/* OpenVAS-Client
 * $Id$
 * Description: sladinstaller startup routine.
 *
 * Authors:
 * Dirk Jagdmann <dirk@jagdmann.de>
 *
 * Copyright:
 * Copyright (C) 2005 by DN-Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * or, at your option, any later version as published by the Free
 * Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <unistd.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "openvas_i18n.h"

/** @TODO Replace by openvas error showing methods (src/gui/err_dlg.c). */
static void ERROR(gchar *str)
{
  GtkWidget*m=gtk_message_dialog_new(GTK_WINDOW(NULL), GTK_DIALOG_MODAL|GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", str);
  gtk_dialog_run(GTK_DIALOG(m));
  gtk_object_destroy(GTK_OBJECT(m));
}

#define SLADINSTALLER "sladinstaller"

void slad_install(GtkWidget *w, gpointer data)
{
  char buf[1024];
  pid_t p;
  FILE *f;

  // check if sladinstall is a working executable
  f = popen (SLADINSTALLER /* RATS: ignore, Comes from trusted source */
             " --ping", "r");
  if(!f)
    {
      ERROR(_("Could not check SLAD installer."));
      return;
    }
  fgets(buf, sizeof(buf), f);
  pclose(f);

#ifndef CYGWIN
  /* compiled with flag -mwindows, sladinstaller
   * does not answer on stdout.
   * Therefore, this test is only performed on
   * non-CYGWIN systems and simply dropped for
   * CYGWIN.
   */
  if(strcmp(buf, "pong\n"))
    {
      ERROR(_("Could not execute SLAD installer."));
      return;
    }
#endif

  // start sladinstall
  p=fork();
  if(p<0)
    {
      ERROR(_("fork error. could not start SLAD install. This is a serious operating system error. Maybe a reboot will fix this."));
    }
  else if(p==0)
    {
      execlp(SLADINSTALLER, SLADINSTALLER, NULL);
      perror("could not run sladinstaller");
      exit(0);
    }
}
