/* OpenVAS-Client
 * $Id$
 * Description: A form for severity_overrides.
 *
 * Author(s):
 * Felix Wolfsteller <felix.wolfsteller@intevation.de>
 *
 * Copyright:
 * Copyright (C) 2009 Greenbone Networks GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * or, at your option, any later version as published by the Free
 * Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _OPENVAS_CLIENT_SEVERITY_OVERRIDE_FROM_H
#define _OPENVAS_CLIENT_SEVERITY_OVERRIDE_FROM_H

#ifdef USE_GTK

#include <gtk/gtk.h>
#include <openvas/base/severity_filter.h> /* for severity_override_t */

/** @brief Possible actions associated with a form */
typedef enum
{
  SOF_VIEW, /**< View, widgets are insensitive to input. */
  SOF_EDIT, // not used yet
  SOF_ADD   /**< Add, widgets are sensitive to input and a add-button is 
             * contained to add the override to the globalfilter. */
} formaction;

/**
 * @brief Structure holding GtkWidget that allow minor modification and
 * @brief inspection of a severity_override.
 */
typedef struct severity_override_form
{
  GtkWidget* vbox;    /**< Overall vbox */
  GtkWidget* table;   /**< Table (in each row left: label,
                       * right: label/combobox/entry) */
  GtkLabel*  name_label; /**< "Name" */
  GtkEntry*  name_entry; /**< Entry showing name of an override. */
  GtkLabel*  reason_label; /**< "Reason" */
  GtkTextView*  reason_textview; /**< Text View showing reason of an override. */
  GtkWidget* host_label;  /**< "Host" */
  GtkWidget* host_value_label;
  GtkWidget* port_label;
  GtkWidget* port_value_label;
  GtkWidget* oid_label;
  GtkWidget* oid_value_label;
  gchar*     severity_from_string; /**< The severity_from of the override that is shown */
  GtkLabel*  map_from_label;
  GtkComboBox* severity_to_combobox;
  formaction action;  /**< The action to perform with this form. */
} severity_override_form_t;

severity_override_form_t*
severity_override_form_from_override (const severity_override_t* override,
                                      formaction action);

void severity_override_form_lock (severity_override_form_t* form);

const severity_override_t*
severity_override_form_to_override (const severity_override_form_t* form);

void
severity_override_form_free (severity_override_form_t* form);

#endif /* USE_GTK */
#endif /* _OPENVAS_CLIENT_SEVERITY_OVERRIDE_FROM_H */
