/* OpenVAS-Client
 * $Id$
 * Description: Header for GUI handling for NVT preference "sshlogins".
 *
 * Author(s):
 * Felix Wolfsteller <felix.wolfsteller@intevation.de>
 *
 * Copyright:
 * Copyright (C) 2009 Greenbone Networks GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * or, at your option, any later version as published by the Free
 * Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _OPENVAS_CLIENT_NVT_PREF_SSHLOGIN_H
#define _OPENVAS_CLIENT_NVT_PREF_SSHLOGIN_H

#ifdef USE_GTK

/** @todo Remove dependence of config.h (some defines influence member variables
 *        of struct context in context.h) */
#include "config.h" /* to have ENABLE_SAVE_TESTS defined before including the
                          context */
#include "context.h"

void nvt_pref_sshlogin_add (GtkWidget* vbox, struct arglist* pref);

void nvt_pref_sshlogin_rebuild_all (struct context* ctx);

void nvt_pref_sshlogin_rebuild_gui (const char* targets, struct context* ctx);

void nvt_pref_sshlogin_update_all_comboboxes (struct context* ctx,
                                              char* newentry);

void text_combobox_set_active_text (GtkWidget* combobox, char*);

gboolean nvt_pref_sshlogin_is_in_use (struct context* ctx, char* login_name);

#endif /* USE_GTK */

#endif /* _OPENVAS_CLIENT_NVT_PREF_SSHLOGIN_H */
