/* OpenVAS Client
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _OPENVAS_REPORT_H
#define _OPENVAS_REPORT_H

#define HOLE_PRESENT    4
#define WARNING_PRESENT 3
#define NOTE_PRESENT    2
#define FALSE_PRESENT   1

#define SAVE_DETAIL_ALL      0
#define SAVE_DETAIL_HIGHMED  1
#define SAVE_DETAIL_HIGHONLY 2

#include "context.h"

gchar* report_get_filename (struct context *);
gchar* report_get_certificates_filename (struct context*);
int is_there_any_hole (struct arglist *);

#ifdef USE_GTK
void report_save (struct context *, int, const char *);
void open_report_selectfile (void);
#endif

#endif /* _OPENVAS_REPORT_H */
