/* OpenVAS Client
 * Copyright (C) 1998 Renaud Deraison
 * Copyright (C) 2004 Greenbone Networks GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _OPENVAS_PREFERENCES_H
#define _OPENVAS_PREFERENCES_H

#include "context.h"

int    preferences_init(struct context *);
void   preferences_save(struct context *);
void   preferences_save_as(struct context *, char *);
struct arglist *prefs_get_pluginset(struct context *, char *, struct openvas_plugin *);
int    preferences_process_filename(struct context *, char *);
int    preferences_generate_new_file(struct context *, const char *);
char * preferences_get_altname(struct context *, const char *);
void * prefs_get_default(struct context *, const char *);
void * prefs_get_value(struct context *, const char *);
#define prefs_get_int(context, name) (GPOINTER_TO_SIZE(prefs_get_value(context, name)))
#define prefs_get_string(context, name) ((const char *)prefs_get_value(context, name))
void   prefs_set_value(struct context *, const char *, void *, int);
void   prefs_set_int(struct context *, const char *, int);
void   prefs_set_string(struct context *, const char *, const char *);
int    prefs_has_options(struct context *);
char * prefs_get_openvashome(void);
gboolean preferences_yes_or_one (struct arglist* argl, char* prefname);
    
#ifdef _WIN32
/* applies to some windows misunderstanding */
#define CANNOT_SET_HOMEVAR "\
There is no personal directory known, where OpenVAS can store the key\n\
and the configuration cache.\n\
\n\
So please set the environment variable OPENVASHOME with explicit path\n\
(eg. C:\\WHAT\\SO\\EVER\\...) to some existing directory.  Make sure that\n\
this variable is set every time you have Windows rebooted.\n\
\n\
Having finshed with the OPENVASHOME variable, close all message boxes\n\
to terminate OpenVAS, then restart OpenVAS, again."

#else /* not  _WIN32 */
#define CANNOT_SET_HOMEVAR "\
Your HOME environment variable might be unset,  or your home directiory\n\
might be unaccessable.  So you need to check/set your HOME variable.\n\
\n\
In case you do not want to change HOME, you can alternatively set the\n\
variable OPENVASHOME, instead (do not forget to \"export OPENVASHOME;\"\n\
after setting it.  OPENVASHOME overwrites the meaning of HOME for this\n\
application."
#endif /* _WIN32 */

#endif
