/* OpenVAS Client
 * Copyright (C) 1998 - 2001 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __BACKEND_H__
#define __BACKEND_H__


#define BE_NUM_FIELDS 7
#define BE_HASH_MAX 4097


#ifdef HAVE_MMAP
struct field {
	char *value;
	int * lines;
	int num_lines;
	int allocated_lines;
	struct field * next;
};

struct hfield {
	struct field * hfield[BE_HASH_MAX];
	};
#endif /* ifdef HAVE_MMAP */




struct backend {
	int fd;
	char * fname;
	int  disposable;
#ifdef HAVE_MMAP	
	char * mmap;
	int    mmap_size;
	int mmap_attempts;
	char ** lines;
	char ** eols;
	struct hfield ** fields;
	int num_lines;
	int cur_line;
#endif
	};


int backend_init(char *);


int backend_insert_report_data(int, char*, char*,char*,char*,char*,char*);
int backend_insert_report_port(int, char*, char*, char*);
int backend_insert_timestamps(int, char*, char*, char*);

int backend_type(int);

int backend_close(int);
int backend_dispose(int);
int backend_empty(int);
int backend_clear_all();

int backend_fd(int);

int backend_import_report(char*);
struct arglist * backend_convert(int);
struct arglist * backend_convert_filter(int, int);

char* priority_idx_to_str (int idx);

#endif
