/* Test 0 of adding a user.
 * $Id$
 * Description: Test OAP CREATE_USER.
 *
 * Authors:
 * Matthew Mundell <matthew.mundell@greenbone.net>
 *
 * Copyright:
 * Copyright (C) 2009 Greenbone Networks GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * or, at your option, any later version as published by the Free
 * Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#define TRACE 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "common.h"
#include "../tracef.h"

#define NAME "xxx"

int
main ()
{
  int socket;
  gnutls_session_t session;
  entity_t entity;

  setup_test ();

  socket = connect_to_manager (&session);
  if (socket == -1) return EXIT_FAILURE;

  if (omp_authenticate_env (&session))
    {
      close_manager_connection (socket, session);
      return EXIT_FAILURE;
    }

  /* Delete the user in case the user already exists. */

  openvas_server_send (&session, "<delete_user name=\"" NAME "\"/>");
  entity = NULL;
  if (read_entity (&session, &entity))
    {
      close_manager_connection (socket, session);
      return EXIT_FAILURE;
    }
  free_entity (entity);

  /* Create the user. */

  if (openvas_server_send (&session,
                           "<create_user>"
                           "<name>" NAME "</name>"
                           "<password>xxx</password>"
                           "</create_user>")
      == -1)
    {
      close_manager_connection (socket, session);
      return EXIT_FAILURE;
    }

  entity = NULL;
  if (read_entity (&session, &entity))
    {
      close_manager_connection (socket, session);
      return EXIT_FAILURE;
    }
  free_entity (entity);

  /* Request the users. */

  if (openvas_server_send (&session, "<get_users/>")
      == -1)
    {
      openvas_server_send (&session, "<delete_user name=\"" NAME "\"/>");
      close_manager_connection (socket, session);
      return EXIT_FAILURE;
    }

  entity = NULL;
  if (read_entity (&session, &entity))
    {
      openvas_server_send (&session, "<delete_user name=\"" NAME "\"/>");
      close_manager_connection (socket, session);
      return EXIT_FAILURE;
    }

  /* Check that the response includes the added user. */

  if (entity_attribute (entity, "status")
      && (strcmp (entity_attribute (entity, "status"), "200") == 0))
    {
      entities_t users = entity->entities;
      entity_t user;

      while ((user = first_entity (users)))
        {
          entity_t name = entity_child (user, "name");
          if (name == NULL) break;
          if (strcmp (entity_text (name), NAME) == 0)
            {
              free_entity (entity);
              openvas_server_send (&session, "<delete_user name=\"" NAME "\"/>");
              close_manager_connection (socket, session);
              return EXIT_SUCCESS;
            }
          users = next_entities (users);
        }
    }

  openvas_server_send (&session, "<delete_user name=\"" NAME "\"/>");
  free_entity (entity);
  close_manager_connection (socket, session);
  return EXIT_FAILURE;
}
