/******************************************************************************
 * $Id: statwin.h,v 1.9 2008/12/09 03:33:06 bdbcat Exp $
 *
 * Project:  OpenCPN
 * Purpose:  Status Window
 * Author:   David Register
 *
 ***************************************************************************
 *   Copyright (C) $YEAR$ by $AUTHOR$   *
 *   $EMAIL$   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************
 *
 * $Log: statwin.h,v $
 * Revision 1.9  2008/12/09 03:33:06  bdbcat
 * Add cm93 support
 *
 * Revision 1.8  2008/08/26 13:49:53  bdbcat
 * Better color scheme support
 *
 * Revision 1.7  2008/03/30 23:24:32  bdbcat
 * *** empty log message ***
 *
 * $Log: statwin.h,v $
 * Revision 1.9  2008/12/09 03:33:06  bdbcat
 * Add cm93 support
 *
 * Revision 1.8  2008/08/26 13:49:53  bdbcat
 * Better color scheme support
 *
 * Revision 1.7  2008/03/30 23:24:32  bdbcat
 * *** empty log message ***
 *
 * Revision 1.6  2008/01/12 06:19:45  bdbcat
 * Update for Mac OSX/Unicode
 *
 * Revision 1.5  2007/06/10 02:37:18  bdbcat
 * Cleanup
 *
 * Revision 1.4  2007/02/06 02:11:47  dsr
 * Cleanup
 *
 * Revision 1.3  2006/10/01 03:24:40  dsr
 * no message
 *
 * Revision 1.2  2006/09/21 01:38:23  dsr
 * Major refactor/cleanup
 *
 *
 */


#ifndef __statwin_H__
#define __statwin_H__

#include "chart1.h"

//----------------------------------------------------------------------------
//   constants
//----------------------------------------------------------------------------
#define KEY_REGIONS_MAX       20

#define NSIGBARS              4

// Class declarations

class MyFrame;
//----------------------------------------------------------------------------
// TStatWin
//----------------------------------------------------------------------------
class TStatWin: public wxWindow
{
public:
      TStatWin(wxFrame *frame);
      ~TStatWin();

      void OnSize(wxSizeEvent& event);
      void OnPaint(wxPaintEvent& event);
      void TextDraw(const wxString& text);

      wxString *pText;
      bool  bTextSet;

DECLARE_EVENT_TABLE()
};


//----------------------------------------------------------------------------
// PianoWin
//----------------------------------------------------------------------------
class PianoWin: public wxWindow
{
public:
      PianoWin(wxFrame *frame);
      ~PianoWin();

      void OnSize(wxSizeEvent& event);
      void OnPaint(wxPaintEvent& event);
      void FormatKeys(void);
      void MouseEvent(wxMouseEvent& event);
      void SetColorScheme(ColorScheme cs);

      int         Size_X, Size_Y, Pos_X, Pos_Y;

      wxRegion    KeyRegion[KEY_REGIONS_MAX];

private:
      int         m_nRegions;
      int         m_index_last;

      wxBrush     *m_pbackBrush;
      wxBrush     *m_ptBrush;
      wxBrush     *m_pvBrush;
      wxBrush     *m_psvBrush;
      wxBrush     *m_puvBrush;
      wxBrush     *m_pslBrush;

      wxBrush     *m_pcBrush;
      wxBrush     *m_pscBrush;

      MyFrame     *gparent;

DECLARE_EVENT_TABLE()
};

#ifdef USE_WIFI_CLIENT
//----------------------------------------------------------------------------
// WiFiStatWin
//----------------------------------------------------------------------------
class WiFiStatWin: public wxWindow
{
    public:
        WiFiStatWin(wxFrame *frame);
        ~WiFiStatWin();

        void OnSize(wxSizeEvent& event);
        void OnPaint(wxPaintEvent& event);
        void TextDraw(const char * text);
        void SetNumberStations(int n);
        void SetStationQuality(int istation, int quality);
        void SetStationSecureFlag(int istation, int flag);
        void SetStationAge(int istation, int age);
        void SetServerStatus(bool stat) { m_bserverstat = stat; }
        void DrawBars(wxDC &dc, int x, int y, int box_width, int box_height, int val, int val_max);
        void SetColorScheme(ColorScheme cs);


        wxBrush     *pqual_hiBrush;
        wxBrush     *psecureBrush;

        wxBrush     *pqual_hiNewBrush;
        wxBrush     *psecureNewBrush;

        wxBrush     *pbackBrush;

        int         m_nstations;
        int         m_quality[NSIGBARS];
        int         m_secure[NSIGBARS];
        int         m_age[NSIGBARS];
        bool        m_bserverstat;

        DECLARE_EVENT_TABLE()
};
#endif


//----------------------------------------------------------------------------
// StatWin
//----------------------------------------------------------------------------
class StatWin: public wxWindow
{
public:
      StatWin(wxFrame *frame);
      ~StatWin();
      void OnSize(wxSizeEvent& event);
      void OnPaint(wxPaintEvent& event);
      void MouseEvent(wxMouseEvent& event);
      int  GetFontHeight();
      int  GetRows(){ return(m_rows);}
      void SetColorScheme(ColorScheme cs);

      void FormatStat(void);

      int         Size_X, Size_Y, Pos_X, Pos_Y;

      PianoWin    *pPiano;
      TStatWin    *pTStat1;
      TStatWin    *pTStat2;
#ifdef USE_WIFI_CLIENT
      WiFiStatWin *pWiFi;
#endif

private:
      wxBrush     *m_pbackBrush;
      int         m_rows;


DECLARE_EVENT_TABLE()
};

#endif
