#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <stdbool.h>
#include <time.h>

#include "bits.h"
#include "utils.h"
#include "a5.h"

static const uint8_t key[] = { 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef };
static const uint32_t fn = 123456;
static const uint8_t dl[] = {
	/* A5/0 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	/* A5/1 */
	0xcb, 0xa2, 0x55, 0x76, 0x17, 0x5d, 0x3b, 0x1c,
	0x7b, 0x2f, 0x29, 0xa8, 0xc1, 0xb6, 0x00,

	/* A5/2 */
	0x45, 0x9c, 0x88, 0xc3, 0x82, 0xb7, 0xff, 0xb3,
	0x98, 0xd2, 0xf9, 0x6e, 0x0f, 0x14, 0x80,
};
static const uint8_t ul[] = {
	/* A5/0 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	/* A5/1 */
	0xd9, 0x03, 0x5e, 0x0f, 0x2a, 0xec, 0x13, 0x9a,
	0x05, 0xd4, 0xa8, 0x7b, 0xb1, 0x64, 0x80,

	/* A5/2 */
	0xf0, 0x3a, 0xac, 0xde, 0xe3, 0x5b, 0x5e, 0x65,
	0x80, 0xba, 0xab, 0xc0, 0x59, 0x26, 0x40,
};

void test_a5(int n, char * kc, uint32_t count, char * block1, char * block2) {
    ubit_t out[114];
    int k = (n == 4) ? 16 : 8;
	int ntrials;
	float t;
	int i;
    uint8_t key[k];
    osmo_hexparse(kc, key, k);
	ntrials = 10000;

	t = clock();
	for (i = 0; i < ntrials; i++) {
		osmo_a5(n, key, count, out, NULL);
	}
	t = (clock() - t) / (CLOCKS_PER_SEC * (float)ntrials);
	printf("osmo_a5 DL takes %g seconds per iteration\n", t);

	t = clock();
	for (i = 0; i < ntrials; i++) {
		osmo_a5(n, key, count, NULL, out);
	}
	t = (clock() - t) / (CLOCKS_PER_SEC * (float)ntrials);
	printf("osmo_a5 UL takes %g seconds per iteration\n", t);

}

int main(int argc, char **argv)
{
	test_a5(3, "2BD6459F82C5BC00", 0x24F20F, "889EEAAF9ED1BA1ABBD8436232E440", "5CA3406AA244CF69CF047AADA2DF40");

	return 0;
}
