#
#
#            Nimrod's Runtime Library
#        (c) Copyright 2010 Andreas Rumpf
#
#    See the file "copying.txt", included in this
#    distribution, for details about the copyright.
#

## Define ``winUnicode`` before importing this module for the
## Unicode version.

{.deadCodeElim: on.}

type
  WideChar* = uint16
  PWideChar* = ptr uint16

type  # WinNT.h -- Defines the 32-Bit Windows types and constants
  SHORT* = int16
  LONG* = int32
  # UNICODE (Wide Character) types
  PWCHAR* = PWideChar
  LPWCH* = PWideChar
  PWCH* = PWideChar
  LPCWCH* = PWideChar
  PCWCH* = PWideChar
  NWPSTR* = PWideChar
  LPWSTR* = PWideChar
  LPCWSTR* = PWideChar
  PCWSTR* = PWideChar
  # ANSI (Multi-byte Character) types
  LPCH* = cstring
  PCH* = cstring
  LPCCH* = cstring
  PCCH* = cstring
  LPSTR* = cstring
  PSTR* = cstring
  LPCSTR* = cstring
  PCSTR* = cstring

type  # BaseTsd.h -- Type definitions for the basic sized types
      # Give here only the bare minimum, to be expanded as needs arise
  LONG32* = int32
  ULONG32* = int32
  DWORD32* = int32
  LONG64* = int64
  ULONG64* = int64
  DWORD64* = int64
  PDWORD64* = ptr DWORD64
  # int32 on Win32, int64 on Win64
  INT_PTR* = TAddress
  UINT_PTR* = TAddress
  LONG_PTR* = TAddress
  ULONG_PTR* = TAddress
  SIZE_T* = TAddress
  SSIZE_T* = TAddress
  DWORD_PTR* = TAddress
  # Thread affinity
  KAFFINITY* = TAddress
  PKAFFINITY* = ptr KAFFINITY

type  # WinDef.h -- Basic Windows Type Definitions
  # BaseTypes
  ULONG* = int
  PULONG* = ptr int
  USHORT* = int16
  PUSHORT* = ptr int16
  UCHAR* = int8
  PUCHAR* = ptr int8
  PSZ* = cstring

  DWORD* = int32
  WINBOOL* = int32
  WORD* = int16
  # FLOAT* = float
  PFLOAT* = ptr FLOAT
  PWINBOOL* = ptr WINBOOL
  LPWINBOOL* = ptr WINBOOL
  PBYTE* = ptr int8
  LPBYTE* = ptr int8
  PINT* = ptr int32
  LPINT* = ptr int32
  PWORD* = ptr int16
  LPWORD* = ptr int16
  LPLONG* = ptr int32
  PDWORD* = ptr DWORD
  LPDWORD* = ptr DWORD
  LPVOID* = pointer
  LPCVOID* = pointer

  # INT* = int  # Cannot work and not necessary anyway
  PUINT* = ptr int

  WPARAM* = LONG_PTR
  LPARAM* = LONG_PTR
  LRESULT* = LONG_PTR

  ATOM* = int16
  TAtom* = ATOM
  HANDLE* = int
  THandle* = HANDLE
  PHANDLE* = ptr HANDLE
  LPHANDLE* = ptr HANDLE
  HWND* = HANDLE
  HHOOK* = HANDLE
  HEVENT* = HANDLE
  HGLOBAL* = HANDLE
  HLOCAL* = HANDLE
  HGDIOBJ* = HANDLE
  HKEY* = HANDLE
  PHKEY* = ptr HKEY
  HACCEL* = HANDLE
  HBITMAP* = HANDLE
  HBRUSH* = HANDLE
  HCOLORSPACE* = HANDLE
  HDC* = HANDLE
  HGLRC* = HANDLE
  HDESK* = HANDLE
  HENHMETAFILE* = HANDLE
  HFONT* = HANDLE
  HICON* = HANDLE
  HMETAFILE* = HANDLE
  HINST* = HANDLE  # Not HINSTANCE, else it has problems with the var HInstance
  HMODULE* = HANDLE
  HPALETTE* = HANDLE
  HPEN* = HANDLE
  HRGN* = HANDLE
  HRSRC* = HANDLE
  HTASK* = HANDLE
  HWINSTA* = HANDLE
  HKL* = HANDLE
  HMONITOR* = HANDLE
  HWINEVENTHOOK* = HANDLE
  HUMPD* = HANDLE

  HFILE* = HANDLE
  HCURSOR* = HANDLE # = HICON
  COLORREF* = int
  LPCOLORREF* = ptr COLORREF

  POINT* {.final, pure.} = object
    x*: LONG
    y*: LONG
  PPOINT* = ptr POINT
  LPPOINT* = ptr POINT
  POINTL* {.final, pure.} = object
    x*: LONG
    y*: LONG
  PPOINTL* = ptr POINTL

  TPOINT* = POINT
  TPOINTL* = POINTL

  RECT* {.final, pure.} = object
    TopLeft*, BottomRight*: TPoint
  PRECT* = ptr RECT
  LPRECT* = ptr RECT

  RECTL* {.final, pure.} = object
    left*: LONG
    top*: LONG
    right*: LONG
    bottom*: LONG
  PRECTL* = ptr RECTL

  SIZE* {.final, pure.} = object
    cx*: LONG
    cy*: LONG
  PSIZE* = ptr SIZE
  LPSIZE* = ptr SIZE
  SIZEL* = SIZE
  PSIZEL* = ptr SIZE
  LPSIZEL* = ptr SIZE

  POINTS* {.final, pure.} = object
    x*: SHORT
    y*: SHORT
  PPOINTS* = ptr POINTS

  TRECT* = RECT
  TRECTL* = RECTL
  TSIZE* = SIZE
  TSIZEL* = SIZE
  TPOINTS* = POINTS

  FILETIME* {.final, pure.} = object
    dwLowDateTime*: DWORD
    dwHighDateTime*: DWORD
  PFILETIME* = ptr FILETIME
  LPFILETIME* = ptr FILETIME

  TFILETIME* = FILETIME

const
  MAX_PATH* = 260
  HFILE_ERROR* = HFILE(-1)

  # mode selections for the device mode function
  # DocumentProperties
  DM_UPDATE* = 1
  DM_COPY* = 2
  DM_PROMPT* = 4
  DM_MODIFY* = 8

  DM_IN_BUFFER* = DM_MODIFY
  DM_IN_PROMPT* = DM_PROMPT
  DM_OUT_BUFFER* = DM_COPY
  DM_OUT_DEFAULT* = DM_UPDATE

  # device capabilities indices
  DC_FIELDS* = 1
  DC_PAPERS* = 2
  DC_PAPERSIZE* = 3
  DC_MINEXTENT* = 4
  DC_MAXEXTENT* = 5
  DC_BINS* = 6
  DC_DUPLEX* = 7
  DC_SIZE* = 8
  DC_EXTRA* = 9
  DC_VERSION* = 10
  DC_DRIVER* = 11
  DC_BINNAMES* = 12
  DC_ENUMRESOLUTIONS* = 13
  DC_FILEDEPENDENCIES* = 14
  DC_TRUETYPE* = 15
  DC_PAPERNAMES* = 16
  DC_ORIENTATION* = 17
  DC_COPIES* = 18

  DC_BINADJUST* = 19
  DC_EMF_COMPLIANT* = 20
  DC_DATATYPE_PRODUCED* = 21

type
  WORDBOOL* = int16  # XXX: not a bool
  CALTYPE* = int
  CALID* = int
  CCHAR* = char
  TCOLORREF* = int
  WINT* = int32
  PINTEGER* = ptr int32
  PBOOL* = ptr WINBOOL
  LONGLONG* = int64
  PLONGLONG* = ptr LONGLONG
  LPLONGLONG* = ptr LONGLONG
  ULONGLONG* = int64          # used in AMD64 CONTEXT
  PULONGLONG* = ptr ULONGLONG #
  DWORDLONG* = int64          # was unsigned long
  PDWORDLONG* = ptr DWORDLONG
  HRESULT* = int
  PHRESULT* = ptr HRESULT
  HCONV* = HANDLE
  HCONVLIST* = HANDLE
  HDBC* = HANDLE
  HDDEDATA* = HANDLE
  HDROP* = HANDLE
  HDWP* = HANDLE
  HENV* = HANDLE
  HIMAGELIST* = HANDLE
  HMENU* = HANDLE
  HRASCONN* = HANDLE
  HSTMT* = HANDLE
  HSTR* = HANDLE
  HSZ* = HANDLE
  LANGID* = int16
  LCID* = DWORD
  LCTYPE* = DWORD
  LP* = ptr int16
  LPBOOL* = ptr WINBOOL

when defined(winUnicode):
  type
    LPCTSTR* = PWideChar
else:
  type
    LPCTSTR* = cstring
type
  LPPCSTR* = ptr LPCSTR
  LPPCTSTR* = ptr LPCTSTR
  LPPCWSTR* = ptr LPCWSTR

when defined(winUnicode):
  type
    LPTCH* = PWideChar
    LPTSTR* = PWideChar
else:
  type
    LPTCH* = cstring
    LPTSTR* = cstring
type
  PBOOLEAN* = ptr int8
  PLONG* = ptr int32
  PSHORT* = ptr SHORT

when defined(winUnicode):
  type
    PTBYTE* = ptr uint16
    PTCH* = PWideChar
    PTCHAR* = PWideChar
    PTSTR* = PWideChar
else:
  type
    PTBYTE* = ptr byte
    PTCH* = cstring
    PTCHAR* = cstring
    PTSTR* = cstring
type
  PVOID* = pointer
  RETCODE* = SHORT
  SC_HANDLE* = HANDLE
  SC_LOCK* = LPVOID
  LPSC_HANDLE* = ptr SC_HANDLE
  SERVICE_STATUS_HANDLE* = DWORD

when defined(winUnicode):
  type
    TBYTE* = uint16
    TCHAR* = widechar
    BCHAR* = int16
else:
  type
    TBYTE* = uint8
    TCHAR* = char
    BCHAR* = int8
type
  WCHAR* = WideChar
  PLPSTR* = ptr LPSTR
  PLPWStr* = ptr LPWStr
  ACL_INFORMATION_CLASS* = enum
    AclRevisionInformation = 1, AclSizeInformation
  MEDIA_TYPE* = enum
    Unknown, F5_1Pt2_512, F3_1Pt44_512, F3_2Pt88_512, F3_20Pt8_512, F3_720_512,
    F5_360_512, F5_320_512, F5_320_1024, F5_180_512, F5_160_512, RemovableMedia,
    FixedMedia

const
  RASCS_DONE* = 0x00002000
  RASCS_PAUSED* = 0x00001000

type
  RASCONNSTATE* = enum
    RASCS_OpenPort = 0, RASCS_PortOpened, RASCS_ConnectDevice,
    RASCS_DeviceConnected, RASCS_AllDevicesConnected, RASCS_Authenticate,
    RASCS_AuthNotify, RASCS_AuthRetry, RASCS_AuthCallback,
    RASCS_AuthChangePassword, RASCS_AuthProject, RASCS_AuthLinkSpeed,
    RASCS_AuthAck, RASCS_ReAuthenticate, RASCS_Authenticated,
    RASCS_PrepareForCallback, RASCS_WaitForModemReset, RASCS_WaitForCallback,
    RASCS_Projected, RASCS_StartAuthentication, RASCS_CallbackComplete,
    RASCS_LogonNetwork, RASCS_Interactive = RASCS_PAUSED,
    RASCS_RetryAuthentication, RASCS_CallbackSetByCaller, RASCS_PasswordExpired,
    RASCS_Connected = RASCS_DONE, RASCS_Disconnected
  RASPROJECTION* = enum
    RASP_PppIp = 0x00008021, RASP_PppIpx = 0x0000802B, RASP_PppNbf = 0x0000803F,
    RASP_Amb = 0x00010000
  SECURITY_IMPERSONATION_LEVEL* = enum


    SecurityAnonymous, SecurityIdentification, SecurityImpersonation,
    SecurityDelegation
  SID_NAME_USE* = enum
    SidTypeUser = 1, SidTypeGroup, SidTypeDomain, SidTypeAlias,
    SidTypeWellKnownGroup, SidTypeDeletedAccount, SidTypeInvalid, SidTypeUnknown
  PSID_NAME_USE* = ptr SID_NAME_USE
  TOKEN_INFORMATION_CLASS* = enum
    TokenUser = 1, TokenGroups, TokenPrivileges, TokenOwner, TokenPrimaryGroup,
    TokenDefaultDacl, TokenSource, TokenType, TokenImpersonationLevel,
    TokenStatistics
  TTOKEN_TYPE* = enum
    TokenPrimary = 1, TokenImpersonation
  MakeIntResourceA* = cstring
  MakeIntResourceW* = PWideChar
  MakeIntResource* = MakeIntResourceA

#
#    Definitions for callback procedures
#
type
  BFFCALLBACK* = proc (para1: HWND, para2: UINT, para3: LPARAM, para4: LPARAM): int32{.
      stdcall.}
  LPCCHOOKPROC* = proc (para1: HWND, para2: UINT, para3: WPARAM, para4: LPARAM): UINT{.
      stdcall.}
  LPCFHOOKPROC* = proc (para1: HWND, para2: UINT, para3: WPARAM, para4: LPARAM): UINT{.
      stdcall.}
  PTHREAD_START_ROUTINE* = Pointer
  LPTHREAD_START_ROUTINE* = PTHREAD_START_ROUTINE
  EDITSTREAMCALLBACK* = proc (para1: DWORD, para2: LPBYTE, para3: LONG,
                              para4: LONG): DWORD{.stdcall.}
  LPFRHOOKPROC* = proc (para1: HWND, para2: UINT, para3: WPARAM, para4: LPARAM): UINT{.
      stdcall.}
  LPOFNHOOKPROC* = proc (para1: HWND, para2: UINT, para3: WPARAM, para4: LPARAM): UINT{.
      stdcall.}
  LPPRINTHOOKPROC* = proc (para1: HWND, para2: UINT, para3: WPARAM,
                           para4: LPARAM): UINT{.stdcall.}
  LPSETUPHOOKPROC* = proc (para1: HWND, para2: UINT, para3: WPARAM,
                           para4: LPARAM): UINT{.stdcall.}
  DLGPROC* = proc (para1: HWND, para2: UINT, para3: WPARAM, para4: LPARAM): LRESULT{.
      stdcall.}
  PFNPROPSHEETCALLBACK* = proc (para1: HWND, para2: UINT, para3: LPARAM): int32{.
      stdcall.}
  LPSERVICE_MAIN_FUNCTION* = proc (para1: DWORD, para2: LPTSTR){.stdcall.}
  PFNTVCOMPARE* = proc (para1: LPARAM, para2: LPARAM, para3: LPARAM): int32{.
      stdcall.}
  WNDPROC* = proc (para1: HWND, para2: UINT, para3: WPARAM, para4: LPARAM): LRESULT{.
      stdcall.}
  FARPROC* = pointer
  TFarProc* = FARPROC
  TProc* = pointer
  ENUMRESTYPEPROC* = proc (para1: HANDLE, para2: LPTSTR, para3: LONG): WINBOOL{.
      stdcall.}
  ENUMRESNAMEPROC* = proc (para1: HANDLE, para2: LPCTSTR, para3: LPTSTR,
                           para4: LONG): WINBOOL{.stdcall.}
  ENUMRESLANGPROC* = proc (para1: HANDLE, para2: LPCTSTR, para3: LPCTSTR,
                           para4: int16, para5: LONG): WINBOOL{.stdcall.}
  DESKTOPENUMPROC* = FARPROC
  ENUMWINDOWSPROC* = proc (para1: HWND, para2: LPARAM): WINBOOL{.stdcall.}
  ENUMWINDOWSTATIONPROC* = proc (para1: LPTSTR, para2: LPARAM): WINBOOL{.stdcall.}
  SENDASYNCPROC* = proc (para1: HWND, para2: UINT, para3: DWORD, para4: LRESULT){.
      stdcall.}
  TIMERPROC* = proc (para1: HWND, para2: UINT, para3: UINT, para4: DWORD){.
      stdcall.}
  GRAYSTRINGPROC* = FARPROC
  DRAWSTATEPROC* = proc (para1: HDC, para2: LPARAM, para3: WPARAM, para4: int32,
                         para5: int32): WINBOOL{.stdcall.}
  PROPENUMPROCEX* = proc (para1: HWND, para2: LPCTSTR, para3: HANDLE,
                          para4: DWORD): WINBOOL{.stdcall.}
  PROPENUMPROC* = proc (para1: HWND, para2: LPCTSTR, para3: HANDLE): WINBOOL{.
      stdcall.}
  HOOKPROC* = proc (para1: int32, para2: WPARAM, para3: LPARAM): LRESULT{.
      stdcall.}
  ENUMOBJECTSPROC* = proc (para1: LPVOID, para2: LPARAM){.stdcall.}
  LINEDDAPROC* = proc (para1: int32, para2: int32, para3: LPARAM){.stdcall.}
  TABORTPROC* = proc (para1: HDC, para2: int32): WINBOOL{.stdcall.}
  LPPAGEPAINTHOOK* = proc (para1: HWND, para2: UINT, para3: WPARAM,
                           para4: LPARAM): UINT{.stdcall.}
  LPPAGESETUPHOOK* = proc (para1: HWND, para2: UINT, para3: WPARAM,
                           para4: LPARAM): UINT{.stdcall.}
  ICMENUMPROC* = proc (para1: LPTSTR, para2: LPARAM): int32{.stdcall.}
  EDITWORDBREAKPROCEX* = proc (para1: cstring, para2: LONG, para3: int8,
                               para4: WINT): LONG{.stdcall.}
  PFNLVCOMPARE* = proc (para1: LPARAM, para2: LPARAM, para3: LPARAM): int32{.
      stdcall.}
  LOCALE_ENUMPROC* = proc (para1: LPTSTR): WINBOOL{.stdcall.}
  CODEPAGE_ENUMPROC* = proc (para1: LPTSTR): WINBOOL{.stdcall.}
  DATEFMT_ENUMPROC* = proc (para1: LPTSTR): WINBOOL{.stdcall.}
  TIMEFMT_ENUMPROC* = proc (para1: LPTSTR): WINBOOL{.stdcall.}
  CALINFO_ENUMPROC* = proc (para1: LPTSTR): WINBOOL{.stdcall.}
  PHANDLER_ROUTINE* = proc (para1: DWORD): WINBOOL{.stdcall.}
  LPHANDLER_FUNCTION* = proc (para1: DWORD): WINBOOL{.stdcall.}
  PFNGETPROFILEPATH* = proc (para1: LPCTSTR, para2: LPSTR, para3: UINT): UINT{.
      stdcall.}
  PFNRECONCILEPROFILE* = proc (para1: LPCTSTR, para2: LPCTSTR, para3: DWORD): UINT{.
      stdcall.}
  PFNPROCESSPOLICIES* = proc (para1: HWND, para2: LPCTSTR, para3: LPCTSTR,
                              para4: LPCTSTR, para5: DWORD): WINBOOL{.stdcall.}

const
  SE_CREATE_TOKEN_NAME* = "SeCreateTokenPrivilege"
  SE_ASSIGNPRIMARYTOKEN_NAME* = "SeAssignPrimaryTokenPrivilege"
  SE_LOCK_MEMORY_NAME* = "SeLockMemoryPrivilege"
  SE_INCREASE_QUOTA_NAME* = "SeIncreaseQuotaPrivilege"
  SE_UNSOLICITED_INPUT_NAME* = "SeUnsolicitedInputPrivilege"
  SE_MACHINE_ACCOUNT_NAME* = "SeMachineAccountPrivilege"
  SE_TCB_NAME* = "SeTcbPrivilege"
  SE_SECURITY_NAME* = "SeSecurityPrivilege"
  SE_TAKE_OWNERSHIP_NAME* = "SeTakeOwnershipPrivilege"
  SE_LOAD_DRIVER_NAME* = "SeLoadDriverPrivilege"
  SE_SYSTEM_PROFILE_NAME* = "SeSystemProfilePrivilege"
  SE_SYSTEMTIME_NAME* = "SeSystemtimePrivilege"
  SE_PROF_SINGLE_PROCESS_NAME* = "SeProfileSingleProcessPrivilege"
  SE_INC_BASE_PRIORITY_NAME* = "SeIncreaseBasePriorityPrivilege"
  SE_CREATE_PAGEFILE_NAME* = "SeCreatePagefilePrivilege"
  SE_CREATE_PERMANENT_NAME* = "SeCreatePermanentPrivilege"
  SE_BACKUP_NAME* = "SeBackupPrivilege"
  SE_RESTORE_NAME* = "SeRestorePrivilege"
  SE_SHUTDOWN_NAME* = "SeShutdownPrivilege"
  SE_DEBUG_NAME* = "SeDebugPrivilege"
  SE_AUDIT_NAME* = "SeAuditPrivilege"
  SE_SYSTEM_ENVIRONMENT_NAME* = "SeSystemEnvironmentPrivilege"
  SE_CHANGE_NOTIFY_NAME* = "SeChangeNotifyPrivilege"
  SE_REMOTE_SHUTDOWN_NAME* = "SeRemoteShutdownPrivilege"
  SERVICES_ACTIVE_DATABASEW* = "ServicesActive"
  SERVICES_FAILED_DATABASEW* = "ServicesFailed"
  SERVICES_ACTIVE_DATABASEA* = "ServicesActive"
  SERVICES_FAILED_DATABASEA* = "ServicesFailed"
  SC_GROUP_IDENTIFIERW* = "+"
  SC_GROUP_IDENTIFIERA* = "+"

when defined(winUnicode):
  const
    SERVICES_ACTIVE_DATABASE* = SERVICES_ACTIVE_DATABASEW
    SERVICES_FAILED_DATABASE* = SERVICES_FAILED_DATABASEW
    SC_GROUP_IDENTIFIER* = SC_GROUP_IDENTIFIERW
else:
  const
    SERVICES_ACTIVE_DATABASE* = SERVICES_ACTIVE_DATABASEA
    SERVICES_FAILED_DATABASE* = SERVICES_FAILED_DATABASEA
    SC_GROUP_IDENTIFIER* = SC_GROUP_IDENTIFIERA
type
  PFNCALLBACK* = proc (para1, para2: UINT, para3: HCONV, para4, para5: HSZ,
                       para6: HDDEDATA, para7, para8: DWORD): HDDEData{.stdcall.}
  CALLB* = PFNCALLBACK
  SECURITY_CONTEXT_TRACKING_MODE* = WINBOOL
  # End of stuff from ddeml.h in old Cygnus headers

  WNDENUMPROC* = FARPROC
  ENHMFENUMPROC* = FARPROC
  CCSTYLE* = DWORD
  PCCSTYLE* = ptr CCSTYLE
  LPCCSTYLE* = ptr CCSTYLE
  CCSTYLEFLAGA* = DWORD
  PCCSTYLEFLAGA* = ptr CCSTYLEFLAGA
  LPCCSTYLEFLAGA* = ptr CCSTYLEFLAGA

const
  LZERROR_UNKNOWNALG* = -8
  LZERROR_BADVALUE* = -7
  LZERROR_GLOBLOCK* = -6
  LZERROR_GLOBALLOC* = -5
  LZERROR_WRITE* = -4
  LZERROR_READ* = -3
  LZERROR_BADOUTHANDLE* = -2
  LZERROR_BADINHANDLE* = -1
  NO_ERROR* = 0
  ERROR_SUCCESS* = 0
  ERROR_INVALID_FUNCTION* = 1
  ERROR_FILE_NOT_FOUND* = 2
  ERROR_PATH_NOT_FOUND* = 3
  ERROR_TOO_MANY_OPEN_FILES* = 4
  ERROR_ACCESS_DENIED* = 5
  ERROR_INVALID_HANDLE* = 6
  ERROR_ARENA_TRASHED* = 7
  ERROR_NOT_ENOUGH_MEMORY* = 8
  ERROR_INVALID_BLOCK* = 9
  ERROR_BAD_ENVIRONMENT* = 10
  ERROR_BAD_FORMAT* = 11
  ERROR_INVALID_ACCESS* = 12
  ERROR_INVALID_DATA* = 13
  ERROR_OUTOFMEMORY* = 14
  ERROR_INVALID_DRIVE* = 15
  ERROR_CURRENT_DIRECTORY* = 16
  ERROR_NOT_SAME_DEVICE* = 17
  ERROR_NO_MORE_FILES* = 18
  ERROR_WRITE_PROTECT* = 19
  ERROR_BAD_UNIT* = 20
  ERROR_NOT_READY* = 21
  ERROR_BAD_COMMAND* = 22
  ERROR_CRC* = 23
  ERROR_BAD_LENGTH* = 24
  ERROR_SEEK* = 25
  ERROR_NOT_DOS_DISK* = 26
  ERROR_SECTOR_NOT_FOUND* = 27
  ERROR_OUT_OF_PAPER* = 28
  ERROR_WRITE_FAULT* = 29
  ERROR_READ_FAULT* = 30
  ERROR_GEN_FAILURE* = 31
  ERROR_SHARING_VIOLATION* = 32
  ERROR_LOCK_VIOLATION* = 33
  ERROR_WRONG_DISK* = 34
  ERROR_SHARING_BUFFER_EXCEEDED* = 36
  ERROR_HANDLE_EOF* = 38
  ERROR_HANDLE_DISK_FULL* = 39
  ERROR_NOT_SUPPORTED* = 50
  ERROR_REM_NOT_LIST* = 51
  ERROR_DUP_NAME* = 52
  ERROR_BAD_NETPATH* = 53
  ERROR_NETWORK_BUSY* = 54
  ERROR_DEV_NOT_EXIST* = 55
  ERROR_TOO_MANY_CMDS* = 56
  ERROR_ADAP_HDW_ERR* = 57
  ERROR_BAD_NET_RESP* = 58
  ERROR_UNEXP_NET_ERR* = 59
  ERROR_BAD_REM_ADAP* = 60
  ERROR_PRINTQ_FULL* = 61
  ERROR_NO_SPOOL_SPACE* = 62
  ERROR_PRINT_CANCELLED* = 63
  ERROR_NETNAME_DELETED* = 64
  ERROR_NETWORK_ACCESS_DENIED* = 65
  ERROR_BAD_DEV_TYPE* = 66
  ERROR_BAD_NET_NAME* = 67
  ERROR_TOO_MANY_NAMES* = 68
  ERROR_TOO_MANY_SESS* = 69
  ERROR_SHARING_PAUSED* = 70
  ERROR_REQ_NOT_ACCEP* = 71
  ERROR_REDIR_PAUSED* = 72
  ERROR_FILE_EXISTS* = 80
  ERROR_CANNOT_MAKE* = 82
  ERROR_FAIL_I24* = 83
  ERROR_OUT_OF_STRUCTURES* = 84
  ERROR_ALREADY_ASSIGNED* = 85
  ERROR_INVALID_PASSWORD* = 86
  ERROR_INVALID_PARAMETER* = 87
  ERROR_NET_WRITE_FAULT* = 88
  ERROR_NO_PROC_SLOTS* = 89
  ERROR_TOO_MANY_SEMAPHORES* = 100
  ERROR_EXCL_SEM_ALREADY_OWNED* = 101
  ERROR_SEM_IS_SET* = 102
  ERROR_TOO_MANY_SEM_REQUESTS* = 103
  ERROR_INVALID_AT_INTERRUPT_TIME* = 104
  ERROR_SEM_OWNER_DIED* = 105
  ERROR_SEM_USER_LIMIT* = 106
  ERROR_DISK_CHANGE* = 107
  ERROR_DRIVE_LOCKED* = 108
  ERROR_BROKEN_PIPE* = 109
  ERROR_OPEN_FAILED* = 110
  ERROR_BUFFER_OVERFLOW* = 111
  ERROR_DISK_FULL* = 112
  ERROR_NO_MORE_SEARCH_HANDLES* = 113
  ERROR_INVALID_TARGET_HANDLE* = 114
  ERROR_INVALID_CATEGORY* = 117
  ERROR_INVALID_VERIFY_SWITCH* = 118
  ERROR_BAD_DRIVER_LEVEL* = 119
  ERROR_CALL_NOT_IMPLEMENTED* = 120
  ERROR_SEM_TIMEOUT* = 121
  ERROR_INSUFFICIENT_BUFFER* = 122
  ERROR_INVALID_NAME* = 123
  ERROR_INVALID_LEVEL* = 124
  ERROR_NO_VOLUME_LABEL* = 125
  ERROR_MOD_NOT_FOUND* = 126
  ERROR_PROC_NOT_FOUND* = 127
  ERROR_WAIT_NO_CHILDREN* = 128
  ERROR_CHILD_NOT_COMPLETE* = 129
  ERROR_DIRECT_ACCESS_HANDLE* = 130
  ERROR_NEGATIVE_SEEK* = 131
  ERROR_SEEK_ON_DEVICE* = 132
  ERROR_IS_JOIN_TARGET* = 133
  ERROR_IS_JOINED* = 134
  ERROR_IS_SUBSTED* = 135
  ERROR_NOT_JOINED* = 136
  ERROR_NOT_SUBSTED* = 137
  ERROR_JOIN_TO_JOIN* = 138
  ERROR_SUBST_TO_SUBST* = 139
  ERROR_JOIN_TO_SUBST* = 140
  ERROR_SUBST_TO_JOIN* = 141
  ERROR_BUSY_DRIVE* = 142
  ERROR_SAME_DRIVE* = 143
  ERROR_DIR_NOT_ROOT* = 144
  ERROR_DIR_NOT_EMPTY* = 145
  ERROR_IS_SUBST_PATH* = 146
  ERROR_IS_JOIN_PATH* = 147
  ERROR_PATH_BUSY* = 148
  ERROR_IS_SUBST_TARGET* = 149
  ERROR_SYSTEM_TRACE* = 150
  ERROR_INVALID_EVENT_COUNT* = 151
  ERROR_TOO_MANY_MUXWAITERS* = 152
  ERROR_INVALID_LIST_FORMAT* = 153
  ERROR_LABEL_TOO_LONG* = 154
  ERROR_TOO_MANY_TCBS* = 155
  ERROR_SIGNAL_REFUSED* = 156
  ERROR_DISCARDED* = 157
  ERROR_NOT_LOCKED* = 158
  ERROR_BAD_THREADID_ADDR* = 159
  ERROR_BAD_ARGUMENTS* = 160
  ERROR_BAD_PATHNAME* = 161
  ERROR_SIGNAL_PENDING* = 162
  ERROR_MAX_THRDS_REACHED* = 164
  ERROR_LOCK_FAILED* = 167
  ERROR_BUSY* = 170
  ERROR_CANCEL_VIOLATION* = 173
  ERROR_ATOMIC_LOCKS_NOT_SUPPORTED* = 174
  ERROR_INVALID_SEGMENT_NUMBER* = 180
  ERROR_INVALID_ORDINAL* = 182
  ERROR_ALREADY_EXISTS* = 183
  ERROR_INVALID_FLAG_NUMBER* = 186
  ERROR_SEM_NOT_FOUND* = 187
  ERROR_INVALID_STARTING_CODESEG* = 188
  ERROR_INVALID_STACKSEG* = 189
  ERROR_INVALID_MODULETYPE* = 190
  ERROR_INVALID_EXE_SIGNATURE* = 191
  ERROR_EXE_MARKED_INVALID* = 192
  ERROR_BAD_EXE_FORMAT* = 193
  ERROR_ITERATED_DATA_EXCEEDS_64k* = 194
  ERROR_INVALID_MINALLOCSIZE* = 195
  ERROR_DYNLINK_FROM_INVALID_RING* = 196
  ERROR_IOPL_NOT_ENABLED* = 197
  ERROR_INVALID_SEGDPL* = 198
  ERROR_AUTODATASEG_EXCEEDS_64k* = 199
  ERROR_RING2SEG_MUST_BE_MOVABLE* = 200
  ERROR_RELOC_CHAIN_XEEDS_SEGLIM* = 201
  ERROR_INFLOOP_IN_RELOC_CHAIN* = 202
  ERROR_ENVVAR_NOT_FOUND* = 203
  ERROR_NO_SIGNAL_SENT* = 205
  ERROR_FILENAME_EXCED_RANGE* = 206
  ERROR_RING2_STACK_IN_USE* = 207
  ERROR_META_EXPANSION_TOO_LONG* = 208
  ERROR_INVALID_SIGNAL_NUMBER* = 209
  ERROR_THREAD_1_INACTIVE* = 210
  ERROR_LOCKED* = 212
  ERROR_TOO_MANY_MODULES* = 214
  ERROR_NESTING_NOT_ALLOWED* = 215
  ERROR_BAD_PIPE* = 230
  ERROR_PIPE_BUSY* = 231
  ERROR_NO_DATA* = 232
  ERROR_PIPE_NOT_CONNECTED* = 233
  ERROR_MORE_DATA* = 234
  ERROR_VC_DISCONNECTED* = 240
  ERROR_INVALID_EA_NAME* = 254
  ERROR_EA_LIST_INCONSISTENT* = 255
  ERROR_NO_MORE_ITEMS* = 259
  ERROR_CANNOT_COPY* = 266
  ERROR_DIRECTORY* = 267
  ERROR_EAS_DIDNT_FIT* = 275
  ERROR_EA_FILE_CORRUPT* = 276
  ERROR_EA_TABLE_FULL* = 277
  ERROR_INVALID_EA_HANDLE* = 278
  ERROR_EAS_NOT_SUPPORTED* = 282
  ERROR_NOT_OWNER* = 288
  ERROR_TOO_MANY_POSTS* = 298
  ERROR_PARTIAL_COPY* = 299
  ERROR_MR_MID_NOT_FOUND* = 317
  ERROR_INVALID_ADDRESS* = 487
  ERROR_ARITHMETIC_OVERFLOW* = 534
  ERROR_PIPE_CONNECTED* = 535
  ERROR_PIPE_LISTENING* = 536
  ERROR_EA_ACCESS_DENIED* = 994
  ERROR_OPERATION_ABORTED* = 995
  ERROR_IO_INCOMPLETE* = 996
  ERROR_IO_PENDING* = 997
  ERROR_NOACCESS* = 998
  ERROR_SWAPERROR* = 999
  ERROR_STACK_OVERFLOW* = 1001
  ERROR_INVALID_MESSAGE* = 1002
  ERROR_CAN_NOT_COMPLETE* = 1003
  ERROR_INVALID_FLAGS* = 1004
  ERROR_UNRECOGNIZED_VOLUME* = 1005
  ERROR_FILE_INVALID* = 1006
  ERROR_FULLSCREEN_MODE* = 1007
  ERROR_NO_TOKEN* = 1008
  ERROR_BADDB* = 1009
  ERROR_BADKEY* = 1010
  ERROR_CANTOPEN* = 1011
  ERROR_CANTREAD* = 1012
  ERROR_CANTWRITE* = 1013
  ERROR_REGISTRY_RECOVERED* = 1014
  ERROR_REGISTRY_CORRUPT* = 1015
  ERROR_REGISTRY_IO_FAILED* = 1016
  ERROR_NOT_REGISTRY_FILE* = 1017
  ERROR_KEY_DELETED* = 1018
  ERROR_NO_LOG_SPACE* = 1019
  ERROR_KEY_HAS_CHILDREN* = 1020
  ERROR_CHILD_MUST_BE_VOLATILE* = 1021
  ERROR_NOTIFY_ENUM_DIR* = 1022
  ERROR_DEPENDENT_SERVICES_RUNNING* = 1051
  ERROR_INVALID_SERVICE_CONTROL* = 1052
  ERROR_SERVICE_REQUEST_TIMEOUT* = 1053
  ERROR_SERVICE_NO_THREAD* = 1054
  ERROR_SERVICE_DATABASE_LOCKED* = 1055
  ERROR_SERVICE_ALREADY_RUNNING* = 1056
  ERROR_INVALID_SERVICE_ACCOUNT* = 1057
  ERROR_SERVICE_DISABLED* = 1058
  ERROR_CIRCULAR_DEPENDENCY* = 1059
  ERROR_SERVICE_DOES_NOT_EXIST* = 1060
  ERROR_SERVICE_CANNOT_ACCEPT_CTRL* = 1061
  ERROR_SERVICE_NOT_ACTIVE* = 1062
  ERROR_FAILED_SERVICE_CONTROLLER_CONNECT* = 1063
  ERROR_EXCEPTION_IN_SERVICE* = 1064
  ERROR_DATABASE_DOES_NOT_EXIST* = 1065
  ERROR_SERVICE_SPECIFIC_ERROR* = 1066
  ERROR_PROCESS_ABORTED* = 1067
  ERROR_SERVICE_DEPENDENCY_FAIL* = 1068
  ERROR_SERVICE_LOGON_FAILED* = 1069
  ERROR_SERVICE_START_HANG* = 1070
  ERROR_INVALID_SERVICE_LOCK* = 1071
  ERROR_SERVICE_MARKED_FOR_DELETE* = 1072
  ERROR_SERVICE_EXISTS* = 1073
  ERROR_ALREADY_RUNNING_LKG* = 1074
  ERROR_SERVICE_DEPENDENCY_DELETED* = 1075
  ERROR_BOOT_ALREADY_ACCEPTED* = 1076
  ERROR_SERVICE_NEVER_STARTED* = 1077
  ERROR_DUPLICATE_SERVICE_NAME* = 1078
  ERROR_END_OF_MEDIA* = 1100
  ERROR_FILEMARK_DETECTED* = 1101
  ERROR_BEGINNING_OF_MEDIA* = 1102
  ERROR_SETMARK_DETECTED* = 1103
  ERROR_NO_DATA_DETECTED* = 1104
  ERROR_PARTITION_FAILURE* = 1105
  ERROR_INVALID_BLOCK_LENGTH* = 1106
  ERROR_DEVICE_NOT_PARTITIONED* = 1107
  ERROR_UNABLE_TO_LOCK_MEDIA* = 1108
  ERROR_UNABLE_TO_UNLOAD_MEDIA* = 1109
  ERROR_MEDIA_CHANGED* = 1110
  ERROR_BUS_RESET* = 1111
  ERROR_NO_MEDIA_IN_DRIVE* = 1112
  ERROR_NO_UNICODE_TRANSLATION* = 1113
  ERROR_DLL_INIT_FAILED* = 1114
  ERROR_SHUTDOWN_IN_PROGRESS* = 1115
  ERROR_NO_SHUTDOWN_IN_PROGRESS* = 1116
  ERROR_IO_DEVICE* = 1117
  ERROR_SERIAL_NO_DEVICE* = 1118
  ERROR_IRQ_BUSY* = 1119
  ERROR_MORE_WRITES* = 1120
  ERROR_COUNTER_TIMEOUT* = 1121
  ERROR_FLOPPY_ID_MARK_NOT_FOUND* = 1122
  ERROR_FLOPPY_WRONG_CYLINDER* = 1123
  ERROR_FLOPPY_UNKNOWN_ERROR* = 1124
  ERROR_FLOPPY_BAD_REGISTERS* = 1125
  ERROR_DISK_RECALIBRATE_FAILED* = 1126
  ERROR_DISK_OPERATION_FAILED* = 1127
  ERROR_DISK_RESET_FAILED* = 1128
  ERROR_EOM_OVERFLOW* = 1129
  ERROR_NOT_ENOUGH_SERVER_MEMORY* = 1130
  ERROR_POSSIBLE_DEADLOCK* = 1131
  ERROR_MAPPED_ALIGNMENT* = 1132
  ERROR_SET_POWER_STATE_VETOED* = 1140
  ERROR_SET_POWER_STATE_FAILED* = 1141
  ERROR_OLD_WIN_VERSION* = 1150
  ERROR_APP_WRONG_OS* = 1151
  ERROR_SINGLE_INSTANCE_APP* = 1152
  ERROR_RMODE_APP* = 1153
  ERROR_INVALID_DLL* = 1154
  ERROR_NO_ASSOCIATION* = 1155
  ERROR_DDE_FAIL* = 1156
  ERROR_DLL_NOT_FOUND* = 1157
  ERROR_BAD_USERNAME* = 2202
  ERROR_NOT_CONNECTED* = 2250
  ERROR_OPEN_FILES* = 2401
  ERROR_ACTIVE_CONNECTIONS* = 2402
  ERROR_DEVICE_IN_USE* = 2404
  ERROR_BAD_DEVICE* = 1200
  ERROR_CONNECTION_UNAVAIL* = 1201
  ERROR_DEVICE_ALREADY_REMEMBERED* = 1202
  ERROR_NO_NET_OR_BAD_PATH* = 1203
  ERROR_BAD_PROVIDER* = 1204
  ERROR_CANNOT_OPEN_PROFILE* = 1205
  ERROR_BAD_PROFILE* = 1206
  ERROR_NOT_CONTAINER* = 1207
  ERROR_EXTENDED_ERROR* = 1208
  ERROR_INVALID_GROUPNAME* = 1209
  ERROR_INVALID_COMPUTERNAME* = 1210
  ERROR_INVALID_EVENTNAME* = 1211
  ERROR_INVALID_DOMAINNAME* = 1212
  ERROR_INVALID_SERVICENAME* = 1213
  ERROR_INVALID_NETNAME* = 1214
  ERROR_INVALID_SHARENAME* = 1215
  ERROR_INVALID_PASSWORDNAME* = 1216
  ERROR_INVALID_MESSAGENAME* = 1217
  ERROR_INVALID_MESSAGEDEST* = 1218
  ERROR_SESSION_CREDENTIAL_CONFLICT* = 1219
  ERROR_REMOTE_SESSION_LIMIT_EXCEEDED* = 1220
  ERROR_DUP_DOMAINNAME* = 1221
  ERROR_NO_NETWORK* = 1222
  ERROR_CANCELLED* = 1223
  ERROR_USER_MAPPED_FILE* = 1224
  ERROR_CONNECTION_REFUSED* = 1225
  ERROR_GRACEFUL_DISCONNECT* = 1226
  ERROR_ADDRESS_ALREADY_ASSOCIATED* = 1227
  ERROR_ADDRESS_NOT_ASSOCIATED* = 1228
  ERROR_CONNECTION_INVALID* = 1229
  ERROR_CONNECTION_ACTIVE* = 1230
  ERROR_NETWORK_UNREACHABLE* = 1231
  ERROR_HOST_UNREACHABLE* = 1232
  ERROR_PROTOCOL_UNREACHABLE* = 1233
  ERROR_PORT_UNREACHABLE* = 1234
  ERROR_REQUEST_ABORTED* = 1235
  ERROR_CONNECTION_ABORTED* = 1236
  ERROR_RETRY* = 1237
  ERROR_CONNECTION_COUNT_LIMIT* = 1238
  ERROR_LOGIN_TIME_RESTRICTION* = 1239
  ERROR_LOGIN_WKSTA_RESTRICTION* = 1240
  ERROR_INCORRECT_ADDRESS* = 1241
  ERROR_ALREADY_REGISTERED* = 1242
  ERROR_SERVICE_NOT_FOUND* = 1243
  ERROR_NOT_AUTHENTICATED* = 1244
  ERROR_NOT_LOGGED_ON* = 1245
  ERROR_CONTINUE* = 1246
  ERROR_ALREADY_INITIALIZED* = 1247
  ERROR_NO_MORE_DEVICES* = 1248
  ERROR_NOT_ALL_ASSIGNED* = 1300
  ERROR_SOME_NOT_MAPPED* = 1301
  ERROR_NO_QUOTAS_FOR_ACCOUNT* = 1302
  ERROR_LOCAL_USER_SESSION_KEY* = 1303
  ERROR_NULL_LM_PASSWORD* = 1304
  ERROR_UNKNOWN_REVISION* = 1305
  ERROR_REVISION_MISMATCH* = 1306
  ERROR_INVALID_OWNER* = 1307
  ERROR_INVALID_PRIMARY_GROUP* = 1308
  ERROR_NO_IMPERSONATION_TOKEN* = 1309
  ERROR_CANT_DISABLE_MANDATORY* = 1310
  ERROR_NO_LOGON_SERVERS* = 1311
  ERROR_NO_SUCH_LOGON_SESSION* = 1312
  ERROR_NO_SUCH_PRIVILEGE* = 1313
  ERROR_PRIVILEGE_NOT_HELD* = 1314
  ERROR_INVALID_ACCOUNT_NAME* = 1315
  ERROR_USER_EXISTS* = 1316
  ERROR_NO_SUCH_USER* = 1317
  ERROR_GROUP_EXISTS* = 1318
  ERROR_NO_SUCH_GROUP* = 1319
  ERROR_MEMBER_IN_GROUP* = 1320
  ERROR_MEMBER_NOT_IN_GROUP* = 1321
  ERROR_LAST_ADMIN* = 1322
  ERROR_WRONG_PASSWORD* = 1323
  ERROR_ILL_FORMED_PASSWORD* = 1324
  ERROR_PASSWORD_RESTRICTION* = 1325
  ERROR_LOGON_FAILURE* = 1326
  ERROR_ACCOUNT_RESTRICTION* = 1327
  ERROR_INVALID_LOGON_HOURS* = 1328
  ERROR_INVALID_WORKSTATION* = 1329
  ERROR_PASSWORD_EXPIRED* = 1330
  ERROR_ACCOUNT_DISABLED* = 1331
  ERROR_NONE_MAPPED* = 1332
  ERROR_TOO_MANY_LUIDS_REQUESTED* = 1333
  ERROR_LUIDS_EXHAUSTED* = 1334
  ERROR_INVALID_SUB_AUTHORITY* = 1335
  ERROR_INVALID_ACL* = 1336
  ERROR_INVALID_SID* = 1337
  ERROR_INVALID_SECURITY_DESCR* = 1338
  ERROR_BAD_INHERITANCE_ACL* = 1340
  ERROR_SERVER_DISABLED* = 1341
  ERROR_SERVER_NOT_DISABLED* = 1342
  ERROR_INVALID_ID_AUTHORITY* = 1343
  ERROR_ALLOTTED_SPACE_EXCEEDED* = 1344
  ERROR_INVALID_GROUP_ATTRIBUTES* = 1345
  ERROR_BAD_IMPERSONATION_LEVEL* = 1346
  ERROR_CANT_OPEN_ANONYMOUS* = 1347
  ERROR_BAD_VALIDATION_CLASS* = 1348
  ERROR_BAD_TOKEN_TYPE* = 1349
  ERROR_NO_SECURITY_ON_OBJECT* = 1350
  ERROR_CANT_ACCESS_DOMAIN_INFO* = 1351
  ERROR_INVALID_SERVER_STATE* = 1352
  ERROR_INVALID_DOMAIN_STATE* = 1353
  ERROR_INVALID_DOMAIN_ROLE* = 1354
  ERROR_NO_SUCH_DOMAIN* = 1355
  ERROR_DOMAIN_EXISTS* = 1356
  ERROR_DOMAIN_LIMIT_EXCEEDED* = 1357
  ERROR_INTERNAL_DB_CORRUPTION* = 1358
  ERROR_INTERNAL_ERROR* = 1359
  ERROR_GENERIC_NOT_MAPPED* = 1360
  ERROR_BAD_DESCRIPTOR_FORMAT* = 1361
  ERROR_NOT_LOGON_PROCESS* = 1362
  ERROR_LOGON_SESSION_EXISTS* = 1363
  ERROR_NO_SUCH_PACKAGE* = 1364
  ERROR_BAD_LOGON_SESSION_STATE* = 1365
  ERROR_LOGON_SESSION_COLLISION* = 1366
  ERROR_INVALID_LOGON_TYPE* = 1367
  ERROR_CANNOT_IMPERSONATE* = 1368
  ERROR_RXACT_INVALID_STATE* = 1369
  ERROR_RXACT_COMMIT_FAILURE* = 1370
  ERROR_SPECIAL_ACCOUNT* = 1371
  ERROR_SPECIAL_GROUP* = 1372
  ERROR_SPECIAL_USER* = 1373
  ERROR_MEMBERS_PRIMARY_GROUP* = 1374
  ERROR_TOKEN_ALREADY_IN_USE* = 1375
  ERROR_NO_SUCH_ALIAS* = 1376
  ERROR_MEMBER_NOT_IN_ALIAS* = 1377
  ERROR_MEMBER_IN_ALIAS* = 1378
  ERROR_ALIAS_EXISTS* = 1379
  ERROR_LOGON_NOT_GRANTED* = 1380
  ERROR_TOO_MANY_SECRETS* = 1381
  ERROR_SECRET_TOO_LONG* = 1382
  ERROR_INTERNAL_DB_ERROR* = 1383
  ERROR_TOO_MANY_CONTEXT_IDS* = 1384
  ERROR_LOGON_TYPE_NOT_GRANTED* = 1385
  ERROR_NT_CROSS_ENCRYPTION_REQUIRED* = 1386
  ERROR_NO_SUCH_MEMBER* = 1387
  ERROR_INVALID_MEMBER* = 1388
  ERROR_TOO_MANY_SIDS* = 1389
  ERROR_LM_CROSS_ENCRYPTION_REQUIRED* = 1390
  ERROR_NO_INHERITANCE* = 1391
  ERROR_FILE_CORRUPT* = 1392
  ERROR_DISK_CORRUPT* = 1393
  ERROR_NO_USER_SESSION_KEY* = 1394
  ERROR_LICENSE_QUOTA_EXCEEDED* = 1395
  ERROR_INVALID_WINDOW_HANDLE* = 1400
  ERROR_INVALID_MENU_HANDLE* = 1401
  ERROR_INVALID_CURSOR_HANDLE* = 1402
  ERROR_INVALID_ACCEL_HANDLE* = 1403
  ERROR_INVALID_HOOK_HANDLE* = 1404
  ERROR_INVALID_DWP_HANDLE* = 1405
  ERROR_TLW_WITH_WSCHILD* = 1406
  ERROR_CANNOT_FIND_WND_CLASS* = 1407
  ERROR_WINDOW_OF_OTHER_THREAD* = 1408
  ERROR_HOTKEY_ALREADY_REGISTERED* = 1409
  ERROR_CLASS_ALREADY_EXISTS* = 1410
  ERROR_CLASS_DOES_NOT_EXIST* = 1411
  ERROR_CLASS_HAS_WINDOWS* = 1412
  ERROR_INVALID_INDEX* = 1413
  ERROR_INVALID_ICON_HANDLE* = 1414
  ERROR_PRIVATE_DIALOG_INDEX* = 1415
  ERROR_LISTBOX_ID_NOT_FOUND* = 1416
  ERROR_NO_WILDCARD_CHARACTERS* = 1417
  ERROR_CLIPBOARD_NOT_OPEN* = 1418
  ERROR_HOTKEY_NOT_REGISTERED* = 1419
  ERROR_WINDOW_NOT_DIALOG* = 1420
  ERROR_CONTROL_ID_NOT_FOUND* = 1421
  ERROR_INVALID_COMBOBOX_MESSAGE* = 1422
  ERROR_WINDOW_NOT_COMBOBOX* = 1423
  ERROR_INVALID_EDIT_HEIGHT* = 1424
  ERROR_DC_NOT_FOUND* = 1425
  ERROR_INVALID_HOOK_FILTER* = 1426
  ERROR_INVALID_FILTER_PROC* = 1427
  ERROR_HOOK_NEEDS_HMOD* = 1428
  ERROR_GLOBAL_ONLY_HOOK* = 1429
  ERROR_JOURNAL_HOOK_SET* = 1430
  ERROR_HOOK_NOT_INSTALLED* = 1431
  ERROR_INVALID_LB_MESSAGE* = 1432
  ERROR_SETCOUNT_ON_BAD_LB* = 1433
  ERROR_LB_WITHOUT_TABSTOPS* = 1434
  ERROR_DESTROY_OBJECT_OF_OTHER_THREAD* = 1435
  ERROR_CHILD_WINDOW_MENU* = 1436
  ERROR_NO_SYSTEM_MENU* = 1437
  ERROR_INVALID_MSGBOX_STYLE* = 1438
  ERROR_INVALID_SPI_VALUE* = 1439
  ERROR_SCREEN_ALREADY_LOCKED* = 1440
  ERROR_HWNDS_HAVE_DIFF_PARENT* = 1441
  ERROR_NOT_CHILD_WINDOW* = 1442
  ERROR_INVALID_GW_COMMAND* = 1443
  ERROR_INVALID_THREAD_ID* = 1444
  ERROR_NON_MDICHILD_WINDOW* = 1445
  ERROR_POPUP_ALREADY_ACTIVE* = 1446
  ERROR_NO_SCROLLBARS* = 1447
  ERROR_INVALID_SCROLLBAR_RANGE* = 1448
  ERROR_INVALID_SHOWWIN_COMMAND* = 1449
  ERROR_NO_SYSTEM_RESOURCES* = 1450
  ERROR_NONPAGED_SYSTEM_RESOURCES* = 1451
  ERROR_PAGED_SYSTEM_RESOURCES* = 1452
  ERROR_WORKING_SET_QUOTA* = 1453
  ERROR_PAGEFILE_QUOTA* = 1454
  ERROR_COMMITMENT_LIMIT* = 1455
  ERROR_MENU_ITEM_NOT_FOUND* = 1456
  ERROR_INVALID_KEYBOARD_HANDLE* = 1457
  ERROR_HOOK_TYPE_NOT_ALLOWED* = 1458
  ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION* = 1459
  ERROR_TIMEOUT* = 1460
  ERROR_EVENTLOG_FILE_CORRUPT* = 1500
  ERROR_EVENTLOG_CANT_START* = 1501
  ERROR_LOG_FILE_FULL* = 1502
  ERROR_EVENTLOG_FILE_CHANGED* = 1503
  RPC_S_INVALID_STRING_BINDING* = 1700
  RPC_S_WRONG_KIND_OF_BINDING* = 1701
  RPC_S_INVALID_BINDING* = 1702
  RPC_S_PROTSEQ_NOT_SUPPORTED* = 1703
  RPC_S_INVALID_RPC_PROTSEQ* = 1704
  RPC_S_INVALID_STRING_UUID* = 1705
  RPC_S_INVALID_ENDPOINT_FORMAT* = 1706
  RPC_S_INVALID_NET_ADDR* = 1707
  RPC_S_NO_ENDPOINT_FOUND* = 1708
  RPC_S_INVALID_TIMEOUT* = 1709
  RPC_S_OBJECT_NOT_FOUND* = 1710
  RPC_S_ALREADY_REGISTERED* = 1711
  RPC_S_TYPE_ALREADY_REGISTERED* = 1712
  RPC_S_ALREADY_LISTENING* = 1713
  RPC_S_NO_PROTSEQS_REGISTERED* = 1714
  RPC_S_NOT_LISTENING* = 1715
  RPC_S_UNKNOWN_MGR_TYPE* = 1716
  RPC_S_UNKNOWN_IF* = 1717
  RPC_S_NO_BINDINGS* = 1718
  RPC_S_NO_PROTSEQS* = 1719
  RPC_S_CANT_CREATE_ENDPOINT* = 1720
  RPC_S_OUT_OF_RESOURCES* = 1721
  RPC_S_SERVER_UNAVAILABLE* = 1722
  RPC_S_SERVER_TOO_BUSY* = 1723
  RPC_S_INVALID_NETWORK_OPTIONS* = 1724
  RPC_S_NO_CALL_ACTIVE* = 1725
  RPC_S_CALL_FAILED* = 1726
  RPC_S_CALL_FAILED_DNE* = 1727
  RPC_S_PROTOCOL_ERROR* = 1728
  RPC_S_UNSUPPORTED_TRANS_SYN* = 1730
  RPC_S_UNSUPPORTED_TYPE* = 1732
  RPC_S_INVALID_TAG* = 1733
  RPC_S_INVALID_BOUND* = 1734
  RPC_S_NO_ENTRY_NAME* = 1735
  RPC_S_INVALID_NAME_SYNTAX* = 1736
  RPC_S_UNSUPPORTED_NAME_SYNTAX* = 1737
  RPC_S_UUID_NO_ADDRESS* = 1739
  RPC_S_DUPLICATE_ENDPOINT* = 1740
  RPC_S_UNKNOWN_AUTHN_TYPE* = 1741
  RPC_S_MAX_CALLS_TOO_SMALL* = 1742
  RPC_S_STRING_TOO_LONG* = 1743
  RPC_S_PROTSEQ_NOT_FOUND* = 1744
  RPC_S_PROCNUM_OUT_OF_RANGE* = 1745
  RPC_S_BINDING_HAS_NO_AUTH* = 1746
  RPC_S_UNKNOWN_AUTHN_SERVICE* = 1747
  RPC_S_UNKNOWN_AUTHN_LEVEL* = 1748
  RPC_S_INVALID_AUTH_IDENTITY* = 1749
  RPC_S_UNKNOWN_AUTHZ_SERVICE* = 1750
  EPT_S_INVALID_ENTRY* = 1751
  EPT_S_CANT_PERFORM_OP* = 1752
  EPT_S_NOT_REGISTERED* = 1753
  RPC_S_NOTHING_TO_EXPORT* = 1754
  RPC_S_INCOMPLETE_NAME* = 1755
  RPC_S_INVALID_VERS_OPTION* = 1756
  RPC_S_NO_MORE_MEMBERS* = 1757
  RPC_S_NOT_ALL_OBJS_UNEXPORTED* = 1758
  RPC_S_INTERFACE_NOT_FOUND* = 1759
  RPC_S_ENTRY_ALREADY_EXISTS* = 1760
  RPC_S_ENTRY_NOT_FOUND* = 1761
  RPC_S_NAME_SERVICE_UNAVAILABLE* = 1762
  RPC_S_INVALID_NAF_ID* = 1763
  RPC_S_CANNOT_SUPPORT* = 1764
  RPC_S_NO_CONTEXT_AVAILABLE* = 1765
  RPC_S_INTERNAL_ERROR* = 1766
  RPC_S_ZERO_DIVIDE* = 1767
  RPC_S_ADDRESS_ERROR* = 1768
  RPC_S_FP_DIV_ZERO* = 1769
  RPC_S_FP_UNDERFLOW* = 1770
  RPC_S_FP_OVERFLOW* = 1771
  RPC_X_NO_MORE_ENTRIES* = 1772
  RPC_X_SS_CHAR_TRANS_OPEN_FAIL* = 1773
  RPC_X_SS_CHAR_TRANS_SHORT_FILE* = 1774
  RPC_X_SS_IN_NULL_CONTEXT* = 1775
  RPC_X_SS_CONTEXT_DAMAGED* = 1777
  RPC_X_SS_HANDLES_MISMATCH* = 1778
  RPC_X_SS_CANNOT_GET_CALL_HANDLE* = 1779
  RPC_X_NULL_REF_POINTER* = 1780
  RPC_X_ENUM_VALUE_OUT_OF_RANGE* = 1781
  RPC_X_BYTE_COUNT_TOO_SMALL* = 1782
  RPC_X_BAD_STUB_DATA* = 1783
  ERROR_INVALID_USER_BUFFER* = 1784
  ERROR_UNRECOGNIZED_MEDIA* = 1785
  ERROR_NO_TRUST_LSA_SECRET* = 1786
  ERROR_NO_TRUST_SAM_ACCOUNT* = 1787
  ERROR_TRUSTED_DOMAIN_FAILURE* = 1788
  ERROR_TRUSTED_RELATIONSHIP_FAILURE* = 1789
  ERROR_TRUST_FAILURE* = 1790
  RPC_S_CALL_IN_PROGRESS* = 1791
  ERROR_NETLOGON_NOT_STARTED* = 1792
  ERROR_ACCOUNT_EXPIRED* = 1793
  ERROR_REDIRECTOR_HAS_OPEN_HANDLES* = 1794
  ERROR_PRINTER_DRIVER_ALREADY_INSTALLED* = 1795
  ERROR_UNKNOWN_PORT* = 1796
  ERROR_UNKNOWN_PRINTER_DRIVER* = 1797
  ERROR_UNKNOWN_PRINTPROCESSOR* = 1798
  ERROR_INVALID_SEPARATOR_FILE* = 1799
  ERROR_INVALID_PRIORITY* = 1800
  ERROR_INVALID_PRINTER_NAME* = 1801
  ERROR_PRINTER_ALREADY_EXISTS* = 1802
  ERROR_INVALID_PRINTER_COMMAND* = 1803
  ERROR_INVALID_DATATYPE* = 1804
  ERROR_INVALID_ENVIRONMENT* = 1805
  RPC_S_NO_MORE_BINDINGS* = 1806
  ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT* = 1807
  ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT* = 1808
  ERROR_NOLOGON_SERVER_TRUST_ACCOUNT* = 1809
  ERROR_DOMAIN_TRUST_INCONSISTENT* = 1810
  ERROR_SERVER_HAS_OPEN_HANDLES* = 1811
  ERROR_RESOURCE_DATA_NOT_FOUND* = 1812
  ERROR_RESOURCE_TYPE_NOT_FOUND* = 1813
  ERROR_RESOURCE_NAME_NOT_FOUND* = 1814
  ERROR_RESOURCE_LANG_NOT_FOUND* = 1815
  ERROR_NOT_ENOUGH_QUOTA* = 1816
  RPC_S_NO_INTERFACES* = 1817
  RPC_S_CALL_CANCELLED* = 1818
  RPC_S_BINDING_INCOMPLETE* = 1819
  RPC_S_COMM_FAILURE* = 1820
  RPC_S_UNSUPPORTED_AUTHN_LEVEL* = 1821
  RPC_S_NO_PRINC_NAME* = 1822
  RPC_S_NOT_RPC_ERROR* = 1823
  RPC_S_UUID_LOCAL_ONLY* = 1824
  RPC_S_SEC_PKG_ERROR* = 1825
  RPC_S_NOT_CANCELLED* = 1826
  RPC_X_INVALID_ES_ACTION* = 1827
  RPC_X_WRONG_ES_VERSION* = 1828
  RPC_X_WRONG_STUB_VERSION* = 1829
  RPC_X_INVALID_PIPE_OBJECT* = 1830
  RPC_X_INVALID_PIPE_OPERATION* = 1831
  RPC_S_GROUP_MEMBER_NOT_FOUND* = 1898
  EPT_S_CANT_CREATE* = 1899
  RPC_S_INVALID_OBJECT* = 1900
  ERROR_INVALID_TIME* = 1901
  ERROR_INVALID_FORM_NAME* = 1902
  ERROR_INVALID_FORM_SIZE* = 1903
  ERROR_ALREADY_WAITING* = 1904
  ERROR_PRINTER_DELETED* = 1905
  ERROR_INVALID_PRINTER_STATE* = 1906
  ERROR_PASSWORD_MUST_CHANGE* = 1907
  ERROR_DOMAIN_CONTROLLER_NOT_FOUND* = 1908
  ERROR_ACCOUNT_LOCKED_OUT* = 1909
  OR_INVALID_OXID* = 1910
  OR_INVALID_OID* = 1911
  OR_INVALID_SET* = 1912
  RPC_S_SEND_INCOMPLETE* = 1913
  ERROR_NO_BROWSER_SERVERS_FOUND* = 6118
  ERROR_INVALID_PIXEL_FORMAT* = 2000
  ERROR_BAD_DRIVER* = 2001
  ERROR_INVALID_WINDOW_STYLE* = 2002
  ERROR_METAFILE_NOT_SUPPORTED* = 2003
  ERROR_TRANSFORM_NOT_SUPPORTED* = 2004
  ERROR_CLIPPING_NOT_SUPPORTED* = 2005
  ERROR_UNKNOWN_PRINT_MONITOR* = 3000
  ERROR_PRINTER_DRIVER_IN_USE* = 3001
  ERROR_SPOOL_FILE_NOT_FOUND* = 3002
  ERROR_SPL_NO_STARTDOC* = 3003
  ERROR_SPL_NO_ADDJOB* = 3004
  ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED* = 3005
  ERROR_PRINT_MONITOR_ALREADY_INSTALLED* = 3006
  ERROR_INVALID_PRINT_MONITOR* = 3007
  ERROR_PRINT_MONITOR_IN_USE* = 3008
  ERROR_PRINTER_HAS_JOBS_QUEUED* = 3009
  ERROR_SUCCESS_REBOOT_REQUIRED* = 3010
  ERROR_SUCCESS_RESTART_REQUIRED* = 3011
  ERROR_WINS_INTERNAL* = 4000
  ERROR_CAN_NOT_DEL_LOCAL_WINS* = 4001
  ERROR_STATIC_INIT* = 4002
  ERROR_INC_BACKUP* = 4003
  ERROR_FULL_BACKUP* = 4004
  ERROR_REC_NON_EXISTENT* = 4005
  ERROR_RPL_NOT_ALLOWED* = 4006
  E_UNEXPECTED* = HRESULT(0x8000FFFF)
  E_NOTIMPL* = HRESULT(0x80004001)
  E_OUTOFMEMORY* = HRESULT(0x8007000E)
  E_INVALIDARG* = HRESULT(0x80070057)
  E_NOINTERFACE* = HRESULT(0x80004002)
  E_POINTER* = HRESULT(0x80004003)
  E_HANDLE* = HRESULT(0x80070006)
  E_ABORT* = HRESULT(0x80004004)
  E_FAIL* = HRESULT(0x80004005)
  E_ACCESSDENIED* = HRESULT(0x80070005)
  E_PENDING* = HRESULT(0x8000000A)
  CO_E_INIT_TLS* = HRESULT(0x80004006)
  CO_E_INIT_SHARED_ALLOCATOR* = HRESULT(0x80004007)
  CO_E_INIT_MEMORY_ALLOCATOR* = HRESULT(0x80004008)
  CO_E_INIT_CLASS_CACHE* = HRESULT(0x80004009)
  CO_E_INIT_RPC_CHANNEL* = HRESULT(0x8000400A)
  CO_E_INIT_TLS_SET_CHANNEL_CONTROL* = HRESULT(0x8000400B)
  CO_E_INIT_TLS_CHANNEL_CONTROL* = HRESULT(0x8000400C)
  CO_E_INIT_UNACCEPTED_USER_ALLOCATOR* = HRESULT(0x8000400D)
  CO_E_INIT_SCM_MUTEX_EXISTS* = HRESULT(0x8000400E)
  CO_E_INIT_SCM_FILE_MAPPING_EXISTS* = HRESULT(0x8000400F)
  CO_E_INIT_SCM_MAP_VIEW_OF_FILE* = HRESULT(0x80004010)
  CO_E_INIT_SCM_EXEC_FAILURE* = HRESULT(0x80004011)
  CO_E_INIT_ONLY_SINGLE_THREADED* = HRESULT(0x80004012)
  CO_E_CANT_REMOTE* = HRESULT(0x80004013)
  CO_E_BAD_SERVER_NAME* = HRESULT(0x80004014)
  CO_E_WRONG_SERVER_IDENTITY* = HRESULT(0x80004015)
  CO_E_OLE1DDE_DISABLED* = HRESULT(0x80004016)
  CO_E_RUNAS_SYNTAX* = HRESULT(0x80004017)
  CO_E_CREATEPROCESS_FAILURE* = HRESULT(0x80004018)
  CO_E_RUNAS_CREATEPROCESS_FAILURE* = HRESULT(0x80004019)
  CO_E_RUNAS_LOGON_FAILURE* = HRESULT(0x8000401A)
  CO_E_LAUNCH_PERMSSION_DENIED* = HRESULT(0x8000401B)
  CO_E_START_SERVICE_FAILURE* = HRESULT(0x8000401C)
  CO_E_REMOTE_COMMUNICATION_FAILURE* = HRESULT(0x8000401D)
  CO_E_SERVER_START_TIMEOUT* = HRESULT(0x8000401E)
  CO_E_CLSREG_INCONSISTENT* = HRESULT(0x8000401F)
  CO_E_IIDREG_INCONSISTENT* = HRESULT(0x80004020)
  CO_E_NOT_SUPPORTED* = HRESULT(0x80004021)
  CO_E_FIRST* = DWORD(0x800401F0)
  CO_E_LAST* = DWORD(0x800401FF)
  CO_S_FIRST* = DWORD(0x000401F0)
  CO_S_LAST* = DWORD(0x000401FF)
  S_OK* = HRESULT(0x00000000)
  S_FALSE* = HRESULT(0x00000001)
  CO_E_NOTINITIALIZED* = HRESULT(0x800401F0)
  CO_E_ALREADYINITIALIZED* = HRESULT(0x800401F1)
  CO_E_CANTDETERMINECLASS* = HRESULT(0x800401F2)
  CO_E_CLASSSTRING* = HRESULT(0x800401F3)
  CO_E_IIDSTRING* = HRESULT(0x800401F4)
  CO_E_APPNOTFOUND* = HRESULT(0x800401F5)
  CO_E_APPSINGLEUSE* = HRESULT(0x800401F6)
  CO_E_ERRORINAPP* = HRESULT(0x800401F7)
  CO_E_DLLNOTFOUND* = HRESULT(0x800401F8)
  CO_E_ERRORINDLL* = HRESULT(0x800401F9)
  CO_E_WRONGOSFORAPP* = HRESULT(0x800401FA)
  CO_E_OBJNOTREG* = HRESULT(0x800401FB)
  CO_E_OBJISREG* = HRESULT(0x800401FC)
  CO_E_OBJNOTCONNECTED* = HRESULT(0x800401FD)
  CO_E_APPDIDNTREG* = HRESULT(0x800401FE)
  CO_E_RELEASED* = HRESULT(0x800401FF)
  OLE_E_FIRST* = HRESULT(0x80040000)
  OLE_E_LAST* = HRESULT(0x800400FF)
  OLE_S_FIRST* = HRESULT(0x00040000)
  OLE_S_LAST* = HRESULT(0x000400FF)
  OLE_E_OLEVERB* = HRESULT(0x80040000)
  OLE_E_ADVF* = HRESULT(0x80040001)
  OLE_E_ENUM_NOMORE* = HRESULT(0x80040002)
  OLE_E_ADVISENOTSUPPORTED* = HRESULT(0x80040003)
  OLE_E_NOCONNECTION* = HRESULT(0x80040004)
  OLE_E_NOTRUNNING* = HRESULT(0x80040005)
  OLE_E_NOCACHE* = HRESULT(0x80040006)
  OLE_E_BLANK* = HRESULT(0x80040007)
  OLE_E_CLASSDIFF* = HRESULT(0x80040008)
  OLE_E_CANT_GETMONIKER* = HRESULT(0x80040009)
  OLE_E_CANT_BINDTOSOURCE* = HRESULT(0x8004000A)
  OLE_E_STATIC* = HRESULT(0x8004000B)
  OLE_E_PROMPTSAVECANCELLED* = HRESULT(0x8004000C)
  OLE_E_INVALIDRECT* = HRESULT(0x8004000D)
  OLE_E_WRONGCOMPOBJ* = HRESULT(0x8004000E)
  OLE_E_INVALIDHWND* = HRESULT(0x8004000F)
  OLE_E_NOT_INPLACEACTIVE* = HRESULT(0x80040010)
  OLE_E_CANTCONVERT* = HRESULT(0x80040011)
  OLE_E_NOSTORAGE* = HRESULT(0x80040012)
  DV_E_FORMATETC* = HRESULT(0x80040064)
  DV_E_DVTARGETDEVICE* = HRESULT(0x80040065)
  DV_E_STGMEDIUM* = HRESULT(0x80040066)
  DV_E_STATDATA* = HRESULT(0x80040067)
  DV_E_LINDEX* = HRESULT(0x80040068)
  DV_E_TYMED* = HRESULT(0x80040069)
  DV_E_CLIPFORMAT* = HRESULT(0x8004006A)
  DV_E_DVASPECT* = HRESULT(0x8004006B)
  DV_E_DVTARGETDEVICE_SIZE* = HRESULT(0x8004006C)
  DV_E_NOIVIEWOBJECT* = HRESULT(0x8004006D)
  DRAGDROP_E_FIRST* = DWORD(0x80040100)
  DRAGDROP_E_LAST* = DWORD(0x8004010F)
  DRAGDROP_S_FIRST* = DWORD(0x00040100)
  DRAGDROP_S_LAST* = DWORD(0x0004010F)
  DRAGDROP_E_NOTREGISTERED* = HRESULT(0x80040100)
  DRAGDROP_E_ALREADYREGISTERED* = HRESULT(0x80040101)
  DRAGDROP_E_INVALIDHWND* = HRESULT(0x80040102)
  CLASSFACTORY_E_FIRST* = DWORD(0x80040110)
  CLASSFACTORY_E_LAST* = DWORD(0x8004011F)
  CLASSFACTORY_S_FIRST* = DWORD(0x00040110)
  CLASSFACTORY_S_LAST* = DWORD(0x0004011F)
  CLASS_E_NOAGGREGATION* = HRESULT(0x80040110)
  CLASS_E_CLASSNOTAVAILABLE* = HRESULT(0x80040111)
  MARSHAL_E_FIRST* = DWORD(0x80040120)
  MARSHAL_E_LAST* = DWORD(0x8004012F)
  MARSHAL_S_FIRST* = DWORD(0x00040120)
  MARSHAL_S_LAST* = DWORD(0x0004012F)
  DATA_E_FIRST* = DWORD(0x80040130)
  DATA_E_LAST* = DWORD(0x8004013F)
  DATA_S_FIRST* = DWORD(0x00040130)
  DATA_S_LAST* = DWORD(0x0004013F)
  VIEW_E_FIRST* = DWORD(0x80040140)
  VIEW_E_LAST* = DWORD(0x8004014F)
  VIEW_S_FIRST* = DWORD(0x00040140)
  VIEW_S_LAST* = DWORD(0x0004014F)
  VIEW_E_DRAW* = HRESULT(0x80040140)
  REGDB_E_FIRST* = DWORD(0x80040150)
  REGDB_E_LAST* = DWORD(0x8004015F)
  REGDB_S_FIRST* = DWORD(0x00040150)
  REGDB_S_LAST* = DWORD(0x0004015F)
  REGDB_E_READREGDB* = HRESULT(0x80040150)
  REGDB_E_WRITEREGDB* = HRESULT(0x80040151)
  REGDB_E_KEYMISSING* = HRESULT(0x80040152)
  REGDB_E_INVALIDVALUE* = HRESULT(0x80040153)
  REGDB_E_CLASSNOTREG* = HRESULT(0x80040154)
  REGDB_E_IIDNOTREG* = HRESULT(0x80040155)
  CACHE_E_FIRST* = DWORD(0x80040170)
  CACHE_E_LAST* = DWORD(0x8004017F)
  CACHE_S_FIRST* = DWORD(0x00040170)
  CACHE_S_LAST* = DWORD(0x0004017F)
  CACHE_E_NOCACHE_UPDATED* = HRESULT(0x80040170)
  OLEOBJ_E_FIRST* = DWORD(0x80040180)
  OLEOBJ_E_LAST* = DWORD(0x8004018F)
  OLEOBJ_S_FIRST* = DWORD(0x00040180)
  OLEOBJ_S_LAST* = DWORD(0x0004018F)
  OLEOBJ_E_NOVERBS* = HRESULT(0x80040180)
  OLEOBJ_E_INVALIDVERB* = HRESULT(0x80040181)
  CLIENTSITE_E_FIRST* = DWORD(0x80040190)
  CLIENTSITE_E_LAST* = DWORD(0x8004019F)
  CLIENTSITE_S_FIRST* = DWORD(0x00040190)
  CLIENTSITE_S_LAST* = DWORD(0x0004019F)
  INPLACE_E_NOTUNDOABLE* = HRESULT(0x800401A0)
  INPLACE_E_NOTOOLSPACE* = HRESULT(0x800401A1)
  INPLACE_E_FIRST* = DWORD(0x800401A0)
  INPLACE_E_LAST* = DWORD(0x800401AF)
  INPLACE_S_FIRST* = DWORD(0x000401A0)
  INPLACE_S_LAST* = DWORD(0x000401AF)
  ENUM_E_FIRST* = DWORD(0x800401B0)
  ENUM_E_LAST* = DWORD(0x800401BF)
  ENUM_S_FIRST* = DWORD(0x000401B0)
  ENUM_S_LAST* = DWORD(0x000401BF)
  CONVERT10_E_FIRST* = DWORD(0x800401C0)
  CONVERT10_E_LAST* = DWORD(0x800401CF)
  CONVERT10_S_FIRST* = DWORD(0x000401C0)
  CONVERT10_S_LAST* = DWORD(0x000401CF)
  CONVERT10_E_OLESTREAM_GET* = HRESULT(0x800401C0)
  CONVERT10_E_OLESTREAM_PUT* = HRESULT(0x800401C1)
  CONVERT10_E_OLESTREAM_FMT* = HRESULT(0x800401C2)
  CONVERT10_E_OLESTREAM_BITMAP_TO_DIB* = HRESULT(0x800401C3)
  CONVERT10_E_STG_FMT* = HRESULT(0x800401C4)
  CONVERT10_E_STG_NO_STD_STREAM* = HRESULT(0x800401C5)
  CONVERT10_E_STG_DIB_TO_BITMAP* = HRESULT(0x800401C6)
  CLIPBRD_E_FIRST* = DWORD(0x800401D0)
  CLIPBRD_E_LAST* = DWORD(0x800401DF)
  CLIPBRD_S_FIRST* = DWORD(0x000401D0)
  CLIPBRD_S_LAST* = DWORD(0x000401DF)
  CLIPBRD_E_CANT_OPEN* = HRESULT(0x800401D0)
  CLIPBRD_E_CANT_EMPTY* = HRESULT(0x800401D1)
  CLIPBRD_E_CANT_SET* = HRESULT(0x800401D2)
  CLIPBRD_E_BAD_DATA* = HRESULT(0x800401D3)
  CLIPBRD_E_CANT_CLOSE* = HRESULT(0x800401D4)
  MK_E_FIRST* = DWORD(0x800401E0)
  MK_E_LAST* = DWORD(0x800401EF)
  MK_S_FIRST* = DWORD(0x000401E0)
  MK_S_LAST* = DWORD(0x000401EF)
  MK_E_CONNECTMANUALLY* = HRESULT(0x800401E0)
  MK_E_EXCEEDEDDEADLINE* = HRESULT(0x800401E1)
  MK_E_NEEDGENERIC* = HRESULT(0x800401E2)
  MK_E_UNAVAILABLE* = HRESULT(0x800401E3)
  MK_E_SYNTAX* = HRESULT(0x800401E4)
  MK_E_NOOBJECT* = HRESULT(0x800401E5)
  MK_E_INVALIDEXTENSION* = HRESULT(0x800401E6)
  MK_E_INTERMEDIATEINTERFACENOTSUPPORTED* = HRESULT(0x800401E7)
  MK_E_NOTBINDABLE* = HRESULT(0x800401E8)
  MK_E_NOTBOUND* = HRESULT(0x800401E9)
  MK_E_CANTOPENFILE* = HRESULT(0x800401EA)
  MK_E_MUSTBOTHERUSER* = HRESULT(0x800401EB)
  MK_E_NOINVERSE* = HRESULT(0x800401EC)
  MK_E_NOSTORAGE* = HRESULT(0x800401ED)
  MK_E_NOPREFIX* = HRESULT(0x800401EE)
  MK_E_ENUMERATION_FAILED* = HRESULT(0x800401EF)
  OLE_S_USEREG* = HRESULT(0x00040000)
  OLE_S_STATIC* = HRESULT(0x00040001)
  OLE_S_MAC_CLIPFORMAT* = HRESULT(0x00040002)
  DRAGDROP_S_DROP* = HRESULT(0x00040100)
  DRAGDROP_S_CANCEL* = HRESULT(0x00040101)
  DRAGDROP_S_USEDEFAULTCURSORS* = HRESULT(0x00040102)
  DATA_S_SAMEFORMATETC* = HRESULT(0x00040130)
  VIEW_S_ALREADY_FROZEN* = HRESULT(0x00040140)
  CACHE_S_FORMATETC_NOTSUPPORTED* = HRESULT(0x00040170)
  CACHE_S_SAMECACHE* = HRESULT(0x00040171)
  CACHE_S_SOMECACHES_NOTUPDATED* = HRESULT(0x00040172)
  OLEOBJ_S_INVALIDVERB* = HRESULT(0x00040180)
  OLEOBJ_S_CANNOT_DOVERB_NOW* = HRESULT(0x00040181)
  OLEOBJ_S_INVALIDHWND* = HRESULT(0x00040182)
  INPLACE_S_TRUNCATED* = HRESULT(0x000401A0)
  CONVERT10_S_NO_PRESENTATION* = HRESULT(0x000401C0)
  MK_S_REDUCED_TO_SELF* = HRESULT(0x000401E2)
  MK_S_ME* = HRESULT(0x000401E4)
  MK_S_HIM* = HRESULT(0x000401E5)
  MK_S_US* = HRESULT(0x000401E6)
  MK_S_MONIKERALREADYREGISTERED* = HRESULT(0x000401E7)
  CO_E_CLASS_CREATE_FAILED* = HRESULT(0x80080001)
  CO_E_SCM_ERROR* = HRESULT(0x80080002)
  CO_E_SCM_RPC_FAILURE* = HRESULT(0x80080003)
  CO_E_BAD_PATH* = HRESULT(0x80080004)
  CO_E_SERVER_EXEC_FAILURE* = HRESULT(0x80080005)
  CO_E_OBJSRV_RPC_FAILURE* = HRESULT(0x80080006)
  MK_E_NO_NORMALIZED* = HRESULT(0x80080007)
  CO_E_SERVER_STOPPING* = HRESULT(0x80080008)
  MEM_E_INVALID_ROOT* = HRESULT(0x80080009)
  MEM_E_INVALID_LINK* = HRESULT(0x80080010)
  MEM_E_INVALID_SIZE* = HRESULT(0x80080011)
  CO_S_NOTALLINTERFACES* = HRESULT(0x00080012)
  DISP_E_UNKNOWNINTERFACE* = HRESULT(0x80020001)
  DISP_E_MEMBERNOTFOUND* = HRESULT(0x80020003)
  DISP_E_PARAMNOTFOUND* = HRESULT(0x80020004)
  DISP_E_TYPEMISMATCH* = HRESULT(0x80020005)
  DISP_E_UNKNOWNNAME* = HRESULT(0x80020006)
  DISP_E_NONAMEDARGS* = HRESULT(0x80020007)
  DISP_E_BADVARTYPE* = HRESULT(0x80020008)
  DISP_E_EXCEPTION* = HRESULT(0x80020009)
  DISP_E_OVERFLOW* = HRESULT(0x8002000A)
  DISP_E_BADINDEX* = HRESULT(0x8002000B)
  DISP_E_UNKNOWNLCID* = HRESULT(0x8002000C)
  DISP_E_ARRAYISLOCKED* = HRESULT(0x8002000D)
  DISP_E_BADPARAMCOUNT* = HRESULT(0x8002000E)
  DISP_E_PARAMNOTOPTIONAL* = HRESULT(0x8002000F)
  DISP_E_BADCALLEE* = HRESULT(0x80020010)
  DISP_E_NOTACOLLECTION* = HRESULT(0x80020011)
  TYPE_E_BUFFERTOOSMALL* = HRESULT(0x80028016)
  TYPE_E_INVDATAREAD* = HRESULT(0x80028018)
  TYPE_E_UNSUPFORMAT* = HRESULT(0x80028019)
  TYPE_E_REGISTRYACCESS* = HRESULT(0x8002801C)
  TYPE_E_LIBNOTREGISTERED* = HRESULT(0x8002801D)
  TYPE_E_UNDEFINEDTYPE* = HRESULT(0x80028027)
  TYPE_E_QUALIFIEDNAMEDISALLOWED* = HRESULT(0x80028028)
  TYPE_E_INVALIDSTATE* = HRESULT(0x80028029)
  TYPE_E_WRONGTYPEKIND* = HRESULT(0x8002802A)
  TYPE_E_ELEMENTNOTFOUND* = HRESULT(0x8002802B)
  TYPE_E_AMBIGUOUSNAME* = HRESULT(0x8002802C)
  TYPE_E_NAMECONFLICT* = HRESULT(0x8002802D)
  TYPE_E_UNKNOWNLCID* = HRESULT(0x8002802E)
  TYPE_E_DLLFUNCTIONNOTFOUND* = HRESULT(0x8002802F)
  TYPE_E_BADMODULEKIND* = HRESULT(0x800288BD)
  TYPE_E_SIZETOOBIG* = HRESULT(0x800288C5)
  TYPE_E_DUPLICATEID* = HRESULT(0x800288C6)
  TYPE_E_INVALIDID* = HRESULT(0x800288CF)
  TYPE_E_TYPEMISMATCH* = HRESULT(0x80028CA0)
  TYPE_E_OUTOFBOUNDS* = HRESULT(0x80028CA1)
  TYPE_E_IOERROR* = HRESULT(0x80028CA2)
  TYPE_E_CANTCREATETMPFILE* = HRESULT(0x80028CA3)
  TYPE_E_CANTLOADLIBRARY* = HRESULT(0x80029C4A)
  TYPE_E_INCONSISTENTPROPFUNCS* = HRESULT(0x80029C83)
  TYPE_E_CIRCULARTYPE* = HRESULT(0x80029C84)
  STG_E_INVALIDFUNCTION* = HRESULT(0x80030001)
  STG_E_FILENOTFOUND* = HRESULT(0x80030002)
  STG_E_PATHNOTFOUND* = HRESULT(0x80030003)
  STG_E_TOOMANYOPENFILES* = HRESULT(0x80030004)
  STG_E_ACCESSDENIED* = HRESULT(0x80030005)
  STG_E_INVALIDHANDLE* = HRESULT(0x80030006)
  STG_E_INSUFFICIENTMEMORY* = HRESULT(0x80030008)
  STG_E_INVALIDPOINTER* = HRESULT(0x80030009)
  STG_E_NOMOREFILES* = HRESULT(0x80030012)
  STG_E_DISKISWRITEPROTECTED* = HRESULT(0x80030013)
  STG_E_SEEKERROR* = HRESULT(0x80030019)
  STG_E_WRITEFAULT* = HRESULT(0x8003001D)
  STG_E_READFAULT* = HRESULT(0x8003001E)
  STG_E_SHAREVIOLATION* = HRESULT(0x80030020)
  STG_E_LOCKVIOLATION* = HRESULT(0x80030021)
  STG_E_FILEALREADYEXISTS* = HRESULT(0x80030050)
  STG_E_INVALIDPARAMETER* = HRESULT(0x80030057)
  STG_E_MEDIUMFULL* = HRESULT(0x80030070)
  STG_E_PROPSETMISMATCHED* = HRESULT(0x800300F0)
  STG_E_ABNORMALAPIEXIT* = HRESULT(0x800300FA)
  STG_E_INVALIDHEADER* = HRESULT(0x800300FB)
  STG_E_INVALIDNAME* = HRESULT(0x800300FC)
  STG_E_UNKNOWN* = HRESULT(0x800300FD)
  STG_E_UNIMPLEMENTEDFUNCTION* = HRESULT(0x800300FE)
  STG_E_INVALIDFLAG* = HRESULT(0x800300FF)
  STG_E_INUSE* = HRESULT(0x80030100)
  STG_E_NOTCURRENT* = HRESULT(0x80030101)
  STG_E_REVERTED* = HRESULT(0x80030102)
  STG_E_CANTSAVE* = HRESULT(0x80030103)
  STG_E_OLDFORMAT* = HRESULT(0x80030104)
  STG_E_OLDDLL* = HRESULT(0x80030105)
  STG_E_SHAREREQUIRED* = HRESULT(0x80030106)
  STG_E_NOTFILEBASEDSTORAGE* = HRESULT(0x80030107)
  STG_E_EXTANTMARSHALLINGS* = HRESULT(0x80030108)
  STG_E_DOCFILECORRUPT* = HRESULT(0x80030109)
  STG_E_BADBASEADDRESS* = HRESULT(0x80030110)
  STG_E_INCOMPLETE* = HRESULT(0x80030201)
  STG_E_TERMINATED* = HRESULT(0x80030202)
  STG_S_CONVERTED* = HRESULT(0x00030200)
  STG_S_BLOCK* = HRESULT(0x00030201)
  STG_S_RETRYNOW* = HRESULT(0x00030202)
  STG_S_MONITORING* = HRESULT(0x00030203)
  RPC_E_CALL_REJECTED* = HRESULT(0x80010001)
  RPC_E_CALL_CANCELED* = HRESULT(0x80010002)
  RPC_E_CANTPOST_INSENDCALL* = HRESULT(0x80010003)
  RPC_E_CANTCALLOUT_INASYNCCALL* = HRESULT(0x80010004)
  RPC_E_CANTCALLOUT_INEXTERNALCALL* = HRESULT(0x80010005)
  RPC_E_CONNECTION_TERMINATED* = HRESULT(0x80010006)
  RPC_E_SERVER_DIED* = HRESULT(0x80010007)
  RPC_E_CLIENT_DIED* = HRESULT(0x80010008)
  RPC_E_INVALID_DATAPACKET* = HRESULT(0x80010009)
  RPC_E_CANTTRANSMIT_CALL* = HRESULT(0x8001000A)
  RPC_E_CLIENT_CANTMARSHAL_DATA* = HRESULT(0x8001000B)
  RPC_E_CLIENT_CANTUNMARSHAL_DATA* = HRESULT(0x8001000C)
  RPC_E_SERVER_CANTMARSHAL_DATA* = HRESULT(0x8001000D)
  RPC_E_SERVER_CANTUNMARSHAL_DATA* = HRESULT(0x8001000E)
  RPC_E_INVALID_DATA* = HRESULT(0x8001000F)
  RPC_E_INVALID_PARAMETER* = HRESULT(0x80010010)
  RPC_E_CANTCALLOUT_AGAIN* = HRESULT(0x80010011)
  RPC_E_SERVER_DIED_DNE* = HRESULT(0x80010012)
  RPC_E_SYS_CALL_FAILED* = HRESULT(0x80010100)
  RPC_E_OUT_OF_RESOURCES* = HRESULT(0x80010101)
  RPC_E_ATTEMPTED_MULTITHREAD* = HRESULT(0x80010102)
  RPC_E_NOT_REGISTERED* = HRESULT(0x80010103)
  RPC_E_FAULT* = HRESULT(0x80010104)
  RPC_E_SERVERFAULT* = HRESULT(0x80010105)
  RPC_E_CHANGED_MODE* = HRESULT(0x80010106)
  RPC_E_INVALIDMETHOD* = HRESULT(0x80010107)
  RPC_E_DISCONNECTED* = HRESULT(0x80010108)
  RPC_E_RETRY* = HRESULT(0x80010109)
  RPC_E_SERVERCALL_RETRYLATER* = HRESULT(0x8001010A)
  RPC_E_SERVERCALL_REJECTED* = HRESULT(0x8001010B)
  RPC_E_INVALID_CALLDATA* = HRESULT(0x8001010C)
  RPC_E_CANTCALLOUT_ININPUTSYNCCALL* = HRESULT(0x8001010D)
  RPC_E_WRONG_THREAD* = HRESULT(0x8001010E)
  RPC_E_THREAD_NOT_INIT* = HRESULT(0x8001010F)
  RPC_E_VERSION_MISMATCH* = HRESULT(0x80010110)
  RPC_E_INVALID_HEADER* = HRESULT(0x80010111)
  RPC_E_INVALID_EXTENSION* = HRESULT(0x80010112)
  RPC_E_INVALID_IPID* = HRESULT(0x80010113)
  RPC_E_INVALID_OBJECT* = HRESULT(0x80010114)
  RPC_S_CALLPENDING* = HRESULT(0x80010115)
  RPC_S_WAITONTIMER* = HRESULT(0x80010116)
  RPC_E_CALL_COMPLETE* = HRESULT(0x80010117)
  RPC_E_UNSECURE_CALL* = HRESULT(0x80010118)
  RPC_E_TOO_LATE* = HRESULT(0x80010119)
  RPC_E_NO_GOOD_SECURITY_PACKAGES* = HRESULT(0x8001011A)
  RPC_E_ACCESS_DENIED* = HRESULT(0x8001011B)
  RPC_E_REMOTE_DISABLED* = HRESULT(0x8001011C)
  RPC_E_INVALID_OBJREF* = HRESULT(0x8001011D)
  RPC_E_UNEXPECTED* = HRESULT(0x8001FFFF)
  NTE_BAD_UID* = HRESULT(0x80090001)
  NTE_BAD_HASH* = HRESULT(0x80090002)
  NTE_BAD_KEY* = HRESULT(0x80090003)
  NTE_BAD_LEN* = HRESULT(0x80090004)
  NTE_BAD_DATA* = HRESULT(0x80090005)
  NTE_BAD_SIGNATURE* = HRESULT(0x80090006)
  NTE_BAD_VER* = HRESULT(0x80090007)
  NTE_BAD_ALGID* = HRESULT(0x80090008)
  NTE_BAD_FLAGS* = HRESULT(0x80090009)
  NTE_BAD_TYPE* = HRESULT(0x8009000A)
  NTE_BAD_KEY_STATE* = HRESULT(0x8009000B)
  NTE_BAD_HASH_STATE* = HRESULT(0x8009000C)
  NTE_NO_KEY* = HRESULT(0x8009000D)
  NTE_NO_MEMORY* = HRESULT(0x8009000E)
  NTE_EXISTS* = HRESULT(0x8009000F)
  NTE_PERM* = HRESULT(0x80090010)
  NTE_NOT_FOUND* = HRESULT(0x80090011)
  NTE_DOUBLE_ENCRYPT* = HRESULT(0x80090012)
  NTE_BAD_PROVIDER* = HRESULT(0x80090013)
  NTE_BAD_PROV_TYPE* = HRESULT(0x80090014)
  NTE_BAD_PUBLIC_KEY* = HRESULT(0x80090015)
  NTE_BAD_KEYSET* = HRESULT(0x80090016)
  NTE_PROV_TYPE_NOT_DEF* = HRESULT(0x80090017)
  NTE_PROV_TYPE_ENTRY_BAD* = HRESULT(0x80090018)
  NTE_KEYSET_NOT_DEF* = HRESULT(0x80090019)
  NTE_KEYSET_ENTRY_BAD* = HRESULT(0x8009001A)
  NTE_PROV_TYPE_NO_MATCH* = HRESULT(0x8009001B)
  NTE_SIGNATURE_FILE_BAD* = HRESULT(0x8009001C)
  NTE_PROVIDER_DLL_FAIL* = HRESULT(0x8009001D)
  NTE_PROV_DLL_NOT_FOUND* = HRESULT(0x8009001E)
  NTE_BAD_KEYSET_PARAM* = HRESULT(0x8009001F)
  NTE_FAIL* = HRESULT(0x80090020)
  NTE_SYS_ERR* = HRESULT(0x80090021)
  NTE_OP_OK* = HRESULT(0)
  TRUST_E_PROVIDER_UNKNOWN* = HRESULT(0x800B0001)
  TRUST_E_ACTION_UNKNOWN* = HRESULT(0x800B0002)
  TRUST_E_SUBJECT_FORM_UNKNOWN* = HRESULT(0x800B0003)
  TRUST_E_SUBJECT_NOT_TRUSTED* = HRESULT(0x800B0004)
  DIGSIG_E_ENCODE* = HRESULT(0x800B0005)
  DIGSIG_E_DECODE* = HRESULT(0x800B0006)
  DIGSIG_E_EXTENSIBILITY* = HRESULT(0x800B0007)
  DIGSIG_E_CRYPTO* = HRESULT(0x800B0008)
  PERSIST_E_SIZEDEFINITE* = HRESULT(0x800B0009)
  PERSIST_E_SIZEINDEFINITE* = HRESULT(0x800B000A)
  PERSIST_E_NOTSELFSIZING* = HRESULT(0x800B000B)
  TRUST_E_NOSIGNATURE* = HRESULT(0x800B0100)
  CERT_E_EXPIRED* = HRESULT(0x800B0101)
  CERT_E_VALIDIYPERIODNESTING* = HRESULT(0x800B0102)
  CERT_E_ROLE* = HRESULT(0x800B0103)
  CERT_E_PATHLENCONST* = HRESULT(0x800B0104)
  CERT_E_CRITICAL* = HRESULT(0x800B0105)
  CERT_E_PURPOSE* = HRESULT(0x800B0106)
  CERT_E_ISSUERCHAINING* = HRESULT(0x800B0107)
  CERT_E_MALFORMED* = HRESULT(0x800B0108)
  CERT_E_UNTRUSTEDROOT* = HRESULT(0x800B0109)
  CERT_E_CHAINING* = HRESULT(0x800B010A)

proc UNICODE_NULL*(): WCHAR
const
  LF_FACESIZE* = 32
  LF_FULLFACESIZE* = 64
  ELF_VENDOR_SIZE* = 4
  SECURITY_STATIC_TRACKING* = 0
  SECURITY_DYNAMIC_TRACKING* = 1
  MAX_DEFAULTCHAR* = 2
  MAX_LEADBYTES* = 12
  EXCEPTION_MAXIMUM_PARAMETERS* = 15
  CCHDEVICENAME* = 32
  CCHFORMNAME* = 32
  MENU_TEXT_LEN* = 40
  MAX_LANA* = 254
  NCBNAMSZ* = 16
  NETBIOS_NAME_LEN* = 16
  OFS_MAXPATHNAME* = 128
  MAX_TAB_STOPS* = 32
  ANYSIZE_ARRAY* = 1
  RAS_MaxCallbackNumber* = 128
  RAS_MaxDeviceName* = 128
  RAS_MaxDeviceType* = 16
  RAS_MaxEntryName* = 256
  RAS_MaxIpAddress* = 15
  RAS_MaxIpxAddress* = 21
  RAS_MaxPhoneNumber* = 128
  UNLEN* = 256
  PWLEN* = 256
  CNLEN* = 15
  DNLEN* = 15
  # Unsigned types max
  MAXDWORD* = 0xFFFFFFFF
  MAXWORD* = 0x0000FFFF
  MAXBYTE* = 0x000000FF
  # Signed types max/min
  MINCHAR* = 0x00000080
  MAXCHAR* = 0x0000007F
  MINSHORT* = 0x00008000
  MAXSHORT* = 0x00007FFF
  MINLONG* = 0x80000000
  MAXLONG* = 0x7FFFFFFF
  # _llseek
  FILE_BEGIN* = 0
  FILE_CURRENT* = 1
  FILE_END* = 2
  # _lopen, LZOpenFile, OpenFile
  OF_READ* = 0
  OF_READWRITE* = 2
  OF_WRITE* = 1
  OF_SHARE_COMPAT* = 0
  OF_SHARE_DENY_NONE* = 64
  OF_SHARE_DENY_READ* = 48
  OF_SHARE_DENY_WRITE* = 32
  OF_SHARE_EXCLUSIVE* = 16
  OF_CANCEL* = 2048
  OF_CREATE* = 4096
  OF_DELETE* = 512
  OF_EXIST* = 16384
  OF_PARSE* = 256
  OF_PROMPT* = 8192
  OF_REOPEN* = 32768
  OF_VERIFY* = 1024
  # ActivateKeyboardLayout, LoadKeyboardLayout
  HKL_NEXT* = 1
  HKL_PREV* = 0
  KLF_REORDER* = 8
  KLF_UNLOADPREVIOUS* = 4
  KLF_ACTIVATE* = 1
  KLF_NOTELLSHELL* = 128
  KLF_REPLACELANG* = 16
  KLF_SUBSTITUTE_OK* = 2
  # AppendMenu
  MF_BITMAP* = 0x00000004
  MF_DISABLED* = 0x00000002
  MF_ENABLED* = 0
  MF_GRAYED* = 0x00000001
  MF_HELP* = 0x00004000
  MF_MENUBARBREAK* = 0x00000020
  MF_MENUBREAK* = 0x00000040
  MF_MOUSESELECT* = 0x00008000
  MF_OWNERDRAW* = 0x00000100
  MF_POPUP* = 0x00000010
  MF_SEPARATOR* = 0x00000800
  MF_STRING* = 0
  MF_SYSMENU* = 0x00002000
  MF_USECHECKBITMAPS* = 0x00000200
  # Ternary Raster Operations - BitBlt
  BLACKNESS* = 0x00000042
  NOTSRCERASE* = 0x001100A6
  NOTSRCCOPY* = 0x00330008
  SRCERASE* = 0x00440328
  DSTINVERT* = 0x00550009
  PATINVERT* = 0x005A0049
  SRCINVERT* = 0x00660046
  SRCAND* = 0x008800C6
  MERGEPAINT* = 0x00BB0226
  MERGECOPY* = 0x00C000CA
  SRCCOPY* = 0x00CC0020
  SRCPAINT* = 0x00EE0086
  PATCOPY* = 0x00F00021
  PATPAINT* = 0x00FB0A09
  WHITENESS* = 0x00FF0062
  # Binary Raster Operations
  R2_BLACK* = 1
  R2_COPYPEN* = 13
  R2_MASKNOTPEN* = 3
  R2_MASKPEN* = 9
  R2_MASKPENNOT* = 5
  R2_MERGENOTPEN* = 12
  R2_MERGEPEN* = 15
  R2_MERGEPENNOT* = 14
  R2_NOP* = 11
  R2_NOT* = 6
  R2_NOTCOPYPEN* = 4
  R2_NOTMASKPEN* = 8
  R2_NOTMERGEPEN* = 2
  R2_NOTXORPEN* = 10
  R2_WHITE* = 16
  R2_XORPEN* = 7
  # BroadcastSystemMessage
  BSF_FLUSHDISK* = 4
  BSF_FORCEIFHUNG* = 32
  BSF_IGNORECURRENTTASK* = 2
  BSF_NOHANG* = 8
  BSF_POSTMESSAGE* = 16
  BSF_QUERY* = 1
  BSM_ALLCOMPONENTS* = 0
  BSM_APPLICATIONS* = 8
  BSM_INSTALLABLEDRIVERS* = 4
  BSM_NETDRIVER* = 2
  BSM_VXDS* = 1
  BROADCAST_QUERY_DENY* = 1112363332
                                     # CallNamedPipe
  NMPWAIT_NOWAIT* = 1
  NMPWAIT_WAIT_FOREVER* = -1
  NMPWAIT_USE_DEFAULT_WAIT* = 0
  # CascadeWindows, TileWindows
  MDITILE_SKIPDISABLED* = 2
  MDITILE_HORIZONTAL* = 1
  MDITILE_VERTICAL* = 0
  # CBTProc
  HCBT_ACTIVATE* = 5
  HCBT_CLICKSKIPPED* = 6
  HCBT_CREATEWND* = 3
  HCBT_DESTROYWND* = 4
  HCBT_KEYSKIPPED* = 7
  HCBT_MINMAX* = 1
  HCBT_MOVESIZE* = 0
  HCBT_QS* = 2
  HCBT_SETFOCUS* = 9
  HCBT_SYSCOMMAND* = 8

  CDS_UPDATEREGISTRY* = 1
  CDS_TEST* = 2
  CDS_FULLSCREEN* = 4
  CDS_GLOBAL* = 8
  CDS_SET_PRIMARY* = 0x00000010
  CDS_RESET* = 0x40000000
  CDS_SETRECT* = 0x20000000
  CDS_NORESET* = 0x10000000
  DISP_CHANGE_SUCCESSFUL* = 0
  DISP_CHANGE_RESTART* = 1
  DISP_CHANGE_BADFLAGS* = -4
  DISP_CHANGE_FAILED* = -1
  DISP_CHANGE_BADMODE* = -2
  DISP_CHANGE_NOTUPDATED* = -3
  # ChangeServiceConfig
  SERVICE_NO_CHANGE* = -1
  SERVICE_WIN32_OWN_PROCESS* = 16
  SERVICE_WIN32_SHARE_PROCESS* = 32
  SERVICE_KERNEL_DRIVER* = 1
  SERVICE_FILE_SYSTEM_DRIVER* = 2
  SERVICE_INTERACTIVE_PROCESS* = 256
  SERVICE_BOOT_START* = 0
  SERVICE_SYSTEM_START* = 1
  SERVICE_AUTO_START* = 2
  SERVICE_DEMAND_START* = 3
  SERVICE_DISABLED* = 4
  SERVICE_STOPPED* = 1
  SERVICE_START_PENDING* = 2
  SERVICE_STOP_PENDING* = 3
  SERVICE_RUNNING* = 4
  SERVICE_CONTINUE_PENDING* = 5
  SERVICE_PAUSE_PENDING* = 6
  SERVICE_PAUSED* = 7
  SERVICE_ACCEPT_STOP* = 1
  SERVICE_ACCEPT_PAUSE_CONTINUE* = 2
  SERVICE_ACCEPT_SHUTDOWN* = 4
  # CheckDlgButton
  BST_CHECKED* = 1
  BST_INDETERMINATE* = 2
  BST_UNCHECKED* = 0
  BST_FOCUS* = 8
  BST_PUSHED* = 4
  # CheckMenuItem, HiliteMenuItem
  MF_BYCOMMAND* = 0
  MF_BYPOSITION* = 0x00000400
  MF_CHECKED* = 0x00000008
  MF_UNCHECKED* = 0
  MF_HILITE* = 0x00000080
  MF_UNHILITE* = 0
  # ChildWindowFromPointEx
  CWP_ALL* = 0
  CWP_SKIPINVISIBLE* = 1
  CWP_SKIPDISABLED* = 2
  CWP_SKIPTRANSPARENT* = 4
  # ClearCommError
  CE_BREAK* = 16
  CE_DNS* = 2048
  CE_FRAME* = 8
  CE_IOE* = 1024
  CE_MODE* = 32768
  CE_OOP* = 4096
  CE_OVERRUN* = 2
  CE_PTO* = 512
  CE_RXOVER* = 1
  CE_RXPARITY* = 4
  CE_TXFULL* = 256
                              # CombineRgn
  RGN_AND* = 1
  RGN_COPY* = 5
  RGN_DIFF* = 4
  RGN_OR* = 2
  RGN_XOR* = 3
  NULLREGION* = 1
  SIMPLEREGION* = 2
  COMPLEXREGION* = 3
  ERROR* = 0
  # CommonDlgExtendedError
  CDERR_DIALOGFAILURE* = 0x0000FFFF
  CDERR_FINDRESFAILURE* = 6
  CDERR_INITIALIZATION* = 2
  CDERR_LOADRESFAILURE* = 7
  CDERR_LOADSTRFAILURE* = 5
  CDERR_LOCKRESFAILURE* = 8
  CDERR_MEMALLOCFAILURE* = 9
  CDERR_MEMLOCKFAILURE* = 10
  CDERR_NOHINSTANCE* = 4
  CDERR_NOHOOK* = 11
  CDERR_NOTEMPLATE* = 3
  CDERR_REGISTERMSGFAIL* = 12
  CDERR_STRUCTSIZE* = 1
  PDERR_CREATEICFAILURE* = 0x00001000 + 10
  PDERR_DEFAULTDIFFERENT* = 0x00001000 + 12
  PDERR_DNDMMISMATCH* = 0x00001000 + 9
  PDERR_GETDEVMODEFAIL* = 0x00001000 + 5
  PDERR_INITFAILURE* = 0x00001000 + 6
  PDERR_LOADDRVFAILURE* = 0x00001000 + 4
  PDERR_NODEFAULTPRN* = 0x00001000 + 8
  PDERR_NODEVICES* = 0x00001000 + 7
  PDERR_PARSEFAILURE* = 0x00001000 + 2
  PDERR_PRINTERNOTFOUND* = 0x00001000 + 11
  PDERR_RETDEFFAILURE* = 0x00001000 + 3
  PDERR_SETUPFAILURE* = 0x00001000 + 1
  CFERR_MAXLESSTHANMIN* = 0x00002000 + 2
  CFERR_NOFONTS* = 0x00002000 + 1
  FNERR_BUFFERTOOSMALL* = 0x00003000 + 3
  FNERR_INVALIDFILENAME* = 0x00003000 + 2
  FNERR_SUBCLASSFAILURE* = 0x00003000 + 1
  FRERR_BUFFERLENGTHZERO* = 0x00004000 + 1
  # CompareString, LCMapString
  LOCALE_SYSTEM_DEFAULT* = 0x00000800
  LOCALE_USER_DEFAULT* = 0x00000400
  NORM_IGNORECASE* = 1
  NORM_IGNOREKANATYPE* = 65536
  NORM_IGNORENONSPACE* = 2
  NORM_IGNORESYMBOLS* = 4
  NORM_IGNOREWIDTH* = 131072
  SORT_STRINGSORT* = 4096
  LCMAP_BYTEREV* = 2048
  LCMAP_FULLWIDTH* = 8388608
  LCMAP_HALFWIDTH* = 4194304
  LCMAP_HIRAGANA* = 1048576
  LCMAP_KATAKANA* = 2097152
  LCMAP_LOWERCASE* = 256
  LCMAP_SORTKEY* = 1024
  LCMAP_UPPERCASE* = 512
  # ContinueDebugEvent
  DBG_CONTINUE* = 0x00010002
  DBG_CONTROL_BREAK* = 0x40010008
  DBG_CONTROL_C* = 0x40010005
  DBG_EXCEPTION_NOT_HANDLED* = 0x80010001
  DBG_TERMINATE_THREAD* = 0x40010003
  DBG_TERMINATE_PROCESS* = 0x40010004
  # ControlService
  SERVICE_CONTROL_STOP* = 1
  SERVICE_CONTROL_PAUSE* = 2
  SERVICE_CONTROL_CONTINUE* = 3
  SERVICE_CONTROL_INTERROGATE* = 4
  SERVICE_CONTROL_SHUTDOWN* = 5
  # CopyImage, LoadImage
  IMAGE_BITMAP* = 0
  IMAGE_CURSOR* = 2
  IMAGE_ENHMETAFILE* = 1
  IMAGE_ICON* = 1
  LR_MONOCHROME* = 1
  LR_COLOR* = 2
  LR_COPYRETURNORG* = 4
  LR_COPYDELETEORG* = 8
  LR_DEFAULTSIZE* = 64
  LR_CREATEDIBSECTION* = 8192
  LR_COPYFROMRESOURCE* = 0x00004000
  LR_SHARED* = 0x00008000
  # CreateDesktop
  DF_ALLOWOTHERACCOUNTHOOK* = 0x00000001
  DESKTOP_CREATEMENU* = 0x00000004
  DESKTOP_CREATEWINDOW* = 0x00000002
  DESKTOP_ENUMERATE* = 0x00000040
  DESKTOP_HOOKCONTROL* = 0x00000008
  DESKTOP_JOURNALPLAYBACK* = 0x00000020
  DESKTOP_JOURNALRECORD* = 0x00000010
  DESKTOP_READOBJECTS* = 0x00000001
  DESKTOP_SWITCHDESKTOP* = 0x00000100
  DESKTOP_WRITEOBJECTS* = 0x00000080
  WSF_VISIBLE* = 0x00000001
  # CreateDIBitmap
  CBM_INIT* = 0x00000004
  DIB_PAL_COLORS* = 1
  DIB_RGB_COLORS* = 0
  # CreateFile, GetFileAttributes, SetFileAttributes
  GENERIC_READ* = 0x80000000
  GENERIC_WRITE* = 0x40000000
  FILE_READ_DATA* = 0x00000001 # file & pipe
  FILE_LIST_DIRECTORY* = 0x00000001 # directory
  FILE_WRITE_DATA* = 0x00000002 # file & pipe
  FILE_ADD_FILE* = 0x00000002 # directory
  FILE_APPEND_DATA* = 0x00000004 # file
  FILE_ADD_SUBDIRECTORY* = 0x00000004 # directory
  FILE_CREATE_PIPE_INSTANCE* = 0x00000004 # named pipe
  FILE_READ_EA* = 0x00000008 # file & directory
  FILE_READ_PROPERTIES* = FILE_READ_EA
  FILE_WRITE_EA* = 0x00000010 # file & directory
  FILE_WRITE_PROPERTIES* = FILE_WRITE_EA
  FILE_EXECUTE* = 0x00000020 # file
  FILE_TRAVERSE* = 0x00000020 # directory
  FILE_DELETE_CHILD* = 0x00000040 # directory
  FILE_READ_ATTRIBUTES* = 0x00000080 # all
  FILE_WRITE_ATTRIBUTES* = 0x00000100 # all
  FILE_SHARE_DELETE* = 4
  FILE_SHARE_READ* = 1
  FILE_SHARE_WRITE* = 2
  CONSOLE_TEXTMODE_BUFFER* = 1
  CREATE_NEW* = 1
  CREATE_ALWAYS* = 2
  OPEN_EXISTING* = 3
  OPEN_ALWAYS* = 4
  TRUNCATE_EXISTING* = 5
  FILE_ATTRIBUTE_ARCHIVE* = 32
  FILE_ATTRIBUTE_COMPRESSED* = 2048
  FILE_ATTRIBUTE_NORMAL* = 128
  FILE_ATTRIBUTE_DIRECTORY* = 16
  FILE_ATTRIBUTE_HIDDEN* = 2
  FILE_ATTRIBUTE_READONLY* = 1
  FILE_ATTRIBUTE_SYSTEM* = 4
  FILE_ATTRIBUTE_TEMPORARY* = 256
  FILE_FLAG_WRITE_THROUGH* = 0x80000000
  FILE_FLAG_OVERLAPPED* = 1073741824
  FILE_FLAG_NO_BUFFERING* = 536870912
  FILE_FLAG_RANDOM_ACCESS* = 268435456
  FILE_FLAG_SEQUENTIAL_SCAN* = 134217728
  FILE_FLAG_DELETE_ON_CLOSE* = 67108864
  FILE_FLAG_BACKUP_SEMANTICS* = 33554432
  FILE_FLAG_POSIX_SEMANTICS* = 16777216
  cSECURITY_ANONYMOUS* = 0
  cSECURITY_IDENTIFICATION* = 65536
  cSECURITY_IMPERSONATION* = 131072
  cSECURITY_DELEGATION* = 196608
  cSECURITY_CONTEXT_TRACKING* = 262144
  cSECURITY_EFFECTIVE_ONLY* = 524288
  cSECURITY_SQOS_PRESENT* = 1048576
  # CreateFileMapping, VirtualAlloc, VirtualFree, VirtualProtect
  SEC_COMMIT* = 134217728
  SEC_IMAGE* = 16777216
  SEC_NOCACHE* = 268435456
  SEC_RESERVE* = 67108864
  PAGE_READONLY* = 2
  PAGE_READWRITE* = 4
  PAGE_WRITECOPY* = 8
  PAGE_EXECUTE* = 16
  PAGE_EXECUTE_READ* = 32
  PAGE_EXECUTE_READWRITE* = 64
  PAGE_EXECUTE_WRITECOPY* = 128
  PAGE_GUARD* = 256
  PAGE_NOACCESS* = 1
  PAGE_NOCACHE* = 512
  MEM_COMMIT* = 4096
  MEM_FREE* = 65536
  MEM_RESERVE* = 8192
  MEM_IMAGE* = 16777216
  MEM_MAPPED* = 262144
  MEM_PRIVATE* = 131072
  MEM_DECOMMIT* = 16384
  MEM_RELEASE* = 32768
  MEM_TOP_DOWN* = 1048576
  EXCEPTION_GUARD_PAGE* = 0x80000001
  SECTION_EXTEND_SIZE* = 0x00000010
  SECTION_MAP_READ* = 0x00000004
  SECTION_MAP_WRITE* = 0x00000002
  SECTION_QUERY* = 0x00000001
  SECTION_ALL_ACCESS* = 0x000F001F
  # CreateFont
  FW_DONTCARE* = 0
  FW_THIN* = 100
  FW_EXTRALIGHT* = 200
  FW_LIGHT* = 300
  FW_NORMAL* = 400
  FW_REGULAR* = FW_NORMAL
  FW_MEDIUM* = 500
  FW_SEMIBOLD* = 600
  FW_BOLD* = 700
  FW_EXTRABOLD* = 800
  FW_HEAVY* = 900
  ANSI_CHARSET* = 0
  DEFAULT_CHARSET* = 1
  SYMBOL_CHARSET* = 2
  SHIFTJIS_CHARSET* = 128
  HANGEUL_CHARSET* = 129
  GB2312_CHARSET* = 134
  CHINESEBIG5_CHARSET* = 136
  GREEK_CHARSET* = 161
  TURKISH_CHARSET* = 162
  HEBREW_CHARSET* = 177
  ARABIC_CHARSET* = 178
  BALTIC_CHARSET* = 186
  RUSSIAN_CHARSET* = 204
  THAI_CHARSET* = 222
  EASTEUROPE_CHARSET* = 238
  OEM_CHARSET* = 255
  OUT_DEFAULT_PRECIS* = 0
  OUT_STRING_PRECIS* = 1
  OUT_CHARACTER_PRECIS* = 2
  OUT_STROKE_PRECIS* = 3
  OUT_TT_PRECIS* = 4
  OUT_DEVICE_PRECIS* = 5
  OUT_RASTER_PRECIS* = 6
  OUT_TT_ONLY_PRECIS* = 7
  OUT_OUTLINE_PRECIS* = 8
  CLIP_DEFAULT_PRECIS* = 0
  CLIP_CHARACTER_PRECIS* = 1
  CLIP_STROKE_PRECIS* = 2
  CLIP_MASK* = 15
  CLIP_LH_ANGLES* = 16
  CLIP_TT_ALWAYS* = 32
  CLIP_EMBEDDED* = 128
  DEFAULT_QUALITY* = 0
  DRAFT_QUALITY* = 1
  PROOF_QUALITY* = 2
  NONANTIALIASED_QUALITY* = 3
  ANTIALIASED_QUALITY* = 4
  DEFAULT_PITCH* = 0
  FIXED_PITCH* = 1
  VARIABLE_PITCH* = 2
  MONO_FONT* = 8
  FF_DECORATIVE* = 80
  FF_DONTCARE* = 0
  FF_MODERN* = 48
  FF_ROMAN* = 16
  FF_SCRIPT* = 64
  FF_SWISS* = 32
  # CreateHatchBrush
  HS_BDIAGONAL* = 3
  HS_CROSS* = 4
  HS_DIAGCROSS* = 5
  HS_FDIAGONAL* = 2
  HS_HORIZONTAL* = 0
  HS_VERTICAL* = 1
  # CreateIconFromResourceEx
  LR_DEFAULTCOLOR* = 0
  LR_LOADREALSIZE* = 128
                              # CreateMailslot, GetMailslotInfo
  MAILSLOT_WAIT_FOREVER* = 0xFFFFFFFF
  MAILSLOT_NO_MESSAGE* = 0xFFFFFFFF
  # CreateMappedBitmap
  CMB_MASKED* = 2
  # CreateNamedPipe
  PIPE_ACCESS_DUPLEX* = 3
  PIPE_ACCESS_INBOUND* = 1
  PIPE_ACCESS_OUTBOUND* = 2
  WRITE_DAC* = 0x00040000
  WRITE_OWNER* = 0x00080000
  ACCESS_SYSTEM_SECURITY* = 0x01000000
  PIPE_TYPE_BYTE* = 0
  PIPE_TYPE_MESSAGE* = 4
  PIPE_READMODE_BYTE* = 0
  PIPE_READMODE_MESSAGE* = 2
  PIPE_WAIT* = 0
  PIPE_NOWAIT* = 1
  # CreatePen, ExtCreatePen
  PS_GEOMETRIC* = 65536
  PS_COSMETIC* = 0
  PS_ALTERNATE* = 8
  PS_SOLID* = 0
  PS_DASH* = 1
  PS_DOT* = 2
  PS_DASHDOT* = 3
  PS_DASHDOTDOT* = 4
  PS_NULL* = 5
  PS_USERSTYLE* = 7
  PS_INSIDEFRAME* = 6
  PS_ENDCAP_ROUND* = 0
  PS_ENDCAP_SQUARE* = 256
  PS_ENDCAP_FLAT* = 512
  PS_JOIN_BEVEL* = 4096
  PS_JOIN_MITER* = 8192
  PS_JOIN_ROUND* = 0
  PS_STYLE_MASK* = 15
  PS_ENDCAP_MASK* = 3840
  PS_TYPE_MASK* = 983040
  # CreatePolygonRgn
  ALTERNATE* = 1
  WINDING* = 2
  # CreateProcess
  CREATE_DEFAULT_ERROR_MODE* = 67108864
  CREATE_NEW_CONSOLE* = 16
  CREATE_NEW_PROCESS_GROUP* = 512
  CREATE_SEPARATE_WOW_VDM* = 2048
  CREATE_SUSPENDED* = 4
  CREATE_UNICODE_ENVIRONMENT* = 1024
  DEBUG_PROCESS* = 1
  DEBUG_ONLY_THIS_PROCESS* = 2
  DETACHED_PROCESS* = 8
  HIGH_PRIORITY_CLASS* = 128
  IDLE_PRIORITY_CLASS* = 64
  NORMAL_PRIORITY_CLASS* = 32
  REALTIME_PRIORITY_CLASS* = 256
  # CreateService
  SERVICE_ALL_ACCESS* = 0x000F01FF
  SERVICE_CHANGE_CONFIG* = 2
  SERVICE_ENUMERATE_DEPENDENTS* = 8
  SERVICE_INTERROGATE* = 128
  SERVICE_PAUSE_CONTINUE* = 64
  SERVICE_QUERY_CONFIG* = 1
  SERVICE_QUERY_STATUS* = 4
  SERVICE_START* = 16
  SERVICE_STOP* = 32
  SERVICE_USER_DEFINED_CONTROL* = 256
  SERVICE_DELETE* = 0x00010000
  SERVICE_READ_CONTROL* = 0x00020000
  SERVICE_GENERIC_EXECUTE* = 0x20000000
  SERVICE_ERROR_IGNORE* = 0
  SERVICE_ERROR_NORMAL* = 1
  SERVICE_ERROR_SEVERE* = 2
  SERVICE_ERROR_CRITICAL* = 3
  # CreateTapePartition, WriteTapemark
  TAPE_FIXED_PARTITIONS* = 0
  TAPE_INITIATOR_PARTITIONS* = 0x00000002
  TAPE_SELECT_PARTITIONS* = 0x00000001
  TAPE_FILEMARKS* = 0x00000001
  TAPE_LONG_FILEMARKS* = 0x00000003
  TAPE_SETMARKS* = 0
  TAPE_SHORT_FILEMARKS* = 0x00000002
  # CreateWindow
  CW_USEDEFAULT* = int32(0x80000000)
  WS_BORDER* = 0x00800000
  WS_CAPTION* = 0x00C00000
  WS_CHILD* = 0x40000000
  WS_CHILDWINDOW* = 0x40000000
  WS_CLIPCHILDREN* = 0x02000000
  WS_CLIPSIBLINGS* = 0x04000000
  WS_DISABLED* = 0x08000000
  WS_DLGFRAME* = 0x00400000
  WS_GROUP* = 0x00020000
  WS_HSCROLL* = 0x00100000
  WS_ICONIC* = 0x20000000
  WS_MAXIMIZE* = 0x01000000
  WS_MAXIMIZEBOX* = 0x00010000
  WS_MINIMIZE* = 0x20000000
  WS_MINIMIZEBOX* = 0x00020000
  WS_OVERLAPPED* = 0
  WS_OVERLAPPEDWINDOW* = 0x00CF0000
  WS_POPUP* = LONG(0x80000000)
  WS_POPUPWINDOW* = LONG(0x80880000)
  WS_SIZEBOX* = 0x00040000
  WS_SYSMENU* = 0x00080000
  WS_TABSTOP* = 0x00010000
  WS_THICKFRAME* = 0x00040000

  WS_TILED* = 0
  WS_TILEDWINDOW* = 0x00CF0000
  WS_VISIBLE* = 0x10000000
  WS_VSCROLL* = 0x00200000
  MDIS_ALLCHILDSTYLES* = 0x00000001
  BS_3STATE* = 0x00000005
  BS_AUTO3STATE* = 0x00000006
  BS_AUTOCHECKBOX* = 0x00000003
  BS_AUTORADIOBUTTON* = 0x00000009
  BS_BITMAP* = 0x00000080
  BS_BOTTOM* = 0x00000800
  BS_CENTER* = 0x00000300
  BS_CHECKBOX* = 0x00000002
  BS_DEFPUSHBUTTON* = 0x00000001
  BS_GROUPBOX* = 0x00000007
  BS_ICON* = 0x00000040
  BS_LEFT* = 0x00000100
  BS_LEFTTEXT* = 0x00000020
  BS_MULTILINE* = 0x00002000
  BS_NOTIFY* = 0x00004000
  BS_OWNERDRAW* = 0x0000000B
  BS_PUSHBUTTON* = 0
  BS_PUSHLIKE* = 0x00001000
  BS_RADIOBUTTON* = 0x00000004
  BS_RIGHT* = 0x00000200
  BS_RIGHTBUTTON* = 0x00000020
  BS_TEXT* = 0
  BS_TOP* = 0x00000400
  BS_USERBUTTON* = 0x00000008
  BS_VCENTER* = 0x00000C00
  BS_FLAT* = 0x00008000
  CBS_AUTOHSCROLL* = 0x00000040
  CBS_DISABLENOSCROLL* = 0x00000800
  CBS_DROPDOWN* = 0x00000002
  CBS_DROPDOWNLIST* = 0x00000003
  CBS_HASSTRINGS* = 0x00000200
  CBS_LOWERCASE* = 0x00004000
  CBS_NOINTEGRALHEIGHT* = 0x00000400
  CBS_OEMCONVERT* = 0x00000080
  CBS_OWNERDRAWFIXED* = 0x00000010
  CBS_OWNERDRAWVARIABLE* = 0x00000020
  CBS_SIMPLE* = 0x00000001
  CBS_SORT* = 0x00000100
  CBS_UPPERCASE* = 0x00002000
  ES_AUTOHSCROLL* = 0x00000080
  ES_AUTOVSCROLL* = 0x00000040
  ES_CENTER* = 0x00000001
  ES_LEFT* = 0
  ES_LOWERCASE* = 0x00000010
  ES_MULTILINE* = 0x00000004
  ES_NOHIDESEL* = 0x00000100
  ES_NUMBER* = 0x00002000
  ES_OEMCONVERT* = 0x00000400
  ES_PASSWORD* = 0x00000020
  ES_READONLY* = 0x00000800
  ES_RIGHT* = 0x00000002
  ES_UPPERCASE* = 0x00000008
  ES_WANTRETURN* = 0x00001000
  LBS_DISABLENOSCROLL* = 0x00001000
  LBS_EXTENDEDSEL* = 0x00000800
  LBS_HASSTRINGS* = 0x00000040
  LBS_MULTICOLUMN* = 0x00000200
  LBS_MULTIPLESEL* = 0x00000008
  LBS_NODATA* = 0x00002000
  LBS_NOINTEGRALHEIGHT* = 0x00000100
  LBS_NOREDRAW* = 0x00000004
  LBS_NOSEL* = 0x00004000
  LBS_NOTIFY* = 0x00000001
  LBS_OWNERDRAWFIXED* = 0x00000010
  LBS_OWNERDRAWVARIABLE* = 0x00000020
  LBS_SORT* = 0x00000002
  LBS_STANDARD* = 0x00A00003
  LBS_USETABSTOPS* = 0x00000080
  LBS_WANTKEYBOARDINPUT* = 0x00000400
  SBS_BOTTOMALIGN* = 0x00000004
  SBS_HORZ* = 0
  SBS_LEFTALIGN* = 0x00000002
  SBS_RIGHTALIGN* = 0x00000004
  SBS_SIZEBOX* = 0x00000008
  SBS_SIZEBOXBOTTOMRIGHTALIGN* = 0x00000004
  SBS_SIZEBOXTOPLEFTALIGN* = 0x00000002
  SBS_SIZEGRIP* = 0x00000010
  SBS_TOPALIGN* = 0x00000002
  SBS_VERT* = 0x00000001
  SS_BITMAP* = 0x0000000E
  SS_BLACKFRAME* = 0x00000007
  SS_BLACKRECT* = 0x00000004
  SS_CENTER* = 0x00000001
  SS_CENTERIMAGE* = 0x00000200
  SS_ENHMETAFILE* = 0x0000000F
  SS_ETCHEDFRAME* = 0x00000012
  SS_ETCHEDHORZ* = 0x00000010
  SS_ETCHEDVERT* = 0x00000011
  SS_GRAYFRAME* = 0x00000008
  SS_GRAYRECT* = 0x00000005
  SS_ICON* = 0x00000003
  SS_LEFT* = 0
  SS_LEFTNOWORDWRAP* = 0x0000000C
  SS_NOPREFIX* = 0x00000080
  SS_NOTIFY* = 0x00000100
  SS_OWNERDRAW* = 0x0000000D
  SS_REALSIZEIMAGE* = 0x00000800
  SS_RIGHT* = 0x00000002
  SS_RIGHTJUST* = 0x00000400
  SS_SIMPLE* = 0x0000000B
  SS_SUNKEN* = 0x00001000
  SS_USERITEM* = 0x0000000A
  SS_WHITEFRAME* = 0x00000009
  SS_WHITERECT* = 0x00000006
  DS_3DLOOK* = 0x00000004
  DS_ABSALIGN* = 0x00000001
  DS_CENTER* = 0x00000800
  DS_CENTERMOUSE* = 0x00001000
  DS_CONTEXTHELP* = 0x00002000
  DS_CONTROL* = 0x00000400
  DS_FIXEDSYS* = 0x00000008
  DS_LOCALEDIT* = 0x00000020
  DS_MODALFRAME* = 0x00000080
  DS_NOFAILCREATE* = 0x00000010
  DS_NOIDLEMSG* = 0x00000100
  DS_SETFONT* = 0x00000040
  DS_SETFOREGROUND* = 0x00000200
  DS_SYSMODAL* = 0x00000002
  # CreateWindowEx
  WS_EX_ACCEPTFILES* = 0x00000010
  WS_EX_APPWINDOW* = 0x00040000
  WS_EX_CLIENTEDGE* = 0x00000200
  WS_EX_CONTEXTHELP* = 0x00000400
  WS_EX_CONTROLPARENT* = 0x00010000
  WS_EX_DLGMODALFRAME* = 0x00000001
  WS_EX_LEFT* = 0
  WS_EX_LEFTSCROLLBAR* = 0x00004000
  WS_EX_LTRREADING* = 0
  WS_EX_MDICHILD* = 0x00000040
  WS_EX_NOPARENTNOTIFY* = 0x00000004
  WS_EX_OVERLAPPEDWINDOW* = 0x00000300
  WS_EX_PALETTEWINDOW* = 0x00000188
  WS_EX_RIGHT* = 0x00001000
  WS_EX_RIGHTSCROLLBAR* = 0
  WS_EX_RTLREADING* = 0x00002000
  WS_EX_STATICEDGE* = 0x00020000
  WS_EX_TOOLWINDOW* = 0x00000080
  WS_EX_TOPMOST* = 0x00000008
  WS_EX_TRANSPARENT* = 0x00000020
  WS_EX_WINDOWEDGE* = 0x00000100
  # CreateWindowStation
  WINSTA_ACCESSCLIPBOARD* = 0x00000004
  WINSTA_ACCESSGLOBALATOMS* = 0x00000020
  WINSTA_CREATEDESKTOP* = 0x00000008
  WINSTA_ENUMDESKTOPS* = 0x00000001
  WINSTA_ENUMERATE* = 0x00000100
  WINSTA_EXITWINDOWS* = 0x00000040
  WINSTA_READATTRIBUTES* = 0x00000002
  WINSTA_READSCREEN* = 0x00000200
  WINSTA_WRITEATTRIBUTES* = 0x00000010
  # DdeCallback
  # DdeClientTransaction
  # DdeEnableCallback
  # DdeGetLastError
  # DdeInitialize
  # DdeNameService
  # DebugProc
  WH_CALLWNDPROC* = 4
  WH_CALLWNDPROCRET* = 12
  WH_CBT* = 5
  WH_DEBUG* = 9
  WH_GETMESSAGE* = 3
  WH_JOURNALPLAYBACK* = 1
  WH_JOURNALRECORD* = 0
  WH_KEYBOARD* = 2
  WH_MOUSE* = 7
  WH_MSGFILTER* = -1
  WH_SHELL* = 10
  WH_SYSMSGFILTER* = 6
  WH_FOREGROUNDIDLE* = 11
  # DefineDosDevice
  DDD_RAW_TARGET_PATH* = 1
  DDD_REMOVE_DEFINITION* = 2
  DDD_EXACT_MATCH_ON_REMOVE* = 4
  # DeviceCapbilities
  DCTT_BITMAP* = 0x00000001
  DCTT_DOWNLOAD* = 0x00000002
  DCTT_SUBDEV* = 0x00000004
                              # DlgDirList
  DDL_ARCHIVE* = 32
  DDL_DIRECTORY* = 16
  DDL_DRIVES* = 16384
  DDL_EXCLUSIVE* = 32768
  DDL_HIDDEN* = 2
  DDL_READONLY* = 1
  DDL_READWRITE* = 0
  DDL_SYSTEM* = 4
  DDL_POSTMSGS* = 8192
  # DllEntryPoint
  DLL_PROCESS_ATTACH* = 1
  DLL_THREAD_ATTACH* = 2
  DLL_PROCESS_DETACH* = 0
  DLL_THREAD_DETACH* = 3
  # DrawAnimatedRects
  IDANI_OPEN* = 1
  IDANI_CLOSE* = 2
  # DrawCaption
  DC_ACTIVE* = 1
  DC_SMALLCAP* = 2
  # DrawEdge
  BDR_RAISEDINNER* = 4
  BDR_SUNKENINNER* = 8
  BDR_RAISEDOUTER* = 1
  BDR_SUNKENOUTER* = 2
  BDR_OUTER* = BDR_RAISEDOUTER or BDR_SUNKENOUTER
  BDR_INNER* = BDR_RAISEDINNER or BDR_SUNKENINNER
  BDR_RAISED* = BDR_RAISEDOUTER or BDR_RAISEDINNER
  BDR_SUNKEN* = BDR_SUNKENOUTER or BDR_SUNKENINNER
  EDGE_BUMP* = 9
  EDGE_ETCHED* = 6
  EDGE_RAISED* = 5
  EDGE_SUNKEN* = 10
  BF_ADJUST* = 8192
  BF_BOTTOM* = 8
  BF_BOTTOMLEFT* = 9
  BF_BOTTOMRIGHT* = 12
  BF_DIAGONAL* = 16
  BF_DIAGONAL_ENDBOTTOMLEFT* = 25
  BF_DIAGONAL_ENDBOTTOMRIGHT* = 28
  BF_DIAGONAL_ENDTOPLEFT* = 19
  BF_DIAGONAL_ENDTOPRIGHT* = 22
  BF_FLAT* = 16384
  BF_LEFT* = 1
  BF_MIDDLE* = 2048
  BF_MONO* = 32768
  BF_RECT* = 15
  BF_RIGHT* = 4
  BF_SOFT* = 4096
  BF_TOP* = 2
  BF_TOPLEFT* = 3
  BF_TOPRIGHT* = 6
  # DrawFrameControl
  DFC_BUTTON* = 4
  DFC_CAPTION* = 1
  DFC_MENU* = 2
  DFC_SCROLL* = 3
  DFCS_BUTTON3STATE* = 8
  DFCS_BUTTONCHECK* = 0
  DFCS_BUTTONPUSH* = 16
  DFCS_BUTTONRADIO* = 4
  DFCS_BUTTONRADIOIMAGE* = 1
  DFCS_BUTTONRADIOMASK* = 2
  DFCS_CAPTIONCLOSE* = 0
  DFCS_CAPTIONHELP* = 4
  DFCS_CAPTIONMAX* = 2
  DFCS_CAPTIONMIN* = 1
  DFCS_CAPTIONRESTORE* = 3
  DFCS_MENUARROW* = 0
  DFCS_MENUBULLET* = 2
  DFCS_MENUCHECK* = 1
  DFCS_SCROLLCOMBOBOX* = 5
  DFCS_SCROLLDOWN* = 1
  DFCS_SCROLLLEFT* = 2
  DFCS_SCROLLRIGHT* = 3
  DFCS_SCROLLSIZEGRIP* = 8
  DFCS_SCROLLUP* = 0
  DFCS_ADJUSTRECT* = 8192
  DFCS_CHECKED* = 1024
  DFCS_FLAT* = 16384
  DFCS_INACTIVE* = 256
  DFCS_MONO* = 32768
  DFCS_PUSHED* = 512
  # DrawIconEx
  DI_COMPAT* = 4
  DI_DEFAULTSIZE* = 8
  DI_IMAGE* = 2
  DI_MASK* = 1
  DI_NORMAL* = 3
  # DrawState
  DST_BITMAP* = 4
  DST_COMPLEX* = 0
  DST_ICON* = 3
  DST_PREFIXTEXT* = 2
  DST_TEXT* = 1
  DSS_NORMAL* = 0
  DSS_UNION* = 16
  DSS_DISABLED* = 32
  DSS_MONO* = 128
  # DrawStatusText
  SBT_NOBORDERS* = 256
  SBT_OWNERDRAW* = 4096
  SBT_POPOUT* = 512
  SBT_RTLREADING* = 1024
  # DrawText, DrawTextEx
  DT_BOTTOM* = 8
  DT_CALCRECT* = 1024
  DT_CENTER* = 1
  DT_EDITCONTROL* = 8192
  DT_END_ELLIPSIS* = 32768
  DT_PATH_ELLIPSIS* = 16384
  DT_EXPANDTABS* = 64
  DT_EXTERNALLEADING* = 512
  DT_LEFT* = 0
  DT_MODIFYSTRING* = 65536
  DT_NOCLIP* = 256
  DT_NOPREFIX* = 2048
  DT_RIGHT* = 2
  DT_RTLREADING* = 131072
  DT_SINGLELINE* = 32
  DT_TABSTOP* = 128
  DT_TOP* = 0
  DT_VCENTER* = 4
  DT_WORDBREAK* = 16
  DT_INTERNAL* = 4096
  DT_WORD_ELLIPSIS* = 0x00040000
  DT_HIDEPREFIX* = 0x00100000
  DT_PREFIXONLY* = 0x00200000
  # DuplicateHandle, MapViewOfFile
  DUPLICATE_CLOSE_SOURCE* = 1
  DUPLICATE_SAME_ACCESS* = 2
  FILE_MAP_ALL_ACCESS* = 0x000F001F
  FILE_MAP_READ* = 4
  FILE_MAP_WRITE* = 2
  FILE_MAP_COPY* = 1
  MUTEX_ALL_ACCESS* = 0x001F0001
  MUTEX_MODIFY_STATE* = 1
  SYNCHRONIZE* = 0x00100000
  SEMAPHORE_ALL_ACCESS* = 0x001F0003
  SEMAPHORE_MODIFY_STATE* = 2
  EVENT_ALL_ACCESS* = 0x001F0003
  EVENT_MODIFY_STATE* = 2
  KEY_ALL_ACCESS* = 0x000F003F
  KEY_CREATE_LINK* = 32
  KEY_CREATE_SUB_KEY* = 4
  KEY_ENUMERATE_SUB_KEYS* = 8
  KEY_EXECUTE* = 0x00020019
  KEY_NOTIFY* = 16
  KEY_QUERY_VALUE* = 1
  KEY_READ* = 0x00020019
  KEY_SET_VALUE* = 2
  KEY_WRITE* = 0x00020006
  PROCESS_ALL_ACCESS* = 0x001F0FFF
  PROCESS_CREATE_PROCESS* = 128
  PROCESS_CREATE_THREAD* = 2
  PROCESS_DUP_HANDLE* = 64
  PROCESS_QUERY_INFORMATION* = 1024
  PROCESS_SET_INFORMATION* = 512
  PROCESS_TERMINATE* = 1
  PROCESS_VM_OPERATION* = 8
  PROCESS_VM_READ* = 16
  PROCESS_VM_WRITE* = 32
  THREAD_ALL_ACCESS* = 0x001F03FF
  THREAD_DIRECT_IMPERSONATION* = 512
  THREAD_GET_CONTEXT* = 8
  THREAD_IMPERSONATE* = 256
  THREAD_QUERY_INFORMATION* = 64
  THREAD_SET_CONTEXT* = 16
  THREAD_SET_INFORMATION* = 32
  THREAD_SET_THREAD_TOKEN* = 128
  THREAD_SUSPEND_RESUME* = 2
  THREAD_TERMINATE* = 1
  # EditWordBreakProc
  WB_ISDELIMITER* = 2
  WB_LEFT* = 0
  WB_RIGHT* = 1
  # EnableScrollBar
  SB_BOTH* = 3
  SB_CTL* = 2
  SB_HORZ* = 0
  SB_VERT* = 1
  ESB_DISABLE_BOTH* = 3
  ESB_DISABLE_DOWN* = 2
  ESB_DISABLE_LEFT* = 1
  ESB_DISABLE_LTUP* = 1
  ESB_DISABLE_RIGHT* = 2
  ESB_DISABLE_RTDN* = 2
  ESB_DISABLE_UP* = 1
  ESB_ENABLE_BOTH* = 0
  # Scroll Bar notifications
  SB_LINEUP* = 0
  SB_LINEDOWN* = 1
  SB_LINELEFT* = 0
  SB_LINERIGHT* = 1
  SB_PAGEUP* = 2
  SB_PAGEDOWN* = 3
  SB_PAGELEFT* = 2
  SB_PAGERIGHT* = 3
  SB_THUMBPOSITION* = 4
  SB_THUMBTRACK* = 5
  SB_ENDSCROLL* = 8
  SB_LEFT* = 6
  SB_RIGHT* = 7
  SB_BOTTOM* = 7
  SB_TOP* = 6
  # EnumCalendarInfo
  ENUM_ALL_CALENDARS* = -1
  # EnumDateFormats
  # GetDateFormat
  DATE_SHORTDATE* = 1
  DATE_LONGDATE* = 2
  DATE_USE_ALT_CALENDAR* = 4
  # EnumDependentServices
  SERVICE_ACTIVE* = 1
  SERVICE_INACTIVE* = 2
  # EnumFontFamExProc
  DEVICE_FONTTYPE* = 2
  RASTER_FONTTYPE* = 1
  TRUETYPE_FONTTYPE* = 4
  # EnumObjects, GetCurrentObject, GetObjectType
  OBJ_BRUSH* = 2
  OBJ_PEN* = 1
  OBJ_PAL* = 5
  OBJ_FONT* = 6
  OBJ_BITMAP* = 7
  OBJ_EXTPEN* = 11
  OBJ_REGION* = 8
  OBJ_DC* = 3
  OBJ_MEMDC* = 10
  OBJ_METAFILE* = 9
  OBJ_METADC* = 4
  OBJ_ENHMETAFILE* = 13
  OBJ_ENHMETADC* = 12

                              #
                              # Predefined Resource Types
                              #
const
  RT_CURSOR* = cast[MAKEINTRESOURCE](1)
  RT_BITMAP* = cast[MAKEINTRESOURCE](2)
  RT_ICON* = cast[MAKEINTRESOURCE](3)
  RT_MENU* = cast[MAKEINTRESOURCE](4)
  RT_DIALOG* = cast[MAKEINTRESOURCE](5)
  RT_STRING* = cast[MAKEINTRESOURCE](6)
  RT_FONTDIR* = cast[MAKEINTRESOURCE](7)
  RT_FONT* = cast[MAKEINTRESOURCE](8)
  RT_ACCELERATOR* = cast[MAKEINTRESOURCE](9)
  RT_RCDATA* = cast[MAKEINTRESOURCE](10)
  RT_MESSAGETABLE* = cast[MAKEINTRESOURCE](11)
  DIFFERENCE* = 11
  RT_GROUP_CURSOR* = cast[MAKEINTRESOURCE](12)
  RT_GROUP_ICON* = cast[MAKEINTRESOURCE](14)
  RT_VERSION* = cast[MAKEINTRESOURCE](16)
  RT_DLGINCLUDE* = cast[MAKEINTRESOURCE](17)
  RT_PLUGPLAY* = cast[MAKEINTRESOURCE](19)
  RT_VXD* = cast[MAKEINTRESOURCE](20)
  RT_ANICURSOR* = cast[MAKEINTRESOURCE](21)
  RT_ANIICON* = cast[MAKEINTRESOURCE](22)
  RT_HTML* = cast[MAKEINTRESOURCE](23)
  RT_MANIFEST* = cast[MAKEINTRESOURCE](24)

const
  # EnumServicesStatus
  SERVICE_WIN32* = 48
  SERVICE_DRIVER* = 11
  # EnumSystemCodePages
  CP_INSTALLED* = 1
  CP_SUPPORTED* = 2
  # EnumSystemLocales
  LCID_INSTALLED* = 1
  LCID_SUPPORTED* = 2
  # EraseTape
  TAPE_ERASE_LONG* = 0x00000001
  TAPE_ERASE_SHORT* = 0
  # Escape
  SP_ERROR* = -1
  SP_OUTOFDISK* = -4
  SP_OUTOFMEMORY* = -5
  SP_USERABORT* = -3
  PHYSICALWIDTH* = 110
  PHYSICALHEIGHT* = 111
  PHYSICALOFFSETX* = 112
  PHYSICALOFFSETY* = 113
  SCALINGFACTORX* = 114
  SCALINGFACTORY* = 115
  QUERYESCSUPPORT* = 8
  #ABORTDOC = 2; conflicts with AbortDoc function
  cABORTDOC* = 2
  #ENDDOC = 11; conflicts with AbortDoc function
  cENDDOC* = 11
  GETPHYSPAGESIZE* = 12
  GETPRINTINGOFFSET* = 13
  GETSCALINGFACTOR* = 14
  NEWFRAME* = 1
  NEXTBAND* = 3
  PASSTHROUGH* = 19
  #SETABORTPROC = 9; conflicts with AbortDoc function
  cSETABORTPROC* = 9
  #STARTDOC = 10; conflicts with AbortDoc function
  cSTARTDOC* = 10
  # EscapeCommFunction
  CLRDTR* = 6
  CLRRTS* = 4
  SETDTR* = 5
  SETRTS* = 3
  SETXOFF* = 1
  SETXON* = 2
  SETBREAK* = 8
  CLRBREAK* = 9
  # ExitWindowsEx
  EWX_FORCE* = 4
  EWX_LOGOFF* = 0
  EWX_POWEROFF* = 8
  EWX_REBOOT* = 2
  EWX_SHUTDOWN* = 1
  # ExtFloodFill
  FLOODFILLBORDER* = 0
  FLOODFILLSURFACE* = 1
  # ExtTextOut
  ETO_CLIPPED* = 4
  ETO_GLYPH_INDEX* = 16
  ETO_OPAQUE* = 2
  ETO_RTLREADING* = 128
  # FillConsoleOutputAttribute
  FOREGROUND_BLUE* = 1
  FOREGROUND_GREEN* = 2
  FOREGROUND_RED* = 4
  FOREGROUND_INTENSITY* = 8
  BACKGROUND_BLUE* = 16
  BACKGROUND_GREEN* = 32
  BACKGROUND_RED* = 64
  BACKGROUND_INTENSITY* = 128
  # FindFirstChangeNotification
  FILE_NOTIFY_CHANGE_FILE_NAME* = 1
  FILE_NOTIFY_CHANGE_DIR_NAME* = 2
  FILE_NOTIFY_CHANGE_ATTRIBUTES* = 4
  FILE_NOTIFY_CHANGE_SIZE* = 8
  FILE_NOTIFY_CHANGE_LAST_WRITE* = 16
  FILE_NOTIFY_CHANGE_SECURITY* = 256
  # FindFirstPrinterChangeNotification
  # FindNextPrinterNotification
  # FMExtensionProc
  # FoldString
  MAP_FOLDCZONE* = 16
  MAP_FOLDDIGITS* = 128
  MAP_PRECOMPOSED* = 32
  MAP_COMPOSITE* = 64
  # ForegroundIdleProc
  HC_ACTION* = 0
  # FormatMessage
  FORMAT_MESSAGE_ALLOCATE_BUFFER* = 256
  FORMAT_MESSAGE_IGNORE_INSERTS* = 512
  FORMAT_MESSAGE_FROM_STRING* = 1024
  FORMAT_MESSAGE_FROM_HMODULE* = 2048
  FORMAT_MESSAGE_FROM_SYSTEM* = 4096
  FORMAT_MESSAGE_ARGUMENT_ARRAY* = 8192
  FORMAT_MESSAGE_MAX_WIDTH_MASK* = 255
  # GdiComment
  GDICOMMENT_WINDOWS_METAFILE* = -2147483647
  GDICOMMENT_BEGINGROUP* = 2
  GDICOMMENT_ENDGROUP* = 3
  GDICOMMENT_MULTIFORMATS* = 1073741828
  GDICOMMENT_IDENTIFIER* = 1128875079
  # GenerateConsoleCtrlEvent, HandlerRoutine
  CTRL_C_EVENT* = 0
  CTRL_BREAK_EVENT* = 1
  CTRL_CLOSE_EVENT* = 2
  CTRL_LOGOFF_EVENT* = 5
  CTRL_SHUTDOWN_EVENT* = 6
  # GetAddressByName
  # GetArcDirection
  AD_COUNTERCLOCKWISE* = 1
  AD_CLOCKWISE* = 2
  # GetBinaryTypes
  SCS_32BIT_BINARY* = 0
  SCS_DOS_BINARY* = 1
  SCS_OS216_BINARY* = 5
  SCS_PIF_BINARY* = 3
  SCS_POSIX_BINARY* = 4
  SCS_WOW_BINARY* = 2
  # GetBoundsRect, SetBoundsRect
  DCB_DISABLE* = 8
  DCB_ENABLE* = 4
  DCB_RESET* = 1
  DCB_SET* = 3
  DCB_ACCUMULATE* = 2
  # GetCharacterPlacement, GetFontLanguageInfo
  GCP_DBCS* = 1
  GCP_ERROR* = 0x00008000
  GCP_CLASSIN* = 0x00080000
  GCP_DIACRITIC* = 256
  GCP_DISPLAYZWG* = 0x00400000
  GCP_GLYPHSHAPE* = 16
  GCP_JUSTIFY* = 0x00010000
  GCP_JUSTIFYIN* = 0x00200000
  GCP_KASHIDA* = 1024
  GCP_LIGATE* = 32
  GCP_MAXEXTENT* = 0x00100000
  GCP_NEUTRALOVERRIDE* = 0x02000000
  GCP_NUMERICOVERRIDE* = 0x01000000
  GCP_NUMERICSLATIN* = 0x04000000
  GCP_NUMERICSLOCAL* = 0x08000000
  GCP_REORDER* = 2
  GCP_SYMSWAPOFF* = 0x00800000
  GCP_USEKERNING* = 8
  FLI_GLYPHS* = 0x00040000
  FLI_MASK* = 0x0000103B
  # GetClassLong, GetClassWord
  GCW_ATOM* = -32
  GCL_CBCLSEXTRA* = -20
  GCL_CBWNDEXTRA* = -18
  GCL_HBRBACKGROUND* = -10
  GCL_HCURSOR* = -12
  GCL_HICON* = -14
  GCL_HICONSM* = -34
  GCL_HMODULE* = -16
  GCL_MENUNAME* = -8
  GCL_STYLE* = -26
  GCL_WNDPROC* = -24
  # GetClipboardFormat, SetClipboardData
  CF_BITMAP* = 2
  CF_DIB* = 8
  CF_PALETTE* = 9
  CF_ENHMETAFILE* = 14
  CF_METAFILEPICT* = 3
  CF_OEMTEXT* = 7
  CF_TEXT* = 1
  CF_UNICODETEXT* = 13
  CF_DIF* = 5
  CF_DSPBITMAP* = 130
  CF_DSPENHMETAFILE* = 142
  CF_DSPMETAFILEPICT* = 131
  CF_DSPTEXT* = 129
  CF_GDIOBJFIRST* = 768
  CF_GDIOBJLAST* = 1023
  CF_HDROP* = 15
  CF_LOCALE* = 16
  CF_OWNERDISPLAY* = 128
  CF_PENDATA* = 10
  CF_PRIVATEFIRST* = 512
  CF_PRIVATELAST* = 767
  CF_RIFF* = 11
  CF_SYLK* = 4
  CF_WAVE* = 12
  CF_TIFF* = 6
  # GetCommMask
  EV_BREAK* = 64
  EV_CTS* = 8
  EV_DSR* = 16
  EV_ERR* = 128
  EV_EVENT1* = 2048
  EV_EVENT2* = 4096
  EV_PERR* = 512
  EV_RING* = 256
  EV_RLSD* = 32
  EV_RX80FULL* = 1024
  EV_RXCHAR* = 1
  EV_RXFLAG* = 2
  EV_TXEMPTY* = 4
  # GetCommModemStatus
  MS_CTS_ON* = 0x00000010
  MS_DSR_ON* = 0x00000020
  MS_RING_ON* = 0x00000040
  MS_RLSD_ON* = 0x00000080
  # GetComputerName
  MAX_COMPUTERNAME_LENGTH* = 15
  # GetConsoleMode
  ENABLE_LINE_INPUT* = 2
  ENABLE_ECHO_INPUT* = 4
  ENABLE_PROCESSED_INPUT* = 1
  ENABLE_WINDOW_INPUT* = 8
  ENABLE_MOUSE_INPUT* = 16
  ENABLE_PROCESSED_OUTPUT* = 1
  ENABLE_WRAP_AT_EOL_OUTPUT* = 2
  # GetCPInfo
  CP_ACP* = 0
  CP_MACCP* = 2
  CP_OEMCP* = 1
  # GetDCEx
  DCX_WINDOW* = 0x00000001
  DCX_CACHE* = 0x00000002
  DCX_PARENTCLIP* = 0x00000020
  DCX_CLIPSIBLINGS* = 0x00000010
  DCX_CLIPCHILDREN* = 0x00000008
  DCX_NORESETATTRS* = 0x00000004
  DCX_LOCKWINDOWUPDATE* = 0x00000400
  DCX_EXCLUDERGN* = 0x00000040
  DCX_INTERSECTRGN* = 0x00000080
  DCX_VALIDATE* = 0x00200000
  # GetDeviceCaps
  DRIVERVERSION* = 0
  TECHNOLOGY* = 2
  DT_PLOTTER* = 0
  DT_RASDISPLAY* = 1
  DT_RASPRINTER* = 2
  DT_RASCAMERA* = 3
  DT_CHARSTREAM* = 4
  DT_METAFILE* = 5
  DT_DISPFILE* = 6
  HORZSIZE* = 4
  VERTSIZE* = 6
  HORZRES* = 8
  VERTRES* = 10
  LOGPIXELSX* = 88
  LOGPIXELSY* = 90
  BITSPIXEL* = 12
  PLANES* = 14
  NUMBRUSHES* = 16
  NUMPENS* = 18
  NUMFONTS* = 22
  NUMCOLORS* = 24
  ASPECTX* = 40
  ASPECTY* = 42
  ASPECTXY* = 44
  PDEVICESIZE* = 26
  CLIPCAPS* = 36
  SIZEPALETTE* = 104
  NUMRESERVED* = 106
  COLORRES* = 108
  VREFRESH* = 116
  DESKTOPHORZRES* = 118
  DESKTOPVERTRES* = 117
  BLTALIGNMENT* = 119
  RASTERCAPS* = 38
  RC_BANDING* = 2
  RC_BITBLT* = 1
  RC_BITMAP64* = 8
  RC_DI_BITMAP* = 128
  RC_DIBTODEV* = 512
  RC_FLOODFILL* = 4096
  RC_GDI20_OUTPUT* = 16
  RC_PALETTE* = 256
  RC_SCALING* = 4
  RC_STRETCHBLT* = 2048
  RC_STRETCHDIB* = 8192
  CURVECAPS* = 28
  CC_NONE* = 0
  CC_CIRCLES* = 1
  CC_PIE* = 2
  CC_CHORD* = 4
  CC_ELLIPSES* = 8
  CC_WIDE* = 16
  CC_STYLED* = 32
  CC_WIDESTYLED* = 64
  CC_INTERIORS* = 128
  CC_ROUNDRECT* = 256
  LINECAPS* = 30
  LC_NONE* = 0
  LC_POLYLINE* = 2
  LC_MARKER* = 4
  LC_POLYMARKER* = 8
  LC_WIDE* = 16
  LC_STYLED* = 32
  LC_WIDESTYLED* = 64
  LC_INTERIORS* = 128
  POLYGONALCAPS* = 32
  PC_NONE* = 0
  PC_POLYGON* = 1
  PC_RECTANGLE* = 2
  PC_WINDPOLYGON* = 4
  PC_SCANLINE* = 8
  PC_WIDE* = 16
  PC_STYLED* = 32
  PC_WIDESTYLED* = 64
  PC_INTERIORS* = 128
  TEXTCAPS* = 34
  TC_OP_CHARACTER* = 1
  TC_OP_STROKE* = 2
  TC_CP_STROKE* = 4
  TC_CR_90* = 8
  TC_CR_ANY* = 16
  TC_SF_X_YINDEP* = 32
  TC_SA_DOUBLE* = 64
  TC_SA_INTEGER* = 128
  TC_SA_CONTIN* = 256
  TC_EA_DOUBLE* = 512
  TC_IA_ABLE* = 1024
  TC_UA_ABLE* = 2048
  TC_SO_ABLE* = 4096
  TC_RA_ABLE* = 8192
  TC_VA_ABLE* = 16384
  TC_RESERVED* = 32768
  TC_SCROLLBLT* = 65536
  PC_PATHS* = 512
  # GetDriveType
  DRIVE_REMOVABLE* = 2
  DRIVE_FIXED* = 3
  DRIVE_REMOTE* = 4
  DRIVE_CDROM* = 5
  DRIVE_RAMDISK* = 6
  DRIVE_UNKNOWN* = 0
  DRIVE_NO_ROOT_DIR* = 1
  # GetExceptionCode
  EXCEPTION_ACCESS_VIOLATION* = 0xC0000005
  EXCEPTION_BREAKPOINT* = 0x80000003
  EXCEPTION_DATATYPE_MISALIGNMENT* = 0x80000002
  EXCEPTION_SINGLE_STEP* = 0x80000004
  EXCEPTION_ARRAY_BOUNDS_EXCEEDED* = 0xC000008C
  EXCEPTION_FLT_DENORMAL_OPERAND* = 0xC000008D
  EXCEPTION_FLT_DIVIDE_BY_ZERO* = 0xC000008E
  EXCEPTION_FLT_INEXACT_RESULT* = 0xC000008F
  EXCEPTION_FLT_INVALID_OPERATION* = 0xC0000090
  EXCEPTION_FLT_OVERFLOW* = 0xC0000091
  EXCEPTION_FLT_STACK_CHECK* = 0xC0000092
  EXCEPTION_FLT_UNDERFLOW* = 0xC0000093
  EXCEPTION_INT_DIVIDE_BY_ZERO* = 0xC0000094
  EXCEPTION_INT_OVERFLOW* = 0xC0000095
  EXCEPTION_INVALID_HANDLE* = 0xC0000008
  EXCEPTION_PRIV_INSTRUCTION* = 0xC0000096
  EXCEPTION_NONCONTINUABLE_EXCEPTION* = 0xC0000025
  EXCEPTION_NONCONTINUABLE* = 0x00000001
  EXCEPTION_STACK_OVERFLOW* = 0xC00000FD
  EXCEPTION_INVALID_DISPOSITION* = 0xC0000026
  EXCEPTION_IN_PAGE_ERROR* = 0xC0000006
  EXCEPTION_ILLEGAL_INSTRUCTION* = 0xC000001D
  EXCEPTION_POSSIBLE_DEADLOCK* = 0xC0000194
  # GetFileType
  FILE_TYPE_UNKNOWN* = 0
  FILE_TYPE_DISK* = 1
  FILE_TYPE_CHAR* = 2
  FILE_TYPE_PIPE* = 3
  # GetGlyphOutline
  GGO_BITMAP* = 1
  GGO_NATIVE* = 2
  GGO_METRICS* = 0
  GGO_GRAY2_BITMAP* = 4
  GGO_GRAY4_BITMAP* = 5
  GGO_GRAY8_BITMAP* = 6
  GDI_ERROR* = 0xFFFFFFFF
  # GetGraphicsMode
  GM_COMPATIBLE* = 1
  GM_ADVANCED* = 2
  # GetHandleInformation
  HANDLE_FLAG_INHERIT* = 1
  HANDLE_FLAG_PROTECT_FROM_CLOSE* = 2
  # GetIconInfo
  IDC_ARROW* =       cast[MAKEINTRESOURCE](32512)
  IDC_IBEAM* =       cast[MAKEINTRESOURCE](32513)
  IDC_WAIT* =        cast[MAKEINTRESOURCE](32514)
  IDC_CROSS* =       cast[MAKEINTRESOURCE](32515)
  IDC_UPARROW* =     cast[MAKEINTRESOURCE](32516)
  IDC_SIZE* =        cast[MAKEINTRESOURCE](32640)  # OBSOLETE: use IDC_SIZEALL
  IDC_ICON* =        cast[MAKEINTRESOURCE](32641)  # OBSOLETE: use IDC_ARROW
  IDC_SIZENWSE* =    cast[MAKEINTRESOURCE](32642)
  IDC_SIZENESW* =    cast[MAKEINTRESOURCE](32643)
  IDC_SIZEWE* =      cast[MAKEINTRESOURCE](32644)
  IDC_SIZENS* =      cast[MAKEINTRESOURCE](32645)
  IDC_SIZEALL* =     cast[MAKEINTRESOURCE](32646)
  IDC_NO* =          cast[MAKEINTRESOURCE](32648)
  IDC_HAND* =        cast[MAKEINTRESOURCE](32649)
  IDC_APPSTARTING* = cast[MAKEINTRESOURCE](32650)
  IDC_HELP* =        cast[MAKEINTRESOURCE](32651)

  IDI_APPLICATION* = cast[MAKEINTRESOURCE](32512)
  IDI_HAND* =        cast[MAKEINTRESOURCE](32513)
  IDI_QUESTION* =    cast[MAKEINTRESOURCE](32514)
  IDI_EXCLAMATION* = cast[MAKEINTRESOURCE](32515)
  IDI_ASTERISK* =    cast[MAKEINTRESOURCE](32516)
  IDI_WINLOGO* =     cast[MAKEINTRESOURCE](32517)
  IDI_WARNING* =     IDI_EXCLAMATION
  IDI_ERROR* =       IDI_HAND
  IDI_INFORMATION* = IDI_ASTERISK

const
  # GetMapMode
  MM_ANISOTROPIC* = 8
  MM_HIENGLISH* = 5
  MM_HIMETRIC* = 3
  MM_ISOTROPIC* = 7
  MM_LOENGLISH* = 4
  MM_LOMETRIC* = 2
  MM_TEXT* = 1
  MM_TWIPS* = 6
  # GetMenuDefaultItem
  GMDI_GOINTOPOPUPS* = 0x00000002
  GMDI_USEDISABLED* = 0x00000001
  # PeekMessage
  PM_NOREMOVE* = 0
  PM_REMOVE* = 1
  PM_NOYIELD* = 2
  # GetNamedPipeHandleState
  #   PIPE_NOWAIT = 1; already above
  #   PIPE_READMODE_MESSAGE = 2;already above
  # GetNamedPipeInfo
  PIPE_CLIENT_END* = 0
  PIPE_SERVER_END* = 1
  #   PIPE_TYPE_MESSAGE = 4;already above
  # GetNextWindow, GetWindow
  GW_HWNDNEXT* = 2
  GW_HWNDPREV* = 3
  GW_CHILD* = 5
  GW_HWNDFIRST* = 0
  GW_HWNDLAST* = 1
  GW_OWNER* = 4
  # GetPath
  PT_MOVETO* = 6
  PT_LINETO* = 2
  PT_BEZIERTO* = 4
  PT_CLOSEFIGURE* = 1
  # GetProcessShutdownParameters
  SHUTDOWN_NORETRY* = 1
  # GetQueueStatus
  QS_ALLEVENTS* = 191
  QS_ALLINPUT* = 255
  QS_HOTKEY* = 128
  QS_INPUT* = 7
  QS_KEY* = 1
  QS_MOUSE* = 6
  QS_MOUSEBUTTON* = 4
  QS_MOUSEMOVE* = 2
  QS_PAINT* = 32
  QS_POSTMESSAGE* = 8
  QS_SENDMESSAGE* = 64
  QS_TIMER* = 16
  # GetScrollInfo, SetScrollInfo
  SIF_ALL* = 23
  SIF_PAGE* = 2
  SIF_POS* = 4
  SIF_RANGE* = 1
  SIF_DISABLENOSCROLL* = 8

  # GetStdHandle
  STD_INPUT_HANDLE* =  DWORD(-10)
  STD_OUTPUT_HANDLE* = DWORD(-11)
  STD_ERROR_HANDLE* =  DWORD(-12)

  INVALID_HANDLE_VALUE* = HANDLE(-1)
  INVALID_SET_FILE_POINTER* = ULONG(-1)
  INVALID_FILE_SIZE* = ULONG(-1)
  INVALID_FILE_ATTRIBUTES* = ULONG(-1)

const
  # GetStockObject
  BLACK_BRUSH* = 4
  DKGRAY_BRUSH* = 3
  GRAY_BRUSH* = 2
  HOLLOW_BRUSH* = 5
  LTGRAY_BRUSH* = 1
  NULL_BRUSH* = 5
  WHITE_BRUSH* = 0
  BLACK_PEN* = 7
  NULL_PEN* = 8
  WHITE_PEN* = 6
  ANSI_FIXED_FONT* = 11
  ANSI_VAR_FONT* = 12
  DEVICE_DEFAULT_FONT* = 14
  DEFAULT_GUI_FONT* = 17
  OEM_FIXED_FONT* = 10
  SYSTEM_FONT* = 13
  SYSTEM_FIXED_FONT* = 16
  DEFAULT_PALETTE* = 15
  # GetStringTypeA
  CT_CTYPE1* = 1
  CT_CTYPE2* = 2
  CT_CTYPE3* = 4
  C1_UPPER* = 1
  C1_LOWER* = 2
  C1_DIGIT* = 4
  C1_SPACE* = 8
  C1_PUNCT* = 16
  C1_CNTRL* = 32
  C1_BLANK* = 64
  C1_XDIGIT* = 128
  C1_ALPHA* = 256
  C2_LEFTTORIGHT* = 1
  C2_RIGHTTOLEFT* = 2
  C2_EUROPENUMBER* = 3
  C2_EUROPESEPARATOR* = 4
  C2_EUROPETERMINATOR* = 5
  C2_ARABICNUMBER* = 6
  C2_COMMONSEPARATOR* = 7
  C2_BLOCKSEPARATOR* = 8
  C2_SEGMENTSEPARATOR* = 9
  C2_WHITESPACE* = 10
  C2_OTHERNEUTRAL* = 11
  C2_NOTAPPLICABLE* = 0
  C3_NONSPACING* = 1
  C3_DIACRITIC* = 2
  C3_VOWELMARK* = 4
  C3_SYMBOL* = 8
  C3_KATAKANA* = 16
  C3_HIRAGANA* = 32
  C3_HALFWIDTH* = 64
  C3_FULLWIDTH* = 128
  C3_IDEOGRAPH* = 256
  C3_KASHIDA* = 512
  C3_ALPHA* = 32768
  C3_NOTAPPLICABLE* = 0
  # GetSysColor
  COLOR_3DDKSHADOW* = 21
  COLOR_3DFACE* = 15
  COLOR_3DHILIGHT* = 20
  COLOR_3DLIGHT* = 22
  COLOR_BTNHILIGHT* = 20
  COLOR_3DSHADOW* = 16
  COLOR_ACTIVEBORDER* = 10
  COLOR_ACTIVECAPTION* = 2
  COLOR_APPWORKSPACE* = 12
  COLOR_BACKGROUND* = 1
  COLOR_DESKTOP* = 1
  COLOR_BTNFACE* = 15
  COLOR_BTNHIGHLIGHT* = 20
  COLOR_BTNSHADOW* = 16
  COLOR_BTNTEXT* = 18
  COLOR_CAPTIONTEXT* = 9
  COLOR_GRAYTEXT* = 17
  COLOR_HIGHLIGHT* = 13
  COLOR_HIGHLIGHTTEXT* = 14
  COLOR_INACTIVEBORDER* = 11
  COLOR_INACTIVECAPTION* = 3
  COLOR_INACTIVECAPTIONTEXT* = 19
  COLOR_INFOBK* = 24
  COLOR_INFOTEXT* = 23
  COLOR_MENU* = 4
  COLOR_MENUTEXT* = 7
  COLOR_SCROLLBAR* = 0
  COLOR_WINDOW* = 5
  COLOR_WINDOWFRAME* = 6
  COLOR_WINDOWTEXT* = 8
  # GetSystemMetrics
  SM_CYMIN* = 29
  SM_CXMIN* = 28
  SM_ARRANGE* = 56
  SM_CLEANBOOT* = 67
  # The right value for SM_CEMETRICS for NT 3.5 is 75.  For Windows 95
  #     and NT 4.0, it is 76.  The meaning is undocumented, anyhow.
  SM_CMETRICS* = 76
  SM_CMOUSEBUTTONS* = 43
  SM_CXBORDER* = 5
  SM_CYBORDER* = 6
  SM_CXCURSOR* = 13
  SM_CYCURSOR* = 14
  SM_CXDLGFRAME* = 7
  SM_CYDLGFRAME* = 8
  SM_CXDOUBLECLK* = 36
  SM_CYDOUBLECLK* = 37
  SM_CXDRAG* = 68
  SM_CYDRAG* = 69
  SM_CXEDGE* = 45
  SM_CYEDGE* = 46
  SM_CXFIXEDFRAME* = 7
  SM_CYFIXEDFRAME* = 8
  SM_CXFRAME* = 32
  SM_CYFRAME* = 33
  SM_CXFULLSCREEN* = 16
  SM_CYFULLSCREEN* = 17
  SM_CXHSCROLL* = 21
  SM_CYHSCROLL* = 3
  SM_CXHTHUMB* = 10
  SM_CXICON* = 11
  SM_CYICON* = 12
  SM_CXICONSPACING* = 38
  SM_CYICONSPACING* = 39
  SM_CXMAXIMIZED* = 61
  SM_CYMAXIMIZED* = 62
  SM_CXMAXTRACK* = 59
  SM_CYMAXTRACK* = 60
  SM_CXMENUCHECK* = 71
  SM_CYMENUCHECK* = 72
  SM_CXMENUSIZE* = 54
  SM_CYMENUSIZE* = 55
  SM_CXMINIMIZED* = 57
  SM_CYMINIMIZED* = 58
  SM_CXMINSPACING* = 47
  SM_CYMINSPACING* = 48
  SM_CXMINTRACK* = 34
  SM_CYMINTRACK* = 35
  SM_CXSCREEN* = 0
  SM_CYSCREEN* = 1
  SM_CXSIZE* = 30
  SM_CYSIZE* = 31
  SM_CXSIZEFRAME* = 32
  SM_CYSIZEFRAME* = 33
  SM_CXSMICON* = 49
  SM_CYSMICON* = 50
  SM_CXSMSIZE* = 52
  SM_CYSMSIZE* = 53
  SM_CXVSCROLL* = 2
  #SM_CYHSCROLL = 3;already above
  #SM_CXHSCROLL = 21;already above
  SM_CYVSCROLL* = 20
  SM_CYVTHUMB* = 9
  SM_CYCAPTION* = 4
  SM_CYKANJIWINDOW* = 18
  SM_CYMENU* = 15
  SM_CYSMCAPTION* = 51
  SM_DBCSENABLED* = 42
  SM_DEBUG* = 22
  SM_MENUDROPALIGNMENT* = 40
  SM_MIDEASTENABLED* = 74
  SM_MOUSEPRESENT* = 19
  SM_MOUSEWHEELPRESENT* = 75
  SM_NETWORK* = 63
  SM_PENWINDOWS* = 41
  SM_SECURE* = 44
  SM_SHOWSOUNDS* = 70
  SM_SLOWMACHINE* = 73
  SM_SWAPBUTTON* = 23
  ARW_BOTTOMLEFT* = 0
  ARW_BOTTOMRIGHT* = 0x00000001
  ARW_HIDE* = 0x00000008
  ARW_TOPLEFT* = 0x00000002
  ARW_TOPRIGHT* = 0x00000003
  ARW_DOWN* = 0x00000004
  ARW_LEFT* = 0
  ARW_RIGHT* = 0
  ARW_UP* = 0x00000004
  # GetSystemPaletteUse
  SYSPAL_NOSTATIC* = 2
  SYSPAL_STATIC* = 1
  SYSPAL_ERROR* = 0
  # GetTapeParameters, SetTapeParameters
  GET_TAPE_MEDIA_INFORMATION* = 0
  GET_TAPE_DRIVE_INFORMATION* = 1
  SET_TAPE_MEDIA_INFORMATION* = 0
  SET_TAPE_DRIVE_INFORMATION* = 1
  # GetTapePosition
  TAPE_ABSOLUTE_POSITION* = 0
  TAPE_LOGICAL_POSITION* = 0x00000001
  # GetTextAlign
  TA_BASELINE* = 24
  TA_BOTTOM* = 8
  TA_TOP* = 0
  TA_CENTER* = 6
  TA_LEFT* = 0
  TA_RIGHT* = 2
  TA_RTLREADING* = 256
  TA_NOUPDATECP* = 0
  TA_UPDATECP* = 1
  VTA_BASELINE* = 24
  VTA_CENTER* = 6
  # GetThreadPriority
  THREAD_PRIORITY_ABOVE_NORMAL* = 1
  THREAD_PRIORITY_BELOW_NORMAL* = -1
  THREAD_PRIORITY_HIGHEST* = 2
  THREAD_PRIORITY_IDLE* = -15
  THREAD_PRIORITY_LOWEST* = -2
  THREAD_PRIORITY_NORMAL* = 0
  THREAD_PRIORITY_TIME_CRITICAL* = 15
  THREAD_PRIORITY_ERROR_RETURN* = 2147483647
  TLS_MINIMUM_AVAILABLE* = 64
  # GetTimeFormat
  TIME_NOMINUTESORSECONDS* = 1
  TIME_NOSECONDS* = 2
  TIME_NOTIMEMARKER* = 4
  TIME_FORCE24HOURFORMAT* = 8

const
  # GetTimeZoneInformation
  TIME_ZONE_ID_INVALID* = DWORD(- 1)
  TIME_ZONE_ID_UNKNOWN* = 0
  TIME_ZONE_ID_STANDARD* = 1
  TIME_ZONE_ID_DAYLIGHT* = 2
  # GetUserObjectInformation
  UOI_FLAGS* = 1
  UOI_NAME* = 2
  UOI_TYPE* = 3
  # GetVolumeInformation
  FS_CASE_IS_PRESERVED* = 2
  FS_CASE_SENSITIVE* = 1
  FS_UNICODE_STORED_ON_DISK* = 4
  FS_PERSISTENT_ACLS* = 8
  FS_FILE_COMPRESSION* = 16
  FS_VOL_IS_COMPRESSED* = 32768
  # GetWindowLong
  GWL_EXSTYLE* = -20
  GWL_STYLE* = -16
  GWL_WNDPROC* = -4
  GWL_HINSTANCE* = -6
  GWL_HWNDPARENT* = -8
  GWL_ID* = -12
  GWL_USERDATA* = -21
  DWL_DLGPROC* = 4
  DWL_MSGRESULT* = 0
  DWL_USER* = 8
  # GlobalAlloc, GlobalFlags
  GMEM_FIXED* = 0
  GMEM_MOVEABLE* = 2
  GPTR* = 64
  GHND* = 66
  GMEM_DDESHARE* = 8192
  GMEM_DISCARDABLE* = 256
  GMEM_LOWER* = 4096
  GMEM_NOCOMPACT* = 16
  GMEM_NODISCARD* = 32
  GMEM_NOT_BANKED* = 4096
  GMEM_NOTIFY* = 16384
  GMEM_SHARE* = 8192
  GMEM_ZEROINIT* = 64
  GMEM_DISCARDED* = 16384
  GMEM_INVALID_HANDLE* = 32768
  GMEM_LOCKCOUNT* = 255
  # HeapAlloc, HeapReAlloc
  HEAP_GENERATE_EXCEPTIONS* = 4
  HEAP_NO_SERIALIZE* = 1
  HEAP_ZERO_MEMORY* = 8
  STATUS_NO_MEMORY* = 0xC0000017
  STATUS_ACCESS_VIOLATION* = 0xC0000005
  HEAP_REALLOC_IN_PLACE_ONLY* = 16
  # ImageList_Create
  ILC_COLOR* = 0
  ILC_COLOR4* = 4
  ILC_COLOR8* = 8
  ILC_COLOR16* = 16
  ILC_COLOR24* = 24
  ILC_COLOR32* = 32
  ILC_COLORDDB* = 254
  ILC_MASK* = 1
  ILC_PALETTE* = 2048
  # ImageList_Draw, ImageList_DrawEx
  ILD_BLEND25* = 2
  ILD_BLEND50* = 4
  ILD_SELECTED* = 4
  ILD_BLEND* = 4
  ILD_FOCUS* = 2
  ILD_MASK* = 16
  ILD_NORMAL* = 0
  ILD_TRANSPARENT* = 1
  CLR_NONE* = 0xFFFFFFFF
  CLR_DEFAULT* = 0xFF000000
  CLR_INVALID* = 0xFFFFFFFF
  # ImageList_LoadImage
  #LR_DEFAULTCOLOR = 0;already above
  LR_LOADFROMFILE* = 16
  LR_LOADMAP3DCOLORS* = 4096
  LR_LOADTRANSPARENT* = 32
  # ImmConfigureIME
  IME_CONFIG_GENERAL* = 1
  IME_CONFIG_REGISTERWORD* = 2
  IME_CONFIG_SELECTDICTIONARY* = 3
  # ImmGetConversionList
  GCL_CONVERSION* = 1
  GCL_REVERSECONVERSION* = 2
  GCL_REVERSE_LENGTH* = 3
  # ImmGetGuideLine
  GGL_LEVEL* = 1
  GGL_INDEX* = 2
  GGL_STRING* = 3
  GGL_PRIVATE* = 4
  GL_LEVEL_ERROR* = 2
  GL_LEVEL_FATAL* = 1
  GL_LEVEL_INFORMATION* = 4
  GL_LEVEL_NOGUIDELINE* = 0
  GL_LEVEL_WARNING* = 3
  GL_ID_CANNOTSAVE* = 17
  GL_ID_NOCONVERT* = 32
  GL_ID_NODICTIONARY* = 16
  GL_ID_NOMODULE* = 1
  GL_ID_READINGCONFLICT* = 35
  GL_ID_TOOMANYSTROKE* = 34
  GL_ID_TYPINGERROR* = 33
  GL_ID_UNKNOWN* = 0
  GL_ID_INPUTREADING* = 36
  GL_ID_INPUTRADICAL* = 37
  GL_ID_INPUTCODE* = 38
  GL_ID_CHOOSECANDIDATE* = 40
  GL_ID_REVERSECONVERSION* = 41
  # ImmGetProperty
  IGP_PROPERTY* = 4
  IGP_CONVERSION* = 8
  IGP_SENTENCE* = 12
  IGP_UI* = 16
  IGP_SETCOMPSTR* = 20
  IGP_SELECT* = 24
  IME_PROP_AT_CARET* = 65536
  IME_PROP_SPECIAL_UI* = 131072
  IME_PROP_CANDLIST_START_FROM_1* = 262144
  IME_PROP_UNICODE* = 524288
  UI_CAP_2700* = 1
  UI_CAP_ROT90* = 2
  UI_CAP_ROTANY* = 4
  SCS_CAP_COMPSTR* = 1
  SCS_CAP_MAKEREAD* = 2
  SELECT_CAP_CONVERSION* = 1
  SELECT_CAP_SENTENCE* = 2
  # ImmNotifyIME
  NI_CHANGECANDIDATELIST* = 19
  NI_CLOSECANDIDATE* = 17
  NI_COMPOSITIONSTR* = 21
  NI_OPENCANDIDATE* = 16
  NI_SELECTCANDIDATESTR* = 18
  NI_SETCANDIDATE_PAGESIZE* = 23
  NI_SETCANDIDATE_PAGESTART* = 22
  CPS_CANCEL* = 4
  CPS_COMPLETE* = 1
  CPS_CONVERT* = 2
  CPS_REVERT* = 3
  # ImmSetCompositionString
  SCS_SETSTR* = 9
  SCS_CHANGEATTR* = 18
  SCS_CHANGECLAUSE* = 36
  # ImmUnregisterWord
  IME_REGWORD_STYLE_EUDC* = 1
  IME_REGWORD_STYLE_USER_FIRST* = 0x80000000
  IME_REGWORD_STYLE_USER_LAST* = -1
  # InitializeSecurityDescriptor
  SECURITY_DESCRIPTOR_REVISION* = 1
  # IsTextUnicode
  IS_TEXT_UNICODE_ASCII16* = 1
  IS_TEXT_UNICODE_REVERSE_ASCII16* = 16
  IS_TEXT_UNICODE_STATISTICS* = 2
  IS_TEXT_UNICODE_REVERSE_STATISTICS* = 32
  IS_TEXT_UNICODE_CONTROLS* = 4
  IS_TEXT_UNICODE_REVERSE_CONTROLS* = 64
  IS_TEXT_UNICODE_SIGNATURE* = 8
  IS_TEXT_UNICODE_REVERSE_SIGNATURE* = 128
  IS_TEXT_UNICODE_ILLEGAL_CHARS* = 256
  IS_TEXT_UNICODE_ODD_LENGTH* = 512
  IS_TEXT_UNICODE_NULL_BYTES* = 4096
  IS_TEXT_UNICODE_UNICODE_MASK* = 15
  IS_TEXT_UNICODE_REVERSE_MASK* = 240
  IS_TEXT_UNICODE_NOT_UNICODE_MASK* = 3840
  IS_TEXT_UNICODE_NOT_ASCII_MASK* = 61440
  # JournalPlaybackProc, KeyboardProc
  HC_GETNEXT* = 1
  HC_SKIP* = 2
  HC_SYSMODALOFF* = 5
  HC_SYSMODALON* = 4
  HC_NOREMOVE* = 3
  # keybd_event
  KEYEVENTF_EXTENDEDKEY* = 1
  KEYEVENTF_KEYUP* = 2
  # LoadBitmap
  OBM_BTNCORNERS* = 32758
  OBM_BTSIZE* = 32761
  OBM_CHECK* = 32760
  OBM_CHECKBOXES* = 32759
  OBM_CLOSE* = 32754
  OBM_COMBO* = 32738
  OBM_DNARROW* = 32752
  OBM_DNARROWD* = 32742
  OBM_DNARROWI* = 32736
  OBM_LFARROW* = 32750
  OBM_LFARROWI* = 32734
  OBM_LFARROWD* = 32740
  OBM_MNARROW* = 32739
  OBM_OLD_CLOSE* = 32767
  OBM_OLD_DNARROW* = 32764
  OBM_OLD_LFARROW* = 32762
  OBM_OLD_REDUCE* = 32757
  OBM_OLD_RESTORE* = 32755
  OBM_OLD_RGARROW* = 32763
  OBM_OLD_UPARROW* = 32765
  OBM_OLD_ZOOM* = 32756
  OBM_REDUCE* = 32749
  OBM_REDUCED* = 32746
  OBM_RESTORE* = 32747
  OBM_RESTORED* = 32744
  OBM_RGARROW* = 32751
  OBM_RGARROWD* = 32741
  OBM_RGARROWI* = 32735
  OBM_SIZE* = 32766
  OBM_UPARROW* = 32753
  OBM_UPARROWD* = 32743
  OBM_UPARROWI* = 32737
  OBM_ZOOM* = 32748
  OBM_ZOOMD* = 32745
  # LoadLibraryEx
  DONT_RESOLVE_DLL_REFERENCES* = 1
  LOAD_LIBRARY_AS_DATAFILE* = 2
  LOAD_WITH_ALTERED_SEARCH_PATH* = 8
  # LocalAlloc, LocalFlags
  LPTR* = 64
  LHND* = 66
  NONZEROLHND* = 2
  NONZEROLPTR* = 0
  LMEM_NONZEROLHND* = 2
  LMEM_NONZEROLPTR* = 0
  LMEM_FIXED* = 0
  LMEM_MOVEABLE* = 2
  LMEM_NOCOMPACT* = 16
  LMEM_NODISCARD* = 32
  LMEM_ZEROINIT* = 64
  LMEM_MODIFY* = 128
  LMEM_LOCKCOUNT* = 255
  LMEM_DISCARDABLE* = 3840
  LMEM_DISCARDED* = 16384
  LMEM_INVALID_HANDLE* = 32768
  # LockFileEx
  LOCKFILE_FAIL_IMMEDIATELY* = 1
  LOCKFILE_EXCLUSIVE_LOCK* = 2
  # LogonUser
  # LZCopy, LZInit, LZRead
  # MessageBeep, MessageBox
  MB_USERICON* = 0x00000080
  MB_ICONASTERISK* = 0x00000040
  MB_ICONEXCLAMATION* = 0x00000030
  MB_ICONWARNING* = 0x00000030
  MB_ICONERROR* = 0x00000010
  MB_ICONHAND* = 0x00000010
  MB_ICONQUESTION* = 0x00000020
  MB_OK* = 0
  MB_ABORTRETRYIGNORE* = 0x00000002
  MB_APPLMODAL* = 0
  MB_DEFAULT_DESKTOP_ONLY* = 0x00020000
  MB_HELP* = 0x00004000
  MB_RIGHT* = 0x00080000
  MB_RTLREADING* = 0x00100000
  MB_TOPMOST* = 0x00040000
  MB_DEFBUTTON1* = 0
  MB_DEFBUTTON2* = 0x00000100
  MB_DEFBUTTON3* = 0x00000200
  MB_DEFBUTTON4* = 0x00000300
  MB_ICONINFORMATION* = 0x00000040
  MB_ICONSTOP* = 0x00000010
  MB_OKCANCEL* = 0x00000001
  MB_RETRYCANCEL* = 0x00000005
  MB_SERVICE_NOTIFICATION* = 0x00040000
  MB_SETFOREGROUND* = 0x00010000
  MB_SYSTEMMODAL* = 0x00001000
  MB_TASKMODAL* = 0x00002000
  MB_YESNO* = 0x00000004
  MB_YESNOCANCEL* = 0x00000003
  IDABORT* = 3
  IDCANCEL* = 2
  IDCLOSE* = 8
  IDHELP* = 9
  IDIGNORE* = 5
  IDNO* = 7
  IDOK* = 1
  IDRETRY* = 4
  IDYES* = 6
  # MessageProc
  MSGF_DIALOGBOX* = 0
  MSGF_MENU* = 2
  MSGF_NEXTWINDOW* = 6
  MSGF_SCROLLBAR* = 5
  MSGF_MAINLOOP* = 8
  MSGF_USER* = 4096
  # ModifyWorldTransform
  MWT_IDENTITY* = 1
  MWT_LEFTMULTIPLY* = 2
  MWT_RIGHTMULTIPLY* = 3
  # mouse_event
  MOUSEEVENTF_ABSOLUTE* = 32768
  MOUSEEVENTF_MOVE* = 1
  MOUSEEVENTF_LEFTDOWN* = 2
  MOUSEEVENTF_LEFTUP* = 4
  MOUSEEVENTF_RIGHTDOWN* = 8
  MOUSEEVENTF_RIGHTUP* = 16
  MOUSEEVENTF_MIDDLEDOWN* = 32
  MOUSEEVENTF_MIDDLEUP* = 64
  # MoveFileEx
  MOVEFILE_REPLACE_EXISTING* = 1
  MOVEFILE_COPY_ALLOWED* = 2
  MOVEFILE_DELAY_UNTIL_REBOOT* = 4
  # MsgWaitForMultipleObjects, WaitForMultipleObjectsEx
  WAIT_OBJECT_0* = 0
  WAIT_ABANDONED_0* = 0x00000080
  WAIT_TIMEOUT* = 0x00000102
  WAIT_IO_COMPLETION* = 0x000000C0
  WAIT_ABANDONED* = 0x00000080
  WAIT_FAILED* = 0xFFFFFFFF
  MAXIMUM_WAIT_OBJECTS* = 0x00000040
  MAXIMUM_SUSPEND_COUNT* = 0x0000007F
  # MultiByteToWideChar
  MB_PRECOMPOSED* = 1
  MB_COMPOSITE* = 2
  MB_ERR_INVALID_CHARS* = 8
  MB_USEGLYPHCHARS* = 4
  # NDdeSetTrustedShare
  # NetAccessCheck
  # NetServerEnum
  # NetServiceControl
  # NetUserEnum
  # OpenProcessToken
  TOKEN_ADJUST_DEFAULT* = 128
  TOKEN_ADJUST_GROUPS* = 64
  TOKEN_ADJUST_PRIVILEGES* = 32
  TOKEN_ALL_ACCESS* = 0x000F00FF
  TOKEN_ASSIGN_PRIMARY* = 1
  TOKEN_DUPLICATE* = 2
  TOKEN_EXECUTE* = 0x00020000
  TOKEN_IMPERSONATE* = 4
  TOKEN_QUERY* = 8
  TOKEN_QUERY_SOURCE* = 16
  TOKEN_READ* = 0x00020008
  TOKEN_WRITE* = 0x000200E0
  # OpenSCManager
  SC_MANAGER_ALL_ACCESS* = 0x000F003F
  SC_MANAGER_CONNECT* = 1
  SC_MANAGER_CREATE_SERVICE* = 2
  SC_MANAGER_ENUMERATE_SERVICE* = 4
  SC_MANAGER_LOCK* = 8
  SC_MANAGER_QUERY_LOCK_STATUS* = 16
  SC_MANAGER_MODIFY_BOOT_CONFIG* = 32
  # PostMessage
  HWND_BROADCAST* = HWND(0xffff)

const
  # PrepareTape
  TAPE_FORMAT* = 0x00000005
  TAPE_LOAD* = 0
  TAPE_LOCK* = 0x00000003
  TAPE_TENSION* = 0x00000002
  TAPE_UNLOAD* = 0x00000001
  TAPE_UNLOCK* = 0x00000004
  # PropertySheet
  IS_PSREBOOTSYSTEM* = 3
  IS_PSRESTARTWINDOWS* = 2
  # PropSheetPageProc
  PSPCB_CREATE* = 2
  PSPCB_RELEASE* = 1
  # PurgeComm
  PURGE_TXABORT* = 1
  PURGE_RXABORT* = 2
  PURGE_TXCLEAR* = 4
  PURGE_RXCLEAR* = 8
  # QueryServiceObjectSecurity
  OWNER_SECURITY_INFORMATION* = 0x00000001
  GROUP_SECURITY_INFORMATION* = 0x00000002
  DACL_SECURITY_INFORMATION* = 0x00000004
  SACL_SECURITY_INFORMATION* = 0x00000008
  # ReadEventLog, ReportEvent
  EVENTLOG_FORWARDS_READ* = 4
  EVENTLOG_BACKWARDS_READ* = 8
  EVENTLOG_SEEK_READ* = 2
  EVENTLOG_SEQUENTIAL_READ* = 1
  EVENTLOG_ERROR_TYPE* = 1
  EVENTLOG_WARNING_TYPE* = 2
  EVENTLOG_INFORMATION_TYPE* = 4
  EVENTLOG_AUDIT_SUCCESS* = 8

  EVENTLOG_AUDIT_FAILURE* = 16
  # RedrawWindow
  RDW_ERASE* = 4
  RDW_FRAME* = 1024
  RDW_INTERNALPAINT* = 2
  RDW_INVALIDATE* = 1
  RDW_NOERASE* = 32
  RDW_NOFRAME* = 2048
  RDW_NOINTERNALPAINT* = 16
  RDW_VALIDATE* = 8
  RDW_ERASENOW* = 512
  RDW_UPDATENOW* = 256
  RDW_ALLCHILDREN* = 128
  RDW_NOCHILDREN* = 64

  # RegCreateKey
  HKEY_CLASSES_ROOT* =     HKEY(0x80000000)
  HKEY_CURRENT_USER* =     HKEY(0x80000001)
  HKEY_LOCAL_MACHINE* =    HKEY(0x80000002)
  HKEY_USERS* =            HKEY(0x80000003)
  HKEY_PERFORMANCE_DATA* = HKEY(0x80000004)
  HKEY_CURRENT_CONFIG* =   HKEY(0x80000005)
  HKEY_DYN_DATA* =         HKEY(0x80000006)

const
  # RegCreateKeyEx
  REG_OPTION_VOLATILE* = 0x00000001
  REG_OPTION_NON_VOLATILE* = 0
  REG_CREATED_NEW_KEY* = 0x00000001
  REG_OPENED_EXISTING_KEY* = 0x00000002
  # RegEnumValue
  REG_BINARY* = 3
  REG_DWORD* = 4
  REG_DWORD_LITTLE_ENDIAN* = 4
  REG_DWORD_BIG_ENDIAN* = 5
  REG_EXPAND_SZ* = 2
  REG_FULL_RESOURCE_DESCRIPTOR* = 9
  REG_LINK* = 6
  REG_MULTI_SZ* = 7
  REG_NONE* = 0
  REG_RESOURCE_LIST* = 8
  REG_RESOURCE_REQUIREMENTS_LIST* = 10
  REG_SZ* = 1
  # RegisterHotKey
  MOD_ALT* = 1
  MOD_CONTROL* = 2
  MOD_SHIFT* = 4
  MOD_WIN* = 8
  IDHOT_SNAPDESKTOP* = -2
  IDHOT_SNAPWINDOW* = -1
  # RegNotifyChangeKeyValue
  REG_NOTIFY_CHANGE_NAME* = 0x00000001
  REG_NOTIFY_CHANGE_ATTRIBUTES* = 0x00000002
  REG_NOTIFY_CHANGE_LAST_SET* = 0x00000004
  REG_NOTIFY_CHANGE_SECURITY* = 0x00000008
  # ScrollWindowEx
  SW_ERASE* = 4
  SW_INVALIDATE* = 2
  SW_SCROLLCHILDREN* = 1
  # SendMessageTimeout
  SMTO_ABORTIFHUNG* = 2
  SMTO_BLOCK* = 1
  SMTO_NORMAL* = 0
  # SetBkMode
  OPAQUE* = 2

  TRANSPARENT* = 1
  # SetDebugErrorLevel
  SLE_ERROR* = 1
  SLE_MINORERROR* = 2
  SLE_WARNING* = 3
  # SetErrorMode
  SEM_FAILCRITICALERRORS* = 1
  SEM_NOALIGNMENTFAULTEXCEPT* = 4
  SEM_NOGPFAULTERRORBOX* = 2
  SEM_NOOPENFILEERRORBOX* = 32768
  # SetICMMode
  ICM_ON* = 2
  ICM_OFF* = 1
  ICM_QUERY* = 3
  # SetJob
  # Locale Information
  LOCALE_ILANGUAGE* = 1
  LOCALE_SLANGUAGE* = 2
  LOCALE_SENGLANGUAGE* = 4097
  LOCALE_SABBREVLANGNAME* = 3
  LOCALE_SNATIVELANGNAME* = 4
  LOCALE_ICOUNTRY* = 5
  LOCALE_SCOUNTRY* = 6
  LOCALE_SENGCOUNTRY* = 4098
  LOCALE_SABBREVCTRYNAME* = 7
  LOCALE_SNATIVECTRYNAME* = 8
  LOCALE_IDEFAULTLANGUAGE* = 9
  LOCALE_IDEFAULTCOUNTRY* = 10
  LOCALE_IDEFAULTANSICODEPAGE* = 4100
  LOCALE_IDEFAULTCODEPAGE* = 11
  LOCALE_SLIST* = 12
  LOCALE_IMEASURE* = 13
  LOCALE_SDECIMAL* = 14
  LOCALE_STHOUSAND* = 15
  LOCALE_SGROUPING* = 16
  LOCALE_IDIGITS* = 17
  LOCALE_ILZERO* = 18
  LOCALE_INEGNUMBER* = 4112
  LOCALE_SCURRENCY* = 20
  LOCALE_SMONDECIMALSEP* = 22
  LOCALE_SMONTHOUSANDSEP* = 23
  LOCALE_SMONGROUPING* = 24
  LOCALE_ICURRDIGITS* = 25
  LOCALE_ICURRENCY* = 27
  LOCALE_INEGCURR* = 28
  LOCALE_SDATE* = 29
  LOCALE_STIME* = 30
  LOCALE_STIMEFORMAT* = 4099
  LOCALE_SSHORTDATE* = 31
  LOCALE_SLONGDATE* = 32
  LOCALE_IDATE* = 33
  LOCALE_ILDATE* = 34
  LOCALE_ITIME* = 35
  LOCALE_ITLZERO* = 37
  LOCALE_IDAYLZERO* = 38
  LOCALE_IMONLZERO* = 39
  LOCALE_S1159* = 40
  LOCALE_S2359* = 41
  LOCALE_ICALENDARTYPE* = 4105
  LOCALE_IOPTIONALCALENDAR* = 4107
  LOCALE_IFIRSTDAYOFWEEK* = 4108
  LOCALE_IFIRSTWEEKOFYEAR* = 4109
  LOCALE_SDAYNAME1* = 42
  LOCALE_SDAYNAME2* = 43
  LOCALE_SDAYNAME3* = 44
  LOCALE_SDAYNAME4* = 45
  LOCALE_SDAYNAME5* = 46
  LOCALE_SDAYNAME6* = 47
  LOCALE_SDAYNAME7* = 48
  LOCALE_SABBREVDAYNAME1* = 49
  LOCALE_SABBREVDAYNAME2* = 50
  LOCALE_SABBREVDAYNAME3* = 51
  LOCALE_SABBREVDAYNAME4* = 52
  LOCALE_SABBREVDAYNAME5* = 53
  LOCALE_SABBREVDAYNAME6* = 54
  LOCALE_SABBREVDAYNAME7* = 55
  LOCALE_SMONTHNAME1* = 56
  LOCALE_SMONTHNAME2* = 57
  LOCALE_SMONTHNAME3* = 58
  LOCALE_SMONTHNAME4* = 59
  LOCALE_SMONTHNAME5* = 60
  LOCALE_SMONTHNAME6* = 61
  LOCALE_SMONTHNAME7* = 62
  LOCALE_SMONTHNAME8* = 63
  LOCALE_SMONTHNAME9* = 64
  LOCALE_SMONTHNAME10* = 65
  LOCALE_SMONTHNAME11* = 66
  LOCALE_SMONTHNAME12* = 67
  LOCALE_SMONTHNAME13* = 4110
  LOCALE_SABBREVMONTHNAME1* = 68
  LOCALE_SABBREVMONTHNAME2* = 69
  LOCALE_SABBREVMONTHNAME3* = 70
  LOCALE_SABBREVMONTHNAME4* = 71
  LOCALE_SABBREVMONTHNAME5* = 72
  LOCALE_SABBREVMONTHNAME6* = 73
  LOCALE_SABBREVMONTHNAME7* = 74
  LOCALE_SABBREVMONTHNAME8* = 75
  LOCALE_SABBREVMONTHNAME9* = 76
  LOCALE_SABBREVMONTHNAME10* = 77
  LOCALE_SABBREVMONTHNAME11* = 78
  LOCALE_SABBREVMONTHNAME12* = 79
  LOCALE_SABBREVMONTHNAME13* = 4111
  LOCALE_SPOSITIVESIGN* = 80
  LOCALE_SNEGATIVESIGN* = 81
  LOCALE_IPOSSIGNPOSN* = 82
  LOCALE_INEGSIGNPOSN* = 83
  LOCALE_IPOSSYMPRECEDES* = 84
  LOCALE_IPOSSEPBYSPACE* = 85
  LOCALE_INEGSYMPRECEDES* = 86
  LOCALE_INEGSEPBYSPACE* = 87
  LOCALE_NOUSEROVERRIDE* = 0x80000000
  LOCALE_USE_CP_ACP* = 0x40000000 # use the system ACP
  LOCALE_RETURN_NUMBER* = 0x20000000 # return number instead
  LOCALE_SISO639LANGNAME* = 0x00000059
  LOCALE_SISO3166CTRYNAME* = 0x0000005A
  # Calendar Type Information
  CAL_ICALINTVALUE* = 1
  CAL_IYEAROFFSETRANGE* = 3
  CAL_SABBREVDAYNAME1* = 14
  CAL_SABBREVDAYNAME2* = 15
  CAL_SABBREVDAYNAME3* = 16
  CAL_SABBREVDAYNAME4* = 17
  CAL_SABBREVDAYNAME5* = 18
  CAL_SABBREVDAYNAME6* = 19
  CAL_SABBREVDAYNAME7* = 20
  CAL_SABBREVMONTHNAME1* = 34
  CAL_SABBREVMONTHNAME2* = 35
  CAL_SABBREVMONTHNAME3* = 36
  CAL_SABBREVMONTHNAME4* = 37
  CAL_SABBREVMONTHNAME5* = 38
  CAL_SABBREVMONTHNAME6* = 39
  CAL_SABBREVMONTHNAME7* = 40
  CAL_SABBREVMONTHNAME8* = 41
  CAL_SABBREVMONTHNAME9* = 42
  CAL_SABBREVMONTHNAME10* = 43
  CAL_SABBREVMONTHNAME11* = 44
  CAL_SABBREVMONTHNAME12* = 45
  CAL_SABBREVMONTHNAME13* = 46
  CAL_SCALNAME* = 2
  CAL_SDAYNAME1* = 7
  CAL_SDAYNAME2* = 8
  CAL_SDAYNAME3* = 9
  CAL_SDAYNAME4* = 10
  CAL_SDAYNAME5* = 11
  CAL_SDAYNAME6* = 12
  CAL_SDAYNAME7* = 13
  CAL_SERASTRING* = 4
  CAL_SLONGDATE* = 6
  CAL_SMONTHNAME1* = 21
  CAL_SMONTHNAME2* = 22
  CAL_SMONTHNAME3* = 23
  CAL_SMONTHNAME4* = 24
  CAL_SMONTHNAME5* = 25
  CAL_SMONTHNAME6* = 26
  CAL_SMONTHNAME7* = 27
  CAL_SMONTHNAME8* = 28
  CAL_SMONTHNAME9* = 29
  CAL_SMONTHNAME10* = 30
  CAL_SMONTHNAME11* = 31
  CAL_SMONTHNAME12* = 32
  CAL_SMONTHNAME13* = 33
  CAL_SSHORTDATE* = 5
  # SetProcessWorkingSetSize
  PROCESS_SET_QUOTA* = 256
  # SetPrinter
  # SetService
  # SetStretchBltMode
  BLACKONWHITE* = 1
  COLORONCOLOR* = 3
  HALFTONE* = 4
  STRETCH_ANDSCANS* = 1
  STRETCH_DELETESCANS* = 3
  STRETCH_HALFTONE* = 4
  STRETCH_ORSCANS* = 2
  WHITEONBLACK* = 2
  # SetSystemCursor
  OCR_NORMAL* = 32512
  OCR_IBEAM* = 32513
  OCR_WAIT* = 32514
  OCR_CROSS* = 32515
  OCR_UP* = 32516
  OCR_SIZE* = 32640
  OCR_ICON* = 32641
  OCR_SIZENWSE* = 32642
  OCR_SIZENESW* = 32643
  OCR_SIZEWE* = 32644
  OCR_SIZENS* = 32645
  OCR_SIZEALL* = 32646
  OCR_NO* = 32648
  OCR_APPSTARTING* = 32650
  # SetTapePosition
  TAPE_ABSOLUTE_BLOCK* = 0x00000001
  TAPE_LOGICAL_BLOCK* = 0x00000002
  TAPE_REWIND* = 0
  TAPE_SPACE_END_OF_DATA* = 0x00000004
  TAPE_SPACE_FILEMARKS* = 0x00000006
  TAPE_SPACE_RELATIVE_BLOCKS* = 0x00000005
  TAPE_SPACE_SEQUENTIAL_FMKS* = 0x00000007
  TAPE_SPACE_SEQUENTIAL_SMKS* = 0x00000009
  TAPE_SPACE_SETMARKS* = 0x00000008
  # SetUnhandledExceptionFilter
  EXCEPTION_EXECUTE_HANDLER* = 1
  EXCEPTION_CONTINUE_EXECUTION* = -1
  EXCEPTION_CONTINUE_SEARCH* = 0

  # SetWindowPos, DeferWindowPos
  HWND_BOTTOM* =    HWND(1)
  HWND_NOTOPMOST* = HWND(-2)
  HWND_TOP* =       HWND(0)
  HWND_TOPMOST* =   HWND(-1)

const
  SWP_DRAWFRAME* = 32
  SWP_FRAMECHANGED* = 32
  SWP_HIDEWINDOW* = 128
  SWP_NOACTIVATE* = 16
  SWP_NOCOPYBITS* = 256
  SWP_NOMOVE* = 2
  SWP_NOSIZE* = 1
  SWP_NOREDRAW* = 8
  SWP_NOZORDER* = 4
  SWP_SHOWWINDOW* = 64
  SWP_NOOWNERZORDER* = 512
  SWP_NOREPOSITION* = 512
  SWP_NOSENDCHANGING* = 1024
  # SHAddToRecentDocs
  # SHAppBarMessage
  # SHChangeNotify
  # ShellProc
  HSHELL_ACTIVATESHELLWINDOW* = 3
  HSHELL_GETMINRECT* = 5
  HSHELL_LANGUAGE* = 8
  HSHELL_REDRAW* = 6
  HSHELL_TASKMAN* = 7
  HSHELL_WINDOWACTIVATED* = 4
  HSHELL_WINDOWCREATED* = 1
  HSHELL_WINDOWDESTROYED* = 2
  # SHGetFileInfo
  # SHGetSpecialFolderLocation
  # ShowWindow
  SW_HIDE* = 0
  SW_MAXIMIZE* = 3
  SW_MINIMIZE* = 6
  SW_NORMAL* = 1
  SW_RESTORE* = 9
  SW_SHOW* = 5
  SW_SHOWDEFAULT* = 10
  SW_SHOWMAXIMIZED* = 3
  SW_SHOWMINIMIZED* = 2
  SW_SHOWMINNOACTIVE* = 7
  SW_SHOWNA* = 8
  SW_SHOWNOACTIVATE* = 4
  SW_SHOWNORMAL* = 1
  WPF_RESTORETOMAXIMIZED* = 2
  WPF_SETMINPOSITION* = 1
  # Sleep
  INFINITE* = -1'i32
  # SystemParametersInfo
  SPI_GETBEEP* = 1
  SPI_SETBEEP* = 2
  SPI_GETMOUSE* = 3
  SPI_SETMOUSE* = 4
  SPI_GETBORDER* = 5
  SPI_SETBORDER* = 6
  SPI_GETKEYBOARDSPEED* = 10
  SPI_SETKEYBOARDSPEED* = 11
  SPI_LANGDRIVER* = 12
  SPI_ICONHORIZONTALSPACING* = 13
  SPI_GETSCREENSAVETIMEOUT* = 14
  SPI_SETSCREENSAVETIMEOUT* = 15
  SPI_GETSCREENSAVEACTIVE* = 16
  SPI_SETSCREENSAVEACTIVE* = 17
  SPI_GETGRIDGRANULARITY* = 18
  SPI_SETGRIDGRANULARITY* = 19
  SPI_SETDESKWALLPAPER* = 20
  SPI_SETDESKPATTERN* = 21
  SPI_GETKEYBOARDDELAY* = 22
  SPI_SETKEYBOARDDELAY* = 23
  SPI_ICONVERTICALSPACING* = 24
  SPI_GETICONTITLEWRAP* = 25
  SPI_SETICONTITLEWRAP* = 26
  SPI_GETMENUDROPALIGNMENT* = 27
  SPI_SETMENUDROPALIGNMENT* = 28
  SPI_SETDOUBLECLKWIDTH* = 29
  SPI_SETDOUBLECLKHEIGHT* = 30
  SPI_GETICONTITLELOGFONT* = 31
  SPI_SETDOUBLECLICKTIME* = 32
  SPI_SETMOUSEBUTTONSWAP* = 33
  SPI_SETICONTITLELOGFONT* = 34
  SPI_GETFASTTASKSWITCH* = 35
  SPI_SETFASTTASKSWITCH* = 36
  SPI_SETDRAGFULLWINDOWS* = 37
  SPI_GETDRAGFULLWINDOWS* = 38
  SPI_GETNONCLIENTMETRICS* = 41
  SPI_SETNONCLIENTMETRICS* = 42

  SPI_GETMINIMIZEDMETRICS* = 43
  SPI_SETMINIMIZEDMETRICS* = 44
  SPI_GETICONMETRICS* = 45
  SPI_SETICONMETRICS* = 46
  SPI_SETWORKAREA* = 47
  SPI_GETWORKAREA* = 48
  SPI_SETPENWINDOWS* = 49
  SPI_GETFILTERKEYS* = 50
  SPI_SETFILTERKEYS* = 51
  SPI_GETTOGGLEKEYS* = 52
  SPI_SETTOGGLEKEYS* = 53
  SPI_GETMOUSEKEYS* = 54
  SPI_SETMOUSEKEYS* = 55
  SPI_GETSHOWSOUNDS* = 56
  SPI_SETSHOWSOUNDS* = 57
  SPI_GETSTICKYKEYS* = 58
  SPI_SETSTICKYKEYS* = 59
  SPI_GETACCESSTIMEOUT* = 60
  SPI_SETACCESSTIMEOUT* = 61
  SPI_GETSERIALKEYS* = 62
  SPI_SETSERIALKEYS* = 63
  SPI_GETSOUNDSENTRY* = 64
  SPI_SETSOUNDSENTRY* = 65
  SPI_GETHIGHCONTRAST* = 66
  SPI_SETHIGHCONTRAST* = 67
  SPI_GETKEYBOARDPREF* = 68
  SPI_SETKEYBOARDPREF* = 69
  SPI_GETSCREENREADER* = 70
  SPI_SETSCREENREADER* = 71
  SPI_GETANIMATION* = 72
  SPI_SETANIMATION* = 73
  SPI_GETFONTSMOOTHING* = 74
  SPI_SETFONTSMOOTHING* = 75
  SPI_SETDRAGWIDTH* = 76
  SPI_SETDRAGHEIGHT* = 77
  SPI_SETHANDHELD* = 78
  SPI_GETLOWPOWERTIMEOUT* = 79
  SPI_GETPOWEROFFTIMEOUT* = 80
  SPI_SETLOWPOWERTIMEOUT* = 81
  SPI_SETPOWEROFFTIMEOUT* = 82
  SPI_GETLOWPOWERACTIVE* = 83
  SPI_GETPOWEROFFACTIVE* = 84
  SPI_SETLOWPOWERACTIVE* = 85
  SPI_SETPOWEROFFACTIVE* = 86
  SPI_SETCURSORS* = 87
  SPI_SETICONS* = 88
  SPI_GETDEFAULTINPUTLANG* = 89
  SPI_SETDEFAULTINPUTLANG* = 90
  SPI_SETLANGTOGGLE* = 91
  SPI_GETWINDOWSEXTENSION* = 92
  SPI_SETMOUSETRAILS* = 93
  SPI_GETMOUSETRAILS* = 94
  SPI_GETSNAPTODEFBUTTON* = 95
  SPI_SETSNAPTODEFBUTTON* = 96
  SPI_SCREENSAVERRUNNING* = 97
  SPI_SETSCREENSAVERRUNNING* = 97
  SPI_GETMOUSEHOVERWIDTH* = 98
  SPI_SETMOUSEHOVERWIDTH* = 99
  SPI_GETMOUSEHOVERHEIGHT* = 100
  SPI_SETMOUSEHOVERHEIGHT* = 101
  SPI_GETMOUSEHOVERTIME* = 102
  SPI_SETMOUSEHOVERTIME* = 103
  SPI_GETWHEELSCROLLLINES* = 104
  SPI_SETWHEELSCROLLLINES* = 105
  SPI_GETMENUSHOWDELAY* = 106
  SPI_SETMENUSHOWDELAY* = 107
  SPI_GETSHOWIMEUI* = 110
  SPI_SETSHOWIMEUI* = 111
  # Windows Me/2000 and higher
  SPI_GETMOUSESPEED* = 112
  SPI_SETMOUSESPEED* = 113
  SPI_GETSCREENSAVERRUNNING* = 114
  SPI_GETDESKWALLPAPER* = 115
  SPI_GETACTIVEWINDOWTRACKING* = 4096
  SPI_SETACTIVEWINDOWTRACKING* = 4097
  SPI_GETMENUANIMATION* = 4098
  SPI_SETMENUANIMATION* = 4099
  SPI_GETCOMBOBOXANIMATION* = 4100
  SPI_SETCOMBOBOXANIMATION* = 4101
  SPI_GETLISTBOXSMOOTHSCROLLING* = 4102
  SPI_SETLISTBOXSMOOTHSCROLLING* = 4103
  SPI_GETGRADIENTCAPTIONS* = 4104
  SPI_SETGRADIENTCAPTIONS* = 4105
  SPI_GETKEYBOARDCUES* = 4106
  SPI_SETKEYBOARDCUES* = 4107
  SPI_GETMENUUNDERLINES* = 4106
  SPI_SETMENUUNDERLINES* = 4107
  SPI_GETACTIVEWNDTRKZORDER* = 4108
  SPI_SETACTIVEWNDTRKZORDER* = 4109
  SPI_GETHOTTRACKING* = 4110
  SPI_SETHOTTRACKING* = 4111
  SPI_GETMENUFADE* = 4114
  SPI_SETMENUFADE* = 4115
  SPI_GETSELECTIONFADE* = 4116
  SPI_SETSELECTIONFADE* = 4117
  SPI_GETTOOLTIPANIMATION* = 4118
  SPI_SETTOOLTIPANIMATION* = 4119
  SPI_GETTOOLTIPFADE* = 4120
  SPI_SETTOOLTIPFADE* = 4121
  SPI_GETCURSORSHADOW* = 4122
  SPI_SETCURSORSHADOW* = 4123
  SPI_GETUIEFFECTS* = 4158
  SPI_SETUIEFFECTS* = 4159
  SPI_GETFOREGROUNDLOCKTIMEOUT* = 8192
  SPI_SETFOREGROUNDLOCKTIMEOUT* = 8193
  SPI_GETACTIVEWNDTRKTIMEOUT* = 8194
  SPI_SETACTIVEWNDTRKTIMEOUT* = 8195
  SPI_GETFOREGROUNDFLASHCOUNT* = 8196
  SPI_SETFOREGROUNDFLASHCOUNT* = 8197
  SPI_GETCARETWIDTH* = 8198
  SPI_SETCARETWIDTH* = 8199
  # Windows XP and higher
  SPI_GETMOUSESONAR* = 4124
  SPI_SETMOUSESONAR* = 4125
  SPI_GETMOUSECLICKLOCK* = 4126
  SPI_SETMOUSECLICKLOCK* = 4127
  SPI_GETMOUSEVANISH* = 4128
  SPI_SETMOUSEVANISH* = 4129
  SPI_GETFLATMENU* = 4130
  SPI_SETFLATMENU* = 4131
  SPI_GETDROPSHADOW* = 4132
  SPI_SETDROPSHADOW* = 4133
  SPI_GETBLOCKSENDINPUTRESETS* = 4134
  SPI_SETBLOCKSENDINPUTRESETS* = 4135
  SPI_GETMOUSECLICKLOCKTIME* = 8200
  SPI_SETMOUSECLICKLOCKTIME* = 8201
  SPI_GETFONTSMOOTHINGTYPE* = 8202
  SPI_SETFONTSMOOTHINGTYPE* = 8203
  SPI_GETFONTSMOOTHINGCONTRAST* = 8204
  SPI_SETFONTSMOOTHINGCONTRAST* = 8205
  SPI_GETFOCUSBORDERWIDTH* = 8206
  SPI_SETFOCUSBORDERWIDTH* = 8207
  SPI_GETFOCUSBORDERHEIGHT* = 8208
  SPI_SETFOCUSBORDERHEIGHT* = 8209
  SPI_GETFONTSMOOTHINGORIENTATION* = 8210
  SPI_SETFONTSMOOTHINGORIENTATION* = 8211
  # constants for SPI_GETFONTSMOOTHINGTYPE and SPI_SETFONTSMOOTHINGTYPE:
  FE_FONTSMOOTHINGSTANDARD* = 1
  FE_FONTSMOOTHINGCLEARTYPE* = 2
  FE_FONTSMOOTHINGDOCKING* = 32768
  # constants for SPI_GETFONTSMOOTHINGORIENTATION and SPI_SETFONTSMOOTHINGORIENTATION:
  FE_FONTSMOOTHINGORIENTATIONBGR* = 0
  FE_FONTSMOOTHINGORIENTATIONRGB* = 1
  # Flags
  SPIF_UPDATEINIFILE* = 1
  SPIF_SENDWININICHANGE* = 2
  SPIF_SENDCHANGE* = 2
  # TrackPopupMenu, TrackPopMenuEx
  TPM_CENTERALIGN* = 0x00000004
  TPM_LEFTALIGN* = 0
  TPM_RIGHTALIGN* = 0x00000008
  TPM_LEFTBUTTON* = 0
  TPM_RIGHTBUTTON* = 0x00000002
  TPM_HORIZONTAL* = 0
  TPM_VERTICAL* = 0x00000040
  # TranslateCharsetInfo
  TCI_SRCCHARSET* = 1
  TCI_SRCCODEPAGE* = 2
  TCI_SRCFONTSIG* = 3
  # VerFindFile
  VFFF_ISSHAREDFILE* = 1
  VFF_CURNEDEST* = 1
  VFF_FILEINUSE* = 2
  VFF_BUFFTOOSMALL* = 4
  # VerInstallFile
  VIFF_FORCEINSTALL* = 1
  VIFF_DONTDELETEOLD* = 2
  VIF_TEMPFILE* = 0x00000001
  VIF_MISMATCH* = 0x00000002
  VIF_SRCOLD* = 0x00000004
  VIF_DIFFLANG* = 0x00000008
  VIF_DIFFCODEPG* = 0x00000010
  VIF_DIFFTYPE* = 0x00000020
  VIF_WRITEPROT* = 0x00000040
  VIF_FILEINUSE* = 0x00000080
  VIF_OUTOFSPACE* = 0x00000100
  VIF_ACCESSVIOLATION* = 0x00000200
  VIF_SHARINGVIOLATION* = 0x00000400
  VIF_CANNOTCREATE* = 0x00000800
  VIF_CANNOTDELETE* = 0x00001000
  VIF_CANNOTDELETECUR* = 0x00004000
  VIF_CANNOTRENAME* = 0x00002000
  VIF_OUTOFMEMORY* = 0x00008000
  VIF_CANNOTREADSRC* = 0x00010000
  VIF_CANNOTREADDST* = 0x00020000
  VIF_BUFFTOOSMALL* = 0x00040000
  # WideCharToMultiByte
  WC_COMPOSITECHECK* = 512
  WC_DISCARDNS* = 16
  WC_SEPCHARS* = 32
  WC_DEFAULTCHAR* = 64
  # WinHelp
  HELP_COMMAND* = 0x00000102
  HELP_CONTENTS* = 0x00000003
  HELP_CONTEXT* = 0x00000001
  HELP_CONTEXTPOPUP* = 0x00000008
  HELP_FORCEFILE* = 0x00000009
  HELP_HELPONHELP* = 0x00000004
  HELP_INDEX* = 0x00000003
  HELP_KEY* = 0x00000101
  HELP_MULTIKEY* = 0x00000201
  HELP_PARTIALKEY* = 0x00000105
  HELP_QUIT* = 0x00000002
  HELP_SETCONTENTS* = 0x00000005
  HELP_SETINDEX* = 0x00000005
  HELP_CONTEXTMENU* = 0x0000000A
  HELP_FINDER* = 0x0000000B
  HELP_WM_HELP* = 0x0000000C
  HELP_TCARD* = 0x00008000
  HELP_TCARD_DATA* = 0x00000010
  HELP_TCARD_OTHER_CALLER* = 0x00000011
  # WNetAddConnectino2
  CONNECT_UPDATE_PROFILE* = 1
  # WNetConnectionDialog, WNetDisconnectDialog, WNetOpenEnum
  RESOURCETYPE_DISK* = 1
  RESOURCETYPE_PRINT* = 2
  RESOURCETYPE_ANY* = 0
  RESOURCE_CONNECTED* = 1
  RESOURCE_GLOBALNET* = 2
  RESOURCE_REMEMBERED* = 3
  RESOURCEUSAGE_CONNECTABLE* = 1
  RESOURCEUSAGE_CONTAINER* = 2
  # WNetGetResourceInformation, WNetGetResourceParent
  WN_BAD_NETNAME* = 0x00000043
  WN_EXTENDED_ERROR* = 0x000004B8
  WN_MORE_DATA* = 0x000000EA
  WN_NO_NETWORK* = 0x000004C6
  WN_SUCCESS* = 0
  WN_ACCESS_DENIED* = 0x00000005
  WN_BAD_PROVIDER* = 0x000004B4
  WN_NOT_AUTHENTICATED* = 0x000004DC
  # WNetGetUniversalName
  UNIVERSAL_NAME_INFO_LEVEL* = 1
  REMOTE_NAME_INFO_LEVEL* = 2
  # GetExitCodeThread
  STILL_ACTIVE* = 0x00000103
  # COMMPROP structure
  SP_SERIALCOMM* = 0x00000001
  BAUD_075* = 0x00000001
  BAUD_110* = 0x00000002
  BAUD_134_5* = 0x00000004
  BAUD_150* = 0x00000008
  BAUD_300* = 0x00000010
  BAUD_600* = 0x00000020
  BAUD_1200* = 0x00000040
  BAUD_1800* = 0x00000080
  BAUD_2400* = 0x00000100
  BAUD_4800* = 0x00000200
  BAUD_7200* = 0x00000400
  BAUD_9600* = 0x00000800
  BAUD_14400* = 0x00001000
  BAUD_19200* = 0x00002000
  BAUD_38400* = 0x00004000
  BAUD_56K* = 0x00008000
  BAUD_57600* = 0x00040000
  BAUD_115200* = 0x00020000
  BAUD_128K* = 0x00010000
  BAUD_USER* = 0x10000000
  PST_FAX* = 0x00000021
  PST_LAT* = 0x00000101
  PST_MODEM* = 0x00000006
  PST_NETWORK_BRIDGE* = 0x00000100
  PST_PARALLELPORT* = 0x00000002
  PST_RS232* = 0x00000001
  PST_RS422* = 0x00000003
  PST_RS423* = 0x00000004
  PST_RS449* = 0x00000005
  PST_SCANNER* = 0x00000022
  PST_TCPIP_TELNET* = 0x00000102
  PST_UNSPECIFIED* = 0
  PST_X25* = 0x00000103
  PCF_16BITMODE* = 0x00000200
  PCF_DTRDSR* = 0x00000001
  PCF_INTTIMEOUTS* = 0x00000080
  PCF_PARITY_CHECK* = 0x00000008
  PCF_RLSD* = 0x00000004
  PCF_RTSCTS* = 0x00000002
  PCF_SETXCHAR* = 0x00000020
  PCF_SPECIALCHARS* = 0x00000100
  PCF_TOTALTIMEOUTS* = 0x00000040
  PCF_XONXOFF* = 0x00000010
  SP_BAUD* = 0x00000002
  SP_DATABITS* = 0x00000004
  SP_HANDSHAKING* = 0x00000010
  SP_PARITY* = 0x00000001
  SP_PARITY_CHECK* = 0x00000020
  SP_RLSD* = 0x00000040
  SP_STOPBITS* = 0x00000008
  DATABITS_5* = 1
  DATABITS_6* = 2
  DATABITS_7* = 4
  DATABITS_8* = 8
  DATABITS_16* = 16
  DATABITS_16X* = 32
  STOPBITS_10* = 1
  STOPBITS_15* = 2
  STOPBITS_20* = 4
  PARITY_NONE* = 256
  PARITY_ODD* = 512
  PARITY_EVEN* = 1024
  PARITY_MARK* = 2048
  PARITY_SPACE* = 4096
  COMMPROP_INITIALIZED* = 0xE73CF52E
  # DCB structure
  CBR_110* = 110
  CBR_300* = 300
  CBR_600* = 600
  CBR_1200* = 1200
  CBR_2400* = 2400
  CBR_4800* = 4800
  CBR_9600* = 9600
  CBR_14400* = 14400
  CBR_19200* = 19200
  CBR_38400* = 38400
  CBR_56000* = 56000
  CBR_57600* = 57600
  CBR_115200* = 115200
  CBR_128000* = 128000
  CBR_256000* = 256000
  DTR_CONTROL_DISABLE* = 0
  DTR_CONTROL_ENABLE* = 1
  DTR_CONTROL_HANDSHAKE* = 2
  RTS_CONTROL_DISABLE* = 0
  RTS_CONTROL_ENABLE* = 1
  RTS_CONTROL_HANDSHAKE* = 2
  RTS_CONTROL_TOGGLE* = 3
  EVENPARITY* = 2
  MARKPARITY* = 3
  NOPARITY* = 0
  ODDPARITY* = 1
  SPACEPARITY* = 4
  ONESTOPBIT* = 0
  ONE5STOPBITS* = 1
  TWOSTOPBITS* = 2
  # Debugging events
  CREATE_PROCESS_DEBUG_EVENT* = 3
  CREATE_THREAD_DEBUG_EVENT* = 2
  EXCEPTION_DEBUG_EVENT* = 1
  EXIT_PROCESS_DEBUG_EVENT* = 5
  EXIT_THREAD_DEBUG_EVENT* = 4
  LOAD_DLL_DEBUG_EVENT* = 6
  OUTPUT_DEBUG_STRING_EVENT* = 8
  UNLOAD_DLL_DEBUG_EVENT* = 7
  RIP_EVENT* = 9
  # PROCESS_HEAP_ENTRY structure
  PROCESS_HEAP_REGION* = 1
  PROCESS_HEAP_UNCOMMITTED_RANGE* = 2
  PROCESS_HEAP_ENTRY_BUSY* = 4
  PROCESS_HEAP_ENTRY_MOVEABLE* = 16
  PROCESS_HEAP_ENTRY_DDESHARE* = 32
  # Win32s
  HINSTANCE_ERROR* = 32
  # WIN32_STREAM_ID structure
  BACKUP_DATA* = 1
  BACKUP_EA_DATA* = 2
  BACKUP_SECURITY_DATA* = 3
  BACKUP_ALTERNATE_DATA* = 4
  BACKUP_LINK* = 5
  STREAM_MODIFIED_WHEN_READ* = 1
  STREAM_CONTAINS_SECURITY* = 2
  # STARTUPINFO structure
  STARTF_USESHOWWINDOW* = 1
  STARTF_USEPOSITION* = 4
  STARTF_USESIZE* = 2
  STARTF_USECOUNTCHARS* = 8
  STARTF_USEFILLATTRIBUTE* = 16
  STARTF_RUNFULLSCREEN* = 32
  STARTF_FORCEONFEEDBACK* = 64
  STARTF_FORCEOFFFEEDBACK* = 128
  STARTF_USESTDHANDLES* = 256
  STARTF_USEHOTKEY* = 512
  # OSVERSIONINFO structure
  VER_PLATFORM_WIN32s* = 0
  VER_PLATFORM_WIN32_WINDOWS* = 1
  VER_PLATFORM_WIN32_NT* = 2
  # More versions
  VER_SERVER_NT* = 0x80000000
  VER_WORKSTATION_NT* = 0x40000000
  VER_SUITE_SMALLBUSINESS* = 0x00000001
  VER_SUITE_ENTERPRISE* = 0x00000002
  VER_SUITE_BACKOFFICE* = 0x00000004
  VER_SUITE_COMMUNICATIONS* = 0x00000008
  VER_SUITE_TERMINAL* = 0x00000010
  VER_SUITE_SMALLBUSINESS_RESTRICTED* = 0x00000020
  VER_SUITE_EMBEDDEDNT* = 0x00000040
  VER_SUITE_DATACENTER* = 0x00000080
  VER_SUITE_SINGLEUSERTS* = 0x00000100
  VER_SUITE_PERSONAL* = 0x00000200
  VER_SUITE_BLADE* = 0x00000400
  VER_SUITE_EMBEDDED_RESTRICTED* = 0x00000800
  # PROPSHEETPAGE structure
  MAXPROPPAGES* = 100
  PSP_DEFAULT* = 0
  PSP_DLGINDIRECT* = 1
  PSP_HASHELP* = 32
  PSP_USECALLBACK* = 128
  PSP_USEHICON* = 2
  PSP_USEICONID* = 4
  PSP_USEREFPARENT* = 64
  PSP_USETITLE* = 8
  PSP_RTLREADING* = 16
  # PROPSHEETHEADER structure
  PSH_DEFAULT* = 0
  PSH_HASHELP* = 512
  PSH_MODELESS* = 1024
  PSH_NOAPPLYNOW* = 128
  PSH_PROPSHEETPAGE* = 8
  PSH_PROPTITLE* = 1
  PSH_USECALLBACK* = 256
  PSH_USEHICON* = 2
  PSH_USEICONID* = 4
  PSH_USEPSTARTPAGE* = 64
  PSH_WIZARD* = 32
  PSH_RTLREADING* = 2048
  PSCB_INITIALIZED* = 1
  PSCB_PRECREATE* = 2
  # PSN_APPLY message
  PSNRET_NOERROR* = 0
  PSNRET_INVALID_NOCHANGEPAGE* = 2
  # Property Sheet
  PSBTN_APPLYNOW* = 4
  PSBTN_BACK* = 0
  PSBTN_CANCEL* = 5
  PSBTN_FINISH* = 2
  PSBTN_HELP* = 6
  PSBTN_NEXT* = 1
  PSBTN_OK* = 3
  PSWIZB_BACK* = 1
  PSWIZB_NEXT* = 2
  PSWIZB_FINISH* = 4
  PSWIZB_DISABLEDFINISH* = 8
  ID_PSREBOOTSYSTEM* = 3
  ID_PSRESTARTWINDOWS* = 2
  WIZ_BODYCX* = 184
  WIZ_BODYX* = 92
  WIZ_CXBMP* = 80
  WIZ_CXDLG* = 276
  WIZ_CYDLG* = 140

  # VX_FIXEDFILEINFO structure
  VS_FILE_INFO* = cast[MAKEINTRESOURCE](16)

const
  VS_VERSION_INFO* = 1
  VS_FF_DEBUG* = 0x00000001
  VS_FF_INFOINFERRED* = 0x00000010
  VS_FF_PATCHED* = 0x00000004
  VS_FF_PRERELEASE* = 0x00000002
  VS_FF_PRIVATEBUILD* = 0x00000008
  VS_FF_SPECIALBUILD* = 0x00000020
  VOS_UNKNOWN* = 0
  VOS_DOS* = 0x00010000
  VOS_OS216* = 0x00020000
  VOS_OS232* = 0x00030000
  VOS_NT* = 0x00040000
  VOS_DOS_WINDOWS16* = 0x00010001
  VOS_DOS_WINDOWS32* = 0x00010004
  VOS_OS216_PM16* = 0x00020002
  VOS_OS232_PM32* = 0x00030003
  VOS_NT_WINDOWS32* = 0x00040004
  VFT_UNKNOWN* = 0
  VFT_APP* = 0x00000001
  VFT_DLL* = 0x00000002
  VFT_DRV* = 0x00000003
  VFT_FONT* = 0x00000004
  VFT_VXD* = 0x00000005
  VFT_STATIC_LIB* = 0x00000007
  VFT2_UNKNOWN* = 0
  VFT2_DRV_PRINTER* = 0x00000001
  VFT2_DRV_KEYBOARD* = 0x00000002
  VFT2_DRV_LANGUAGE* = 0x00000003
  VFT2_DRV_DISPLAY* = 0x00000004
  VFT2_DRV_MOUSE* = 0x00000005
  VFT2_DRV_NETWORK* = 0x00000006
  VFT2_DRV_SYSTEM* = 0x00000007
  VFT2_DRV_INSTALLABLE* = 0x00000008
  VFT2_DRV_SOUND* = 0x00000009
  VFT2_FONT_RASTER* = 0x00000001
  VFT2_FONT_VECTOR* = 0x00000002
  VFT2_FONT_TRUETYPE* = 0x00000003
  # PANOSE structure
  PAN_ANY* = 0
  PAN_NO_FIT* = 1
  PAN_FAMILY_TEXT_DISPLAY* = 2
  PAN_FAMILY_SCRIPT* = 3
  PAN_FAMILY_DECORATIVE* = 4
  PAN_FAMILY_PICTORIAL* = 5
  PAN_SERIF_COVE* = 2
  PAN_SERIF_OBTUSE_COVE* = 3
  PAN_SERIF_SQUARE_COVE* = 4
  PAN_SERIF_OBTUSE_SQUARE_COVE* = 5
  PAN_SERIF_SQUARE* = 6
  PAN_SERIF_THIN* = 7
  PAN_SERIF_BONE* = 8
  PAN_SERIF_EXAGGERATED* = 9
  PAN_SERIF_TRIANGLE* = 10
  PAN_SERIF_NORMAL_SANS* = 11
  PAN_SERIF_OBTUSE_SANS* = 12
  PAN_SERIF_PERP_SANS* = 13
  PAN_SERIF_FLARED* = 14
  PAN_SERIF_ROUNDED* = 15
  PAN_WEIGHT_VERY_LIGHT* = 2
  PAN_WEIGHT_LIGHT* = 3
  PAN_WEIGHT_THIN* = 4
  PAN_WEIGHT_BOOK* = 5
  PAN_WEIGHT_MEDIUM* = 6
  PAN_WEIGHT_DEMI* = 7
  PAN_WEIGHT_BOLD* = 8
  PAN_WEIGHT_HEAVY* = 9
  PAN_WEIGHT_BLACK* = 10
  PAN_WEIGHT_NORD* = 11
  PAN_PROP_OLD_STYLE* = 2
  PAN_PROP_MODERN* = 3
  PAN_PROP_EVEN_WIDTH* = 4
  PAN_PROP_EXPANDED* = 5
  PAN_PROP_CONDENSED* = 6
  PAN_PROP_VERY_EXPANDED* = 7
  PAN_PROP_VERY_CONDENSED* = 8
  PAN_PROP_MONOSPACED* = 9
  PAN_CONTRAST_NONE* = 2
  PAN_CONTRAST_VERY_LOW* = 3
  PAN_CONTRAST_LOW* = 4
  PAN_CONTRAST_MEDIUM_LOW* = 5
  PAN_CONTRAST_MEDIUM* = 6
  PAN_CONTRAST_MEDIUM_HIGH* = 7
  PAN_CONTRAST_HIGH* = 8
  PAN_CONTRAST_VERY_HIGH* = 9
  PAN_STROKE_GRADUAL_DIAG* = 2
  PAN_STROKE_GRADUAL_TRAN* = 3
  PAN_STROKE_GRADUAL_VERT* = 4
  PAN_STROKE_GRADUAL_HORZ* = 5
  PAN_STROKE_RAPID_VERT* = 6
  PAN_STROKE_RAPID_HORZ* = 7
  PAN_STROKE_INSTANT_VERT* = 8
  PAN_STRAIGHT_ARMS_HORZ* = 2
  PAN_STRAIGHT_ARMS_WEDGE* = 3
  PAN_STRAIGHT_ARMS_VERT* = 4
  PAN_STRAIGHT_ARMS_SINGLE_SERIF* = 5
  PAN_STRAIGHT_ARMS_DOUBLE_SERIF* = 6
  PAN_BENT_ARMS_HORZ* = 7
  PAN_BENT_ARMS_VERT* = 9
  PAN_BENT_ARMS_WEDGE* = 8
  PAN_BENT_ARMS_SINGLE_SERIF* = 10
  PAN_BENT_ARMS_DOUBLE_SERIF* = 11
  PAN_LETT_NORMAL_CONTACT* = 2
  PAN_LETT_NORMAL_WEIGHTED* = 3
  PAN_LETT_NORMAL_BOXED* = 4
  PAN_LETT_NORMAL_FLATTENED* = 5
  PAN_LETT_NORMAL_ROUNDED* = 6
  PAN_LETT_NORMAL_OFF_CENTER* = 7
  PAN_LETT_NORMAL_SQUARE* = 8
  PAN_LETT_OBLIQUE_CONTACT* = 9
  PAN_LETT_OBLIQUE_WEIGHTED* = 10
  PAN_LETT_OBLIQUE_BOXED* = 11
  PAN_LETT_OBLIQUE_FLATTENED* = 12
  PAN_LETT_OBLIQUE_ROUNDED* = 13
  PAN_LETT_OBLIQUE_OFF_CENTER* = 14
  PAN_LETT_OBLIQUE_SQUARE* = 15
  PAN_MIDLINE_STANDARD_TRIMMED* = 2
  PAN_MIDLINE_STANDARD_POINTED* = 3
  PAN_MIDLINE_STANDARD_SERIFED* = 4
  PAN_MIDLINE_HIGH_TRIMMED* = 5
  PAN_MIDLINE_HIGH_POINTED* = 6
  PAN_MIDLINE_HIGH_SERIFED* = 7
  PAN_MIDLINE_CONSTANT_TRIMMED* = 8
  PAN_MIDLINE_CONSTANT_POINTED* = 9
  PAN_MIDLINE_CONSTANT_SERIFED* = 10
  PAN_MIDLINE_LOW_TRIMMED* = 11
  PAN_MIDLINE_LOW_POINTED* = 12
  PAN_MIDLINE_LOW_SERIFED* = 13
  PAN_XHEIGHT_CONSTANT_SMALL* = 2
  PAN_XHEIGHT_CONSTANT_STD* = 3
  PAN_XHEIGHT_CONSTANT_LARGE* = 4
  PAN_XHEIGHT_DUCKING_SMALL* = 5
  PAN_XHEIGHT_DUCKING_STD* = 6
  PAN_XHEIGHT_DUCKING_LARGE* = 7
  # PALETTENTRY structure
  PC_EXPLICIT* = 2
  PC_NOCOLLAPSE* = 4
  PC_RESERVED* = 1
  # LOGBRUSH structure
  BS_DIBPATTERN* = 5
  BS_DIBPATTERN8X8* = 8
  BS_DIBPATTERNPT* = 6
  BS_HATCHED* = 2
  BS_HOLLOW* = 1
  BS_NULL* = 1
  BS_PATTERN* = 3
  BS_PATTERN8X8* = 7
  BS_SOLID* = 0
  # DEVMODE structure, field selection bits
  DM_ORIENTATION* = 0x00000001
  DM_PAPERSIZE* = 0x00000002
  DM_PAPERLENGTH* = 0x00000004
  DM_PAPERWIDTH* = 0x00000008
  DM_SCALE* = 0x00000010
  DM_POSITION* = 0x00000020
  DM_NUP* = 0x00000040
  DM_DISPLAYORIENTATION* = 0x00000080
  DM_COPIES* = 0x00000100
  DM_DEFAULTSOURCE* = 0x00000200
  DM_PRINTQUALITY* = 0x00000400
  DM_COLOR* = 0x00000800
  DM_DUPLEX* = 0x00001000
  DM_YRESOLUTION* = 0x00002000
  DM_TTOPTION* = 0x00004000
  DM_COLLATE* = 0x00008000
  DM_FORMNAME* = 0x00010000
  DM_LOGPIXELS* = 0x00020000
  DM_BITSPERPEL* = 0x00040000
  DM_PELSWIDTH* = 0x00080000
  DM_PELSHEIGHT* = 0x00100000
  DM_DISPLAYFLAGS* = 0x00200000
  DM_DISPLAYFREQUENCY* = 0x00400000
  DM_ICMMETHOD* = 0x00800000
  DM_ICMINTENT* = 0x01000000
  DM_MEDIATYPE* = 0x02000000
  DM_DITHERTYPE* = 0x04000000
  DM_PANNINGWIDTH* = 0x08000000
  DM_PANNINGHEIGHT* = 0x10000000
  DM_DISPLAYFIXEDOUTPUT* = 0x20000000
  # orientation selections
  DMORIENT_LANDSCAPE* = 2
  DMORIENT_PORTRAIT* = 1
  # paper selections
  DMPAPER_LETTER* = 1
  DMPAPER_LEGAL* = 5
  DMPAPER_A4* = 9
  DMPAPER_CSHEET* = 24
  DMPAPER_DSHEET* = 25
  DMPAPER_ESHEET* = 26
  DMPAPER_LETTERSMALL* = 2
  DMPAPER_TABLOID* = 3
  DMPAPER_LEDGER* = 4
  DMPAPER_STATEMENT* = 6
  DMPAPER_EXECUTIVE* = 7
  DMPAPER_A3* = 8
  DMPAPER_A4SMALL* = 10
  DMPAPER_A5* = 11
  DMPAPER_B4* = 12
  DMPAPER_B5* = 13
  DMPAPER_FOLIO* = 14
  DMPAPER_QUARTO* = 15
  DMPAPER_10X14* = 16
  DMPAPER_11X17* = 17
  DMPAPER_NOTE* = 18
  DMPAPER_ENV_9* = 19
  DMPAPER_ENV_10* = 20
  DMPAPER_ENV_11* = 21
  DMPAPER_ENV_12* = 22
  DMPAPER_ENV_14* = 23
  DMPAPER_ENV_DL* = 27
  DMPAPER_ENV_C5* = 28
  DMPAPER_ENV_C3* = 29
  DMPAPER_ENV_C4* = 30
  DMPAPER_ENV_C6* = 31
  DMPAPER_ENV_C65* = 32
  DMPAPER_ENV_B4* = 33
  DMPAPER_ENV_B5* = 34
  DMPAPER_ENV_B6* = 35
  DMPAPER_ENV_ITALY* = 36
  DMPAPER_ENV_MONARCH* = 37
  DMPAPER_ENV_PERSONAL* = 38
  DMPAPER_FANFOLD_US* = 39
  DMPAPER_FANFOLD_STD_GERMAN* = 40
  DMPAPER_FANFOLD_LGL_GERMAN* = 41
  DMPAPER_ISO_B4* = 42
  DMPAPER_JAPANESE_POSTCARD* = 43
  DMPAPER_9X11* = 44
  DMPAPER_10X11* = 45
  DMPAPER_15X11* = 46
  DMPAPER_ENV_INVITE* = 47
  DMPAPER_RESERVED_48* = 48
  DMPAPER_RESERVED_49* = 49
  DMPAPER_LETTER_EXTRA* = 50
  DMPAPER_LEGAL_EXTRA* = 51
  DMPAPER_TABLOID_EXTRA* = 52
  DMPAPER_A4_EXTRA* = 53
  DMPAPER_LETTER_TRANSVERSE* = 54
  DMPAPER_A4_TRANSVERSE* = 55
  DMPAPER_LETTER_EXTRA_TRANSVERSE* = 56
  DMPAPER_A_PLUS* = 57
  DMPAPER_B_PLUS* = 58
  DMPAPER_LETTER_PLUS* = 59
  DMPAPER_A4_PLUS* = 60
  DMPAPER_A5_TRANSVERSE* = 61
  DMPAPER_B5_TRANSVERSE* = 62
  DMPAPER_A3_EXTRA* = 63
  DMPAPER_A5_EXTRA* = 64
  DMPAPER_B5_EXTRA* = 65
  DMPAPER_A2* = 66
  DMPAPER_A3_TRANSVERSE* = 67
  DMPAPER_A3_EXTRA_TRANSVERSE* = 68
  DMPAPER_DBL_JAPANESE_POSTCARD* = 69
  DMPAPER_A6* = 70
  DMPAPER_JENV_KAKU2* = 71
  DMPAPER_JENV_KAKU3* = 72
  DMPAPER_JENV_CHOU3* = 73
  DMPAPER_JENV_CHOU4* = 74
  DMPAPER_LETTER_ROTATED* = 75
  DMPAPER_A3_ROTATED* = 76
  DMPAPER_A4_ROTATED* = 77
  DMPAPER_A5_ROTATED* = 78
  DMPAPER_B4_JIS_ROTATED* = 79
  DMPAPER_B5_JIS_ROTATED* = 80
  DMPAPER_JAPANESE_POSTCARD_ROTATED* = 81
  DMPAPER_DBL_JAPANESE_POSTCARD_ROTATED* = 82
  DMPAPER_A6_ROTATED* = 83
  DMPAPER_JENV_KAKU2_ROTATED* = 84
  DMPAPER_JENV_KAKU3_ROTATED* = 85
  DMPAPER_JENV_CHOU3_ROTATED* = 86
  DMPAPER_JENV_CHOU4_ROTATED* = 87
  DMPAPER_B6_JIS* = 88
  DMPAPER_B6_JIS_ROTATED* = 89
  DMPAPER_12X11* = 90
  DMPAPER_JENV_YOU4* = 91
  DMPAPER_JENV_YOU4_ROTATED* = 92
  DMPAPER_P16K* = 93
  DMPAPER_P32K* = 94
  DMPAPER_P32KBIG* = 95
  DMPAPER_PENV_1* = 96
  DMPAPER_PENV_2* = 97
  DMPAPER_PENV_3* = 98
  DMPAPER_PENV_4* = 99
  DMPAPER_PENV_5* = 100
  DMPAPER_PENV_6* = 101
  DMPAPER_PENV_7* = 102
  DMPAPER_PENV_8* = 103
  DMPAPER_PENV_9* = 104
  DMPAPER_PENV_10* = 105
  DMPAPER_P16K_ROTATED* = 106
  DMPAPER_P32K_ROTATED* = 107
  DMPAPER_P32KBIG_ROTATED* = 108
  DMPAPER_PENV_1_ROTATED* = 109
  DMPAPER_PENV_2_ROTATED* = 110
  DMPAPER_PENV_3_ROTATED* = 111
  DMPAPER_PENV_4_ROTATED* = 112
  DMPAPER_PENV_5_ROTATED* = 113
  DMPAPER_PENV_6_ROTATED* = 114
  DMPAPER_PENV_7_ROTATED* = 115
  DMPAPER_PENV_8_ROTATED* = 116
  DMPAPER_PENV_9_ROTATED* = 117
  DMPAPER_PENV_10_ROTATED* = 118
  DMPAPER_USER* = 256
  # bin selections
  DMBIN_UPPER* = 1
  DMBIN_ONLYONE* = 1
  DMBIN_LOWER* = 2
  DMBIN_MIDDLE* = 3
  DMBIN_MANUAL* = 4
  DMBIN_ENVELOPE* = 5
  DMBIN_ENVMANUAL* = 6
  DMBIN_AUTO* = 7
  DMBIN_TRACTOR* = 8
  DMBIN_SMALLFMT* = 9
  DMBIN_LARGEFMT* = 10
  DMBIN_LARGECAPACITY* = 11
  DMBIN_CASSETTE* = 14
  DMBIN_FORMSOURCE* = 15
  DMBIN_USER* = 256
  # print qualities
  DMRES_DRAFT* = -1
  DMRES_LOW* = -2
  DMRES_MEDIUM* = -3
  DMRES_HIGH* = -4
  # color enable/disable for color printers
  DMCOLOR_MONOCHROME* = 1
  DMCOLOR_COLOR* = 2
  # duplex enable
  DMDUP_SIMPLEX* = 1
  DMDUP_VERTICAL* = 2
  DMDUP_HORIZONTAL* = 3
  # TrueType options
  DMTT_BITMAP* = 1
  DMTT_DOWNLOAD* = 2
  DMTT_SUBDEV* = 3
  # Collation selections
  DMCOLLATE_TRUE* = 1
  DMCOLLATE_FALSE* = 0
  # DEVMODE dmDisplayOrientation specifiations
  DMDO_DEFAULT* = 0
  DMDO_90* = 1
  DMDO_180* = 2
  DMDO_270* = 3
  # DEVMODE dmDisplayFixedOutput specifiations
  DMDFO_DEFAULT* = 0
  DMDFO_STRETCH* = 1
  DMDFO_CENTER* = 2
  # Deprecated
  #DM_GRAYSCALE* = 1
  #DM_INTERLACED* = 2
  DMDISPLAYFLAGS_TEXTMODE* = 0x00000004
  # dmNup , multiple logical page per physical page options
  DMNUP_SYSTEM* = 1
  DMNUP_ONEUP* = 2
  # ICM methods
  DMICMMETHOD_NONE* = 1
  DMICMMETHOD_SYSTEM* = 2
  DMICMMETHOD_DRIVER* = 3
  DMICMMETHOD_DEVICE* = 4
  DMICMMETHOD_USER* = 256
  # ICM Intents
  DMICM_SATURATE* = 1
  DMICM_CONTRAST* = 2
  DMICM_COLORMETRIC* = 3
  DMICM_USER* = 256
  # Media types
  DMMEDIA_STANDARD* = 1
  DMMEDIA_TRANSPARENCY* = 2
  DMMEDIA_GLOSSY* = 3
  DMMEDIA_USER* = 256
  # Dither types
  DMDITHER_NONE* = 1
  DMDITHER_COARSE* = 2
  DMDITHER_FINE* = 3
  DMDITHER_LINEART* = 4
  DMDITHER_GRAYSCALE* = 10
  DMDITHER_USER* = 256
  # RGNDATAHEADER structure
  RDH_RECTANGLES* = 1
  # TTPOLYGONHEADER structure
  TT_POLYGON_TYPE* = 24
  # TTPOLYCURVE structure
  TT_PRIM_LINE* = 1
  TT_PRIM_QSPLINE* = 2
  # GCP_RESULTS structure
  GCPCLASS_ARABIC* = 2
  GCPCLASS_HEBREW* = 2
  GCPCLASS_LATIN* = 1
  GCPCLASS_LATINNUMBER* = 5
  GCPCLASS_LOCALNUMBER* = 4
  GCPCLASS_LATINNUMERICSEPARATOR* = 7
  GCPCLASS_LATINNUMERICTERMINATOR* = 6
  GCPCLASS_NEUTRAL* = 3
  GCPCLASS_NUMERICSEPARATOR* = 8
  GCPCLASS_PREBOUNDLTR* = 128
  GCPCLASS_PREBOUNDRTL* = 64
  GCPCLASS_POSTBOUNDLTR* = 32
  GCPCLASS_POSTBOUNDRTL* = 16
  GCPGLYPH_LINKBEFORE* = 32768
  GCPGLYPH_LINKAFTER* = 16384
  # RASTERIZER_STATUS structure
  TT_AVAILABLE* = 1
  TT_ENABLED* = 2
  # COLORADJUSTMENT structure
  CA_NEGATIVE* = 1
  CA_LOG_FILTER* = 2
  ILLUMINANT_DEVICE_DEFAULT* = 0
  ILLUMINANT_A* = 1
  ILLUMINANT_B* = 2
  ILLUMINANT_C* = 3
  ILLUMINANT_D50* = 4
  ILLUMINANT_D55* = 5
  ILLUMINANT_D65* = 6
  ILLUMINANT_D75* = 7
  ILLUMINANT_F2* = 8
  ILLUMINANT_TUNGSTEN* = 1
  ILLUMINANT_DAYLIGHT* = 3
  ILLUMINANT_FLUORESCENT* = 8
  ILLUMINANT_NTSC* = 3
  # DOCINFO structure
  DI_APPBANDING* = 1
  # EMRMETAHEADER structure
  EMR_HEADER* = 1
  ENHMETA_SIGNATURE* = 1179469088
  # RTF event masks
  ENM_CHANGE* = 1
  ENM_CORRECTTEXT* = 4194304
  ENM_DROPFILES* = 1048576
  ENM_KEYEVENTS* = 65536
  ENM_MOUSEEVENTS* = 131072
  ENM_PROTECTED* = 2097152
  ENM_REQUESTRESIZE* = 262144
  ENM_SCROLL* = 4
  ENM_SELCHANGE* = 524288
  ENM_UPDATE* = 2
  ENM_NONE* = 0
  # RTF styles
  ES_DISABLENOSCROLL* = 8192
  ES_EX_NOCALLOLEINIT* = 16777216
  ES_NOIME* = 524288
  ES_SAVESEL* = 32768
  ES_SELFIME* = 262144
  ES_SUNKEN* = 16384
  ES_VERTICAL* = 4194304
  ES_SELECTIONBAR* = 16777216
  # EM_SETOPTIONS message
  ECOOP_SET* = 1
  ECOOP_OR* = 2
  ECOOP_AND* = 3
  ECOOP_XOR* = 4
  ECO_AUTOWORDSELECTION* = 1
  ECO_AUTOVSCROLL* = 64
  ECO_AUTOHSCROLL* = 128
  ECO_NOHIDESEL* = 256
  ECO_READONLY* = 2048
  ECO_WANTRETURN* = 4096
  ECO_SAVESEL* = 32768
  ECO_SELECTIONBAR* = 16777216
  ECO_VERTICAL* = 4194304
  # EM_SETCHARFORMAT message
  SCF_WORD* = 2
  SCF_SELECTION* = 1
  # EM_STREAMOUT message
  SF_TEXT* = 1
  SF_RTF* = 2
  SF_RTFNOOBJS* = 3
  SF_TEXTIZED* = 4
  SFF_SELECTION* = 32768
  SFF_PLAINRTF* = 16384
  # EM_FINDWORDBREAK message
  WB_CLASSIFY* = 3
  #WB_ISDELIMITER = 2;
  #     WB_LEFT = 0; already above
  WB_LEFTBREAK* = 6
  WB_PREVBREAK* = 6
  WB_MOVEWORDLEFT* = 4
  WB_MOVEWORDPREV* = 4
  WB_MOVEWORDRIGHT* = 5
  WB_MOVEWORDNEXT* = 5
  #WB_RIGHT = 1;already above
  WB_RIGHTBREAK* = 7
  WB_NEXTBREAK* = 7
  # EM_GETPUNCTUATION message
  PC_LEADING* = 2
  PC_FOLLOWING* = 1
  PC_DELIMITER* = 4
  PC_OVERFLOW* = 3
  # EM_SETWORDWRAPMODE message
  WBF_WORDWRAP* = 16
  WBF_WORDBREAK* = 32
  WBF_OVERFLOW* = 64
  WBF_LEVEL1* = 128
  WBF_LEVEL2* = 256
  WBF_CUSTOM* = 512
  WBF_BREAKAFTER* = 64
  WBF_BREAKLINE* = 32
  WBF_ISWHITE* = 16
  # CHARFORMAT structure
  CFM_BOLD* = 1
  CFM_COLOR* = 1073741824
  CFM_FACE* = 536870912
  CFM_ITALIC* = 2
  CFM_OFFSET* = 268435456
  CFM_PROTECTED* = 16
  CFM_SIZE* = 0x80000000
  CFM_STRIKEOUT* = 8
  CFM_UNDERLINE* = 4
  CFE_AUTOCOLOR* = 1073741824
  CFE_BOLD* = 1
  CFE_ITALIC* = 2
  CFE_STRIKEOUT* = 8
  CFE_UNDERLINE* = 4
  CFE_PROTECTED* = 16
  # PARAFORMAT structure
  PFM_ALIGNMENT* = 8
  PFM_NUMBERING* = 32
  PFM_OFFSET* = 4
  PFM_OFFSETINDENT* = 0x80000000
  PFM_RIGHTINDENT* = 2
  PFM_STARTINDENT* = 1
  PFM_TABSTOPS* = 16
  PFN_BULLET* = 1
  PFA_LEFT* = 1
  PFA_RIGHT* = 2
  PFA_CENTER* = 3
  # SELCHANGE structure
  SEL_EMPTY* = 0
  SEL_TEXT* = 1
  SEL_OBJECT* = 2
  SEL_MULTICHAR* = 4
  SEL_MULTIOBJECT* = 8
  # RTF clipboard formats
  CF_RTF* = "Rich Text Format"
  CF_RETEXTOBJ* = "RichEdit Text and Objects"
  # DRAWITEMSTRUCT structure
  ODT_BUTTON* = 4
  ODT_COMBOBOX* = 3
  ODT_LISTBOX* = 2
  ODT_LISTVIEW* = 102
  ODT_MENU* = 1
  ODT_STATIC* = 5
  ODT_TAB* = 101
  ODT_HEADER* = 100
  ODA_DRAWENTIRE* = 1
  ODA_FOCUS* = 4
  ODA_SELECT* = 2
  ODS_SELECTED* = 1
  ODS_GRAYED* = 2
  ODS_DISABLED* = 4
  ODS_CHECKED* = 8
  ODS_FOCUS* = 16
  ODS_DEFAULT* = 32
  ODS_HOTLIGHT* = 0x00000040
  ODS_INACTIVE* = 0x00000080
  ODS_NOACCEL* = 0x00000100
  ODS_NOFOCUSRECT* = 0x00000200
  ODS_COMBOBOXEDIT* = 0x00001000
  # Common control styles
  CCS_ADJUSTABLE* = 0x00000020
  CCS_BOTTOM* = 0x00000003
  CCS_NODIVIDER* = 0x00000040
  CCS_NOMOVEY* = 0x00000002
  CCS_NOPARENTALIGN* = 0x00000008
  CCS_NORESIZE* = 0x00000004
  CCS_TOP* = 0x00000001

  # Common control window classes
  ANIMATE_CLASSW* = "SysAnimate32"
  HOTKEY_CLASSW* = "msctls_hotkey32"
  PROGRESS_CLASSW* = "msctls_progress32"
  STATUSCLASSNAMEW* = "msctls_statusbar32"
  TOOLBARCLASSNAMEW* = "ToolbarWindow32"
  TOOLTIPS_CLASSW* = "tooltips_class32"
  TRACKBAR_CLASSW* = "msctls_trackbar32"
  UPDOWN_CLASSW* = "msctls_updown32"
  WC_HEADERW* = "SysHeader32"
  WC_LISTVIEWW* = "SysListView32"
  WC_TABCONTROLW* = "SysTabControl32"
  WC_TREEVIEWW* = "SysTreeView32"

  ANIMATE_CLASSA* = "SysAnimate32"
  HOTKEY_CLASSA* = "msctls_hotkey32"
  PROGRESS_CLASSA* = "msctls_progress32"
  STATUSCLASSNAMEA* = "msctls_statusbar32"
  TOOLBARCLASSNAMEA* = "ToolbarWindow32"
  TOOLTIPS_CLASSA* = "tooltips_class32"
  TRACKBAR_CLASSA* = "msctls_trackbar32"
  UPDOWN_CLASSA* = "msctls_updown32"
  WC_HEADERA* = "SysHeader32"
  WC_LISTVIEWA* = "SysListView32"
  WC_TABCONTROLA* = "SysTabControl32"
  WC_TREEVIEWA* = "SysTreeView32"

when defined(winUnicode):
  const
    ANIMATE_CLASS* = ANIMATE_CLASSW
    HOTKEY_CLASS* = HOTKEY_CLASSW
    PROGRESS_CLASS* = PROGRESS_CLASSW
    STATUSCLASSNAME* = STATUSCLASSNAMEW
    TOOLBARCLASSNAME* = TOOLBARCLASSNAMEW
    TOOLTIPS_CLASS* = TOOLTIPS_CLASSW
    TRACKBAR_CLASS* = TRACKBAR_CLASSW
    UPDOWN_CLASS* = UPDOWN_CLASSW
    WC_HEADER* = WC_HEADERW
    WC_LISTVIEW* = WC_LISTVIEWW
    WC_TABCONTROL* = WC_TABCONTROLW
    WC_TREEVIEW* = WC_TREEVIEWW
else:
  const
    ANIMATE_CLASS* = ANIMATE_CLASSA
    HOTKEY_CLASS* = HOTKEY_CLASSA
    PROGRESS_CLASS* = PROGRESS_CLASSA
    STATUSCLASSNAME* = STATUSCLASSNAMEA
    TOOLBARCLASSNAME* = TOOLBARCLASSNAMEA
    TOOLTIPS_CLASS* = TOOLTIPS_CLASSA
    TRACKBAR_CLASS* = TRACKBAR_CLASSA
    UPDOWN_CLASS* = UPDOWN_CLASSA
    WC_HEADER* = WC_HEADERA
    WC_LISTVIEW* = WC_LISTVIEWA
    WC_TABCONTROL* = WC_TABCONTROLA
    WC_TREEVIEW* = WC_TREEVIEWA
# UNICODE

const
  # Header control styles
  HDS_BUTTONS* = 2
  HDS_HIDDEN* = 8
  HDS_HORZ* = 0
  # HD_ITEM structure
  HDI_BITMAP* = 16
  HDI_FORMAT* = 4
  HDI_HEIGHT* = 1
  HDI_LPARAM* = 8
  HDI_TEXT* = 2
  HDI_WIDTH* = 1
  HDF_CENTER* = 2
  HDF_LEFT* = 0
  HDF_RIGHT* = 1
  HDF_RTLREADING* = 4
  HDF_BITMAP* = 8192
  HDF_OWNERDRAW* = 32768
  HDF_STRING* = 16384
  HDF_JUSTIFYMASK* = 3
  # HD_HITTESTINFO structure
  HHT_NOWHERE* = 1
  HHT_ONDIVIDER* = 4
  HHT_ONDIVOPEN* = 8
  HHT_ONHEADER* = 2
  HHT_TOLEFT* = 2048
  HHT_TORIGHT* = 1024
  # TBADDBITMAP structure
  HINST_COMMCTRL* = HINST(-1)

const
  IDB_STD_LARGE_COLOR* = 1
  IDB_STD_SMALL_COLOR* = 0
  IDB_VIEW_LARGE_COLOR* = 5
  IDB_VIEW_SMALL_COLOR* = 4
  STD_COPY* = 1
  STD_CUT* = 0
  STD_DELETE* = 5
  STD_FILENEW* = 6
  STD_FILEOPEN* = 7
  STD_FILESAVE* = 8
  STD_FIND* = 12
  STD_HELP* = 11
  STD_PASTE* = 2
  STD_PRINT* = 14
  STD_PRINTPRE* = 9
  STD_PROPERTIES* = 10
  STD_REDOW* = 4
  STD_REPLACE* = 13
  STD_UNDO* = 3
  VIEW_LARGEICONS* = 0
  VIEW_SMALLICONS* = 1
  VIEW_LIST* = 2
  VIEW_DETAILS* = 3
  VIEW_SORTNAME* = 4
  VIEW_SORTSIZE* = 5
  VIEW_SORTDATE* = 6
  VIEW_SORTTYPE* = 7
  # Toolbar styles
  TBSTYLE_ALTDRAG* = 1024
  TBSTYLE_TOOLTIPS* = 256
  TBSTYLE_WRAPABLE* = 512
  TBSTYLE_BUTTON* = 0
  TBSTYLE_CHECK* = 2
  TBSTYLE_CHECKGROUP* = 6
  TBSTYLE_GROUP* = 4
  TBSTYLE_SEP* = 1
  # Toolbar states
  TBSTATE_CHECKED* = 1
  TBSTATE_ENABLED* = 4
  TBSTATE_HIDDEN* = 8
  TBSTATE_INDETERMINATE* = 16
  TBSTATE_PRESSED* = 2
  TBSTATE_WRAP* = 32
  # Tooltip styles
  TTS_ALWAYSTIP* = 1
  TTS_NOPREFIX* = 2
  # TOOLINFO structure
  TTF_IDISHWND* = 1
  TTF_CENTERTIP* = 2
  TTF_RTLREADING* = 4
  TTF_SUBCLASS* = 16
  # TTM_SETDELAYTIME message
  TTDT_AUTOMATIC* = 0
  TTDT_AUTOPOP* = 2
  TTDT_INITIAL* = 3
  TTDT_RESHOW* = 1
  # Status window
  SBARS_SIZEGRIP* = 256
  #SBARS_SIZEGRIP = 256;already above
  # DL_DRAGGING message
  DL_MOVECURSOR* = 3
  DL_COPYCURSOR* = 2
  DL_STOPCURSOR* = 1
  # Up-down control styles
  UDS_ALIGNLEFT* = 8
  UDS_ALIGNRIGHT* = 4
  UDS_ARROWKEYS* = 32
  UDS_AUTOBUDDY* = 16
  UDS_HORZ* = 64
  UDS_NOTHOUSANDS* = 128
  UDS_SETBUDDYINT* = 2
  UDS_WRAP* = 1
  # UDM_SETRANGE message
  UD_MAXVAL* = 32767
  UD_MINVAL* = -32767
  # HKM_GETHOTKEY message
  HOTKEYF_ALT* = 4
  HOTKEYF_CONTROL* = 2
  HOTKEYF_EXT* = 8
  HOTKEYF_SHIFT* = 1
  # HKM_SETRULES message
  HKCOMB_A* = 8
  HKCOMB_C* = 4
  HKCOMB_CA* = 64
  HKCOMB_NONE* = 1
  HKCOMB_S* = 2
  HKCOMB_SA* = 32
  HKCOMB_SC* = 16
  HKCOMB_SCA* = 128
  # Trackbar styles
  TBS_HORZ* = 0
  TBS_VERT* = 2
  TBS_AUTOTICKS* = 1
  TBS_NOTICKS* = 16
  TBS_TOP* = 4
  TBS_BOTTOM* = 0
  TBS_LEFT* = 4
  TBS_RIGHT* = 0
  TBS_BOTH* = 8
  TBS_ENABLESELRANGE* = 32
  TBS_FIXEDLENGTH* = 64
  TBS_NOTHUMB* = 128
  TB_BOTTOM* = 7
  TB_ENDTRACK* = 8
  TB_LINEDOWN* = 1
  TB_LINEUP* = 0
  TB_PAGEDOWN* = 3
  TB_PAGEUP* = 2
  TB_THUMBPOSITION* = 4
  TB_THUMBTRACK* = 5
  TB_TOP* = 6
  # List view styles
  LVS_ALIGNLEFT* = 2048
  LVS_ALIGNTOP* = 0
  LVS_AUTOARRANGE* = 256
  LVS_EDITLABELS* = 512
  LVS_ICON* = 0
  LVS_LIST* = 3
  LVS_NOCOLUMNHEADER* = 16384
  LVS_NOLABELWRAP* = 128
  LVS_NOSCROLL* = 8192
  LVS_NOSORTHEADER* = 32768
  LVS_OWNERDRAWFIXED* = 1024
  LVS_REPORT* = 1
  LVS_SHAREIMAGELISTS* = 64
  LVS_SHOWSELALWAYS* = 8
  LVS_SINGLESEL* = 4
  LVS_SMALLICON* = 2
  LVS_SORTASCENDING* = 16
  LVS_SORTDESCENDING* = 32
  LVS_TYPESTYLEMASK* = 64512
  LVSIL_NORMAL* = 0
  LVSIL_SMALL* = 1
  LVSIL_STATE* = 2
  LVIS_CUT* = 4
  LVIS_DROPHILITED* = 8
  LVIS_FOCUSED* = 1
  LVIS_SELECTED* = 2
  LVIS_OVERLAYMASK* = 3840
  LVIS_STATEIMAGEMASK* = 61440

  LPSTR_TEXTCALLBACKW* = cast[LPWSTR](-1)
  LPSTR_TEXTCALLBACKA* = cast[LPSTR](-1)
when defined(winUnicode):
  const LPSTR_TEXTCALLBACK*  = cast[LPWSTR](-1)
else:
  const LPSTR_TEXTCALLBACK*  = cast[LPSTR](-1)

const
  LVIF_TEXT* = 1
  LVIF_IMAGE* = 2
  LVIF_PARAM* = 4
  LVIF_STATE* = 8
  LVIF_DI_SETITEM* = 4096
  # LVM_GETNEXTITEM structure
  LVNI_ABOVE* = 256
  LVNI_ALL* = 0
  LVNI_BELOW* = 512
  LVNI_TOLEFT* = 1024
  LVNI_TORIGHT* = 2048
  LVNI_CUT* = 4
  LVNI_DROPHILITED* = 8
  LVNI_FOCUSED* = 1
  LVNI_SELECTED* = 2
  # LV_FINDINFO structure
  LVFI_PARAM* = 1
  LVFI_PARTIAL* = 8
  LVFI_STRING* = 2
  LVFI_WRAP* = 32
  LVFI_NEARESTXY* = 64
  # LV_HITTESTINFO structure
  LVHT_ABOVE* = 8
  LVHT_BELOW* = 16
  LVHT_NOWHERE* = 1
  LVHT_ONITEMICON* = 2
  LVHT_ONITEMLABEL* = 4
  LVHT_ONITEMSTATEICON* = 8
  LVHT_TOLEFT* = 64
  LVHT_TORIGHT* = 32
  # LV_COLUMN structure
  LVCF_FMT* = 1
  LVCF_SUBITEM* = 8
  LVCF_TEXT* = 4
  LVCF_WIDTH* = 2
  LVCFMT_CENTER* = 2
  LVCFMT_LEFT* = 0
  LVCFMT_RIGHT* = 1
  # ListView_GetItemRect
  LVIR_BOUNDS* = 0
  LVIR_ICON* = 1
  LVIR_LABEL* = 2
  LVIR_SELECTBOUNDS* = 3
  # LVM_ARRANGE message
  LVA_ALIGNLEFT* = 1
  LVA_ALIGNTOP* = 2
  LVA_DEFAULT* = 0
  LVA_SNAPTOGRID* = 5
  # LVM_SETCOLUMNWIDTH message
  LVSCW_AUTOSIZE* = -1
  LVSCW_AUTOSIZE_USEHEADER* = -2
  # Tree View styles
  TVS_DISABLEDRAGDROP* = 16
  TVS_EDITLABELS* = 8
  TVS_HASBUTTONS* = 1
  TVS_HASLINES* = 2
  TVS_LINESATROOT* = 4
  TVS_SHOWSELALWAYS* = 32
  # Tree View states
  TVIS_BOLD* = 16
  TVIS_CUT* = 4
  TVIS_DROPHILITED* = 8
  TVIS_EXPANDED* = 32
  TVIS_EXPANDEDONCE* = 64
  TVIS_FOCUSED* = 1
  TVIS_OVERLAYMASK* = 3840
  TVIS_SELECTED* = 2
  TVIS_STATEIMAGEMASK* = 61440
  TVIS_USERMASK* = 61440
  # TV_ITEM structure
  TVIF_CHILDREN* = 64
  TVIF_HANDLE* = 16
  TVIF_IMAGE* = 2
  TVIF_PARAM* = 4
  TVIF_SELECTEDIMAGE* = 32
  TVIF_STATE* = 8
  TVIF_TEXT* = 1
  I_CHILDRENCALLBACK* = -1
  I_IMAGECALLBACK* = -1
  # TV_INSERTSTRUCT structure

type
  TTREEITEM* {.final, pure.} = object
  HTREEITEM* = ptr TTREEITEM
  PTREEITEM* = ptr TTREEITEM

const
  TVI_ROOT* =  cast[HTREEITEM](0xFFFF0000)
  TVI_FIRST* = cast[HTREEITEM](0xFFFF0001)
  TVI_LAST* =  cast[HTREEITEM](0xFFFF0002)
  TVI_SORT* =  cast[HTREEITEM](0xFFFF0003)

const
  # TV_HITTESTINFO structure
  TVHT_ABOVE* = 256
  TVHT_BELOW* = 512
  TVHT_NOWHERE* = 1
  TVHT_ONITEM* = 70
  TVHT_ONITEMBUTTON* = 16
  TVHT_ONITEMICON* = 2
  TVHT_ONITEMINDENT* = 8
  TVHT_ONITEMLABEL* = 4
  TVHT_ONITEMRIGHT* = 32
  TVHT_ONITEMSTATEICON* = 64
  TVHT_TOLEFT* = 2048
  TVHT_TORIGHT* = 1024
  # TVM_EXPAND message
  TVE_COLLAPSE* = 1
  TVE_COLLAPSERESET* = 32768
  TVE_EXPAND* = 2
  TVE_TOGGLE* = 3
  # TVM_GETIMAGELIST message
  TVSIL_NORMAL* = 0
  TVSIL_STATE* = 2
  # TVM_GETNEXTITEM message
  TVGN_CARET* = 9
  TVGN_CHILD* = 4
  TVGN_DROPHILITE* = 8
  TVGN_FIRSTVISIBLE* = 5
  TVGN_NEXT* = 1
  TVGN_NEXTVISIBLE* = 6
  TVGN_PARENT* = 3
  TVGN_PREVIOUS* = 2
  TVGN_PREVIOUSVISIBLE* = 7
  TVGN_ROOT* = 0
  # TVN_SELCHANGED message
  TVC_BYKEYBOARD* = 2
  TVC_BYMOUSE* = 1
  TVC_UNKNOWN* = 0
  # Tab control styles
  TCS_BUTTONS* = 256
  TCS_FIXEDWIDTH* = 1024
  TCS_FOCUSNEVER* = 32768
  TCS_FOCUSONBUTTONDOWN* = 4096
  TCS_FORCEICONLEFT* = 16
  TCS_FORCELABELLEFT* = 32
  TCS_MULTILINE* = 512
  TCS_OWNERDRAWFIXED* = 8192
  TCS_RAGGEDRIGHT* = 2048
  TCS_RIGHTJUSTIFY* = 0
  TCS_SINGLELINE* = 0
  TCS_TABS* = 0
  TCS_TOOLTIPS* = 16384
  # TC_ITEM structure
  TCIF_TEXT* = 1
  TCIF_IMAGE* = 2
  TCIF_PARAM* = 8
  TCIF_RTLREADING* = 4
  # TC_HITTESTINFO structure
  TCHT_NOWHERE* = 1
  TCHT_ONITEM* = 6
  TCHT_ONITEMICON* = 2
  TCHT_ONITEMLABEL* = 4
  # Animation control styles
  ACS_AUTOPLAY* = 4
  ACS_CENTER* = 1
  ACS_TRANSPARENT* = 2
  # MODEMDEVCAPS structure
  DIALOPTION_BILLING* = 64
  DIALOPTION_QUIET* = 128
  DIALOPTION_DIALTONE* = 256
  MDMVOLFLAG_LOW* = 1
  MDMVOLFLAG_MEDIUM* = 2
  MDMVOLFLAG_HIGH* = 4
  MDMVOL_LOW* = 0
  MDMVOL_MEDIUM* = 1
  MDMVOL_HIGH* = 2
  MDMSPKRFLAG_OFF* = 1
  MDMSPKRFLAG_DIAL* = 2
  MDMSPKRFLAG_ON* = 4
  MDMSPKRFLAG_CALLSETUP* = 8
  MDMSPKR_OFF* = 0
  MDMSPKR_DIAL* = 1
  MDMSPKR_ON* = 2
  MDMSPKR_CALLSETUP* = 3
  MDM_BLIND_DIAL* = 512
  MDM_CCITT_OVERRIDE* = 64
  MDM_CELLULAR* = 8
  MDM_COMPRESSION* = 1
  MDM_ERROR_CONTROL* = 2
  MDM_FLOWCONTROL_HARD* = 16
  MDM_FLOWCONTROL_SOFT* = 32
  MDM_FORCED_EC* = 4
  MDM_SPEED_ADJUST* = 128
  MDM_TONE_DIAL* = 256
  MDM_V23_OVERRIDE* = 1024

  # Languages
  #
  #  Language IDs.
  #
  #  The following two combinations of primary language ID and
  #  sublanguage ID have special semantics:
  #
  #    Primary Language ID   Sublanguage ID      Result
  #    -------------------   ---------------     ------------------------
  #    LANG_NEUTRAL          SUBLANG_NEUTRAL     Language neutral
  #    LANG_NEUTRAL          SUBLANG_DEFAULT     User default language
  #    LANG_NEUTRAL          SUBLANG_SYS_DEFAULT System default language
  #    LANG_INVARIANT        SUBLANG_NEUTRAL     Invariant locale
  #
  #
  #  Primary language IDs.
  #
  LANG_NEUTRAL* = 0x00000000
  LANG_INVARIANT* = 0x0000007F
  LANG_AFRIKAANS* = 0x00000036
  LANG_ALBANIAN* = 0x0000001C
  LANG_ARABIC* = 0x00000001
  LANG_ARMENIAN* = 0x0000002B
  LANG_ASSAMESE* = 0x0000004D
  LANG_AZERI* = 0x0000002C
  LANG_BASQUE* = 0x0000002D
  LANG_BELARUSIAN* = 0x00000023
  LANG_BENGALI* = 0x00000045
  LANG_BULGARIAN* = 0x00000002
  LANG_CATALAN* = 0x00000003
  LANG_CHINESE* = 0x00000004
  LANG_CROATIAN* = 0x0000001A
  LANG_CZECH* = 0x00000005
  LANG_DANISH* = 0x00000006
  LANG_DIVEHI* = 0x00000065
  LANG_DUTCH* = 0x00000013
  LANG_ENGLISH* = 0x00000009
  LANG_ESTONIAN* = 0x00000025
  LANG_FAEROESE* = 0x00000038
  LANG_FARSI* = 0x00000029
  LANG_FINNISH* = 0x0000000B
  LANG_FRENCH* = 0x0000000C
  LANG_GALICIAN* = 0x00000056
  LANG_GEORGIAN* = 0x00000037
  LANG_GERMAN* = 0x00000007
  LANG_GREEK* = 0x00000008
  LANG_GUJARATI* = 0x00000047
  LANG_HEBREW* = 0x0000000D
  LANG_HINDI* = 0x00000039
  LANG_HUNGARIAN* = 0x0000000E
  LANG_ICELANDIC* = 0x0000000F
  LANG_INDONESIAN* = 0x00000021
  LANG_ITALIAN* = 0x00000010
  LANG_JAPANESE* = 0x00000011
  LANG_KANNADA* = 0x0000004B
  LANG_KASHMIRI* = 0x00000060
  LANG_KAZAK* = 0x0000003F
  LANG_KONKANI* = 0x00000057
  LANG_KOREAN* = 0x00000012
  LANG_KYRGYZ* = 0x00000040
  LANG_LATVIAN* = 0x00000026
  LANG_LITHUANIAN* = 0x00000027
  LANG_MACEDONIAN* = 0x0000002F # the Former Yugoslav Republic of Macedonia
  LANG_MALAY* = 0x0000003E
  LANG_MALAYALAM* = 0x0000004C
  LANG_MANIPURI* = 0x00000058
  LANG_MARATHI* = 0x0000004E
  LANG_MONGOLIAN* = 0x00000050
  LANG_NEPALI* = 0x00000061
  LANG_NORWEGIAN* = 0x00000014
  LANG_ORIYA* = 0x00000048
  LANG_POLISH* = 0x00000015
  LANG_PORTUGUESE* = 0x00000016
  LANG_PUNJABI* = 0x00000046
  LANG_ROMANIAN* = 0x00000018
  LANG_RUSSIAN* = 0x00000019
  LANG_SANSKRIT* = 0x0000004F
  LANG_SERBIAN* = 0x0000001A
  LANG_SINDHI* = 0x00000059
  LANG_SLOVAK* = 0x0000001B
  LANG_SLOVENIAN* = 0x00000024
  LANG_SPANISH* = 0x0000000A
  LANG_SWAHILI* = 0x00000041
  LANG_SWEDISH* = 0x0000001D
  LANG_SYRIAC* = 0x0000005A
  LANG_TAMIL* = 0x00000049
  LANG_TATAR* = 0x00000044
  LANG_TELUGU* = 0x0000004A
  LANG_THAI* = 0x0000001E
  LANG_TURKISH* = 0x0000001F
  LANG_UKRAINIAN* = 0x00000022
  LANG_URDU* = 0x00000020
  LANG_UZBEK* = 0x00000043
  LANG_VIETNAMESE* = 0x0000002A
  #
  #  Sublanguage IDs.
  #
  #  The name immediately following SUBLANG_ dictates which primary
  #  language ID that sublanguage ID can be combined with to form a
  #  valid language ID.
  #
  SUBLANG_NEUTRAL* = 0x00000000 # language neutral
  SUBLANG_DEFAULT* = 0x00000001 # user default
  SUBLANG_SYS_DEFAULT* = 0x00000002 # system default
  SUBLANG_ARABIC_SAUDI_ARABIA* = 0x00000001 # Arabic (Saudi Arabia)
  SUBLANG_ARABIC_IRAQ* = 0x00000002 # Arabic (Iraq)
  SUBLANG_ARABIC_EGYPT* = 0x00000003 # Arabic (Egypt)
  SUBLANG_ARABIC_LIBYA* = 0x00000004 # Arabic (Libya)
  SUBLANG_ARABIC_ALGERIA* = 0x00000005 # Arabic (Algeria)
  SUBLANG_ARABIC_MOROCCO* = 0x00000006 # Arabic (Morocco)
  SUBLANG_ARABIC_TUNISIA* = 0x00000007 # Arabic (Tunisia)
  SUBLANG_ARABIC_OMAN* = 0x00000008 # Arabic (Oman)
  SUBLANG_ARABIC_YEMEN* = 0x00000009 # Arabic (Yemen)
  SUBLANG_ARABIC_SYRIA* = 0x0000000A # Arabic (Syria)
  SUBLANG_ARABIC_JORDAN* = 0x0000000B # Arabic (Jordan)
  SUBLANG_ARABIC_LEBANON* = 0x0000000C # Arabic (Lebanon)
  SUBLANG_ARABIC_KUWAIT* = 0x0000000D # Arabic (Kuwait)
  SUBLANG_ARABIC_UAE* = 0x0000000E # Arabic (U.A.E)
  SUBLANG_ARABIC_BAHRAIN* = 0x0000000F # Arabic (Bahrain)
  SUBLANG_ARABIC_QATAR* = 0x00000010 # Arabic (Qatar)
  SUBLANG_AZERI_LATIN* = 0x00000001 # Azeri (Latin)
  SUBLANG_AZERI_CYRILLIC* = 0x00000002 # Azeri (Cyrillic)
  SUBLANG_CHINESE_TRADITIONAL* = 0x00000001 # Chinese (Taiwan)
  SUBLANG_CHINESE_SIMPLIFIED* = 0x00000002 # Chinese (PR China)
  SUBLANG_CHINESE_HONGKONG* = 0x00000003 # Chinese (Hong Kong S.A.R., P.R.C.)
  SUBLANG_CHINESE_SINGAPORE* = 0x00000004 # Chinese (Singapore)
  SUBLANG_CHINESE_MACAU* = 0x00000005 # Chinese (Macau S.A.R.)
  SUBLANG_DUTCH* = 0x00000001 # Dutch
  SUBLANG_DUTCH_BELGIAN* = 0x00000002 # Dutch (Belgian)
  SUBLANG_ENGLISH_US* = 0x00000001 # English (USA)
  SUBLANG_ENGLISH_UK* = 0x00000002 # English (UK)
  SUBLANG_ENGLISH_AUS* = 0x00000003 # English (Australian)
  SUBLANG_ENGLISH_CAN* = 0x00000004 # English (Canadian)
  SUBLANG_ENGLISH_NZ* = 0x00000005 # English (New Zealand)
  SUBLANG_ENGLISH_EIRE* = 0x00000006 # English (Irish)
  SUBLANG_ENGLISH_SOUTH_AFRICA* = 0x00000007 # English (South Africa)
  SUBLANG_ENGLISH_JAMAICA* = 0x00000008 # English (Jamaica)
  SUBLANG_ENGLISH_CARIBBEAN* = 0x00000009 # English (Caribbean)
  SUBLANG_ENGLISH_BELIZE* = 0x0000000A # English (Belize)
  SUBLANG_ENGLISH_TRINIDAD* = 0x0000000B # English (Trinidad)
  SUBLANG_ENGLISH_ZIMBABWE* = 0x0000000C # English (Zimbabwe)
  SUBLANG_ENGLISH_PHILIPPINES* = 0x0000000D # English (Philippines)
  SUBLANG_FRENCH* = 0x00000001 # French
  SUBLANG_FRENCH_BELGIAN* = 0x00000002 # French (Belgian)
  SUBLANG_FRENCH_CANADIAN* = 0x00000003 # French (Canadian)
  SUBLANG_FRENCH_SWISS* = 0x00000004 # French (Swiss)
  SUBLANG_FRENCH_LUXEMBOURG* = 0x00000005 # French (Luxembourg)
  SUBLANG_FRENCH_MONACO* = 0x00000006 # French (Monaco)
  SUBLANG_GERMAN* = 0x00000001 # German
  SUBLANG_GERMAN_SWISS* = 0x00000002 # German (Swiss)
  SUBLANG_GERMAN_AUSTRIAN* = 0x00000003 # German (Austrian)
  SUBLANG_GERMAN_LUXEMBOURG* = 0x00000004 # German (Luxembourg)
  SUBLANG_GERMAN_LIECHTENSTEIN* = 0x00000005 # German (Liechtenstein)
  SUBLANG_ITALIAN* = 0x00000001 # Italian
  SUBLANG_ITALIAN_SWISS* = 0x00000002 # Italian (Swiss)
  SUBLANG_KASHMIRI_SASIA* = 0x00000002 # Kashmiri (South Asia)
  SUBLANG_KASHMIRI_INDIA* = 0x00000002 # For app compatibility only
  SUBLANG_KOREAN* = 0x00000001 # Korean (Extended Wansung)
  SUBLANG_LITHUANIAN* = 0x00000001 # Lithuanian
  SUBLANG_MALAY_MALAYSIA* = 0x00000001 # Malay (Malaysia)
  SUBLANG_MALAY_BRUNEI_DARUSSALAM* = 0x00000002 # Malay (Brunei Darussalam)
  SUBLANG_NEPALI_INDIA* = 0x00000002 # Nepali (India)
  SUBLANG_NORWEGIAN_BOKMAL* = 0x00000001 # Norwegian (Bokmal)
  SUBLANG_NORWEGIAN_NYNORSK* = 0x00000002 # Norwegian (Nynorsk)
  SUBLANG_PORTUGUESE* = 0x00000002 # Portuguese
  SUBLANG_PORTUGUESE_BRAZILIAN* = 0x00000001 # Portuguese (Brazilian)
  SUBLANG_SERBIAN_LATIN* = 0x00000002 # Serbian (Latin)
  SUBLANG_SERBIAN_CYRILLIC* = 0x00000003 # Serbian (Cyrillic)
  SUBLANG_SPANISH* = 0x00000001 # Spanish (Castilian)
  SUBLANG_SPANISH_MEXICAN* = 0x00000002 # Spanish (Mexican)
  SUBLANG_SPANISH_MODERN* = 0x00000003 # Spanish (Spain)
  SUBLANG_SPANISH_GUATEMALA* = 0x00000004 # Spanish (Guatemala)
  SUBLANG_SPANISH_COSTA_RICA* = 0x00000005 # Spanish (Costa Rica)
  SUBLANG_SPANISH_PANAMA* = 0x00000006 # Spanish (Panama)
  SUBLANG_SPANISH_DOMINICAN_REPUBLIC* = 0x00000007 # Spanish (Dominican Republic)
  SUBLANG_SPANISH_VENEZUELA* = 0x00000008 # Spanish (Venezuela)
  SUBLANG_SPANISH_COLOMBIA* = 0x00000009 # Spanish (Colombia)
  SUBLANG_SPANISH_PERU* = 0x0000000A # Spanish (Peru)
  SUBLANG_SPANISH_ARGENTINA* = 0x0000000B # Spanish (Argentina)
  SUBLANG_SPANISH_ECUADOR* = 0x0000000C # Spanish (Ecuador)
  SUBLANG_SPANISH_CHILE* = 0x0000000D # Spanish (Chile)
  SUBLANG_SPANISH_URUGUAY* = 0x0000000E # Spanish (Uruguay)
  SUBLANG_SPANISH_PARAGUAY* = 0x0000000F # Spanish (Paraguay)
  SUBLANG_SPANISH_BOLIVIA* = 0x00000010 # Spanish (Bolivia)
  SUBLANG_SPANISH_EL_SALVADOR* = 0x00000011 # Spanish (El Salvador)
  SUBLANG_SPANISH_HONDURAS* = 0x00000012 # Spanish (Honduras)
  SUBLANG_SPANISH_NICARAGUA* = 0x00000013 # Spanish (Nicaragua)
  SUBLANG_SPANISH_PUERTO_RICO* = 0x00000014 # Spanish (Puerto Rico)
  SUBLANG_SWEDISH* = 0x00000001 # Swedish
  SUBLANG_SWEDISH_FINLAND* = 0x00000002 # Swedish (Finland)
  SUBLANG_URDU_PAKISTAN* = 0x00000001 # Urdu (Pakistan)
  SUBLANG_URDU_INDIA* = 0x00000002 # Urdu (India)
  SUBLANG_UZBEK_LATIN* = 0x00000001 # Uzbek (Latin)
  SUBLANG_UZBEK_CYRILLIC* = 0x00000002 # Uzbek (Cyrillic)
                                       #
                                       #  Sorting IDs.
                                       #
  SORT_DEFAULT* = 0x00000000  # sorting default
  SORT_JAPANESE_XJIS* = 0x00000000 # Japanese XJIS order
  SORT_JAPANESE_UNICODE* = 0x00000001 # Japanese Unicode order
  SORT_CHINESE_BIG5* = 0x00000000 # Chinese BIG5 order
  SORT_CHINESE_PRCP* = 0x00000000 # PRC Chinese Phonetic order
  SORT_CHINESE_UNICODE* = 0x00000001 # Chinese Unicode order
  SORT_CHINESE_PRC* = 0x00000002 # PRC Chinese Stroke Count order
  SORT_CHINESE_BOPOMOFO* = 0x00000003 # Traditional Chinese Bopomofo order
  SORT_KOREAN_KSC* = 0x00000000 # Korean KSC order
  SORT_KOREAN_UNICODE* = 0x00000001 # Korean Unicode order
  SORT_GERMAN_PHONE_BOOK* = 0x00000001 # German Phone Book order
  SORT_HUNGARIAN_DEFAULT* = 0x00000000 # Hungarian Default order
  SORT_HUNGARIAN_TECHNICAL* = 0x00000001 # Hungarian Technical order
  SORT_GEORGIAN_TRADITIONAL* = 0x00000000 # Georgian Traditional order
  SORT_GEORGIAN_MODERN* = 0x00000001 # Georgian Modern order
                                     # SYSTEM_INFO structure
  PROCESSOR_INTEL_386* = 386
  PROCESSOR_INTEL_486* = 486
  PROCESSOR_INTEL_PENTIUM* = 586
  PROCESSOR_MIPS_R4000* = 4000
  PROCESSOR_ALPHA_21064* = 21064
  # FSCTL_SET_COMPRESSION
  COMPRESSION_FORMAT_NONE* = 0
  COMPRESSION_FORMAT_DEFAULT* = 1
  COMPRESSION_FORMAT_LZNT1* = 2
  # TAPE_GET_DRIVE_PARAMETERS structure
  TAPE_DRIVE_COMPRESSION* = 131072
  TAPE_DRIVE_ECC* = 65536
  TAPE_DRIVE_ERASE_BOP_ONLY* = 64
  TAPE_DRIVE_ERASE_LONG* = 32
  TAPE_DRIVE_ERASE_IMMEDIATE* = 128
  TAPE_DRIVE_ERASE_SHORT* = 16
  TAPE_DRIVE_FIXED* = 1
  TAPE_DRIVE_FIXED_BLOCK* = 1024
  TAPE_DRIVE_INITIATOR* = 4
  TAPE_DRIVE_PADDING* = 262144
  TAPE_DRIVE_GET_ABSOLUTE_BLK* = 1048576
  TAPE_DRIVE_GET_LOGICAL_BLK* = 2097152
  TAPE_DRIVE_REPORT_SMKS* = 524288
  TAPE_DRIVE_SELECT* = 2
  TAPE_DRIVE_SET_EOT_WZ_SIZE* = 4194304
  TAPE_DRIVE_TAPE_CAPACITY* = 256
  TAPE_DRIVE_TAPE_REMAINING* = 512
  TAPE_DRIVE_VARIABLE_BLOCK* = 2048
  TAPE_DRIVE_WRITE_PROTECT* = 4096
  TAPE_DRIVE_ABS_BLK_IMMED* = -2147475456
  TAPE_DRIVE_ABSOLUTE_BLK* = -2147479552
  TAPE_DRIVE_END_OF_DATA* = -2147418112
  TAPE_DRIVE_FILEMARKS* = -2147221504
  TAPE_DRIVE_LOAD_UNLOAD* = -2147483647
  TAPE_DRIVE_LOAD_UNLD_IMMED* = -2147483616
  TAPE_DRIVE_LOCK_UNLOCK* = -2147483644
  TAPE_DRIVE_LOCK_UNLK_IMMED* = -2147483520
  TAPE_DRIVE_LOG_BLK_IMMED* = -2147450880
  TAPE_DRIVE_LOGICAL_BLK* = -2147467264
  TAPE_DRIVE_RELATIVE_BLKS* = -2147352576
  TAPE_DRIVE_REVERSE_POSITION* = -2143289344
  TAPE_DRIVE_REWIND_IMMEDIATE* = -2147483640
  TAPE_DRIVE_SEQUENTIAL_FMKS* = -2146959360
  TAPE_DRIVE_SEQUENTIAL_SMKS* = -2145386496
  TAPE_DRIVE_SET_BLOCK_SIZE* = -2147483632
  TAPE_DRIVE_SET_COMPRESSION* = -2147483136
  TAPE_DRIVE_SET_ECC* = -2147483392
  TAPE_DRIVE_SET_PADDING* = -2147482624
  TAPE_DRIVE_SET_REPORT_SMKS* = -2147481600
  TAPE_DRIVE_SETMARKS* = -2146435072
  TAPE_DRIVE_SPACE_IMMEDIATE* = -2139095040
  TAPE_DRIVE_TENSION* = -2147483646
  TAPE_DRIVE_TENSION_IMMED* = -2147483584
  TAPE_DRIVE_WRITE_FILEMARKS* = -2113929216
  TAPE_DRIVE_WRITE_LONG_FMKS* = -2013265920
  TAPE_DRIVE_WRITE_MARK_IMMED* = -1879048192
  TAPE_DRIVE_WRITE_SETMARKS* = -2130706432
  TAPE_DRIVE_WRITE_SHORT_FMKS* = -2080374784
  # Standard rights
  STANDARD_RIGHTS_REQUIRED* = 0x000F0000
  STANDARD_RIGHTS_WRITE* = 0x00020000
  STANDARD_RIGHTS_READ* = 0x00020000
  STANDARD_RIGHTS_EXECUTE* = 0x00020000
  STANDARD_RIGHTS_ALL* = 0x001F0000
  SPECIFIC_RIGHTS_ALL* = 0x0000FFFF

  FILE_GENERIC_READ* = STANDARD_RIGHTS_READ or
      FILE_READ_DATA or
      FILE_READ_ATTRIBUTES or
      FILE_READ_EA or
      SYNCHRONIZE
  FILE_GENERIC_WRITE* = STANDARD_RIGHTS_WRITE or
      FILE_WRITE_DATA or
      FILE_WRITE_ATTRIBUTES or
      FILE_WRITE_EA or
      FILE_APPEND_DATA or
      SYNCHRONIZE
  FILE_GENERIC_EXECUTE* = STANDARD_RIGHTS_EXECUTE or
      FILE_READ_ATTRIBUTES or
      FILE_EXECUTE or
      SYNCHRONIZE
  FILE_ALL_ACCESS* = STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or 0x1FF

  # ACCESS_MASK
  MAXIMUM_ALLOWED* = 0x02000000
  GENERIC_ALL* = 0x10000000
  # SID
  SECURITY_NULL_RID* = 0
  SECURITY_WORLD_RID* = 0
  SECURITY_LOCAL_RID* = 0
  SECURITY_CREATOR_OWNER_RID* = 0
  SECURITY_CREATOR_GROUP_RID* = 0x00000001
  SECURITY_DIALUP_RID* = 0x00000001
  SECURITY_NETWORK_RID* = 0x00000002
  SECURITY_BATCH_RID* = 0x00000003
  SECURITY_INTERACTIVE_RID* = 0x00000004
  SECURITY_LOGON_IDS_RID* = 0x00000005
  SECURITY_LOGON_IDS_RID_COUNT* = 0x00000003
  SECURITY_SERVICE_RID* = 0x00000006
  SECURITY_LOCAL_SYSTEM_RID* = 0x00000012
  SECURITY_BUILTIN_DOMAIN_RID* = 0x00000020
  DOMAIN_USER_RID_ADMIN* = 0x000001F4
  DOMAIN_USER_RID_GUEST* = 0x000001F5
  DOMAIN_GROUP_RID_ADMINS* = 0x00000200
  DOMAIN_GROUP_RID_USERS* = 0x00000201
  DOMAIN_ALIAS_RID_ADMINS* = 0x00000220
  DOMAIN_ALIAS_RID_USERS* = 0x00000221
  DOMAIN_ALIAS_RID_GUESTS* = 0x00000222
  DOMAIN_ALIAS_RID_POWER_USERS* = 0x00000223
  DOMAIN_ALIAS_RID_ACCOUNT_OPS* = 0x00000224
  DOMAIN_ALIAS_RID_SYSTEM_OPS* = 0x00000225
  DOMAIN_ALIAS_RID_PRINT_OPS* = 0x00000226
  DOMAIN_ALIAS_RID_BACKUP_OPS* = 0x00000227
  DOMAIN_ALIAS_RID_REPLICATOR* = 0x00000228
  # TOKEN_GROUPS structure
  SE_GROUP_MANDATORY* = 0x00000001
  SE_GROUP_ENABLED_BY_DEFAULT* = 0x00000002
  SE_GROUP_ENABLED* = 0x00000004
  SE_GROUP_OWNER* = 0x00000008
  SE_GROUP_LOGON_ID* = 0xC0000000
  # ACL Defines
  ACL_REVISION* = 2
  # ACE_HEADER structure
  ACCESS_ALLOWED_ACE_TYPE* = 0x00000000
  ACCESS_DENIED_ACE_TYPE* = 0x00000001
  SYSTEM_AUDIT_ACE_TYPE* = 0x00000002
  SYSTEM_ALARM_ACE_TYPE* = 0x00000003
  # ACE flags in the ACE_HEADER structure
  OBJECT_INHERIT_ACE* = 0x00000001
  CONTAINER_INHERIT_ACE* = 0x00000002
  NO_PROPAGATE_INHERIT_ACE* = 0x00000004
  INHERIT_ONLY_ACE* = 0x00000008
  SUCCESSFUL_ACCESS_ACE_FLAG* = 0x00000040
  FAILED_ACCESS_ACE_FLAG* = 0x00000080
  # SECURITY_DESCRIPTOR_CONTROL
  #SECURITY_DESCRIPTOR_REVISION = 1;already defined above
  SECURITY_DESCRIPTOR_MIN_LENGTH* = 20
  SE_OWNER_DEFAULTED* = 1
  SE_GROUP_DEFAULTED* = 2
  SE_DACL_PRESENT* = 4
  SE_DACL_DEFAULTED* = 8
  SE_SACL_PRESENT* = 16
  SE_SACL_DEFAULTED* = 32
  SE_SELF_RELATIVE* = 32768
  # PRIVILEGE_SET
  SE_PRIVILEGE_ENABLED_BY_DEFAULT* = 0x00000001
  SE_PRIVILEGE_ENABLED* = 0x00000002
  SE_PRIVILEGE_USED_FOR_ACCESS* = 0x80000000
  PRIVILEGE_SET_ALL_NECESSARY* = 0x00000001
  # OPENFILENAME structure
  OFN_ALLOWMULTISELECT* = 0x00000200
  OFN_CREATEPROMPT* = 0x00002000
  OFN_ENABLEHOOK* = 0x00000020
  OFN_ENABLETEMPLATE* = 0x00000040
  OFN_ENABLETEMPLATEHANDLE* = 0x00000080
  OFN_EXPLORER* = 0x00080000
  OFN_EXTENSIONDIFFERENT* = 0x00000400
  OFN_FILEMUSTEXIST* = 0x00001000
  OFN_HIDEREADONLY* = 0x00000004
  OFN_LONGNAMES* = 0x00200000
  OFN_NOCHANGEDIR* = 0x00000008
  OFN_NODEREFERENCELINKS* = 0x00100000
  OFN_NOLONGNAMES* = 0x00040000
  OFN_NONETWORKBUTTON* = 0x00020000
  OFN_NOREADONLYRETURN* = 0x00008000
  OFN_NOTESTFILECREATE* = 0x00010000
  OFN_NOVALIDATE* = 0x00000100
  OFN_OVERWRITEPROMPT* = 0x00000002
  OFN_PATHMUSTEXIST* = 0x00000800
  OFN_READONLY* = 0x00000001
  OFN_SHAREAWARE* = 0x00004000
  OFN_SHOWHELP* = 0x00000010
  # SHAREVISTRING message
  OFN_SHAREFALLTHROUGH* = 0x00000002
  OFN_SHARENOWARN* = 0x00000001
  OFN_SHAREWARN* = 0
  # Open/Save notifications
  CDN_INITDONE* = 0xFFFFFDA7
  CDN_SELCHANGE* = 0xFFFFFDA6
  CDN_FOLDERCHANGE* = 0xFFFFFDA5
  CDN_SHAREVIOLATION* = 0xFFFFFDA4
  CDN_HELP* = 0xFFFFFDA3
  CDN_FILEOK* = 0xFFFFFDA2
  CDN_TYPECHANGE* = 0xFFFFFDA1
  # Open/Save messages
  CDM_GETFILEPATH* = 0x00000465
  CDM_GETFOLDERIDLIST* = 0x00000467
  CDM_GETFOLDERPATH* = 0x00000466
  CDM_GETSPEC* = 0x00000464
  CDM_HIDECONTROL* = 0x00000469
  CDM_SETCONTROLTEXT* = 0x00000468
  CDM_SETDEFEXT* = 0x0000046A
  # CHOOSECOLOR structure
  CC_ENABLEHOOK* = 0x00000010
  CC_ENABLETEMPLATE* = 0x00000020
  CC_ENABLETEMPLATEHANDLE* = 0x00000040
  CC_FULLOPEN* = 0x00000002
  CC_PREVENTFULLOPEN* = 0x00000004
  CC_RGBINIT* = 0x00000001
  CC_SHOWHELP* = 0x00000008
  CC_SOLIDCOLOR* = 0x00000080
  # FINDREPLACE structure
  FR_DIALOGTERM* = 0x00000040
  FR_DOWN* = 0x00000001
  FR_ENABLEHOOK* = 0x00000100
  FR_ENABLETEMPLATE* = 0x00000200
  FR_ENABLETEMPLATEHANDLE* = 0x00002000
  FR_FINDNEXT* = 0x00000008
  FR_HIDEUPDOWN* = 0x00004000
  FR_HIDEMATCHCASE* = 0x00008000
  FR_HIDEWHOLEWORD* = 0x00010000
  FR_MATCHCASE* = 0x00000004
  FR_NOMATCHCASE* = 0x00000800
  FR_NOUPDOWN* = 0x00000400
  FR_NOWHOLEWORD* = 0x00001000
  FR_REPLACE* = 0x00000010
  FR_REPLACEALL* = 0x00000020
  FR_SHOWHELP* = 0x00000080
  FR_WHOLEWORD* = 0x00000002
  # CHOOSEFONT structure
  CF_APPLY* = 0x00000200
  CF_ANSIONLY* = 0x00000400
  CF_BOTH* = 0x00000003
  CF_TTONLY* = 0x00040000
  CF_EFFECTS* = 0x00000100
  CF_ENABLEHOOK* = 0x00000008
  CF_ENABLETEMPLATE* = 0x00000010
  CF_ENABLETEMPLATEHANDLE* = 0x00000020
  CF_FIXEDPITCHONLY* = 0x00004000
  CF_FORCEFONTEXIST* = 0x00010000
  CF_INITTOLOGFONTSTRUCT* = 0x00000040
  CF_LIMITSIZE* = 0x00002000
  CF_NOOEMFONTS* = 0x00000800
  CF_NOFACESEL* = 0x00080000
  CF_NOSCRIPTSEL* = 0x00800000
  CF_NOSTYLESEL* = 0x00100000
  CF_NOSIZESEL* = 0x00200000
  CF_NOSIMULATIONS* = 0x00001000
  CF_NOVECTORFONTS* = 0x00000800
  CF_NOVERTFONTS* = 0x01000000
  CF_PRINTERFONTS* = 0x00000002
  CF_SCALABLEONLY* = 0x00020000
  CF_SCREENFONTS* = 0x00000001
  CF_SCRIPTSONLY* = 0x00000400
  CF_SELECTSCRIPT* = 0x00400000
  CF_SHOWHELP* = 0x00000004
  CF_USESTYLE* = 0x00000080
  CF_WYSIWYG* = 0x00008000
  BOLD_FONTTYPE* = 0x00000100
  ITALIC_FONTTYPE* = 0x00000200
  PRINTER_FONTTYPE* = 0x00004000
  REGULAR_FONTTYPE* = 0x00000400
  SCREEN_FONTTYPE* = 0x00002000
  SIMULATED_FONTTYPE* = 0x00008000
  # Common dialog messages
  COLOROKSTRINGW* = "commdlg_ColorOK"
  FILEOKSTRINGW* = "commdlg_FileNameOK"
  FINDMSGSTRINGW* = "commdlg_FindReplace"
  HELPMSGSTRINGW* = "commdlg_help"
  LBSELCHSTRINGW* = "commdlg_LBSelChangedNotify"
  SETRGBSTRINGW* = "commdlg_SetRGBColor"
  SHAREVISTRINGW* = "commdlg_ShareViolation"
  COLOROKSTRINGA* = "commdlg_ColorOK"
  FILEOKSTRINGA* = "commdlg_FileNameOK"
  FINDMSGSTRINGA* = "commdlg_FindReplace"
  HELPMSGSTRINGA* = "commdlg_help"
  LBSELCHSTRINGA* = "commdlg_LBSelChangedNotify"
  SETRGBSTRINGA* = "commdlg_SetRGBColor"
  SHAREVISTRINGA* = "commdlg_ShareViolation"

when defined(winUnicode):
  const
    COLOROKSTRING* = COLOROKSTRINGW
    FILEOKSTRING* = FILEOKSTRINGW
    FINDMSGSTRING* = FINDMSGSTRINGW
    HELPMSGSTRING* = HELPMSGSTRINGW
    LBSELCHSTRING* = LBSELCHSTRINGW
    SETRGBSTRING* = SETRGBSTRINGW
    SHAREVISTRING* = SHAREVISTRINGW
else:
  const
    COLOROKSTRING* = COLOROKSTRINGA
    FILEOKSTRING* = FILEOKSTRINGA
    FINDMSGSTRING* = FINDMSGSTRINGA
    HELPMSGSTRING* = HELPMSGSTRINGA
    LBSELCHSTRING* = LBSELCHSTRINGA
    SETRGBSTRING* = SETRGBSTRINGA
    SHAREVISTRING* = SHAREVISTRINGA

const
  # LBSELCHSTRING message
  CD_LBSELCHANGE* = 0
  CD_LBSELADD* = 2
  CD_LBSELSUB* = 1
  CD_LBSELNOITEMS* = -1
  # DEVNAMES structure
  DN_DEFAULTPRN* = 1
  # PRINTDLG structure
  PD_ALLPAGES* = 0
  PD_COLLATE* = 16
  PD_DISABLEPRINTTOFILE* = 524288
  PD_ENABLEPRINTHOOK* = 4096
  PD_ENABLEPRINTTEMPLATE* = 16384
  PD_ENABLEPRINTTEMPLATEHANDLE* = 65536
  PD_ENABLESETUPHOOK* = 8192
  PD_ENABLESETUPTEMPLATE* = 32768
  PD_ENABLESETUPTEMPLATEHANDLE* = 131072
  PD_HIDEPRINTTOFILE* = 1048576
  PD_NOPAGENUMS* = 8
  PD_NOSELECTION* = 4
  PD_NOWARNING* = 128
  PD_PAGENUMS* = 2
  PD_PRINTSETUP* = 64
  PD_PRINTTOFILE* = 32
  PD_RETURNDC* = 256
  PD_RETURNDEFAULT* = 1024
  PD_RETURNIC* = 512
  PD_SELECTION* = 1
  PD_SHOWHELP* = 2048
  PD_USEDEVMODECOPIES* = 262144
  PD_USEDEVMODECOPIESANDCOLLATE* = 262144
  # PAGESETUPDLG structure
  PSD_DEFAULTMINMARGINS* = 0
  PSD_DISABLEMARGINS* = 16
  PSD_DISABLEORIENTATION* = 256
  PSD_DISABLEPAGEPAINTING* = 524288
  PSD_DISABLEPAPER* = 512
  PSD_DISABLEPRINTER* = 32
  PSD_ENABLEPAGEPAINTHOOK* = 262144
  PSD_ENABLEPAGESETUPHOOK* = 8192
  PSD_ENABLEPAGESETUPTEMPLATE* = 32768
  PSD_ENABLEPAGESETUPTEMPLATEHANDLE* = 131072
  PSD_INHUNDREDTHSOFMILLIMETERS* = 8
  PSD_INTHOUSANDTHSOFINCHES* = 4
  PSD_INWININIINTLMEASURE* = 0
  PSD_MARGINS* = 2
  PSD_MINMARGINS* = 1
  PSD_NOWARNING* = 128
  PSD_RETURNDEFAULT* = 1024
  PSD_SHOWHELP* = 2048
  # WM_SHOWWINDOW message
  SW_OTHERUNZOOM* = 4
  SW_OTHERZOOM* = 2
  SW_PARENTCLOSING* = 1
  SW_PARENTOPENING* = 3
  # Virtual Key codes
  VK_LBUTTON* = 1
  VK_RBUTTON* = 2
  VK_CANCEL* = 3
  VK_MBUTTON* = 4
  VK_BACK* = 8
  VK_TAB* = 9
  VK_CLEAR* = 12
  VK_RETURN* = 13
  VK_SHIFT* = 16
  VK_CONTROL* = 17
  VK_MENU* = 18
  VK_PAUSE* = 19
  VK_CAPITAL* = 20
  VK_ESCAPE* = 27
  VK_SPACE* = 32
  VK_PRIOR* = 33
  VK_NEXT* = 34
  VK_END* = 35
  VK_HOME* = 36
  VK_LEFT* = 37
  VK_UP* = 38
  VK_RIGHT* = 39
  VK_DOWN* = 40
  VK_SELECT* = 41
  VK_PRINT* = 42
  VK_EXECUTE* = 43
  VK_SNAPSHOT* = 44
  VK_INSERT* = 45
  VK_DELETE* = 46
  VK_HELP* = 47
  VK_0* = 48
  VK_1* = 49
  VK_2* = 50
  VK_3* = 51
  VK_4* = 52
  VK_5* = 53
  VK_6* = 54
  VK_7* = 55
  VK_8* = 56
  VK_9* = 57
  VK_A* = 65
  VK_B* = 66
  VK_C* = 67
  VK_D* = 68
  VK_E* = 69
  VK_F* = 70
  VK_G* = 71
  VK_H* = 72
  VK_I* = 73
  VK_J* = 74
  VK_K* = 75
  VK_L* = 76
  VK_M* = 77
  VK_N* = 78
  VK_O* = 79
  VK_P* = 80
  VK_Q* = 81
  VK_R* = 82
  VK_S* = 83
  VK_T* = 84
  VK_U* = 85
  VK_V* = 86
  VK_W* = 87
  VK_X* = 88
  VK_Y* = 89
  VK_Z* = 90
  VK_LWIN* = 91
  VK_RWIN* = 92
  VK_APPS* = 93
  VK_NUMPAD0* = 96
  VK_NUMPAD1* = 97
  VK_NUMPAD2* = 98
  VK_NUMPAD3* = 99
  VK_NUMPAD4* = 100
  VK_NUMPAD5* = 101
  VK_NUMPAD6* = 102
  VK_NUMPAD7* = 103
  VK_NUMPAD8* = 104
  VK_NUMPAD9* = 105
  VK_MULTIPLY* = 106
  VK_ADD* = 107
  VK_SEPARATOR* = 108
  VK_SUBTRACT* = 109
  VK_DECIMAL* = 110
  VK_DIVIDE* = 111
  VK_F1* = 112
  VK_F2* = 113
  VK_F3* = 114
  VK_F4* = 115
  VK_F5* = 116
  VK_F6* = 117
  VK_F7* = 118
  VK_F8* = 119
  VK_F9* = 120
  VK_F10* = 121
  VK_F11* = 122
  VK_F12* = 123
  VK_F13* = 124
  VK_F14* = 125
  VK_F15* = 126
  VK_F16* = 127
  VK_F17* = 128
  VK_F18* = 129
  VK_F19* = 130
  VK_F20* = 131
  VK_F21* = 132
  VK_F22* = 133
  VK_F23* = 134
  VK_F24* = 135
  # GetAsyncKeyState
  VK_NUMLOCK* = 144
  VK_SCROLL* = 145
  VK_LSHIFT* = 160
  VK_LCONTROL* = 162
  VK_LMENU* = 164
  VK_RSHIFT* = 161
  VK_RCONTROL* = 163
  VK_RMENU* = 165
  # ImmGetVirtualKey
  VK_PROCESSKEY* = 229
  # Keystroke Message Flags
  KF_ALTDOWN* = 8192
  KF_DLGMODE* = 2048
  KF_EXTENDED* = 256
  KF_MENUMODE* = 4096
  KF_REPEAT* = 16384
  KF_UP* = 32768
  # GetKeyboardLayoutName
  KL_NAMELENGTH* = 9
  # WM_ACTIVATE message
  WA_ACTIVE* = 1
  WA_CLICKACTIVE* = 2
  WA_INACTIVE* = 0
  # WM_ACTIVATE message
  PWR_CRITICALRESUME* = 3
  PWR_SUSPENDREQUEST* = 1
  PWR_SUSPENDRESUME* = 2
  PWR_FAIL* = -1
  PWR_OK* = 1
  # WM_NOTIFYFORMAT message
  NF_QUERY* = 3
  NF_REQUERY* = 4
  NFR_ANSI* = 1
  NFR_UNICODE* = 2
  # WM_SIZING message
  WMSZ_BOTTOM* = 6
  WMSZ_BOTTOMLEFT* = 7
  WMSZ_BOTTOMRIGHT* = 8
  WMSZ_LEFT* = 1
  WMSZ_RIGHT* = 2
  WMSZ_TOP* = 3
  WMSZ_TOPLEFT* = 4
  WMSZ_TOPRIGHT* = 5
  # WM_MOUSEACTIVATE message
  MA_ACTIVATE* = 1
  MA_ACTIVATEANDEAT* = 2
  MA_NOACTIVATE* = 3
  MA_NOACTIVATEANDEAT* = 4
  # WM_SIZE message
  SIZE_MAXHIDE* = 4
  SIZE_MAXIMIZED* = 2
  SIZE_MAXSHOW* = 3
  SIZE_MINIMIZED* = 1
  SIZE_RESTORED* = 0
  # WM_NCCALCSIZE message
  WVR_ALIGNTOP* = 16
  WVR_ALIGNLEFT* = 32
  WVR_ALIGNBOTTOM* = 64
  WVR_ALIGNRIGHT* = 128
  WVR_HREDRAW* = 256
  WVR_VREDRAW* = 512
  WVR_REDRAW* = 768
  WVR_VALIDRECTS* = 1024
  # WM_NCHITTEST message
  HTBOTTOM* = 15
  HTBOTTOMLEFT* = 16
  HTBOTTOMRIGHT* = 17
  HTCAPTION* = 2
  HTCLIENT* = 1
  HTERROR* = -2
  HTGROWBOX* = 4
  HTHSCROLL* = 6
  HTLEFT* = 10
  HTMENU* = 5
  HTNOWHERE* = 0
  HTREDUCE* = 8

  HTRIGHT* = 11
  HTSIZE* = 4
  HTSYSMENU* = 3
  HTTOP* = 12
  HTTOPLEFT* = 13
  HTTOPRIGHT* = 14
  HTTRANSPARENT* = -1
  HTVSCROLL* = 7
  HTZOOM* = 9
  # Mouse messages
  MK_CONTROL* = 8
  MK_LBUTTON* = 1
  MK_MBUTTON* = 16
  MK_RBUTTON* = 2
  MK_SHIFT* = 4
  # WNDCLASS structure
  CS_BYTEALIGNCLIENT* = 4096
  CS_BYTEALIGNWINDOW* = 8192
  CS_CLASSDC* = 64
  CS_DBLCLKS* = 8
  CS_GLOBALCLASS* = 16384
  CS_HREDRAW* = 2
  CS_KEYCVTWINDOW* = 4
  CS_NOCLOSE* = 512
  CS_NOKEYCVT* = 256
  CS_OWNDC* = 32
  CS_PARENTDC* = 128
  CS_SAVEBITS* = 2048
  CS_VREDRAW* = 1
  DLGWINDOWEXTRA* = 30
  # ACCEL structure
  FALT* = 16
  FCONTROL* = 8
  FNOINVERT* = 2
  FSHIFT* = 4
  FVIRTKEY* = 1
  # WM_MENUCHAR return constants
  MNC_IGNORE* = 0
  MNC_CLOSE* = 1
  MNC_EXECUTE* = 2
  MNC_SELECT* = 3
  # MENUINFO structure
  MIM_MAXHEIGHT* = 1
  MIM_BACKGROUND* = 2
  MIM_HELPID* = 4
  MIM_MENUDATA* = 8
  MIM_STYLE* = 16
  MIM_APPLYTOSUBMENUS* = 0x80000000
  MNS_CHECKORBMP* = 0x04000000
  MNS_NOTIFYBYPOS* = 0x08000000
  MNS_AUTODISMISS* = 0x10000000
  MNS_DRAGDROP* = 0x20000000
  MNS_MODELESS* = 0x40000000
  MNS_NOCHECK* = 0x80000000
  # MENUITEMINFO structure
  MIIM_CHECKMARKS* = 8
  MIIM_DATA* = 32
  MIIM_ID* = 2
  MIIM_STATE* = 1
  MIIM_SUBMENU* = 4
  MIIM_TYPE* = 16
  MIIM_STRING* = 64
  MIIM_BITMAP* = 128
  MIIM_FTYPE* = 256
  MFT_BITMAP* = 0x00000004
  MFT_MENUBARBREAK* = 0x00000020
  MFT_MENUBREAK* = 0x00000040
  MFT_OWNERDRAW* = 0x00000100
  MFT_RADIOCHECK* = 0x00000200
  MFT_RIGHTJUSTIFY* = 0x00004000
  MFT_SEPARATOR* = 0x00000800
  MFT_RIGHTORDER* = 0x00002000
  MFT_STRING* = 0
  MFS_CHECKED* = 0x00000008
  MFS_DEFAULT* = 0x00001000
  MFS_DISABLED* = 0x00000003
  MFS_ENABLED* = 0
  MFS_GRAYED* = 0x00000003
  MFS_HILITE* = 0x00000080
  MFS_UNCHECKED* = 0
  MFS_UNHILITE* = 0
  HBMMENU_CALLBACK* = - 1
  HBMMENU_SYSTEM* = 1
  HBMMENU_MBAR_RESTORE* = 2
  HBMMENU_MBAR_MINIMIZE* = 3
  HBMMENU_MBAR_CLOSE* = 5
  HBMMENU_MBAR_CLOSE_D* = 6
  HBMMENU_MBAR_MINIMIZE_D* = 7
  HBMMENU_POPUP_CLOSE* = 8
  HBMMENU_POPUP_RESTORE* = 9
  HBMMENU_POPUP_MAXIMIZE* = 10
  HBMMENU_POPUP_MINIMIZE* = 11
  # SERIALKEYS structure
  SERKF_AVAILABLE* = 2
  SERKF_INDICATOR* = 4
  SERKF_SERIALKEYSON* = 1
  # FILTERKEYS structure
  FKF_AVAILABLE* = 2
  FKF_CLICKON* = 64
  FKF_FILTERKEYSON* = 1
  FKF_HOTKEYACTIVE* = 4
  FKF_HOTKEYSOUND* = 16
  FKF_CONFIRMHOTKEY* = 8
  FKF_INDICATOR* = 32
  # HELPINFO structure
  HELPINFO_MENUITEM* = 2
  HELPINFO_WINDOW* = 1
  # WM_PRINT message
  PRF_CHECKVISIBLE* = 0x00000001
  PRF_CHILDREN* = 0x00000010
  PRF_CLIENT* = 0x00000004
  PRF_ERASEBKGND* = 0x00000008
  PRF_NONCLIENT* = 0x00000002
  PRF_OWNED* = 0x00000020

  # MapWindowPoints
  HWND_DESKTOP* = HWND(0)

const
  # WM_SYSCOMMAND message
  SC_CLOSE* = 61536
  SC_CONTEXTHELP* = 61824
  SC_DEFAULT* = 61792
  SC_HOTKEY* = 61776
  SC_HSCROLL* = 61568
  SC_KEYMENU* = 61696
  SC_MAXIMIZE* = 61488
  SC_ZOOM* = 61488
  SC_MINIMIZE* = 61472
  SC_ICON* = 61472
  SC_MONITORPOWER* = 61808
  SC_MOUSEMENU* = 61584
  SC_MOVE* = 61456
  SC_NEXTWINDOW* = 61504
  SC_PREVWINDOW* = 61520
  SC_RESTORE* = 61728
  SC_SCREENSAVE* = 61760
  SC_SIZE* = 61440
  SC_TASKLIST* = 61744
  SC_VSCROLL* = 61552
  # DM_GETDEFID message
  DC_HASDEFID* = 21323
  # WM_GETDLGCODE message
  DLGC_BUTTON* = 8192
  DLGC_DEFPUSHBUTTON* = 16
  DLGC_HASSETSEL* = 8
  DLGC_RADIOBUTTON* = 64
  DLGC_STATIC* = 256
  DLGC_UNDEFPUSHBUTTON* = 32
  DLGC_WANTALLKEYS* = 4
  DLGC_WANTARROWS* = 1
  DLGC_WANTCHARS* = 128
  DLGC_WANTMESSAGE* = 4
  DLGC_WANTTAB* = 2
  # EM_SETMARGINS message
  EC_LEFTMARGIN* = 1
  EC_RIGHTMARGIN* = 2
  EC_USEFONTINFO* = 65535
  # LB_SETCOUNT message
  LB_ERR* = -1
  LB_ERRSPACE* = -2
  LB_OKAY* = 0
  # CB_DIR message
  CB_ERR* = -1
  CB_ERRSPACE* = -2
  # WM_IME_CONTROL message
  IMC_GETCANDIDATEPOS* = 7
  IMC_GETCOMPOSITIONFONT* = 9
  IMC_GETCOMPOSITIONWINDOW* = 11
  IMC_GETSTATUSWINDOWPOS* = 15
  IMC_CLOSESTATUSWINDOW* = 33
  IMC_OPENSTATUSWINDOW* = 34
  IMC_SETCANDIDATEPOS* = 8
  IMC_SETCOMPOSITIONFONT* = 10
  IMC_SETCOMPOSITIONWINDOW* = 12
  IMC_SETSTATUSWINDOWPOS* = 16
  # WM_IME_CONTROL message
  IMN_CHANGECANDIDATE* = 3
  IMN_CLOSECANDIDATE* = 4
  IMN_CLOSESTATUSWINDOW* = 1
  IMN_GUIDELINE* = 13
  IMN_OPENCANDIDATE* = 5
  IMN_OPENSTATUSWINDOW* = 2
  IMN_SETCANDIDATEPOS* = 9
  IMN_SETCOMPOSITIONFONT* = 10
  IMN_SETCOMPOSITIONWINDOW* = 11
  IMN_SETCONVERSIONMODE* = 6
  IMN_SETOPENSTATUS* = 8
  IMN_SETSENTENCEMODE* = 7
  IMN_SETSTATUSWINDOWPOS* = 12
  IMN_PRIVATE* = 14
  # STICKYKEYS structure
  SKF_AUDIBLEFEEDBACK* = 64
  SKF_AVAILABLE* = 2
  SKF_CONFIRMHOTKEY* = 8
  SKF_HOTKEYACTIVE* = 4
  SKF_HOTKEYSOUND* = 16
  SKF_INDICATOR* = 32
  SKF_STICKYKEYSON* = 1
  SKF_TRISTATE* = 128
  SKF_TWOKEYSOFF* = 256
  # MOUSEKEYS structure
  MKF_AVAILABLE* = 2
  MKF_CONFIRMHOTKEY* = 8
  MKF_HOTKEYACTIVE* = 4
  MKF_HOTKEYSOUND* = 16
  MKF_INDICATOR* = 32
  MKF_MOUSEKEYSON* = 1
  MKF_MODIFIERS* = 64
  MKF_REPLACENUMBERS* = 128
  # SOUNDSENTRY structure
  SSF_AVAILABLE* = 2
  SSF_SOUNDSENTRYON* = 1
  SSTF_BORDER* = 2
  SSTF_CHARS* = 1
  SSTF_DISPLAY* = 3
  SSTF_NONE* = 0
  SSGF_DISPLAY* = 3
  SSGF_NONE* = 0
  SSWF_CUSTOM* = 4
  SSWF_DISPLAY* = 3
  SSWF_NONE* = 0
  SSWF_TITLE* = 1
  SSWF_WINDOW* = 2
  # ACCESSTIMEOUT structure
  ATF_ONOFFFEEDBACK* = 2
  ATF_TIMEOUTON* = 1
  # HIGHCONTRAST structure
  HCF_AVAILABLE* = 2
  HCF_CONFIRMHOTKEY* = 8
  HCF_HIGHCONTRASTON* = 1
  HCF_HOTKEYACTIVE* = 4
  HCF_HOTKEYAVAILABLE* = 64
  HCF_HOTKEYSOUND* = 16
  HCF_INDICATOR* = 32
  # TOGGLEKEYS structure
  TKF_AVAILABLE* = 2
  TKF_CONFIRMHOTKEY* = 8
  TKF_HOTKEYACTIVE* = 4
  TKF_HOTKEYSOUND* = 16
  TKF_TOGGLEKEYSON* = 1
  # Installable Policy
  PP_DISPLAYERRORS* = 1
  # SERVICE_INFO structure
  RESOURCEDISPLAYTYPE_DOMAIN* = 1
  RESOURCEDISPLAYTYPE_FILE* = 4
  RESOURCEDISPLAYTYPE_GENERIC* = 0
  RESOURCEDISPLAYTYPE_GROUP* = 5
  RESOURCEDISPLAYTYPE_SERVER* = 2
  RESOURCEDISPLAYTYPE_SHARE* = 3
  # KEY_EVENT_RECORD structure
  CAPSLOCK_ON* = 128
  ENHANCED_KEY* = 256
  LEFT_ALT_PRESSED* = 2
  LEFT_CTRL_PRESSED* = 8
  NUMLOCK_ON* = 32
  RIGHT_ALT_PRESSED* = 1
  RIGHT_CTRL_PRESSED* = 4
  SCROLLLOCK_ON* = 64
  SHIFT_PRESSED* = 16
  # MOUSE_EVENT_RECORD structure
  FROM_LEFT_1ST_BUTTON_PRESSED* = 1
  RIGHTMOST_BUTTON_PRESSED* = 2
  FROM_LEFT_2ND_BUTTON_PRESSED* = 4
  FROM_LEFT_3RD_BUTTON_PRESSED* = 8
  FROM_LEFT_4TH_BUTTON_PRESSED* = 16
  DOUBLE_CLICK* = 2
  MOUSE_MOVED* = 1
  # INPUT_RECORD structure
  KEY_EVENT* = 1
  cMOUSE_EVENT* = 2
  WINDOW_BUFFER_SIZE_EVENT* = 4
  MENU_EVENT* = 8
  FOCUS_EVENT* = 16
  # BITMAPINFOHEADER structure
  BI_RGB* = 0
  BI_RLE8* = 1
  BI_RLE4* = 2
  BI_BITFIELDS* = 3
  # Extensions to OpenGL
  # ChoosePixelFormat
  PFD_DOUBLEBUFFER* = 0x00000001
  PFD_STEREO* = 0x00000002
  PFD_DRAW_TO_WINDOW* = 0x00000004
  PFD_DRAW_TO_BITMAP* = 0x00000008
  PFD_SUPPORT_GDI* = 0x00000010
  PFD_SUPPORT_OPENGL* = 0x00000020
  PFD_DEPTH_DONTCARE* = 0x20000000
  PFD_DOUBLEBUFFER_DONTCARE* = 0x40000000
  PFD_STEREO_DONTCARE* = 0x80000000
  PFD_TYPE_RGBA* = 0
  PFD_TYPE_COLORINDEX* = 1
  PFD_MAIN_PLANE* = 0
  PFD_OVERLAY_PLANE* = 1
  PFD_UNDERLAY_PLANE* = -1
  # wglUseFontOutlines
  WGL_FONT_LINES* = 0
  WGL_FONT_POLYGONS* = 1
  PFD_GENERIC_FORMAT* = 0x00000040
  PFD_NEED_PALETTE* = 0x00000080
  PFD_NEED_SYSTEM_PALETTE* = 0x00000100
  PFD_SWAP_EXCHANGE* = 0x00000200
  PFD_SWAP_COPY* = 0x00000400
  PFD_SWAP_LAYER_BUFFERS* = 0x00000800
  PFD_GENERIC_ACCELERATED* = 0x00001000
  PFD_SUPPORT_DIRECTDRAW* = 0x00002000
  TMPF_FIXED_PITCH* = 0x00000001
  TMPF_VECTOR* = 0x00000002
  TMPF_TRUETYPE* = 0x00000004
  TMPF_DEVICE* = 0x00000008
  WM_CTLCOLOR* = 25
  LWA_COLORKEY* = 0x00000001
  LWA_ALPHA* = 0x00000002
  ULW_COLORKEY* = 0x00000001
  ULW_ALPHA* = 0x00000002
  ULW_OPAQUE* = 0x00000004
  WS_EX_LAYERED* = 0x00080000
  WS_EX_NOINHERITLAYOUT* = 0x00100000
  WS_EX_LAYOUTRTL* = 0x00400000
  WS_EX_COMPOSITED* = 0x02000000
  WS_EX_NOACTIVATE* = 0x08000000
  C3_LEXICAL* = 1024

# --------------------- old stuff, need to organize! ---------------
# BEGINNING of windowsx.h stuff from old headers:

# was #define dname(params) def_expr
proc GetFirstChild*(h: HWND): HWND
  # was #define dname(params) def_expr
proc GetNextSibling*(h: HWND): HWND
  # was #define dname(params) def_expr
proc GetWindowID*(h: HWND): int32
  # was #define dname(params) def_expr
proc SubclassWindow*(h: HWND, p: LONG): LONG
  # was #define dname(params) def_expr
  # argument types are unknown
  # return type might be wrong
proc GET_WM_COMMAND_CMD*(w, L: int32): int32
  # return type might be wrong
  # was #define dname(params) def_expr
  # argument types are unknown
  # return type might be wrong
proc GET_WM_COMMAND_ID*(w, L: int32): int32
  # return type might be wrong
  # was #define dname(params) def_expr
  # argument types are unknown
proc GET_WM_CTLCOLOR_HDC*(w, L, msg: int32): HDC
  # was #define dname(params) def_expr
  # argument types are unknown
proc GET_WM_CTLCOLOR_HWND*(w, L, msg: int32): HWND
  # was #define dname(params) def_expr
  # argument types are unknown
  # return type might be wrong
proc GET_WM_HSCROLL_CODE*(w, L: int32): int32
  # return type might be wrong
  # was #define dname(params) def_expr
  # argument types are unknown
proc GET_WM_HSCROLL_HWND*(w, L: int32): HWND
  # was #define dname(params) def_expr
  # argument types are unknown
  # return type might be wrong
proc GET_WM_HSCROLL_POS*(w, L: int32): int32
  # return type might be wrong
  # was #define dname(params) def_expr
  # argument types are unknown
  # return type might be wrong
proc GET_WM_MDIACTIVATE_FACTIVATE*(h, a, b: int32): int32
  # return type might be wrong
  # was #define dname(params) def_expr
  # argument types are unknown
proc GET_WM_MDIACTIVATE_HWNDACTIVATE*(a, b: int32): HWND
  # was #define dname(params) def_expr
  # argument types are unknown
proc GET_WM_MDIACTIVATE_HWNDDEACT*(a, b: int32): HWND
  # was #define dname(params) def_expr
  # argument types are unknown
  # return type might be wrong
proc GET_WM_VSCROLL_CODE*(w, L: int32): int32
  # return type might be wrong
  # was #define dname(params) def_expr
  # argument types are unknown
proc GET_WM_VSCROLL_HWND*(w, L: int32): HWND
  # was #define dname(params) def_expr
  # argument types are unknown
  # return type might be wrong
proc GET_WM_VSCROLL_POS*(w, L: int32): int32
  # return type might be wrong
  #  Not convertable by H2PAS
  # END OF windowsx.h stuff from old headers
  # ------------------------------------------------------------------

const
  # BEGINNING of shellapi.h stuff from old headers
  SE_ERR_SHARE* = 26
  SE_ERR_ASSOCINCOMPLETE* = 27
  SE_ERR_DDETIMEOUT* = 28
  SE_ERR_DDEFAIL* = 29
  SE_ERR_DDEBUSY* = 30
  SE_ERR_NOASSOC* = 31
  # END OF shellapi.h stuff from old headers
  #
  # ------------------------------------------------------------------
  # From ddeml.h in old Cygnus headers
  XCLASS_BOOL* = 0x00001000
  XCLASS_DATA* = 0x00002000
  XCLASS_FLAGS* = 0x00004000
  XCLASS_MASK* = 0x0000FC00
  XCLASS_NOTIFICATION* = 0x00008000
  XTYPF_NOBLOCK* = 0x00000002
  XTYP_ADVDATA* = 0x00004010
  XTYP_ADVREQ* = 0x00002022
  XTYP_ADVSTART* = 0x00001030
  XTYP_ADVSTOP* = 0x00008040
  XTYP_CONNECT* = 0x00001062
  XTYP_CONNECT_CONFIRM* = 0x00008072
  XTYP_DISCONNECT* = 0x000080C2
  XTYP_EXECUTE* = 0x00004050
  XTYP_POKE* = 0x00004090
  XTYP_REQUEST* = 0x000020B0
  XTYP_WILDCONNECT* = 0x000020E2
  XTYP_REGISTER* = 0x000080A2
  XTYP_ERROR* = 0x00008002
  XTYP_XACT_COMPLETE* = 0x00008080
  XTYP_UNREGISTER* = 0x000080D2
  DMLERR_DLL_USAGE* = 0x00004004
  DMLERR_INVALIDPARAMETER* = 0x00004006
  DMLERR_NOTPROCESSED* = 0x00004009
  DMLERR_POSTMSG_FAILED* = 0x0000400C
  DMLERR_SERVER_DIED* = 0x0000400E
  DMLERR_SYS_ERROR* = 0x0000400F
  DMLERR_BUSY* = 0x00004001
  DMLERR_DATAACKTIMEOUT* = 0x00004002
  DMLERR_ADVACKTIMEOUT* = 0x00004000
  DMLERR_DLL_NOT_INITIALIZED* = 0x00004003
  DMLERR_LOW_MEMORY* = 0x00004007
  DMLERR_MEMORY_ERROR* = 0x00004008
  DMLERR_POKEACKTIMEOUT* = 0x0000400B
  DMLERR_NO_CONV_ESTABLISHED* = 0x0000400A
  DMLERR_REENTRANCY* = 0x0000400D
  DMLERR_UNFOUND_QUEUE_ID* = 0x00004011
  DMLERR_UNADVACKTIMEOUT* = 0x00004010
  DMLERR_EXECACKTIMEOUT* = 0x00004005
  DDE_FACK* = 0x00008000
  DDE_FNOTPROCESSED* = 0x00000000
  DNS_REGISTER* = 0x00000001
  DNS_UNREGISTER* = 0x00000002
  CP_WINANSI* = 1004
  CP_WINUNICODE* = 1200
  #  Not convertable by H2PAS
  #  #define EXPENTRY CALLBACK
  APPCLASS_STANDARD* = 0x00000000
  # End of stuff from ddeml.h in old Cygnus headers

  BKMODE_LAST* = 2
  CTLCOLOR_MSGBOX* = 0
  CTLCOLOR_EDIT* = 1
  CTLCOLOR_LISTBOX* = 2
  CTLCOLOR_BTN* = 3
  CTLCOLOR_DLG* = 4
  CTLCOLOR_SCROLLBAR* = 5
  CTLCOLOR_STATIC* = 6
  CTLCOLOR_MAX* = 7
  META_SETMAPMODE* = 0x00000103
  META_SETWINDOWORG* = 0x0000020B
  META_SETWINDOWEXT* = 0x0000020C
  POLYFILL_LAST* = 2
  STATUS_WAIT_0* = 0x00000000
  STATUS_ABANDONED_WAIT_0* = 0x00000080
  STATUS_USER_APC* = 0x000000C0
  STATUS_TIMEOUT* = 0x00000102
  STATUS_PENDING* = 0x00000103
  STATUS_GUARD_PAGE_VIOLATION* = 0x80000001
  STATUS_DATATYPE_MISALIGNMENT* = 0x80000002
  STATUS_BREAKPOINT* = 0x80000003
  STATUS_SINGLE_STEP* = 0x80000004
  STATUS_IN_PAGE_ERROR* = 0xC0000006
  STATUS_INVALID_HANDLE* = 0xC0000008
  STATUS_ILLEGAL_INSTRUCTION* = 0xC000001D
  STATUS_NONCONTINUABLE_EXCEPTION* = 0xC0000025
  STATUS_INVALID_DISPOSITION* = 0xC0000026
  STATUS_ARRAY_BOUNDS_EXCEEDED* = 0xC000008C
  STATUS_FLOAT_DENORMAL_OPERAND* = 0xC000008D
  STATUS_FLOAT_DIVIDE_BY_ZERO* = 0xC000008E
  STATUS_FLOAT_INEXACT_RESULT* = 0xC000008F
  STATUS_FLOAT_INVALID_OPERATION* = 0xC0000090
  STATUS_FLOAT_OVERFLOW* = 0xC0000091
  STATUS_FLOAT_STACK_CHECK* = 0xC0000092
  STATUS_FLOAT_UNDERFLOW* = 0xC0000093
  STATUS_INTEGER_DIVIDE_BY_ZERO* = 0xC0000094
  STATUS_INTEGER_OVERFLOW* = 0xC0000095
  STATUS_PRIVILEGED_INSTRUCTION* = 0xC0000096
  STATUS_STACK_OVERFLOW* = 0xC00000FD
  STATUS_CONTROL_C_EXIT* = 0xC000013A
  PROCESSOR_ARCHITECTURE_INTEL* = 0
  PROCESSOR_ARCHITECTURE_MIPS* = 1
  PROCESSOR_ARCHITECTURE_ALPHA* = 2
  PROCESSOR_ARCHITECTURE_PPC* = 3

const
  SIZEFULLSCREEN* = SIZE_MAXIMIZED
  SIZENORMAL* = SIZE_RESTORED
  SIZEICONIC* = SIZE_MINIMIZED

const
  EXCEPTION_READ_FAULT* = 0   # Access violation was caused by a read
  EXCEPTION_WRITE_FAULT* = 1  # Access violation was caused by a write

when defined(cpuia64):
  const
    EXCEPTION_EXECUTE_FAULT* = 2 # Access violation was caused by an instruction fetch
else:
  const
    EXCEPTION_EXECUTE_FAULT* = 8
when defined(cpupowerpc32):
  # ppc
  const
    CONTEXT_CONTROL* = 1
    CONTEXT_FLOATING_POINT* = 2
    CONTEXT_INTEGER* = 4
    CONTEXT_DEBUG_REGISTERS* = 8
    CONTEXT_FULL* = CONTEXT_CONTROL or CONTEXT_FLOATING_POINT or CONTEXT_INTEGER
    CONTEXT_DEBUGGER* = CONTEXT_FULL
when defined(cpui386):
  # x86
  # The doc refered me to winnt.h, so I had to look...
  const
    SIZE_OF_80387_REGISTERS* = 80 # Values for contextflags
    CONTEXT_i386* = 0x00010000 # this assumes that i386 and
    CONTEXT_i486* = 0x00010000 # i486 have identical context records
    CONTEXT_CONTROL* = CONTEXT_i386 or 1 # SS:SP, CS:IP, FLAGS, BP
    CONTEXT_INTEGER* = CONTEXT_i386 or 2 # AX, BX, CX, DX, SI, DI
    CONTEXT_SEGMENTS* = CONTEXT_i386 or 4 # DS, ES, FS, GS
    CONTEXT_FLOATING_POINT* = CONTEXT_i386 or 8 # 387 state
    CONTEXT_DEBUG_REGISTERS* = CONTEXT_i386 or 0x00000010 # DB 0-3,6,7
    CONTEXT_EXTENDED_REGISTERS* = CONTEXT_i386 or 0x00000020 # cpu specific extensions
    CONTEXT_FULL* = (CONTEXT_CONTROL or CONTEXT_INTEGER) or CONTEXT_SEGMENTS
    CONTEXT_ALL* = CONTEXT_FULL or CONTEXT_FLOATING_POINT or
        CONTEXT_DEBUG_REGISTERS or CONTEXT_EXTENDED_REGISTERS # our own invention
    FLAG_TRACE_BIT* = 0x00000100
    CONTEXT_DEBUGGER* = CONTEXT_FULL or CONTEXT_FLOATING_POINT
when defined(cpux86_64):
  const
    INITIAL_MXCSR* = 0x00001F80 # initial MXCSR value
    INITIAL_FPCSR* = 0x0000027F # initial FPCSR value
    CONTEXT_AMD64* = 0x00100000
    CONTEXT_CONTROL* = (CONTEXT_AMD64 or 0x00000001)
    CONTEXT_INTEGER* = (CONTEXT_AMD64 or 0x00000002)
    CONTEXT_SEGMENTS* = (CONTEXT_AMD64 or 0x00000004)
    CONTEXT_FLOATING_POINT* = (CONTEXT_AMD64 or 0x00000008)
    CONTEXT_DEBUG_REGISTERS* = (CONTEXT_AMD64 or 0x00000010)
    CONTEXT_FULL* = CONTEXT_CONTROL or CONTEXT_INTEGER or CONTEXT_FLOATING_POINT
    CONTEXT_ALL* = CONTEXT_CONTROL or CONTEXT_INTEGER or CONTEXT_SEGMENTS or
        CONTEXT_FLOATING_POINT or CONTEXT_DEBUG_REGISTERS
    CONTEXT_EXCEPTION_ACTIVE* = 0x08000000
    CONTEXT_SERVICE_ACTIVE* = 0x10000000
    CONTEXT_EXCEPTION_REQUEST* = 0x40000000
    CONTEXT_EXCEPTION_REPORTING* = 0x80000000

const
  FILTER_TEMP_DUPLICATE_ACCOUNT* = 0x00000001
  FILTER_NORMAL_ACCOUNT* = 0x00000002
  FILTER_INTERDOMAIN_TRUST_ACCOUNT* = 0x00000008
  FILTER_WORKSTATION_TRUST_ACCOUNT* = 0x00000010
  FILTER_SERVER_TRUST_ACCOUNT* = 0x00000020
  LOGON32_LOGON_INTERACTIVE* = 0x00000002
  LOGON32_LOGON_BATCH* = 0x00000004
  LOGON32_LOGON_SERVICE* = 0x00000005
  LOGON32_PROVIDER_DEFAULT* = 0x00000000
  LOGON32_PROVIDER_WINNT35* = 0x00000001
  QID_SYNC* = 0xFFFFFFFF
  # Magic numbers in PE executable header. # e_magic field
  IMAGE_DOS_SIGNATURE* = 0x00005A4D
  # nt_signature field
  IMAGE_NT_SIGNATURE* = 0x00004550
  # Severity values
  SEVERITY_SUCCESS* = 0
  SEVERITY_ERROR* = 1
  # Variant type codes (wtypes.h).
  #    Some, not all though
  VT_EMPTY* = 0
  VT_NULL* = 1
  VT_I2* = 2
  VT_I4* = 3
  VT_R4* = 4
  VT_R8* = 5
  VT_BSTR* = 8
  VT_ERROR* = 10
  VT_BOOL* = 11
  VT_UI1* = 17
  VT_BYREF* = 0x00004000
  VT_RESERVED* = 0x00008000

const
  # Define the facility codes
  FACILITY_WINDOWS* = 8
  FACILITY_STORAGE* = 3
  FACILITY_RPC* = 1
  FACILITY_SSPI* = 9
  FACILITY_WIN32* = 7
  FACILITY_CONTROL* = 10
  FACILITY_NULL* = 0
  FACILITY_INTERNET* = 12
  FACILITY_ITF* = 4
  FACILITY_DISPATCH* = 2
  FACILITY_CERT* = 11         # Manually added, bug 2672
  ICON_SMALL* = 0
  ICON_BIG* = 1
  # For the TrackMouseEvent
  TME_HOVER* = 0x00000001
  TME_LEAVE* = 0x00000002
  TME_QUERY* = 0x40000000
  TME_CANCEL* = DWORD(0x80000000)
  HOVER_DEFAULT* = DWORD(0xFFFFFFFF) # Manually added, bug 3270
  COLOR_HOTLIGHT* = 26
  COLOR_GRADIENTACTIVECAPTION* = 27
  COLOR_GRADIENTINACTIVECAPTION* = 28
  COLOR_MENUHILIGHT* = 29
  COLOR_MENUBAR* = 30
  WM_APP* = 0x00008000
  SYSRGN* = 4
  UIS_SET* = 1
  UIS_CLEAR* = 2
  UIS_INITIALIZE* = 3
  UISF_HIDEFOCUS* = 0x00000001
  UISF_HIDEACCEL* = 0x00000002
  UISF_ACTIVE* = 0x00000004

type
  # WARNING
  #      the variable argument list
  #      is not implemented for FPC
  #      va_list is just a dummy record
  #      MvdV: Nevertheless it should be a pointer type, not a record
  va_list* = cstring
  TABC* {.final, pure.} = object
    abcA*: int32
    abcB*: UINT
    abcC*: int32

  LPABC* = ptr TABC
  PABC* = ptr TABC
  TABCFLOAT* {.final, pure.} = object
    abcfA*: float32
    abcfB*: float32
    abcfC*: float32
  LPABCFLOAT* = ptr TABCFLOAT
  PABCFLOAT* = ptr TABCFLOAT

  TACCEL* {.final, pure.} = object
    fVirt*: int8
    key*: int16
    cmd*: int16
  LPACCEL* = ptr TACCEL
  PACCEL* = ptr TACCEL
  ACE_HEADER* {.final, pure.} = object
    AceType*: int8
    AceFlags*: int8
    AceSize*: int16

  TACE_HEADER* = ACE_HEADER
  PACE_HEADER* = ptr ACE_HEADER
  ACCESS_MASK* = DWORD
  REGSAM* = ACCESS_MASK
  ACCESS_ALLOWED_ACE* {.final, pure.} = object
    Header*: ACE_HEADER
    Mask*: ACCESS_MASK
    SidStart*: DWORD

  TACCESS_ALLOWED_ACE* = ACCESS_ALLOWED_ACE
  PACCESS_ALLOWED_ACE* = ptr ACCESS_ALLOWED_ACE
  ACCESS_DENIED_ACE* {.final, pure.} = object
    Header*: ACE_HEADER
    Mask*: ACCESS_MASK
    SidStart*: DWORD

  TACCESS_DENIED_ACE* = ACCESS_DENIED_ACE
  ACCESSTIMEOUT* {.final, pure.} = object
    cbSize*: UINT
    dwFlags*: DWORD
    iTimeOutMSec*: DWORD

  TACCESSTIMEOUT* = ACCESSTIMEOUT
  PACCESSTIMEOUT* = ptr ACCESSTIMEOUT
  ACL* {.final, pure.} = object
    AclRevision*: int8
    Sbz1*: int8
    AclSize*: int16
    AceCount*: int16
    Sbz2*: int16

  PACL* = ptr ACL
  TACL* = ACL
  TACL_REVISION_INFORMATION* {.final, pure.} = object
    AclRevision*: DWORD
  PACLREVISIONINFORMATION* = ptr TACL_REVISION_INFORMATION

  TACL_SIZE_INFORMATION* {.final, pure.} = object
    AceCount*: DWORD
    AclBytesInUse*: DWORD
    AclBytesFree*: DWORD
  PACLSIZEINFORMATION* = ptr TACL_SIZE_INFORMATION
  ACTION_HEADER* {.final, pure.} = object
    transport_id*: ULONG
    action_code*: USHORT
    reserved*: USHORT

  TACTIONHEADER* = ACTION_HEADER
  PACTIONHEADER* = ptr ACTION_HEADER
  ADAPTER_STATUS* {.final, pure.} = object
    adapter_address*: array[0..5, UCHAR]
    rev_major*: UCHAR
    reserved0*: UCHAR
    adapter_type*: UCHAR
    rev_minor*: UCHAR
    duration*: int16
    frmr_recv*: int16
    frmr_xmit*: int16
    iframe_recv_err*: int16
    xmit_aborts*: int16
    xmit_success*: DWORD
    recv_success*: DWORD
    iframe_xmit_err*: int16
    recv_buff_unavail*: int16
    t1_timeouts*: int16
    ti_timeouts*: int16
    reserved1*: DWORD
    free_ncbs*: int16
    max_cfg_ncbs*: int16
    max_ncbs*: int16
    xmit_buf_unavail*: int16
    max_dgram_size*: int16
    pending_sess*: int16
    max_cfg_sess*: int16
    max_sess*: int16
    max_sess_pkt_size*: int16
    name_count*: int16

  TADAPTERSTATUS* = ADAPTER_STATUS
  PADAPTERSTATUS* = ptr ADAPTER_STATUS
  ADDJOB_INFO_1* {.final, pure.} = object
    Path*: LPTSTR
    JobId*: DWORD

  TADDJOB_INFO_1* = ADDJOB_INFO_1
  PADDJOB_INFO_1* = ptr ADDJOB_INFO_1
  ANIMATIONINFO* {.final, pure.} = object
    cbSize*: UINT
    iMinAnimate*: int32

  LPANIMATIONINFO* = ptr ANIMATIONINFO
  TANIMATIONINFO* = ANIMATIONINFO
  PANIMATIONINFO* = ptr ANIMATIONINFO

  APPBARDATA* {.final, pure.} = object
    cbSize*: DWORD
    hWnd*: HWND
    uCallbackMessage*: UINT
    uEdge*: UINT
    rc*: RECT
    lParam*: LPARAM

  TAppBarData* = APPBARDATA
  PAppBarData* = ptr APPBARDATA
  BITMAP* {.final, pure.} = object
    bmType*: LONG
    bmWidth*: LONG
    bmHeight*: LONG
    bmWidthBytes*: LONG
    bmPlanes*: int16
    bmBitsPixel*: int16
    bmBits*: LPVOID

  PBITMAP* = ptr BITMAP
  NPBITMAP* = ptr BITMAP
  LPBITMAP* = ptr BITMAP
  TBITMAP* = BITMAP
  BITMAPCOREHEADER* {.final, pure.} = object
    bcSize*: DWORD
    bcWidth*: int16
    bcHeight*: int16
    bcPlanes*: int16
    bcBitCount*: int16

  TBITMAPCOREHEADER* = BITMAPCOREHEADER
  PBITMAPCOREHEADER* = ptr BITMAPCOREHEADER
  RGBTRIPLE* {.final, pure.} = object
    rgbtBlue*: int8
    rgbtGreen*: int8
    rgbtRed*: int8

  TRGBTRIPLE* = RGBTRIPLE
  PRGBTRIPLE* = ptr RGBTRIPLE
  BITMAPCOREINFO* {.final, pure.} = object
    bmciHeader*: BITMAPCOREHEADER
    bmciColors*: array[0..0, RGBTRIPLE]

  PBITMAPCOREINFO* = ptr BITMAPCOREINFO
  LPBITMAPCOREINFO* = ptr BITMAPCOREINFO
  TBITMAPCOREINFO* = BITMAPCOREINFO # error
                                    #  WORD    bfReserved1;
                                    #  WORD    bfReserved2;
                                    # in declarator_list
  BITMAPINFOHEADER* {.final, pure.} = object
    biSize*: DWORD
    biWidth*: LONG
    biHeight*: LONG
    biPlanes*: int16
    biBitCount*: int16
    biCompression*: DWORD
    biSizeImage*: DWORD
    biXPelsPerMeter*: LONG
    biYPelsPerMeter*: LONG
    biClrUsed*: DWORD
    biClrImportant*: DWORD

  LPBITMAPINFOHEADER* = ptr BITMAPINFOHEADER
  TBITMAPINFOHEADER* = BITMAPINFOHEADER
  PBITMAPINFOHEADER* = ptr BITMAPINFOHEADER
  RGBQUAD* {.final, pure.} = object
    rgbBlue*: int8
    rgbGreen*: int8
    rgbRed*: int8
    rgbReserved*: int8

  TRGBQUAD* = RGBQUAD
  PRGBQUAD* = ptr RGBQUAD
  BITMAPINFO* {.final, pure.} = object
    bmiHeader*: BITMAPINFOHEADER
    bmiColors*: array[0..0, RGBQUAD]

  LPBITMAPINFO* = ptr BITMAPINFO
  PBITMAPINFO* = ptr BITMAPINFO
  TBITMAPINFO* = BITMAPINFO
  FXPT2DOT30* = int32
  LPFXPT2DOT30* = ptr FXPT2DOT30
  TPFXPT2DOT30* = FXPT2DOT30
  PPFXPT2DOT30* = ptr FXPT2DOT30
  CIEXYZ* {.final, pure.} = object
    ciexyzX*: FXPT2DOT30
    ciexyzY*: FXPT2DOT30
    ciexyzZ*: FXPT2DOT30

  LPCIEXYZ* = ptr CIEXYZ
  TPCIEXYZ* = CIEXYZ
  PCIEXYZ* = ptr CIEXYZ
  CIEXYZTRIPLE* {.final, pure.} = object
    ciexyzRed*: CIEXYZ
    ciexyzGreen*: CIEXYZ
    ciexyzBlue*: CIEXYZ

  LPCIEXYZTRIPLE* = ptr CIEXYZTRIPLE
  TCIEXYZTRIPLE* = CIEXYZTRIPLE
  PCIEXYZTRIPLE* = ptr CIEXYZTRIPLE
  BITMAPV4HEADER* {.final, pure.} = object
    bV4Size*: DWORD
    bV4Width*: LONG
    bV4Height*: LONG
    bV4Planes*: int16
    bV4BitCount*: int16
    bV4V4Compression*: DWORD
    bV4SizeImage*: DWORD
    bV4XPelsPerMeter*: LONG
    bV4YPelsPerMeter*: LONG
    bV4ClrUsed*: DWORD
    bV4ClrImportant*: DWORD
    bV4RedMask*: DWORD
    bV4GreenMask*: DWORD
    bV4BlueMask*: DWORD
    bV4AlphaMask*: DWORD
    bV4CSType*: DWORD
    bV4Endpoints*: CIEXYZTRIPLE
    bV4GammaRed*: DWORD
    bV4GammaGreen*: DWORD
    bV4GammaBlue*: DWORD

  LPBITMAPV4HEADER* = ptr BITMAPV4HEADER
  TBITMAPV4HEADER* = BITMAPV4HEADER
  PBITMAPV4HEADER* = ptr BITMAPV4HEADER
  BITMAPFILEHEADER* {.final, pure.} = object
    bfType*: int16
    bfSize*: DWord
    bfReserved1*: int16
    bfReserved2*: int16
    bfOffBits*: DWord

  BLOB* {.final, pure.} = object
    cbSize*: ULONG
    pBlobData*: ptr int8

  TBLOB* = BLOB
  PBLOB* = ptr BLOB
  SHITEMID* {.final, pure.} = object
    cb*: USHORT
    abID*: array[0..0, int8]

  LPSHITEMID* = ptr SHITEMID
  LPCSHITEMID* = ptr SHITEMID
  TSHITEMID* = SHITEMID
  PSHITEMID* = ptr SHITEMID
  ITEMIDLIST* {.final, pure.} = object
    mkid*: SHITEMID

  LPITEMIDLIST* = ptr ITEMIDLIST
  LPCITEMIDLIST* = ptr ITEMIDLIST
  TITEMIDLIST* = ITEMIDLIST
  PITEMIDLIST* = ptr ITEMIDLIST
  BROWSEINFO* {.final, pure.} = object
    hwndOwner*: HWND
    pidlRoot*: LPCITEMIDLIST
    pszDisplayName*: LPSTR
    lpszTitle*: LPCSTR
    ulFlags*: UINT
    lpfn*: BFFCALLBACK
    lParam*: LPARAM
    iImage*: int32

  LPBROWSEINFO* = ptr BROWSEINFO
  Tbrowseinfo* = BROWSEINFO
  PBROWSEINFO* = ptr BROWSEINFO

  BY_HANDLE_FILE_INFORMATION* {.final, pure.} = object
    dwFileAttributes*: DWORD
    ftCreationTime*: FILETIME
    ftLastAccessTime*: FILETIME
    ftLastWriteTime*: FILETIME
    dwVolumeSerialNumber*: DWORD
    nFileSizeHigh*: DWORD
    nFileSizeLow*: DWORD
    nNumberOfLinks*: DWORD
    nFileIndexHigh*: DWORD
    nFileIndexLow*: DWORD

  LPBY_HANDLE_FILE_INFORMATION* = ptr BY_HANDLE_FILE_INFORMATION
  TBYHANDLEFILEINFORMATION* = BY_HANDLE_FILE_INFORMATION
  PBYHANDLEFILEINFORMATION* = ptr BY_HANDLE_FILE_INFORMATION
  FIXED* {.final, pure.} = object
    fract*: int16
    value*: SHORT

  TFIXED* = FIXED
  PFIXED* = ptr FIXED
  POINTFX* {.final, pure.} = object
    x*: FIXED
    y*: FIXED

  TPOINTFX* = POINTFX
  PPOINTFX* = ptr POINTFX

  TSmallPoint* {.final, pure.} = object
    X*, Y*: SHORT

  CANDIDATEFORM* {.final, pure.} = object
    dwIndex*: DWORD
    dwStyle*: DWORD
    ptCurrentPos*: POINT
    rcArea*: RECT

  LPCANDIDATEFORM* = ptr CANDIDATEFORM
  TCANDIDATEFORM* = CANDIDATEFORM
  PCANDIDATEFORM* = ptr CANDIDATEFORM
  CANDIDATELIST* {.final, pure.} = object
    dwSize*: DWORD
    dwStyle*: DWORD
    dwCount*: DWORD
    dwSelection*: DWORD
    dwPageStart*: DWORD
    dwPageSize*: DWORD
    dwOffset*: array[0..0, DWORD]

  LPCANDIDATELIST* = ptr CANDIDATELIST
  TCANDIDATELIST* = CANDIDATELIST
  PCANDIDATELIST* = ptr CANDIDATELIST
  CREATESTRUCT* {.final, pure.} = object
    lpCreateParams*: LPVOID
    hInstance*: HINST
    hMenu*: HMENU
    hwndParent*: HWND
    cy*: int32
    cx*: int32
    y*: int32
    x*: int32
    style*: LONG
    lpszName*: LPCTSTR
    lpszClass*: LPCTSTR
    dwExStyle*: DWORD

  LPCREATESTRUCT* = ptr CREATESTRUCT
  TCREATESTRUCT* = CREATESTRUCT
  PCREATESTRUCT* = ptr CREATESTRUCT
  CBT_CREATEWND* {.final, pure.} = object
    lpcs*: LPCREATESTRUCT
    hwndInsertAfter*: HWND

  TCBT_CREATEWND* = CBT_CREATEWND
  PCBT_CREATEWND* = ptr CBT_CREATEWND
  CBTACTIVATESTRUCT* {.final, pure.} = object
    fMouse*: WINBOOL
    hWndActive*: HWND

  TCBTACTIVATESTRUCT* = CBTACTIVATESTRUCT
  PCBTACTIVATESTRUCT* = ptr CBTACTIVATESTRUCT
  CHAR_INFO* {.final, pure.} = object
    UnicodeChar*: WCHAR
    Attributes*: int16        # other union part: AsciiChar : CHAR

  TCHAR_INFO* = CHAR_INFO
  PCHAR_INFO* = ptr CHAR_INFO
  CHARFORMAT* {.final, pure.} = object
    cbSize*: UINT
    dwMask*: DWORD
    dwEffects*: DWORD
    yHeight*: LONG
    yOffset*: LONG
    crTextColor*: COLORREF
    bCharSet*: int8
    bPitchAndFamily*: int8
    szFaceName*: array[0..(LF_FACESIZE) - 1, TCHAR]

  Tcharformat* = CHARFORMAT
  Pcharformat* = ptr CHARFORMAT
  CHARRANGE* {.final, pure.} = object
    cpMin*: LONG
    cpMax*: LONG

  Tcharrange* = CHARRANGE
  Pcharrange* = ptr CHARRANGE
  CHARSET* {.final, pure.} = object
    aflBlock*: array[0..2, DWORD]
    flLang*: DWORD

  TCHARSET* = CHARSET
  PCHARSET* = ptr CHARSET
  FONTSIGNATURE* {.final, pure.} = object
    fsUsb*: array[0..3, DWORD]
    fsCsb*: array[0..1, DWORD]

  LPFONTSIGNATURE* = ptr FONTSIGNATURE
  TFONTSIGNATURE* = FONTSIGNATURE
  PFONTSIGNATURE* = ptr FONTSIGNATURE
  CHARSETINFO* {.final, pure.} = object
    ciCharset*: UINT
    ciACP*: UINT
    fs*: FONTSIGNATURE

  LPCHARSETINFO* = ptr CHARSETINFO
  TCHARSETINFO* = CHARSETINFO
  PCHARSETINFO* = ptr CHARSETINFO
  #CHOOSECOLOR = record confilcts with function ChooseColor
  TCHOOSECOLOR* {.final, pure.} = object
    lStructSize*: DWORD
    hwndOwner*: HWND
    hInstance*: HWND
    rgbResult*: COLORREF
    lpCustColors*: ptr COLORREF
    Flags*: DWORD
    lCustData*: LPARAM
    lpfnHook*: LPCCHOOKPROC
    lpTemplateName*: LPCTSTR

  LPCHOOSECOLOR* = ptr TCHOOSECOLOR
  PCHOOSECOLOR* = ptr TCHOOSECOLOR
  LOGFONT* {.final, pure.} = object
    lfHeight*: LONG
    lfWidth*: LONG
    lfEscapement*: LONG
    lfOrientation*: LONG
    lfWeight*: LONG
    lfItalic*: int8
    lfUnderline*: int8
    lfStrikeOut*: int8
    lfCharSet*: int8
    lfOutPrecision*: int8
    lfClipPrecision*: int8
    lfQuality*: int8
    lfPitchAndFamily*: int8
    lfFaceName*: array[0..(LF_FACESIZE) - 1, TCHAR]

  LPLOGFONT* = ptr LOGFONT
  TLOGFONT* = LOGFONT
  TLOGFONTA* = LOGFONT
  PLOGFONT* = ptr LOGFONT
  PLOGFONTA* = PLOGFONT
  LOGFONTW* {.final, pure.} = object
    lfHeight*: LONG
    lfWidth*: LONG
    lfEscapement*: LONG
    lfOrientation*: LONG
    lfWeight*: LONG
    lfItalic*: int8
    lfUnderline*: int8
    lfStrikeOut*: int8
    lfCharSet*: int8
    lfOutPrecision*: int8
    lfClipPrecision*: int8
    lfQuality*: int8
    lfPitchAndFamily*: int8
    lfFaceName*: array[0..LF_FACESIZE - 1, WCHAR]

  LPLOGFONTW* = ptr LOGFONTW
  NPLOGFONTW* = ptr LOGFONTW
  TLogFontW* = LOGFONTW
  PLogFontW* = ptr TLogFontW
  TCHOOSEFONT* {.final, pure.} = object
    lStructSize*: DWORD
    hwndOwner*: HWND
    hDC*: HDC
    lpLogFont*: LPLOGFONT
    iPointSize*: WINT
    Flags*: DWORD
    rgbColors*: DWORD
    lCustData*: LPARAM
    lpfnHook*: LPCFHOOKPROC
    lpTemplateName*: LPCTSTR
    hInstance*: HINST
    lpszStyle*: LPTSTR
    nFontType*: int16
    MISSING_ALIGNMENT*: int16
    nSizeMin*: WINT
    nSizeMax*: WINT

  LPCHOOSEFONT* = ptr TCHOOSEFONT
  PCHOOSEFONT* = ptr TCHOOSEFONT
  CIDA* {.final, pure.} = object
    cidl*: UINT
    aoffset*: array[0..0, UINT]

  LPIDA* = ptr CIDA
  TIDA* = CIDA
  PIDA* = ptr CIDA
  CLIENTCREATESTRUCT* {.final, pure.} = object
    hWindowMenu*: HANDLE
    idFirstChild*: UINT

  LPCLIENTCREATESTRUCT* = ptr CLIENTCREATESTRUCT
  TCLIENTCREATESTRUCT* = CLIENTCREATESTRUCT
  PCLIENTCREATESTRUCT* = ptr CLIENTCREATESTRUCT
  CMINVOKECOMMANDINFO* {.final, pure.} = object
    cbSize*: DWORD
    fMask*: DWORD
    hwnd*: HWND
    lpVerb*: LPCSTR
    lpParameters*: LPCSTR
    lpDirectory*: LPCSTR
    nShow*: int32
    dwHotKey*: DWORD
    hIcon*: HANDLE

  LPCMINVOKECOMMANDINFO* = ptr CMINVOKECOMMANDINFO
  TCMInvokeCommandInfo* = CMINVOKECOMMANDINFO
  PCMInvokeCommandInfo* = ptr CMINVOKECOMMANDINFO
  COLORADJUSTMENT* {.final, pure.} = object
    caSize*: int16
    caFlags*: int16
    caIlluminantIndex*: int16
    caRedGamma*: int16
    caGreenGamma*: int16
    caBlueGamma*: int16
    caReferenceBlack*: int16
    caReferenceWhite*: int16
    caContrast*: SHORT
    caBrightness*: SHORT
    caColorfulness*: SHORT
    caRedGreenTint*: SHORT

  LPCOLORADJUSTMENT* = ptr COLORADJUSTMENT
  TCOLORADJUSTMENT* = COLORADJUSTMENT
  PCOLORADJUSTMENT* = ptr COLORADJUSTMENT
  COLORMAP* {.final, pure.} = object
    `from`*: COLORREF
    `to`*: COLORREF          # XXX!

  LPCOLORMAP* = ptr COLORMAP
  TCOLORMAP* = COLORMAP
  PCOLORMAP* = ptr COLORMAP
  DCB* {.final, pure.} = object
    DCBlength*: DWORD
    BaudRate*: DWORD
    flags*: DWORD
    wReserved*: int16
    XonLim*: int16
    XoffLim*: int16
    ByteSize*: int8
    Parity*: int8
    StopBits*: int8
    XonChar*: char
    XoffChar*: char
    ErrorChar*: char
    EofChar*: char
    EvtChar*: char
    wReserved1*: int16

  LPDCB* = ptr DCB
  TDCB* = DCB
  PDCB* = ptr DCB

const
  bm_DCB_fBinary* = 1
  bp_DCB_fBinary* = 0'i32
  bm_DCB_fParity* = 0x00000002
  bp_DCB_fParity* = 1'i32
  bm_DCB_fOutxCtsFlow* = 0x00000004
  bp_DCB_fOutxCtsFlow* = 2'i32
  bm_DCB_fOutxDsrFlow* = 0x00000008
  bp_DCB_fOutxDsrFlow* = 3'i32
  bm_DCB_fDtrControl* = 0x00000030
  bp_DCB_fDtrControl* = 4'i32
  bm_DCB_fDsrSensitivity* = 0x00000040
  bp_DCB_fDsrSensitivity* = 6'i32
  bm_DCB_fTXContinueOnXoff* = 0x00000080
  bp_DCB_fTXContinueOnXoff* = 7'i32
  bm_DCB_fOutX* = 0x00000100
  bp_DCB_fOutX* = 8'i32
  bm_DCB_fInX* = 0x00000200
  bp_DCB_fInX* = 9'i32
  bm_DCB_fErrorChar* = 0x00000400
  bp_DCB_fErrorChar* = 10'i32
  bm_DCB_fNull* = 0x00000800
  bp_DCB_fNull* = 11'i32
  bm_DCB_fRtsControl* = 0x00003000
  bp_DCB_fRtsControl* = 12'i32
  bm_DCB_fAbortOnError* = 0x00004000
  bp_DCB_fAbortOnError* = 14'i32
  bm_DCB_fDummy2* = 0xFFFF8000'i32
  bp_DCB_fDummy2* = 15'i32

proc fBinary*(a: var DCB): DWORD
proc set_fBinary*(a: var DCB, fBinary: DWORD)
proc fParity*(a: var DCB): DWORD
proc set_fParity*(a: var DCB, fParity: DWORD)
proc fOutxCtsFlow*(a: var DCB): DWORD
proc set_fOutxCtsFlow*(a: var DCB, fOutxCtsFlow: DWORD)
proc fOutxDsrFlow*(a: var DCB): DWORD
proc set_fOutxDsrFlow*(a: var DCB, fOutxDsrFlow: DWORD)
proc fDtrControl*(a: var DCB): DWORD
proc set_fDtrControl*(a: var DCB, fDtrControl: DWORD)
proc fDsrSensitivity*(a: var DCB): DWORD
proc set_fDsrSensitivity*(a: var DCB, fDsrSensitivity: DWORD)
proc fTXContinueOnXoff*(a: var DCB): DWORD
proc set_fTXContinueOnXoff*(a: var DCB, fTXContinueOnXoff: DWORD)
proc fOutX*(a: var DCB): DWORD
proc set_fOutX*(a: var DCB, fOutX: DWORD)
proc fInX*(a: var DCB): DWORD
proc set_fInX*(a: var DCB, fInX: DWORD)
proc fErrorChar*(a: var DCB): DWORD
proc set_fErrorChar*(a: var DCB, fErrorChar: DWORD)
proc fNull*(a: var DCB): DWORD
proc set_fNull*(a: var DCB, fNull: DWORD)
proc fRtsControl*(a: var DCB): DWORD
proc set_fRtsControl*(a: var DCB, fRtsControl: DWORD)
proc fAbortOnError*(a: var DCB): DWORD
proc set_fAbortOnError*(a: var DCB, fAbortOnError: DWORD)
proc fDummy2*(a: var DCB): DWORD
proc set_fDummy2*(a: var DCB, fDummy2: DWORD)
type
  COMMCONFIG* {.final, pure.} = object
    dwSize*: DWORD
    wVersion*: int16
    wReserved*: int16
    dcb*: DCB
    dwProviderSubType*: DWORD
    dwProviderOffset*: DWORD
    dwProviderSize*: DWORD
    wcProviderData*: array[0..0, WCHAR]

  LPCOMMCONFIG* = ptr COMMCONFIG
  TCOMMCONFIG* = COMMCONFIG
  PCOMMCONFIG* = ptr COMMCONFIG
  COMMPROP* {.final, pure.} = object
    wPacketLength*: int16
    wPacketVersion*: int16
    dwServiceMask*: DWORD
    dwReserved1*: DWORD
    dwMaxTxQueue*: DWORD
    dwMaxRxQueue*: DWORD
    dwMaxBaud*: DWORD
    dwProvSubType*: DWORD
    dwProvCapabilities*: DWORD
    dwSettableParams*: DWORD
    dwSettableBaud*: DWORD
    wSettableData*: int16
    wSettableStopParity*: int16
    dwCurrentTxQueue*: DWORD
    dwCurrentRxQueue*: DWORD
    dwProvSpec1*: DWORD
    dwProvSpec2*: DWORD
    wcProvChar*: array[0..0, WCHAR]

  LPCOMMPROP* = ptr COMMPROP
  TCOMMPROP* = COMMPROP
  PCOMMPROP* = ptr COMMPROP
  COMMTIMEOUTS* {.final, pure.} = object
    ReadIntervalTimeout*: DWORD
    ReadTotalTimeoutMultiplier*: DWORD
    ReadTotalTimeoutConstant*: DWORD
    WriteTotalTimeoutMultiplier*: DWORD
    WriteTotalTimeoutConstant*: DWORD

  LPCOMMTIMEOUTS* = ptr COMMTIMEOUTS
  TCOMMTIMEOUTS* = COMMTIMEOUTS
  PCOMMTIMEOUTS* = ptr COMMTIMEOUTS
  COMPAREITEMSTRUCT* {.final, pure.} = object
    CtlType*: UINT
    CtlID*: UINT
    hwndItem*: HWND
    itemID1*: UINT
    itemData1*: ULONG_PTR
    itemID2*: UINT
    itemData2*: ULONG_PTR

  TCOMPAREITEMSTRUCT* = COMPAREITEMSTRUCT
  PCOMPAREITEMSTRUCT* = ptr COMPAREITEMSTRUCT
  COMPCOLOR* {.final, pure.} = object
    crText*: COLORREF
    crBackground*: COLORREF
    dwEffects*: DWORD

  TCOMPCOLOR* = COMPCOLOR
  PCOMPCOLOR* = ptr COMPCOLOR
  COMPOSITIONFORM* {.final, pure.} = object
    dwStyle*: DWORD
    ptCurrentPos*: POINT
    rcArea*: RECT

  LPCOMPOSITIONFORM* = ptr COMPOSITIONFORM
  TCOMPOSITIONFORM* = COMPOSITIONFORM
  PCOMPOSITIONFORM* = ptr COMPOSITIONFORM #     TComStatFlags = set of (fCtsHold, fDsrHold, fRlsdHold , fXoffHold ,
                                          #                    fXoffSent , fEof ,  fTxim  , fReserved);
  COMSTAT* {.final, pure.} = object
    flag0*: DWORD             # can't use tcomstatflags, set packing issues
                              # and conflicts with macro's
    cbInQue*: DWORD
    cbOutQue*: DWORD

  LPCOMSTAT* = ptr COMSTAT
  TCOMSTAT* = COMSTAT
  PCOMSTAT* = ptr COMSTAT

const
  bm_COMSTAT_fCtsHold* = 0x00000001
  bp_COMSTAT_fCtsHold* = 0'i32
  bm_COMSTAT_fDsrHold* = 0x00000002
  bp_COMSTAT_fDsrHold* = 1'i32
  bm_COMSTAT_fRlsdHold* = 0x00000004
  bp_COMSTAT_fRlsdHold* = 2'i32
  bm_COMSTAT_fXoffHold* = 0x00000008
  bp_COMSTAT_fXoffHold* = 3'i32
  bm_COMSTAT_fXoffSent* = 0x00000010
  bp_COMSTAT_fXoffSent* = 4'i32
  bm_COMSTAT_fEof* = 0x00000020
  bp_COMSTAT_fEof* = 5'i32
  bm_COMSTAT_fTxim* = 0x00000040
  bp_COMSTAT_fTxim* = 6'i32
  bm_COMSTAT_fReserved* = 0xFFFFFF80'i32
  bp_COMSTAT_fReserved* = 7'i32

proc fCtsHold*(a: var COMSTAT): DWORD
  # should be renamed to get_<x>?
proc set_fCtsHold*(a: var COMSTAT, fCtsHold: DWORD)
proc fDsrHold*(a: var COMSTAT): DWORD
proc set_fDsrHold*(a: var COMSTAT, fDsrHold: DWORD)
proc fRlsdHold*(a: var COMSTAT): DWORD
proc set_fRlsdHold*(a: var COMSTAT, fRlsdHold: DWORD)
proc fXoffHold*(a: var COMSTAT): DWORD
proc set_fXoffHold*(a: var COMSTAT, fXoffHold: DWORD)
proc fXoffSent*(a: var COMSTAT): DWORD
proc set_fXoffSent*(a: var COMSTAT, fXoffSent: DWORD)
proc fEof*(a: var COMSTAT): DWORD
proc set_fEof*(a: var COMSTAT, fEof: DWORD)
proc fTxim*(a: var COMSTAT): DWORD
proc set_fTxim*(a: var COMSTAT, fTxim: DWORD)
proc fReserved*(a: var COMSTAT): DWORD
proc set_fReserved*(a: var COMSTAT, fReserved: DWORD)
type
  CONSOLE_CURSOR_INFO* {.final, pure.} = object
    dwSize*: DWORD
    bVisible*: WINBOOL

  PCONSOLE_CURSOR_INFO* = ptr CONSOLE_CURSOR_INFO
  TCONSOLECURSORINFO* = CONSOLE_CURSOR_INFO
  TCURSORINFO* = CONSOLE_CURSOR_INFO
  COORD* {.final, pure.} = object
    X*: SHORT
    Y*: SHORT

  TCOORD* = COORD
  PCOORD* = ptr COORD
  SMALL_RECT* {.final, pure.} = object
    Left*: SHORT
    Top*: SHORT
    Right*: SHORT
    Bottom*: SHORT

  TSMALL_RECT* = SMALL_RECT
  PSMALL_RECT* = ptr SMALL_RECT
  CONSOLE_SCREEN_BUFFER_INFO* {.final, pure.} = object
    dwSize*: COORD
    dwCursorPosition*: COORD
    wAttributes*: int16
    srWindow*: SMALL_RECT
    dwMaximumWindowSize*: COORD

  PCONSOLE_SCREEN_BUFFER_INFO* = ptr CONSOLE_SCREEN_BUFFER_INFO
  TCONSOLESCREENBUFFERINFO* = CONSOLE_SCREEN_BUFFER_INFO

when defined(i386):
  type
    FLOATING_SAVE_AREA* {.final, pure.} = object
      ControlWord*: DWORD
      StatusWord*: DWORD
      TagWord*: DWORD
      ErrorOffset*: DWORD
      ErrorSelector*: DWORD
      DataOffset*: DWORD
      DataSelector*: DWORD
      RegisterArea*: array[0..79, int8]
      Cr0NpxState*: DWORD

    TFLOATINGSAVEAREA* = FLOATING_SAVE_AREA
    PFLOATINGSAVEAREA* = ptr FLOATING_SAVE_AREA
    CONTEXT* {.final, pure.} = object
      ContextFlags*: DWORD
      Dr0*: DWORD
      Dr1*: DWORD
      Dr2*: DWORD
      Dr3*: DWORD
      Dr6*: DWORD
      Dr7*: DWORD
      FloatSave*: FLOATING_SAVE_AREA
      SegGs*: DWORD
      SegFs*: DWORD
      SegEs*: DWORD
      SegDs*: DWORD
      Edi*: DWORD
      Esi*: DWORD
      Ebx*: DWORD
      Edx*: DWORD
      Ecx*: DWORD
      Eax*: DWORD
      Ebp*: DWORD
      Eip*: DWORD
      SegCs*: DWORD
      EFlags*: DWORD
      Esp*: DWORD
      SegSs*: DWORD

elif defined(x86_64):
  #
  # Define 128-bit 16-byte aligned xmm register type.
  #
  type
    M128A* {.final, pure.} = object
      Low*: ULONGLONG
      High*: LONGLONG

    TM128A* = M128A
    PM128A* = TM128A #typedef struct _XMM_SAVE_AREA32 {
    XMM_SAVE_AREA32* {.final, pure.} = object
      ControlWord*: int16
      StatusWord*: int16
      TagWord*: int8
      Reserved1*: int8
      ErrorOpcode*: int16
      ErrorOffset*: DWORD
      ErrorSelector*: int16
      Reserved2*: int16
      DataOffset*: DWORD
      DataSelector*: int16
      Reserved3*: int16
      MxCsr*: DWORD
      MxCsr_Mask*: DWORD
      FloatRegisters*: array[0..7, M128A]
      XmmRegisters*: array[0..16, M128A]
      Reserved4*: array[0..95, int8]

    TXmmSaveArea* = XMM_SAVE_AREA32
    PXmmSaveArea* = ptr TXmmSaveArea
  type
    CONTEXT* {.final, pure.} = object
      P1Home*: DWORD64
      P2Home*: DWORD64
      P3Home*: DWORD64
      P4Home*: DWORD64
      P5Home*: DWORD64
      P6Home*: DWORD64        #
                              # Control flags.
                              #
      ContextFlags*: DWORD
      MxCsr*: DWORD           #
                              # Segment Registers and processor flags.
                              #
      SegCs*: int16
      SegDs*: int16
      SegEs*: int16
      SegFs*: int16
      SegGs*: int16
      SegSs*: int16
      EFlags*: DWORD          #
                              # Debug registers
                              #
      Dr0*: DWORD64
      Dr1*: DWORD64
      Dr2*: DWORD64
      Dr3*: DWORD64
      Dr6*: DWORD64
      Dr7*: DWORD64           #
                              # Integer registers.
                              #
      Rax*: DWORD64
      Rcx*: DWORD64
      Rdx*: DWORD64
      Rbx*: DWORD64
      Rsp*: DWORD64
      Rbp*: DWORD64
      Rsi*: DWORD64
      Rdi*: DWORD64
      R8*: DWORD64
      R9*: DWORD64
      R10*: DWORD64
      R11*: DWORD64
      R12*: DWORD64
      R13*: DWORD64
      R14*: DWORD64
      R15*: DWORD64           #
                              # Program counter.
                              #
      Rip*: DWORD64           #
                              # Floating point state.
                              #
      FltSave*: XMM_SAVE_AREA32 # MWE: only translated the FltSave part of the union
                                #
                                # Vector registers.
                                #
      VectorRegister*: array[0..25, M128A]
      VectorControl*: DWORD64 #
                              # Special debug control registers.
                              #
      DebugControl*: DWORD64
      LastBranchToRip*: DWORD64
      LastBranchFromRip*: DWORD64
      LastExceptionToRip*: DWORD64
      LastExceptionFromRip*: DWORD64

elif defined(powerpc32):
  # ppc
  # Floating point registers returned when CONTEXT_FLOATING_POINT is set
  # Integer registers returned when CONTEXT_INTEGER is set.
  # Condition register
  # Fixed point exception register
  # The following are set when CONTEXT_CONTROL is set.
  # Machine status register
  # Instruction address register
  # Link register
  # Control register
  # Control which context values are returned
  # Registers returned if CONTEXT_DEBUG_REGISTERS is set.
  # Breakpoint Register 1
  # Breakpoint Register 2
  # Breakpoint Register 3
  # Breakpoint Register 4
  # Breakpoint Register 5
  # Breakpoint Register 6
  # Debug Status Register
  # Debug Control Register
  type
    CONTEXT* {.final, pure.} = object
      Fpr0*: float64
      Fpr1*: float64
      Fpr2*: float64
      Fpr3*: float64
      Fpr4*: float64
      Fpr5*: float64
      Fpr6*: float64
      Fpr7*: float64
      Fpr8*: float64
      Fpr9*: float64
      Fpr10*: float64
      Fpr11*: float64
      Fpr12*: float64
      Fpr13*: float64
      Fpr14*: float64
      Fpr15*: float64
      Fpr16*: float64
      Fpr17*: float64
      Fpr18*: float64
      Fpr19*: float64
      Fpr20*: float64
      Fpr21*: float64
      Fpr22*: float64
      Fpr23*: float64
      Fpr24*: float64
      Fpr25*: float64
      Fpr26*: float64
      Fpr27*: float64
      Fpr28*: float64
      Fpr29*: float64
      Fpr30*: float64
      Fpr31*: float64
      Fpscr*: float64
      Gpr0*: DWORD
      Gpr1*: DWORD
      Gpr2*: DWORD
      Gpr3*: DWORD
      Gpr4*: DWORD
      Gpr5*: DWORD
      Gpr6*: DWORD
      Gpr7*: DWORD
      Gpr8*: DWORD
      Gpr9*: DWORD
      Gpr10*: DWORD
      Gpr11*: DWORD
      Gpr12*: DWORD
      Gpr13*: DWORD
      Gpr14*: DWORD
      Gpr15*: DWORD
      Gpr16*: DWORD
      Gpr17*: DWORD
      Gpr18*: DWORD
      Gpr19*: DWORD
      Gpr20*: DWORD
      Gpr21*: DWORD
      Gpr22*: DWORD
      Gpr23*: DWORD
      Gpr24*: DWORD
      Gpr25*: DWORD
      Gpr26*: DWORD
      Gpr27*: DWORD
      Gpr28*: DWORD
      Gpr29*: DWORD
      Gpr30*: DWORD
      Gpr31*: DWORD
      Cr*: DWORD
      Xer*: DWORD
      Msr*: DWORD
      Iar*: DWORD
      Lr*: DWORD
      Ctr*: DWORD
      ContextFlags*: DWORD
      Fill*: array[0..2, DWORD]
      Dr0*: DWORD
      Dr1*: DWORD
      Dr2*: DWORD
      Dr3*: DWORD
      Dr4*: DWORD
      Dr5*: DWORD
      Dr6*: DWORD
      Dr7*: DWORD

else:
  # dummy CONTEXT so that it compiles:
  type
    CONTEXT* {.final, pure.} = object
      data: array [0..255, float64]

type
  LPCONTEXT* = ptr CONTEXT
  TCONTEXT* = CONTEXT
  PCONTEXT* = ptr CONTEXT

type
  LIST_ENTRY* {.final, pure.} = object
    Flink*: ptr LIST_ENTRY
    Blink*: ptr LIST_ENTRY

  TLISTENTRY* = LIST_ENTRY
  PLISTENTRY* = ptr LIST_ENTRY
  CRITICAL_SECTION_DEBUG* {.final, pure.} = object
    `type`*: int16
    CreatorBackTraceIndex*: int16
    CriticalSection*: ptr TCRITICAL_SECTION
    ProcessLocksList*: LIST_ENTRY
    EntryCount*: DWORD
    ContentionCount*: DWORD
    Depth*: DWORD
    OwnerBackTrace*: array[0..4, PVOID]

  TRTL_CRITICAL_SECTION* {.final, pure.} = object
    DebugInfo*: ptr CRITICAL_SECTION_DEBUG
    LockCount*: int32
    RecursionCount*: int32
    OwningThread*: Handle
    LockSemaphore*: Handle
    Reserved*: DWORD

  PRTLCriticalSection* = ptr TRTLCriticalSection

  LPCRITICAL_SECTION_DEBUG* = ptr CRITICAL_SECTION_DEBUG
  PCRITICAL_SECTION_DEBUG* = ptr CRITICAL_SECTION_DEBUG
  TCRITICALSECTIONDEBUG* = CRITICAL_SECTION_DEBUG
  TCRITICAL_SECTION* = TRTLCriticalSection
  PCRITICAL_SECTION* = PRTLCriticalSection
  LPCRITICAL_SECTION* = PRTLCriticalSection
  SECURITY_QUALITY_OF_SERVICE* {.final, pure.} = object
    len*: DWORD
    ImpersonationLevel*: SECURITY_IMPERSONATION_LEVEL
    ContextTrackingMode*: WINBOOL
    EffectiveOnly*: bool

  PSECURITY_QUALITY_OF_SERVICE* = ptr SECURITY_QUALITY_OF_SERVICE
  TSECURITYQUALITYOFSERVICE* = SECURITY_QUALITY_OF_SERVICE
  CONVCONTEXT* {.final, pure.} = object
    cb*: UINT
    wFlags*: UINT
    wCountryID*: UINT
    iCodePage*: int32
    dwLangID*: DWORD
    dwSecurity*: DWORD
    qos*: SECURITY_QUALITY_OF_SERVICE

  TCONVCONTEXT* = CONVCONTEXT
  PCONVCONTEXT* = ptr CONVCONTEXT
  CONVINFO* {.final, pure.} = object
    cb*: DWORD
    hUser*: DWORD
    hConvPartner*: HCONV
    hszSvcPartner*: HSZ
    hszServiceReq*: HSZ
    hszTopic*: HSZ
    hszItem*: HSZ
    wFmt*: UINT
    wType*: UINT
    wStatus*: UINT
    wConvst*: UINT
    wLastError*: UINT
    hConvList*: HCONVLIST
    ConvCtxt*: CONVCONTEXT
    hwnd*: HWND
    hwndPartner*: HWND

  TCONVINFO* = CONVINFO
  PCONVINFO* = ptr CONVINFO
  COPYDATASTRUCT* {.final, pure.} = object
    dwData*: DWORD
    cbData*: DWORD
    lpData*: PVOID

  TCOPYDATASTRUCT* = COPYDATASTRUCT
  PCOPYDATASTRUCT* = ptr COPYDATASTRUCT
  CPINFO* {.final, pure.} = object
    MaxCharSize*: UINT
    DefaultChar*: array[0..(MAX_DEFAULTCHAR) - 1, int8]
    LeadByte*: array[0..(MAX_LEADBYTES) - 1, int8]

  LPCPINFO* = ptr CPINFO
  Tcpinfo* = CPINFO
  Pcpinfo* = ptr CPINFO
  CPLINFO* {.final, pure.} = object
    idIcon*: int32
    idName*: int32
    idInfo*: int32
    lData*: LONG

  TCPLINFO* = CPLINFO
  PCPLINFO* = ptr CPLINFO
  CREATE_PROCESS_DEBUG_INFO* {.final, pure.} = object
    hFile*: HANDLE
    hProcess*: HANDLE
    hThread*: HANDLE
    lpBaseOfImage*: LPVOID
    dwDebugInfoFileOffset*: DWORD
    nDebugInfoSize*: DWORD
    lpThreadLocalBase*: LPVOID
    lpStartAddress*: LPTHREAD_START_ROUTINE
    lpImageName*: LPVOID
    fUnicode*: int16

  TCREATEPROCESSDEBUGINFO* = CREATE_PROCESS_DEBUG_INFO
  PCREATEPROCESSDEBUGINFO* = ptr CREATE_PROCESS_DEBUG_INFO
  CREATE_THREAD_DEBUG_INFO* {.final, pure.} = object
    hThread*: HANDLE
    lpThreadLocalBase*: LPVOID
    lpStartAddress*: LPTHREAD_START_ROUTINE

  TCREATETHREADDEBUGINFO* = CREATE_THREAD_DEBUG_INFO
  PCREATETHREADDEBUGINFO* = ptr CREATE_THREAD_DEBUG_INFO

  CURRENCYFMT* {.final, pure.} = object
    NumDigits*: UINT
    LeadingZero*: UINT
    Grouping*: UINT
    lpDecimalSep*: LPTSTR
    lpThousandSep*: LPTSTR
    NegativeOrder*: UINT
    PositiveOrder*: UINT
    lpCurrencySymbol*: LPTSTR

  Tcurrencyfmt* = CURRENCYFMT
  Pcurrencyfmt* = ptr CURRENCYFMT
  CURSORSHAPE* {.final, pure.} = object
    xHotSpot*: int32
    yHotSpot*: int32
    cx*: int32
    cy*: int32
    cbWidth*: int32
    Planes*: int8
    BitsPixel*: int8

  LPCURSORSHAPE* = ptr CURSORSHAPE
  TCURSORSHAPE* = CURSORSHAPE
  PCURSORSHAPE* = ptr CURSORSHAPE
  CWPRETSTRUCT* {.final, pure.} = object
    lResult*: LRESULT
    lParam*: LPARAM
    wParam*: WPARAM
    message*: DWORD
    hwnd*: HWND

  TCWPRETSTRUCT* = CWPRETSTRUCT
  PCWPRETSTRUCT* = ptr CWPRETSTRUCT
  CWPSTRUCT* {.final, pure.} = object
    lParam*: LPARAM
    wParam*: WPARAM
    message*: UINT
    hwnd*: HWND

  TCWPSTRUCT* = CWPSTRUCT
  PCWPSTRUCT* = ptr CWPSTRUCT
  DATATYPES_INFO_1* {.final, pure.} = object
    pName*: LPTSTR

  TDATATYPESINFO1* = DATATYPES_INFO_1
  PDATATYPESINFO1* = ptr DATATYPES_INFO_1
  DDEACK* {.final, pure.} = object
    flag0*: int16

  TDDEACK* = DDEACK
  PDDEACK* = ptr DDEACK

const
  bm_DDEACK_bAppReturnCode* = 0x000000FF'i16
  bp_DDEACK_bAppReturnCode* = 0'i16
  bm_DDEACK_reserved* = 0x00003F00'i16
  bp_DDEACK_reserved* = 8'i16
  bm_DDEACK_fBusy* = 0x00004000'i16
  bp_DDEACK_fBusy* = 14'i16
  bm_DDEACK_fAck* = 0x00008000'i16
  bp_DDEACK_fAck* = 15'i16

proc bAppReturnCode*(a: var DDEACK): int16
proc set_bAppReturnCode*(a: var DDEACK, bAppReturnCode: int16)
proc reserved*(a: var DDEACK): int16
proc set_reserved*(a: var DDEACK, reserved: int16)
proc fBusy*(a: var DDEACK): int16
proc set_fBusy*(a: var DDEACK, fBusy: int16)
proc fAck*(a: var DDEACK): int16
proc set_fAck*(a: var DDEACK, fAck: int16)
type
  DDEADVISE* {.final, pure.} = object
    flag0*: int16
    cfFormat*: SHORT

  TDDEADVISE* = DDEADVISE
  PDDEADVISE* = ptr DDEADVISE

const
  bm_DDEADVISE_reserved* = 0x00003FFF'i16
  bp_DDEADVISE_reserved* = 0'i16
  bm_DDEADVISE_fDeferUpd* = 0x00004000'i16
  bp_DDEADVISE_fDeferUpd* = 14'i16
  bm_DDEADVISE_fAckReq* = 0x00008000'i16
  bp_DDEADVISE_fAckReq* = 15'i16

proc reserved*(a: var DDEADVISE): int16
proc set_reserved*(a: var DDEADVISE, reserved: int16)
proc fDeferUpd*(a: var DDEADVISE): int16
proc set_fDeferUpd*(a: var DDEADVISE, fDeferUpd: int16)
proc fAckReq*(a: var DDEADVISE): int16
proc set_fAckReq*(a: var DDEADVISE, fAckReq: int16)
type
  DDEDATA* {.final, pure.} = object
    flag0*: int16
    cfFormat*: SHORT
    Value*: array[0..0, int8]

  PDDEDATA* = ptr DDEDATA

const
  bm_DDEDATA_unused* = 0x00000FFF'i16
  bp_DDEDATA_unused* = 0'i16
  bm_DDEDATA_fResponse* = 0x00001000'i16
  bp_DDEDATA_fResponse* = 12'i16
  bm_DDEDATA_fRelease* = 0x00002000'i16
  bp_DDEDATA_fRelease* = 13'i16
  bm_DDEDATA_reserved* = 0x00004000'i16
  bp_DDEDATA_reserved* = 14'i16
  bm_DDEDATA_fAckReq* = 0x00008000'i16
  bp_DDEDATA_fAckReq* = 15'i16

proc unused*(a: var DDEDATA): int16
proc set_unused*(a: var DDEDATA, unused: int16)
proc fResponse*(a: var DDEDATA): int16
proc set_fResponse*(a: var DDEDATA, fResponse: int16)
proc fRelease*(a: var DDEDATA): int16
proc set_fRelease*(a: var DDEDATA, fRelease: int16)
proc reserved*(a: var DDEDATA): int16
proc set_reserved*(a: var DDEDATA, reserved: int16)
proc fAckReq*(a: var DDEDATA): int16
proc set_fAckReq*(a: var DDEDATA, fAckReq: int16)
type
  DDELN* {.final, pure.} = object
    flag0*: int16
    cfFormat*: SHORT

  TDDELN* = DDELN
  PDDELN* = ptr DDELN

const
  bm_DDELN_unused* = 0x00001FFF'i16
  bp_DDELN_unused* = 0'i16
  bm_DDELN_fRelease* = 0x00002000'i16
  bp_DDELN_fRelease* = 13'i16
  bm_DDELN_fDeferUpd* = 0x00004000'i16
  bp_DDELN_fDeferUpd* = 14'i16
  bm_DDELN_fAckReq* = 0x00008000'i16
  bp_DDELN_fAckReq* = 15'i16

proc unused*(a: var DDELN): int16
proc set_unused*(a: var DDELN, unused: int16)
proc fRelease*(a: var DDELN): int16
proc set_fRelease*(a: var DDELN, fRelease: int16)
proc fDeferUpd*(a: var DDELN): int16
proc set_fDeferUpd*(a: var DDELN, fDeferUpd: int16)
proc fAckReq*(a: var DDELN): int16
proc set_fAckReq*(a: var DDELN, fAckReq: int16)
type
  DDEML_MSG_HOOK_DATA* {.final, pure.} = object
    uiLo*: UINT
    uiHi*: UINT
    cbData*: DWORD
    Data*: array[0..7, DWORD]

  TDDEMLMSGHOOKDATA* = DDEML_MSG_HOOK_DATA
  PDDEMLMSGHOOKDATA* = ptr DDEML_MSG_HOOK_DATA
  DDEPOKE* {.final, pure.} = object
    flag0*: int16
    cfFormat*: SHORT
    Value*: array[0..0, int8]

  TDDEPOKE* = DDEPOKE
  PDDEPOKE* = ptr DDEPOKE

const
  bm_DDEPOKE_unused* = 0x00001FFF'i16
  bp_DDEPOKE_unused* = 0'i16
  bm_DDEPOKE_fRelease* = 0x00002000'i16
  bp_DDEPOKE_fRelease* = 13'i16
  bm_DDEPOKE_fReserved* = 0x0000C000'i16
  bp_DDEPOKE_fReserved* = 14'i16

proc unused*(a: var DDEPOKE): int16
proc set_unused*(a: var DDEPOKE, unused: int16)
proc fRelease*(a: var DDEPOKE): int16
proc set_fRelease*(a: var DDEPOKE, fRelease: int16)
proc fReserved*(a: var DDEPOKE): int16
proc set_fReserved*(a: var DDEPOKE, fReserved: int16)
type
  DDEUP* {.final, pure.} = object
    flag0*: int16
    cfFormat*: SHORT
    rgb*: array[0..0, int8]

  TDDEUP* = DDEUP
  PDDEUP* = ptr DDEUP

const
  bm_DDEUP_unused* = 0x00000FFF'i16
  bp_DDEUP_unused* = 0'i16
  bm_DDEUP_fAck* = 0x00001000'i16
  bp_DDEUP_fAck* = 12'i16
  bm_DDEUP_fRelease* = 0x00002000'i16
  bp_DDEUP_fRelease* = 13'i16
  bm_DDEUP_fReserved* = 0x00004000'i16
  bp_DDEUP_fReserved* = 14'i16
  bm_DDEUP_fAckReq* = 0x00008000'i16
  bp_DDEUP_fAckReq* = 15'i16

proc unused*(a: var DDEUP): int16
proc set_unused*(a: var DDEUP, unused: int16)
proc fAck*(a: var DDEUP): int16
proc set_fAck*(a: var DDEUP, fAck: int16)
proc fRelease*(a: var DDEUP): int16
proc set_fRelease*(a: var DDEUP, fRelease: int16)
proc fReserved*(a: var DDEUP): int16
proc set_fReserved*(a: var DDEUP, fReserved: int16)
proc fAckReq*(a: var DDEUP): int16
proc set_fAckReq*(a: var DDEUP, fAckReq: int16)
type
  EXCEPTION_RECORD* {.final, pure.} = object
    ExceptionCode*: DWORD
    ExceptionFlags*: DWORD
    ExceptionRecord*: ptr EXCEPTION_RECORD
    ExceptionAddress*: PVOID
    NumberParameters*: DWORD
    ExceptionInformation*: array[0..(EXCEPTION_MAXIMUM_PARAMETERS) - 1,
                                 ULONG_PTR]

  PEXCEPTION_RECORD* = ptr EXCEPTION_RECORD
  TEXCEPTIONRECORD* = EXCEPTION_RECORD
  EXCEPTION_DEBUG_INFO* {.final, pure.} = object
    ExceptionRecord*: EXCEPTION_RECORD
    dwFirstChance*: DWORD

  PEXCEPTION_DEBUG_INFO* = ptr EXCEPTION_DEBUG_INFO
  TEXCEPTIONDEBUGINFO* = EXCEPTION_DEBUG_INFO
  EXCEPTION_RECORD32* {.final, pure.} = object
    ExceptionCode*: DWORD
    ExceptionFlags*: DWORD
    ExceptionRecord*: DWORD
    ExceptionAddress*: DWORD
    NumberParameters*: DWORD
    ExceptionInformation*: array[0..(EXCEPTION_MAXIMUM_PARAMETERS) - 1, DWORD]

  PEXCEPTION_RECORD32* = ptr EXCEPTION_RECORD32
  TExceptionRecord32* = EXCEPTION_RECORD32
  EXCEPTION_DEBUG_INFO32* {.final, pure.} = object
    ExceptionRecord*: EXCEPTION_RECORD32
    dwFirstChance*: DWORD

  PEXCEPTION_DEBUG_INFO32* = ptr EXCEPTION_DEBUG_INFO32
  TExceptionDebugInfo32* = EXCEPTION_DEBUG_INFO32
  EXCEPTION_RECORD64* {.final, pure.} = object
    ExceptionCode*: DWORD
    ExceptionFlags*: DWORD
    ExceptionRecord*: DWORD64
    ExceptionAddress*: DWORD64
    NumberParameters*: DWORD
    unusedAlignment*: DWORD
    ExceptionInformation*: array[0..(EXCEPTION_MAXIMUM_PARAMETERS) - 1, DWORD64]

  PEXCEPTION_RECORD64* = ptr EXCEPTION_RECORD64
  TExceptionRecord64* = EXCEPTION_RECORD64
  EXCEPTION_DEBUG_INFO64* {.final, pure.} = object
    ExceptionRecord*: EXCEPTION_RECORD64
    dwFirstChance*: DWORD

  PEXCEPTION_DEBUG_INFO64* = ptr EXCEPTION_DEBUG_INFO64
  TExceptionDebugInfo64* = EXCEPTION_DEBUG_INFO64
  EXIT_PROCESS_DEBUG_INFO* {.final, pure.} = object
    dwExitCode*: DWORD

  TEXITPROCESSDEBUGINFO* = EXIT_PROCESS_DEBUG_INFO
  PEXITPROCESSDEBUGINFO* = ptr EXIT_PROCESS_DEBUG_INFO
  EXIT_THREAD_DEBUG_INFO* {.final, pure.} = object
    dwExitCode*: DWORD

  TEXITTHREADDEBUGINFO* = EXIT_THREAD_DEBUG_INFO
  PEXITTHREADDEBUGINFO* = ptr EXIT_THREAD_DEBUG_INFO
  LOAD_DLL_DEBUG_INFO* {.final, pure.} = object
    hFile*: HANDLE
    lpBaseOfDll*: LPVOID
    dwDebugInfoFileOffset*: DWORD
    nDebugInfoSize*: DWORD
    lpImageName*: LPVOID
    fUnicode*: int16

  TLOADDLLDEBUGINFO* = LOAD_DLL_DEBUG_INFO
  PLOADDLLDEBUGINFO* = ptr LOAD_DLL_DEBUG_INFO
  UNLOAD_DLL_DEBUG_INFO* {.final, pure.} = object
    lpBaseOfDll*: LPVOID

  TUNLOADDLLDEBUGINFO* = UNLOAD_DLL_DEBUG_INFO
  PUNLOADDLLDEBUGINFO* = ptr UNLOAD_DLL_DEBUG_INFO
  OUTPUT_DEBUG_STRING_INFO* {.final, pure.} = object
    lpDebugStringData*: LPSTR
    fUnicode*: int16
    nDebugStringLength*: int16

  TOUTPUTDEBUGSTRINGINFO* = OUTPUT_DEBUG_STRING_INFO
  POUTPUTDEBUGSTRINGINFO* = ptr OUTPUT_DEBUG_STRING_INFO
  RIP_INFO* {.final, pure.} = object
    dwError*: DWORD
    dwType*: DWORD

  TRIPINFO* = RIP_INFO
  PRIPINFO* = ptr RIP_INFO
  DEBUG_EVENT* {.final, pure.} = object
    dwDebugEventCode*: DWORD
    dwProcessId*: DWORD
    dwThreadId*: DWORD
    data*: array[0..15, DWORD]

  LPDEBUG_EVENT* = ptr DEBUG_EVENT
  TDEBUGEVENT* = DEBUG_EVENT
  PDEBUGEVENT* = ptr DEBUG_EVENT
  DEBUGHOOKINFO* {.final, pure.} = object
    idThread*: DWORD
    idThreadInstaller*: DWORD
    lParam*: LPARAM
    wParam*: WPARAM
    code*: int32

  TDEBUGHOOKINFO* = DEBUGHOOKINFO
  PDEBUGHOOKINFO* = ptr DEBUGHOOKINFO
  DELETEITEMSTRUCT* {.final, pure.} = object
    CtlType*: UINT
    CtlID*: UINT
    itemID*: UINT
    hwndItem*: HWND
    itemData*: ULONG_PTR

  TDELETEITEMSTRUCT* = DELETEITEMSTRUCT
  PDELETEITEMSTRUCT* = ptr DELETEITEMSTRUCT
  DEV_BROADCAST_HDR* {.final, pure.} = object
    dbch_size*: ULONG
    dbch_devicetype*: ULONG
    dbch_reserved*: ULONG

  PDEV_BROADCAST_HDR* = ptr DEV_BROADCAST_HDR
  TDEVBROADCASTHDR* = DEV_BROADCAST_HDR
  DEV_BROADCAST_OEM* {.final, pure.} = object
    dbco_size*: ULONG
    dbco_devicetype*: ULONG
    dbco_reserved*: ULONG
    dbco_identifier*: ULONG
    dbco_suppfunc*: ULONG

  PDEV_BROADCAST_OEM* = ptr DEV_BROADCAST_OEM
  TDEVBROADCASTOEM* = DEV_BROADCAST_OEM
  DEV_BROADCAST_PORT* {.final, pure.} = object
    dbcp_size*: ULONG
    dbcp_devicetype*: ULONG
    dbcp_reserved*: ULONG
    dbcp_name*: array[0..0, char]

  PDEV_BROADCAST_PORT* = ptr DEV_BROADCAST_PORT
  TDEVBROADCASTPORT* = DEV_BROADCAST_PORT
  DEV_BROADCAST_USERDEFINED* {.final, pure.} = object
    dbud_dbh*: DEV_BROADCAST_HDR
    dbud_szName*: array[0..0, char]
    dbud_rgbUserDefined*: array[0..0, int8]

  TDEVBROADCASTUSERDEFINED* = DEV_BROADCAST_USERDEFINED
  PDEVBROADCASTUSERDEFINED* = ptr DEV_BROADCAST_USERDEFINED
  DEV_BROADCAST_VOLUME* {.final, pure.} = object
    dbcv_size*: ULONG
    dbcv_devicetype*: ULONG
    dbcv_reserved*: ULONG
    dbcv_unitmask*: ULONG
    dbcv_flags*: USHORT

  PDEV_BROADCAST_VOLUME* = ptr DEV_BROADCAST_VOLUME
  TDEVBROADCASTVOLUME* = DEV_BROADCAST_VOLUME
  DEVMODE* {.final, pure.} = object
    dmDeviceName*: array[0..(CCHDEVICENAME) - 1, BCHAR]
    dmSpecVersion*: int16
    dmDriverVersion*: int16
    dmSize*: int16
    dmDriverExtra*: int16
    dmFields*: DWORD
    dmOrientation*: int16
    dmPaperSize*: int16
    dmPaperLength*: int16
    dmPaperWidth*: int16
    dmScale*: int16
    dmCopies*: int16
    dmDefaultSource*: int16
    dmPrintQuality*: int16
    dmColor*: int16
    dmDuplex*: int16
    dmYResolution*: int16
    dmTTOption*: int16
    dmCollate*: int16
    dmFormName*: array[0..(CCHFORMNAME) - 1, BCHAR]
    dmLogPixels*: int16
    dmBitsPerPel*: DWORD
    dmPelsWidth*: DWORD
    dmPelsHeight*: DWORD
    dmDisplayFlags*: DWORD
    dmDisplayFrequency*: DWORD
    dmICMMethod*: DWORD
    dmICMIntent*: DWORD
    dmMediaType*: DWORD
    dmDitherType*: DWORD
    dmICCManufacturer*: DWORD
    dmICCModel*: DWORD        # other union part:
                              # dmPosition: POINTL;
                              # dmDisplayOrientation: DWORD;
                              # dmDisplayFixedOutput: DWORD;

  LPDEVMODE* = ptr DEVMODE
  devicemode* = DEVMODE
  tdevicemode* = DEVMODE
  tdevicemodeA* = DEVMODE
  PDeviceModeA* = LPDEVMODE
  PDeviceMode* = LPDEVMODE
  TDEVMODE* = DEVMODE
  PDEVMODE* = LPDEVMODE
  devmodeW* {.final, pure.} = object
    dmDeviceName*: array[0..CCHDEVICENAME - 1, WCHAR]
    dmSpecVersion*: int16
    dmDriverVersion*: int16
    dmSize*: int16
    dmDriverExtra*: int16
    dmFields*: DWORD
    dmOrientation*: short
    dmPaperSize*: short
    dmPaperLength*: short
    dmPaperWidth*: short
    dmScale*: short
    dmCopies*: short
    dmDefaultSource*: short
    dmPrintQuality*: short
    dmColor*: short
    dmDuplex*: short
    dmYResolution*: short
    dmTTOption*: short
    dmCollate*: short
    dmFormName*: array[0..CCHFORMNAME - 1, wchar]
    dmLogPixels*: int16
    dmBitsPerPel*: DWORD
    dmPelsWidth*: DWORD
    dmPelsHeight*: DWORD
    dmDisplayFlags*: DWORD
    dmDisplayFrequency*: DWORD
    dmICMMethod*: DWORD
    dmICMIntent*: DWORD
    dmMediaType*: DWORD
    dmDitherType*: DWORD
    dmReserved1*: DWORD
    dmReserved2*: DWORD
    dmPanningWidth*: DWORD
    dmPanningHeight*: DWORD

  LPDEVMODEW* = ptr DEVMODEW
  devicemodeW* = DEVMODEW
  TDeviceModeW* = DEVMODEW
  PDeviceModeW* = LPDEVMODEW
  TDEVMODEW* = DEVMODEW
  PDEVMODEW* = LPDEVMODEW
  DEVNAMES* {.final, pure.} = object
    wDriverOffset*: int16
    wDeviceOffset*: int16
    wOutputOffset*: int16
    wDefault*: int16

  LPDEVNAMES* = ptr DEVNAMES
  TDEVNAMES* = DEVNAMES
  PDEVNAMES* = ptr DEVNAMES
  DIBSECTION* {.final, pure.} = object
    dsBm*: BITMAP
    dsBmih*: BITMAPINFOHEADER
    dsBitfields*: array[0..2, DWORD]
    dshSection*: HANDLE
    dsOffset*: DWORD

  TDIBSECTION* = DIBSECTION
  PDIBSECTION* = ptr DIBSECTION #
                                #     LARGE_INTEGER = record
                                #        case byte of
                                #          0: (LowPart : DWORD;
                                #              HighPart : LONG);
                                #          1: (QuadPart : LONGLONG);
                                #       end;     ULARGE_INTEGER = record
                                #        case byte of
                                #          0: (LowPart : DWORD;
                                #              HighPart : DWORD);
                                #          1: (QuadPart : LONGLONG);
                                #       end;
                                #
  LARGE_INTEGER* = int64
  ULARGE_INTEGER* = int64
  PLARGE_INTEGER* = ptr LARGE_INTEGER
  TLargeInteger* = Int64
  PULARGE_INTEGER* = ptr ULARGE_INTEGER
  TULargeInteger* = int64
  DISK_GEOMETRY* {.final, pure.} = object
    Cylinders*: LARGE_INTEGER
    MediaType*: MEDIA_TYPE
    TracksPerCylinder*: DWORD
    SectorsPerTrack*: DWORD
    BytesPerSector*: DWORD

  TDISKGEOMETRY* = DISK_GEOMETRY
  PDISKGEOMETRY* = ptr DISK_GEOMETRY
  DISK_PERFORMANCE* {.final, pure.} = object
    BytesRead*: LARGE_INTEGER
    BytesWritten*: LARGE_INTEGER
    ReadTime*: LARGE_INTEGER
    WriteTime*: LARGE_INTEGER
    ReadCount*: DWORD
    WriteCount*: DWORD
    QueueDepth*: DWORD

  TDISKPERFORMANCE* = DISK_PERFORMANCE
  PDISKPERFORMANCE* = ptr DISK_PERFORMANCE
  DLGITEMTEMPLATE* {.final, pure.} = object
    style*: DWORD
    dwExtendedStyle*: DWORD
    x*: int16
    y*: int16
    cx*: int16
    cy*: int16
    id*: int16

  LPDLGITEMTEMPLATE* = ptr DLGITEMTEMPLATE
  TDLGITEMTEMPLATE* = DLGITEMTEMPLATE
  PDLGITEMTEMPLATE* = ptr DLGITEMTEMPLATE
  DLGTEMPLATE* {.final, pure.} = object
    style*: DWORD
    dwExtendedStyle*: DWORD
    cdit*: int16
    x*: int16
    y*: int16
    cx*: int16
    cy*: int16

  LPDLGTEMPLATE* = ptr DLGTEMPLATE
  LPCDLGTEMPLATE* = ptr DLGTEMPLATE
  TDLGTEMPLATE* = DLGTEMPLATE
  PDLGTEMPLATE* = ptr DLGTEMPLATE
  DOC_INFO_1* {.final, pure.} = object
    pDocName*: LPTSTR
    pOutputFile*: LPTSTR
    pDatatype*: LPTSTR

  TDOCINFO1* = DOC_INFO_1
  PDOCINFO1* = ptr DOC_INFO_1
  DOC_INFO_2* {.final, pure.} = object
    pDocName*: LPTSTR
    pOutputFile*: LPTSTR
    pDatatype*: LPTSTR
    dwMode*: DWORD
    JobId*: DWORD

  TDOCINFO2* = DOC_INFO_2
  PDOCINFO2* = ptr DOC_INFO_2
  DOCINFO* {.final, pure.} = object
    cbSize*: int32
    lpszDocName*: LPCTSTR
    lpszOutput*: LPCTSTR
    lpszDatatype*: LPCTSTR
    fwType*: DWORD

  TDOCINFO* = DOCINFO
  TDOCINFOA* = DOCINFO
  PDOCINFO* = ptr DOCINFO
  DRAGLISTINFO* {.final, pure.} = object
    uNotification*: UINT
    hWnd*: HWND
    ptCursor*: POINT

  LPDRAGLISTINFO* = ptr DRAGLISTINFO
  TDRAGLISTINFO* = DRAGLISTINFO
  PDRAGLISTINFO* = ptr DRAGLISTINFO
  DRAWITEMSTRUCT* {.final, pure.} = object
    CtlType*: UINT
    CtlID*: UINT
    itemID*: UINT
    itemAction*: UINT
    itemState*: UINT
    hwndItem*: HWND
    hDC*: HDC
    rcItem*: RECT
    itemData*: ULONG_PTR

  LPDRAWITEMSTRUCT* = ptr DRAWITEMSTRUCT
  TDRAWITEMSTRUCT* = DRAWITEMSTRUCT
  PDRAWITEMSTRUCT* = ptr DRAWITEMSTRUCT
  DRAWTEXTPARAMS* {.final, pure.} = object
    cbSize*: UINT
    iTabLength*: int32
    iLeftMargin*: int32
    iRightMargin*: int32
    uiLengthDrawn*: UINT

  LPDRAWTEXTPARAMS* = ptr DRAWTEXTPARAMS
  TDRAWTEXTPARAMS* = DRAWTEXTPARAMS
  PDRAWTEXTPARAMS* = ptr DRAWTEXTPARAMS
  PARTITION_INFORMATION* {.final, pure.} = object
    PartitionType*: int8
    BootIndicator*: bool
    RecognizedPartition*: bool
    RewritePartition*: bool
    StartingOffset*: LARGE_INTEGER
    PartitionLength*: LARGE_INTEGER
    HiddenSectors*: LARGE_INTEGER

  TPARTITIONINFORMATION* = PARTITION_INFORMATION
  PPARTITIONINFORMATION* = ptr PARTITION_INFORMATION
  DRIVE_LAYOUT_INFORMATION* {.final, pure.} = object
    PartitionCount*: DWORD
    Signature*: DWORD
    PartitionEntry*: array[0..0, PARTITION_INFORMATION]

  TDRIVELAYOUTINFORMATION* = DRIVE_LAYOUT_INFORMATION
  PDRIVELAYOUTINFORMATION* = ptr DRIVE_LAYOUT_INFORMATION
  DRIVER_INFO_1* {.final, pure.} = object
    pName*: LPTSTR

  TDRIVERINFO1* = DRIVER_INFO_1
  PDRIVERINFO1* = ptr DRIVER_INFO_1
  DRIVER_INFO_2* {.final, pure.} = object
    cVersion*: DWORD
    pName*: LPTSTR
    pEnvironment*: LPTSTR
    pDriverPath*: LPTSTR
    pDataFile*: LPTSTR
    pConfigFile*: LPTSTR

  TDRIVERINFO2* = DRIVER_INFO_2
  PDRIVERINFO2* = ptr DRIVER_INFO_2
  DRIVER_INFO_3* {.final, pure.} = object
    cVersion*: DWORD
    pName*: LPTSTR
    pEnvironment*: LPTSTR
    pDriverPath*: LPTSTR
    pDataFile*: LPTSTR
    pConfigFile*: LPTSTR
    pHelpFile*: LPTSTR
    pDependentFiles*: LPTSTR
    pMonitorName*: LPTSTR
    pDefaultDataType*: LPTSTR

  TDRIVERINFO3* = DRIVER_INFO_3
  PDRIVERINFO3* = ptr DRIVER_INFO_3
  EDITSTREAM* {.final, pure.} = object
    dwCookie*: DWORD
    dwError*: DWORD
    pfnCallback*: EDITSTREAMCALLBACK

  Teditstream* = EDITSTREAM
  Peditstream* = ptr EDITSTREAM
  EMR* {.final, pure.} = object
    iType*: DWORD
    nSize*: DWORD

  TEMR* = EMR
  PEMR* = ptr EMR
  EMRANGLEARC* {.final, pure.} = object
    emr*: EMR
    ptlCenter*: POINTL
    nRadius*: DWORD
    eStartAngle*: float32
    eSweepAngle*: float32

  TEMRANGLEARC* = EMRANGLEARC
  PEMRANGLEARC* = ptr EMRANGLEARC
  EMRARC* {.final, pure.} = object
    emr*: EMR
    rclBox*: RECTL
    ptlStart*: POINTL
    ptlEnd*: POINTL

  TEMRARC* = EMRARC
  PEMRARC* = ptr EMRARC
  EMRARCTO* = EMRARC
  TEMRARCTO* = EMRARC
  PEMRARCTO* = ptr EMRARC
  EMRCHORD* = EMRARC
  TEMRCHORD* = EMRARC
  PEMRCHORD* = ptr EMRARC
  EMRPIE* = EMRARC
  TEMRPIE* = EMRARC
  PEMRPIE* = ptr EMRARC
  XFORM* {.final, pure.} = object
    eM11*: float32
    eM12*: float32
    eM21*: float32
    eM22*: float32
    eDx*: float32
    eDy*: float32

  LPXFORM* = ptr XFORM
  TXFORM* = XFORM
  PXFORM* = ptr XFORM
  EMRBITBLT* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    xDest*: LONG
    yDest*: LONG
    cxDest*: LONG
    cyDest*: LONG
    dwRop*: DWORD
    xSrc*: LONG
    ySrc*: LONG
    xformSrc*: XFORM
    crBkColorSrc*: COLORREF
    iUsageSrc*: DWORD
    offBmiSrc*: DWORD
    offBitsSrc*: DWORD
    cbBitsSrc*: DWORD

  TEMRBITBLT* = EMRBITBLT
  PEMRBITBLT* = ptr EMRBITBLT
  LOGBRUSH* {.final, pure.} = object
    lbStyle*: UINT
    lbColor*: COLORREF
    lbHatch*: LONG

  TLOGBRUSH* = LOGBRUSH
  PLOGBRUSH* = ptr LOGBRUSH
  EMRCREATEBRUSHINDIRECT* {.final, pure.} = object
    emr*: EMR
    ihBrush*: DWORD
    lb*: LOGBRUSH

  TEMRCREATEBRUSHINDIRECT* = EMRCREATEBRUSHINDIRECT
  PEMRCREATEBRUSHINDIRECT* = ptr EMRCREATEBRUSHINDIRECT
  LCSCSTYPE* = LONG
  LCSGAMUTMATCH* = LONG
  LOGCOLORSPACE* {.final, pure.} = object
    lcsSignature*: DWORD
    lcsVersion*: DWORD
    lcsSize*: DWORD
    lcsCSType*: LCSCSTYPE
    lcsIntent*: LCSGAMUTMATCH
    lcsEndpoints*: CIEXYZTRIPLE
    lcsGammaRed*: DWORD
    lcsGammaGreen*: DWORD
    lcsGammaBlue*: DWORD
    lcsFilename*: array[0..(MAX_PATH) - 1, TCHAR]

  LPLOGCOLORSPACE* = ptr LOGCOLORSPACE
  TLOGCOLORSPACE* = LOGCOLORSPACE
  TLOGCOLORSPACEA* = LOGCOLORSPACE
  PLOGCOLORSPACE* = ptr LOGCOLORSPACE
  EMRCREATECOLORSPACE* {.final, pure.} = object
    emr*: EMR
    ihCS*: DWORD
    lcs*: LOGCOLORSPACE

  TEMRCREATECOLORSPACE* = EMRCREATECOLORSPACE
  PEMRCREATECOLORSPACE* = ptr EMRCREATECOLORSPACE
  EMRCREATEDIBPATTERNBRUSHPT* {.final, pure.} = object
    emr*: EMR
    ihBrush*: DWORD
    iUsage*: DWORD
    offBmi*: DWORD
    cbBmi*: DWORD
    offBits*: DWORD
    cbBits*: DWORD

  TEMRCREATEDIBPATTERNBRUSHPT* = EMRCREATEDIBPATTERNBRUSHPT
  PEMRCREATEDIBPATTERNBRUSHPT* = EMRCREATEDIBPATTERNBRUSHPT
  EMRCREATEMONOBRUSH* {.final, pure.} = object
    emr*: EMR
    ihBrush*: DWORD
    iUsage*: DWORD
    offBmi*: DWORD
    cbBmi*: DWORD
    offBits*: DWORD
    cbBits*: DWORD

  TEMRCREATEMONOBRUSH* = EMRCREATEMONOBRUSH
  PEMRCREATEMONOBRUSH* = ptr EMRCREATEMONOBRUSH
  PALETTEENTRY* {.final, pure.} = object
    peRed*: int8
    peGreen*: int8
    peBlue*: int8
    peFlags*: int8

  LPPALETTEENTRY* = ptr PALETTEENTRY
  TPALETTEENTRY* = PALETTEENTRY
  PPALETTEENTRY* = ptr PALETTEENTRY
  LOGPALETTE* {.final, pure.} = object
    palVersion*: int16
    palNumEntries*: int16
    palPalEntry*: array[0..0, PALETTEENTRY]

  LPLOGPALETTE* = ptr LOGPALETTE
  NPLOGPALETTE* = ptr LOGPALETTE
  TLOGPALETTE* = LOGPALETTE
  PLOGPALETTE* = ptr LOGPALETTE
  EMRCREATEPALETTE* {.final, pure.} = object
    emr*: EMR
    ihPal*: DWORD
    lgpl*: LOGPALETTE

  TEMRCREATEPALETTE* = EMRCREATEPALETTE
  PEMRCREATEPALETTE* = ptr EMRCREATEPALETTE
  LOGPEN* {.final, pure.} = object
    lopnStyle*: UINT
    lopnWidth*: POINT
    lopnColor*: COLORREF

  TLOGPEN* = LOGPEN
  PLOGPEN* = ptr LOGPEN
  EMRCREATEPEN* {.final, pure.} = object
    emr*: EMR
    ihPen*: DWORD
    lopn*: LOGPEN

  TEMRCREATEPEN* = EMRCREATEPEN
  PEMRCREATEPEN* = ptr EMRCREATEPEN
  EMRELLIPSE* {.final, pure.} = object
    emr*: EMR
    rclBox*: RECTL

  TEMRELLIPSE* = EMRELLIPSE
  PEMRELLIPSE* = ptr EMRELLIPSE
  EMRRECTANGLE* = EMRELLIPSE
  TEMRRECTANGLE* = EMRELLIPSE
  PEMRRECTANGLE* = ptr EMRELLIPSE
  EMREOF* {.final, pure.} = object
    emr*: EMR
    nPalEntries*: DWORD
    offPalEntries*: DWORD
    nSizeLast*: DWORD

  TEMREOF* = EMREOF
  PEMREOF* = ptr EMREOF
  EMREXCLUDECLIPRECT* {.final, pure.} = object
    emr*: EMR
    rclClip*: RECTL

  TEMREXCLUDECLIPRECT* = EMREXCLUDECLIPRECT
  PEMREXCLUDECLIPRECT* = ptr EMREXCLUDECLIPRECT
  EMRINTERSECTCLIPRECT* = EMREXCLUDECLIPRECT
  TEMRINTERSECTCLIPRECT* = EMREXCLUDECLIPRECT
  PEMRINTERSECTCLIPRECT* = ptr EMREXCLUDECLIPRECT
  PANOSE* {.final, pure.} = object
    bFamilyType*: int8
    bSerifStyle*: int8
    bWeight*: int8
    bProportion*: int8
    bContrast*: int8
    bStrokeVariation*: int8
    bArmStyle*: int8
    bLetterform*: int8
    bMidline*: int8
    bXHeight*: int8

  TPANOSE* = PANOSE
  PPANOSE* = ptr PANOSE
  EXTLOGFONT* {.final, pure.} = object
    elfLogFont*: LOGFONT
    elfFullName*: array[0..(LF_FULLFACESIZE) - 1, BCHAR]
    elfStyle*: array[0..(LF_FACESIZE) - 1, BCHAR]
    elfVersion*: DWORD
    elfStyleSize*: DWORD
    elfMatch*: DWORD
    elfReserved*: DWORD
    elfVendorId*: array[0..(ELF_VENDOR_SIZE) - 1, int8]
    elfCulture*: DWORD
    elfPanose*: PANOSE

  TEXTLOGFONT* = EXTLOGFONT
  PEXTLOGFONT* = ptr EXTLOGFONT
  EMREXTCREATEFONTINDIRECTW* {.final, pure.} = object
    emr*: EMR
    ihFont*: DWORD
    elfw*: EXTLOGFONT

  TEMREXTCREATEFONTINDIRECTW* = EMREXTCREATEFONTINDIRECTW
  PEMREXTCREATEFONTINDIRECTW* = ptr EMREXTCREATEFONTINDIRECTW
  EXTLOGPEN* {.final, pure.} = object
    elpPenStyle*: UINT
    elpWidth*: UINT
    elpBrushStyle*: UINT
    elpColor*: COLORREF
    elpHatch*: LONG
    elpNumEntries*: DWORD
    elpStyleEntry*: array[0..0, DWORD]

  TEXTLOGPEN* = EXTLOGPEN
  PEXTLOGPEN* = ptr EXTLOGPEN
  EMREXTCREATEPEN* {.final, pure.} = object
    emr*: EMR
    ihPen*: DWORD
    offBmi*: DWORD
    cbBmi*: DWORD
    offBits*: DWORD
    cbBits*: DWORD
    elp*: EXTLOGPEN

  TEMREXTCREATEPEN* = EMREXTCREATEPEN
  PEMREXTCREATEPEN* = ptr EMREXTCREATEPEN
  EMREXTFLOODFILL* {.final, pure.} = object
    emr*: EMR
    ptlStart*: POINTL
    crColor*: COLORREF
    iMode*: DWORD

  TEMREXTFLOODFILL* = EMREXTFLOODFILL
  PEMREXTFLOODFILL* = ptr EMREXTFLOODFILL
  EMREXTSELECTCLIPRGN* {.final, pure.} = object
    emr*: EMR
    cbRgnData*: DWORD
    iMode*: DWORD
    RgnData*: array[0..0, int8]

  TEMREXTSELECTCLIPRGN* = EMREXTSELECTCLIPRGN
  PEMREXTSELECTCLIPRGN* = ptr EMREXTSELECTCLIPRGN
  EMRTEXT* {.final, pure.} = object
    ptlReference*: POINTL
    nChars*: DWORD
    offString*: DWORD
    fOptions*: DWORD
    rcl*: RECTL
    offDx*: DWORD

  TEMRTEXT* = EMRTEXT
  PEMRTEXT* = ptr EMRTEXT
  EMREXTTEXTOUTA* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    iGraphicsMode*: DWORD
    exScale*: float32
    eyScale*: float32
    emrtext*: EMRTEXT

  TEMREXTTEXTOUTA* = EMREXTTEXTOUTA
  PEMREXTTEXTOUTA* = ptr EMREXTTEXTOUTA
  EMREXTTEXTOUTW* = EMREXTTEXTOUTA
  TEMREXTTEXTOUTW* = EMREXTTEXTOUTA
  PEMREXTTEXTOUTW* = ptr EMREXTTEXTOUTA
  EMRFILLPATH* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL

  TEMRFILLPATH* = EMRFILLPATH
  PEMRFILLPATH* = ptr EMRFILLPATH
  EMRSTROKEANDFILLPATH* = EMRFILLPATH
  TEMRSTROKEANDFILLPATH* = EMRFILLPATH
  PEMRSTROKEANDFILLPATH* = ptr EMRFILLPATH
  EMRSTROKEPATH* = EMRFILLPATH
  TEMRSTROKEPATH* = EMRFILLPATH
  PEMRSTROKEPATH* = ptr EMRFILLPATH
  EMRFILLRGN* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    cbRgnData*: DWORD
    ihBrush*: DWORD
    RgnData*: array[0..0, int8]

  TEMRFILLRGN* = EMRFILLRGN
  PEMRFILLRGN* = ptr EMRFILLRGN
  EMRFORMAT* {.final, pure.} = object
    dSignature*: DWORD
    nVersion*: DWORD
    cbData*: DWORD
    offData*: DWORD

  TEMRFORMAT* = EMRFORMAT
  PEMRFORMAT* = ptr EMRFORMAT

  EMRFRAMERGN* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    cbRgnData*: DWORD
    ihBrush*: DWORD
    szlStroke*: SIZEL
    RgnData*: array[0..0, int8]

  TEMRFRAMERGN* = EMRFRAMERGN
  PEMRFRAMERGN* = ptr EMRFRAMERGN
  EMRGDICOMMENT* {.final, pure.} = object
    emr*: EMR
    cbData*: DWORD
    Data*: array[0..0, int8]

  TEMRGDICOMMENT* = EMRGDICOMMENT
  PEMRGDICOMMENT* = ptr EMRGDICOMMENT
  EMRINVERTRGN* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    cbRgnData*: DWORD
    RgnData*: array[0..0, int8]

  TEMRINVERTRGN* = EMRINVERTRGN
  PEMRINVERTRGN* = ptr EMRINVERTRGN
  EMRPAINTRGN* = EMRINVERTRGN
  TEMRPAINTRGN* = EMRINVERTRGN
  PEMRPAINTRGN* = ptr EMRINVERTRGN
  EMRLINETO* {.final, pure.} = object
    emr*: EMR
    ptl*: POINTL

  TEMRLINETO* = EMRLINETO
  PEMRLINETO* = ptr EMRLINETO
  EMRMOVETOEX* = EMRLINETO
  TEMRMOVETOEX* = EMRLINETO
  PEMRMOVETOEX* = ptr EMRLINETO
  EMRMASKBLT* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    xDest*: LONG
    yDest*: LONG
    cxDest*: LONG
    cyDest*: LONG
    dwRop*: DWORD
    xSrc*: LONG
    ySrc*: LONG
    xformSrc*: XFORM
    crBkColorSrc*: COLORREF
    iUsageSrc*: DWORD
    offBmiSrc*: DWORD
    cbBmiSrc*: DWORD
    offBitsSrc*: DWORD
    cbBitsSrc*: DWORD
    xMask*: LONG
    yMask*: LONG
    iUsageMask*: DWORD
    offBmiMask*: DWORD
    cbBmiMask*: DWORD
    offBitsMask*: DWORD
    cbBitsMask*: DWORD

  TEMRMASKBLT* = EMRMASKBLT
  PEMRMASKBLT* = ptr EMRMASKBLT
  EMRMODIFYWORLDTRANSFORM* {.final, pure.} = object
    emr*: EMR
    xform*: XFORM
    iMode*: DWORD

  TEMRMODIFYWORLDTRANSFORM* = EMRMODIFYWORLDTRANSFORM
  PEMRMODIFYWORLDTRANSFORM* = EMRMODIFYWORLDTRANSFORM
  EMROFFSETCLIPRGN* {.final, pure.} = object
    emr*: EMR
    ptlOffset*: POINTL

  TEMROFFSETCLIPRGN* = EMROFFSETCLIPRGN
  PEMROFFSETCLIPRGN* = ptr EMROFFSETCLIPRGN
  EMRPLGBLT* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    aptlDest*: array[0..2, POINTL]
    xSrc*: LONG
    ySrc*: LONG
    cxSrc*: LONG
    cySrc*: LONG
    xformSrc*: XFORM
    crBkColorSrc*: COLORREF
    iUsageSrc*: DWORD
    offBmiSrc*: DWORD
    cbBmiSrc*: DWORD
    offBitsSrc*: DWORD
    cbBitsSrc*: DWORD
    xMask*: LONG
    yMask*: LONG
    iUsageMask*: DWORD
    offBmiMask*: DWORD
    cbBmiMask*: DWORD
    offBitsMask*: DWORD
    cbBitsMask*: DWORD

  TEMRPLGBLT* = EMRPLGBLT
  PEMRPLGBLT* = ptr EMRPLGBLT
  EMRPOLYDRAW* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    cptl*: DWORD
    aptl*: array[0..0, POINTL]
    abTypes*: array[0..0, int8]

  TEMRPOLYDRAW* = EMRPOLYDRAW
  PEMRPOLYDRAW* = ptr EMRPOLYDRAW
  EMRPOLYDRAW16* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    cpts*: DWORD
    apts*: array[0..0, POINTS]
    abTypes*: array[0..0, int8]

  TEMRPOLYDRAW16* = EMRPOLYDRAW16
  PEMRPOLYDRAW16* = ptr EMRPOLYDRAW16
  EMRPOLYLINE* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    cptl*: DWORD
    aptl*: array[0..0, POINTL]

  TEMRPOLYLINE* = EMRPOLYLINE
  PEMRPOLYLINE* = ptr EMRPOLYLINE
  EMRPOLYBEZIER* = EMRPOLYLINE
  TEMRPOLYBEZIER* = EMRPOLYLINE
  PEMRPOLYBEZIER* = ptr EMRPOLYLINE
  EMRPOLYGON* = EMRPOLYLINE
  TEMRPOLYGON* = EMRPOLYLINE
  PEMRPOLYGON* = ptr EMRPOLYLINE
  EMRPOLYBEZIERTO* = EMRPOLYLINE
  TEMRPOLYBEZIERTO* = EMRPOLYLINE
  PEMRPOLYBEZIERTO* = ptr EMRPOLYLINE
  EMRPOLYLINETO* = EMRPOLYLINE
  TEMRPOLYLINETO* = EMRPOLYLINE
  PEMRPOLYLINETO* = ptr EMRPOLYLINE
  EMRPOLYLINE16* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    cpts*: DWORD
    apts*: array[0..0, POINTL]

  TEMRPOLYLINE16* = EMRPOLYLINE16
  PEMRPOLYLINE16* = ptr EMRPOLYLINE16
  EMRPOLYBEZIER16* = EMRPOLYLINE16
  TEMRPOLYBEZIER16* = EMRPOLYLINE16
  PEMRPOLYBEZIER16* = ptr EMRPOLYLINE16
  EMRPOLYGON16* = EMRPOLYLINE16
  TEMRPOLYGON16* = EMRPOLYLINE16
  PEMRPOLYGON16* = ptr EMRPOLYLINE16
  EMRPOLYBEZIERTO16* = EMRPOLYLINE16
  TEMRPOLYBEZIERTO16* = EMRPOLYLINE16
  PEMRPOLYBEZIERTO16* = ptr EMRPOLYLINE16
  EMRPOLYLINETO16* = EMRPOLYLINE16
  TEMRPOLYLINETO16* = EMRPOLYLINE16
  PEMRPOLYLINETO16* = ptr EMRPOLYLINE16
  EMRPOLYPOLYLINE* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    nPolys*: DWORD
    cptl*: DWORD
    aPolyCounts*: array[0..0, DWORD]
    aptl*: array[0..0, POINTL]

  TEMRPOLYPOLYLINE* = EMRPOLYPOLYLINE
  PEMRPOLYPOLYLINE* = ptr EMRPOLYPOLYLINE
  EMRPOLYPOLYGON* = EMRPOLYPOLYLINE
  TEMRPOLYPOLYGON* = EMRPOLYPOLYLINE
  PEMRPOLYPOLYGON* = ptr EMRPOLYPOLYLINE
  EMRPOLYPOLYLINE16* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    nPolys*: DWORD
    cpts*: DWORD
    aPolyCounts*: array[0..0, DWORD]
    apts*: array[0..0, POINTS]

  TEMRPOLYPOLYLINE16* = EMRPOLYPOLYLINE16
  PEMRPOLYPOLYLINE16* = ptr EMRPOLYPOLYLINE16
  EMRPOLYPOLYGON16* = EMRPOLYPOLYLINE16
  TEMRPOLYPOLYGON16* = EMRPOLYPOLYLINE16
  PEMRPOLYPOLYGON16* = ptr EMRPOLYPOLYLINE16
  EMRPOLYTEXTOUTA* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    iGraphicsMode*: DWORD
    exScale*: float32
    eyScale*: float32
    cStrings*: LONG
    aemrtext*: array[0..0, EMRTEXT]

  TEMRPOLYTEXTOUTA* = EMRPOLYTEXTOUTA
  PEMRPOLYTEXTOUTA* = ptr EMRPOLYTEXTOUTA
  EMRPOLYTEXTOUTW* = EMRPOLYTEXTOUTA
  TEMRPOLYTEXTOUTW* = EMRPOLYTEXTOUTA
  PEMRPOLYTEXTOUTW* = ptr EMRPOLYTEXTOUTA
  EMRRESIZEPALETTE* {.final, pure.} = object
    emr*: EMR
    ihPal*: DWORD
    cEntries*: DWORD

  TEMRRESIZEPALETTE* = EMRRESIZEPALETTE
  PEMRRESIZEPALETTE* = ptr EMRRESIZEPALETTE
  EMRRESTOREDC* {.final, pure.} = object
    emr*: EMR
    iRelative*: LONG

  TEMRRESTOREDC* = EMRRESTOREDC
  PEMRRESTOREDC* = ptr EMRRESTOREDC
  EMRROUNDRECT* {.final, pure.} = object
    emr*: EMR
    rclBox*: RECTL
    szlCorner*: SIZEL

  TEMRROUNDRECT* = EMRROUNDRECT
  PEMRROUNDRECT* = ptr EMRROUNDRECT
  EMRSCALEVIEWPORTEXTEX* {.final, pure.} = object
    emr*: EMR
    xNum*: LONG
    xDenom*: LONG
    yNum*: LONG
    yDenom*: LONG

  TEMRSCALEVIEWPORTEXTEX* = EMRSCALEVIEWPORTEXTEX
  PEMRSCALEVIEWPORTEXTEX* = ptr EMRSCALEVIEWPORTEXTEX
  EMRSCALEWINDOWEXTEX* = EMRSCALEVIEWPORTEXTEX
  TEMRSCALEWINDOWEXTEX* = EMRSCALEVIEWPORTEXTEX
  PEMRSCALEWINDOWEXTEX* = ptr EMRSCALEVIEWPORTEXTEX
  EMRSELECTCOLORSPACE* {.final, pure.} = object
    emr*: EMR

    ihCS*: DWORD

  TEMRSELECTCOLORSPACE* = EMRSELECTCOLORSPACE
  PEMRSELECTCOLORSPACE* = ptr EMRSELECTCOLORSPACE
  EMRDELETECOLORSPACE* = EMRSELECTCOLORSPACE
  TEMRDELETECOLORSPACE* = EMRSELECTCOLORSPACE
  PEMRDELETECOLORSPACE* = ptr EMRSELECTCOLORSPACE
  EMRSELECTOBJECT* {.final, pure.} = object
    emr*: EMR
    ihObject*: DWORD

  TEMRSELECTOBJECT* = EMRSELECTOBJECT
  PEMRSELECTOBJECT* = ptr EMRSELECTOBJECT
  EMRDELETEOBJECT* = EMRSELECTOBJECT
  TEMRDELETEOBJECT* = EMRSELECTOBJECT
  PEMRDELETEOBJECT* = ptr EMRSELECTOBJECT
  EMRSELECTPALETTE* {.final, pure.} = object
    emr*: EMR
    ihPal*: DWORD

  TEMRSELECTPALETTE* = EMRSELECTPALETTE
  PEMRSELECTPALETTE* = ptr EMRSELECTPALETTE
  EMRSETARCDIRECTION* {.final, pure.} = object
    emr*: EMR
    iArcDirection*: DWORD

  TEMRSETARCDIRECTION* = EMRSETARCDIRECTION
  PEMRSETARCDIRECTION* = ptr EMRSETARCDIRECTION
  EMRSETBKCOLOR* {.final, pure.} = object
    emr*: EMR
    crColor*: COLORREF

  TEMRSETBKCOLOR* = EMRSETBKCOLOR
  PEMRSETBKCOLOR* = ptr EMRSETBKCOLOR
  EMRSETTEXTCOLOR* = EMRSETBKCOLOR
  TEMRSETTEXTCOLOR* = EMRSETBKCOLOR
  PEMRSETTEXTCOLOR* = ptr EMRSETBKCOLOR
  EMRSETCOLORADJUSTMENT* {.final, pure.} = object
    emr*: EMR
    ColorAdjustment*: COLORADJUSTMENT

  TEMRSETCOLORADJUSTMENT* = EMRSETCOLORADJUSTMENT
  PEMRSETCOLORADJUSTMENT* = ptr EMRSETCOLORADJUSTMENT
  EMRSETDIBITSTODEVICE* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    xDest*: LONG
    yDest*: LONG
    xSrc*: LONG
    ySrc*: LONG
    cxSrc*: LONG
    cySrc*: LONG
    offBmiSrc*: DWORD
    cbBmiSrc*: DWORD
    offBitsSrc*: DWORD
    cbBitsSrc*: DWORD
    iUsageSrc*: DWORD
    iStartScan*: DWORD
    cScans*: DWORD

  TEMRSETDIBITSTODEVICE* = EMRSETDIBITSTODEVICE
  PEMRSETDIBITSTODEVICE* = ptr EMRSETDIBITSTODEVICE
  EMRSETMAPPERFLAGS* {.final, pure.} = object
    emr*: EMR
    dwFlags*: DWORD

  TEMRSETMAPPERFLAGS* = EMRSETMAPPERFLAGS
  PEMRSETMAPPERFLAGS* = ptr EMRSETMAPPERFLAGS
  EMRSETMITERLIMIT* {.final, pure.} = object
    emr*: EMR
    eMiterLimit*: float32

  TEMRSETMITERLIMIT* = EMRSETMITERLIMIT
  PEMRSETMITERLIMIT* = ptr EMRSETMITERLIMIT
  EMRSETPALETTEENTRIES* {.final, pure.} = object
    emr*: EMR
    ihPal*: DWORD
    iStart*: DWORD
    cEntries*: DWORD
    aPalEntries*: array[0..0, PALETTEENTRY]

  TEMRSETPALETTEENTRIES* = EMRSETPALETTEENTRIES
  PEMRSETPALETTEENTRIES* = ptr EMRSETPALETTEENTRIES
  EMRSETPIXELV* {.final, pure.} = object
    emr*: EMR
    ptlPixel*: POINTL
    crColor*: COLORREF

  TEMRSETPIXELV* = EMRSETPIXELV
  PEMRSETPIXELV* = ptr EMRSETPIXELV
  EMRSETVIEWPORTEXTEX* {.final, pure.} = object
    emr*: EMR
    szlExtent*: SIZEL

  TEMRSETVIEWPORTEXTEX* = EMRSETVIEWPORTEXTEX
  PEMRSETVIEWPORTEXTEX* = ptr EMRSETVIEWPORTEXTEX
  EMRSETWINDOWEXTEX* = EMRSETVIEWPORTEXTEX
  TEMRSETWINDOWEXTEX* = EMRSETVIEWPORTEXTEX
  PEMRSETWINDOWEXTEX* = ptr EMRSETVIEWPORTEXTEX
  EMRSETVIEWPORTORGEX* {.final, pure.} = object
    emr*: EMR
    ptlOrigin*: POINTL

  TEMRSETVIEWPORTORGEX* = EMRSETVIEWPORTORGEX
  PEMRSETVIEWPORTORGEX* = ptr EMRSETVIEWPORTORGEX
  EMRSETWINDOWORGEX* = EMRSETVIEWPORTORGEX
  TEMRSETWINDOWORGEX* = EMRSETVIEWPORTORGEX
  PEMRSETWINDOWORGEX* = ptr EMRSETVIEWPORTORGEX
  EMRSETBRUSHORGEX* = EMRSETVIEWPORTORGEX
  TEMRSETBRUSHORGEX* = EMRSETVIEWPORTORGEX
  PEMRSETBRUSHORGEX* = ptr EMRSETVIEWPORTORGEX
  EMRSETWORLDTRANSFORM* {.final, pure.} = object
    emr*: EMR
    xform*: XFORM

  TEMRSETWORLDTRANSFORM* = EMRSETWORLDTRANSFORM
  PEMRSETWORLDTRANSFORM* = ptr EMRSETWORLDTRANSFORM
  EMRSTRETCHBLT* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    xDest*: LONG
    yDest*: LONG
    cxDest*: LONG
    cyDest*: LONG
    dwRop*: DWORD
    xSrc*: LONG
    ySrc*: LONG
    xformSrc*: XFORM
    crBkColorSrc*: COLORREF
    iUsageSrc*: DWORD
    offBmiSrc*: DWORD
    cbBmiSrc*: DWORD
    offBitsSrc*: DWORD
    cbBitsSrc*: DWORD
    cxSrc*: LONG
    cySrc*: LONG

  TEMRSTRETCHBLT* = EMRSTRETCHBLT
  PEMRSTRETCHBLT* = ptr EMRSTRETCHBLT
  EMRSTRETCHDIBITS* {.final, pure.} = object
    emr*: EMR
    rclBounds*: RECTL
    xDest*: LONG
    yDest*: LONG
    xSrc*: LONG
    ySrc*: LONG
    cxSrc*: LONG
    cySrc*: LONG
    offBmiSrc*: DWORD
    cbBmiSrc*: DWORD
    offBitsSrc*: DWORD
    cbBitsSrc*: DWORD
    iUsageSrc*: DWORD
    dwRop*: DWORD
    cxDest*: LONG
    cyDest*: LONG

  TEMRSTRETCHDIBITS* = EMRSTRETCHDIBITS
  PEMRSTRETCHDIBITS* = ptr EMRSTRETCHDIBITS
  EMRABORTPATH* {.final, pure.} = object
    emr*: EMR

  TEMRABORTPATH* = EMRABORTPATH
  PEMRABORTPATH* = ptr EMRABORTPATH
  TABORTPATH* = EMRABORTPATH
  EMRBEGINPATH* = EMRABORTPATH
  TEMRBEGINPATH* = EMRABORTPATH
  PEMRBEGINPATH* = ptr EMRABORTPATH
  EMRENDPATH* = EMRABORTPATH
  TEMRENDPATH* = EMRABORTPATH
  PEMRENDPATH* = ptr EMRABORTPATH
  EMRCLOSEFIGURE* = EMRABORTPATH
  TEMRCLOSEFIGURE* = EMRABORTPATH
  PEMRCLOSEFIGURE* = ptr EMRABORTPATH
  EMRFLATTENPATH* = EMRABORTPATH
  TEMRFLATTENPATH* = EMRABORTPATH
  PEMRFLATTENPATH* = ptr EMRABORTPATH
  EMRWIDENPATH* = EMRABORTPATH
  TEMRWIDENPATH* = EMRABORTPATH
  PEMRWIDENPATH* = ptr EMRABORTPATH
  EMRSETMETARGN* = EMRABORTPATH
  TEMRSETMETARGN* = EMRABORTPATH
  PEMRSETMETARGN* = ptr EMRABORTPATH
  EMRSAVEDC* = EMRABORTPATH
  TEMRSAVEDC* = EMRABORTPATH
  PEMRSAVEDC* = ptr EMRABORTPATH
  EMRREALIZEPALETTE* = EMRABORTPATH
  TEMRREALIZEPALETTE* = EMRABORTPATH
  PEMRREALIZEPALETTE* = ptr EMRABORTPATH
  EMRSELECTCLIPPATH* {.final, pure.} = object
    emr*: EMR
    iMode*: DWORD

  TEMRSELECTCLIPPATH* = EMRSELECTCLIPPATH
  PEMRSELECTCLIPPATH* = ptr EMRSELECTCLIPPATH
  EMRSETBKMODE* = EMRSELECTCLIPPATH
  TEMRSETBKMODE* = EMRSELECTCLIPPATH
  PEMRSETBKMODE* = ptr EMRSELECTCLIPPATH
  EMRSETMAPMODE* = EMRSELECTCLIPPATH
  TEMRSETMAPMODE* = EMRSELECTCLIPPATH
  PEMRSETMAPMODE* = ptr EMRSELECTCLIPPATH
  EMRSETPOLYFILLMODE* = EMRSELECTCLIPPATH
  TEMRSETPOLYFILLMODE* = EMRSELECTCLIPPATH
  PEMRSETPOLYFILLMODE* = ptr EMRSELECTCLIPPATH
  EMRSETROP2* = EMRSELECTCLIPPATH
  TEMRSETROP2* = EMRSELECTCLIPPATH
  PEMRSETROP2* = ptr EMRSELECTCLIPPATH
  EMRSETSTRETCHBLTMODE* = EMRSELECTCLIPPATH
  TEMRSETSTRETCHBLTMODE* = EMRSELECTCLIPPATH
  PEMRSETSTRETCHBLTMODE* = ptr EMRSELECTCLIPPATH
  EMRSETTEXTALIGN* = EMRSELECTCLIPPATH
  TEMRSETTEXTALIGN* = EMRSELECTCLIPPATH
  PEMRSETTEXTALIGN* = ptr EMRSELECTCLIPPATH
  EMRENABLEICM* = EMRSELECTCLIPPATH
  TEMRENABLEICM* = EMRSELECTCLIPPATH
  PEMRENABLEICM* = ptr EMRSELECTCLIPPATH
  NMHDR* {.final, pure.} = object
    hwndFrom*: HWND
    idFrom*: UINT
    code*: UINT

  TNMHDR* = NMHDR
  PNMHDR* = ptr NMHDR
  TENCORRECTTEXT* {.final, pure.} = object
    nmhdr*: NMHDR
    chrg*: CHARRANGE
    seltyp*: int16

  Pencorrecttext* = ptr TENCORRECTTEXT
  TENDROPFILES* {.final, pure.} = object
    nmhdr*: NMHDR
    hDrop*: HANDLE
    cp*: LONG
    fProtected*: WINBOOL

  Pendropfiles* = ptr TENDROPFILES
  TENSAVECLIPBOARD* {.final, pure.} = object
    nmhdr*: NMHDR
    cObjectCount*: LONG
    cch*: LONG

  PENSAVECLIPBOARD* = ptr TENSAVECLIPBOARD
  TENOLEOPFAILED* {.final, pure.} = object
    nmhdr*: NMHDR
    iob*: LONG
    lOper*: LONG
    hr*: HRESULT

  PENOLEOPFAILED* = ptr TENOLEOPFAILED
  TENHMETAHEADER* {.final, pure.} = object
    iType*: DWORD
    nSize*: DWORD
    rclBounds*: RECTL
    rclFrame*: RECTL
    dSignature*: DWORD
    nVersion*: DWORD
    nBytes*: DWORD
    nRecords*: DWORD
    nHandles*: int16
    sReserved*: int16
    nDescription*: DWORD
    offDescription*: DWORD
    nPalEntries*: DWORD
    szlDevice*: SIZEL
    szlMillimeters*: SIZEL

  LPENHMETAHEADER* = ptr TENHMETAHEADER
  PENHMETAHEADER* = ptr TENHMETAHEADER
  TENHMETARECORD* {.final, pure.} = object
    iType*: DWORD
    nSize*: DWORD
    dParm*: array[0..0, DWORD]

  LPENHMETARECORD* = ptr TENHMETARECORD
  PENHMETARECORD* = ptr TENHMETARECORD
  TENPROTECTED* {.final, pure.} = object
    nmhdr*: NMHDR
    msg*: UINT
    wParam*: WPARAM
    lParam*: LPARAM
    chrg*: CHARRANGE

  Penprotected* = ptr TENPROTECTED
  SERVICE_STATUS* {.final, pure.} = object
    dwServiceType*: DWORD
    dwCurrentState*: DWORD
    dwControlsAccepted*: DWORD
    dwWin32ExitCode*: DWORD
    dwServiceSpecificExitCode*: DWORD
    dwCheckPoint*: DWORD
    dwWaitHint*: DWORD

  LPSERVICE_STATUS* = ptr SERVICE_STATUS
  TSERVICESTATUS* = SERVICE_STATUS
  PSERVICESTATUS* = ptr SERVICE_STATUS
  ENUM_SERVICE_STATUS* {.final, pure.} = object
    lpServiceName*: LPTSTR
    lpDisplayName*: LPTSTR
    ServiceStatus*: SERVICE_STATUS

  LPENUM_SERVICE_STATUS* = ptr ENUM_SERVICE_STATUS
  TENUMSERVICESTATUS* = ENUM_SERVICE_STATUS
  PENUMSERVICESTATUS* = ptr ENUM_SERVICE_STATUS
  ENUMLOGFONT* {.final, pure.} = object
    elfLogFont*: LOGFONT
    elfFullName*: array[0..(LF_FULLFACESIZE) - 1, BCHAR]
    elfStyle*: array[0..(LF_FACESIZE) - 1, BCHAR]

  TENUMLOGFONT* = ENUMLOGFONT
  PENUMLOGFONT* = ptr ENUMLOGFONT
  ENUMLOGFONTEX* {.final, pure.} = object
    elfLogFont*: LOGFONT
    elfFullName*: array[0..(LF_FULLFACESIZE) - 1, BCHAR]
    elfStyle*: array[0..(LF_FACESIZE) - 1, BCHAR]
    elfScript*: array[0..(LF_FACESIZE) - 1, BCHAR]

  TENUMLOGFONTEX* = ENUMLOGFONTEX
  PENUMLOGFONTEX* = ptr ENUMLOGFONTEX

  EVENTLOGRECORD* {.final, pure.} = object
    Length*: DWORD
    Reserved*: DWORD
    RecordNumber*: DWORD
    TimeGenerated*: DWORD
    TimeWritten*: DWORD
    EventID*: DWORD
    EventType*: int16
    NumStrings*: int16
    EventCategory*: int16
    ReservedFlags*: int16
    ClosingRecordNumber*: DWORD
    StringOffset*: DWORD
    UserSidLength*: DWORD
    UserSidOffset*: DWORD
    DataLength*: DWORD
    DataOffset*: DWORD

  TEVENTLOGRECORD* = EVENTLOGRECORD
  PEVENTLOGRECORD* = ptr EVENTLOGRECORD
  EVENTMSG* {.final, pure.} = object
    message*: UINT
    paramL*: UINT
    paramH*: UINT
    time*: DWORD
    hwnd*: HWND

  TEVENTMSG* = EVENTMSG
  PEVENTMSG* = ptr EVENTMSG
  EXCEPTION_POINTERS* {.final, pure.} = object
    ExceptionRecord*: PEXCEPTION_RECORD
    ContextRecord*: PCONTEXT

  LPEXCEPTION_POINTERS* = ptr EXCEPTION_POINTERS
  PEXCEPTION_POINTERS* = ptr EXCEPTION_POINTERS
  TEXCEPTIONPOINTERS* = EXCEPTION_POINTERS
  EXT_BUTTON* {.final, pure.} = object
    idCommand*: int16
    idsHelp*: int16
    fsStyle*: int16

  LPEXT_BUTTON* = ptr EXT_BUTTON
  TEXTBUTTON* = EXT_BUTTON
  PEXTBUTTON* = ptr EXT_BUTTON
  FILTERKEYS* {.final, pure.} = object
    cbSize*: UINT
    dwFlags*: DWORD
    iWaitMSec*: DWORD
    iDelayMSec*: DWORD
    iRepeatMSec*: DWORD
    iBounceMSec*: DWORD

  TFILTERKEYS* = FILTERKEYS
  PFILTERKEYS* = ptr FILTERKEYS
  FIND_NAME_BUFFER* {.final, pure.} = object
    len*: UCHAR
    access_control*: UCHAR
    frame_control*: UCHAR
    destination_addr*: array[0..5, UCHAR]
    source_addr*: array[0..5, UCHAR]
    routing_info*: array[0..17, UCHAR]

  TFINDNAMEBUFFER* = FIND_NAME_BUFFER
  PFINDNAMEBUFFER* = ptr FIND_NAME_BUFFER
  FIND_NAME_HEADER* {.final, pure.} = object
    node_count*: int16
    reserved*: UCHAR
    unique_group*: UCHAR

  TFINDNAMEHEADER* = FIND_NAME_HEADER
  PFINDNAMEHEADER* = ptr FIND_NAME_HEADER
  FINDREPLACE* {.final, pure.} = object
    lStructSize*: DWORD
    hwndOwner*: HWND
    hInstance*: HINST
    Flags*: DWORD
    lpstrFindWhat*: LPTSTR
    lpstrReplaceWith*: LPTSTR
    wFindWhatLen*: int16
    wReplaceWithLen*: int16
    lCustData*: LPARAM
    lpfnHook*: LPFRHOOKPROC
    lpTemplateName*: LPCTSTR

  LPFINDREPLACE* = ptr FINDREPLACE
  TFINDREPLACE* = FINDREPLACE
  PFINDREPLACE* = ptr FINDREPLACE
  #FINDTEXT = record conflicts with FindText function
  TFINDTEXT* {.final, pure.} = object
    chrg*: CHARRANGE
    lpstrText*: LPSTR

  Pfindtext* = ptr TFINDTEXT
  FINDTEXTEX* {.final, pure.} = object
    chrg*: CHARRANGE
    lpstrText*: LPSTR
    chrgText*: CHARRANGE

  Tfindtextex* = FINDTEXTEX
  Pfindtextex* = ptr FINDTEXTEX
  FMS_GETDRIVEINFO* {.final, pure.} = object
    dwTotalSpace*: DWORD
    dwFreeSpace*: DWORD
    szPath*: array[0..259, TCHAR]
    szVolume*: array[0..13, TCHAR]
    szShare*: array[0..127, TCHAR]

  TFMSGETDRIVEINFO* = FMS_GETDRIVEINFO
  PFMSGETDRIVEINFO* = ptr FMS_GETDRIVEINFO
  FMS_GETFILESEL* {.final, pure.} = object
    ftTime*: FILETIME
    dwSize*: DWORD
    bAttr*: int8
    szName*: array[0..259, TCHAR]

  TFMSGETFILESEL* = FMS_GETFILESEL
  PFMSGETFILESEL* = ptr FMS_GETFILESEL
  FMS_LOAD* {.final, pure.} = object
    dwSize*: DWORD
    szMenuName*: array[0..(MENU_TEXT_LEN) - 1, TCHAR]
    hMenu*: HMENU
    wMenuDelta*: UINT

  TFMSLOAD* = FMS_LOAD
  PFMSLOAD* = ptr FMS_LOAD
  FMS_TOOLBARLOAD* {.final, pure.} = object
    dwSize*: DWORD
    lpButtons*: LPEXT_BUTTON
    cButtons*: int16
    cBitmaps*: int16
    idBitmap*: int16
    hBitmap*: HBITMAP

  TFMSTOOLBARLOAD* = FMS_TOOLBARLOAD
  PFMSTOOLBARLOAD* = ptr FMS_TOOLBARLOAD
  FOCUS_EVENT_RECORD* {.final, pure.} = object
    bSetFocus*: WINBOOL

  TFOCUSEVENTRECORD* = FOCUS_EVENT_RECORD
  PFOCUSEVENTRECORD* = ptr FOCUS_EVENT_RECORD
  FORM_INFO_1* {.final, pure.} = object
    Flags*: DWORD
    pName*: LPTSTR
    Size*: SIZEL
    ImageableArea*: RECTL

  TFORMINFO1* = FORM_INFO_1
  PFORMINFO1* = ptr FORM_INFO_1
  FORMAT_PARAMETERS* {.final, pure.} = object
    MediaType*: MEDIA_TYPE
    StartCylinderNumber*: DWORD
    EndCylinderNumber*: DWORD
    StartHeadNumber*: DWORD
    EndHeadNumber*: DWORD

  TFORMATPARAMETERS* = FORMAT_PARAMETERS
  PFORMATPARAMETERS* = ptr FORMAT_PARAMETERS
  FORMATRANGE* {.final, pure.} = object
    hdc*: HDC
    hdcTarget*: HDC
    rc*: RECT
    rcPage*: RECT
    chrg*: CHARRANGE

  Tformatrange* = FORMATRANGE
  Pformatrange* = ptr FORMATRANGE
  GCP_RESULTS* {.final, pure.} = object
    lStructSize*: DWORD
    lpOutString*: LPTSTR
    lpOrder*: ptr UINT
    lpDx*: ptr WINT
    lpCaretPos*: ptr WINT
    lpClass*: LPTSTR
    lpGlyphs*: ptr UINT
    nGlyphs*: UINT
    nMaxFit*: UINT

  LPGCP_RESULTS* = ptr GCP_RESULTS
  TGCPRESULTS* = GCP_RESULTS
  PGCPRESULTS* = ptr GCP_RESULTS
  GENERIC_MAPPING* {.final, pure.} = object
    GenericRead*: ACCESS_MASK
    GenericWrite*: ACCESS_MASK
    GenericExecute*: ACCESS_MASK
    GenericAll*: ACCESS_MASK

  PGENERIC_MAPPING* = ptr GENERIC_MAPPING
  TGENERICMAPPING* = GENERIC_MAPPING
  GLYPHMETRICS* {.final, pure.} = object
    gmBlackBoxX*: UINT
    gmBlackBoxY*: UINT
    gmptGlyphOrigin*: POINT
    gmCellIncX*: SHORT
    gmCellIncY*: SHORT

  LPGLYPHMETRICS* = ptr GLYPHMETRICS
  TGLYPHMETRICS* = GLYPHMETRICS
  PGLYPHMETRICS* = ptr GLYPHMETRICS
  HANDLETABLE* {.final, pure.} = object
    objectHandle*: array[0..0, HGDIOBJ]

  THANDLETABLE* = HANDLETABLE
  LPHANDLETABLE* = ptr HANDLETABLE
  HD_HITTESTINFO* {.final, pure.} = object
    pt*: POINT
    flags*: UINT
    iItem*: int32

  THDHITTESTINFO* = HD_HITTESTINFO
  PHDHITTESTINFO* = ptr HD_HITTESTINFO
  HD_ITEM* {.final, pure.} = object
    mask*: UINT
    cxy*: int32
    pszText*: LPTSTR
    hbm*: HBITMAP
    cchTextMax*: int32
    fmt*: int32
    lParam*: LPARAM

  THDITEM* = HD_ITEM
  PHDITEM* = ptr HD_ITEM
  WINDOWPOS* {.final, pure.} = object
    hwnd*: HWND
    hwndInsertAfter*: HWND
    x*: int32
    y*: int32
    cx*: int32
    cy*: int32
    flags*: UINT

  LPWINDOWPOS* = ptr WINDOWPOS
  TWINDOWPOS* = WINDOWPOS
  PWINDOWPOS* = ptr WINDOWPOS
  HD_LAYOUT* {.final, pure.} = object
    prc*: ptr RECT
    pwpos*: ptr WINDOWPOS

  THDLAYOUT* = HD_LAYOUT
  PHDLAYOUT* = ptr HD_LAYOUT
  HD_NOTIFY* {.final, pure.} = object
    hdr*: NMHDR
    iItem*: int32
    iButton*: int32
    pitem*: ptr HD_ITEM

  THDNOTIFY* = HD_NOTIFY
  PHDNOTIFY* = ptr HD_NOTIFY
  HELPINFO* {.final, pure.} = object
    cbSize*: UINT
    iContextType*: int32
    iCtrlId*: int32
    hItemHandle*: HANDLE
    dwContextId*: DWORD
    MousePos*: POINT

  LPHELPINFO* = ptr HELPINFO
  THELPINFO* = HELPINFO
  PHELPINFO* = ptr HELPINFO
  HELPWININFO* {.final, pure.} = object
    wStructSize*: int32
    x*: int32
    y*: int32
    dx*: int32
    dy*: int32
    wMax*: int32
    rgchMember*: array[0..1, TCHAR]

  THELPWININFO* = HELPWININFO
  PHELPWININFO* = ptr HELPWININFO
  HIGHCONTRAST* {.final, pure.} = object
    cbSize*: UINT
    dwFlags*: DWORD
    lpszDefaultScheme*: LPTSTR

  LPHIGHCONTRAST* = ptr HIGHCONTRAST
  THIGHCONTRAST* = HIGHCONTRAST
  PHIGHCONTRAST* = ptr HIGHCONTRAST
  HSZPAIR* {.final, pure.} = object
    hszSvc*: HSZ
    hszTopic*: HSZ

  THSZPAIR* = HSZPAIR
  PHSZPAIR* = ptr HSZPAIR
  ICONINFO* {.final, pure.} = object
    fIcon*: WINBOOL
    xHotspot*: DWORD
    yHotspot*: DWORD
    hbmMask*: HBITMAP
    hbmColor*: HBITMAP

  TICONINFO* = ICONINFO
  PICONINFO* = ptr ICONINFO
  ICONMETRICS* {.final, pure.} = object
    cbSize*: UINT
    iHorzSpacing*: int32
    iVertSpacing*: int32
    iTitleWrap*: int32
    lfFont*: LOGFONT

  LPICONMETRICS* = ptr ICONMETRICS
  TICONMETRICS* = ICONMETRICS
  PICONMETRICS* = ptr ICONMETRICS
  IMAGEINFO* {.final, pure.} = object
    hbmImage*: HBITMAP
    hbmMask*: HBITMAP
    Unused1*: int32
    Unused2*: int32
    rcImage*: RECT

  TIMAGEINFO* = IMAGEINFO
  PIMAGEINFO* = ptr IMAGEINFO
  KEY_EVENT_RECORD* {.final, pure.} = object
    bKeyDown*: WINBOOL
    wRepeatCount*: int16
    wVirtualKeyCode*: int16
    wVirtualScanCode*: int16
    UnicodeChar*: WCHAR
    dwControlKeyState*: DWORD # other union part: AsciiChar: CHAR

  TKEYEVENTRECORD* = KEY_EVENT_RECORD
  PKEYEVENTRECORD* = ptr KEY_EVENT_RECORD
  MOUSE_EVENT_RECORD* {.final, pure.} = object
    dwMousePosition*: COORD
    dwButtonState*: DWORD
    dwControlKeyState*: DWORD
    dwEventFlags*: DWORD

  TMOUSEEVENTRECORD* = MOUSE_EVENT_RECORD
  PMOUSEEVENTRECORD* = ptr MOUSE_EVENT_RECORD
  WINDOW_BUFFER_SIZE_RECORD* {.final, pure.} = object
    dwSize*: COORD

  TWINDOWBUFFERSIZERECORD* = WINDOW_BUFFER_SIZE_RECORD
  PWINDOWBUFFERSIZERECORD* = ptr WINDOW_BUFFER_SIZE_RECORD
  MENU_EVENT_RECORD* {.final, pure.} = object
    dwCommandId*: UINT

  PMENU_EVENT_RECORD* = ptr MENU_EVENT_RECORD
  TMENUEVENTRECORD* = MENU_EVENT_RECORD
  INPUT_RECORD* {.final, pure.} = object
    EventType*: int16
    Reserved*: int16
    event*: array[0..5, DWORD]

  PINPUT_RECORD* = ptr INPUT_RECORD
  TINPUTRECORD* = INPUT_RECORD
  SYSTEMTIME* {.final, pure.} = object
    wYear*: int16
    wMonth*: int16
    wDayOfWeek*: int16
    wDay*: int16
    wHour*: int16
    wMinute*: int16
    wSecond*: int16
    wMilliseconds*: int16

  LPSYSTEMTIME* = ptr SYSTEMTIME
  TSYSTEMTIME* = SYSTEMTIME
  PSYSTEMTIME* = ptr SYSTEMTIME
  JOB_INFO_1* {.final, pure.} = object
    JobId*: DWORD
    pPrinterName*: LPTSTR
    pMachineName*: LPTSTR
    pUserName*: LPTSTR
    pDocument*: LPTSTR
    pDatatype*: LPTSTR
    pStatus*: LPTSTR
    Status*: DWORD
    Priority*: DWORD
    Position*: DWORD
    TotalPages*: DWORD
    PagesPrinted*: DWORD
    Submitted*: SYSTEMTIME

  TJOBINFO1* = JOB_INFO_1
  PJOBINFO1* = ptr JOB_INFO_1
  SID_IDENTIFIER_AUTHORITY* {.final, pure.} = object
    Value*: array[0..5, int8]

  LPSID_IDENTIFIER_AUTHORITY* = ptr SID_IDENTIFIER_AUTHORITY
  PSID_IDENTIFIER_AUTHORITY* = ptr SID_IDENTIFIER_AUTHORITY
  TSIDIDENTIFIERAUTHORITY* = SID_IDENTIFIER_AUTHORITY
  SID* {.final, pure.} = object
    Revision*: int8
    SubAuthorityCount*: int8
    IdentifierAuthority*: SID_IDENTIFIER_AUTHORITY
    SubAuthority*: array[0..(ANYSIZE_ARRAY) - 1, DWORD]

  TSID* = SID
  PSID* = ptr SID
  SECURITY_DESCRIPTOR_CONTROL* = int16
  PSECURITY_DESCRIPTOR_CONTROL* = ptr SECURITY_DESCRIPTOR_CONTROL
  TSECURITYDESCRIPTORCONTROL* = SECURITY_DESCRIPTOR_CONTROL
  SECURITY_DESCRIPTOR* {.final, pure.} = object
    Revision*: int8
    Sbz1*: int8
    Control*: SECURITY_DESCRIPTOR_CONTROL
    Owner*: PSID
    Group*: PSID
    Sacl*: PACL
    Dacl*: PACL

  PSECURITY_DESCRIPTOR* = ptr SECURITY_DESCRIPTOR
  TSECURITYDESCRIPTOR* = SECURITY_DESCRIPTOR
  JOB_INFO_2* {.final, pure.} = object
    JobId*: DWORD
    pPrinterName*: LPTSTR
    pMachineName*: LPTSTR
    pUserName*: LPTSTR
    pDocument*: LPTSTR
    pNotifyName*: LPTSTR
    pDatatype*: LPTSTR
    pPrintProcessor*: LPTSTR
    pParameters*: LPTSTR
    pDriverName*: LPTSTR
    pDevMode*: LPDEVMODE
    pStatus*: LPTSTR
    pSecurityDescriptor*: PSECURITY_DESCRIPTOR
    Status*: DWORD
    Priority*: DWORD
    Position*: DWORD
    StartTime*: DWORD
    UntilTime*: DWORD
    TotalPages*: DWORD
    Size*: DWORD
    Submitted*: SYSTEMTIME
    Time*: DWORD
    PagesPrinted*: DWORD

  TJOBINFO2* = JOB_INFO_2
  PJOBINFO2* = ptr JOB_INFO_2
  KERNINGPAIR* {.final, pure.} = object
    wFirst*: int16
    wSecond*: int16
    iKernAmount*: int32

  LPKERNINGPAIR* = ptr KERNINGPAIR
  TKERNINGPAIR* = KERNINGPAIR
  PKERNINGPAIR* = ptr KERNINGPAIR
  LANA_ENUM* {.final, pure.} = object
    len*: UCHAR
    lana*: array[0..(MAX_LANA) - 1, UCHAR]

  TLANAENUM* = LANA_ENUM
  PLANAENUM* = ptr LANA_ENUM
  LDT_ENTRY* {.final, pure.} = object
    LimitLow*: int16
    BaseLow*: int16
    BaseMid*: int8
    Flags1*: int8
    Flags2*: int8
    BaseHi*: int8

  LPLDT_ENTRY* = ptr LDT_ENTRY
  PLDT_ENTRY* = ptr LDT_ENTRY
  TLDTENTRY* = LDT_ENTRY

const
  bm_LDT_ENTRY_BaseMid* = 0x000000FF
  bp_LDT_ENTRY_BaseMid* = 0'i32
  bm_LDT_ENTRY_Type* = 0x00001F00
  bp_LDT_ENTRY_Type* = 8'i32
  bm_LDT_ENTRY_Dpl* = 0x00006000
  bp_LDT_ENTRY_Dpl* = 13'i32
  bm_LDT_ENTRY_Pres* = 0x00008000
  bp_LDT_ENTRY_Pres* = 15'i32
  bm_LDT_ENTRY_LimitHi* = 0x000F0000
  bp_LDT_ENTRY_LimitHi* = 16'i32
  bm_LDT_ENTRY_Sys* = 0x00100000
  bp_LDT_ENTRY_Sys* = 20'i32
  bm_LDT_ENTRY_Reserved_0* = 0x00200000
  bp_LDT_ENTRY_Reserved_0* = 21'i32
  bm_LDT_ENTRY_Default_Big* = 0x00400000
  bp_LDT_ENTRY_Default_Big* = 22'i32
  bm_LDT_ENTRY_Granularity* = 0x00800000
  bp_LDT_ENTRY_Granularity* = 23'i32
  bm_LDT_ENTRY_BaseHi* = 0xFF000000
  bp_LDT_ENTRY_BaseHi* = 24'i32

type
  LOCALESIGNATURE* {.final, pure.} = object
    lsUsb*: array[0..3, DWORD]
    lsCsbDefault*: array[0..1, DWORD]
    lsCsbSupported*: array[0..1, DWORD]

  TLOCALESIGNATURE* = LOCALESIGNATURE
  PLOCALESIGNATURE* = ptr LOCALESIGNATURE
  LOCALGROUP_MEMBERS_INFO_0* {.final, pure.} = object
    lgrmi0_sid*: PSID

  TLOCALGROUPMEMBERSINFO0* = LOCALGROUP_MEMBERS_INFO_0
  PLOCALGROUPMEMBERSINFO0* = ptr LOCALGROUP_MEMBERS_INFO_0
  LOCALGROUP_MEMBERS_INFO_3* {.final, pure.} = object
    lgrmi3_domainandname*: LPWSTR

  TLOCALGROUPMEMBERSINFO3* = LOCALGROUP_MEMBERS_INFO_3
  PLOCALGROUPMEMBERSINFO3* = ptr LOCALGROUP_MEMBERS_INFO_3
  FXPT16DOT16* = int32
  LPFXPT16DOT16* = ptr FXPT16DOT16
  TFXPT16DOT16* = FXPT16DOT16
  PFXPT16DOT16* = ptr FXPT16DOT16
  LUID* = TlargeInteger
  TLUID* = LUID
  PLUID* = ptr LUID
  LUID_AND_ATTRIBUTES* {.final, pure.} = object
    Luid*: LUID
    Attributes*: DWORD

  TLUIDANDATTRIBUTES* = LUID_AND_ATTRIBUTES
  PLUIDANDATTRIBUTES* = ptr LUID_AND_ATTRIBUTES
  LUID_AND_ATTRIBUTES_ARRAY* = array[0..(ANYSIZE_ARRAY) - 1, LUID_AND_ATTRIBUTES]
  PLUID_AND_ATTRIBUTES_ARRAY* = ptr LUID_AND_ATTRIBUTES_ARRAY
  TLUIDANDATTRIBUTESARRAY* = LUID_AND_ATTRIBUTES_ARRAY
  LV_COLUMN* {.final, pure.} = object
    mask*: UINT
    fmt*: int32
    cx*: int32
    pszText*: LPTSTR
    cchTextMax*: int32
    iSubItem*: int32

  TLVCOLUMN* = LV_COLUMN
  PLVCOLUMN* = ptr LV_COLUMN
  LV_ITEM* {.final, pure.} = object
    mask*: UINT
    iItem*: int32
    iSubItem*: int32
    state*: UINT
    stateMask*: UINT
    pszText*: LPTSTR
    cchTextMax*: int32
    iImage*: int32
    lParam*: LPARAM

  TLVITEM* = LV_ITEM
  PLVITEM* = ptr LV_ITEM
  LV_DISPINFO* {.final, pure.} = object
    hdr*: NMHDR
    item*: LV_ITEM

  TLVDISPINFO* = LV_DISPINFO
  PLVDISPINFO* = ptr LV_DISPINFO
  LV_FINDINFO* {.final, pure.} = object
    flags*: UINT
    psz*: LPCTSTR
    lParam*: LPARAM
    pt*: POINT
    vkDirection*: UINT

  TLVFINDINFO* = LV_FINDINFO
  PLVFINDINFO* = ptr LV_FINDINFO
  LV_HITTESTINFO* {.final, pure.} = object
    pt*: POINT
    flags*: UINT
    iItem*: int32

  TLVHITTESTINFO* = LV_HITTESTINFO
  PLVHITTESTINFO* = ptr LV_HITTESTINFO
  LV_KEYDOWN* {.final, pure.} = object
    hdr*: NMHDR
    wVKey*: int16
    flags*: UINT

  TLVKEYDOWN* = LV_KEYDOWN
  PLVKEYDOWN* = ptr LV_KEYDOWN
  MAT2* {.final, pure.} = object
    eM11*: FIXED
    eM12*: FIXED
    eM21*: FIXED
    eM22*: FIXED

  TMAT2* = MAT2
  PMAT2* = ptr MAT2
  MDICREATESTRUCT* {.final, pure.} = object
    szClass*: LPCTSTR
    szTitle*: LPCTSTR
    hOwner*: HANDLE
    x*: int32
    y*: int32
    cx*: int32
    cy*: int32
    style*: DWORD
    lParam*: LPARAM

  LPMDICREATESTRUCT* = ptr MDICREATESTRUCT
  TMDICREATESTRUCT* = MDICREATESTRUCT
  PMDICREATESTRUCT* = ptr MDICREATESTRUCT
  MEASUREITEMSTRUCT* {.final, pure.} = object
    CtlType*: UINT
    CtlID*: UINT
    itemID*: UINT
    itemWidth*: UINT
    itemHeight*: UINT
    itemData*: ULONG_PTR

  LPMEASUREITEMSTRUCT* = ptr MEASUREITEMSTRUCT
  TMEASUREITEMSTRUCT* = MEASUREITEMSTRUCT
  PMEASUREITEMSTRUCT* = ptr MEASUREITEMSTRUCT
  MEMORY_BASIC_INFORMATION* {.final, pure.} = object
    BaseAddress*: PVOID
    AllocationBase*: PVOID
    AllocationProtect*: DWORD
    RegionSize*: DWORD
    State*: DWORD
    Protect*: DWORD
    `type`*: DWORD

  PMEMORY_BASIC_INFORMATION* = ptr MEMORY_BASIC_INFORMATION
  TMEMORYBASICINFORMATION* = MEMORY_BASIC_INFORMATION
  MEMORYSTATUS* {.final, pure.} = object
    dwLength*: DWORD
    dwMemoryLoad*: DWORD
    dwTotalPhys*: int
    dwAvailPhys*: int
    dwTotalPageFile*: int
    dwAvailPageFile*: int
    dwTotalVirtual*: int
    dwAvailVirtual*: int

  TGUID* {.final, pure.} = object
    D1*: int32
    D2*: int16
    D3*: int16
    D4*: array [0..7, int8]

  LPMEMORYSTATUS* = ptr MEMORYSTATUS
  TMEMORYSTATUS* = MEMORYSTATUS
  PMEMORYSTATUS* = ptr MEMORYSTATUS
  MENUEX_TEMPLATE_HEADER* {.final, pure.} = object
    wVersion*: int16
    wOffset*: int16
    dwHelpId*: DWORD

  TMENUXTEMPLATEHEADER* = MENUEX_TEMPLATE_HEADER
  PMENUXTEMPLATEHEADER* = ptr MENUEX_TEMPLATE_HEADER
  MENUEX_TEMPLATE_ITEM* {.final, pure.} = object
    dwType*: DWORD
    dwState*: DWORD
    uId*: UINT
    bResInfo*: int8
    szText*: array[0..0, WCHAR]
    dwHelpId*: DWORD

  TMENUEXTEMPLATEITEM* = MENUEX_TEMPLATE_ITEM
  PMENUEXTEMPLATEITEM* = ptr MENUEX_TEMPLATE_ITEM
  MENUINFO* {.final, pure.} = object
    cbSize*: DWORD
    fMask*: DWORD
    dwStyle*: DWORD
    cyMax*: UINT
    hbrBack*: HBRUSH
    dwContextHelpID*: DWORD
    dwMenuData*: ULONG_PTR

  LPMENUINFO* = ptr MENUINFO
  LPCMENUINFO* = ptr MENUINFO
  TMENUINFO* = MENUINFO
  PMENUINFO* = ptr MENUINFO
  MENUITEMINFO* {.final, pure.} = object
    cbSize*: UINT
    fMask*: UINT
    fType*: UINT
    fState*: UINT
    wID*: UINT
    hSubMenu*: HMENU
    hbmpChecked*: HBITMAP
    hbmpUnchecked*: HBITMAP
    dwItemData*: ULONG_PTR
    dwTypeData*: LPTSTR
    cch*: UINT
    hbmpItem*: HBITMAP

  LPMENUITEMINFO* = ptr MENUITEMINFO
  LPCMENUITEMINFO* = ptr MENUITEMINFO
  TMENUITEMINFO* = MENUITEMINFO
  TMENUITEMINFOA* = MENUITEMINFO
  PMENUITEMINFO* = ptr MENUITEMINFO
  MENUITEMTEMPLATE* {.final, pure.} = object
    mtOption*: int16
    mtID*: int16
    mtString*: array[0..0, WCHAR]

  TMENUITEMTEMPLATE* = MENUITEMTEMPLATE
  PMENUITEMTEMPLATE* = ptr MENUITEMTEMPLATE
  MENUITEMTEMPLATEHEADER* {.final, pure.} = object
    versionNumber*: int16
    offset*: int16

  TMENUITEMTEMPLATEHEADER* = MENUITEMTEMPLATEHEADER
  PMENUITEMTEMPLATEHEADER* = ptr MENUITEMTEMPLATEHEADER
  MENUTEMPLATE* {.final, pure.} = object
  LPMENUTEMPLATE* = ptr MENUTEMPLATE
  TMENUTEMPLATE* = MENUTEMPLATE
  PMENUTEMPLATE* = ptr MENUTEMPLATE
  METAFILEPICT* {.final, pure.} = object
    mm*: LONG
    xExt*: LONG
    yExt*: LONG
    hMF*: HMETAFILE

  LPMETAFILEPICT* = ptr METAFILEPICT
  TMETAFILEPICT* = METAFILEPICT
  PMETAFILEPICT* = ptr METAFILEPICT
  METAHEADER* {.final, pure.} = object
    mtType*: int16
    mtHeaderSize*: int16
    mtVersion*: int16
    mtSize*: DWORD
    mtNoObjects*: int16
    mtMaxRecord*: DWORD
    mtNoParameters*: int16

  TMETAHEADER* = METAHEADER
  PMETAHEADER* = ptr METAHEADER
  METARECORD* {.final, pure.} = object
    rdSize*: DWORD
    rdFunction*: int16
    rdParm*: array[0..0, int16]

  LPMETARECORD* = ptr METARECORD
  TMETARECORD* = METARECORD
  PMETARECORD* = ptr METARECORD
  MINIMIZEDMETRICS* {.final, pure.} = object
    cbSize*: UINT
    iWidth*: int32
    iHorzGap*: int32
    iVertGap*: int32
    iArrange*: int32

  LPMINIMIZEDMETRICS* = ptr MINIMIZEDMETRICS
  TMINIMIZEDMETRICS* = MINIMIZEDMETRICS
  PMINIMIZEDMETRICS* = ptr MINIMIZEDMETRICS
  MINMAXINFO* {.final, pure.} = object
    ptReserved*: POINT
    ptMaxSize*: POINT
    ptMaxPosition*: POINT
    ptMinTrackSize*: POINT
    ptMaxTrackSize*: POINT

  TMINMAXINFO* = MINMAXINFO
  PMINMAXINFO* = ptr MINMAXINFO
  MODEMDEVCAPS* {.final, pure.} = object
    dwActualSize*: DWORD
    dwRequiredSize*: DWORD
    dwDevSpecificOffset*: DWORD
    dwDevSpecificSize*: DWORD
    dwModemProviderVersion*: DWORD
    dwModemManufacturerOffset*: DWORD
    dwModemManufacturerSize*: DWORD
    dwModemModelOffset*: DWORD
    dwModemModelSize*: DWORD
    dwModemVersionOffset*: DWORD
    dwModemVersionSize*: DWORD
    dwDialOptions*: DWORD
    dwCallSetupFailTimer*: DWORD
    dwInactivityTimeout*: DWORD
    dwSpeakerVolume*: DWORD
    dwSpeakerMode*: DWORD
    dwModemOptions*: DWORD
    dwMaxDTERate*: DWORD
    dwMaxDCERate*: DWORD
    abVariablePortion*: array[0..0, int8]

  LPMODEMDEVCAPS* = ptr MODEMDEVCAPS
  TMODEMDEVCAPS* = MODEMDEVCAPS
  PMODEMDEVCAPS* = ptr MODEMDEVCAPS
  MODEMSETTINGS* {.final, pure.} = object
    dwActualSize*: DWORD
    dwRequiredSize*: DWORD
    dwDevSpecificOffset*: DWORD
    dwDevSpecificSize*: DWORD
    dwCallSetupFailTimer*: DWORD
    dwInactivityTimeout*: DWORD
    dwSpeakerVolume*: DWORD
    dwSpeakerMode*: DWORD
    dwPreferredModemOptions*: DWORD
    dwNegotiatedModemOptions*: DWORD
    dwNegotiatedDCERate*: DWORD
    abVariablePortion*: array[0..0, int8]

  LPMODEMSETTINGS* = ptr MODEMSETTINGS
  TMODEMSETTINGS* = MODEMSETTINGS
  PMODEMSETTINGS* = ptr MODEMSETTINGS
  MONCBSTRUCT* {.final, pure.} = object
    cb*: UINT
    dwTime*: DWORD
    hTask*: HANDLE
    dwRet*: DWORD
    wType*: UINT
    wFmt*: UINT
    hConv*: HCONV
    hsz1*: HSZ
    hsz2*: HSZ
    hData*: HDDEDATA
    dwData1*: DWORD
    dwData2*: DWORD
    cc*: CONVCONTEXT
    cbData*: DWORD
    Data*: array[0..7, DWORD]

  TMONCBSTRUCT* = MONCBSTRUCT
  PMONCBSTRUCT* = ptr MONCBSTRUCT
  MONCONVSTRUCT* {.final, pure.} = object
    cb*: UINT
    fConnect*: WINBOOL
    dwTime*: DWORD
    hTask*: HANDLE
    hszSvc*: HSZ
    hszTopic*: HSZ
    hConvClient*: HCONV
    hConvServer*: HCONV

  TMONCONVSTRUCT* = MONCONVSTRUCT
  PMONCONVSTRUCT* = ptr MONCONVSTRUCT
  MONERRSTRUCT* {.final, pure.} = object
    cb*: UINT
    wLastError*: UINT
    dwTime*: DWORD
    hTask*: HANDLE

  TMONERRSTRUCT* = MONERRSTRUCT
  PMONERRSTRUCT* = ptr MONERRSTRUCT
  MONHSZSTRUCT* {.final, pure.} = object
    cb*: UINT
    fsAction*: WINBOOL
    dwTime*: DWORD
    hsz*: HSZ
    hTask*: HANDLE
    str*: array[0..0, TCHAR]

  TMONHSZSTRUCT* = MONHSZSTRUCT
  PMONHSZSTRUCT* = ptr MONHSZSTRUCT
  MONITOR_INFO_1* {.final, pure.} = object
    pName*: LPTSTR

  TMONITORINFO1* = MONITOR_INFO_1
  PMONITORINFO1* = ptr MONITOR_INFO_1
  MONITOR_INFO_2* {.final, pure.} = object
    pName*: LPTSTR
    pEnvironment*: LPTSTR
    pDLLName*: LPTSTR

  TMONITORINFO2* = MONITOR_INFO_2
  PMONITORINFO2* = ptr MONITOR_INFO_2
  MONLINKSTRUCT* {.final, pure.} = object
    cb*: UINT
    dwTime*: DWORD
    hTask*: HANDLE
    fEstablished*: WINBOOL
    fNoData*: WINBOOL
    hszSvc*: HSZ
    hszTopic*: HSZ
    hszItem*: HSZ
    wFmt*: UINT
    fServer*: WINBOOL
    hConvServer*: HCONV
    hConvClient*: HCONV

  TMONLINKSTRUCT* = MONLINKSTRUCT
  PMONLINKSTRUCT* = ptr MONLINKSTRUCT
  MONMSGSTRUCT* {.final, pure.} = object
    cb*: UINT
    hwndTo*: HWND
    dwTime*: DWORD
    hTask*: HANDLE
    wMsg*: UINT
    wParam*: WPARAM
    lParam*: LPARAM
    dmhd*: DDEML_MSG_HOOK_DATA

  TMONMSGSTRUCT* = MONMSGSTRUCT
  PMONMSGSTRUCT* = ptr MONMSGSTRUCT
  MOUSEHOOKSTRUCT* {.final, pure.} = object
    pt*: POINT
    hwnd*: HWND
    wHitTestCode*: UINT
    dwExtraInfo*: DWORD

  LPMOUSEHOOKSTRUCT* = ptr MOUSEHOOKSTRUCT
  TMOUSEHOOKSTRUCT* = MOUSEHOOKSTRUCT
  PMOUSEHOOKSTRUCT* = ptr MOUSEHOOKSTRUCT
  MOUSEKEYS* {.final, pure.} = object
    cbSize*: DWORD
    dwFlags*: DWORD
    iMaxSpeed*: DWORD
    iTimeToMaxSpeed*: DWORD
    iCtrlSpeed*: DWORD
    dwReserved1*: DWORD
    dwReserved2*: DWORD

  TMOUSEKEYS* = MOUSEKEYS
  PMOUSEKEYS* = ptr MOUSEKEYS
  MSGBOXCALLBACK* = proc (lpHelpInfo: LPHELPINFO){.stdcall.}
  TMSGBOXCALLBACK* = MSGBOXCALLBACK
  MSGBOXPARAMS* {.final, pure.} = object
    cbSize*: UINT
    hwndOwner*: HWND
    hInstance*: HINST
    lpszText*: LPCSTR
    lpszCaption*: LPCSTR
    dwStyle*: DWORD
    lpszIcon*: LPCSTR
    dwContextHelpId*: DWORD
    lpfnMsgBoxCallback*: MSGBOXCALLBACK
    dwLanguageId*: DWORD

  LPMSGBOXPARAMS* = ptr MSGBOXPARAMS
  TMSGBOXPARAMS* = MSGBOXPARAMS
  TMSGBOXPARAMSA* = MSGBOXPARAMS
  PMSGBOXPARAMS* = ptr MSGBOXPARAMS
  MSGFILTER* {.final, pure.} = object
    nmhdr*: NMHDR
    msg*: UINT
    wParam*: WPARAM
    lParam*: LPARAM

  Tmsgfilter* = MSGFILTER
  Pmsgfilter* = ptr MSGFILTER
  MULTIKEYHELP* {.final, pure.} = object
    mkSize*: DWORD
    mkKeylist*: TCHAR
    szKeyphrase*: array[0..0, TCHAR]

  TMULTIKEYHELP* = MULTIKEYHELP
  PMULTIKEYHELP* = ptr MULTIKEYHELP
  NAME_BUFFER* {.final, pure.} = object
    name*: array[0..(NCBNAMSZ) - 1, UCHAR]
    name_num*: UCHAR
    name_flags*: UCHAR

  TNAMEBUFFER* = NAME_BUFFER
  PNAMEBUFFER* = ptr NAME_BUFFER
  p_NCB* = ptr NCB
  NCB* {.final, pure.} = object
    ncb_command*: UCHAR
    ncb_retcode*: UCHAR
    ncb_lsn*: UCHAR
    ncb_num*: UCHAR
    ncb_buffer*: PUCHAR
    ncb_length*: int16
    ncb_callname*: array[0..(NCBNAMSZ) - 1, UCHAR]
    ncb_name*: array[0..(NCBNAMSZ) - 1, UCHAR]
    ncb_rto*: UCHAR
    ncb_sto*: UCHAR
    ncb_post*: proc (para1: p_NCB){.CDECL.}
    ncb_lana_num*: UCHAR
    ncb_cmd_cplt*: UCHAR
    ncb_reserve*: array[0..9, UCHAR]
    ncb_event*: HANDLE

  TNCB* = NCB
  NCCALCSIZE_PARAMS* {.final, pure.} = object
    rgrc*: array[0..2, RECT]
    lppos*: PWINDOWPOS

  TNCCALCSIZEPARAMS* = NCCALCSIZE_PARAMS
  PNCCALCSIZEPARAMS* = ptr NCCALCSIZE_PARAMS
  NDDESHAREINFO* {.final, pure.} = object
    lRevision*: LONG
    lpszShareName*: LPTSTR
    lShareType*: LONG
    lpszAppTopicList*: LPTSTR
    fSharedFlag*: LONG
    fService*: LONG
    fStartAppFlag*: LONG
    nCmdShow*: LONG
    qModifyId*: array[0..1, LONG]
    cNumItems*: LONG
    lpszItemList*: LPTSTR

  TNDDESHAREINFO* = NDDESHAREINFO
  PNDDESHAREINFO* = ptr NDDESHAREINFO
  NETRESOURCE* {.final, pure.} = object
    dwScope*: DWORD
    dwType*: DWORD
    dwDisplayType*: DWORD
    dwUsage*: DWORD
    lpLocalName*: LPTSTR
    lpRemoteName*: LPTSTR
    lpComment*: LPTSTR
    lpProvider*: LPTSTR

  LPNETRESOURCE* = ptr NETRESOURCE
  TNETRESOURCE* = NETRESOURCE
  TNETRESOURCEA* = NETRESOURCE
  PNETRESOURCE* = ptr NETRESOURCE
  PNETRESOURCEA* = ptr NETRESOURCE
  NEWCPLINFO* {.final, pure.} = object
    dwSize*: DWORD
    dwFlags*: DWORD
    dwHelpContext*: DWORD
    lData*: LONG
    hIcon*: HICON
    szName*: array[0..31, TCHAR]
    szInfo*: array[0..63, TCHAR]
    szHelpFile*: array[0..127, TCHAR]

  TNEWCPLINFO* = NEWCPLINFO
  PNEWCPLINFO* = ptr NEWCPLINFO
  NEWTEXTMETRIC* {.final, pure.} = object
    tmHeight*: LONG
    tmAscent*: LONG
    tmDescent*: LONG
    tmInternalLeading*: LONG
    tmExternalLeading*: LONG
    tmAveCharWidth*: LONG
    tmMaxCharWidth*: LONG
    tmWeight*: LONG
    tmOverhang*: LONG
    tmDigitizedAspectX*: LONG
    tmDigitizedAspectY*: LONG
    tmFirstChar*: BCHAR
    tmLastChar*: BCHAR
    tmDefaultChar*: BCHAR
    tmBreakChar*: BCHAR
    tmItalic*: int8
    tmUnderlined*: int8
    tmStruckOut*: int8
    tmPitchAndFamily*: int8
    tmCharSet*: int8
    ntmFlags*: DWORD
    ntmSizeEM*: UINT
    ntmCellHeight*: UINT
    ntmAvgWidth*: UINT

  TNEWTEXTMETRIC* = NEWTEXTMETRIC
  PNEWTEXTMETRIC* = ptr NEWTEXTMETRIC
  NEWTEXTMETRICEX* {.final, pure.} = object
    ntmentm*: NEWTEXTMETRIC
    ntmeFontSignature*: FONTSIGNATURE

  TNEWTEXTMETRICEX* = NEWTEXTMETRICEX
  PNEWTEXTMETRICEX* = ptr NEWTEXTMETRICEX
  NM_LISTVIEW* {.final, pure.} = object
    hdr*: NMHDR
    iItem*: int32
    iSubItem*: int32
    uNewState*: UINT
    uOldState*: UINT
    uChanged*: UINT
    ptAction*: POINT
    lParam*: LPARAM

  TNMLISTVIEW* = NM_LISTVIEW
  PNMLISTVIEW* = ptr NM_LISTVIEW
  TV_ITEM* {.final, pure.} = object
    mask*: UINT
    hItem*: HTREEITEM
    state*: UINT
    stateMask*: UINT
    pszText*: LPTSTR
    cchTextMax*: int32
    iImage*: int32
    iSelectedImage*: int32
    cChildren*: int32
    lParam*: LPARAM

  LPTV_ITEM* = ptr TV_ITEM
  TTVITEM* = TV_ITEM
  PTVITEM* = ptr TV_ITEM
  NM_TREEVIEW* {.final, pure.} = object
    hdr*: NMHDR
    action*: UINT
    itemOld*: TV_ITEM
    itemNew*: TV_ITEM
    ptDrag*: POINT

  LPNM_TREEVIEW* = ptr NM_TREEVIEW
  TNMTREEVIEW* = NM_TREEVIEW
  PNMTREEVIEW* = ptr NM_TREEVIEW
  NM_UPDOWNW* {.final, pure.} = object
    hdr*: NMHDR
    iPos*: int32
    iDelta*: int32

  TNMUPDOWN* = NM_UPDOWNW
  PNMUPDOWN* = ptr NM_UPDOWNW
  NONCLIENTMETRICS* {.final, pure.} = object
    cbSize*: UINT
    iBorderWidth*: int32
    iScrollWidth*: int32
    iScrollHeight*: int32
    iCaptionWidth*: int32
    iCaptionHeight*: int32
    lfCaptionFont*: LOGFONT
    iSmCaptionWidth*: int32
    iSmCaptionHeight*: int32
    lfSmCaptionFont*: LOGFONT
    iMenuWidth*: int32
    iMenuHeight*: int32
    lfMenuFont*: LOGFONT
    lfStatusFont*: LOGFONT
    lfMessageFont*: LOGFONT

  LPNONCLIENTMETRICS* = ptr NONCLIENTMETRICS
  TNONCLIENTMETRICS* = NONCLIENTMETRICS
  PNONCLIENTMETRICS* = ptr NONCLIENTMETRICS
  SERVICE_ADDRESS* {.final, pure.} = object
    dwAddressType*: DWORD
    dwAddressFlags*: DWORD
    dwAddressLength*: DWORD
    dwPrincipalLength*: DWORD
    lpAddress*: ptr int8
    lpPrincipal*: ptr int8

  TSERVICEADDRESS* = SERVICE_ADDRESS
  PSERVICEADDRESS* = ptr SERVICE_ADDRESS
  SERVICE_ADDRESSES* {.final, pure.} = object
    dwAddressCount*: DWORD
    Addresses*: array[0..0, SERVICE_ADDRESS]

  LPSERVICE_ADDRESSES* = ptr SERVICE_ADDRESSES
  TSERVICEADDRESSES* = SERVICE_ADDRESSES
  PSERVICEADDRESSES* = ptr SERVICE_ADDRESSES
  LPGUID* = ptr TGUID
  PGUID* = ptr TGUID
  CLSID* = TGUID
  LPCLSID* = ptr CLSID
  TCLSID* = CLSID
  PCLSID* = ptr CLSID
  SERVICE_INFO* {.final, pure.} = object
    lpServiceType*: LPGUID
    lpServiceName*: LPTSTR
    lpComment*: LPTSTR
    lpLocale*: LPTSTR
    dwDisplayHint*: DWORD
    dwVersion*: DWORD
    dwTime*: DWORD
    lpMachineName*: LPTSTR
    lpServiceAddress*: LPSERVICE_ADDRESSES
    ServiceSpecificInfo*: BLOB

  TSERVICEINFO* = SERVICE_INFO
  PSERVICEINFO* = ptr SERVICE_INFO
  NS_SERVICE_INFO* {.final, pure.} = object
    dwNameSpace*: DWORD
    ServiceInfo*: SERVICE_INFO

  TNSSERVICEINFO* = NS_SERVICE_INFO
  PNSSERVICEINFO* = ptr NS_SERVICE_INFO
  NUMBERFMT* {.final, pure.} = object
    NumDigits*: UINT
    LeadingZero*: UINT
    Grouping*: UINT
    lpDecimalSep*: LPTSTR
    lpThousandSep*: LPTSTR
    NegativeOrder*: UINT

  Tnumberfmt* = NUMBERFMT
  Pnumberfmt* = ptr NUMBERFMT
  OFSTRUCT* {.final, pure.} = object
    cBytes*: int8
    fFixedDisk*: int8
    nErrCode*: int16
    Reserved1*: int16
    Reserved2*: int16
    szPathName*: array[0..(OFS_MAXPATHNAME) - 1, CHAR]

  LPOFSTRUCT* = ptr OFSTRUCT
  TOFSTRUCT* = OFSTRUCT
  POFSTRUCT* = ptr OFSTRUCT
  OPENFILENAME_NT4* {.final, pure.} = object
    lStructSize*: DWORD
    hwndOwner*: HWND
    hInstance*: HINST
    lpstrFilter*: LPCTSTR
    lpstrCustomFilter*: LPTSTR
    nMaxCustFilter*: DWORD
    nFilterIndex*: DWORD
    lpstrFile*: LPTSTR
    nMaxFile*: DWORD
    lpstrFileTitle*: LPTSTR
    nMaxFileTitle*: DWORD
    lpstrInitialDir*: LPCTSTR
    lpstrTitle*: LPCTSTR
    Flags*: DWORD
    nFileOffset*: int16
    nFileExtension*: int16
    lpstrDefExt*: LPCTSTR
    lCustData*: LPARAM
    lpfnHook*: LPOFNHOOKPROC
    lpTemplateName*: LPCTSTR

  LPOPENFILENAME_NT4* = ptr OPENFILENAME_NT4
  TOPENFILENAME_NT4* = OPENFILENAME_NT4
  POPENFILENAME_NT4* = ptr OPENFILENAME_NT4
  TOPENFILENAME* {.final, pure.} = object
    lStructSize*: DWORD
    hwndOwner*: HWND
    hInstance*: HINST
    lpstrFilter*: LPCTSTR
    lpstrCustomFilter*: LPTSTR
    nMaxCustFilter*: DWORD
    nFilterIndex*: DWORD
    lpstrFile*: LPTSTR
    nMaxFile*: DWORD
    lpstrFileTitle*: LPTSTR
    nMaxFileTitle*: DWORD
    lpstrInitialDir*: LPCTSTR
    lpstrTitle*: LPCTSTR
    Flags*: DWORD
    nFileOffset*: int16
    nFileExtension*: int16
    lpstrDefExt*: LPCTSTR
    lCustData*: LPARAM
    lpfnHook*: LPOFNHOOKPROC
    lpTemplateName*: LPCTSTR
    pvReserved*: pointer
    dwreserved*: dword
    FlagsEx*: dword

  LPOPENFILENAME* = ptr TOPENFILENAME
  POPENFILENAME* = ptr TOPENFILENAME
  OFN* = TOPENFILENAME
  POFN* = ptr TOPENFILENAME
  OFNOTIFY* {.final, pure.} = object
    hdr*: NMHDR
    lpOFN*: LPOPENFILENAME
    pszFile*: LPTSTR

  LPOFNOTIFY* = ptr OFNOTIFY
  TOFNOTIFY* = OFNOTIFY
  POFNOTIFY* = ptr OFNOTIFY
  OSVERSIONINFO* {.final, pure.} = object
    dwOSVersionInfoSize*: DWORD
    dwMajorVersion*: DWORD
    dwMinorVersion*: DWORD
    dwBuildNumber*: DWORD
    dwPlatformId*: DWORD
    szCSDVersion*: array[0..127, TCHAR]

  LPOSVERSIONINFO* = ptr OSVERSIONINFO
  TOSVERSIONINFO* = OSVERSIONINFO
  POSVERSIONINFO* = ptr OSVERSIONINFO
  OSVERSIONINFOW* {.final, pure.} = object
    dwOSVersionInfoSize*: DWORD
    dwMajorVersion*: DWORD
    dwMinorVersion*: DWORD
    dwBuildNumber*: DWORD
    dwPlatformId*: DWORD
    szCSDVersion*: array[0..127, WCHAR]

  LPOSVERSIONINFOW* = ptr OSVERSIONINFOW
  TOSVERSIONINFOW* = OSVERSIONINFOW
  POSVERSIONINFOW* = ptr OSVERSIONINFOW
  TEXTMETRIC* {.final, pure.} = object
    tmHeight*: LONG
    tmAscent*: LONG
    tmDescent*: LONG
    tmInternalLeading*: LONG
    tmExternalLeading*: LONG
    tmAveCharWidth*: LONG
    tmMaxCharWidth*: LONG
    tmWeight*: LONG
    tmOverhang*: LONG
    tmDigitizedAspectX*: LONG
    tmDigitizedAspectY*: LONG
    tmFirstChar*: BCHAR
    tmLastChar*: BCHAR
    tmDefaultChar*: BCHAR
    tmBreakChar*: BCHAR
    tmItalic*: int8
    tmUnderlined*: int8
    tmStruckOut*: int8
    tmPitchAndFamily*: int8
    tmCharSet*: int8

  LPTEXTMETRIC* = ptr TEXTMETRIC
  TTEXTMETRIC* = TEXTMETRIC
  PTEXTMETRIC* = ptr TEXTMETRIC
  TEXTMETRICW* {.final, pure.} = object
    tmHeight*: LONG
    tmAscent*: LONG
    tmDescent*: LONG
    tmInternalLeading*: LONG
    tmExternalLeading*: LONG
    tmAveCharWidth*: LONG
    tmMaxCharWidth*: LONG
    tmWeight*: LONG
    tmOverhang*: LONG
    tmDigitizedAspectX*: LONG
    tmDigitizedAspectY*: LONG
    tmFirstChar*: WCHAR
    tmLastChar*: WCHAR
    tmDefaultChar*: WCHAR
    tmBreakChar*: WCHAR
    tmItalic*: int8
    tmUnderlined*: int8
    tmStruckOut*: int8
    tmPitchAndFamily*: int8
    tmCharSet*: int8

  LPTEXTMETRICW* = ptr TEXTMETRICW
  TTEXTMETRICW* = TEXTMETRICW
  PTEXTMETRICW* = ptr TEXTMETRICW
  OUTLINETEXTMETRIC* {.final, pure.} = object
    otmSize*: UINT
    otmTextMetrics*: TEXTMETRIC
    otmFiller*: int8
    otmPanoseNumber*: PANOSE
    otmfsSelection*: UINT
    otmfsType*: UINT
    otmsCharSlopeRise*: int32
    otmsCharSlopeRun*: int32
    otmItalicAngle*: int32
    otmEMSquare*: UINT
    otmAscent*: int32
    otmDescent*: int32
    otmLineGap*: UINT
    otmsCapEmHeight*: UINT
    otmsXHeight*: UINT
    otmrcFontBox*: RECT
    otmMacAscent*: int32
    otmMacDescent*: int32
    otmMacLineGap*: UINT
    otmusMinimumPPEM*: UINT
    otmptSubscriptSize*: POINT
    otmptSubscriptOffset*: POINT
    otmptSuperscriptSize*: POINT
    otmptSuperscriptOffset*: POINT
    otmsStrikeoutSize*: UINT
    otmsStrikeoutPosition*: int32
    otmsUnderscoreSize*: int32
    otmsUnderscorePosition*: int32
    otmpFamilyName*: PSTR
    otmpFaceName*: PSTR
    otmpStyleName*: PSTR
    otmpFullName*: PSTR

  LPOUTLINETEXTMETRIC* = ptr OUTLINETEXTMETRIC
  TOUTLINETEXTMETRIC* = OUTLINETEXTMETRIC
  POUTLINETEXTMETRIC* = ptr OUTLINETEXTMETRIC
  OVERLAPPED* {.final, pure.} = object
    Internal*: DWORD
    InternalHigh*: DWORD
    Offset*: DWORD
    OffsetHigh*: DWORD
    hEvent*: HANDLE

  LPOVERLAPPED* = ptr OVERLAPPED
  TOVERLAPPED* = OVERLAPPED
  POVERLAPPED* = ptr OVERLAPPED
  #PAGESETUPDLG = record conflicts with function PageSetupDlg
  TPAGESETUPDLG* {.final, pure.} = object
    lStructSize*: DWORD
    hwndOwner*: HWND
    hDevMode*: HGLOBAL
    hDevNames*: HGLOBAL
    Flags*: DWORD
    ptPaperSize*: POINT
    rtMinMargin*: RECT
    rtMargin*: RECT
    hInstance*: HINST
    lCustData*: LPARAM
    lpfnPageSetupHook*: LPPAGESETUPHOOK
    lpfnPagePaintHook*: LPPAGEPAINTHOOK
    lpPageSetupTemplateName*: LPCTSTR
    hPageSetupTemplate*: HGLOBAL

  LPPAGESETUPDLG* = ptr TPAGESETUPDLG
  PPAGESETUPDLG* = ptr TPAGESETUPDLG
  TPSD* = TPAGESETUPDLG
  PPSD* = ptr TPAGESETUPDLG
  PAINTSTRUCT* {.final, pure.} = object
    hdc*: HDC
    fErase*: WINBOOL
    rcPaint*: RECT
    fRestore*: WINBOOL
    fIncUpdate*: WINBOOL
    rgbReserved*: array[0..31, int8]

  LPPAINTSTRUCT* = ptr PAINTSTRUCT
  TPAINTSTRUCT* = PAINTSTRUCT
  PPAINTSTRUCT* = ptr PAINTSTRUCT
  PARAFORMAT* {.final, pure.} = object
    cbSize*: UINT
    dwMask*: DWORD
    wNumbering*: int16
    wReserved*: int16
    dxStartIndent*: LONG
    dxRightIndent*: LONG
    dxOffset*: LONG
    wAlignment*: int16
    cTabCount*: SHORT
    rgxTabs*: array[0..(MAX_TAB_STOPS) - 1, LONG]

  Tparaformat* = PARAFORMAT
  Pparaformat* = ptr PARAFORMAT
  PERF_COUNTER_BLOCK* {.final, pure.} = object
    ByteLength*: DWORD

  TPERFCOUNTERBLOCK* = PERF_COUNTER_BLOCK
  PPERFCOUNTERBLOCK* = ptr PERF_COUNTER_BLOCK
  PERF_COUNTER_DEFINITION* {.final, pure.} = object
    ByteLength*: DWORD
    CounterNameTitleIndex*: DWORD
    CounterNameTitle*: LPWSTR
    CounterHelpTitleIndex*: DWORD
    CounterHelpTitle*: LPWSTR
    DefaultScale*: DWORD
    DetailLevel*: DWORD
    CounterType*: DWORD
    CounterSize*: DWORD
    CounterOffset*: DWORD

  TPERFCOUNTERDEFINITION* = PERF_COUNTER_DEFINITION
  PPERFCOUNTERDEFINITION* = ptr PERF_COUNTER_DEFINITION
  PERF_DATA_BLOCK* {.final, pure.} = object
    Signature*: array[0..3, WCHAR]
    LittleEndian*: DWORD
    Version*: DWORD
    Revision*: DWORD
    TotalByteLength*: DWORD
    HeaderLength*: DWORD
    NumObjectTypes*: DWORD
    DefaultObject*: DWORD
    SystemTime*: SYSTEMTIME
    PerfTime*: LARGE_INTEGER
    PerfFreq*: LARGE_INTEGER
    PerfTime100nSec*: LARGE_INTEGER
    SystemNameLength*: DWORD
    SystemNameOffset*: DWORD

  TPERFDATABLOCK* = PERF_DATA_BLOCK
  PPERFDATABLOCK* = ptr PERF_DATA_BLOCK
  PERF_INSTANCE_DEFINITION* {.final, pure.} = object
    ByteLength*: DWORD
    ParentObjectTitleIndex*: DWORD
    ParentObjectInstance*: DWORD
    UniqueID*: DWORD
    NameOffset*: DWORD
    NameLength*: DWORD

  TPERFINSTANCEDEFINITION* = PERF_INSTANCE_DEFINITION
  PPERFINSTANCEDEFINITION* = PERF_INSTANCE_DEFINITION
  PERF_OBJECT_TYPE* {.final, pure.} = object
    TotalByteLength*: DWORD
    DefinitionLength*: DWORD
    HeaderLength*: DWORD
    ObjectNameTitleIndex*: DWORD
    ObjectNameTitle*: LPWSTR
    ObjectHelpTitleIndex*: DWORD
    ObjectHelpTitle*: LPWSTR
    DetailLevel*: DWORD
    NumCounters*: DWORD
    DefaultCounter*: DWORD
    NumInstances*: DWORD
    CodePage*: DWORD
    PerfTime*: LARGE_INTEGER
    PerfFreq*: LARGE_INTEGER

  TPERFOBJECTTYPE* = PERF_OBJECT_TYPE
  PPERFOBJECTTYPE* = ptr PERF_OBJECT_TYPE
  POLYTEXT* {.final, pure.} = object
    x*: int32
    y*: int32
    n*: UINT
    lpstr*: LPCTSTR
    uiFlags*: UINT
    rcl*: RECT
    pdx*: ptr int32

  TPOLYTEXT* = POLYTEXT
  PPOLYTEXT* = ptr POLYTEXT
  PORT_INFO_1* {.final, pure.} = object
    pName*: LPTSTR

  TPORTINFO1* = PORT_INFO_1
  PPORTINFO1* = ptr PORT_INFO_1
  PORT_INFO_2* {.final, pure.} = object
    pPortName*: LPSTR
    pMonitorName*: LPSTR
    pDescription*: LPSTR
    fPortType*: DWORD
    Reserved*: DWORD

  TPORTINFO2* = PORT_INFO_2
  PPORTINFO2* = ptr PORT_INFO_2
  PREVENT_MEDIA_REMOVAL* {.final, pure.} = object
    PreventMediaRemoval*: bool

  TPREVENTMEDIAREMOVAL* = PREVENT_MEDIA_REMOVAL
  PPREVENTMEDIAREMOVAL* = ptr PREVENT_MEDIA_REMOVAL
  #PRINTDLG = record conflicts with PrintDlg function
  TPRINTDLG* {.final, pure.} = object
    lStructSize*: DWORD
    hwndOwner*: HWND
    hDevMode*: HANDLE
    hDevNames*: HANDLE
    hDC*: HDC
    Flags*: DWORD
    nFromPage*: int16
    nToPage*: int16
    nMinPage*: int16
    nMaxPage*: int16
    nCopies*: int16
    hInstance*: HINST
    lCustData*: DWORD
    lpfnPrintHook*: LPPRINTHOOKPROC
    lpfnSetupHook*: LPSETUPHOOKPROC
    lpPrintTemplateName*: LPCTSTR
    lpSetupTemplateName*: LPCTSTR
    hPrintTemplate*: HANDLE
    hSetupTemplate*: HANDLE

  LPPRINTDLG* = ptr TPRINTDLG
  PPRINTDLG* = ptr TPRINTDLG
  TPD* = TPRINTDLG
  PPD* = ptr TPRINTDLG
  PRINTER_DEFAULTS* {.final, pure.} = object
    pDatatype*: LPTSTR
    pDevMode*: LPDEVMODE
    DesiredAccess*: ACCESS_MASK

  TPRINTERDEFAULTS* = PRINTER_DEFAULTS
  PPRINTERDEFAULTS* = ptr PRINTER_DEFAULTS
  PRINTER_INFO_1* {.final, pure.} = object
    Flags*: DWORD
    pDescription*: LPTSTR
    pName*: LPTSTR
    pComment*: LPTSTR

  LPPRINTER_INFO_1* = ptr PRINTER_INFO_1
  PPRINTER_INFO_1* = ptr PRINTER_INFO_1
  TPRINTERINFO1* = PRINTER_INFO_1
  PRINTER_INFO_2* {.final, pure.} = object
    pServerName*: LPTSTR
    pPrinterName*: LPTSTR
    pShareName*: LPTSTR
    pPortName*: LPTSTR
    pDriverName*: LPTSTR
    pComment*: LPTSTR
    pLocation*: LPTSTR
    pDevMode*: LPDEVMODE
    pSepFile*: LPTSTR
    pPrintProcessor*: LPTSTR
    pDatatype*: LPTSTR
    pParameters*: LPTSTR
    pSecurityDescriptor*: PSECURITY_DESCRIPTOR
    Attributes*: DWORD
    Priority*: DWORD
    DefaultPriority*: DWORD
    StartTime*: DWORD
    UntilTime*: DWORD
    Status*: DWORD
    cJobs*: DWORD
    AveragePPM*: DWORD

  TPRINTERINFO2* = PRINTER_INFO_2
  PPRINTERINFO2* = ptr PRINTER_INFO_2
  PRINTER_INFO_3* {.final, pure.} = object
    pSecurityDescriptor*: PSECURITY_DESCRIPTOR

  TPRINTERINFO3* = PRINTER_INFO_3
  PPRINTERINFO3* = ptr PRINTER_INFO_3
  PRINTER_INFO_4* {.final, pure.} = object
    pPrinterName*: LPTSTR
    pServerName*: LPTSTR
    Attributes*: DWORD

  TPRINTERINFO4* = PRINTER_INFO_4
  PPRINTERINFO4* = ptr PRINTER_INFO_4
  PRINTER_INFO_5* {.final, pure.} = object
    pPrinterName*: LPTSTR
    pPortName*: LPTSTR
    Attributes*: DWORD
    DeviceNotSelectedTimeout*: DWORD
    TransmissionRetryTimeout*: DWORD

  TPRINTERINFO5* = PRINTER_INFO_5
  PPRINTERINFO5* = ptr PRINTER_INFO_5
  PRINTER_NOTIFY_INFO_DATA* {.final, pure.} = object
    `type`*: int16
    Field*: int16
    Reserved*: DWORD
    Id*: DWORD
    cbBuf*: DWORD
    pBuf*: LPVOID

  TPRINTERNOTIFYINFODATA* = PRINTER_NOTIFY_INFO_DATA
  PPRINTERNOTIFYINFODATA* = ptr PRINTER_NOTIFY_INFO_DATA
  PRINTER_NOTIFY_INFO* {.final, pure.} = object
    Version*: DWORD
    Flags*: DWORD
    Count*: DWORD
    aData*: array[0..0, PRINTER_NOTIFY_INFO_DATA]

  TPRINTERNOTIFYINFO* = PRINTER_NOTIFY_INFO
  PPRINTERNOTIFYINFO* = ptr PRINTER_NOTIFY_INFO
  PRINTER_NOTIFY_OPTIONS_TYPE* {.final, pure.} = object
    `type`*: int16
    Reserved0*: int16
    Reserved1*: DWORD
    Reserved2*: DWORD
    Count*: DWORD
    pFields*: PWORD

  PPRINTER_NOTIFY_OPTIONS_TYPE* = ptr PRINTER_NOTIFY_OPTIONS_TYPE
  TPRINTERNOTIFYOPTIONSTYPE* = PRINTER_NOTIFY_OPTIONS_TYPE
  PRINTER_NOTIFY_OPTIONS* {.final, pure.} = object
    Version*: DWORD
    Flags*: DWORD
    Count*: DWORD
    pTypes*: PPRINTER_NOTIFY_OPTIONS_TYPE

  TPRINTERNOTIFYOPTIONS* = PRINTER_NOTIFY_OPTIONS
  PPRINTERNOTIFYOPTIONS* = ptr PRINTER_NOTIFY_OPTIONS
  PRINTPROCESSOR_INFO_1* {.final, pure.} = object
    pName*: LPTSTR

  TPRINTPROCESSORINFO1* = PRINTPROCESSOR_INFO_1
  PPRINTPROCESSORINFO1* = ptr PRINTPROCESSOR_INFO_1
  PRIVILEGE_SET* {.final, pure.} = object
    PrivilegeCount*: DWORD
    Control*: DWORD
    Privilege*: array[0..(ANYSIZE_ARRAY) - 1, LUID_AND_ATTRIBUTES]

  LPPRIVILEGE_SET* = ptr PRIVILEGE_SET
  PPRIVILEGE_SET* = ptr PRIVILEGE_SET
  TPRIVILEGESET* = PRIVILEGE_SET
  PROCESS_HEAPENTRY* {.final, pure.} = object
    lpData*: PVOID
    cbData*: DWORD
    cbOverhead*: int8
    iRegionIndex*: int8
    wFlags*: int16
    dwCommittedSize*: DWORD
    dwUnCommittedSize*: DWORD
    lpFirstBlock*: LPVOID
    lpLastBlock*: LPVOID
    hMem*: HANDLE

  LPPROCESS_HEAP_ENTRY* = ptr PROCESS_HEAPENTRY
  TPROCESSHEAPENTRY* = PROCESS_HEAPENTRY
  PPROCESSHEAPENTRY* = ptr PROCESS_HEAPENTRY
  PROCESS_INFORMATION* {.final, pure.} = object
    hProcess*: HANDLE
    hThread*: HANDLE
    dwProcessId*: DWORD
    dwThreadId*: DWORD

  LPPROCESS_INFORMATION* = ptr PROCESS_INFORMATION
  TPROCESSINFORMATION* = PROCESS_INFORMATION
  PPROCESSINFORMATION* = ptr PROCESS_INFORMATION
  LPFNPSPCALLBACK* = proc (para1: HWND, para2: UINT, para3: LPVOID): UINT{.
      stdcall.}
  TFNPSPCALLBACK* = LPFNPSPCALLBACK
  PROPSHEETPAGE* {.final, pure.} = object
    dwSize*: DWORD
    dwFlags*: DWORD
    hInstance*: HINST
    pszIcon*: LPCTSTR
    pszTitle*: LPCTSTR
    pfnDlgProc*: DLGPROC
    lParam*: LPARAM
    pfnCallback*: LPFNPSPCALLBACK
    pcRefParent*: ptr UINT

  LPPROPSHEETPAGE* = ptr PROPSHEETPAGE
  LPCPROPSHEETPAGE* = ptr PROPSHEETPAGE
  TPROPSHEETPAGE* = PROPSHEETPAGE
  PPROPSHEETPAGE* = ptr PROPSHEETPAGE
  emptyrecord* {.final, pure.} = object
  lpemptyrecord* = ptr emptyrecord
  HPROPSHEETPAGE* = ptr emptyrecord
  PROPSHEETHEADER* {.final, pure.} = object
    dwSize*: DWORD
    dwFlags*: DWORD
    hwndParent*: HWND
    hInstance*: HINST
    pszIcon*: LPCTSTR
    pszCaption*: LPCTSTR
    nPages*: UINT
    pStartPage*: LPCTSTR
    phpage*: ptr HPROPSHEETPAGE
    pfnCallback*: PFNPROPSHEETCALLBACK
    pszbmWatermark*: LPCTSTR
    hplWatermark*: HPALETTE
    pszbmHeader*: cstring

  LPPROPSHEETHEADER* = ptr PROPSHEETHEADER
  LPCPROPSHEETHEADER* = ptr PROPSHEETHEADER
  TPROPSHEETHEADER* = PROPSHEETHEADER
  PPROPSHEETHEADER* = ptr PROPSHEETHEADER
  # PropertySheet callbacks
  LPFNADDPROPSHEETPAGE* = proc (para1: HPROPSHEETPAGE, para2: LPARAM): WINBOOL{.
      stdcall.}
  TFNADDPROPSHEETPAGE* = LPFNADDPROPSHEETPAGE
  LPFNADDPROPSHEETPAGES* = proc (para1: LPVOID, para2: LPFNADDPROPSHEETPAGE,
                                 para3: LPARAM): WINBOOL{.stdcall.}
  TFNADDPROPSHEETPAGES* = LPFNADDPROPSHEETPAGES
  PROTOCOL_INFO* {.final, pure.} = object
    dwServiceFlags*: DWORD
    iAddressFamily*: WINT
    iMaxSockAddr*: WINT
    iMinSockAddr*: WINT
    iSocketType*: WINT
    iProtocol*: WINT
    dwMessageSize*: DWORD
    lpProtocol*: LPTSTR

  TPROTOCOLINFO* = PROTOCOL_INFO
  PPROTOCOLINFO* = ptr PROTOCOL_INFO
  PROVIDOR_INFO_1* {.final, pure.} = object
    pName*: LPTSTR
    pEnvironment*: LPTSTR
    pDLLName*: LPTSTR

  TPROVIDORINFO1* = PROVIDOR_INFO_1
  PPROVIDORINFO1* = ptr PROVIDOR_INFO_1
  PSHNOTIFY* {.final, pure.} = object
    hdr*: NMHDR
    lParam*: LPARAM

  LPPSHNOTIFY* = ptr PSHNOTIFY
  TPSHNOTIFY* = PSHNOTIFY
  PPSHNOTIFY* = ptr PSHNOTIFY
  PUNCTUATION* {.final, pure.} = object
    iSize*: UINT
    szPunctuation*: LPSTR

  Tpunctuation* = PUNCTUATION
  Ppunctuation* = ptr PUNCTUATION
  TQUERY_SERVICE_CONFIG* {.final, pure.} = object
    dwServiceType*: DWORD
    dwStartType*: DWORD
    dwErrorControl*: DWORD
    lpBinaryPathName*: LPTSTR
    lpLoadOrderGroup*: LPTSTR
    dwTagId*: DWORD
    lpDependencies*: LPTSTR
    lpServiceStartName*: LPTSTR
    lpDisplayName*: LPTSTR

  LPQUERY_SERVICE_CONFIG* = ptr TQUERY_SERVICE_CONFIG
  PQUERYSERVICECONFIG* = ptr TQUERY_SERVICE_CONFIG
  TQUERY_SERVICE_LOCK_STATUS* {.final, pure.} = object
    fIsLocked*: DWORD
    lpLockOwner*: LPTSTR
    dwLockDuration*: DWORD

  LPQUERY_SERVICE_LOCK_STATUS* = ptr TQUERY_SERVICE_LOCK_STATUS
  PQUERYSERVICELOCKSTATUS* = ptr TQUERY_SERVICE_LOCK_STATUS
  RASAMB* {.final, pure.} = object
    dwSize*: DWORD
    dwError*: DWORD
    szNetBiosError*: array[0..(NETBIOS_NAME_LEN + 1) - 1, TCHAR]
    bLana*: int8

  TRASAMB* = RASAMB
  PRASAMB* = ptr RASAMB
  RASCONN* {.final, pure.} = object
    dwSize*: DWORD
    hrasconn*: HRASCONN
    szEntryName*: array[0..(RAS_MaxEntryName + 1) - 1, TCHAR]
    szDeviceType*: array[0..(RAS_MaxDeviceType + 1) - 1, CHAR]
    szDeviceName*: array[0..(RAS_MaxDeviceName + 1) - 1, CHAR]

  TRASCONN* = RASCONN
  PRASCONN* = ptr RASCONN
  RASCONNSTATUS* {.final, pure.} = object
    dwSize*: DWORD
    rasconnstate*: RASCONNSTATE
    dwError*: DWORD
    szDeviceType*: array[0..(RAS_MaxDeviceType + 1) - 1, TCHAR]
    szDeviceName*: array[0..(RAS_MaxDeviceName + 1) - 1, TCHAR]

  TRASCONNSTATUS* = RASCONNSTATUS
  PRASCONNSTATUS* = ptr RASCONNSTATUS
  RASDIALEXTENSIONS* {.final, pure.} = object
    dwSize*: DWORD
    dwfOptions*: DWORD
    hwndParent*: HWND
    reserved*: DWORD

  TRASDIALEXTENSIONS* = RASDIALEXTENSIONS
  PRASDIALEXTENSIONS* = ptr RASDIALEXTENSIONS
  RASDIALPARAMS* {.final, pure.} = object
    dwSize*: DWORD
    szEntryName*: array[0..(RAS_MaxEntryName + 1) - 1, TCHAR]
    szPhoneNumber*: array[0..(RAS_MaxPhoneNumber + 1) - 1, TCHAR]
    szCallbackNumber*: array[0..(RAS_MaxCallbackNumber + 1) - 1, TCHAR]
    szUserName*: array[0..(UNLEN + 1) - 1, TCHAR]
    szPassword*: array[0..(PWLEN + 1) - 1, TCHAR]
    szDomain*: array[0..(DNLEN + 1) - 1, TCHAR]

  TRASDIALPARAMS* = RASDIALPARAMS
  PRASDIALPARAMS* = ptr RASDIALPARAMS
  RASENTRYNAME* {.final, pure.} = object
    dwSize*: DWORD
    szEntryName*: array[0..(RAS_MaxEntryName + 1) - 1, TCHAR]

  TRASENTRYNAME* = RASENTRYNAME
  PRASENTRYNAME* = ptr RASENTRYNAME
  RASPPPIP* {.final, pure.} = object
    dwSize*: DWORD
    dwError*: DWORD
    szIpAddress*: array[0..(RAS_MaxIpAddress + 1) - 1, TCHAR]

  TRASPPPIP* = RASPPPIP
  PRASPPPIP* = ptr RASPPPIP
  RASPPPIPX* {.final, pure.} = object
    dwSize*: DWORD
    dwError*: DWORD
    szIpxAddress*: array[0..(RAS_MaxIpxAddress + 1) - 1, TCHAR]

  TRASPPPIPX* = RASPPPIPX
  PRASPPPIPX* = ptr RASPPPIPX
  RASPPPNBF* {.final, pure.} = object
    dwSize*: DWORD
    dwError*: DWORD
    dwNetBiosError*: DWORD
    szNetBiosError*: array[0..(NETBIOS_NAME_LEN + 1) - 1, TCHAR]
    szWorkstationName*: array[0..(NETBIOS_NAME_LEN + 1) - 1, TCHAR]
    bLana*: int8

  TRASPPPNBF* = RASPPPNBF
  PRASPPPNBF* = ptr RASPPPNBF
  RASTERIZER_STATUS* {.final, pure.} = object
    nSize*: short
    wFlags*: short
    nLanguageID*: short

  LPRASTERIZER_STATUS* = ptr RASTERIZER_STATUS
  TRASTERIZERSTATUS* = RASTERIZER_STATUS
  PRASTERIZERSTATUS* = ptr RASTERIZER_STATUS
  REASSIGN_BLOCKS* {.final, pure.} = object
    Reserved*: int16
    Count*: int16
    BlockNumber*: array[0..0, DWORD]

  TREASSIGNBLOCKS* = REASSIGN_BLOCKS
  PREASSIGNBLOCKS* = ptr REASSIGN_BLOCKS
  REMOTE_NAME_INFO* {.final, pure.} = object
    lpUniversalName*: LPTSTR
    lpConnectionName*: LPTSTR
    lpRemainingPath*: LPTSTR

  TREMOTENAMEINFO* = REMOTE_NAME_INFO
  PREMOTENAMEINFO* = ptr REMOTE_NAME_INFO

  REPASTESPECIAL* {.final, pure.} = object
    dwAspect*: DWORD
    dwParam*: DWORD

  Trepastespecial* = REPASTESPECIAL
  Prepastespecial* = ptr REPASTESPECIAL
  REQRESIZE* {.final, pure.} = object
    nmhdr*: NMHDR
    rc*: RECT

  Treqresize* = REQRESIZE
  Preqresize* = ptr REQRESIZE
  RGNDATAHEADER* {.final, pure.} = object
    dwSize*: DWORD
    iType*: DWORD
    nCount*: DWORD
    nRgnSize*: DWORD
    rcBound*: RECT

  TRGNDATAHEADER* = RGNDATAHEADER
  PRGNDATAHEADER* = ptr RGNDATAHEADER
  RGNDATA* {.final, pure.} = object
    rdh*: RGNDATAHEADER
    Buffer*: array[0..0, char]

  LPRGNDATA* = ptr RGNDATA
  TRGNDATA* = RGNDATA
  PRGNDATA* = ptr RGNDATA
  SCROLLINFO* {.final, pure.} = object
    cbSize*: UINT
    fMask*: UINT
    nMin*: int32
    nMax*: int32
    nPage*: UINT
    nPos*: int32
    nTrackPos*: int32

  LPSCROLLINFO* = ptr SCROLLINFO
  LPCSCROLLINFO* = ptr SCROLLINFO
  TSCROLLINFO* = SCROLLINFO
  PSCROLLINFO* = ptr SCROLLINFO
  SECURITY_ATTRIBUTES* {.final, pure.} = object
    nLength*: DWORD
    lpSecurityDescriptor*: LPVOID
    bInheritHandle*: WINBOOL

  LPSECURITY_ATTRIBUTES* = ptr SECURITY_ATTRIBUTES
  TSECURITYATTRIBUTES* = SECURITY_ATTRIBUTES
  PSECURITYATTRIBUTES* = ptr SECURITY_ATTRIBUTES
  SECURITY_INFORMATION* = DWORD
  PSECURITY_INFORMATION* = ptr SECURITY_INFORMATION
  TSECURITYINFORMATION* = SECURITY_INFORMATION
  SELCHANGE* {.final, pure.} = object
    nmhdr*: NMHDR
    chrg*: CHARRANGE
    seltyp*: int16

  Tselchange* = SELCHANGE
  Pselchange* = ptr SELCHANGE
  SERIALKEYS* {.final, pure.} = object
    cbSize*: DWORD
    dwFlags*: DWORD
    lpszActivePort*: LPSTR
    lpszPort*: LPSTR
    iBaudRate*: DWORD
    iPortState*: DWORD

  LPSERIALKEYS* = ptr SERIALKEYS
  TSERIALKEYS* = SERIALKEYS
  PSERIALKEYS* = ptr SERIALKEYS
  SERVICE_TABLE_ENTRY* {.final, pure.} = object
    lpServiceName*: LPTSTR
    lpServiceProc*: LPSERVICE_MAIN_FUNCTION

  LPSERVICE_TABLE_ENTRY* = ptr SERVICE_TABLE_ENTRY
  TSERVICETABLEENTRY* = SERVICE_TABLE_ENTRY
  PSERVICETABLEENTRY* = ptr SERVICE_TABLE_ENTRY
  SERVICE_TYPE_VALUE_ABS* {.final, pure.} = object
    dwNameSpace*: DWORD
    dwValueType*: DWORD
    dwValueSize*: DWORD
    lpValueName*: LPTSTR
    lpValue*: PVOID

  TSERVICETYPEVALUEABS* = SERVICE_TYPE_VALUE_ABS
  PSERVICETYPEVALUEABS* = ptr SERVICE_TYPE_VALUE_ABS
  SERVICE_TYPE_INFO_ABS* {.final, pure.} = object
    lpTypeName*: LPTSTR
    dwValueCount*: DWORD
    Values*: array[0..0, SERVICE_TYPE_VALUE_ABS]

  TSERVICETYPEINFOABS* = SERVICE_TYPE_INFO_ABS
  PSERVICETYPEINFOABS* = ptr SERVICE_TYPE_INFO_ABS
  SESSION_BUFFER* {.final, pure.} = object
    lsn*: UCHAR
    state*: UCHAR
    local_name*: array[0..(NCBNAMSZ) - 1, UCHAR]
    remote_name*: array[0..(NCBNAMSZ) - 1, UCHAR]
    rcvs_outstanding*: UCHAR
    sends_outstanding*: UCHAR

  TSESSIONBUFFER* = SESSION_BUFFER
  PSESSIONBUFFER* = ptr SESSION_BUFFER
  SESSION_HEADER* {.final, pure.} = object
    sess_name*: UCHAR
    num_sess*: UCHAR
    rcv_dg_outstanding*: UCHAR
    rcv_any_outstanding*: UCHAR

  TSESSIONHEADER* = SESSION_HEADER
  PSESSIONHEADER* = ptr SESSION_HEADER
  SET_PARTITION_INFORMATION* {.final, pure.} = object
    PartitionType*: int8

  TSETPARTITIONINFORMATION* = SET_PARTITION_INFORMATION
  PSETPARTITIONINFORMATION* = ptr SET_PARTITION_INFORMATION
  SHCONTF* = enum
    SHCONTF_FOLDERS = 32, SHCONTF_NONFOLDERS = 64, SHCONTF_INCLUDEHIDDEN = 128
  TSHCONTF* = SHCONTF
  SHFILEINFO* {.final, pure.} = object
    hIcon*: HICON
    iIcon*: int32
    dwAttributes*: DWORD
    szDisplayName*: array[0..(MAX_PATH) - 1, char]
    szTypeName*: array[0..79, char]

  TSHFILEINFO* = SHFILEINFO
  PSHFILEINFO* = ptr SHFILEINFO
  FILEOP_FLAGS* = int16
  TFILEOPFLAGS* = FILEOP_FLAGS
  PFILEOPFLAGS* = ptr FILEOP_FLAGS
  SHFILEOPSTRUCT* {.final, pure.} = object
    hwnd*: HWND
    wFunc*: UINT
    pFrom*: LPCSTR
    pTo*: LPCSTR
    fFlags*: FILEOP_FLAGS
    fAnyOperationsAborted*: WINBOOL
    hNameMappings*: LPVOID
    lpszProgressTitle*: LPCSTR

  LPSHFILEOPSTRUCT* = ptr SHFILEOPSTRUCT
  TSHFILEOPSTRUCT* = SHFILEOPSTRUCT
  PSHFILEOPSTRUCT* = ptr SHFILEOPSTRUCT
  SHGNO* = enum
    SHGDN_NORMAL = 0, SHGDN_INFOLDER = 1, SHGDN_FORPARSING = 0x00008000
  TSHGDN* = SHGNO
  SHNAMEMAPPING* {.final, pure.} = object
    pszOldPath*: LPSTR
    pszNewPath*: LPSTR
    cchOldPath*: int32
    cchNewPath*: int32

  LPSHNAMEMAPPING* = ptr SHNAMEMAPPING
  TSHNAMEMAPPING* = SHNAMEMAPPING
  PSHNAMEMAPPING* = ptr SHNAMEMAPPING
  SID_AND_ATTRIBUTES* {.final, pure.} = object
    Sid*: PSID
    Attributes*: DWORD

  TSIDANDATTRIBUTES* = SID_AND_ATTRIBUTES
  PSIDANDATTRIBUTES* = ptr SID_AND_ATTRIBUTES
  SID_AND_ATTRIBUTES_ARRAY* = array[0..(ANYSIZE_ARRAY) - 1, SID_AND_ATTRIBUTES]
  PSID_AND_ATTRIBUTES_ARRAY* = ptr SID_AND_ATTRIBUTES_ARRAY
  TSIDANDATTRIBUTESARRAY* = SID_AND_ATTRIBUTES_ARRAY
  SINGLE_LIST_ENTRY* {.final, pure.} = object
    Next*: ptr SINGLE_LIST_ENTRY

  TSINGLELISTENTRY* = SINGLE_LIST_ENTRY
  PSINGLELISTENTRY* = ptr SINGLE_LIST_ENTRY
  SOUNDSENTRY* {.final, pure.} = object
    cbSize*: UINT
    dwFlags*: DWORD
    iFSTextEffect*: DWORD
    iFSTextEffectMSec*: DWORD
    iFSTextEffectColorBits*: DWORD
    iFSGrafEffect*: DWORD
    iFSGrafEffectMSec*: DWORD
    iFSGrafEffectColor*: DWORD
    iWindowsEffect*: DWORD
    iWindowsEffectMSec*: DWORD
    lpszWindowsEffectDLL*: LPTSTR
    iWindowsEffectOrdinal*: DWORD

  LPSOUNDSENTRY* = ptr SOUNDSENTRY
  TSOUNDSENTRY* = SOUNDSENTRY
  PSOUNDSENTRY* = ptr SOUNDSENTRY
  STARTUPINFO* {.final, pure.} = object
    cb*: DWORD
    lpReserved*: LPTSTR
    lpDesktop*: LPTSTR
    lpTitle*: LPTSTR
    dwX*: DWORD
    dwY*: DWORD
    dwXSize*: DWORD
    dwYSize*: DWORD
    dwXCountChars*: DWORD
    dwYCountChars*: DWORD
    dwFillAttribute*: DWORD
    dwFlags*: DWORD
    wShowWindow*: int16
    cbReserved2*: int16
    lpReserved2*: LPBYTE
    hStdInput*: HANDLE
    hStdOutput*: HANDLE
    hStdError*: HANDLE

  LPSTARTUPINFO* = ptr STARTUPINFO
  TSTARTUPINFO* = STARTUPINFO
  PSTARTUPINFO* = ptr STARTUPINFO
  STICKYKEYS* {.final, pure.} = object
    cbSize*: DWORD
    dwFlags*: DWORD

  LPSTICKYKEYS* = ptr STICKYKEYS
  TSTICKYKEYS* = STICKYKEYS
  PSTICKYKEYS* = ptr STICKYKEYS
  STRRET* {.final, pure.} = object
    uType*: UINT
    cStr*: array[0..(MAX_PATH) - 1, char]

  LPSTRRET* = ptr STRRET
  TSTRRET* = STRRET
  PSTRRET* = ptr STRRET
  STYLEBUF* {.final, pure.} = object
    dwStyle*: DWORD
    szDescription*: array[0..31, CHAR]

  LPSTYLEBUF* = ptr STYLEBUF
  TSTYLEBUF* = STYLEBUF
  PSTYLEBUF* = ptr STYLEBUF
  STYLESTRUCT* {.final, pure.} = object
    styleOld*: DWORD
    styleNew*: DWORD

  LPSTYLESTRUCT* = ptr STYLESTRUCT
  TSTYLESTRUCT* = STYLESTRUCT
  PSTYLESTRUCT* = ptr STYLESTRUCT
  SYSTEM_AUDIT_ACE* {.final, pure.} = object
    Header*: ACE_HEADER
    Mask*: ACCESS_MASK
    SidStart*: DWORD

  TSYSTEMAUDITACE* = SYSTEM_AUDIT_ACE
  PSYSTEMAUDITACE* = ptr SYSTEM_AUDIT_ACE
  SYSTEM_INFO* {.final, pure.} = object
    dwOemId*: DWORD
    dwPageSize*: DWORD
    lpMinimumApplicationAddress*: LPVOID
    lpMaximumApplicationAddress*: LPVOID
    dwActiveProcessorMask*: DWORD
    dwNumberOfProcessors*: DWORD
    dwProcessorType*: DWORD
    dwAllocationGranularity*: DWORD
    wProcessorLevel*: int16
    wProcessorRevision*: int16

  LPSYSTEM_INFO* = ptr SYSTEM_INFO
  TSYSTEMINFO* = SYSTEM_INFO
  PSYSTEMINFO* = ptr SYSTEM_INFO
  SYSTEM_POWER_STATUS* {.final, pure.} = object
    ACLineStatus*: int8
    BatteryFlag*: int8
    BatteryLifePercent*: int8
    Reserved1*: int8
    BatteryLifeTime*: DWORD
    BatteryFullLifeTime*: DWORD

  TSYSTEMPOWERSTATUS* = SYSTEM_POWER_STATUS
  PSYSTEMPOWERSTATUS* = ptr SYSTEM_POWER_STATUS
  LPSYSTEM_POWER_STATUS* = ptr emptyrecord
  TAPE_ERASE* {.final, pure.} = object
    `type`*: ULONG

  TTAPEERASE* = TAPE_ERASE
  PTAPEERASE* = ptr TAPE_ERASE
  TAPE_GET_DRIVE_PARAMETERS* {.final, pure.} = object
    ECC*: bool
    Compression*: bool
    DataPadding*: bool
    ReportSetmarks*: bool
    DefaultBlockSize*: ULONG
    MaximumBlockSize*: ULONG
    MinimumBlockSize*: ULONG
    MaximumPartitionCount*: ULONG
    FeaturesLow*: ULONG
    FeaturesHigh*: ULONG
    EOTWarningZoneSize*: ULONG

  TTAPEGETDRIVEPARAMETERS* = TAPE_GET_DRIVE_PARAMETERS
  PTAPEGETDRIVEPARAMETERS* = ptr TAPE_GET_DRIVE_PARAMETERS
  TAPE_GET_MEDIA_PARAMETERS* {.final, pure.} = object
    Capacity*: LARGE_INTEGER
    Remaining*: LARGE_INTEGER
    BlockSize*: DWORD
    PartitionCount*: DWORD
    WriteProtected*: bool

  TTAPEGETMEDIAPARAMETERS* = TAPE_GET_MEDIA_PARAMETERS
  PTAPEGETMEDIAPARAMETERS* = ptr TAPE_GET_MEDIA_PARAMETERS
  TAPE_GET_POSITION* {.final, pure.} = object
    `type`*: ULONG
    Partition*: ULONG
    OffsetLow*: ULONG
    OffsetHigh*: ULONG

  TTAPEGETPOSITION* = TAPE_GET_POSITION
  PTAPEGETPOSITION* = ptr TAPE_GET_POSITION
  TAPE_PREPARE* {.final, pure.} = object
    Operation*: ULONG

  TTAPEPREPARE* = TAPE_PREPARE
  PTAPEPREPARE* = ptr TAPE_PREPARE
  TAPE_SET_DRIVE_PARAMETERS* {.final, pure.} = object
    ECC*: bool
    Compression*: bool
    DataPadding*: bool
    ReportSetmarks*: bool
    EOTWarningZoneSize*: ULONG

  TTAPESETDRIVEPARAMETERS* = TAPE_SET_DRIVE_PARAMETERS
  PTAPESETDRIVEPARAMETERS* = ptr TAPE_SET_DRIVE_PARAMETERS
  TAPE_SET_MEDIA_PARAMETERS* {.final, pure.} = object
    BlockSize*: ULONG

  TTAPESETMEDIAPARAMETERS* = TAPE_SET_MEDIA_PARAMETERS
  PTAPESETMEDIAPARAMETERS* = ptr TAPE_SET_MEDIA_PARAMETERS
  TAPE_SET_POSITION* {.final, pure.} = object
    `Method`*: ULONG
    Partition*: ULONG
    OffsetLow*: ULONG
    OffsetHigh*: ULONG

  TTAPESETPOSITION* = TAPE_SET_POSITION
  PTAPESETPOSITION* = ptr TAPE_SET_POSITION
  TAPE_WRITE_MARKS* {.final, pure.} = object
    `type`*: ULONG
    Count*: ULONG

  TTAPEWRITEMARKS* = TAPE_WRITE_MARKS
  PTAPEWRITEMARKS* = ptr TAPE_WRITE_MARKS
  TTBADDBITMAP* {.final, pure.} = object
    hInst*: HINST
    nID*: UINT

  LPTBADDBITMAP* = ptr TTBADDBITMAP
  PTBADDBITMAP* = ptr TTBADDBITMAP
  TBBUTTON* {.final, pure.} = object
    iBitmap*: int32
    idCommand*: int32
    fsState*: int8
    fsStyle*: int8
    dwData*: DWORD
    iString*: int32

  LPTBBUTTON* = ptr TBBUTTON
  LPCTBBUTTON* = ptr TBBUTTON
  TTBBUTTON* = TBBUTTON
  PTBBUTTON* = ptr TBBUTTON
  TBNOTIFY* {.final, pure.} = object
    hdr*: NMHDR
    iItem*: int32
    tbButton*: TBBUTTON
    cchText*: int32
    pszText*: LPTSTR

  LPTBNOTIFY* = ptr TBNOTIFY
  TTBNOTIFY* = TBNOTIFY
  PTBNOTIFY* = ptr TBNOTIFY
  TBSAVEPARAMS* {.final, pure.} = object
    hkr*: HKEY
    pszSubKey*: LPCTSTR
    pszValueName*: LPCTSTR

  TTBSAVEPARAMS* = TBSAVEPARAMS
  PTBSAVEPARAMS* = ptr TBSAVEPARAMS
  TC_HITTESTINFO* {.final, pure.} = object
    pt*: POINT
    flags*: UINT

  TTCHITTESTINFO* = TC_HITTESTINFO
  PTCHITTESTINFO* = ptr TC_HITTESTINFO
  TC_ITEM* {.final, pure.} = object
    mask*: UINT
    lpReserved1*: UINT
    lpReserved2*: UINT
    pszText*: LPTSTR
    cchTextMax*: int32
    iImage*: int32
    lParam*: LPARAM

  TTCITEM* = TC_ITEM
  PTCITEM* = ptr TC_ITEM
  TC_ITEMHEADER* {.final, pure.} = object
    mask*: UINT
    lpReserved1*: UINT
    lpReserved2*: UINT
    pszText*: LPTSTR
    cchTextMax*: int32
    iImage*: int32

  TTCITEMHEADER* = TC_ITEMHEADER
  PTCITEMHEADER* = ptr TC_ITEMHEADER
  TC_KEYDOWN* {.final, pure.} = object
    hdr*: NMHDR
    wVKey*: int16
    flags*: UINT

  TTCKEYDOWN* = TC_KEYDOWN
  PTCKEYDOWN* = ptr TC_KEYDOWN
  TEXTRANGE* {.final, pure.} = object
    chrg*: CHARRANGE
    lpstrText*: LPSTR

  Ttextrange* = TEXTRANGE
  Ptextrange* = ptr TEXTRANGE
  TIME_ZONE_INFORMATION* {.final, pure.} = object
    Bias*: LONG
    StandardName*: array[0..31, WCHAR]
    StandardDate*: SYSTEMTIME
    StandardBias*: LONG
    DaylightName*: array[0..31, WCHAR]
    DaylightDate*: SYSTEMTIME
    DaylightBias*: LONG

  LPTIME_ZONE_INFORMATION* = ptr TIME_ZONE_INFORMATION
  TTIMEZONEINFORMATION* = TIME_ZONE_INFORMATION
  PTIMEZONEINFORMATION* = ptr TIME_ZONE_INFORMATION
  TOGGLEKEYS* {.final, pure.} = object
    cbSize*: DWORD
    dwFlags*: DWORD

  TTOGGLEKEYS* = TOGGLEKEYS
  PTOGGLEKEYS* = ptr TOGGLEKEYS
  TTOKEN_SOURCE* {.final, pure.} = object
    SourceName*: array[0..7, CHAR]
    SourceIdentifier*: LUID

  PTOKENSOURCE* = ptr TTOKEN_SOURCE
  TOKEN_CONTROL* {.final, pure.} = object
    TokenId*: LUID
    AuthenticationId*: LUID
    ModifiedId*: LUID
    TokenSource*: TTOKEN_SOURCE

  TTOKENCONTROL* = TOKEN_CONTROL
  PTOKENCONTROL* = ptr TOKEN_CONTROL
  TTOKEN_DEFAULT_DACL* {.final, pure.} = object
    DefaultDacl*: PACL

  PTOKENDEFAULTDACL* = ptr TTOKEN_DEFAULT_DACL
  TTOKEN_GROUPS* {.final, pure.} = object
    GroupCount*: DWORD
    Groups*: array[0..(ANYSIZE_ARRAY) - 1, SID_AND_ATTRIBUTES]

  LPTOKEN_GROUPS* = ptr TTOKEN_GROUPS
  PTOKENGROUPS* = ptr TTOKEN_GROUPS
  TTOKEN_OWNER* {.final, pure.} = object
    Owner*: PSID

  PTOKENOWNER* = ptr TTOKEN_OWNER
  TTOKEN_PRIMARY_GROUP* {.final, pure.} = object
    PrimaryGroup*: PSID

  PTOKENPRIMARYGROUP* = ptr TTOKEN_PRIMARY_GROUP
  TTOKEN_PRIVILEGES* {.final, pure.} = object
    PrivilegeCount*: DWORD
    Privileges*: array[0..(ANYSIZE_ARRAY) - 1, LUID_AND_ATTRIBUTES]

  PTOKEN_PRIVILEGES* = ptr TTOKEN_PRIVILEGES
  LPTOKEN_PRIVILEGES* = ptr TTOKEN_PRIVILEGES
  TTOKEN_STATISTICS* {.final, pure.} = object
    TokenId*: LUID
    AuthenticationId*: LUID
    ExpirationTime*: LARGE_INTEGER
    TokenType*: TTOKEN_TYPE
    ImpersonationLevel*: SECURITY_IMPERSONATION_LEVEL
    DynamicCharged*: DWORD
    DynamicAvailable*: DWORD
    GroupCount*: DWORD
    PrivilegeCount*: DWORD
    ModifiedId*: LUID

  PTOKENSTATISTICS* = ptr TTOKEN_STATISTICS
  TTOKEN_USER* {.final, pure.} = object
    User*: SID_AND_ATTRIBUTES

  PTOKENUSER* = ptr TTOKEN_USER
  TOOLINFO* {.final, pure.} = object
    cbSize*: UINT
    uFlags*: UINT
    hwnd*: HWND
    uId*: UINT
    rect*: RECT
    hinst*: HINST
    lpszText*: LPTSTR

  LPTOOLINFO* = ptr TOOLINFO
  TTOOLINFO* = TOOLINFO
  PTOOLINFO* = ptr TOOLINFO
  TOOLTIPTEXT* {.final, pure.} = object
    hdr*: NMHDR
    lpszText*: LPTSTR
    szText*: array[0..79, char]
    hinst*: HINST
    uFlags*: UINT

  LPTOOLTIPTEXT* = ptr TOOLTIPTEXT
  TTOOLTIPTEXT* = TOOLTIPTEXT
  PTOOLTIPTEXT* = ptr TOOLTIPTEXT
  TPMPARAMS* {.final, pure.} = object
    cbSize*: UINT
    rcExclude*: RECT

  LPTPMPARAMS* = ptr TPMPARAMS
  TTPMPARAMS* = TPMPARAMS
  PTPMPARAMS* = ptr TPMPARAMS
  TRANSMIT_FILE_BUFFERS* {.final, pure.} = object
    Head*: PVOID
    HeadLength*: DWORD
    Tail*: PVOID
    TailLength*: DWORD

  TTRANSMITFILEBUFFERS* = TRANSMIT_FILE_BUFFERS
  PTRANSMITFILEBUFFERS* = ptr TRANSMIT_FILE_BUFFERS
  TTHITTESTINFO* {.final, pure.} = object
    hwnd*: HWND
    pt*: POINT
    ti*: TOOLINFO

  LPHITTESTINFO* = ptr TTHITTESTINFO
  TTTHITTESTINFO* = TTHITTESTINFO
  PTTHITTESTINFO* = ptr TTHITTESTINFO
  TTPOLYCURVE* {.final, pure.} = object
    wType*: int16
    cpfx*: int16
    apfx*: array[0..0, POINTFX]

  LPTTPOLYCURVE* = ptr TTPOLYCURVE
  TTTPOLYCURVE* = TTPOLYCURVE
  PTTPOLYCURVE* = ptr TTPOLYCURVE
  TTPOLYGONHEADER* {.final, pure.} = object
    cb*: DWORD
    dwType*: DWORD
    pfxStart*: POINTFX

  LPTTPOLYGONHEADER* = ptr TTPOLYGONHEADER
  TTTPOLYGONHEADER* = TTPOLYGONHEADER
  PTTPOLYGONHEADER* = ptr TTPOLYGONHEADER
  TV_DISPINFO* {.final, pure.} = object
    hdr*: NMHDR
    item*: TV_ITEM

  TTVDISPINFO* = TV_DISPINFO
  PTVDISPINFO* = ptr TV_DISPINFO
  TV_HITTESTINFO* {.final, pure.} = object
    pt*: POINT
    flags*: UINT
    hItem*: HTREEITEM

  LPTV_HITTESTINFO* = ptr TV_HITTESTINFO
  TTVHITTESTINFO* = TV_HITTESTINFO
  PTVHITTESTINFO* = ptr TV_HITTESTINFO
  TV_INSERTSTRUCT* {.final, pure.} = object
    hParent*: HTREEITEM
    hInsertAfter*: HTREEITEM
    item*: TV_ITEM

  LPTV_INSERTSTRUCT* = ptr TV_INSERTSTRUCT
  TTVINSERTSTRUCT* = TV_INSERTSTRUCT
  PTVINSERTSTRUCT* = ptr TV_INSERTSTRUCT
  TV_KEYDOWN* {.final, pure.} = object
    hdr*: NMHDR
    wVKey*: int16
    flags*: UINT

  TTVKEYDOWN* = TV_KEYDOWN
  PTVKEYDOWN* = ptr TV_KEYDOWN
  TV_SORTCB* {.final, pure.} = object
    hParent*: HTREEITEM
    lpfnCompare*: PFNTVCOMPARE
    lParam*: LPARAM

  LPTV_SORTCB* = ptr TV_SORTCB
  TTVSORTCB* = TV_SORTCB
  PTVSORTCB* = ptr TV_SORTCB
  UDACCEL* {.final, pure.} = object
    nSec*: UINT
    nInc*: UINT

  TUDACCEL* = UDACCEL
  PUDACCEL* = ptr UDACCEL
  UNIVERSAL_NAME_INFO* {.final, pure.} = object
    lpUniversalName*: LPTSTR

  TUNIVERSALNAMEINFO* = UNIVERSAL_NAME_INFO
  PUNIVERSALNAMEINFO* = ptr UNIVERSAL_NAME_INFO
  USEROBJECTFLAGS* {.final, pure.} = object
    fInherit*: WINBOOL
    fReserved*: WINBOOL
    dwFlags*: DWORD

  TUSEROBJECTFLAGS* = USEROBJECTFLAGS
  PUSEROBJECTFLAGS* = ptr USEROBJECTFLAGS
  VALENT* {.final, pure.} = object
    ve_valuename*: LPTSTR
    ve_valuelen*: DWORD
    ve_valueptr*: DWORD
    ve_type*: DWORD

  TVALENT* = VALENT
  PVALENT* = ptr VALENT
  value_ent* = VALENT
  Tvalue_ent* = VALENT
  Pvalue_ent* = ptr VALENT
  VERIFY_INFORMATION* {.final, pure.} = object
    StartingOffset*: LARGE_INTEGER
    len*: DWORD

  TVERIFYINFORMATION* = VERIFY_INFORMATION
  PVERIFYINFORMATION* = ptr VERIFY_INFORMATION
  VS_FIXEDFILEINFO* {.final, pure.} = object
    dwSignature*: DWORD
    dwStrucVersion*: DWORD
    dwFileVersionMS*: DWORD
    dwFileVersionLS*: DWORD
    dwProductVersionMS*: DWORD
    dwProductVersionLS*: DWORD
    dwFileFlagsMask*: DWORD
    dwFileFlags*: DWORD
    dwFileOS*: DWORD
    dwFileType*: DWORD
    dwFileSubtype*: DWORD
    dwFileDateMS*: DWORD
    dwFileDateLS*: DWORD

  TVSFIXEDFILEINFO* = VS_FIXEDFILEINFO
  PVSFIXEDFILEINFO* = ptr VS_FIXEDFILEINFO
  WIN32_FIND_DATA* {.final, pure.} = object
    dwFileAttributes*: DWORD
    ftCreationTime*: FILETIME
    ftLastAccessTime*: FILETIME
    ftLastWriteTime*: FILETIME
    nFileSizeHigh*: DWORD
    nFileSizeLow*: DWORD
    dwReserved0*: DWORD
    dwReserved1*: DWORD
    cFileName*: array[0..(MAX_PATH) - 1, TCHAR]
    cAlternateFileName*: array[0..13, TCHAR]

  LPWIN32_FIND_DATA* = ptr WIN32_FIND_DATA
  PWIN32_FIND_DATA* = ptr WIN32_FIND_DATA
  TWIN32FINDDATA* = WIN32_FIND_DATA
  TWIN32FINDDATAA* = WIN32_FIND_DATA
  WIN32_FIND_DATAW* {.final, pure.} = object
    dwFileAttributes*: DWORD
    ftCreationTime*: FILETIME
    ftLastAccessTime*: FILETIME
    ftLastWriteTime*: FILETIME
    nFileSizeHigh*: DWORD
    nFileSizeLow*: DWORD
    dwReserved0*: DWORD
    dwReserved1*: DWORD
    cFileName*: array[0..(MAX_PATH) - 1, WCHAR]
    cAlternateFileName*: array[0..13, WCHAR]

  LPWIN32_FIND_DATAW* = ptr WIN32_FIND_DATAW
  PWIN32_FIND_DATAW* = ptr WIN32_FIND_DATAW
  TWIN32FINDDATAW* = WIN32_FIND_DATAW
  WIN32_STREAM_ID* {.final, pure.} = object
    dwStreamId*: DWORD
    dwStreamAttributes*: DWORD
    Size*: LARGE_INTEGER
    dwStreamNameSize*: DWORD
    cStreamName*: ptr WCHAR

  TWIN32STREAMID* = WIN32_STREAM_ID
  PWIN32STREAMID* = ptr WIN32_STREAM_ID
  WINDOWPLACEMENT* {.final, pure.} = object
    len*: UINT
    flags*: UINT
    showCmd*: UINT
    ptMinPosition*: POINT
    ptMaxPosition*: POINT
    rcNormalPosition*: RECT

  TWINDOWPLACEMENT* = WINDOWPLACEMENT
  PWINDOWPLACEMENT* = ptr WINDOWPLACEMENT
  WNDCLASS* {.final, pure.} = object
    style*: UINT
    lpfnWndProc*: WNDPROC
    cbClsExtra*: int32
    cbWndExtra*: int32
    hInstance*: HANDLE
    hIcon*: HICON
    hCursor*: HCURSOR
    hbrBackground*: HBRUSH
    lpszMenuName*: LPCTSTR
    lpszClassName*: LPCTSTR

  LPWNDCLASS* = ptr WNDCLASS
  TWNDCLASS* = WNDCLASS
  TWNDCLASSA* = WNDCLASS
  PWNDCLASS* = ptr WNDCLASS
  WNDCLASSW* {.final, pure.} = object
    style*: UINT
    lpfnWndProc*: WNDPROC
    cbClsExtra*: int32
    cbWndExtra*: int32
    hInstance*: HANDLE
    hIcon*: HICON
    hCursor*: HCURSOR
    hbrBackground*: HBRUSH
    lpszMenuName*: LPCWSTR
    lpszClassName*: LPCWSTR

  LPWNDCLASSW* = ptr WNDCLASSW
  TWNDCLASSW* = WNDCLASSW
  PWNDCLASSW* = ptr WNDCLASSW
  WNDCLASSEX* {.final, pure.} = object
    cbSize*: UINT
    style*: UINT
    lpfnWndProc*: WNDPROC
    cbClsExtra*: int32
    cbWndExtra*: int32
    hInstance*: HANDLE
    hIcon*: HICON
    hCursor*: HCURSOR
    hbrBackground*: HBRUSH
    lpszMenuName*: LPCTSTR
    lpszClassName*: LPCTSTR
    hIconSm*: HANDLE

  LPWNDCLASSEX* = ptr WNDCLASSEX
  TWNDCLASSEX* = WNDCLASSEX
  TWNDCLASSEXA* = WNDCLASSEX
  PWNDCLASSEX* = ptr WNDCLASSEX
  WNDCLASSEXW* {.final, pure.} = object
    cbSize*: UINT
    style*: UINT
    lpfnWndProc*: WNDPROC
    cbClsExtra*: int32
    cbWndExtra*: int32
    hInstance*: HANDLE
    hIcon*: HICON
    hCursor*: HCURSOR
    hbrBackground*: HBRUSH
    lpszMenuName*: LPCWSTR
    lpszClassName*: LPCWSTR
    hIconSm*: HANDLE

  LPWNDCLASSEXW* = ptr WNDCLASSEXW
  TWNDCLASSEXW* = WNDCLASSEXW
  PWNDCLASSEXW* = ptr WNDCLASSEXW
  CONNECTDLGSTRUCT* {.final, pure.} = object
    cbStructure*: DWORD
    hwndOwner*: HWND
    lpConnRes*: LPNETRESOURCE
    dwFlags*: DWORD
    dwDevNum*: DWORD

  LPCONNECTDLGSTRUCT* = ptr CONNECTDLGSTRUCT
  TCONNECTDLGSTRUCT* = CONNECTDLGSTRUCT
  PCONNECTDLGSTRUCT* = ptr CONNECTDLGSTRUCT
  DISCDLGSTRUCT* {.final, pure.} = object
    cbStructure*: DWORD
    hwndOwner*: HWND
    lpLocalName*: LPTSTR
    lpRemoteName*: LPTSTR
    dwFlags*: DWORD

  LPDISCDLGSTRUCT* = ptr DISCDLGSTRUCT
  TDISCDLGSTRUCT* = DISCDLGSTRUCT
  TDISCDLGSTRUCTA* = DISCDLGSTRUCT
  PDISCDLGSTRUCT* = ptr DISCDLGSTRUCT
  NETINFOSTRUCT* {.final, pure.} = object
    cbStructure*: DWORD
    dwProviderVersion*: DWORD
    dwStatus*: DWORD
    dwCharacteristics*: DWORD
    dwHandle*: DWORD
    wNetType*: int16
    dwPrinters*: DWORD
    dwDrives*: DWORD

  LPNETINFOSTRUCT* = ptr NETINFOSTRUCT
  TNETINFOSTRUCT* = NETINFOSTRUCT
  PNETINFOSTRUCT* = ptr NETINFOSTRUCT
  NETCONNECTINFOSTRUCT* {.final, pure.} = object
    cbStructure*: DWORD
    dwFlags*: DWORD
    dwSpeed*: DWORD
    dwDelay*: DWORD
    dwOptDataSize*: DWORD

  LPNETCONNECTINFOSTRUCT* = ptr NETCONNECTINFOSTRUCT
  TNETCONNECTINFOSTRUCT* = NETCONNECTINFOSTRUCT
  PNETCONNECTINFOSTRUCT* = ptr NETCONNECTINFOSTRUCT
  ENUMMETAFILEPROC* = proc (para1: HDC, para2: HANDLETABLE, para3: METARECORD,
                            para4: int32, para5: LPARAM): int32{.stdcall.}
  ENHMETAFILEPROC* = proc (para1: HDC, para2: HANDLETABLE, para3: TENHMETARECORD,
                           para4: int32, para5: LPARAM): int32{.stdcall.}
  ENUMFONTSPROC* = proc (para1: LPLOGFONT, para2: LPTEXTMETRIC, para3: DWORD,
                         para4: LPARAM): int32{.stdcall.}
  FONTENUMPROC* = proc (para1: var ENUMLOGFONT, para2: var NEWTEXTMETRIC,
                        para3: int32, para4: LPARAM): int32{.stdcall.}
  FONTENUMEXPROC* = proc (para1: var ENUMLOGFONTEX, para2: var NEWTEXTMETRICEX,
                          para3: int32, para4: LPARAM): int32{.stdcall.}
  LPOVERLAPPED_COMPLETION_ROUTINE* = proc (para1: DWORD, para2: DWORD,
      para3: LPOVERLAPPED){.stdcall.}
  # Structures for the extensions to OpenGL
  POINTFLOAT* {.final, pure.} = object
    x*: float32
    y*: float32

  TPOINTFLOAT* = POINTFLOAT
  PPOINTFLOAT* = ptr POINTFLOAT
  GLYPHMETRICSFLOAT* {.final, pure.} = object
    gmfBlackBoxX*: float32
    gmfBlackBoxY*: float32
    gmfptGlyphOrigin*: POINTFLOAT
    gmfCellIncX*: float32
    gmfCellIncY*: float32

  LPGLYPHMETRICSFLOAT* = ptr GLYPHMETRICSFLOAT
  TGLYPHMETRICSFLOAT* = GLYPHMETRICSFLOAT
  PGLYPHMETRICSFLOAT* = ptr GLYPHMETRICSFLOAT
  LAYERPLANEDESCRIPTOR* {.final, pure.} = object
    nSize*: int16
    nVersion*: int16
    dwFlags*: DWORD
    iPixelType*: int8
    cColorBits*: int8
    cRedBits*: int8
    cRedShift*: int8
    cGreenBits*: int8
    cGreenShift*: int8
    cBlueBits*: int8
    cBlueShift*: int8
    cAlphaBits*: int8
    cAlphaShift*: int8
    cAccumBits*: int8
    cAccumRedBits*: int8
    cAccumGreenBits*: int8
    cAccumBlueBits*: int8
    cAccumAlphaBits*: int8
    cDepthBits*: int8
    cStencilBits*: int8
    cAuxBuffers*: int8
    iLayerPlane*: int8
    bReserved*: int8
    crTransparent*: COLORREF

  LPLAYERPLANEDESCRIPTOR* = ptr LAYERPLANEDESCRIPTOR
  TLAYERPLANEDESCRIPTOR* = LAYERPLANEDESCRIPTOR
  PLAYERPLANEDESCRIPTOR* = ptr LAYERPLANEDESCRIPTOR
  PIXELFORMATDESCRIPTOR* {.final, pure.} = object
    nSize*: int16
    nVersion*: int16
    dwFlags*: DWORD
    iPixelType*: int8
    cColorBits*: int8
    cRedBits*: int8
    cRedShift*: int8
    cGreenBits*: int8
    cGreenShift*: int8
    cBlueBits*: int8
    cBlueShift*: int8
    cAlphaBits*: int8
    cAlphaShift*: int8
    cAccumBits*: int8
    cAccumRedBits*: int8
    cAccumGreenBits*: int8
    cAccumBlueBits*: int8
    cAccumAlphaBits*: int8
    cDepthBits*: int8
    cStencilBits*: int8
    cAuxBuffers*: int8
    iLayerType*: int8
    bReserved*: int8
    dwLayerMask*: DWORD
    dwVisibleMask*: DWORD
    dwDamageMask*: DWORD

  LPPIXELFORMATDESCRIPTOR* = ptr PIXELFORMATDESCRIPTOR
  TPIXELFORMATDESCRIPTOR* = PIXELFORMATDESCRIPTOR
  PPIXELFORMATDESCRIPTOR* = ptr PIXELFORMATDESCRIPTOR
  USER_INFO_2* {.final, pure.} = object
    usri2_name*: LPWSTR
    usri2_password*: LPWSTR
    usri2_password_age*: DWORD
    usri2_priv*: DWORD
    usri2_home_dir*: LPWSTR
    usri2_comment*: LPWSTR
    usri2_flags*: DWORD
    usri2_script_path*: LPWSTR
    usri2_auth_flags*: DWORD
    usri2_full_name*: LPWSTR
    usri2_usr_comment*: LPWSTR
    usri2_parms*: LPWSTR
    usri2_workstations*: LPWSTR
    usri2_last_logon*: DWORD
    usri2_last_logoff*: DWORD
    usri2_acct_expires*: DWORD
    usri2_max_storage*: DWORD
    usri2_units_per_week*: DWORD
    usri2_logon_hours*: PBYTE
    usri2_bad_pw_count*: DWORD
    usri2_num_logons*: DWORD
    usri2_logon_server*: LPWSTR
    usri2_country_code*: DWORD
    usri2_code_page*: DWORD

  PUSER_INFO_2* = ptr USER_INFO_2
  LPUSER_INFO_2* = ptr USER_INFO_2
  TUSERINFO2* = USER_INFO_2
  USER_INFO_0* {.final, pure.} = object
    usri0_name*: LPWSTR

  PUSER_INFO_0* = ptr USER_INFO_0
  LPUSER_INFO_0* = ptr USER_INFO_0
  TUSERINFO0* = USER_INFO_0
  USER_INFO_3* {.final, pure.} = object
    usri3_name*: LPWSTR
    usri3_password*: LPWSTR
    usri3_password_age*: DWORD
    usri3_priv*: DWORD
    usri3_home_dir*: LPWSTR
    usri3_comment*: LPWSTR
    usri3_flags*: DWORD
    usri3_script_path*: LPWSTR
    usri3_auth_flags*: DWORD
    usri3_full_name*: LPWSTR
    usri3_usr_comment*: LPWSTR
    usri3_parms*: LPWSTR
    usri3_workstations*: LPWSTR
    usri3_last_logon*: DWORD
    usri3_last_logoff*: DWORD
    usri3_acct_expires*: DWORD
    usri3_max_storage*: DWORD
    usri3_units_per_week*: DWORD
    usri3_logon_hours*: PBYTE
    usri3_bad_pw_count*: DWORD
    usri3_num_logons*: DWORD
    usri3_logon_server*: LPWSTR
    usri3_country_code*: DWORD
    usri3_code_page*: DWORD
    usri3_user_id*: DWORD
    usri3_primary_group_id*: DWORD
    usri3_profile*: LPWSTR
    usri3_home_dir_drive*: LPWSTR
    usri3_password_expired*: DWORD

  PUSER_INFO_3* = ptr USER_INFO_3
  LPUSER_INFO_3* = ptr USER_INFO_3
  TUSERINFO3* = USER_INFO_3
  GROUP_INFO_2* {.final, pure.} = object
    grpi2_name*: LPWSTR
    grpi2_comment*: LPWSTR
    grpi2_group_id*: DWORD
    grpi2_attributes*: DWORD

  PGROUP_INFO_2* = ptr GROUP_INFO_2
  TGROUPINFO2* = GROUP_INFO_2
  LOCALGROUP_INFO_0* {.final, pure.} = object
    lgrpi0_name*: LPWSTR

  PLOCALGROUP_INFO_0* = ptr LOCALGROUP_INFO_0
  LPLOCALGROUP_INFO_0* = ptr LOCALGROUP_INFO_0
  TLOCALGROUPINFO0* = LOCALGROUP_INFO_0
  IMAGE_DOS_HEADER* {.final, pure.} = object
    e_magic*: int16
    e_cblp*: int16
    e_cp*: int16
    e_crlc*: int16
    e_cparhdr*: int16
    e_minalloc*: int16
    e_maxalloc*: int16
    e_ss*: int16
    e_sp*: int16
    e_csum*: int16
    e_ip*: int16
    e_cs*: int16
    e_lfarlc*: int16
    e_ovno*: int16
    e_res*: array[0..3, int16]
    e_oemid*: int16
    e_oeminfo*: int16
    e_res2*: array[0..9, int16]
    e_lfanew*: LONG

  PIMAGE_DOS_HEADER* = ptr IMAGE_DOS_HEADER
  TIMAGEDOSHEADER* = IMAGE_DOS_HEADER
  NOTIFYICONDATAA* {.final, pure.} = object
    cbSize*: DWORD
    Wnd*: HWND
    uID*: UINT
    uFlags*: UINT
    uCallbackMessage*: UINT
    hIcon*: HICON
    szTip*: array[0..63, Char]

  NOTIFYICONDATA* = NOTIFYICONDATAA
  NOTIFYICONDATAW* {.final, pure.} = object
    cbSize*: DWORD
    Wnd*: HWND
    uID*: UINT
    uFlags*: UINT
    uCallbackMessage*: UINT
    hIcon*: HICON
    szTip*: array[0..63, int16]

  TNotifyIconDataA* = NOTIFYICONDATAA
  TNotifyIconDataW* = NOTIFYICONDATAW
  TNotifyIconData* = TNotifyIconDataA
  PNotifyIconDataA* = ptr TNotifyIconDataA
  PNotifyIconDataW* = ptr TNotifyIconDataW
  PNotifyIconData* = PNotifyIconDataA
  TWOHandleArray* = array[0..MAXIMUM_WAIT_OBJECTS - 1, HANDLE]
  PWOHandleArray* = ptr TWOHandleArray
  MMRESULT* = int32

type
  PWaveFormatEx* = ptr TWaveFormatEx
  TWaveFormatEx* {.final, pure.} = object
    wFormatTag*: int16        # format type
    nChannels*: int16         # number of channels (i.e. mono, stereo, etc.)
    nSamplesPerSec*: DWORD    # sample rate
    nAvgBytesPerSec*: DWORD   # for buffer estimation
    nBlockAlign*: int16       # block size of data
    wBitsPerSample*: int16    # number of bits per sample of mono data
    cbSize*: int16            # the count in bytes of the size of

  WIN32_FILE_ATTRIBUTE_DATA* {.final, pure.} = object
    dwFileAttributes*: DWORD
    ftCreationTime*: FILETIME
    ftLastAccessTime*: FILETIME
    ftLastWriteTime*: FILETIME
    nFileSizeHigh*: DWORD
    nFileSizeLow*: DWORD

  LPWIN32_FILE_ATTRIBUTE_DATA* = ptr WIN32_FILE_ATTRIBUTE_DATA
  TWIN32FILEATTRIBUTEDATA* = WIN32_FILE_ATTRIBUTE_DATA
  PWIN32FILEATTRIBUTEDATA* = ptr WIN32_FILE_ATTRIBUTE_DATA
  # TrackMouseEvent. NT or higher only.
  TTrackMouseEvent* {.final, pure.} = object
    cbSize*: DWORD
    dwFlags*: DWORD
    hwndTrack*: HWND
    dwHoverTime*: DWORD

  PTrackMouseEvent* = ptr TTrackMouseEvent

const
  ACM_OPENW* = 1127
  ACM_OPENA* = 1124

when defined(winUnicode):
  const
    ACM_OPEN* = ACM_OPENW
else:
  const
    ACM_OPEN* = ACM_OPENA
# UNICODE

const
  ACM_PLAY* = 1125
  ACM_STOP* = 1126
  ACN_START* = 1
  ACN_STOP* = 2
  # Buttons
  BM_CLICK* = 245
  BM_GETCHECK* = 240
  BM_GETIMAGE* = 246
  BM_GETSTATE* = 242
  BM_SETCHECK* = 241
  BM_SETIMAGE* = 247
  BM_SETSTATE* = 243
  BM_SETSTYLE* = 244
  BN_CLICKED* = 0
  BN_DBLCLK* = 5
  BN_DISABLE* = 4
  BN_DOUBLECLICKED* = 5
  BN_HILITE* = 2
  BN_KILLFOCUS* = 7
  BN_PAINT* = 1
  BN_PUSHED* = 2
  BN_SETFOCUS* = 6
  BN_UNHILITE* = 3
  BN_UNPUSHED* = 3
  # Combo Box
  CB_ADDSTRING* = 323
  CB_DELETESTRING* = 324
  CB_DIR* = 325
  CB_FINDSTRING* = 332
  CB_FINDSTRINGEXACT* = 344
  CB_GETCOUNT* = 326
  CB_GETCURSEL* = 327
  CB_GETDROPPEDCONTROLRECT* = 338
  CB_GETDROPPEDSTATE* = 343
  CB_GETDROPPEDWIDTH* = 351
  CB_GETEDITSEL* = 320
  CB_GETEXTENDEDUI* = 342
  CB_GETHORIZONTALEXTENT* = 349
  CB_GETITEMDATA* = 336
  CB_GETITEMHEIGHT* = 340
  CB_GETLBTEXT* = 328
  CB_GETLBTEXTLEN* = 329
  CB_GETLOCALE* = 346
  CB_GETTOPINDEX* = 347
  CB_INITSTORAGE* = 353
  CB_INSERTSTRING* = 330
  CB_LIMITTEXT* = 321
  CB_RESETCONTENT* = 331
  CB_SELECTSTRING* = 333
  CB_SETCURSEL* = 334
  CB_SETDROPPEDWIDTH* = 352
  CB_SETEDITSEL* = 322
  CB_SETEXTENDEDUI* = 341
  CB_SETHORIZONTALEXTENT* = 350
  CB_SETITEMDATA* = 337
  CB_SETITEMHEIGHT* = 339
  CB_SETLOCALE* = 345
  CB_SETTOPINDEX* = 348
  CB_SHOWDROPDOWN* = 335
  # Combo Box notifications
  CBN_CLOSEUP* = 8
  CBN_DBLCLK* = 2
  CBN_DROPDOWN* = 7
  CBN_EDITCHANGE* = 5
  CBN_EDITUPDATE* = 6
  CBN_ERRSPACE* = -1
  CBN_KILLFOCUS* = 4
  CBN_SELCHANGE* = 1
  CBN_SELENDCANCEL* = 10
  CBN_SELENDOK* = 9
  CBN_SETFOCUS* = 3
  # Control Panel
  # Device messages
  # Drag list box
  DL_BEGINDRAG* = 1157
  DL_CANCELDRAG* = 1160
  DL_DRAGGING* = 1158
  DL_DROPPED* = 1159
  # Default push button
  DM_GETDEFID* = 1024
  DM_REPOSITION* = 1026
  DM_SETDEFID* = 1025
  # RTF control
  EM_CANPASTE* = 1074
  EM_CANUNDO* = 198
  EM_CHARFROMPOS* = 215
  EM_DISPLAYBAND* = 1075
  EM_EMPTYUNDOBUFFER* = 205
  EM_EXGETSEL* = 1076
  EM_EXLIMITTEXT* = 1077
  EM_EXLINEFROMCHAR* = 1078
  EM_EXSETSEL* = 1079
  EM_FINDTEXT* = 1080
  EM_FINDTEXTEX* = 1103
  EM_FINDWORDBREAK* = 1100
  EM_FMTLINES* = 200
  EM_FORMATRANGE* = 1081
  EM_GETCHARFORMAT* = 1082
  EM_GETEVENTMASK* = 1083
  EM_GETFIRSTVISIBLELINE* = 206
  EM_GETHANDLE* = 189
  EM_GETLIMITTEXT* = 213
  EM_GETLINE* = 196
  EM_GETLINECOUNT* = 186
  EM_GETMARGINS* = 212
  EM_GETMODIFY* = 184
  EM_GETIMECOLOR* = 1129
  EM_GETIMEOPTIONS* = 1131
  EM_GETOPTIONS* = 1102
  EM_GETOLEINTERFACE* = 1084
  EM_GETPARAFORMAT* = 1085
  EM_GETPASSWORDCHAR* = 210
  EM_GETPUNCTUATION* = 1125
  EM_GETRECT* = 178
  EM_GETSEL* = 176
  EM_GETSELTEXT* = 1086
  EM_GETTEXTRANGE* = 1099
  EM_GETTHUMB* = 190
  EM_GETWORDBREAKPROC* = 209
  EM_GETWORDBREAKPROCEX* = 1104
  EM_GETWORDWRAPMODE* = 1127
  EM_HIDESELECTION* = 1087
  EM_LIMITTEXT* = 197
  EM_LINEFROMCHAR* = 201
  EM_LINEINDEX* = 187
  EM_LINELENGTH* = 193
  EM_LINESCROLL* = 182
  EM_PASTESPECIAL* = 1088
  EM_POSFROMCHAR* = 214
  EM_REPLACESEL* = 194
  EM_REQUESTRESIZE* = 1089
  EM_SCROLL* = 181
  EM_SCROLLCARET* = 183
  EM_SELECTIONTYPE* = 1090
  EM_SETBKGNDCOLOR* = 1091
  EM_SETCHARFORMAT* = 1092
  EM_SETEVENTMASK* = 1093
  EM_SETHANDLE* = 188
  EM_SETIMECOLOR* = 1128
  EM_SETIMEOPTIONS* = 1130
  EM_SETLIMITTEXT* = 197
  EM_SETMARGINS* = 211
  EM_SETMODIFY* = 185
  EM_SETOLECALLBACK* = 1094
  EM_SETOPTIONS* = 1101
  EM_SETPARAFORMAT* = 1095
  EM_SETPASSWORDCHAR* = 204
  EM_SETPUNCTUATION* = 1124
  EM_SETREADONLY* = 207
  EM_SETRECT* = 179
  EM_SETRECTNP* = 180
  EM_SETSEL* = 177
  EM_SETTABSTOPS* = 203
  EM_SETTARGETDEVICE* = 1096
  EM_SETWORDBREAKPROC* = 208
  EM_SETWORDBREAKPROCEX* = 1105
  EM_SETWORDWRAPMODE* = 1126
  EM_STREAMIN* = 1097
  EM_STREAMOUT* = 1098
  EM_UNDO* = 199
  # Edit control
  EN_CHANGE* = 768
  EN_CORRECTTEXT* = 1797
  EN_DROPFILES* = 1795
  EN_ERRSPACE* = 1280
  EN_HSCROLL* = 1537
  EN_IMECHANGE* = 1799
  EN_KILLFOCUS* = 512
  EN_MAXTEXT* = 1281
  EN_MSGFILTER* = 1792
  EN_OLEOPFAILED* = 1801
  EN_PROTECTED* = 1796
  EN_REQUESTRESIZE* = 1793
  EN_SAVECLIPBOARD* = 1800
  EN_SELCHANGE* = 1794
  EN_SETFOCUS* = 256
  EN_STOPNOUNDO* = 1798
  EN_UPDATE* = 1024
  EN_VSCROLL* = 1538
  # File Manager extensions
  # File Manager extensions DLL events
  # Header control
  HDM_DELETEITEM* = 4610
  HDM_GETITEMW* = 4619
  HDM_INSERTITEMW* = 4618
  HDM_SETITEMW* = 4620
  HDM_GETITEMA* = 4611
  HDM_INSERTITEMA* = 4609
  HDM_SETITEMA* = 4612

when defined(winUnicode):
  const
    HDM_GETITEM* = HDM_GETITEMW
    HDM_INSERTITEM* = HDM_INSERTITEMW
    HDM_SETITEM* = HDM_SETITEMW
else:
  const
    HDM_GETITEM* = HDM_GETITEMA
    HDM_INSERTITEM* = HDM_INSERTITEMA
    HDM_SETITEM* = HDM_SETITEMA
# UNICODE

const
  HDM_GETITEMCOUNT* = 4608
  HDM_HITTEST* = 4614
  HDM_LAYOUT* = 4613
  # Header control notifications
  HDN_BEGINTRACKW* = -326
  HDN_DIVIDERDBLCLICKW* = -325
  HDN_ENDTRACKW* = -327
  HDN_ITEMCHANGEDW* = -321
  HDN_ITEMCHANGINGW* = -320
  HDN_ITEMCLICKW* = -322
  HDN_ITEMDBLCLICKW* = -323
  HDN_TRACKW* = -328
  HDN_BEGINTRACKA* = -306
  HDN_DIVIDERDBLCLICKA* = -305
  HDN_ENDTRACKA* = -307
  HDN_ITEMCHANGEDA* = -301
  HDN_ITEMCHANGINGA* = -300
  HDN_ITEMCLICKA* = -302
  HDN_ITEMDBLCLICKA* = -303
  HDN_TRACKA* = -308

when defined(winUnicode):
  const
    HDN_BEGINTRACK* = HDN_BEGINTRACKW
    HDN_DIVIDERDBLCLICK* = HDN_DIVIDERDBLCLICKW
    HDN_ENDTRACK* = HDN_ENDTRACKW
    HDN_ITEMCHANGED* = HDN_ITEMCHANGEDW
    HDN_ITEMCHANGING* = HDN_ITEMCHANGINGW
    HDN_ITEMCLICK* = HDN_ITEMCLICKW
    HDN_ITEMDBLCLICK* = HDN_ITEMDBLCLICKW
    HDN_TRACK* = HDN_TRACKW
else:
  const
    HDN_BEGINTRACK* = HDN_BEGINTRACKA
    HDN_DIVIDERDBLCLICK* = HDN_DIVIDERDBLCLICKA
    HDN_ENDTRACK* = HDN_ENDTRACKA
    HDN_ITEMCHANGED* = HDN_ITEMCHANGEDA
    HDN_ITEMCHANGING* = HDN_ITEMCHANGINGA
    HDN_ITEMCLICK* = HDN_ITEMCLICKA
    HDN_ITEMDBLCLICK* = HDN_ITEMDBLCLICKA
    HDN_TRACK* = HDN_TRACKA
# UNICODE

const
  # Hot key control
  HKM_GETHOTKEY* = 1026
  HKM_SETHOTKEY* = 1025
  HKM_SETRULES* = 1027
  # List box
  LB_ADDFILE* = 406
  LB_ADDSTRING* = 384
  LB_DELETESTRING* = 386
  LB_DIR* = 397
  LB_FINDSTRING* = 399
  LB_FINDSTRINGEXACT* = 418
  LB_GETANCHORINDEX* = 413
  LB_GETCARETINDEX* = 415
  LB_GETCOUNT* = 395
  LB_GETCURSEL* = 392
  LB_GETHORIZONTALEXTENT* = 403
  LB_GETITEMDATA* = 409
  LB_GETITEMHEIGHT* = 417
  LB_GETITEMRECT* = 408
  LB_GETLOCALE* = 422
  LB_GETSEL* = 391
  LB_GETSELCOUNT* = 400
  LB_GETSELITEMS* = 401
  LB_GETTEXT* = 393
  LB_GETTEXTLEN* = 394
  LB_GETTOPINDEX* = 398
  LB_INITSTORAGE* = 424
  LB_INSERTSTRING* = 385
  LB_ITEMFROMPOINT* = 425
  LB_RESETCONTENT* = 388
  LB_SELECTSTRING* = 396
  LB_SELITEMRANGE* = 411
  LB_SELITEMRANGEEX* = 387
  LB_SETANCHORINDEX* = 412
  LB_SETCARETINDEX* = 414
  LB_SETCOLUMNWIDTH* = 405
  LB_SETCOUNT* = 423
  LB_SETCURSEL* = 390
  LB_SETHORIZONTALEXTENT* = 404
  LB_SETITEMDATA* = 410
  LB_SETITEMHEIGHT* = 416
  LB_SETLOCALE* = 421
  LB_SETSEL* = 389
  LB_SETTABSTOPS* = 402
  LB_SETTOPINDEX* = 407
  # List box notifications
  LBN_DBLCLK* = 2
  LBN_ERRSPACE* = -2
  LBN_KILLFOCUS* = 5
  LBN_SELCANCEL* = 3
  LBN_SELCHANGE* = 1
  LBN_SETFOCUS* = 4
  # List view control
  LVM_ARRANGE* = 4118
  LVM_CREATEDRAGIMAGE* = 4129
  LVM_DELETEALLITEMS* = 4105
  LVM_DELETECOLUMN* = 4124
  LVM_DELETEITEM* = 4104
  LVM_ENSUREVISIBLE* = 4115
  LVM_GETBKCOLOR* = 4096
  LVM_GETCALLBACKMASK* = 4106
  LVM_GETCOLUMNWIDTH* = 4125
  LVM_GETCOUNTPERPAGE* = 4136
  LVM_GETEDITCONTROL* = 4120
  LVM_GETIMAGELIST* = 4098
  LVM_EDITLABELW* = 4214
  LVM_FINDITEMW* = 4179
  LVM_GETCOLUMNW* = 4191
  LVM_GETISEARCHSTRINGW* = 4213
  LVM_GETITEMW* = 4171
  LVM_GETITEMTEXTW* = 4211
  LVM_GETSTRINGWIDTHW* = 4183
  LVM_INSERTCOLUMNW* = 4193
  LVM_INSERTITEMW* = 4173
  LVM_SETCOLUMNW* = 4192
  LVM_SETITEMW* = 4172
  LVM_SETITEMTEXTW* = 4212
  LVM_EDITLABELA* = 4119
  LVM_FINDITEMA* = 4109
  LVM_GETCOLUMNA* = 4121
  LVM_GETISEARCHSTRINGA* = 4148
  LVM_GETITEMA* = 4101
  LVM_GETITEMTEXTA* = 4141
  LVM_GETSTRINGWIDTHA* = 4113
  LVM_INSERTCOLUMNA* = 4123
  LVM_INSERTITEMA* = 4103
  LVM_SETCOLUMNA* = 4122
  LVM_SETITEMA* = 4102
  LVM_SETITEMTEXTA* = 4142

when defined(winUnicode):
  const
    LVM_EDITLABEL* = LVM_EDITLABELW
    LVM_FINDITEM* = LVM_FINDITEMW
    LVM_GETCOLUMN* = LVM_GETCOLUMNW
    LVM_GETISEARCHSTRING* = LVM_GETISEARCHSTRINGW
    LVM_GETITEM* = LVM_GETITEMW
    LVM_GETITEMTEXT* = LVM_GETITEMTEXTW
    LVM_GETSTRINGWIDTH* = LVM_GETSTRINGWIDTHW
    LVM_INSERTCOLUMN* = LVM_INSERTCOLUMNW
    LVM_INSERTITEM* = LVM_INSERTITEMW
    LVM_SETCOLUMN* = LVM_SETCOLUMNW
    LVM_SETITEM* = LVM_SETITEMW
    LVM_SETITEMTEXT* = LVM_SETITEMTEXTW
else:
  const
    LVM_EDITLABEL* = LVM_EDITLABELA
    LVM_FINDITEM* = LVM_FINDITEMA
    LVM_GETCOLUMN* = LVM_GETCOLUMNA
    LVM_GETISEARCHSTRING* = LVM_GETISEARCHSTRINGA
    LVM_GETITEM* = LVM_GETITEMA
    LVM_GETITEMTEXT* = LVM_GETITEMTEXTA
    LVM_GETSTRINGWIDTH* = LVM_GETSTRINGWIDTHA
    LVM_INSERTCOLUMN* = LVM_INSERTCOLUMNA
    LVM_INSERTITEM* = LVM_INSERTITEMA
    LVM_SETCOLUMN* = LVM_SETCOLUMNA
    LVM_SETITEM* = LVM_SETITEMA
    LVM_SETITEMTEXT* = LVM_SETITEMTEXTA
# UNICODE

const
  LVM_GETITEMCOUNT* = 4100
  LVM_GETITEMPOSITION* = 4112
  LVM_GETITEMRECT* = 4110
  LVM_GETITEMSPACING* = 4147
  LVM_GETITEMSTATE* = 4140
  LVM_GETNEXTITEM* = 4108
  LVM_GETORIGIN* = 4137
  LVM_GETSELECTEDCOUNT* = 4146
  LVM_GETTEXTBKCOLOR* = 4133
  LVM_GETTEXTCOLOR* = 4131
  LVM_GETTOPINDEX* = 4135
  LVM_GETVIEWRECT* = 4130
  LVM_HITTEST* = 4114
  LVM_REDRAWITEMS* = 4117
  LVM_SCROLL* = 4116
  LVM_SETBKCOLOR* = 4097
  LVM_SETCALLBACKMASK* = 4107
  LVM_SETCOLUMNWIDTH* = 4126
  LVM_SETIMAGELIST* = 4099
  LVM_SETITEMCOUNT* = 4143
  LVM_SETITEMPOSITION* = 4111
  LVM_SETITEMPOSITION32* = 4145
  LVM_SETITEMSTATE* = 4139
  LVM_SETTEXTBKCOLOR* = 4134
  LVM_SETTEXTCOLOR* = 4132
  LVM_SORTITEMS* = 4144
  LVM_UPDATE* = 4138
  # List view control notifications
  LVN_BEGINDRAG* = -109
  LVN_BEGINRDRAG* = -111
  LVN_COLUMNCLICK* = -108
  LVN_DELETEALLITEMS* = -104
  LVN_DELETEITEM* = -103
  LVN_BEGINLABELEDITW* = -175
  LVN_ENDLABELEDITW* = -176
  LVN_GETDISPINFOW* = -177
  LVN_SETDISPINFOW* = -178
  LVN_BEGINLABELEDITA* = -105
  LVN_ENDLABELEDITA* = -106
  LVN_GETDISPINFOA* = -150
  LVN_SETDISPINFOA* = -151

when defined(winUnicode):
  const
    LVN_BEGINLABELEDIT* = LVN_BEGINLABELEDITW
    LVN_ENDLABELEDIT* = LVN_ENDLABELEDITW
    LVN_GETDISPINFO* = LVN_GETDISPINFOW
    LVN_SETDISPINFO* = LVN_SETDISPINFOW
else:
  const
    LVN_BEGINLABELEDIT* = LVN_BEGINLABELEDITA
    LVN_ENDLABELEDIT* = LVN_ENDLABELEDITA
    LVN_GETDISPINFO* = LVN_GETDISPINFOA
    LVN_SETDISPINFO* = LVN_SETDISPINFOA
# UNICODE

const
  LVN_INSERTITEM* = -102
  LVN_ITEMCHANGED* = -101
  LVN_ITEMCHANGING* = -100
  LVN_KEYDOWN* = -155
  # Control notification
  NM_CLICK* = -2
  NM_DBLCLK* = -3
  NM_KILLFOCUS* = -8
  NM_OUTOFMEMORY* = -1
  NM_RCLICK* = -5
  NM_RDBLCLK* = -6
  NM_RETURN* = -4
  NM_SETFOCUS* = -7
  # Power status
  # Progress bar control
  PBM_DELTAPOS* = 1027
  PBM_SETPOS* = 1026
  PBM_SETRANGE* = 1025
  PBM_SETRANGE32* = 1030
  PBM_SETSTEP* = 1028
  PBM_STEPIT* = 1029
  # Property sheets
  PSM_ADDPAGE* = 1127
  PSM_APPLY* = 1134
  PSM_CANCELTOCLOSE* = 1131
  PSM_CHANGED* = 1128
  PSM_GETTABCONTROL* = 1140
  PSM_GETCURRENTPAGEHWND* = 1142
  PSM_ISDIALOGMESSAGE* = 1141
  PSM_PRESSBUTTON* = 1137
  PSM_QUERYSIBLINGS* = 1132
  PSM_REBOOTSYSTEM* = 1130
  PSM_REMOVEPAGE* = 1126
  PSM_RESTARTWINDOWS* = 1129
  PSM_SETCURSEL* = 1125
  PSM_SETCURSELID* = 1138
  PSM_SETFINISHTEXTW* = 1145
  PSM_SETTITLEW* = 1144
  PSM_SETFINISHTEXTA* = 1139
  PSM_SETTITLEA* = 1135

when defined(winUnicode):
  const
    PSM_SETFINISHTEXT* = PSM_SETFINISHTEXTW
    PSM_SETTITLE* = PSM_SETTITLEW
else:
  const
    PSM_SETFINISHTEXT* = PSM_SETFINISHTEXTA
    PSM_SETTITLE* = PSM_SETTITLEA
# UNICODE

const
  PSM_SETWIZBUTTONS* = 1136
  PSM_UNCHANGED* = 1133
  # Property sheet notifications
  PSN_APPLY* = -202
  PSN_HELP* = -205
  PSN_KILLACTIVE* = -201
  PSN_QUERYCANCEL* = -209
  PSN_RESET* = -203
  PSN_SETACTIVE* = -200
  PSN_WIZBACK* = -206
  PSN_WIZFINISH* = -208
  PSN_WIZNEXT* = -207
  # Status window
  SB_GETBORDERS* = 1031
  SB_GETPARTS* = 1030
  SB_GETRECT* = 1034
  SB_GETTEXTW* = 1037
  SB_GETTEXTLENGTHW* = 1036
  SB_SETTEXTW* = 1035
  SB_GETTEXTA* = 1026
  SB_GETTEXTLENGTHA* = 1027
  SB_SETTEXTA* = 1025

when defined(winUnicode):
  const
    SB_GETTEXT* = SB_GETTEXTW
    SB_GETTEXTLENGTH* = SB_GETTEXTLENGTHW
    SB_SETTEXT* = SB_SETTEXTW
else:
  const
    SB_GETTEXT* = SB_GETTEXTA
    SB_GETTEXTLENGTH* = SB_GETTEXTLENGTHA
    SB_SETTEXT* = SB_SETTEXTA
# UNICODE

const
  SB_SETMINHEIGHT* = 1032
  SB_SETPARTS* = 1028
  SB_SIMPLE* = 1033
  # Scroll bar control
  SBM_ENABLE_ARROWS* = 228
  SBM_GETPOS* = 225
  SBM_GETRANGE* = 227
  SBM_GETSCROLLINFO* = 234
  SBM_SETPOS* = 224
  SBM_SETRANGE* = 226
  SBM_SETRANGEREDRAW* = 230
  SBM_SETSCROLLINFO* = 233
  # Static control
  STM_GETICON* = 369
  STM_GETIMAGE* = 371
  STM_SETICON* = 368
  STM_SETIMAGE* = 370
  # Static control notifications
  STN_CLICKED* = 0
  STN_DBLCLK* = 1
  STN_DISABLE* = 3
  STN_ENABLE* = 2
  # Toolbar control
  TB_ADDBITMAP* = 1043
  TB_ADDBUTTONS* = 1044
  TB_AUTOSIZE* = 1057
  TB_BUTTONCOUNT* = 1048
  TB_BUTTONSTRUCTSIZE* = 1054
  TB_CHANGEBITMAP* = 1067
  TB_CHECKBUTTON* = 1026
  TB_COMMANDTOINDEX* = 1049
  TB_CUSTOMIZE* = 1051
  TB_DELETEBUTTON* = 1046
  TB_ENABLEBUTTON* = 1025
  TB_GETBITMAP* = 1068
  TB_GETBITMAPFLAGS* = 1065
  TB_GETBUTTON* = 1047
  TB_ADDSTRINGW* = 1101
  TB_GETBUTTONTEXTW* = 1099
  TB_SAVERESTOREW* = 1100
  TB_ADDSTRINGA* = 1052
  TB_GETBUTTONTEXTA* = 1069
  TB_SAVERESTOREA* = 1050

when defined(winUnicode):
  const
    TB_ADDSTRING* = TB_ADDSTRINGW
    TB_GETBUTTONTEXT* = TB_GETBUTTONTEXTW
    TB_SAVERESTORE* = TB_SAVERESTOREW
else:
  const
    TB_ADDSTRING* = TB_ADDSTRINGA
    TB_GETBUTTONTEXT* = TB_GETBUTTONTEXTA
    TB_SAVERESTORE* = TB_SAVERESTOREA
# UNICODE

const
  TB_GETITEMRECT* = 1053
  TB_GETROWS* = 1064
  TB_GETSTATE* = 1042
  TB_GETTOOLTIPS* = 1059
  TB_HIDEBUTTON* = 1028
  TB_INDETERMINATE* = 1029
  TB_INSERTBUTTON* = 1045
  TB_ISBUTTONCHECKED* = 1034
  TB_ISBUTTONENABLED* = 1033
  TB_ISBUTTONHIDDEN* = 1036
  TB_ISBUTTONINDETERMINATE* = 1037
  TB_ISBUTTONPRESSED* = 1035
  TB_PRESSBUTTON* = 1027
  TB_SETBITMAPSIZE* = 1056
  TB_SETBUTTONSIZE* = 1055
  TB_SETCMDID* = 1066
  TB_SETPARENT* = 1061
  TB_SETROWS* = 1063
  TB_SETSTATE* = 1041
  TB_SETTOOLTIPS* = 1060
  # Track bar control
  TBM_CLEARSEL* = 1043
  TBM_CLEARTICS* = 1033
  TBM_GETCHANNELRECT* = 1050
  TBM_GETLINESIZE* = 1048
  TBM_GETNUMTICS* = 1040
  TBM_GETPAGESIZE* = 1046
  TBM_GETPOS* = 1024
  TBM_GETPTICS* = 1038
  TBM_GETRANGEMAX* = 1026
  TBM_GETRANGEMIN* = 1025
  TBM_GETSELEND* = 1042
  TBM_GETSELSTART* = 1041
  TBM_GETTHUMBLENGTH* = 1052
  TBM_GETTHUMBRECT* = 1049
  TBM_GETTIC* = 1027
  TBM_GETTICPOS* = 1039
  TBM_SETLINESIZE* = 1047
  TBM_SETPAGESIZE* = 1045
  TBM_SETPOS* = 1029
  TBM_SETRANGE* = 1030
  TBM_SETRANGEMAX* = 1032
  TBM_SETRANGEMIN* = 1031
  TBM_SETSEL* = 1034
  TBM_SETSELEND* = 1036
  TBM_SETSELSTART* = 1035
  TBM_SETTHUMBLENGTH* = 1051
  TBM_SETTIC* = 1028
  TBM_SETTICFREQ* = 1044
  # Tool bar control notifications
  TBN_BEGINADJUST* = -703
  TBN_BEGINDRAG* = -701
  TBN_CUSTHELP* = -709
  TBN_ENDADJUST* = -704
  TBN_ENDDRAG* = -702
  TBN_GETBUTTONINFOW* = -720
  TBN_GETBUTTONINFOA* = -700

when defined(winUnicode):
  const
    TBN_GETBUTTONINFO* = TBN_GETBUTTONINFOW
else:
  const
    TBN_GETBUTTONINFO* = TBN_GETBUTTONINFOA
# UNICODE

const
  TBN_QUERYDELETE* = -707
  TBN_QUERYINSERT* = -706
  TBN_RESET* = -705
  TBN_TOOLBARCHANGE* = -708
  # Tab control
  TCM_ADJUSTRECT* = 4904
  TCM_DELETEALLITEMS* = 4873
  TCM_DELETEITEM* = 4872
  TCM_GETCURFOCUS* = 4911
  TCM_GETCURSEL* = 4875
  TCM_GETIMAGELIST* = 4866
  TCM_GETITEMW* = 4924
  TCM_INSERTITEMW* = 4926
  TCM_SETITEMW* = 4925
  TCM_GETITEMA* = 4869
  TCM_INSERTITEMA* = 4871
  TCM_SETITEMA* = 4870

when defined(winUnicode):
  const
    TCM_GETITEM* = TCM_GETITEM
    TCM_INSERTITEM* = TCM_INSERTITEMW
    TCM_SETITEM* = TCM_SETITEMW
else:
  const
    TCM_GETITEM* = TCM_GETITEMA
    TCM_INSERTITEM* = TCM_INSERTITEMA
    TCM_SETITEM* = TCM_SETITEMA
# UNICODE

const
  TCM_GETITEMCOUNT* = 4868
  TCM_GETITEMRECT* = 4874
  TCM_GETROWCOUNT* = 4908
  TCM_GETTOOLTIPS* = 4909
  TCM_HITTEST* = 4877
  TCM_REMOVEIMAGE* = 4906
  TCM_SETCURFOCUS* = 4912
  TCM_SETCURSEL* = 4876
  TCM_SETIMAGELIST* = 4867
  TCM_SETITEMEXTRA* = 4878
  TCM_SETITEMSIZE* = 4905
  TCM_SETPADDING* = 4907
  TCM_SETTOOLTIPS* = 4910
  # Tab control notifications
  TCN_KEYDOWN* = -550
  TCN_SELCHANGE* = -551
  TCN_SELCHANGING* = -552
  # Tool tip control
  TTM_ACTIVATE* = 1025
  TTM_ADDTOOLW* = 1074
  TTM_DELTOOLW* = 1075
  TTM_ENUMTOOLSW* = 1082
  TTM_GETCURRENTTOOLW* = 1083
  TTM_GETTEXTW* = 1080
  TTM_GETTOOLINFOW* = 1077
  TTM_HITTESTW* = 1079
  TTM_NEWTOOLRECTW* = 1076
  TTM_SETTOOLINFOW* = 1078
  TTM_UPDATETIPTEXTW* = 1081
  TTM_ADDTOOLA* = 1028
  TTM_DELTOOLA* = 1029
  TTM_ENUMTOOLSA* = 1038
  TTM_GETCURRENTTOOLA* = 1039
  TTM_GETTEXTA* = 1035
  TTM_GETTOOLINFOA* = 1032
  TTM_HITTESTA* = 1034
  TTM_NEWTOOLRECTA* = 1030
  TTM_SETTOOLINFOA* = 1033
  TTM_UPDATETIPTEXTA* = 1036

when defined(winUnicode):
  const
    TTM_ADDTOOL* = TTM_ADDTOOLW
    TTM_DELTOOL* = TTM_DELTOOLW
    TTM_ENUMTOOLS* = TTM_ENUMTOOLSW
    TTM_GETCURRENTTOOL* = TTM_GETCURRENTTOOLW
    TTM_GETTEXT* = TTM_GETTEXTW
    TTM_GETTOOLINFO* = TTM_GETTOOLINFOW
    TTM_HITTEST* = TTM_HITTESTW
    TTM_NEWTOOLRECT* = TTM_NEWTOOLRECTW
    TTM_SETTOOLINFO* = TTM_SETTOOLINFOW
    TTM_UPDATETIPTEXT* = TTM_UPDATETIPTEXTW
else:
  const
    TTM_ADDTOOL* = TTM_ADDTOOLA
    TTM_DELTOOL* = TTM_DELTOOLA
    TTM_ENUMTOOLS* = TTM_ENUMTOOLSA
    TTM_GETCURRENTTOOL* = TTM_GETCURRENTTOOLA
    TTM_GETTEXT* = TTM_GETTEXTA
    TTM_GETTOOLINFO* = TTM_GETTOOLINFOA
    TTM_HITTEST* = TTM_HITTESTA
    TTM_NEWTOOLRECT* = TTM_NEWTOOLRECTA
    TTM_SETTOOLINFO* = TTM_SETTOOLINFOA
    TTM_UPDATETIPTEXT* = TTM_UPDATETIPTEXTA
# UNICODE

const
  TTM_GETTOOLCOUNT* = 1037
  TTM_RELAYEVENT* = 1031
  TTM_SETDELAYTIME* = 1027
  TTM_WINDOWFROMPOINT* = 1040
  # Tool tip control notification
  TTN_NEEDTEXTW* = -530
  TTN_NEEDTEXTA* = -520

when defined(winUnicode):
  const
    TTN_NEEDTEXT* = TTN_NEEDTEXTW
else:
  const
    TTN_NEEDTEXT* = TTN_NEEDTEXTA
# UNICODE

const
  TTN_POP* = -522
  TTN_SHOW* = -521
  # Tree view control
  TVM_CREATEDRAGIMAGE* = 4370
  TVM_DELETEITEM* = 4353
  TVM_ENDEDITLABELNOW* = 4374
  TVM_ENSUREVISIBLE* = 4372
  TVM_EXPAND* = 4354
  TVM_GETCOUNT* = 4357
  TVM_GETEDITCONTROL* = 4367
  TVM_GETIMAGELIST* = 4360
  TVM_GETINDENT* = 4358
  TVM_GETITEMRECT* = 4356
  TVM_GETNEXTITEM* = 4362
  TVM_GETVISIBLECOUNT* = 4368
  TVM_HITTEST* = 4369
  TVM_EDITLABELW* = 4417
  TVM_GETISEARCHSTRINGW* = 4416
  TVM_GETITEMW* = 4414
  TVM_INSERTITEMW* = 4402
  TVM_SETITEMW* = 4415
  TVM_EDITLABELA* = 4366
  TVM_GETISEARCHSTRINGA* = 4375
  TVM_GETITEMA* = 4364
  TVM_INSERTITEMA* = 4352
  TVM_SETITEMA* = 4365

when defined(winUnicode):
  const
    TVM_EDITLABEL* = TVM_EDITLABELW
    TVM_GETISEARCHSTRING* = TVM_GETISEARCHSTRINGW
    TVM_GETITEM* = TVM_GETITEMW
    TVM_INSERTITEM* = TVM_INSERTITEMW
    TVM_SETITEM* = TVM_SETITEMW
else:
  const
    TVM_EDITLABEL* = TVM_EDITLABELA
    TVM_GETISEARCHSTRING* = TVM_GETISEARCHSTRINGA
    TVM_GETITEM* = TVM_GETITEMA
    TVM_INSERTITEM* = TVM_INSERTITEMA
    TVM_SETITEM* = TVM_SETITEMA
# UNICODE

const
  TVM_SELECTITEM* = 4363
  TVM_SETIMAGELIST* = 4361
  TVM_SETINDENT* = 4359
  TVM_SORTCHILDREN* = 4371
  TVM_SORTCHILDRENCB* = 4373
  # Tree view control notification
  TVN_KEYDOWN* = -412
  TVN_BEGINDRAGW* = -456
  TVN_BEGINLABELEDITW* = -459
  TVN_BEGINRDRAGW* = -457
  TVN_DELETEITEMW* = -458
  TVN_ENDLABELEDITW* = -460
  TVN_GETDISPINFOW* = -452
  TVN_ITEMEXPANDEDW* = -455
  TVN_ITEMEXPANDINGW* = -454
  TVN_SELCHANGEDW* = -451
  TVN_SELCHANGINGW* = -450
  TVN_SETDISPINFOW* = -453
  TVN_BEGINDRAGA* = -407
  TVN_BEGINLABELEDITA* = -410
  TVN_BEGINRDRAGA* = -408
  TVN_DELETEITEMA* = -409
  TVN_ENDLABELEDITA* = -411
  TVN_GETDISPINFOA* = -403
  TVN_ITEMEXPANDEDA* = -406
  TVN_ITEMEXPANDINGA* = -405
  TVN_SELCHANGEDA* = -402
  TVN_SELCHANGINGA* = -401
  TVN_SETDISPINFOA* = -404

when defined(winUnicode):
  const
    TVN_BEGINDRAG* = TVN_BEGINDRAGW
    TVN_BEGINLABELEDIT* = TVN_BEGINLABELEDITW
    TVN_BEGINRDRAG* = TVN_BEGINRDRAGW
    TVN_DELETEITEM* = TVN_DELETEITEMW
    TVN_ENDLABELEDIT* = TVN_ENDLABELEDITW
    TVN_GETDISPINFO* = TVN_GETDISPINFOW
    TVN_ITEMEXPANDED* = TVN_ITEMEXPANDEDW
    TVN_ITEMEXPANDING* = TVN_ITEMEXPANDINGW
    TVN_SELCHANGED* = TVN_SELCHANGEDW
    TVN_SELCHANGING* = TVN_SELCHANGINGW
    TVN_SETDISPINFO* = TVN_SETDISPINFOW
else:
  const
    TVN_BEGINDRAG* = TVN_BEGINDRAGA
    TVN_BEGINLABELEDIT* = TVN_BEGINLABELEDITA
    TVN_BEGINRDRAG* = TVN_BEGINRDRAGA
    TVN_DELETEITEM* = TVN_DELETEITEMA
    TVN_ENDLABELEDIT* = TVN_ENDLABELEDITA
    TVN_GETDISPINFO* = TVN_GETDISPINFOA
    TVN_ITEMEXPANDED* = TVN_ITEMEXPANDEDA
    TVN_ITEMEXPANDING* = TVN_ITEMEXPANDINGA
    TVN_SELCHANGED* = TVN_SELCHANGEDA
    TVN_SELCHANGING* = TVN_SELCHANGINGA
    TVN_SETDISPINFO* = TVN_SETDISPINFOA
# UNICODE

const
  # Up/down control
  UDM_GETACCEL* = 1132
  UDM_GETBASE* = 1134
  UDM_GETBUDDY* = 1130
  UDM_GETPOS* = 1128
  UDM_GETPOS32* = 1138
  UDM_GETRANGE* = 1126
  UDM_GETRANGE32* = 1136
  UDM_SETACCEL* = 1131
  UDM_SETBASE* = 1133
  UDM_SETBUDDY* = 1129
  UDM_SETPOS* = 1127
  UDM_SETPOS32* = 1137
  UDM_SETRANGE* = 1125
  UDM_SETRANGE32* = 1135
  # Up/down control notification
  UDN_DELTAPOS* = -722
  # Window messages
  WM_ACTIVATE* = 6
  WM_ACTIVATEAPP* = 28
  WM_ASKCBFORMATNAME* = 780
  WM_CANCELJOURNAL* = 75
  WM_CANCELMODE* = 31
  WM_CAPTURECHANGED* = 533
  WM_CHANGECBCHAIN* = 781
  WM_CHAR* = 258
  WM_CHARTOITEM* = 47
  WM_CHILDACTIVATE* = 34
  WM_CHOOSEFONT_GETLOGFONT* = 1025
  WM_CHOOSEFONT_SETLOGFONT* = 1125
  WM_CHOOSEFONT_SETFLAGS* = 1126
  WM_CLEAR* = 771
  WM_CLOSE* = 16
  WM_COMMAND* = 273
  WM_COMPACTING* = 65
  WM_COMPAREITEM* = 57
  WM_CONTEXTMENU* = 123
  WM_COPY* = 769
  WM_COPYDATA* = 74
  WM_CREATE* = 1
  WM_CTLCOLORBTN* = 309
  WM_CTLCOLORDLG* = 310
  WM_CTLCOLOREDIT* = 307
  WM_CTLCOLORLISTBOX* = 308
  WM_CTLCOLORMSGBOX* = 306
  WM_CTLCOLORSCROLLBAR* = 311
  WM_CTLCOLORSTATIC* = 312
  WM_CUT* = 768
  WM_DEADCHAR* = 259
  WM_DELETEITEM* = 45
  WM_DESTROY* = 2
  WM_DESTROYCLIPBOARD* = 775
  WM_DEVICECHANGE* = 537
  WM_DEVMODECHANGE* = 27
  WM_DISPLAYCHANGE* = 126
  WM_DRAWCLIPBOARD* = 776
  WM_DRAWITEM* = 43
  WM_DROPFILES* = 563
  WM_ENABLE* = 10
  WM_ENDSESSION* = 22
  WM_ENTERIDLE* = 289
  WM_ENTERMENULOOP* = 529
  WM_ENTERSIZEMOVE* = 561
  WM_ERASEBKGND* = 20
  WM_EXITMENULOOP* = 530
  WM_EXITSIZEMOVE* = 562
  WM_FONTCHANGE* = 29
  WM_GETDLGCODE* = 135
  WM_GETFONT* = 49
  WM_GETHOTKEY* = 51
  WM_GETICON* = 127
  WM_GETMINMAXINFO* = 36
  WM_GETTEXT* = 13
  WM_GETTEXTLENGTH* = 14
  WM_HELP* = 83
  WM_HOTKEY* = 786
  WM_HSCROLL* = 276
  WM_HSCROLLCLIPBOARD* = 782
  WM_ICONERASEBKGND* = 39
  WM_IME_CHAR* = 646
  WM_IME_COMPOSITION* = 271
  WM_IME_COMPOSITIONFULL* = 644
  WM_IME_CONTROL* = 643
  WM_IME_ENDCOMPOSITION* = 270
  WM_IME_KEYDOWN* = 656
  WM_IME_KEYUP* = 657
  WM_IME_NOTIFY* = 642
  WM_IME_SELECT* = 645
  WM_IME_SETCONTEXT* = 641
  WM_IME_STARTCOMPOSITION* = 269
  WM_INITDIALOG* = 272
  WM_INITMENU* = 278
  WM_INITMENUPOPUP* = 279
  WM_INPUTLANGCHANGE* = 81
  WM_INPUTLANGCHANGEREQUEST* = 80
  WM_KEYDOWN* = 256
  WM_KEYUP* = 257
  WM_KILLFOCUS* = 8
  WM_LBUTTONDBLCLK* = 515
  WM_LBUTTONDOWN* = 513
  WM_LBUTTONUP* = 514
  WM_MBUTTONDBLCLK* = 521
  WM_MBUTTONDOWN* = 519
  WM_MBUTTONUP* = 520
  WM_MDIACTIVATE* = 546
  WM_MDICASCADE* = 551
  WM_MDICREATE* = 544
  WM_MDIDESTROY* = 545
  WM_MDIGETACTIVE* = 553
  WM_MDIICONARRANGE* = 552
  WM_MDIMAXIMIZE* = 549
  WM_MDINEXT* = 548
  WM_MDIREFRESHMENU* = 564
  WM_MDIRESTORE* = 547
  WM_MDISETMENU* = 560
  WM_MDITILE* = 550
  WM_MEASUREITEM* = 44
  WM_MENUCHAR* = 288
  WM_MENUSELECT* = 287
  WM_MOUSEACTIVATE* = 33
  WM_MOUSEMOVE* = 512
  WM_MOUSEWHEEL* = 522
  WM_MOUSEHOVER* = 673
  WM_MOUSELEAVE* = 675
  WM_MOVE* = 3
  WM_MOVING* = 534
  WM_NCACTIVATE* = 134
  WM_NCCALCSIZE* = 131
  WM_NCCREATE* = 129
  WM_NCDESTROY* = 130
  WM_NCHITTEST* = 132
  WM_NCLBUTTONDBLCLK* = 163
  WM_NCLBUTTONDOWN* = 161
  WM_NCLBUTTONUP* = 162
  WM_NCMBUTTONDBLCLK* = 169
  WM_NCMBUTTONDOWN* = 167
  WM_NCMBUTTONUP* = 168
  WM_NCMOUSEMOVE* = 160
  WM_NCPAINT* = 133
  WM_NCRBUTTONDBLCLK* = 166
  WM_NCRBUTTONDOWN* = 164
  WM_NCRBUTTONUP* = 165
  WM_NEXTDLGCTL* = 40
  WM_NOTIFY* = 78
  WM_NOTIFYFORMAT* = 85
  WM_NULL* = 0
  WM_PAINT* = 15
  WM_PAINTCLIPBOARD* = 777
  WM_PAINTICON* = 38
  WM_PALETTECHANGED* = 785
  WM_PALETTEISCHANGING* = 784
  WM_PARENTNOTIFY* = 528
  WM_PASTE* = 770
  WM_PENWINFIRST* = 896
  WM_PENWINLAST* = 911
  WM_POWER* = 72
  WM_POWERBROADCAST* = 536
  WM_PRINT* = 791
  WM_PRINTCLIENT* = 792
  WM_PSD_ENVSTAMPRECT* = 1029
  WM_PSD_FULLPAGERECT* = 1025
  WM_PSD_GREEKTEXTRECT* = 1028
  WM_PSD_MARGINRECT* = 1027
  WM_PSD_MINMARGINRECT* = 1026
  WM_PSD_PAGESETUPDLG* = 1024
  WM_PSD_YAFULLPAGERECT* = 1030
  WM_QUERYDRAGICON* = 55
  WM_QUERYENDSESSION* = 17
  WM_QUERYNEWPALETTE* = 783
  WM_QUERYOPEN* = 19
  WM_QUEUESYNC* = 35
  WM_QUIT* = 18
  WM_RBUTTONDBLCLK* = 518
  WM_RBUTTONDOWN* = 516
  WM_RBUTTONUP* = 517
  WM_RENDERALLFORMATS* = 774
  WM_RENDERFORMAT* = 773
  WM_SETCURSOR* = 32
  WM_SETFOCUS* = 7
  WM_SETFONT* = 48
  WM_SETHOTKEY* = 50
  WM_SETICON* = 128
  WM_SETREDRAW* = 11
  WM_SETTEXT* = 12
  WM_SETTINGCHANGE* = 26
  WM_SHOWWINDOW* = 24
  WM_SIZE* = 5
  WM_SIZECLIPBOARD* = 779
  WM_SIZING* = 532
  WM_SPOOLERSTATUS* = 42
  WM_STYLECHANGED* = 125
  WM_STYLECHANGING* = 124
  WM_SYSCHAR* = 262
  WM_SYSCOLORCHANGE* = 21
  WM_SYSCOMMAND* = 274
  WM_SYSDEADCHAR* = 263
  WM_SYSKEYDOWN* = 260
  WM_SYSKEYUP* = 261
  WM_TCARD* = 82
  WM_TIMECHANGE* = 30
  WM_TIMER* = 275
  WM_UNDO* = 772
  WM_USER* = 1024
  WM_USERCHANGED* = 84
  WM_VKEYTOITEM* = 46
  WM_VSCROLL* = 277
  WM_VSCROLLCLIPBOARD* = 778
  WM_WINDOWPOSCHANGED* = 71
  WM_WINDOWPOSCHANGING* = 70
  WM_WININICHANGE* = 26
  # Window message ranges
  WM_KEYFIRST* = 256
  WM_KEYLAST* = 264
  WM_MOUSEFIRST* = 512
  WM_MOUSELAST* = 525
  WM_XBUTTONDOWN* = 523
  WM_XBUTTONUP* = 524
  WM_XBUTTONDBLCLK* = 525

when defined(cpu64):
  type
    HALFLRESULT* = DWORD
    HALFPARAM* = DWORD
    HALFPARAMBOOL* = WINBOOL
else:
  type
    HALFLRESULT* = int16
    HALFPARAM* = int16
    HALFPARAMBOOL* = WORDBOOL
type
  MSG* {.final, pure.} = object
    hwnd*: HWND
    message*: UINT
    wParam*: WPARAM
    lParam*: LPARAM
    time*: DWORD
    pt*: POINT

  LPMSG* = ptr MSG
  TMSG* = MSG
  PMSG* = ptr MSG
  PMessage* = ptr TMessage
  TMessage* {.final, pure.} = object          #fields according to ICS
    msg*: UINT
    wParam*: WPARAM
    lParam*: LPARAM
    Result*: LRESULT

  TWMSize* {.final, pure.} = object
    Msg*: UINT
    SizeType*: WPARAM
    Width*: HALFPARAM
    Height*: HALFPARAM
    Result*: LRESULT

  TWMNoParams* {.final, pure.} = object
    Msg*: UINT
    Unused*: array[0..3, HALFPARAM]
    Result*: LRESULT

  TWMCancelMode* = TWMNoParams
  TWMNCDestroy* = TWMNoParams
  TWMDestroy* = TWMNoParams
  TWMClose* = TWMNoParams
  TWMQueryUIState* = TWMNoParams
  TWMUIState* {.final, pure.} = object
    Msg*: UINT
    Action*: int16
    Flags*: int16
    Unused*: HRESULT

  TWMChangeUIState* = TWMUIState
  TWMUpdateUIState* = TWMUIState
  TWMKey* {.final, pure.} = object
    Msg*: UINT
    CharCode*: int16
    Unused*: int16
    KeyData*: int32
    Result*: LRESULT

  TWMKeyDown* = TWMKey
  TWMKeyUp* = TWMKey
  TWMChar* = TWMKey
  TWMSysChar* = TWMKey
  TWMSysKeyDown* = TWMKey
  TWMSysKeyUp* = TWMKey
  TWMMenuChar* {.final, pure.} = object
    Msg*: UINT
    User*: Char
    MenuFlag*: int16
    Menu*: HMENU
    Result*: LRESULT

  TWMGetDlgCode* = TWMNoParams
  TWMFontChange* = TWMNoParams
  TWMGetFont* = TWMNoParams
  TWMSysColorChange* = TWMNoParams
  TWMQueryDragIcon* = TWMNoParams
  TWMScroll* {.final, pure.} = object
    Msg*: UINT
    ScrollCode*: HALFPARAM
    Pos*: HALFPARAM
    ScrollBar*: HWND
    Result*: LRESULT

  TWMHScroll* = TWMScroll
  TWMVScroll* = TWMScroll
  TWMGetText* {.final, pure.} = object
    Msg*: UINT
    TextMax*: LPARAM
    Text*: cstring
    Result*: LRESULT

  TWMGetTextLength* = TWMNoParams
  TWMKillFocus* {.final, pure.} = object
    Msg*: UINT
    FocusedWnd*: HWND
    UnUsed*: WPARAM
    Result*: LRESULT

  TWMSetCursor* {.final, pure.} = object
    Msg*: UINT
    CursorWnd*: HWND
    HitTest*: HALFPARAM
    MouseMsg*: HALFPARAM
    Result*: LRESULT

  TWMSetFocus* {.final, pure.} = object
    Msg*: UINT
    FocusedWnd*: HWND
    Unused*: WPARAM
    Result*: LRESULT

  TWMSetFont* {.final, pure.} = object
    Msg*: UINT
    Font*: HFONT
    Redraw*: HALFPARAMBOOL
    Unused*: HALFPARAM
    Result*: LRESULT

  TWMShowWindow* {.final, pure.} = object
    Msg*: UINT
    Show*: HALFPARAMBOOL
    Unused*: HALFPARAM
    Status*: WPARAM
    Result*: LRESULT

  TWMEraseBkgnd* {.final, pure.} = object
    Msg*: UINT
    DC*: HDC
    Unused*: LPARAM
    Result*: LRESULT

  TWMNCHitTest* {.final, pure.} = object
    Msg*: UINT
    Unused*: int32
    Pos*: TSmallPoint
    Result*: LRESULT

  TWMMouse* {.final, pure.} = object
    Msg*: UINT
    Keys*: int32
    Pos*: TSmallPoint
    Result*: LRESULT

  TWMLButtonDblClk* = TWMMouse
  TWMLButtonDown* = TWMMouse
  TWMLButtonUp* = TWMMouse
  TWMMButtonDblClk* = TWMMouse
  TWMMButtonDown* = TWMMouse
  TWMMButtonUp* = TWMMouse
  TWMMouseWheel* {.final, pure.} = object
    Msg*: UINT
    Keys*: int16
    WheelDelta*: int16
    Pos*: TSmallPoint
    Result*: LRESULT

  TWMNCHitMessage* {.final, pure.} = object
    Msg*: UINT
    HitTest*: int32
    XCursor*: int16
    YCursor*: int16
    Result*: LRESULT

  TWMNCLButtonDblClk* = TWMNCHitMessage
  TWMNCLButtonDown* = TWMNCHitMessage
  TWMNCLButtonUp* = TWMNCHitMessage
  TWMNCMButtonDblClk* = TWMNCHitMessage
  TWMNCMButtonDown* = TWMNCHitMessage
  TWMNCMButtonUp* = TWMNCHitMessage
  TWMNCMouseMove* = TWMNCHitMessage
  TWMRButtonDblClk* = TWMMouse
  TWMRButtonDown* = TWMMouse
  TWMRButtonUp* = TWMMouse
  TWMMouseMove* = TWMMouse
  TWMPaint* {.final, pure.} = object
    Msg*: UINT
    DC*: HDC
    Unused*: int32
    Result*: LRESULT

  TWMCommand* {.final, pure.} = object
    Msg*: UINT
    ItemID*: int16
    NotifyCode*: int16
    Ctl*: HWND
    Result*: LRESULT

  TWMNotify* {.final, pure.} = object
    Msg*: UINT
    IDCtrl*: int32
    NMHdr*: PNMHdr
    Result*: LRESULT

  TWMPrint* {.final, pure.} = object
    Msg*: UINT
    DC*: HDC
    Flags*: int
    Result*: LRESULT

  TWMPrintClient* = TWMPrint
  TWMWinIniChange* {.final, pure.} = object
    Msg*: UINT
    Unused*: int
    Section*: cstring
    Result*: LRESULT

  TWMContextMenu* {.final, pure.} = object
    Msg*: UINT
    hWnd*: HWND
    Pos*: TSmallPoint
    Result*: LRESULT

  TWMNCCalcSize* {.final, pure.} = object
    Msg*: UINT
    CalcValidRects*: WINBOOL
    CalcSize_Params*: PNCCalcSizeParams
    Result*: LRESULT

  TWMCharToItem* {.final, pure.} = object
    Msg*: UINT
    Key*: int16
    CaretPos*: int16
    ListBox*: HWND
    Result*: LRESULT

  TWMVKeyToItem* = TWMCharToItem
  TMyEventRange = range[0'i16..16000'i16]
  TWMParentNotify* {.final, pure.} = object
    Msg*: UINT
    case Event*: TMyEventRange
    of TMyEventRange(WM_CREATE), TMyEventRange(WM_DESTROY):
        ChildID*: int16
        ChildWnd*: HWnd

    of TMyEventRange(WM_LBUTTONDOWN),
      TMyEventRange(WM_MBUTTONDOWN),
      TMyEventRange(WM_RBUTTONDOWN):
        Value*: int16
        XPos*: int16
        YPos*: int16

    else:
        Value1*: int16
        Value2*: int32
        Result*: LRESULT

  TWMSysCommand* {.final, pure.} = object
    Msg*: UINT
    CmdType*: int32
    XPos*: int16
    YPos*: int16
    Result*: LRESULT
  #  case CmdType*: int32
  #  of SC_HOTKEY:
  #      ActivateWnd*: HWND
  #  of SC_CLOSE, SC_HSCROLL, SC_MAXIMIZE, SC_MINIMIZE, SC_MOUSEMENU, SC_MOVE,
  #     SC_NEXTWINDOW, SC_PREVWINDOW, SC_RESTORE, SC_SCREENSAVE, SC_SIZE,
  #     SC_TASKLIST, SC_VSCROLL:
  #      XPos*: int16
  #      YPos*: int16
  #      Result*: LRESULT
  #  else: # of SC_KEYMENU:
  #      Key*: int16

  TWMMove* {.final, pure.} = object
    Msg*: UINT
    Unused*: int
    Pos*: TSmallPoint
    Result*: LRESULT

  TWMWindowPosMsg* {.final, pure.} = object
    Msg*: UINT
    Unused*: int
    WindowPos*: PWindowPos
    Result*: LRESULT

  TWMWindowPosChanged* = TWMWindowPosMsg
  TWMWindowPosChanging* = TWMWindowPosMsg
  TWMCompareItem* {.final, pure.} = object
    Msg*: UINT
    Ctl*: HWnd
    CompareItemStruct*: PCompareItemStruct
    Result*: LRESULT

  TWMDeleteItem* {.final, pure.} = object
    Msg*: UINT
    Ctl*: HWND
    DeleteItemStruct*: PDeleteItemStruct
    Result*: LRESULT

  TWMDrawItem* {.final, pure.} = object
    Msg*: UINT
    Ctl*: HWND
    DrawItemStruct*: PDrawItemStruct
    Result*: LRESULT

  TWMMeasureItem* {.final, pure.} = object
    Msg*: UINT
    IDCtl*: HWnd
    MeasureItemStruct*: PMeasureItemStruct
    Result*: LRESULT

  TWMNCCreate* {.final, pure.} = object
    Msg*: UINT
    Unused*: int
    CreateStruct*: PCreateStruct
    Result*: LRESULT

  TWMInitMenuPopup* {.final, pure.} = object
    Msg*: UINT
    MenuPopup*: HMENU
    Pos*: int16
    SystemMenu*: WordBool
    Result*: LRESULT

  TWMMenuSelect* {.final, pure.} = object
    Msg*: UINT
    IDItem*: int16
    MenuFlag*: int16
    Menu*: HMENU
    Result*: LRESULT

  TWMActivate* {.final, pure.} = object
    Msg*: UINT
    Active*: int16
    Minimized*: WordBool
    ActiveWindow*: HWND
    Result*: LRESULT

  TWMQueryEndSession* {.final, pure.} = object
    Msg*: UINT
    Source*: int32
    Unused*: int32
    Result*: LRESULT

  TWMMDIActivate* {.final, pure.} = object
    Msg*: UINT
    DeactiveWnd*: HWND
    ActiveWnd*: HWND
    Result*: LRESULT

  TWMNextDlgCtl* {.final, pure.} = object
    Msg*: UINT
    CtlFocus*: int32
    Handle*: WordBool
    Unused*: int16
    Result*: LRESULT

  TWMHelp* {.final, pure.} = object
    Msg*: UINT
    Unused*: int
    HelpInfo*: PHelpInfo
    Result*: LRESULT

  TWMGetMinMaxInfo* {.final, pure.} = object
    Msg*: UINT
    Unused*: int
    MinMaxInfo*: PMinMaxInfo
    Result*: LRESULT

  TWMSettingChange* {.final, pure.} = object
    Msg*: UINT
    Flag*: int
    Section*: cstring
    Result*: LRESULT

  TWMCreate* {.final, pure.} = object
    Msg*: UINT
    Unused*: int
    CreateStruct*: PCreateStruct
    Result*: LRESULT

  TWMCtlColor* {.final, pure.} = object
    Msg*: UINT
    ChildDC*: HDC
    ChildWnd*: HWND
    Result*: LRESULT

  TWMCtlColorScrollbar* = TWMCtlColor
  TWMCtlColorStatic* = TWMCtlColor
  TWMCtlColorBtn* = TWMCtlColor
  TWMCtlColorListbox* = TWMCtlColor
  TWMCtlColorMsgbox* = TWMCtlColor
  TWMCtlColorDlg* = TWMCtlColor
  TWMCtlColorEdit* = TWMCtlColor
  TWMInitDialog* {.final, pure.} = object
    Msg*: UINT
    Focus*: HWND
    InitParam*: int32
    Result*: LRESULT

  TWMNCPaint* {.final, pure.} = object
    Msg*: UINT
    RGN*: HRGN
    Unused*: int32
    Result*: LRESULT

  TWMSetText* {.final, pure.} = object
    Msg*: UINT
    Unused*: int32
    Text*: cstring
    Result*: LRESULT

  TWMSizeClipboard* {.final, pure.} = object
    Msg*: UINT
    Viewer*: HWND
    RC*: THandle
    Result*: LRESULT

  TWMSpoolerStatus* {.final, pure.} = object
    Msg*: UINT
    JobStatus*: LPARAM
    JobsLeft*: WPARAM
    Unused*: WPARAM
    Result*: LRESULT

  TWMStyleChange* {.final, pure.} = object
    Msg*: UINT
    StyleType*: LPARAM
    StyleStruct*: PStyleStruct
    Result*: LRESULT

  TWMStyleChanged* = TWMStyleChange
  TWMStyleChanging* = TWMStyleChange
  TWMSysDeadChar* {.final, pure.} = object
    Msg*: UINT
    CharCode*: WPARAM
    Unused*: WPARAM
    KeyData*: LPARAM
    Result*: LRESULT

  TWMSystemError* {.final, pure.} = object
    Msg*: UINT
    ErrSpec*: WPARAM
    Unused*: LPARAM
    Result*: LRESULT

  TWMTimeChange* = TWMNoParams
  TWMTimer* {.final, pure.} = object
    Msg*: UINT
    TimerID*: LPARAM
    TimerProc*: TFarProc
    Result*: LRESULT

  TWMUndo* = TWMNoParams
  TWMVScrollClipboard* {.final, pure.} = object
    Msg*: UINT
    Viewer*: HWND
    ScollCode*: WPARAM
    ThumbPos*: WPARAM
    Result*: LRESULT

  TWMDisplayChange* {.final, pure.} = object
    Msg*: UINT
    BitsPerPixel*: int
    Width*: WPARAM
    Height*: WPARAM
    Result*: LRESULT

  TWMDropFiles* {.final, pure.} = object
    Msg*: UINT
    Drop*: THANDLE
    Unused*: LPARAM
    Result*: LRESULT

  TWMEnable* {.final, pure.} = object
    Msg*: int
    Enabled*: WINBOOL
    Unused*: int32
    Result*: int32

  TWMMouseActivate* {.final, pure.} = object
    Msg*: int
    TopLevel*: HWND
    HitTestCode*: int16
    MouseMsg*: int16
    Result*: int32


proc GetBinaryTypeA*(lpApplicationName: LPCSTR, lpBinaryType: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetBinaryTypeA".}

proc GetShortPathNameA*(lpszLongPath: LPCSTR, lpszShortPath: LPSTR,
                        cchBuffer: DWORD): DWORD{.stdcall,
                        dynlib: "kernel32", importc.}
proc GetEnvironmentStringsA*(): LPSTR{.stdcall, dynlib: "kernel32", importc.}
proc FreeEnvironmentStringsA*(para1: LPSTR): WINBOOL{.stdcall, dynlib: "kernel32", importc.}
proc FormatMessageA*(dwFlags: DWORD, lpSource: LPCVOID, dwMessageId: DWORD,
                     dwLanguageId: DWORD, lpBuffer: LPSTR, nSize: DWORD,
                     Arguments: va_list): DWORD{.stdcall,dynlib: "kernel32", importc.}
proc CreateMailslotA*(lpName: LPCSTR, nMaxMessageSize: DWORD,
                      lReadTimeout: DWORD,
                      lpSecurityAttributes: LPSECURITY_ATTRIBUTES): HANDLE{.
    stdcall, dynlib: "kernel32", importc.}
proc lstrcmpA*(lpString1: LPCSTR, lpString2: LPCSTR): int32{.stdcall,
  dynlib: "kernel32", importc.}
proc lstrcmpiA*(lpString1: LPCSTR, lpString2: LPCSTR): int32{.stdcall, dynlib: "kernel32", importc.}
proc lstrcpynA*(lpString1: LPSTR, lpString2: LPCSTR, iMaxLength: int32): LPSTR{.
    stdcall, dynlib: "kernel32", importc.}
proc CreateMutexA*(lpMutexAttributes: LPSECURITY_ATTRIBUTES,
                   bInitialOwner: WINBOOL, lpName: LPCSTR): HANDLE{.stdcall,
                   dynlib: "kernel32", importc.}
proc OpenMutexA*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL, lpName: LPCSTR): HANDLE{.
    stdcall, dynlib: "kernel32", importc.}
proc CreateEventA*(lpEventAttributes: LPSECURITY_ATTRIBUTES,
                   bManualReset: WINBOOL, bInitialState: WINBOOL, lpName: LPCSTR): HANDLE{.
    stdcall, dynlib: "kernel32", importc.}
proc OpenEventA*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL, lpName: LPCSTR): HANDLE{.
    stdcall, dynlib: "kernel32", importc.}
proc CreateSemaphoreA*(lpSemaphoreAttributes: LPSECURITY_ATTRIBUTES,
                       lInitialCount: LONG, lMaximumCount: LONG, lpName: LPCSTR): HANDLE{.
    stdcall, dynlib: "kernel32", importc.}
proc OpenSemaphoreA*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                     lpName: LPCSTR): HANDLE{.stdcall,
                     dynlib: "kernel32", importc.}
proc CreateFileMappingA*(hFile: HANDLE,
                         lpFileMappingAttributes: LPSECURITY_ATTRIBUTES,
                         flProtect: DWORD, dwMaximumSizeHigh: DWORD,
                         dwMaximumSizeLow: DWORD, lpName: LPCSTR): HANDLE{.
    stdcall, dynlib: "kernel32", importc.}
proc OpenFileMappingA*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                       lpName: LPCSTR): HANDLE{.stdcall,
                       dynlib: "kernel32", importc.}
proc GetLogicalDriveStringsA*(nBufferLength: DWORD, lpBuffer: LPSTR): DWORD{.
    stdcall, dynlib: "kernel32", importc.}
proc LoadLibraryA*(lpLibFileName: LPCSTR): HINST{.stdcall,
  dynlib: "kernel32", importc.}
proc LoadLibraryExA*(lpLibFileName: LPCSTR, hFile: HANDLE, dwFlags: DWORD): HINST{.
    stdcall, dynlib: "kernel32", importc.}
proc GetModuleFileNameA*(hModule: HINST, lpFilename: LPSTR, nSize: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc.}
proc GetModuleHandleA*(lpModuleName: LPCSTR): HMODULE{.stdcall,
     dynlib: "kernel32", importc.}
proc FatalAppExitA*(uAction: UINT, lpMessageText: LPCSTR){.stdcall,
     dynlib: "kernel32", importc.}
proc GetCommandLineA*(): LPSTR{.stdcall, dynlib: "kernel32", importc.}
proc GetEnvironmentVariableA*(lpName: LPCSTR, lpBuffer: LPSTR, nSize: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc.}
proc SetEnvironmentVariableA*(lpName: LPCSTR, lpValue: LPCSTR): WINBOOL{.stdcall,
  dynlib: "kernel32", importc.}
proc ExpandEnvironmentStringsA*(lpSrc: LPCSTR, lpDst: LPSTR, nSize: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc.}
proc OutputDebugStringA*(lpOutputString: LPCSTR){.stdcall,
   dynlib: "kernel32", importc.}
proc FindResourceA*(hModule: HINST, lpName: LPCSTR, lpType: LPCSTR): HRSRC{.
    stdcall, dynlib: "kernel32", importc.}
proc FindResourceExA*(hModule: HINST, lpType: LPCSTR, lpName: LPCSTR,
                      wLanguage: int16): HRSRC{.stdcall,
                      dynlib: "kernel32", importc.}
proc EnumResourceTypesA*(hModule: HINST, lpEnumFunc: ENUMRESTYPEPROC,
                         lParam: LONG): WINBOOL{.stdcall,
                         dynlib: "kernel32", importc.}
proc EnumResourceNamesA*(hModule: HINST, lpType: LPCSTR,
                         lpEnumFunc: ENUMRESNAMEPROC, lParam: LONG): WINBOOL{.
    stdcall, dynlib: "kernel32", importc.}
proc EnumResourceLanguagesA*(hModule: HINST, lpType: LPCSTR, lpName: LPCSTR,
                             lpEnumFunc: ENUMRESLANGPROC, lParam: LONG): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "EnumResourceLanguagesA".}

proc BeginUpdateResourceA*(pFileName: LPCSTR, bDeleteExistingResources: WINBOOL): HANDLE{.
    stdcall, dynlib: "kernel32", importc: "BeginUpdateResourceA".}

proc UpdateResourceA*(hUpdate: HANDLE, lpType: LPCSTR, lpName: LPCSTR,
                      wLanguage: int16, lpData: LPVOID, cbData: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "UpdateResourceA".}
proc EndUpdateResourceA*(hUpdate: HANDLE, fDiscard: WINBOOL): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "EndUpdateResourceA".}
proc GlobalAddAtomA*(lpString: LPCSTR): ATOM{.stdcall, dynlib: "kernel32",
    importc: "GlobalAddAtomA".}
proc GlobalFindAtomA*(lpString: LPCSTR): ATOM{.stdcall, dynlib: "kernel32",
    importc: "GlobalFindAtomA".}
proc GlobalGetAtomNameA*(nAtom: ATOM, lpBuffer: LPSTR, nSize: int32): UINT{.
    stdcall, dynlib: "kernel32", importc: "GlobalGetAtomNameA".}
proc AddAtomA*(lpString: LPCSTR): ATOM{.stdcall, dynlib: "kernel32",
                                        importc: "AddAtomA".}
proc FindAtomA*(lpString: LPCSTR): ATOM{.stdcall, dynlib: "kernel32",
    importc: "FindAtomA".}
proc GetAtomNameA*(nAtom: ATOM, lpBuffer: LPSTR, nSize: int32): UINT{.stdcall,
    dynlib: "kernel32", importc: "GetAtomNameA".}
proc GetProfileIntA*(lpAppName: LPCSTR, lpKeyName: LPCSTR, nDefault: WINT): UINT{.
    stdcall, dynlib: "kernel32", importc: "GetProfileIntA".}
proc GetProfileStringA*(lpAppName: LPCSTR, lpKeyName: LPCSTR, lpDefault: LPCSTR,
                        lpReturnedString: LPSTR, nSize: DWORD): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetProfileStringA".}
proc WriteProfileStringA*(lpAppName: LPCSTR, lpKeyName: LPCSTR, lpString: LPCSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteProfileStringA".}
proc GetProfileSectionA*(lpAppName: LPCSTR, lpReturnedString: LPSTR,
                         nSize: DWORD): DWORD{.stdcall, dynlib: "kernel32",
    importc: "GetProfileSectionA".}
proc WriteProfileSectionA*(lpAppName: LPCSTR, lpString: LPCSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteProfileSectionA".}
proc GetPrivateProfileIntA*(lpAppName: LPCSTR, lpKeyName: LPCSTR,
                            nDefault: WINT, lpFileName: LPCSTR): UINT{.stdcall,
    dynlib: "kernel32", importc: "GetPrivateProfileIntA".}
proc GetPrivateProfileStringA*(lpAppName: LPCSTR, lpKeyName: LPCSTR,
                               lpDefault: LPCSTR, lpReturnedString: LPSTR,
                               nSize: DWORD, lpFileName: LPCSTR): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetPrivateProfileStringA".}

proc WritePrivateProfileStringA*(lpAppName: LPCSTR, lpKeyName: LPCSTR,
                                 lpString: LPCSTR, lpFileName: LPCSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WritePrivateProfileStringA".}
proc GetPrivateProfileSectionA*(lpAppName: LPCSTR, lpReturnedString: LPSTR,
                                nSize: DWORD, lpFileName: LPCSTR): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetPrivateProfileSectionA".}
proc WritePrivateProfileSectionA*(lpAppName: LPCSTR, lpString: LPCSTR,
                                  lpFileName: LPCSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WritePrivateProfileSectionA".}
proc GetDriveTypeA*(lpRootPathName: LPCSTR): UINT{.stdcall, dynlib: "kernel32",
    importc: "GetDriveTypeA".}
proc GetSystemDirectoryA*(lpBuffer: LPSTR, uSize: UINT): UINT{.stdcall,
    dynlib: "kernel32", importc: "GetSystemDirectoryA".}
proc GetTempPathA*(nBufferLength: DWORD, lpBuffer: LPSTR): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetTempPathA".}
proc GetTempFileNameA*(lpPathName: LPCSTR, lpPrefixString: LPCSTR,
                       uUnique: UINT, lpTempFileName: LPSTR): UINT{.stdcall,
    dynlib: "kernel32", importc: "GetTempFileNameA".}
proc GetWindowsDirectoryA*(lpBuffer: LPSTR, uSize: UINT): UINT{.stdcall,
    dynlib: "kernel32", importc: "GetWindowsDirectoryA".}
proc SetCurrentDirectoryA*(lpPathName: LPCSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetCurrentDirectoryA".}
proc GetCurrentDirectoryA*(nBufferLength: DWORD, lpBuffer: LPSTR): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetCurrentDirectoryA".}
proc GetDiskFreeSpaceA*(lpRootPathName: LPCSTR, lpSectorsPerCluster: LPDWORD,
                        lpBytesPerSector: LPDWORD,
                        lpNumberOfFreeClusters: LPDWORD,
                        lpTotalNumberOfClusters: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetDiskFreeSpaceA".}
proc CreateDirectoryA*(lpPathName: LPCSTR,

                       lpSecurityAttributes: LPSECURITY_ATTRIBUTES): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CreateDirectoryA".}
proc CreateDirectoryExA*(lpTemplateDirectory: LPCSTR, lpNewDirectory: LPCSTR,
                         lpSecurityAttributes: LPSECURITY_ATTRIBUTES): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CreateDirectoryExA".}
proc RemoveDirectoryA*(lpPathName: LPCSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "RemoveDirectoryA".}
proc GetFullPathNameA*(lpFileName: LPCSTR, nBufferLength: DWORD,
                       lpBuffer: LPSTR, lpFilePart: var LPSTR): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetFullPathNameA".}
proc DefineDosDeviceA*(dwFlags: DWORD, lpDeviceName: LPCSTR,
                       lpTargetPath: LPCSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "DefineDosDeviceA".}
proc QueryDosDeviceA*(lpDeviceName: LPCSTR, lpTargetPath: LPSTR, ucchMax: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc: "QueryDosDeviceA".}
proc CreateFileA*(lpFileName: LPCSTR, dwDesiredAccess: DWORD,
                  dwShareMode: DWORD,
                  lpSecurityAttributes: LPSECURITY_ATTRIBUTES,
                  dwCreationDisposition: DWORD, dwFlagsAndAttributes: DWORD,
                  hTemplateFile: HANDLE): HANDLE{.stdcall, dynlib: "kernel32",
    importc: "CreateFileA".}
proc SetFileAttributesA*(lpFileName: LPCSTR, dwFileAttributes: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetFileAttributesA".}
proc GetFileAttributesA*(lpFileName: LPCSTR): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetFileAttributesA".}
proc GetCompressedFileSizeA*(lpFileName: LPCSTR, lpFileSizeHigh: LPDWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetCompressedFileSizeA".}
proc DeleteFileA*(lpFileName: LPCSTR): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "DeleteFileA".}
proc SearchPathA*(lpPath: LPCSTR, lpFileName: LPCSTR, lpExtension: LPCSTR,
                  nBufferLength: DWORD, lpBuffer: LPSTR, lpFilePart: LPSTR): DWORD{.
    stdcall, dynlib: "kernel32", importc: "SearchPathA".}
proc CopyFileA*(lpExistingFileName: LPCSTR, lpNewFileName: LPCSTR,
                bFailIfExists: WINBOOL): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "CopyFileA".}
proc MoveFileA*(lpExistingFileName: LPCSTR, lpNewFileName: LPCSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "MoveFileA".}
proc MoveFileExA*(lpExistingFileName: LPCSTR, lpNewFileName: LPCSTR,
                  dwFlags: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "MoveFileExA".}
proc CreateNamedPipeA*(lpName: LPCSTR, dwOpenMode: DWORD, dwPipeMode: DWORD,
                       nMaxInstances: DWORD, nOutBufferSize: DWORD,
                       nInBufferSize: DWORD, nDefaultTimeOut: DWORD,
                       lpSecurityAttributes: LPSECURITY_ATTRIBUTES): HANDLE{.
    stdcall, dynlib: "kernel32", importc: "CreateNamedPipeA".}
proc GetNamedPipeHandleStateA*(hNamedPipe: HANDLE, lpState: LPDWORD,
                               lpCurInstances: LPDWORD,
                               lpMaxCollectionCount: LPDWORD,
                               lpCollectDataTimeout: LPDWORD, lpUserName: LPSTR,
                               nMaxUserNameSize: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetNamedPipeHandleStateA".}
proc CallNamedPipeA*(lpNamedPipeName: LPCSTR, lpInBuffer: LPVOID,
                     nInBufferSize: DWORD, lpOutBuffer: LPVOID,
                     nOutBufferSize: DWORD, lpBytesRead: LPDWORD,
                     nTimeOut: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "CallNamedPipeA".}
proc WaitNamedPipeA*(lpNamedPipeName: LPCSTR, nTimeOut: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WaitNamedPipeA".}
proc SetVolumeLabelA*(lpRootPathName: LPCSTR, lpVolumeName: LPCSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetVolumeLabelA".}
proc GetVolumeInformationA*(lpRootPathName: LPCSTR, lpVolumeNameBuffer: LPSTR,
                            nVolumeNameSize: DWORD,
                            lpVolumeSerialNumber: LPDWORD,
                            lpMaximumComponentLength: LPDWORD,
                            lpFileSystemFlags: LPDWORD,
                            lpFileSystemNameBuffer: LPSTR,
                            nFileSystemNameSize: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetVolumeInformationA".}
proc ClearEventLogA*(hEventLog: HANDLE, lpBackupFileName: LPCSTR): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "ClearEventLogA".}
proc BackupEventLogA*(hEventLog: HANDLE, lpBackupFileName: LPCSTR): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "BackupEventLogA".}
proc OpenEventLogA*(lpUNCServerName: LPCSTR, lpSourceName: LPCSTR): HANDLE{.
    stdcall, dynlib: "advapi32", importc: "OpenEventLogA".}
proc RegisterEventSourceA*(lpUNCServerName: LPCSTR, lpSourceName: LPCSTR): HANDLE{.
    stdcall, dynlib: "advapi32", importc: "RegisterEventSourceA".}
proc OpenBackupEventLogA*(lpUNCServerName: LPCSTR, lpFileName: LPCSTR): HANDLE{.
    stdcall, dynlib: "advapi32", importc: "OpenBackupEventLogA".}
proc ReadEventLogA*(hEventLog: HANDLE, dwReadFlags: DWORD,
                    dwRecordOffset: DWORD, lpBuffer: LPVOID,
                    nNumberOfBytesToRead: DWORD, pnBytesRead: LPDWORD,
                    pnMinNumberOfBytesNeeded: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ReadEventLogA".}
proc ReportEventA*(hEventLog: HANDLE, wType: int16, wCategory: int16,
                   dwEventID: DWORD, lpUserSid: PSID, wNumStrings: int16,
                   dwDataSize: DWORD, lpStrings: LPPCSTR, lpRawData: LPVOID): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "ReportEventA".}
proc AccessCheckAndAuditAlarmA*(SubsystemName: LPCSTR, HandleId: LPVOID,
                                ObjectTypeName: LPSTR, ObjectName: LPSTR,
                                SecurityDescriptor: PSECURITY_DESCRIPTOR,
                                DesiredAccess: DWORD,
                                GenericMapping: PGENERIC_MAPPING,
                                ObjectCreation: WINBOOL, GrantedAccess: LPDWORD,
                                AccessStatus: LPBOOL, pfGenerateOnClose: LPBOOL): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "AccessCheckAndAuditAlarmA".}
proc ObjectOpenAuditAlarmA*(SubsystemName: LPCSTR, HandleId: LPVOID,
                            ObjectTypeName: LPSTR, ObjectName: LPSTR,
                            pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                            ClientToken: HANDLE, DesiredAccess: DWORD,
                            GrantedAccess: DWORD, Privileges: PPRIVILEGE_SET,
                            ObjectCreation: WINBOOL, AccessGranted: WINBOOL,
                            GenerateOnClose: LPBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ObjectOpenAuditAlarmA".}
proc ObjectPrivilegeAuditAlarmA*(SubsystemName: LPCSTR, HandleId: LPVOID,
                                 ClientToken: HANDLE, DesiredAccess: DWORD,
                                 Privileges: PPRIVILEGE_SET,
                                 AccessGranted: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ObjectPrivilegeAuditAlarmA".}
proc ObjectCloseAuditAlarmA*(SubsystemName: LPCSTR, HandleId: LPVOID,
                             GenerateOnClose: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ObjectCloseAuditAlarmA".}
proc PrivilegedServiceAuditAlarmA*(SubsystemName: LPCSTR, ServiceName: LPCSTR,
                                   ClientToken: HANDLE,
                                   Privileges: PPRIVILEGE_SET,
                                   AccessGranted: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "PrivilegedServiceAuditAlarmA".}
proc SetFileSecurityA*(lpFileName: LPCSTR,
                       SecurityInformation: SECURITY_INFORMATION,
                       pSecurityDescriptor: PSECURITY_DESCRIPTOR): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "SetFileSecurityA".}
proc GetFileSecurityA*(lpFileName: LPCSTR,
                       RequestedInformation: SECURITY_INFORMATION,
                       pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                       nLength: DWORD, lpnLengthNeeded: LPDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetFileSecurityA".}
proc FindFirstChangeNotificationA*(lpPathName: LPCSTR, bWatchSubtree: WINBOOL,
                                   dwNotifyFilter: DWORD): HANDLE{.stdcall,
    dynlib: "kernel32", importc: "FindFirstChangeNotificationA".}
proc IsBadStringPtrA*(lpsz: LPCSTR, ucchMax: UINT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "IsBadStringPtrA".}
proc LookupAccountSidA*(lpSystemName: LPCSTR, Sid: PSID, Name: LPSTR,
                        cbName: LPDWORD, ReferencedDomainName: LPSTR,
                        cbReferencedDomainName: LPDWORD, peUse: PSID_NAME_USE): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "LookupAccountSidA".}
proc LookupAccountNameA*(lpSystemName: LPCSTR, lpAccountName: LPCSTR, Sid: PSID,
                         cbSid: LPDWORD, ReferencedDomainName: LPSTR,
                         cbReferencedDomainName: LPDWORD, peUse: PSID_NAME_USE): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "LookupAccountNameA".}
proc LookupPrivilegeValueA*(lpSystemName: LPCSTR, lpName: LPCSTR, lpLuid: PLUID): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "LookupPrivilegeValueA".}
proc LookupPrivilegeNameA*(lpSystemName: LPCSTR, lpLuid: PLUID, lpName: LPSTR,
                           cbName: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupPrivilegeNameA".}
proc LookupPrivilegeDisplayNameA*(lpSystemName: LPCSTR, lpName: LPCSTR,
                                  lpDisplayName: LPSTR, cbDisplayName: LPDWORD,
                                  lpLanguageId: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupPrivilegeDisplayNameA".}
proc BuildCommDCBA*(lpDef: LPCSTR, lpDCB: LPDCB): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "BuildCommDCBA".}
proc BuildCommDCBAndTimeoutsA*(lpDef: LPCSTR, lpDCB: LPDCB,
                               lpCommTimeouts: LPCOMMTIMEOUTS): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "BuildCommDCBAndTimeoutsA".}
proc CommConfigDialogA*(lpszName: LPCSTR, wnd: HWND, lpCC: LPCOMMCONFIG): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CommConfigDialogA".}
proc GetDefaultCommConfigA*(lpszName: LPCSTR, lpCC: LPCOMMCONFIG,
                            lpdwSize: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetDefaultCommConfigA".}
proc SetDefaultCommConfigA*(lpszName: LPCSTR, lpCC: LPCOMMCONFIG, dwSize: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetDefaultCommConfigA".}
proc GetComputerNameA*(lpBuffer: LPSTR, nSize: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetComputerNameA".}
proc SetComputerNameA*(lpComputerName: LPCSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetComputerNameA".}
proc GetUserNameA*(lpBuffer: LPSTR, nSize: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "GetUserNameA".}
proc LoadKeyboardLayoutA*(pwszKLID: LPCSTR, Flags: UINT): HKL{.stdcall,
    dynlib: "user32", importc: "LoadKeyboardLayoutA".}
proc GetKeyboardLayoutNameA*(pwszKLID: LPSTR): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetKeyboardLayoutNameA".}
proc CreateDesktopA*(lpszDesktop: LPSTR, lpszDevice: LPSTR, pDevmode: LPDEVMODE,
                     dwFlags: DWORD, dwDesiredAccess: DWORD,
                     lpsa: LPSECURITY_ATTRIBUTES): HDESK{.stdcall,
    dynlib: "user32", importc: "CreateDesktopA".}
proc OpenDesktopA*(lpszDesktop: LPSTR, dwFlags: DWORD, fInherit: WINBOOL,
                   dwDesiredAccess: DWORD): HDESK{.stdcall, dynlib: "user32",
    importc: "OpenDesktopA".}
proc EnumDesktopsA*(hwinsta: HWINSTA, lpEnumFunc: DESKTOPENUMPROC,
                    lp: LPARAM): WINBOOL{.stdcall, dynlib: "user32",
    importc: "EnumDesktopsA".}
proc CreateWindowStationA*(lpwinsta: LPSTR, dwReserved: DWORD,
                           dwDesiredAccess: DWORD, lpsa: LPSECURITY_ATTRIBUTES): HWINSTA{.
    stdcall, dynlib: "user32", importc: "CreateWindowStationA".}
proc OpenWindowStationA*(lpszWinSta: LPSTR, fInherit: WINBOOL,
                         dwDesiredAccess: DWORD): HWINSTA{.stdcall,
    dynlib: "user32", importc: "OpenWindowStationA".}
proc EnumWindowStationsA*(lpEnumFunc: ENUMWINDOWSTATIONPROC, lp: LPARAM): WINBOOL{.
    stdcall, dynlib: "user32", importc: "EnumWindowStationsA".}
proc GetUserObjectInformationA*(hObj: HANDLE, nIndex: int32, pvInfo: PVOID,
                                nLength: DWORD, lpnLengthNeeded: LPDWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetUserObjectInformationA".}
proc SetUserObjectInformationA*(hObj: HANDLE, nIndex: int32, pvInfo: PVOID,
                                nLength: DWORD): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetUserObjectInformationA".}
proc RegisterWindowMessageA*(lpString: LPCSTR): UINT{.stdcall, dynlib: "user32",
    importc: "RegisterWindowMessageA".}
proc GetMessageA*(lpMsg: LPMSG, wnd: HWND, wMsgFilterMin: UINT,
                  wMsgFilterMax: UINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "GetMessageA".}
proc DispatchMessageA*(lpMsg: LPMSG): LONG{.stdcall, dynlib: "user32",
    importc: "DispatchMessageA".}
proc PeekMessageA*(lpMsg: LPMSG, wnd: HWND, wMsgFilterMin: UINT,
                   wMsgFilterMax: UINT, wRemoveMsg: UINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "PeekMessageA".}
proc SendMessageA*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
    stdcall, dynlib: "user32", importc: "SendMessageA".}
proc SendMessageTimeoutA*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM,
                          fuFlags: UINT, uTimeout: UINT, lpdwResult: LPDWORD): LRESULT{.
    stdcall, dynlib: "user32", importc: "SendMessageTimeoutA".}
proc SendNotifyMessageA*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SendNotifyMessageA".}
proc SendMessageCallbackA*(wnd: HWND, Msg: UINT, wp: WPARAM,
                           lp: LPARAM, lpResultCallBack: SENDASYNCPROC,
                           dwData: DWORD): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SendMessageCallbackA".}
proc PostMessageA*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): WINBOOL{.
    stdcall, dynlib: "user32", importc: "PostMessageA".}
proc PostThreadMessageA*(idThread: DWORD, Msg: UINT, wp: WPARAM,
                         lp: LPARAM): WINBOOL{.stdcall, dynlib: "user32",
    importc: "PostThreadMessageA".}
proc DefWindowProcA*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
    stdcall, dynlib: "user32", importc: "DefWindowProcA".}
proc CallWindowProcA*(lpPrevWndFunc: WNDPROC, wnd: HWND, Msg: UINT,
                      wp: WPARAM, lp: LPARAM): LRESULT{.stdcall,
    dynlib: "user32", importc: "CallWindowProcA".}
proc RegisterClassA*(lpWndClass: LPWNDCLASS): ATOM{.stdcall, dynlib: "user32",
    importc: "RegisterClassA".}
proc UnregisterClassA*(lpClassName: LPCSTR, hInstance: HINST): WINBOOL{.stdcall,
    dynlib: "user32", importc: "UnregisterClassA".}
proc GetClassInfoA*(hInstance: HINST, lpClassName: LPCSTR,
                    lpWndClass: LPWNDCLASS): WINBOOL{.stdcall, dynlib: "user32",
    importc: "GetClassInfoA".}
proc RegisterClassExA*(para1: LPWNDCLASSEX): ATOM{.stdcall, dynlib: "user32",
    importc: "RegisterClassExA".}
proc GetClassInfoExA*(para1: HINST, para2: LPCSTR, para3: LPWNDCLASSEX): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetClassInfoExA".}
proc CreateWindowExA*(dwExStyle: DWORD, lpClassName: LPCSTR,
                      lpWindowName: LPCSTR, dwStyle: DWORD, X: int32, Y: int32,
                      nWidth: int32, nHeight: int32, hWndParent: HWND,
                      menu: HMENU, hInstance: HINST, lpParam: LPVOID): HWND{.
    stdcall, dynlib: "user32", importc: "CreateWindowExA".}
proc CreateDialogParamA*(hInstance: HINST, lpTemplateName: LPCSTR,
                         hWndParent: HWND, lpDialogFunc: DLGPROC,
                         dwInitParam: LPARAM): HWND{.stdcall, dynlib: "user32",
    importc: "CreateDialogParamA".}
proc CreateDialogIndirectParamA*(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                                 hWndParent: HWND, lpDialogFunc: DLGPROC,
                                 dwInitParam: LPARAM): HWND{.stdcall,
    dynlib: "user32", importc: "CreateDialogIndirectParamA".}
proc DialogBoxParamA*(hInstance: HINST, lpTemplateName: LPCSTR,
                      hWndParent: HWND, lpDialogFunc: DLGPROC,
                      dwInitParam: LPARAM): int32{.stdcall, dynlib: "user32",
    importc: "DialogBoxParamA".}
proc DialogBoxIndirectParamA*(hInstance: HINST, hDialogTemplate: LPCDLGTEMPLATE,
                              hWndParent: HWND, lpDialogFunc: DLGPROC,
                              dwInitParam: LPARAM): int32{.stdcall,
    dynlib: "user32", importc: "DialogBoxIndirectParamA".}
proc SetDlgItemTextA*(hDlg: HWND, nIDDlgItem: int32, lpString: LPCSTR): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SetDlgItemTextA".}
proc GetDlgItemTextA*(hDlg: HWND, nIDDlgItem: int32, lpString: LPSTR,
                      nMaxCount: int32): UINT{.stdcall, dynlib: "user32",
    importc: "GetDlgItemTextA".}
proc SendDlgItemMessageA*(hDlg: HWND, nIDDlgItem: int32, Msg: UINT,
                          wp: WPARAM, lp: LPARAM): LONG{.stdcall,
    dynlib: "user32", importc: "SendDlgItemMessageA".}
proc DefDlgProcA*(hDlg: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
    stdcall, dynlib: "user32", importc: "DefDlgProcA".}
proc CallMsgFilterA*(lpMsg: LPMSG, nCode: int32): WINBOOL{.stdcall,
    dynlib: "user32", importc: "CallMsgFilterA".}
proc RegisterClipboardFormatA*(lpszFormat: LPCSTR): UINT{.stdcall,
    dynlib: "user32", importc: "RegisterClipboardFormatA".}
proc GetClipboardFormatNameA*(format: UINT, lpszFormatName: LPSTR,
                              cchMaxCount: int32): int32{.stdcall,
    dynlib: "user32", importc: "GetClipboardFormatNameA".}
proc CharToOemA*(lpszSrc: LPCSTR, lpszDst: LPSTR): WINBOOL{.stdcall,
    dynlib: "user32", importc: "CharToOemA".}
proc OemToCharA*(lpszSrc: LPCSTR, lpszDst: LPSTR): WINBOOL{.stdcall,
    dynlib: "user32", importc: "OemToCharA".}
proc CharToOemBuffA*(lpszSrc: LPCSTR, lpszDst: LPSTR, cchDstLength: DWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "CharToOemBuffA".}
proc OemToCharBuffA*(lpszSrc: LPCSTR, lpszDst: LPSTR, cchDstLength: DWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "OemToCharBuffA".}
proc CharUpperA*(lpsz: LPSTR): LPSTR{.stdcall, dynlib: "user32",
                                      importc: "CharUpperA".}
proc CharUpperBuffA*(lpsz: LPSTR, cchLength: DWORD): DWORD{.stdcall,
    dynlib: "user32", importc: "CharUpperBuffA".}
proc CharLowerA*(lpsz: LPSTR): LPSTR{.stdcall, dynlib: "user32",
                                      importc: "CharLowerA".}
proc CharLowerBuffA*(lpsz: LPSTR, cchLength: DWORD): DWORD{.stdcall,
    dynlib: "user32", importc: "CharLowerBuffA".}
proc CharNextA*(lpsz: LPCSTR): LPSTR{.stdcall, dynlib: "user32",
                                      importc: "CharNextA".}
proc CharPrevA*(lpszStart: LPCSTR, lpszCurrent: LPCSTR): LPSTR{.stdcall,
    dynlib: "user32", importc: "CharPrevA".}
proc IsCharAlphaA*(ch: CHAR): WINBOOL{.stdcall, dynlib: "user32",
                                       importc: "IsCharAlphaA".}
proc IsCharAlphaNumericA*(ch: CHAR): WINBOOL{.stdcall, dynlib: "user32",
    importc: "IsCharAlphaNumericA".}
proc IsCharUpperA*(ch: CHAR): WINBOOL{.stdcall, dynlib: "user32",
                                       importc: "IsCharUpperA".}
proc IsCharLowerA*(ch: CHAR): WINBOOL{.stdcall, dynlib: "user32",
                                       importc: "IsCharLowerA".}
proc GetKeyNameTextA*(lParam: LONG, lpString: LPSTR, nSize: int32): int32{.
    stdcall, dynlib: "user32", importc: "GetKeyNameTextA".}
proc VkKeyScanA*(ch: CHAR): SHORT{.stdcall, dynlib: "user32",
                                   importc: "VkKeyScanA".}
proc VkKeyScanExA*(ch: CHAR, dwhkl: HKL): SHORT{.stdcall, dynlib: "user32",
    importc: "VkKeyScanExA".}
proc MapVirtualKeyA*(uCode: UINT, uMapType: UINT): UINT{.stdcall,
    dynlib: "user32", importc: "MapVirtualKeyA".}
proc MapVirtualKeyExA*(uCode: UINT, uMapType: UINT, dwhkl: HKL): UINT{.stdcall,
    dynlib: "user32", importc: "MapVirtualKeyExA".}
proc LoadAcceleratorsA*(hInstance: HINST, lpTableName: LPCSTR): HACCEL{.stdcall,
    dynlib: "user32", importc: "LoadAcceleratorsA".}
proc CreateAcceleratorTableA*(para1: LPACCEL, para2: int32): HACCEL{.stdcall,
    dynlib: "user32", importc: "CreateAcceleratorTableA".}
proc CopyAcceleratorTableA*(hAccelSrc: HACCEL, lpAccelDst: LPACCEL,
                            cAccelEntries: int32): int32{.stdcall,
    dynlib: "user32", importc: "CopyAcceleratorTableA".}
proc TranslateAcceleratorA*(wnd: HWND, hAccTable: HACCEL, lpMsg: LPMSG): int32{.
    stdcall, dynlib: "user32", importc: "TranslateAcceleratorA".}
proc LoadMenuA*(hInstance: HINST, lpMenuName: LPCSTR): HMENU{.stdcall,
    dynlib: "user32", importc: "LoadMenuA".}
proc LoadMenuIndirectA*(lpMenuTemplate: LPMENUTEMPLATE): HMENU{.stdcall,
    dynlib: "user32", importc: "LoadMenuIndirectA".}
proc ChangeMenuA*(menu: HMENU, cmd: UINT, lpszNewItem: LPCSTR, cmdInsert: UINT,
                  flags: UINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "ChangeMenuA".}
proc GetMenuStringA*(menu: HMENU, uIDItem: UINT, lpString: LPSTR,
                     nMaxCount: int32, uFlag: UINT): int32{.stdcall,
    dynlib: "user32", importc: "GetMenuStringA".}
proc InsertMenuA*(menu: HMENU, uPosition: UINT, uFlags: UINT, uIDNewItem: UINT,
                  lpNewItem: LPCSTR): WINBOOL{.stdcall, dynlib: "user32",
    importc: "InsertMenuA".}
proc AppendMenuA*(menu: HMENU, uFlags: UINT, uIDNewItem: UINT,
                  lpNewItem: LPCSTR): WINBOOL{.stdcall, dynlib: "user32",
    importc: "AppendMenuA".}
proc ModifyMenuA*(hMnu: HMENU, uPosition: UINT, uFlags: UINT, uIDNewItem: UINT,
                  lpNewItem: LPCSTR): WINBOOL{.stdcall, dynlib: "user32",
    importc: "ModifyMenuA".}
proc InsertMenuItemA*(para1: HMENU, para2: UINT, para3: WINBOOL,
                      para4: LPCMENUITEMINFO): WINBOOL{.stdcall,
    dynlib: "user32", importc: "InsertMenuItemA".}
proc GetMenuItemInfoA*(para1: HMENU, para2: UINT, para3: WINBOOL,
                       para4: LPMENUITEMINFO): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetMenuItemInfoA".}
proc SetMenuItemInfoA*(para1: HMENU, para2: UINT, para3: WINBOOL,
                       para4: LPCMENUITEMINFO): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetMenuItemInfoA".}
proc DrawTextA*(hDC: HDC, lpString: LPCSTR, nCount: int32, lpRect: LPRECT,
                uFormat: UINT): int32{.stdcall, dynlib: "user32",
                                       importc: "DrawTextA".}
proc DrawTextExA*(para1: HDC, para2: LPSTR, para3: int32, para4: LPRECT,
                  para5: UINT, para6: LPDRAWTEXTPARAMS): int32{.stdcall,
    dynlib: "user32", importc: "DrawTextExA".}
proc GrayStringA*(hDC: HDC, hBrush: HBRUSH, lpOutputFunc: GRAYSTRINGPROC,
                  lpData: LPARAM, nCount: int32, X: int32, Y: int32,
                  nWidth: int32, nHeight: int32): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GrayStringA".}
proc DrawStateA*(para1: HDC, para2: HBRUSH, para3: DRAWSTATEPROC, para4: LPARAM,
                 para5: WPARAM, para6: int32, para7: int32, para8: int32,
                 para9: int32, para10: UINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "DrawStateA".}
proc TabbedTextOutA*(hDC: HDC, X: int32, Y: int32, lpString: LPCSTR,
                     nCount: int32, nTabPositions: int32,
                     lpnTabStopPositions: LPINT, nTabOrigin: int32): LONG{.
    stdcall, dynlib: "user32", importc: "TabbedTextOutA".}
proc GetTabbedTextExtentA*(hDC: HDC, lpString: LPCSTR, nCount: int32,
                           nTabPositions: int32, lpnTabStopPositions: LPINT): DWORD{.
    stdcall, dynlib: "user32", importc: "GetTabbedTextExtentA".}
proc SetPropA*(wnd: HWND, lpString: LPCSTR, hData: HANDLE): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetPropA".}
proc GetPropA*(wnd: HWND, lpString: LPCSTR): HANDLE{.stdcall, dynlib: "user32",
    importc: "GetPropA".}
proc RemovePropA*(wnd: HWND, lpString: LPCSTR): HANDLE{.stdcall,
    dynlib: "user32", importc: "RemovePropA".}
proc EnumPropsExA*(wnd: HWND, lpEnumFunc: PROPENUMPROCEX, lp: LPARAM): int32{.
    stdcall, dynlib: "user32", importc: "EnumPropsExA".}
proc EnumPropsA*(wnd: HWND, lpEnumFunc: PROPENUMPROC): int32{.stdcall,
    dynlib: "user32", importc: "EnumPropsA".}
proc SetWindowTextA*(wnd: HWND, lpString: LPCSTR): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetWindowTextA".}
proc GetWindowTextA*(wnd: HWND, lpString: LPSTR, nMaxCount: int32): int32{.
    stdcall, dynlib: "user32", importc: "GetWindowTextA".}
proc GetWindowTextLengthA*(wnd: HWND): int32{.stdcall, dynlib: "user32",
    importc: "GetWindowTextLengthA".}
proc MessageBoxA*(wnd: HWND, lpText: LPCSTR, lpCaption: LPCSTR, uType: int): int32{.
    stdcall, dynlib: "user32", importc: "MessageBoxA".}
proc MessageBoxExA*(wnd: HWND, lpText: LPCSTR, lpCaption: LPCSTR, uType: UINT,
                    wLanguageId: int16): int32{.stdcall, dynlib: "user32",
    importc: "MessageBoxExA".}
proc MessageBoxIndirectA*(para1: LPMSGBOXPARAMS): int32{.stdcall,
    dynlib: "user32", importc: "MessageBoxIndirectA".}
proc GetWindowLongA*(wnd: HWND, nIndex: int32): LONG{.stdcall,
    dynlib: "user32", importc: "GetWindowLongA".}
proc SetWindowLongA*(wnd: HWND, nIndex: int32, dwNewLong: LONG): LONG{.stdcall,
    dynlib: "user32", importc: "SetWindowLongA".}
proc GetClassLongA*(wnd: HWND, nIndex: int32): DWORD{.stdcall,
    dynlib: "user32", importc: "GetClassLongA".}
proc SetClassLongA*(wnd: HWND, nIndex: int32, dwNewLong: LONG): DWORD{.stdcall,
    dynlib: "user32", importc: "SetClassLongA".}
when defined(cpu64):
  proc GetWindowLongPtrA*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
      dynlib: "user32", importc: "GetWindowLongPtrA".}
  proc SetWindowLongPtrA*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
      stdcall, dynlib: "user32", importc: "SetWindowLongPtrA".}
  proc GetClassLongPtrA*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
      dynlib: "user32", importc: "GetClassLongPtrA".}
  proc SetClassLongPtrA*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
      stdcall, dynlib: "user32", importc: "SetClassLongPtrA".}
else:
  proc GetWindowLongPtrA*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
      dynlib: "user32", importc: "GetWindowLongA".}
  proc SetWindowLongPtrA*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
      stdcall, dynlib: "user32", importc: "SetWindowLongA".}
  proc GetClassLongPtrA*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
      dynlib: "user32", importc: "GetClassLongA".}
  proc SetClassLongPtrA*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
      stdcall, dynlib: "user32", importc: "SetClassLongA".}
proc FindWindowA*(lpClassName: LPCSTR, lpWindowName: LPCSTR): HWND{.stdcall,
    dynlib: "user32", importc: "FindWindowA".}
proc FindWindowExA*(para1: HWND, para2: HWND, para3: LPCSTR, para4: LPCSTR): HWND{.
    stdcall, dynlib: "user32", importc: "FindWindowExA".}
proc GetClassNameA*(wnd: HWND, lpClassName: LPSTR, nMaxCount: int32): int32{.
    stdcall, dynlib: "user32", importc: "GetClassNameA".}
proc SetWindowsHookExA*(idHook: int32, lpfn: HOOKPROC, hmod: HINST,
                        dwThreadId: DWORD): HHOOK{.stdcall, dynlib: "user32",
    importc: "SetWindowsHookExA".}
proc LoadBitmapA*(hInstance: HINST, lpBitmapName: LPCSTR): HBITMAP{.stdcall,
    dynlib: "user32", importc: "LoadBitmapA".}
proc LoadCursorA*(hInstance: HINST, lpCursorName: LPCSTR): HCURSOR{.stdcall,
    dynlib: "user32", importc: "LoadCursorA".}
proc LoadCursorFromFileA*(lpFileName: LPCSTR): HCURSOR{.stdcall,
    dynlib: "user32", importc: "LoadCursorFromFileA".}
proc LoadIconA*(hInstance: HINST, lpIconName: LPCSTR): HICON{.stdcall,
    dynlib: "user32", importc: "LoadIconA".}
proc LoadImageA*(para1: HINST, para2: LPCSTR, para3: UINT, para4: int32,
                 para5: int32, para6: UINT): HANDLE{.stdcall, dynlib: "user32",
    importc: "LoadImageA".}
proc LoadStringA*(hInstance: HINST, uID: UINT, lpBuffer: LPSTR,
                  nBufferMax: int32): int32{.stdcall, dynlib: "user32",
    importc: "LoadStringA".}
proc IsDialogMessageA*(hDlg: HWND, lpMsg: LPMSG): WINBOOL{.stdcall,
    dynlib: "user32", importc: "IsDialogMessageA".}
proc DlgDirListA*(hDlg: HWND, lpPathSpec: LPSTR, nIDListBox: int32,
                  nIDStaticPath: int32, uFileType: UINT): int32{.stdcall,
    dynlib: "user32", importc: "DlgDirListA".}
proc DlgDirSelectExA*(hDlg: HWND, lpString: LPSTR, nCount: int32,
                      nIDListBox: int32): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DlgDirSelectExA".}
proc DlgDirListComboBoxA*(hDlg: HWND, lpPathSpec: LPSTR, nIDComboBox: int32,
                          nIDStaticPath: int32, uFiletype: UINT): int32{.
    stdcall, dynlib: "user32", importc: "DlgDirListComboBoxA".}
proc DlgDirSelectComboBoxExA*(hDlg: HWND, lpString: LPSTR, nCount: int32,
                              nIDComboBox: int32): WINBOOL{.stdcall,
    dynlib: "user32", importc: "DlgDirSelectComboBoxExA".}
proc DefFrameProcA*(wnd: HWND, hWndMDIClient: HWND, uMsg: UINT, wp: WPARAM,
                    lp: LPARAM): LRESULT{.stdcall, dynlib: "user32",
    importc: "DefFrameProcA".}
proc DefMDIChildProcA*(wnd: HWND, uMsg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
    stdcall, dynlib: "user32", importc: "DefMDIChildProcA".}
proc CreateMDIWindowA*(lpClassName: LPSTR, lpWindowName: LPSTR, dwStyle: DWORD,
                       X: int32, Y: int32, nWidth: int32, nHeight: int32,
                       hWndParent: HWND, hInstance: HINST, lp: LPARAM): HWND{.
    stdcall, dynlib: "user32", importc: "CreateMDIWindowA".}
proc WinHelpA*(hWndMain: HWND, lpszHelp: LPCSTR, uCommand: UINT, dwData: DWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "WinHelpA".}
proc ChangeDisplaySettingsA*(lpDevMode: LPDEVMODE, dwFlags: DWORD): LONG{.
    stdcall, dynlib: "user32", importc: "ChangeDisplaySettingsA".}
proc EnumDisplaySettingsA*(lpszDeviceName: LPCSTR, iModeNum: DWORD,
                           lpDevMode: LPDEVMODE): WINBOOL{.stdcall,
    dynlib: "user32", importc: "EnumDisplaySettingsA".}
proc SystemParametersInfoA*(uiAction: UINT, uiParam: UINT, pvParam: PVOID,
                            fWinIni: UINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SystemParametersInfoA".}
proc AddFontResourceA*(para1: LPCSTR): int32{.stdcall, dynlib: "gdi32",
    importc: "AddFontResourceA".}
proc CopyMetaFileA*(para1: HMETAFILE, para2: LPCSTR): HMETAFILE{.stdcall,
    dynlib: "gdi32", importc: "CopyMetaFileA".}
proc CreateFontA*(para1: int32, para2: int32, para3: int32, para4: int32,
                  para5: int32, para6: DWORD, para7: DWORD, para8: DWORD,
                  para9: DWORD, para10: DWORD, para11: DWORD, para12: DWORD,
                  para13: DWORD, para14: LPCSTR): HFONT{.stdcall,
    dynlib: "gdi32", importc: "CreateFontA".}
proc CreateFontIndirectA*(para1: LPLOGFONT): HFONT{.stdcall, dynlib: "gdi32",
    importc: "CreateFontIndirectA".}
proc CreateFontIndirectA*(para1: var LOGFONT): HFONT{.stdcall, dynlib: "gdi32",
    importc: "CreateFontIndirectA".}
proc CreateICA*(para1: LPCSTR, para2: LPCSTR, para3: LPCSTR, para4: LPDEVMODE): HDC{.
    stdcall, dynlib: "gdi32", importc: "CreateICA".}
proc CreateMetaFileA*(para1: LPCSTR): HDC{.stdcall, dynlib: "gdi32",
    importc: "CreateMetaFileA".}
proc CreateScalableFontResourceA*(para1: DWORD, para2: LPCSTR, para3: LPCSTR,
                                  para4: LPCSTR): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "CreateScalableFontResourceA".}
proc EnumFontFamiliesExA*(para1: HDC, para2: LPLOGFONT, para3: FONTENUMEXPROC,
                          para4: LPARAM, para5: DWORD): int32{.stdcall,
    dynlib: "gdi32", importc: "EnumFontFamiliesExA".}
proc EnumFontFamiliesA*(para1: HDC, para2: LPCSTR, para3: FONTENUMPROC,
                        para4: LPARAM): int32{.stdcall, dynlib: "gdi32",
    importc: "EnumFontFamiliesA".}
proc EnumFontsA*(para1: HDC, para2: LPCSTR, para3: ENUMFONTSPROC, para4: LPARAM): int32{.
    stdcall, dynlib: "gdi32", importc: "EnumFontsA".}
proc EnumFontsA*(para1: HDC, para2: LPCSTR, para3: ENUMFONTSPROC, para4: pointer): int32{.
    stdcall, dynlib: "gdi32", importc: "EnumFontsA".}
proc GetCharWidthA*(para1: HDC, para2: UINT, para3: UINT, para4: LPINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharWidthA".}
proc GetCharWidth32A*(para1: HDC, para2: UINT, para3: UINT, para4: LPINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharWidth32A".}
proc GetCharWidthFloatA*(para1: HDC, para2: UINT, para3: UINT, para4: ptr float32): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharWidthFloatA".}
proc GetCharABCWidthsA*(para1: HDC, para2: UINT, para3: UINT, para4: LPABC): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharABCWidthsA".}
proc GetCharABCWidthsFloatA*(para1: HDC, para2: UINT, para3: UINT,
                             para4: LPABCFLOAT): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetCharABCWidthsFloatA".}
proc GetGlyphOutlineA*(para1: HDC, para2: UINT, para3: UINT,
                       para4: LPGLYPHMETRICS, para5: DWORD, para6: LPVOID,
                       para7: PMAT2): DWORD{.stdcall, dynlib: "gdi32",
    importc: "GetGlyphOutlineA".}
proc GetMetaFileA*(para1: LPCSTR): HMETAFILE{.stdcall, dynlib: "gdi32",
    importc: "GetMetaFileA".}
proc GetOutlineTextMetricsA*(para1: HDC, para2: UINT, para3: LPOUTLINETEXTMETRIC): UINT{.
    stdcall, dynlib: "gdi32", importc: "GetOutlineTextMetricsA".}
proc GetTextExtentPointA*(para1: HDC, para2: LPCSTR, para3: int32, para4: LPSIZE): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetTextExtentPointA".}
proc GetTextExtentPoint32A*(para1: HDC, para2: LPCSTR, para3: int32,
                            para4: LPSIZE): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "GetTextExtentPoint32A".}
proc GetTextExtentExPointA*(para1: HDC, para2: LPCSTR, para3: int32,
                            para4: int32, para5: LPINT, para6: LPINT,
                            para7: LPSIZE): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "GetTextExtentExPointA".}
proc GetCharacterPlacementA*(para1: HDC, para2: LPCSTR, para3: int32,
                             para4: int32, para5: LPGCP_RESULTS, para6: DWORD): DWORD{.
    stdcall, dynlib: "gdi32", importc: "GetCharacterPlacementA".}
proc ResetDCA*(para1: HDC, para2: LPDEVMODE): HDC{.stdcall, dynlib: "gdi32",
    importc: "ResetDCA".}
proc RemoveFontResourceA*(para1: LPCSTR): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "RemoveFontResourceA".}
proc CopyEnhMetaFileA*(para1: HENHMETAFILE, para2: LPCSTR): HENHMETAFILE{.
    stdcall, dynlib: "gdi32", importc: "CopyEnhMetaFileA".}
proc CreateEnhMetaFileA*(para1: HDC, para2: LPCSTR, para3: LPRECT, para4: LPCSTR): HDC{.
    stdcall, dynlib: "gdi32", importc: "CreateEnhMetaFileA".}
proc GetEnhMetaFileA*(para1: LPCSTR): HENHMETAFILE{.stdcall, dynlib: "gdi32",
    importc: "GetEnhMetaFileA".}
proc GetEnhMetaFileDescriptionA*(para1: HENHMETAFILE, para2: UINT, para3: LPSTR): UINT{.
    stdcall, dynlib: "gdi32", importc: "GetEnhMetaFileDescriptionA".}
proc GetTextMetricsA*(para1: HDC, para2: LPTEXTMETRIC): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetTextMetricsA".}
proc StartDocA*(para1: HDC, para2: PDOCINFO): int32{.stdcall, dynlib: "gdi32",
    importc: "StartDocA".}
proc GetObjectA*(para1: HGDIOBJ, para2: int32, para3: LPVOID): int32{.stdcall,
    dynlib: "gdi32", importc: "GetObjectA".}
proc TextOutA*(para1: HDC, para2: int32, para3: int32, para4: LPCSTR,
               para5: int32): WINBOOL{.stdcall, dynlib: "gdi32",
                                       importc: "TextOutA".}
proc ExtTextOutA*(para1: HDC, para2: int32, para3: int32, para4: UINT,
                  para5: LPRECT, para6: LPCSTR, para7: UINT, para8: LPINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "ExtTextOutA".}
proc PolyTextOutA*(para1: HDC, para2: PPOLYTEXT, para3: int32): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "PolyTextOutA".}
proc GetTextFaceA*(para1: HDC, para2: int32, para3: LPSTR): int32{.stdcall,
    dynlib: "gdi32", importc: "GetTextFaceA".}
proc GetKerningPairsA*(para1: HDC, para2: DWORD, para3: LPKERNINGPAIR): DWORD{.
    stdcall, dynlib: "gdi32", importc: "GetKerningPairsA".}
proc CreateColorSpaceA*(para1: LPLOGCOLORSPACE): HCOLORSPACE{.stdcall,
    dynlib: "gdi32", importc: "CreateColorSpaceA".}
proc GetLogColorSpaceA*(para1: HCOLORSPACE, para2: LPLOGCOLORSPACE, para3: DWORD): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetLogColorSpaceA".}
proc GetICMProfileA*(para1: HDC, para2: DWORD, para3: LPSTR): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetICMProfileA".}
proc SetICMProfileA*(para1: HDC, para2: LPSTR): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "SetICMProfileA".}
proc UpdateICMRegKeyA*(para1: DWORD, para2: DWORD, para3: LPSTR, para4: UINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "UpdateICMRegKeyA".}
proc EnumICMProfilesA*(para1: HDC, para2: ICMENUMPROC, para3: LPARAM): int32{.
    stdcall, dynlib: "gdi32", importc: "EnumICMProfilesA".}
proc PropertySheetA*(lppsph: LPCPROPSHEETHEADER): int32{.stdcall,
    dynlib: "comctl32", importc: "PropertySheetA".}
proc ImageList_LoadImageA*(hi: HINST, lpbmp: LPCSTR, cx: int32, cGrow: int32,
                           crMask: COLORREF, uType: UINT, uFlags: UINT): HIMAGELIST{.
    stdcall, dynlib: "comctl32", importc: "ImageList_LoadImageA".}
proc CreateStatusWindowA*(style: LONG, lpszText: LPCSTR, hwndParent: HWND,
                          wID: UINT): HWND{.stdcall, dynlib: "comctl32",
    importc: "CreateStatusWindowA".}
proc DrawStatusTextA*(hDC: HDC, lprc: LPRECT, pszText: LPCSTR, uFlags: UINT){.
    stdcall, dynlib: "comctl32", importc: "DrawStatusTextA".}
proc GetOpenFileNameA*(para1: LPOPENFILENAME): WINBOOL{.stdcall,
    dynlib: "comdlg32", importc: "GetOpenFileNameA".}
proc GetSaveFileNameA*(para1: LPOPENFILENAME): WINBOOL{.stdcall,
    dynlib: "comdlg32", importc: "GetSaveFileNameA".}
proc GetFileTitleA*(para1: LPCSTR, para2: LPSTR, para3: int16): int{.stdcall,
    dynlib: "comdlg32", importc: "GetFileTitleA".}
proc ChooseColorA*(para1: LPCHOOSECOLOR): WINBOOL{.stdcall, dynlib: "comdlg32",
    importc: "ChooseColorA".}
proc FindTextA*(para1: LPFINDREPLACE): HWND{.stdcall, dynlib: "comdlg32",
    importc: "FindTextA".}
proc ReplaceTextA*(para1: LPFINDREPLACE): HWND{.stdcall, dynlib: "comdlg32",
    importc: "ReplaceTextA".}
proc ChooseFontA*(para1: LPCHOOSEFONT): WINBOOL{.stdcall, dynlib: "comdlg32",
    importc: "ChooseFontA".}
proc PrintDlgA*(para1: LPPRINTDLG): WINBOOL{.stdcall, dynlib: "comdlg32",
    importc: "PrintDlgA".}
proc PageSetupDlgA*(para1: LPPAGESETUPDLG): WINBOOL{.stdcall,
    dynlib: "comdlg32", importc: "PageSetupDlgA".}
proc CreateProcessA*(lpApplicationName: LPCSTR, lpCommandLine: LPSTR,
                     lpProcessAttributes: LPSECURITY_ATTRIBUTES,
                     lpThreadAttributes: LPSECURITY_ATTRIBUTES,
                     bInheritHandles: WINBOOL, dwCreationFlags: DWORD,
                     lpEnvironment: LPVOID, lpCurrentDirectory: LPCSTR,
                     lpStartupInfo: LPSTARTUPINFO,
                     lpProcessInformation: LPPROCESS_INFORMATION): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CreateProcessA".}
proc GetStartupInfoA*(lpStartupInfo: LPSTARTUPINFO){.stdcall,
    dynlib: "kernel32", importc: "GetStartupInfoA".}
proc FindFirstFileA*(lpFileName: LPCSTR, lpFindFileData: LPWIN32_FIND_DATA): HANDLE{.
    stdcall, dynlib: "kernel32", importc: "FindFirstFileA".}
proc FindNextFileA*(hFindFile: HANDLE, lpFindFileData: LPWIN32_FIND_DATA): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FindNextFileA".}
proc GetVersionExA*(VersionInformation: LPOSVERSIONINFO): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetVersionExA".}
proc CreateWindowA*(lpClassName: LPCSTR, lpWindowName: LPCSTR, dwStyle: DWORD,
                    X: int32, Y: int32, nWidth: int32, nHeight: int32,
                    hWndParent: HWND, menu: HMENU, hInstance: HINST,
                    lpParam: LPVOID): HWND
proc CreateDialogA*(hInstance: HINST, lpTemplateName: LPCSTR, hWndParent: HWND,
                    lpDialogFunc: DLGPROC): HWND
proc CreateDialogIndirectA*(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                            hWndParent: HWND, lpDialogFunc: DLGPROC): HWND
proc DialogBoxA*(hInstance: HINST, lpTemplateName: LPCSTR, hWndParent: HWND,
                 lpDialogFunc: DLGPROC): int32
proc DialogBoxIndirectA*(hInstance: HINST, hDialogTemplate: LPCDLGTEMPLATE,
                         hWndParent: HWND, lpDialogFunc: DLGPROC): int32
proc CreateDCA*(para1: LPCSTR, para2: LPCSTR, para3: LPCSTR, para4: pDEVMODE): HDC{.
    stdcall, dynlib: "gdi32", importc: "CreateDCA".}
proc VerInstallFileA*(uFlags: DWORD, szSrcFileName: LPSTR,
                      szDestFileName: LPSTR, szSrcDir: LPSTR, szDestDir: LPSTR,
                      szCurDir: LPSTR, szTmpFile: LPSTR, lpuTmpFileLen: PUINT): DWORD{.
    stdcall, dynlib: "version", importc: "VerInstallFileA".}
proc GetFileVersionInfoSizeA*(lptstrFilename: LPSTR, lpdwHandle: LPDWORD): DWORD{.
    stdcall, dynlib: "version", importc: "GetFileVersionInfoSizeA".}
proc GetFileVersionInfoA*(lptstrFilename: LPSTR, dwHandle: DWORD, dwLen: DWORD,
                          lpData: LPVOID): WINBOOL{.stdcall, dynlib: "version",
    importc: "GetFileVersionInfoA".}
proc VerLanguageNameA*(wLang: DWORD, szLang: LPSTR, nSize: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc: "VerLanguageNameA".}
proc VerQueryValueA*(pBlock: LPVOID, lpSubBlock: LPSTR, lplpBuffer: LPVOID,
                     puLen: PUINT): WINBOOL{.stdcall, dynlib: "version",
    importc: "VerQueryValueA".}
proc VerFindFileA*(uFlags: DWORD, szFileName: LPSTR, szWinDir: LPSTR,
                   szAppDir: LPSTR, szCurDir: LPSTR, lpuCurDirLen: PUINT,
                   szDestDir: LPSTR, lpuDestDirLen: PUINT): DWORD{.stdcall,
    dynlib: "version", importc: "VerFindFileA".}
proc RegConnectRegistryA*(lpMachineName: LPSTR, key: HKEY, phkResult: PHKEY): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegConnectRegistryA".}
proc RegCreateKeyA*(key: HKEY, lpSubKey: LPCSTR, phkResult: PHKEY): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegCreateKeyA".}
proc RegCreateKeyExA*(key: HKEY, lpSubKey: LPCSTR, Reserved: DWORD,
                      lpClass: LPSTR, dwOptions: DWORD, samDesired: REGSAM,
                      lpSecurityAttributes: LPSECURITY_ATTRIBUTES,
                      phkResult: PHKEY, lpdwDisposition: LPDWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegCreateKeyExA".}
proc RegDeleteKeyA*(key: HKEY, lpSubKey: LPCSTR): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegDeleteKeyA".}
proc RegDeleteValueA*(key: HKEY, lpValueName: LPCSTR): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegDeleteValueA".}
proc RegEnumKeyA*(key: HKEY, dwIndex: DWORD, lpName: LPSTR, cbName: DWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegEnumKeyA".}
proc RegEnumKeyExA*(key: HKEY, dwIndex: DWORD, lpName: LPSTR,
                    lpcbName: LPDWORD, lpReserved: LPDWORD, lpClass: LPSTR,
                    lpcbClass: LPDWORD, lpftLastWriteTime: PFILETIME): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegEnumKeyExA".}
proc RegEnumValueA*(key: HKEY, dwIndex: DWORD, lpValueName: LPSTR,
                    lpcbValueName: LPDWORD, lpReserved: LPDWORD,
                    lpType: LPDWORD, lpData: LPBYTE, lpcbData: LPDWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegEnumValueA".}
proc RegLoadKeyA*(key: HKEY, lpSubKey: LPCSTR, lpFile: LPCSTR): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegLoadKeyA".}
proc RegOpenKeyA*(key: HKEY, lpSubKey: LPCSTR, phkResult: PHKEY): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegOpenKeyA".}
proc RegOpenKeyExA*(key: HKEY, lpSubKey: LPCSTR, ulOptions: DWORD,
                    samDesired: REGSAM, phkResult: PHKEY): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegOpenKeyExA".}
proc RegQueryInfoKeyA*(key: HKEY, lpClass: LPSTR, lpcbClass: LPDWORD,
                       lpReserved: LPDWORD, lpcSubKeys: LPDWORD,
                       lpcbMaxSubKeyLen: LPDWORD, lpcbMaxClassLen: LPDWORD,
                       lpcValues: LPDWORD, lpcbMaxValueNameLen: LPDWORD,
                       lpcbMaxValueLen: LPDWORD,
                       lpcbSecurityDescriptor: LPDWORD,
                       lpftLastWriteTime: PFILETIME): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegQueryInfoKeyA".}
proc RegQueryValueA*(key: HKEY, lpSubKey: LPCSTR, lpValue: LPSTR,
                     lpcbValue: PLONG): LONG{.stdcall, dynlib: "advapi32",
    importc: "RegQueryValueA".}
proc RegQueryMultipleValuesA*(key: HKEY, val_list: PVALENT, num_vals: DWORD,
                              lpValueBuf: LPSTR, ldwTotsize: LPDWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegQueryMultipleValuesA".}
proc RegQueryValueExA*(key: HKEY, lpValueName: LPCSTR, lpReserved: LPDWORD,
                       lpType: LPDWORD, lpData: LPBYTE, lpcbData: LPDWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegQueryValueExA".}
proc RegReplaceKeyA*(key: HKEY, lpSubKey: LPCSTR, lpNewFile: LPCSTR,
                     lpOldFile: LPCSTR): LONG{.stdcall, dynlib: "advapi32",
    importc: "RegReplaceKeyA".}
proc RegRestoreKeyA*(key: HKEY, lpFile: LPCSTR, dwFlags: DWORD): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegRestoreKeyA".}
proc RegSaveKeyA*(key: HKEY, lpFile: LPCSTR,
                  lpSecurityAttributes: LPSECURITY_ATTRIBUTES): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegSaveKeyA".}
proc RegSetValueA*(key: HKEY, lpSubKey: LPCSTR, dwType: DWORD, lpData: LPCSTR,
                   cbData: DWORD): LONG{.stdcall, dynlib: "advapi32",
    importc: "RegSetValueA".}
proc RegSetValueExA*(key: HKEY, lpValueName: LPCSTR, Reserved: DWORD,
                     dwType: DWORD, lpData: LPBYTE, cbData: DWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegSetValueExA".}
proc RegUnLoadKeyA*(key: HKEY, lpSubKey: LPCSTR): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegUnLoadKeyA".}
proc InitiateSystemShutdownA*(lpMachineName: LPSTR, lpMessage: LPSTR,
                              dwTimeout: DWORD, bForceAppsClosed: WINBOOL,
                              bRebootAfterShutdown: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "InitiateSystemShutdownA".}
proc AbortSystemShutdownA*(lpMachineName: LPSTR): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "AbortSystemShutdownA".}
proc CompareStringA*(Locale: LCID, dwCmpFlags: DWORD, lpString1: LPCSTR,
                     cchCount1: int32, lpString2: LPCSTR, cchCount2: int32): int32{.
    stdcall, dynlib: "kernel32", importc: "CompareStringA".}
proc LCMapStringA*(Locale: LCID, dwMapFlags: DWORD, lpSrcStr: LPCSTR,
                   cchSrc: int32, lpDestStr: LPSTR, cchDest: int32): int32{.
    stdcall, dynlib: "kernel32", importc: "LCMapStringA".}
proc GetLocaleInfoA*(Locale: LCID, LCType: LCTYPE, lpLCData: LPSTR,
                     cchData: int32): int32{.stdcall, dynlib: "kernel32",
    importc: "GetLocaleInfoA".}
proc SetLocaleInfoA*(Locale: LCID, LCType: LCTYPE, lpLCData: LPCSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetLocaleInfoA".}
proc GetTimeFormatA*(Locale: LCID, dwFlags: DWORD, lpTime: LPSYSTEMTIME,
                     lpFormat: LPCSTR, lpTimeStr: LPSTR, cchTime: int32): int32{.
    stdcall, dynlib: "kernel32", importc: "GetTimeFormatA".}
proc GetDateFormatA*(Locale: LCID, dwFlags: DWORD, lpDate: LPSYSTEMTIME,
                     lpFormat: LPCSTR, lpDateStr: LPSTR, cchDate: int32): int32{.
    stdcall, dynlib: "kernel32", importc: "GetDateFormatA".}
proc GetNumberFormatA*(Locale: LCID, dwFlags: DWORD, lpValue: LPCSTR,
                       lpFormat: PNUMBERFMT, lpNumberStr: LPSTR,
                       cchNumber: int32): int32{.stdcall, dynlib: "kernel32",
    importc: "GetNumberFormatA".}
proc GetCurrencyFormatA*(Locale: LCID, dwFlags: DWORD, lpValue: LPCSTR,
                         lpFormat: PCURRENCYFMT, lpCurrencyStr: LPSTR,
                         cchCurrency: int32): int32{.stdcall,
    dynlib: "kernel32", importc: "GetCurrencyFormatA".}
proc EnumCalendarInfoA*(lpCalInfoEnumProc: CALINFO_ENUMPROC, Locale: LCID,
                        Calendar: CALID, CalType: CALTYPE): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "EnumCalendarInfoA".}
proc EnumTimeFormatsA*(lpTimeFmtEnumProc: TIMEFMT_ENUMPROC, Locale: LCID,
                       dwFlags: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "EnumTimeFormatsA".}
proc EnumDateFormatsA*(lpDateFmtEnumProc: DATEFMT_ENUMPROC, Locale: LCID,
                       dwFlags: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "EnumDateFormatsA".}
proc GetStringTypeExA*(Locale: LCID, dwInfoType: DWORD, lpSrcStr: LPCSTR,
                       cchSrc: int32, lpCharType: LPWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetStringTypeExA".}
proc GetStringTypeA*(Locale: LCID, dwInfoType: DWORD, lpSrcStr: LPCSTR,
                     cchSrc: int32, lpCharType: LPWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetStringTypeA".}
proc FoldStringA*(dwMapFlags: DWORD, lpSrcStr: LPCSTR, cchSrc: int32,
                  lpDestStr: LPSTR, cchDest: int32): int32{.stdcall,
    dynlib: "kernel32", importc: "FoldStringA".}
proc EnumSystemLocalesA*(lpLocaleEnumProc: LOCALE_ENUMPROC, dwFlags: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "EnumSystemLocalesA".}
proc EnumSystemCodePagesA*(lpCodePageEnumProc: CODEPAGE_ENUMPROC, dwFlags: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "EnumSystemCodePagesA".}
proc PeekConsoleInputA*(hConsoleInput: HANDLE, lpBuffer: PINPUTRECORD,
                        nLength: DWORD, lpNumberOfEventsRead: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "PeekConsoleInputA".}
proc ReadConsoleInputA*(hConsoleInput: HANDLE, lpBuffer: PINPUTRECORD,
                        nLength: DWORD, lpNumberOfEventsRead: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadConsoleInputA".}
proc WriteConsoleInputA*(hConsoleInput: HANDLE, lpBuffer: PINPUTRECORD,
                         nLength: DWORD, lpNumberOfEventsWritten: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleInputA".}
proc ReadConsoleOutputA*(hConsoleOutput: HANDLE, lpBuffer: PCHAR_INFO,
                         dwBufferSize: COORD, dwBufferCoord: COORD,
                         lpReadRegion: PSMALL_RECT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "ReadConsoleOutputA".}
proc WriteConsoleOutputA*(hConsoleOutput: HANDLE, lpBuffer: PCHAR_INFO,
                          dwBufferSize: COORD, dwBufferCoord: COORD,
                          lpWriteRegion: PSMALL_RECT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WriteConsoleOutputA".}
proc ReadConsoleOutputCharacterA*(hConsoleOutput: HANDLE, lpCharacter: LPSTR,
                                  nLength: DWORD, dwReadCoord: COORD,
                                  lpNumberOfCharsRead: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadConsoleOutputCharacterA".}
proc WriteConsoleOutputCharacterA*(hConsoleOutput: HANDLE, lpCharacter: LPCSTR,
                                   nLength: DWORD, dwWriteCoord: COORD,
                                   lpNumberOfCharsWritten: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleOutputCharacterA".}
proc FillConsoleOutputCharacterA*(hConsoleOutput: HANDLE, cCharacter: CHAR,
                                  nLength: DWORD, dwWriteCoord: COORD,
                                  lpNumberOfCharsWritten: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FillConsoleOutputCharacterA".}
proc ScrollConsoleScreenBufferA*(hConsoleOutput: HANDLE,
                                 lpScrollRectangle: PSMALL_RECT,
                                 lpClipRectangle: PSMALL_RECT,
                                 dwDestinationOrigin: COORD, lpFill: PCHAR_INFO): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ScrollConsoleScreenBufferA".}
proc GetConsoleTitleA*(lpConsoleTitle: LPSTR, nSize: DWORD): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetConsoleTitleA".}
proc SetConsoleTitleA*(lpConsoleTitle: LPCSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetConsoleTitleA".}
proc ReadConsoleA*(hConsoleInput: HANDLE, lpBuffer: LPVOID,
                   nNumberOfCharsToRead: DWORD, lpNumberOfCharsRead: LPDWORD,
                   lpReserved: LPVOID): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "ReadConsoleA".}
proc WriteConsoleA*(hConsoleOutput: HANDLE, lpBuffer: pointer,
                    nNumberOfCharsToWrite: DWORD,
                    lpNumberOfCharsWritten: LPDWORD, lpReserved: LPVOID): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleA".}
proc WNetAddConnectionA*(lpRemoteName: LPCSTR, lpPassword: LPCSTR,
                         lpLocalName: LPCSTR): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetAddConnectionA".}
proc WNetAddConnection2A*(lpNetResource: LPNETRESOURCE, lpPassword: LPCSTR,
                          lpUserName: LPCSTR, dwFlags: DWORD): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetAddConnection2A".}
proc WNetAddConnection3A*(hwndOwner: HWND, lpNetResource: LPNETRESOURCE,
                          lpPassword: LPCSTR, lpUserName: LPCSTR, dwFlags: DWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetAddConnection3A".}
proc WNetCancelConnectionA*(lpName: LPCSTR, fForce: WINBOOL): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetCancelConnectionA".}
proc WNetCancelConnection2A*(lpName: LPCSTR, dwFlags: DWORD, fForce: WINBOOL): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetCancelConnection2A".}
proc WNetGetConnectionA*(lpLocalName: LPCSTR, lpRemoteName: LPSTR,
                         lpnLength: LPDWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetGetConnectionA".}
proc WNetUseConnectionA*(hwndOwner: HWND, lpNetResource: LPNETRESOURCE,
                         lpUserID: LPCSTR, lpPassword: LPCSTR, dwFlags: DWORD,
                         lpAccessName: LPSTR, lpBufferSize: LPDWORD,
                         lpResult: LPDWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetUseConnectionA".}
proc WNetSetConnectionA*(lpName: LPCSTR, dwProperties: DWORD, pvValues: LPVOID): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetSetConnectionA".}
proc WNetConnectionDialog1A*(lpConnDlgStruct: LPCONNECTDLGSTRUCT): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetConnectionDialog1A".}
proc WNetDisconnectDialog1A*(lpConnDlgStruct: LPDISCDLGSTRUCT): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetDisconnectDialog1A".}
proc WNetOpenEnumA*(dwScope: DWORD, dwType: DWORD, dwUsage: DWORD,
                    lpNetResource: LPNETRESOURCE, lphEnum: LPHANDLE): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetOpenEnumA".}
proc WNetEnumResourceA*(hEnum: HANDLE, lpcCount: LPDWORD, lpBuffer: LPVOID,
                        lpBufferSize: LPDWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetEnumResourceA".}
proc WNetGetUniversalNameA*(lpLocalPath: LPCSTR, dwInfoLevel: DWORD,
                            lpBuffer: LPVOID, lpBufferSize: LPDWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetUniversalNameA".}
proc WNetGetUserA*(lpName: LPCSTR, lpUserName: LPSTR, lpnLength: LPDWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetUserA".}
proc WNetGetProviderNameA*(dwNetType: DWORD, lpProviderName: LPSTR,
                           lpBufferSize: LPDWORD): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetGetProviderNameA".}
proc WNetGetNetworkInformationA*(lpProvider: LPCSTR,
                                 lpNetInfoStruct: LPNETINFOSTRUCT): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetNetworkInformationA".}
proc WNetGetLastErrorA*(lpError: LPDWORD, lpErrorBuf: LPSTR,
                        nErrorBufSize: DWORD, lpNameBuf: LPSTR,
                        nNameBufSize: DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetGetLastErrorA".}
proc MultinetGetConnectionPerformanceA*(lpNetResource: LPNETRESOURCE,
    lpNetConnectInfoStruct: LPNETCONNECTINFOSTRUCT): DWORD{.stdcall,
    dynlib: "mpr", importc: "MultinetGetConnectionPerformanceA".}
proc ChangeServiceConfigA*(hService: SC_HANDLE, dwServiceType: DWORD,
                           dwStartType: DWORD, dwErrorControl: DWORD,
                           lpBinaryPathName: LPCSTR, lpLoadOrderGroup: LPCSTR,
                           lpdwTagId: LPDWORD, lpDependencies: LPCSTR,
                           lpServiceStartName: LPCSTR, lpPassword: LPCSTR,
                           lpDisplayName: LPCSTR): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ChangeServiceConfigA".}
proc CreateServiceA*(hSCManager: SC_HANDLE, lpServiceName: LPCSTR,
                     lpDisplayName: LPCSTR, dwDesiredAccess: DWORD,
                     dwServiceType: DWORD, dwStartType: DWORD,
                     dwErrorControl: DWORD, lpBinaryPathName: LPCSTR,
                     lpLoadOrderGroup: LPCSTR, lpdwTagId: LPDWORD,
                     lpDependencies: LPCSTR, lpServiceStartName: LPCSTR,
                     lpPassword: LPCSTR): SC_HANDLE{.stdcall,
    dynlib: "advapi32", importc: "CreateServiceA".}
proc EnumDependentServicesA*(hService: SC_HANDLE, dwServiceState: DWORD,
                             lpServices: LPENUM_SERVICE_STATUS,
                             cbBufSize: DWORD, pcbBytesNeeded: LPDWORD,
                             lpServicesReturned: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "EnumDependentServicesA".}
proc EnumServicesStatusA*(hSCManager: SC_HANDLE, dwServiceType: DWORD,
                          dwServiceState: DWORD,
                          lpServices: LPENUM_SERVICE_STATUS, cbBufSize: DWORD,
                          pcbBytesNeeded: LPDWORD, lpServicesReturned: LPDWORD,
                          lpResumeHandle: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "EnumServicesStatusA".}
proc GetServiceKeyNameA*(hSCManager: SC_HANDLE, lpDisplayName: LPCSTR,
                         lpServiceName: LPSTR, lpcchBuffer: LPDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetServiceKeyNameA".}
proc GetServiceDisplayNameA*(hSCManager: SC_HANDLE, lpServiceName: LPCSTR,
                             lpDisplayName: LPSTR, lpcchBuffer: LPDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetServiceDisplayNameA".}
proc OpenSCManagerA*(lpMachineName: LPCSTR, lpDatabaseName: LPCSTR,
                     dwDesiredAccess: DWORD): SC_HANDLE{.stdcall,
    dynlib: "advapi32", importc: "OpenSCManagerA".}
proc OpenServiceA*(hSCManager: SC_HANDLE, lpServiceName: LPCSTR,
                   dwDesiredAccess: DWORD): SC_HANDLE{.stdcall,
    dynlib: "advapi32", importc: "OpenServiceA".}
proc QueryServiceConfigA*(hService: SC_HANDLE,
                          lpServiceConfig: LPQUERY_SERVICE_CONFIG,
                          cbBufSize: DWORD, pcbBytesNeeded: LPDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "QueryServiceConfigA".}
proc QueryServiceLockStatusA*(hSCManager: SC_HANDLE,
                              lpLockStatus: LPQUERY_SERVICE_LOCK_STATUS,
                              cbBufSize: DWORD, pcbBytesNeeded: LPDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "QueryServiceLockStatusA".}
proc RegisterServiceCtrlHandlerA*(lpServiceName: LPCSTR,
                                  lpHandlerProc: LPHANDLER_FUNCTION): SERVICE_STATUS_HANDLE{.
    stdcall, dynlib: "advapi32", importc: "RegisterServiceCtrlHandlerA".}
proc StartServiceCtrlDispatcherA*(lpServiceStartTable: LPSERVICE_TABLE_ENTRY): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "StartServiceCtrlDispatcherA".}
proc StartServiceA*(hService: SC_HANDLE, dwNumServiceArgs: DWORD,
                    lpServiceArgVectors: LPCSTR): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "StartServiceA".}
proc DragQueryFileA*(para1: HDROP, para2: int, para3: cstring, para4: int): int{.
    stdcall, dynlib: "shell32", importc: "DragQueryFileA".}
proc ExtractAssociatedIconA*(para1: HINST, para2: cstring, para3: LPWORD): HICON{.
    stdcall, dynlib: "shell32", importc: "ExtractAssociatedIconA".}
proc ExtractIconA*(para1: HINST, para2: cstring, para3: int): HICON{.stdcall,
    dynlib: "shell32", importc: "ExtractIconA".}
proc FindExecutableA*(para1: cstring, para2: cstring, para3: cstring): HINST{.
    stdcall, dynlib: "shell32", importc: "FindExecutableA".}
proc ShellAboutA*(para1: HWND, para2: cstring, para3: cstring, para4: HICON): int32{.
    stdcall, dynlib: "shell32", importc: "ShellAboutA".}
proc ShellExecuteA*(para1: HWND, para2: cstring, para3: cstring, para4: cstring,
                    para5: cstring, para6: int32): HINST{.stdcall,
    dynlib: "shell32", importc: "ShellExecuteA".}
proc Shell_NotifyIconA*(dwMessage: DWORD, lpData: PNotifyIconDataA): WINBOOL{.
    stdcall, dynlib: "shell32", importc: "Shell_NotifyIconA".}
proc DdeCreateStringHandleA*(para1: DWORD, para2: cstring, para3: int32): HSZ{.
    stdcall, dynlib: "user32", importc: "DdeCreateStringHandleA".}
proc DdeInitializeA*(para1: LPDWORD, para2: PFNCALLBACK, para3: DWORD,
                     para4: DWORD): UINT{.stdcall, dynlib: "user32",
    importc: "DdeInitializeA".}
proc DdeQueryStringA*(para1: DWORD, para2: HSZ, para3: cstring, para4: DWORD,
                      para5: int32): DWORD{.stdcall, dynlib: "user32",
    importc: "DdeQueryStringA".}
proc LogonUserA*(para1: LPSTR, para2: LPSTR, para3: LPSTR, para4: DWORD,
                 para5: DWORD, para6: PHANDLE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LogonUserA".}
proc CreateProcessAsUserA*(para1: HANDLE, para2: LPCTSTR, para3: LPTSTR,
                           para4: LPSECURITY_ATTRIBUTES,
                           para5: LPSECURITY_ATTRIBUTES, para6: WINBOOL,
                           para7: DWORD, para8: LPVOID, para9: LPCTSTR,
                           para10: LPSTARTUPINFO, para11: LPPROCESS_INFORMATION): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "CreateProcessAsUserA".}
proc GetBinaryTypeW*(lpApplicationName: LPCWSTR, lpBinaryType: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetBinaryTypeW".}
proc GetShortPathNameW*(lpszLongPath: LPCWSTR, lpszShortPath: LPWSTR,
                        cchBuffer: DWORD): DWORD{.stdcall, dynlib: "kernel32",
    importc: "GetShortPathNameW".}
proc GetEnvironmentStringsW*(): LPWSTR{.stdcall, dynlib: "kernel32",
                                        importc: "GetEnvironmentStringsW".}
proc FreeEnvironmentStringsW*(para1: LPWSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "FreeEnvironmentStringsW".}
proc FormatMessageW*(dwFlags: DWORD, lpSource: LPCVOID, dwMessageId: DWORD,
                     dwLanguageId: DWORD, lpBuffer: LPWSTR, nSize: DWORD,
                     Arguments: va_list): DWORD{.stdcall, dynlib: "kernel32",
    importc: "FormatMessageW".}
proc CreateMailslotW*(lpName: LPCWSTR, nMaxMessageSize: DWORD,
                      lReadTimeout: DWORD,
                      lpSecurityAttributes: LPSECURITY_ATTRIBUTES): HANDLE{.
    stdcall, dynlib: "kernel32", importc: "CreateMailslotW".}
proc lstrcmpW*(lpString1: LPCWSTR, lpString2: LPCWSTR): int32{.stdcall,
    dynlib: "kernel32", importc: "lstrcmpW".}
proc lstrcmpiW*(lpString1: LPCWSTR, lpString2: LPCWSTR): int32{.stdcall,
    dynlib: "kernel32", importc: "lstrcmpiW".}
proc lstrcpynW*(lpString1: LPWSTR, lpString2: LPCWSTR, iMaxLength: int32): LPWSTR{.
    stdcall, dynlib: "kernel32", importc: "lstrcpynW".}
proc lstrcpyW*(lpString1: LPWSTR, lpString2: LPCWSTR): LPWSTR{.stdcall,
    dynlib: "kernel32", importc: "lstrcpyW".}
proc lstrcatW*(lpString1: LPWSTR, lpString2: LPCWSTR): LPWSTR{.stdcall,
    dynlib: "kernel32", importc: "lstrcatW".}
proc lstrlenW*(lpString: LPCWSTR): int32{.stdcall, dynlib: "kernel32",
    importc: "lstrlenW".}
proc CreateMutexW*(lpMutexAttributes: LPSECURITY_ATTRIBUTES,
                   bInitialOwner: WINBOOL, lpName: LPCWSTR): HANDLE{.stdcall,
    dynlib: "kernel32", importc: "CreateMutexW".}
proc OpenMutexW*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                 lpName: LPCWSTR): HANDLE{.stdcall, dynlib: "kernel32",
    importc: "OpenMutexW".}
proc CreateEventW*(lpEventAttributes: LPSECURITY_ATTRIBUTES,
                   bManualReset: WINBOOL, bInitialState: WINBOOL,
                   lpName: LPCWSTR): HANDLE{.stdcall, dynlib: "kernel32",
    importc: "CreateEventW".}
proc OpenEventW*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                 lpName: LPCWSTR): HANDLE{.stdcall, dynlib: "kernel32",
    importc: "OpenEventW".}
proc CreateSemaphoreW*(lpSemaphoreAttributes: LPSECURITY_ATTRIBUTES,
                       lInitialCount: LONG, lMaximumCount: LONG, lpName: LPCWSTR): HANDLE{.
    stdcall, dynlib: "kernel32", importc: "CreateSemaphoreW".}
proc OpenSemaphoreW*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                     lpName: LPCWSTR): HANDLE{.stdcall, dynlib: "kernel32",
    importc: "OpenSemaphoreW".}
proc CreateFileMappingW*(hFile: HANDLE,
                         lpFileMappingAttributes: LPSECURITY_ATTRIBUTES,
                         flProtect: DWORD, dwMaximumSizeHigh: DWORD,
                         dwMaximumSizeLow: DWORD, lpName: LPCWSTR): HANDLE{.
    stdcall, dynlib: "kernel32", importc: "CreateFileMappingW".}
proc OpenFileMappingW*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                       lpName: LPCWSTR): HANDLE{.stdcall, dynlib: "kernel32",
    importc: "OpenFileMappingW".}
proc GetLogicalDriveStringsW*(nBufferLength: DWORD, lpBuffer: LPWSTR): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetLogicalDriveStringsW".}
proc LoadLibraryW*(lpLibFileName: LPCWSTR): HINST{.stdcall, dynlib: "kernel32",
    importc: "LoadLibraryW".}
proc LoadLibraryExW*(lpLibFileName: LPCWSTR, hFile: HANDLE, dwFlags: DWORD): HINST{.
    stdcall, dynlib: "kernel32", importc: "LoadLibraryExW".}
proc GetModuleFileNameW*(hModule: HINST, lpFilename: LPWSTR, nSize: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetModuleFileNameW".}
proc GetModuleHandleW*(lpModuleName: LPCWSTR): HMODULE{.stdcall,
    dynlib: "kernel32", importc: "GetModuleHandleW".}
proc FatalAppExitW*(uAction: UINT, lpMessageText: LPCWSTR){.stdcall,
    dynlib: "kernel32", importc: "FatalAppExitW".}
proc GetCommandLineW*(): LPWSTR{.stdcall, dynlib: "kernel32",
                                 importc: "GetCommandLineW".}
proc GetEnvironmentVariableW*(lpName: LPCWSTR, lpBuffer: LPWSTR, nSize: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetEnvironmentVariableW".}
proc SetEnvironmentVariableW*(lpName: LPCWSTR, lpValue: LPCWSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetEnvironmentVariableW".}
proc ExpandEnvironmentStringsW*(lpSrc: LPCWSTR, lpDst: LPWSTR, nSize: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc: "ExpandEnvironmentStringsW".}
proc OutputDebugStringW*(lpOutputString: LPCWSTR){.stdcall, dynlib: "kernel32",
    importc: "OutputDebugStringW".}
proc FindResourceW*(hModule: HINST, lpName: LPCWSTR, lpType: LPCWSTR): HRSRC{.
    stdcall, dynlib: "kernel32", importc: "FindResourceW".}
proc FindResourceExW*(hModule: HINST, lpType: LPCWSTR, lpName: LPCWSTR,
                      wLanguage: int16): HRSRC{.stdcall, dynlib: "kernel32",
    importc: "FindResourceExW".}
proc EnumResourceTypesW*(hModule: HINST, lpEnumFunc: ENUMRESTYPEPROC,
                         lParam: LONG): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "EnumResourceTypesW".}
proc EnumResourceNamesW*(hModule: HINST, lpType: LPCWSTR,
                         lpEnumFunc: ENUMRESNAMEPROC, lParam: LONG): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "EnumResourceNamesW".}
proc EnumResourceLanguagesW*(hModule: HINST, lpType: LPCWSTR, lpName: LPCWSTR,
                             lpEnumFunc: ENUMRESLANGPROC, lParam: LONG): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "EnumResourceLanguagesW".}
proc BeginUpdateResourceW*(pFileName: LPCWSTR, bDeleteExistingResources: WINBOOL): HANDLE{.
    stdcall, dynlib: "kernel32", importc: "BeginUpdateResourceW".}
proc UpdateResourceW*(hUpdate: HANDLE, lpType: LPCWSTR, lpName: LPCWSTR,
                      wLanguage: int16, lpData: LPVOID, cbData: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "UpdateResourceW".}
proc EndUpdateResourceW*(hUpdate: HANDLE, fDiscard: WINBOOL): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "EndUpdateResourceW".}
proc GlobalAddAtomW*(lpString: LPCWSTR): ATOM{.stdcall, dynlib: "kernel32",
    importc: "GlobalAddAtomW".}
proc GlobalFindAtomW*(lpString: LPCWSTR): ATOM{.stdcall, dynlib: "kernel32",
    importc: "GlobalFindAtomW".}
proc GlobalGetAtomNameW*(nAtom: ATOM, lpBuffer: LPWSTR, nSize: int32): UINT{.
    stdcall, dynlib: "kernel32", importc: "GlobalGetAtomNameW".}
proc AddAtomW*(lpString: LPCWSTR): ATOM{.stdcall, dynlib: "kernel32",
    importc: "AddAtomW".}
proc FindAtomW*(lpString: LPCWSTR): ATOM{.stdcall, dynlib: "kernel32",
    importc: "FindAtomW".}
proc GetAtomNameW*(nAtom: ATOM, lpBuffer: LPWSTR, nSize: int32): UINT{.stdcall,
    dynlib: "kernel32", importc: "GetAtomNameW".}
proc GetProfileIntW*(lpAppName: LPCWSTR, lpKeyName: LPCWSTR, nDefault: WINT): UINT{.
    stdcall, dynlib: "kernel32", importc: "GetProfileIntW".}
proc GetProfileStringW*(lpAppName: LPCWSTR, lpKeyName: LPCWSTR,
                        lpDefault: LPCWSTR, lpReturnedString: LPWSTR,
                        nSize: DWORD): DWORD{.stdcall, dynlib: "kernel32",
    importc: "GetProfileStringW".}
proc WriteProfileStringW*(lpAppName: LPCWSTR, lpKeyName: LPCWSTR,
                          lpString: LPCWSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WriteProfileStringW".}
proc GetProfileSectionW*(lpAppName: LPCWSTR, lpReturnedString: LPWSTR,
                         nSize: DWORD): DWORD{.stdcall, dynlib: "kernel32",
    importc: "GetProfileSectionW".}
proc WriteProfileSectionW*(lpAppName: LPCWSTR, lpString: LPCWSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteProfileSectionW".}
proc GetPrivateProfileIntW*(lpAppName: LPCWSTR, lpKeyName: LPCWSTR,
                            nDefault: WINT, lpFileName: LPCWSTR): UINT{.stdcall,
    dynlib: "kernel32", importc: "GetPrivateProfileIntW".}
proc GetPrivateProfileStringW*(lpAppName: LPCWSTR, lpKeyName: LPCWSTR,
                               lpDefault: LPCWSTR, lpReturnedString: LPWSTR,
                               nSize: DWORD, lpFileName: LPCWSTR): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetPrivateProfileStringW".}
proc WritePrivateProfileStringW*(lpAppName: LPCWSTR, lpKeyName: LPCWSTR,
                                 lpString: LPCWSTR, lpFileName: LPCWSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WritePrivateProfileStringW".}
proc GetPrivateProfileSectionW*(lpAppName: LPCWSTR, lpReturnedString: LPWSTR,
                                nSize: DWORD, lpFileName: LPCWSTR): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetPrivateProfileSectionW".}
proc WritePrivateProfileSectionW*(lpAppName: LPCWSTR, lpString: LPCWSTR,
                                  lpFileName: LPCWSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WritePrivateProfileSectionW".}
proc GetDriveTypeW*(lpRootPathName: LPCWSTR): UINT{.stdcall, dynlib: "kernel32",
    importc: "GetDriveTypeW".}
proc GetSystemDirectoryW*(lpBuffer: LPWSTR, uSize: UINT): UINT{.stdcall,
    dynlib: "kernel32", importc: "GetSystemDirectoryW".}
proc GetTempPathW*(nBufferLength: DWORD, lpBuffer: LPWSTR): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetTempPathW".}
proc GetTempFileNameW*(lpPathName: LPCWSTR, lpPrefixString: LPCWSTR,
                       uUnique: UINT, lpTempFileName: LPWSTR): UINT{.stdcall,
    dynlib: "kernel32", importc: "GetTempFileNameW".}
proc GetWindowsDirectoryW*(lpBuffer: LPWSTR, uSize: UINT): UINT{.stdcall,
    dynlib: "kernel32", importc: "GetWindowsDirectoryW".}
proc SetCurrentDirectoryW*(lpPathName: LPCWSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetCurrentDirectoryW".}
proc GetCurrentDirectoryW*(nBufferLength: DWORD, lpBuffer: LPWSTR): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetCurrentDirectoryW".}
proc GetDiskFreeSpaceW*(lpRootPathName: LPCWSTR, lpSectorsPerCluster: LPDWORD,
                        lpBytesPerSector: LPDWORD,
                        lpNumberOfFreeClusters: LPDWORD,
                        lpTotalNumberOfClusters: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetDiskFreeSpaceW".}
proc CreateDirectoryW*(lpPathName: LPCWSTR,
                       lpSecurityAttributes: LPSECURITY_ATTRIBUTES): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CreateDirectoryW".}
proc CreateDirectoryExW*(lpTemplateDirectory: LPCWSTR, lpNewDirectory: LPCWSTR,
                         lpSecurityAttributes: LPSECURITY_ATTRIBUTES): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CreateDirectoryExW".}
proc RemoveDirectoryW*(lpPathName: LPCWSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "RemoveDirectoryW".}
proc GetFullPathNameW*(lpFileName: LPCWSTR, nBufferLength: DWORD,
                       lpBuffer: LPWSTR, lpFilePart: var LPWSTR): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetFullPathNameW".}
proc DefineDosDeviceW*(dwFlags: DWORD, lpDeviceName: LPCWSTR,
                       lpTargetPath: LPCWSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "DefineDosDeviceW".}
proc QueryDosDeviceW*(lpDeviceName: LPCWSTR, lpTargetPath: LPWSTR,
                      ucchMax: DWORD): DWORD{.stdcall, dynlib: "kernel32",
    importc: "QueryDosDeviceW".}
proc CreateFileW*(lpFileName: LPCWSTR, dwDesiredAccess: DWORD,
                  dwShareMode: DWORD,
                  lpSecurityAttributes: LPSECURITY_ATTRIBUTES,
                  dwCreationDisposition: DWORD, dwFlagsAndAttributes: DWORD,
                  hTemplateFile: HANDLE): HANDLE{.stdcall, dynlib: "kernel32",
    importc: "CreateFileW".}
proc SetFileAttributesW*(lpFileName: LPCWSTR, dwFileAttributes: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetFileAttributesW".}
proc GetFileAttributesW*(lpFileName: LPCWSTR): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetFileAttributesW".}
proc GetCompressedFileSizeW*(lpFileName: LPCWSTR, lpFileSizeHigh: LPDWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetCompressedFileSizeW".}
proc DeleteFileW*(lpFileName: LPCWSTR): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "DeleteFileW".}
proc SearchPathW*(lpPath: LPCWSTR, lpFileName: LPCWSTR, lpExtension: LPCWSTR,
                  nBufferLength: DWORD, lpBuffer: LPWSTR, lpFilePart: LPWSTR): DWORD{.
    stdcall, dynlib: "kernel32", importc: "SearchPathW".}
proc CopyFileW*(lpExistingFileName: LPCWSTR, lpNewFileName: LPCWSTR,
                bFailIfExists: WINBOOL): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "CopyFileW".}
proc MoveFileW*(lpExistingFileName: LPCWSTR, lpNewFileName: LPCWSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "MoveFileW".}
proc MoveFileExW*(lpExistingFileName: LPCWSTR, lpNewFileName: LPCWSTR,
                  dwFlags: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "MoveFileExW".}
proc CreateNamedPipeW*(lpName: LPCWSTR, dwOpenMode: DWORD, dwPipeMode: DWORD,
                       nMaxInstances: DWORD, nOutBufferSize: DWORD,
                       nInBufferSize: DWORD, nDefaultTimeOut: DWORD,
                       lpSecurityAttributes: LPSECURITY_ATTRIBUTES): HANDLE{.
    stdcall, dynlib: "kernel32", importc: "CreateNamedPipeW".}
proc GetNamedPipeHandleStateW*(hNamedPipe: HANDLE, lpState: LPDWORD,
                               lpCurInstances: LPDWORD,
                               lpMaxCollectionCount: LPDWORD,
                               lpCollectDataTimeout: LPDWORD,
                               lpUserName: LPWSTR, nMaxUserNameSize: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetNamedPipeHandleStateW".}
proc CallNamedPipeW*(lpNamedPipeName: LPCWSTR, lpInBuffer: LPVOID,
                     nInBufferSize: DWORD, lpOutBuffer: LPVOID,
                     nOutBufferSize: DWORD, lpBytesRead: LPDWORD,
                     nTimeOut: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "CallNamedPipeW".}
proc WaitNamedPipeW*(lpNamedPipeName: LPCWSTR, nTimeOut: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WaitNamedPipeW".}
proc SetVolumeLabelW*(lpRootPathName: LPCWSTR, lpVolumeName: LPCWSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetVolumeLabelW".}
proc GetVolumeInformationW*(lpRootPathName: LPCWSTR, lpVolumeNameBuffer: LPWSTR,
                            nVolumeNameSize: DWORD,
                            lpVolumeSerialNumber: LPDWORD,
                            lpMaximumComponentLength: LPDWORD,
                            lpFileSystemFlags: LPDWORD,
                            lpFileSystemNameBuffer: LPWSTR,
                            nFileSystemNameSize: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetVolumeInformationW".}
proc ClearEventLogW*(hEventLog: HANDLE, lpBackupFileName: LPCWSTR): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "ClearEventLogW".}
proc BackupEventLogW*(hEventLog: HANDLE, lpBackupFileName: LPCWSTR): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "BackupEventLogW".}
proc OpenEventLogW*(lpUNCServerName: LPCWSTR, lpSourceName: LPCWSTR): HANDLE{.
    stdcall, dynlib: "advapi32", importc: "OpenEventLogW".}
proc RegisterEventSourceW*(lpUNCServerName: LPCWSTR, lpSourceName: LPCWSTR): HANDLE{.
    stdcall, dynlib: "advapi32", importc: "RegisterEventSourceW".}
proc OpenBackupEventLogW*(lpUNCServerName: LPCWSTR, lpFileName: LPCWSTR): HANDLE{.
    stdcall, dynlib: "advapi32", importc: "OpenBackupEventLogW".}
proc ReadEventLogW*(hEventLog: HANDLE, dwReadFlags: DWORD,
                    dwRecordOffset: DWORD, lpBuffer: LPVOID,
                    nNumberOfBytesToRead: DWORD, pnBytesRead: LPDWORD,
                    pnMinNumberOfBytesNeeded: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ReadEventLogW".}
proc ReportEventW*(hEventLog: HANDLE, wType: int16, wCategory: int16,
                   dwEventID: DWORD, lpUserSid: PSID, wNumStrings: int16,
                   dwDataSize: DWORD, lpStrings: LPPCWSTR, lpRawData: LPVOID): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "ReportEventW".}
proc AccessCheckAndAuditAlarmW*(SubsystemName: LPCWSTR, HandleId: LPVOID,
                                ObjectTypeName: LPWSTR, ObjectName: LPWSTR,
                                SecurityDescriptor: PSECURITY_DESCRIPTOR,
                                DesiredAccess: DWORD,
                                GenericMapping: PGENERIC_MAPPING,
                                ObjectCreation: WINBOOL, GrantedAccess: LPDWORD,
                                AccessStatus: LPBOOL, pfGenerateOnClose: LPBOOL): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "AccessCheckAndAuditAlarmW".}
proc ObjectOpenAuditAlarmW*(SubsystemName: LPCWSTR, HandleId: LPVOID,
                            ObjectTypeName: LPWSTR, ObjectName: LPWSTR,
                            pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                            ClientToken: HANDLE, DesiredAccess: DWORD,
                            GrantedAccess: DWORD, Privileges: PPRIVILEGE_SET,
                            ObjectCreation: WINBOOL, AccessGranted: WINBOOL,
                            GenerateOnClose: LPBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ObjectOpenAuditAlarmW".}
proc ObjectPrivilegeAuditAlarmW*(SubsystemName: LPCWSTR, HandleId: LPVOID,
                                 ClientToken: HANDLE, DesiredAccess: DWORD,
                                 Privileges: PPRIVILEGE_SET,
                                 AccessGranted: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ObjectPrivilegeAuditAlarmW".}
proc ObjectCloseAuditAlarmW*(SubsystemName: LPCWSTR, HandleId: LPVOID,
                             GenerateOnClose: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ObjectCloseAuditAlarmW".}
proc PrivilegedServiceAuditAlarmW*(SubsystemName: LPCWSTR, ServiceName: LPCWSTR,
                                   ClientToken: HANDLE,
                                   Privileges: PPRIVILEGE_SET,
                                   AccessGranted: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "PrivilegedServiceAuditAlarmW".}
proc SetFileSecurityW*(lpFileName: LPCWSTR,
                       SecurityInformation: SECURITY_INFORMATION,
                       pSecurityDescriptor: PSECURITY_DESCRIPTOR): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "SetFileSecurityW".}
proc GetFileSecurityW*(lpFileName: LPCWSTR,
                       RequestedInformation: SECURITY_INFORMATION,
                       pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                       nLength: DWORD, lpnLengthNeeded: LPDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetFileSecurityW".}
proc FindFirstChangeNotificationW*(lpPathName: LPCWSTR, bWatchSubtree: WINBOOL,
                                   dwNotifyFilter: DWORD): HANDLE{.stdcall,
    dynlib: "kernel32", importc: "FindFirstChangeNotificationW".}
proc IsBadStringPtrW*(lpsz: LPCWSTR, ucchMax: UINT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "IsBadStringPtrW".}
proc LookupAccountSidW*(lpSystemName: LPCWSTR, Sid: PSID, Name: LPWSTR,
                        cbName: LPDWORD, ReferencedDomainName: LPWSTR,
                        cbReferencedDomainName: LPDWORD, peUse: PSID_NAME_USE): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "LookupAccountSidW".}
proc LookupAccountNameW*(lpSystemName: LPCWSTR, lpAccountName: LPCWSTR,
                         Sid: PSID, cbSid: LPDWORD,
                         ReferencedDomainName: LPWSTR,
                         cbReferencedDomainName: LPDWORD, peUse: PSID_NAME_USE): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "LookupAccountNameW".}
proc LookupPrivilegeValueW*(lpSystemName: LPCWSTR, lpName: LPCWSTR,
                            lpLuid: PLUID): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupPrivilegeValueW".}
proc LookupPrivilegeNameW*(lpSystemName: LPCWSTR, lpLuid: PLUID, lpName: LPWSTR,
                           cbName: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupPrivilegeNameW".}
proc LookupPrivilegeDisplayNameW*(lpSystemName: LPCWSTR, lpName: LPCWSTR,
                                  lpDisplayName: LPWSTR, cbDisplayName: LPDWORD,
                                  lpLanguageId: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupPrivilegeDisplayNameW".}
proc BuildCommDCBW*(lpDef: LPCWSTR, lpDCB: LPDCB): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "BuildCommDCBW".}
proc BuildCommDCBAndTimeoutsW*(lpDef: LPCWSTR, lpDCB: LPDCB,
                               lpCommTimeouts: LPCOMMTIMEOUTS): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "BuildCommDCBAndTimeoutsW".}
proc CommConfigDialogW*(lpszName: LPCWSTR, wnd: HWND, lpCC: LPCOMMCONFIG): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CommConfigDialogW".}
proc GetDefaultCommConfigW*(lpszName: LPCWSTR, lpCC: LPCOMMCONFIG,
                            lpdwSize: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetDefaultCommConfigW".}
proc SetDefaultCommConfigW*(lpszName: LPCWSTR, lpCC: LPCOMMCONFIG, dwSize: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetDefaultCommConfigW".}
proc GetComputerNameW*(lpBuffer: LPWSTR, nSize: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetComputerNameW".}
proc SetComputerNameW*(lpComputerName: LPCWSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetComputerNameW".}
proc GetUserNameW*(lpBuffer: LPWSTR, nSize: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "GetUserNameW".}
proc LoadKeyboardLayoutW*(pwszKLID: LPCWSTR, Flags: UINT): HKL{.stdcall,
    dynlib: "user32", importc: "LoadKeyboardLayoutW".}
proc GetKeyboardLayoutNameW*(pwszKLID: LPWSTR): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetKeyboardLayoutNameW".}
proc CreateDesktopW*(lpszDesktop: LPWSTR, lpszDevice: LPWSTR,
                     pDevmodew: LPDEVMODEw, dwFlags: DWORD,
                     dwDesiredAccess: DWORD, lpsa: LPSECURITY_ATTRIBUTES): HDESK{.
    stdcall, dynlib: "user32", importc: "CreateDesktopW".}
proc OpenDesktopW*(lpszDesktop: LPWSTR, dwFlags: DWORD, fInherit: WINBOOL,
                   dwDesiredAccess: DWORD): HDESK{.stdcall, dynlib: "user32",
    importc: "OpenDesktopW".}
proc EnumDesktopsW*(hwinsta: HWINSTA, lpEnumFunc: DESKTOPENUMPROC,
                    lp: LPARAM): WINBOOL{.stdcall, dynlib: "user32",
    importc: "EnumDesktopsW".}
proc CreateWindowStationW*(lpwinsta: LPWSTR, dwReserved: DWORD,
                           dwDesiredAccess: DWORD, lpsa: LPSECURITY_ATTRIBUTES): HWINSTA{.
    stdcall, dynlib: "user32", importc: "CreateWindowStationW".}
proc OpenWindowStationW*(lpszWinSta: LPWSTR, fInherit: WINBOOL,
                         dwDesiredAccess: DWORD): HWINSTA{.stdcall,
    dynlib: "user32", importc: "OpenWindowStationW".}
proc EnumWindowStationsW*(lpEnumFunc: ENUMWINDOWSTATIONPROC, lp: LPARAM): WINBOOL{.
    stdcall, dynlib: "user32", importc: "EnumWindowStationsW".}
proc GetUserObjectInformationW*(hObj: HANDLE, nIndex: int32, pvInfo: PVOID,
                                nLength: DWORD, lpnLengthNeeded: LPDWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetUserObjectInformationW".}
proc SetUserObjectInformationW*(hObj: HANDLE, nIndex: int32, pvInfo: PVOID,
                                nLength: DWORD): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetUserObjectInformationW".}
proc RegisterWindowMessageW*(lpString: LPCWSTR): UINT{.stdcall,
    dynlib: "user32", importc: "RegisterWindowMessageW".}
proc GetMessageW*(lpMsg: LPMSG, wnd: HWND, wMsgFilterMin: UINT,
                  wMsgFilterMax: UINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "GetMessageW".}
proc DispatchMessageW*(lpMsg: LPMSG): LONG{.stdcall, dynlib: "user32",
    importc: "DispatchMessageW".}
proc PeekMessageW*(lpMsg: LPMSG, wnd: HWND, wMsgFilterMin: UINT,
                   wMsgFilterMax: UINT, wRemoveMsg: UINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "PeekMessageW".}
proc SendMessageW*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
    stdcall, dynlib: "user32", importc: "SendMessageW".}
proc SendMessageTimeoutW*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM,
                          fuFlags: UINT, uTimeout: UINT, lpdwResult: LPDWORD): LRESULT{.
    stdcall, dynlib: "user32", importc: "SendMessageTimeoutW".}
proc SendNotifyMessageW*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SendNotifyMessageW".}
proc SendMessageCallbackW*(wnd: HWND, Msg: UINT, wp: WPARAM,
                           lp: LPARAM, lpResultCallBack: SENDASYNCPROC,
                           dwData: DWORD): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SendMessageCallbackW".}
proc PostMessageW*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): WINBOOL{.
    stdcall, dynlib: "user32", importc: "PostMessageW".}
proc PostThreadMessageW*(idThread: DWORD, Msg: UINT, wp: WPARAM,
                         lp: LPARAM): WINBOOL{.stdcall, dynlib: "user32",
    importc: "PostThreadMessageW".}
proc DefWindowProcW*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
    stdcall, dynlib: "user32", importc: "DefWindowProcW".}
proc CallWindowProcW*(lpPrevWndFunc: WNDPROC, wnd: HWND, Msg: UINT,
                      wp: WPARAM, lp: LPARAM): LRESULT{.stdcall,
    dynlib: "user32", importc: "CallWindowProcW".}
proc RegisterClassW*(lpWndClass: LPWNDCLASSW): ATOM{.stdcall, dynlib: "user32",
    importc: "RegisterClassW".}
proc UnregisterClassW*(lpClassName: LPCWSTR, hInstance: HINST): WINBOOL{.
    stdcall, dynlib: "user32", importc: "UnregisterClassW".}
proc GetClassInfoW*(hInstance: HINST, lpClassName: LPCWSTR,
                    lpWndClass: LPWNDCLASS): WINBOOL{.stdcall, dynlib: "user32",
    importc: "GetClassInfoW".}
proc RegisterClassExW*(para1: LPWNDCLASSEXW): ATOM{.stdcall, dynlib: "user32",
    importc: "RegisterClassExW".}
proc GetClassInfoExW*(para1: HINST, para2: LPCWSTR, para3: LPWNDCLASSEX): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetClassInfoExW".}
proc CreateWindowExW*(dwExStyle: DWORD, lpClassName: LPCWSTR,
                      lpWindowName: LPCWSTR, dwStyle: DWORD, X: int32, Y: int32,
                      nWidth: int32, nHeight: int32, hWndParent: HWND,
                      menu: HMENU, hInstance: HINST, lpParam: LPVOID): HWND{.
    stdcall, dynlib: "user32", importc: "CreateWindowExW".}
proc CreateDialogParamW*(hInstance: HINST, lpTemplateName: LPCWSTR,
                         hWndParent: HWND, lpDialogFunc: DLGPROC,
                         dwInitParam: LPARAM): HWND{.stdcall, dynlib: "user32",
    importc: "CreateDialogParamW".}
proc CreateDialogIndirectParamW*(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                                 hWndParent: HWND, lpDialogFunc: DLGPROC,
                                 dwInitParam: LPARAM): HWND{.stdcall,
    dynlib: "user32", importc: "CreateDialogIndirectParamW".}
proc DialogBoxParamW*(hInstance: HINST, lpTemplateName: LPCWSTR,
                      hWndParent: HWND, lpDialogFunc: DLGPROC,
                      dwInitParam: LPARAM): int32{.stdcall, dynlib: "user32",
    importc: "DialogBoxParamW".}
proc DialogBoxIndirectParamW*(hInstance: HINST, hDialogTemplate: LPCDLGTEMPLATE,
                              hWndParent: HWND, lpDialogFunc: DLGPROC,
                              dwInitParam: LPARAM): int32{.stdcall,
    dynlib: "user32", importc: "DialogBoxIndirectParamW".}
proc SetDlgItemTextW*(hDlg: HWND, nIDDlgItem: int32, lpString: LPCWSTR): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SetDlgItemTextW".}
proc GetDlgItemTextW*(hDlg: HWND, nIDDlgItem: int32, lpString: LPWSTR,
                      nMaxCount: int32): UINT{.stdcall, dynlib: "user32",
    importc: "GetDlgItemTextW".}
proc SendDlgItemMessageW*(hDlg: HWND, nIDDlgItem: int32, Msg: UINT,
                          wp: WPARAM, lp: LPARAM): LONG{.stdcall,
    dynlib: "user32", importc: "SendDlgItemMessageW".}
proc DefDlgProcW*(hDlg: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
    stdcall, dynlib: "user32", importc: "DefDlgProcW".}
proc CallMsgFilterW*(lpMsg: LPMSG, nCode: int32): WINBOOL{.stdcall,
    dynlib: "user32", importc: "CallMsgFilterW".}
proc RegisterClipboardFormatW*(lpszFormat: LPCWSTR): UINT{.stdcall,
    dynlib: "user32", importc: "RegisterClipboardFormatW".}
proc GetClipboardFormatNameW*(format: UINT, lpszFormatName: LPWSTR,
                              cchMaxCount: int32): int32{.stdcall,
    dynlib: "user32", importc: "GetClipboardFormatNameW".}
proc CharToOemW*(lpszSrc: LPCWSTR, lpszDst: LPSTR): WINBOOL{.stdcall,
    dynlib: "user32", importc: "CharToOemW".}
proc OemToCharW*(lpszSrc: LPCSTR, lpszDst: LPWSTR): WINBOOL{.stdcall,
    dynlib: "user32", importc: "OemToCharW".}
proc CharToOemBuffW*(lpszSrc: LPCWSTR, lpszDst: LPSTR, cchDstLength: DWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "CharToOemBuffW".}
proc OemToCharBuffW*(lpszSrc: LPCSTR, lpszDst: LPWSTR, cchDstLength: DWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "OemToCharBuffW".}
proc CharUpperW*(lpsz: LPWSTR): LPWSTR{.stdcall, dynlib: "user32",
                                        importc: "CharUpperW".}
proc CharUpperBuffW*(lpsz: LPWSTR, cchLength: DWORD): DWORD{.stdcall,
    dynlib: "user32", importc: "CharUpperBuffW".}
proc CharLowerW*(lpsz: LPWSTR): LPWSTR{.stdcall, dynlib: "user32",
                                        importc: "CharLowerW".}
proc CharLowerBuffW*(lpsz: LPWSTR, cchLength: DWORD): DWORD{.stdcall,
    dynlib: "user32", importc: "CharLowerBuffW".}
proc CharNextW*(lpsz: LPCWSTR): LPWSTR{.stdcall, dynlib: "user32",
                                        importc: "CharNextW".}
proc CharPrevW*(lpszStart: LPCWSTR, lpszCurrent: LPCWSTR): LPWSTR{.stdcall,
    dynlib: "user32", importc: "CharPrevW".}
proc IsCharAlphaW*(ch: WCHAR): WINBOOL{.stdcall, dynlib: "user32",
                                        importc: "IsCharAlphaW".}
proc IsCharAlphaNumericW*(ch: WCHAR): WINBOOL{.stdcall, dynlib: "user32",
    importc: "IsCharAlphaNumericW".}
proc IsCharUpperW*(ch: WCHAR): WINBOOL{.stdcall, dynlib: "user32",
                                        importc: "IsCharUpperW".}
proc IsCharLowerW*(ch: WCHAR): WINBOOL{.stdcall, dynlib: "user32",
                                        importc: "IsCharLowerW".}
proc GetKeyNameTextW*(lParam: LONG, lpString: LPWSTR, nSize: int32): int32{.
    stdcall, dynlib: "user32", importc: "GetKeyNameTextW".}
proc VkKeyScanW*(ch: WCHAR): SHORT{.stdcall, dynlib: "user32",
                                    importc: "VkKeyScanW".}
proc VkKeyScanExW*(ch: WCHAR, dwhkl: HKL): SHORT{.stdcall, dynlib: "user32",
    importc: "VkKeyScanExW".}
proc MapVirtualKeyW*(uCode: UINT, uMapType: UINT): UINT{.stdcall,
    dynlib: "user32", importc: "MapVirtualKeyW".}
proc MapVirtualKeyExW*(uCode: UINT, uMapType: UINT, dwhkl: HKL): UINT{.stdcall,
    dynlib: "user32", importc: "MapVirtualKeyExW".}
proc LoadAcceleratorsW*(hInstance: HINST, lpTableName: LPCWSTR): HACCEL{.
    stdcall, dynlib: "user32", importc: "LoadAcceleratorsW".}
proc CreateAcceleratorTableW*(para1: LPACCEL, para2: int32): HACCEL{.stdcall,
    dynlib: "user32", importc: "CreateAcceleratorTableW".}
proc CopyAcceleratorTableW*(hAccelSrc: HACCEL, lpAccelDst: LPACCEL,
                            cAccelEntries: int32): int32{.stdcall,
    dynlib: "user32", importc: "CopyAcceleratorTableW".}
proc TranslateAcceleratorW*(wnd: HWND, hAccTable: HACCEL, lpMsg: LPMSG): int32{.
    stdcall, dynlib: "user32", importc: "TranslateAcceleratorW".}
proc LoadMenuW*(hInstance: HINST, lpMenuName: LPCWSTR): HMENU{.stdcall,
    dynlib: "user32", importc: "LoadMenuW".}
proc LoadMenuIndirectW*(lpMenuTemplate: LPMENUTEMPLATE): HMENU{.stdcall,
    dynlib: "user32", importc: "LoadMenuIndirectW".}
proc ChangeMenuW*(menu: HMENU, cmd: UINT, lpszNewItem: LPCWSTR,
                  cmdInsert: UINT, flags: UINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "ChangeMenuW".}
proc GetMenuStringW*(menu: HMENU, uIDItem: UINT, lpString: LPWSTR,
                     nMaxCount: int32, uFlag: UINT): int32{.stdcall,
    dynlib: "user32", importc: "GetMenuStringW".}
proc InsertMenuW*(menu: HMENU, uPosition: UINT, uFlags: UINT, uIDNewItem: UINT,
                  lpNewItem: LPCWSTR): WINBOOL{.stdcall, dynlib: "user32",
    importc: "InsertMenuW".}
proc AppendMenuW*(menu: HMENU, uFlags: UINT, uIDNewItem: UINT,
                  lpNewItem: LPCWSTR): WINBOOL{.stdcall, dynlib: "user32",
    importc: "AppendMenuW".}
proc ModifyMenuW*(hMnu: HMENU, uPosition: UINT, uFlags: UINT, uIDNewItem: UINT,
                  lpNewItem: LPCWSTR): WINBOOL{.stdcall, dynlib: "user32",
    importc: "ModifyMenuW".}
proc InsertMenuItemW*(para1: HMENU, para2: UINT, para3: WINBOOL,
                      para4: LPCMENUITEMINFO): WINBOOL{.stdcall,
    dynlib: "user32", importc: "InsertMenuItemW".}
proc GetMenuItemInfoW*(para1: HMENU, para2: UINT, para3: WINBOOL,
                       para4: LPMENUITEMINFO): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetMenuItemInfoW".}
proc SetMenuItemInfoW*(para1: HMENU, para2: UINT, para3: WINBOOL,
                       para4: LPCMENUITEMINFO): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetMenuItemInfoW".}
proc DrawTextW*(hDC: HDC, lpString: LPCWSTR, nCount: int32, lpRect: LPRECT,
                uFormat: UINT): int32{.stdcall, dynlib: "user32",
                                       importc: "DrawTextW".}
proc DrawTextExW*(para1: HDC, para2: LPWSTR, para3: int32, para4: LPRECT,
                  para5: UINT, para6: LPDRAWTEXTPARAMS): int32{.stdcall,
    dynlib: "user32", importc: "DrawTextExW".}
proc GrayStringW*(hDC: HDC, hBrush: HBRUSH, lpOutputFunc: GRAYSTRINGPROC,
                  lpData: LPARAM, nCount: int32, X: int32, Y: int32,
                  nWidth: int32, nHeight: int32): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GrayStringW".}
proc DrawStateW*(para1: HDC, para2: HBRUSH, para3: DRAWSTATEPROC, para4: LPARAM,
                 para5: WPARAM, para6: int32, para7: int32, para8: int32,
                 para9: int32, para10: UINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "DrawStateW".}
proc TabbedTextOutW*(hDC: HDC, X: int32, Y: int32, lpString: LPCWSTR,
                     nCount: int32, nTabPositions: int32,
                     lpnTabStopPositions: LPINT, nTabOrigin: int32): LONG{.
    stdcall, dynlib: "user32", importc: "TabbedTextOutW".}
proc GetTabbedTextExtentW*(hDC: HDC, lpString: LPCWSTR, nCount: int32,
                           nTabPositions: int32, lpnTabStopPositions: LPINT): DWORD{.
    stdcall, dynlib: "user32", importc: "GetTabbedTextExtentW".}
proc SetPropW*(wnd: HWND, lpString: LPCWSTR, hData: HANDLE): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetPropW".}
proc GetPropW*(wnd: HWND, lpString: LPCWSTR): HANDLE{.stdcall,
    dynlib: "user32", importc: "GetPropW".}
proc RemovePropW*(wnd: HWND, lpString: LPCWSTR): HANDLE{.stdcall,
    dynlib: "user32", importc: "RemovePropW".}
proc EnumPropsExW*(wnd: HWND, lpEnumFunc: PROPENUMPROCEX, lp: LPARAM): int32{.
    stdcall, dynlib: "user32", importc: "EnumPropsExW".}
proc EnumPropsW*(wnd: HWND, lpEnumFunc: PROPENUMPROC): int32{.stdcall,
    dynlib: "user32", importc: "EnumPropsW".}
proc SetWindowTextW*(wnd: HWND, lpString: LPCWSTR): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetWindowTextW".}
proc GetWindowTextW*(wnd: HWND, lpString: LPWSTR, nMaxCount: int32): int32{.
    stdcall, dynlib: "user32", importc: "GetWindowTextW".}
proc GetWindowTextLengthW*(wnd: HWND): int32{.stdcall, dynlib: "user32",
    importc: "GetWindowTextLengthW".}
proc MessageBoxW*(wnd: HWND, lpText: LPCWSTR, lpCaption: LPCWSTR, uType: UINT): int32{.
    stdcall, dynlib: "user32", importc: "MessageBoxW".}
proc MessageBoxExW*(wnd: HWND, lpText: LPCWSTR, lpCaption: LPCWSTR,
                    uType: UINT, wLanguageId: int16): int32{.stdcall,
    dynlib: "user32", importc: "MessageBoxExW".}
proc MessageBoxIndirectW*(para1: LPMSGBOXPARAMS): int32{.stdcall,
    dynlib: "user32", importc: "MessageBoxIndirectW".}
proc GetWindowLongW*(wnd: HWND, nIndex: int32): LONG{.stdcall,
    dynlib: "user32", importc: "GetWindowLongW".}
proc SetWindowLongW*(wnd: HWND, nIndex: int32, dwNewLong: LONG): LONG{.stdcall,
    dynlib: "user32", importc: "SetWindowLongW".}
proc GetClassLongW*(wnd: HWND, nIndex: int32): DWORD{.stdcall,
    dynlib: "user32", importc: "GetClassLongW".}
proc SetClassLongW*(wnd: HWND, nIndex: int32, dwNewLong: LONG): DWORD{.stdcall,
    dynlib: "user32", importc: "SetClassLongW".}
when defined(cpu64):
  proc GetWindowLongPtrW*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
      dynlib: "user32", importc: "GetWindowLongPtrW".}
  proc SetWindowLongPtrW*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
      stdcall, dynlib: "user32", importc: "SetWindowLongPtrW".}
  proc GetClassLongPtrW*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
      dynlib: "user32", importc: "GetClassLongPtrW".}
  proc SetClassLongPtrW*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
      stdcall, dynlib: "user32", importc: "SetClassLongPtrW".}
else:
  proc GetWindowLongPtrW*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
      dynlib: "user32", importc: "GetWindowLongW".}
  proc SetWindowLongPtrW*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
      stdcall, dynlib: "user32", importc: "SetWindowLongW".}
  proc GetClassLongPtrW*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
      dynlib: "user32", importc: "GetClassLongW".}
  proc SetClassLongPtrW*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
      stdcall, dynlib: "user32", importc: "SetClassLongW".}
proc FindWindowW*(lpClassName: LPCWSTR, lpWindowName: LPCWSTR): HWND{.stdcall,
    dynlib: "user32", importc: "FindWindowW".}
proc FindWindowExW*(para1: HWND, para2: HWND, para3: LPCWSTR, para4: LPCWSTR): HWND{.
    stdcall, dynlib: "user32", importc: "FindWindowExW".}
proc GetClassNameW*(wnd: HWND, lpClassName: LPWSTR, nMaxCount: int32): int32{.
    stdcall, dynlib: "user32", importc: "GetClassNameW".}
proc SetWindowsHookExW*(idHook: int32, lpfn: HOOKPROC, hmod: HINST,
                        dwThreadId: DWORD): HHOOK{.stdcall, dynlib: "user32",
    importc: "SetWindowsHookExW".}
proc LoadBitmapW*(hInstance: HINST, lpBitmapName: LPCWSTR): HBITMAP{.stdcall,
    dynlib: "user32", importc: "LoadBitmapW".}
proc LoadCursorW*(hInstance: HINST, lpCursorName: LPCWSTR): HCURSOR{.stdcall,
    dynlib: "user32", importc: "LoadCursorW".}
proc LoadCursorFromFileW*(lpFileName: LPCWSTR): HCURSOR{.stdcall,
    dynlib: "user32", importc: "LoadCursorFromFileW".}
proc LoadIconW*(hInstance: HINST, lpIconName: LPCWSTR): HICON{.stdcall,
    dynlib: "user32", importc: "LoadIconW".}
proc LoadImageW*(para1: HINST, para2: LPCWSTR, para3: UINT, para4: int32,
                 para5: int32, para6: UINT): HANDLE{.stdcall, dynlib: "user32",
    importc: "LoadImageW".}
proc LoadStringW*(hInstance: HINST, uID: UINT, lpBuffer: LPWSTR,
                  nBufferMax: int32): int32{.stdcall, dynlib: "user32",
    importc: "LoadStringW".}
proc IsDialogMessageW*(hDlg: HWND, lpMsg: LPMSG): WINBOOL{.stdcall,
    dynlib: "user32", importc: "IsDialogMessageW".}
proc DlgDirListW*(hDlg: HWND, lpPathSpec: LPWSTR, nIDListBox: int32,
                  nIDStaticPath: int32, uFileType: UINT): int32{.stdcall,
    dynlib: "user32", importc: "DlgDirListW".}
proc DlgDirSelectExW*(hDlg: HWND, lpString: LPWSTR, nCount: int32,
                      nIDListBox: int32): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DlgDirSelectExW".}
proc DlgDirListComboBoxW*(hDlg: HWND, lpPathSpec: LPWSTR, nIDComboBox: int32,
                          nIDStaticPath: int32, uFiletype: UINT): int32{.
    stdcall, dynlib: "user32", importc: "DlgDirListComboBoxW".}
proc DlgDirSelectComboBoxExW*(hDlg: HWND, lpString: LPWSTR, nCount: int32,
                              nIDComboBox: int32): WINBOOL{.stdcall,
    dynlib: "user32", importc: "DlgDirSelectComboBoxExW".}
proc DefFrameProcW*(wnd: HWND, hWndMDIClient: HWND, uMsg: UINT, w: WPARAM,
                    lp: LPARAM): LRESULT{.stdcall, dynlib: "user32",
    importc: "DefFrameProcW".}
proc DefMDIChildProcW*(wnd: HWND, uMsg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
    stdcall, dynlib: "user32", importc: "DefMDIChildProcW".}
proc CreateMDIWindowW*(lpClassName: LPWSTR, lpWindowName: LPWSTR,
                       dwStyle: DWORD, X: int32, Y: int32, nWidth: int32,
                       nHeight: int32, hWndParent: HWND, hInstance: HINST,
                       lp: LPARAM): HWND{.stdcall, dynlib: "user32",
    importc: "CreateMDIWindowW".}
proc WinHelpW*(hWndMain: HWND, lpszHelp: LPCWSTR, uCommand: UINT, dwData: DWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "WinHelpW".}
proc ChangeDisplaySettingsW*(lpDevMode: LPDEVMODEW, dwFlags: DWORD): LONG{.
    stdcall, dynlib: "user32", importc: "ChangeDisplaySettingsW".}
proc EnumDisplaySettingsW*(lpszDeviceName: LPCWSTR, iModeNum: DWORD,
                           lpDevMode: LPDEVMODEW): WINBOOL{.stdcall,
    dynlib: "user32", importc: "EnumDisplaySettingsW".}
proc SystemParametersInfoW*(uiAction: UINT, uiParam: UINT, pvParam: PVOID,
                            fWinIni: UINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SystemParametersInfoW".}
proc AddFontResourceW*(para1: LPCWSTR): int32{.stdcall, dynlib: "gdi32",
    importc: "AddFontResourceW".}
proc CopyMetaFileW*(para1: HMETAFILE, para2: LPCWSTR): HMETAFILE{.stdcall,
    dynlib: "gdi32", importc: "CopyMetaFileW".}
proc CreateFontIndirectW*(para1: PLOGFONT): HFONT{.stdcall, dynlib: "gdi32",
    importc: "CreateFontIndirectW".}
proc CreateFontIndirectW*(para1: var LOGFONT): HFONT{.stdcall, dynlib: "gdi32",
    importc: "CreateFontIndirectW".}
proc CreateFontW*(para1: int32, para2: int32, para3: int32, para4: int32,
                  para5: int32, para6: DWORD, para7: DWORD, para8: DWORD,
                  para9: DWORD, para10: DWORD, para11: DWORD, para12: DWORD,
                  para13: DWORD, para14: LPCWSTR): HFONT{.stdcall,
    dynlib: "gdi32", importc: "CreateFontW".}
proc CreateICW*(para1: LPCWSTR, para2: LPCWSTR, para3: LPCWSTR,
                para4: LPDEVMODEw): HDC{.stdcall, dynlib: "gdi32",
    importc: "CreateICW".}
proc CreateMetaFileW*(para1: LPCWSTR): HDC{.stdcall, dynlib: "gdi32",
    importc: "CreateMetaFileW".}
proc CreateScalableFontResourceW*(para1: DWORD, para2: LPCWSTR, para3: LPCWSTR,
                                  para4: LPCWSTR): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "CreateScalableFontResourceW".}
proc EnumFontFamiliesExW*(para1: HDC, para2: LPLOGFONT, para3: FONTENUMEXPROC,
                          para4: LPARAM, para5: DWORD): int32{.stdcall,
    dynlib: "gdi32", importc: "EnumFontFamiliesExW".}
proc EnumFontFamiliesW*(para1: HDC, para2: LPCWSTR, para3: FONTENUMPROC,
                        para4: LPARAM): int32{.stdcall, dynlib: "gdi32",
    importc: "EnumFontFamiliesW".}
proc EnumFontsW*(para1: HDC, para2: LPCWSTR, para3: ENUMFONTSPROC, para4: LPARAM): int32{.
    stdcall, dynlib: "gdi32", importc: "EnumFontsW".}
proc EnumFontsW*(para1: HDC, para2: LPCWSTR, para3: ENUMFONTSPROC,
                 para4: pointer): int32{.stdcall, dynlib: "gdi32",
    importc: "EnumFontsW".}
proc GetCharWidthW*(para1: HDC, para2: UINT, para3: UINT, para4: LPINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharWidthW".}
proc GetCharWidth32W*(para1: HDC, para2: UINT, para3: UINT, para4: LPINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharWidth32W".}
proc GetCharWidthFloatW*(para1: HDC, para2: UINT, para3: UINT, para4: ptr float32): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharWidthFloatW".}
proc GetCharABCWidthsW*(para1: HDC, para2: UINT, para3: UINT, para4: LPABC): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharABCWidthsW".}
proc GetCharABCWidthsFloatW*(para1: HDC, para2: UINT, para3: UINT,
                             para4: LPABCFLOAT): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetCharABCWidthsFloatW".}
proc GetGlyphOutlineW*(para1: HDC, para2: UINT, para3: UINT,
                       para4: LPGLYPHMETRICS, para5: DWORD, para6: LPVOID,
                       para7: PMAT2): DWORD{.stdcall, dynlib: "gdi32",
    importc: "GetGlyphOutlineW".}
proc GetMetaFileW*(para1: LPCWSTR): HMETAFILE{.stdcall, dynlib: "gdi32",
    importc: "GetMetaFileW".}
proc GetOutlineTextMetricsW*(para1: HDC, para2: UINT, para3: LPOUTLINETEXTMETRIC): UINT{.
    stdcall, dynlib: "gdi32", importc: "GetOutlineTextMetricsW".}
proc GetTextExtentPointW*(para1: HDC, para2: LPCWSTR, para3: int32,
                          para4: LPSIZE): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "GetTextExtentPointW".}
proc GetTextExtentPoint32W*(para1: HDC, para2: LPCWSTR, para3: int32,
                            para4: LPSIZE): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "GetTextExtentPoint32W".}
proc GetTextExtentExPointW*(para1: HDC, para2: LPCWSTR, para3: int32,
                            para4: int32, para5: LPINT, para6: LPINT,
                            para7: LPSIZE): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "GetTextExtentExPointW".}
proc GetCharacterPlacementW*(para1: HDC, para2: LPCWSTR, para3: int32,
                             para4: int32, para5: LPGCP_RESULTS, para6: DWORD): DWORD{.
    stdcall, dynlib: "gdi32", importc: "GetCharacterPlacementW".}
proc ResetDCW*(para1: HDC, para2: LPDEVMODEW): HDC{.stdcall, dynlib: "gdi32",
    importc: "ResetDCW".}
proc RemoveFontResourceW*(para1: LPCWSTR): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "RemoveFontResourceW".}
proc CopyEnhMetaFileW*(para1: HENHMETAFILE, para2: LPCWSTR): HENHMETAFILE{.
    stdcall, dynlib: "gdi32", importc: "CopyEnhMetaFileW".}
proc CreateEnhMetaFileW*(para1: HDC, para2: LPCWSTR, para3: LPRECT,
                         para4: LPCWSTR): HDC{.stdcall, dynlib: "gdi32",
    importc: "CreateEnhMetaFileW".}
proc GetEnhMetaFileW*(para1: LPCWSTR): HENHMETAFILE{.stdcall, dynlib: "gdi32",
    importc: "GetEnhMetaFileW".}
proc GetEnhMetaFileDescriptionW*(para1: HENHMETAFILE, para2: UINT, para3: LPWSTR): UINT{.
    stdcall, dynlib: "gdi32", importc: "GetEnhMetaFileDescriptionW".}
proc GetTextMetricsW*(para1: HDC, para2: LPTEXTMETRIC): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetTextMetricsW".}
proc StartDocW*(para1: HDC, para2: PDOCINFO): int32{.stdcall, dynlib: "gdi32",
    importc: "StartDocW".}
proc GetObjectW*(para1: HGDIOBJ, para2: int32, para3: LPVOID): int32{.stdcall,
    dynlib: "gdi32", importc: "GetObjectW".}
proc TextOutW*(para1: HDC, para2: int32, para3: int32, para4: LPCWSTR,
               para5: int32): WINBOOL{.stdcall, dynlib: "gdi32",
                                       importc: "TextOutW".}
proc ExtTextOutW*(para1: HDC, para2: int32, para3: int32, para4: UINT,
                  para5: LPRECT, para6: LPCWSTR, para7: UINT, para8: LPINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "ExtTextOutW".}
proc PolyTextOutW*(para1: HDC, para2: PPOLYTEXT, para3: int32): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "PolyTextOutW".}
proc GetTextFaceW*(para1: HDC, para2: int32, para3: LPWSTR): int32{.stdcall,
    dynlib: "gdi32", importc: "GetTextFaceW".}
proc GetKerningPairsW*(para1: HDC, para2: DWORD, para3: LPKERNINGPAIR): DWORD{.
    stdcall, dynlib: "gdi32", importc: "GetKerningPairsW".}
proc GetLogColorSpaceW*(para1: HCOLORSPACE, para2: LPLOGCOLORSPACE, para3: DWORD): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetLogColorSpaceW".}
proc CreateColorSpaceW*(para1: LPLOGCOLORSPACE): HCOLORSPACE{.stdcall,
    dynlib: "gdi32", importc: "CreateColorSpaceW".}
proc GetICMProfileW*(para1: HDC, para2: DWORD, para3: LPWSTR): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetICMProfileW".}
proc SetICMProfileW*(para1: HDC, para2: LPWSTR): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "SetICMProfileW".}
proc UpdateICMRegKeyW*(para1: DWORD, para2: DWORD, para3: LPWSTR, para4: UINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "UpdateICMRegKeyW".}
proc EnumICMProfilesW*(para1: HDC, para2: ICMENUMPROC, para3: LPARAM): int32{.
    stdcall, dynlib: "gdi32", importc: "EnumICMProfilesW".}
proc CreatePropertySheetPageW*(lppsp: LPCPROPSHEETPAGE): HPROPSHEETPAGE{.
    stdcall, dynlib: "comctl32", importc: "CreatePropertySheetPageW".}
proc PropertySheetW*(lppsph: LPCPROPSHEETHEADER): int32{.stdcall,
    dynlib: "comctl32", importc: "PropertySheetW".}
proc ImageList_LoadImageW*(hi: HINST, lpbmp: LPCWSTR, cx: int32, cGrow: int32,
                           crMask: COLORREF, uType: UINT, uFlags: UINT): HIMAGELIST{.
    stdcall, dynlib: "comctl32", importc: "ImageList_LoadImageW".}
proc CreateStatusWindowW*(style: LONG, lpszText: LPCWSTR, hwndParent: HWND,
                          wID: UINT): HWND{.stdcall, dynlib: "comctl32",
    importc: "CreateStatusWindowW".}
proc DrawStatusTextW*(hDC: HDC, lprc: LPRECT, pszText: LPCWSTR, uFlags: UINT){.
    stdcall, dynlib: "comctl32", importc: "DrawStatusTextW".}
proc GetOpenFileNameW*(para1: LPOPENFILENAME): WINBOOL{.stdcall,
    dynlib: "comdlg32", importc: "GetOpenFileNameW".}
proc GetSaveFileNameW*(para1: LPOPENFILENAME): WINBOOL{.stdcall,
    dynlib: "comdlg32", importc: "GetSaveFileNameW".}
proc GetFileTitleW*(para1: LPCWSTR, para2: LPWSTR, para3: int16): int{.stdcall,
    dynlib: "comdlg32", importc: "GetFileTitleW".}
proc ChooseColorW*(para1: LPCHOOSECOLOR): WINBOOL{.stdcall, dynlib: "comdlg32",
    importc: "ChooseColorW".}
proc ReplaceTextW*(para1: LPFINDREPLACE): HWND{.stdcall, dynlib: "comdlg32",
    importc: "ReplaceTextW".}
proc ChooseFontW*(para1: LPCHOOSEFONT): WINBOOL{.stdcall, dynlib: "comdlg32",
    importc: "ChooseFontW".}
proc FindTextW*(para1: LPFINDREPLACE): HWND{.stdcall, dynlib: "comdlg32",
    importc: "FindTextW".}
proc PrintDlgW*(para1: LPPRINTDLG): WINBOOL{.stdcall, dynlib: "comdlg32",
    importc: "PrintDlgW".}
proc PageSetupDlgW*(para1: LPPAGESETUPDLG): WINBOOL{.stdcall,
    dynlib: "comdlg32", importc: "PageSetupDlgW".}
proc CreateProcessW*(lpApplicationName: LPCWSTR, lpCommandLine: LPWSTR,
                     lpProcessAttributes: LPSECURITY_ATTRIBUTES,
                     lpThreadAttributes: LPSECURITY_ATTRIBUTES,
                     bInheritHandles: WINBOOL, dwCreationFlags: DWORD,
                     lpEnvironment: LPVOID, lpCurrentDirectory: LPCWSTR,
                     lpStartupInfo: LPSTARTUPINFO,
                     lpProcessInformation: LPPROCESS_INFORMATION): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CreateProcessW".}
proc GetStartupInfoW*(lpStartupInfo: LPSTARTUPINFO){.stdcall,
    dynlib: "kernel32", importc: "GetStartupInfoW".}
proc FindFirstFileW*(lpFileName: LPCWSTR, lpFindFileData: LPWIN32_FIND_DATAW): HANDLE{.
    stdcall, dynlib: "kernel32", importc: "FindFirstFileW".}
proc FindNextFileW*(hFindFile: HANDLE, lpFindFileData: LPWIN32_FIND_DATAW): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FindNextFileW".}
proc GetVersionExW*(VersionInformation: LPOSVERSIONINFOW): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetVersionExW".}
proc CreateWindowW*(lpClassName: LPCWSTR, lpWindowName: LPCWSTR, dwStyle: DWORD,
                    X: int32, Y: int32, nWidth: int32, nHeight: int32,
                    hWndParent: HWND, menu: HMENU, hInstance: HINST,
                    lpParam: LPVOID): HWND
proc CreateDialogW*(hInstance: HINST, lpName: LPCWSTR, hWndParent: HWND,
                    lpDialogFunc: DLGPROC): HWND
proc CreateDialogIndirectW*(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                            hWndParent: HWND, lpDialogFunc: DLGPROC): HWND
proc DialogBoxW*(hInstance: HINST, lpTemplate: LPCWSTR, hWndParent: HWND,
                 lpDialogFunc: DLGPROC): int32
proc DialogBoxIndirectW*(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                         hWndParent: HWND, lpDialogFunc: DLGPROC): int32
proc CreateDCW*(para1: LPCWSTR, para2: LPCWSTR, para3: LPCWSTR, para4: pDEVMODEW): HDC{.
    stdcall, dynlib: "gdi32", importc: "CreateDCW".}
proc VerInstallFileW*(uFlags: DWORD, szSrcFileName: LPWSTR,
                      szDestFileName: LPWSTR, szSrcDir: LPWSTR,
                      szDestDir: LPWSTR, szCurDir: LPWSTR, szTmpFile: LPWSTR,
                      lpuTmpFileLen: PUINT): DWORD{.stdcall, dynlib: "version",
    importc: "VerInstallFileW".}
proc GetFileVersionInfoSizeW*(lptstrFilename: LPWSTR, lpdwHandle: LPDWORD): DWORD{.
    stdcall, dynlib: "version", importc: "GetFileVersionInfoSizeW".}
proc GetFileVersionInfoW*(lptstrFilename: LPWSTR, dwHandle: DWORD, dwLen: DWORD,
                          lpData: LPVOID): WINBOOL{.stdcall, dynlib: "version",
    importc: "GetFileVersionInfoW".}
proc VerLanguageNameW*(wLang: DWORD, szLang: LPWSTR, nSize: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc: "VerLanguageNameW".}
proc VerQueryValueW*(pBlock: LPVOID, lpSubBlock: LPWSTR, lplpBuffer: LPVOID,
                     puLen: PUINT): WINBOOL{.stdcall, dynlib: "version",
    importc: "VerQueryValueW".}
proc VerFindFileW*(uFlags: DWORD, szFileName: LPWSTR, szWinDir: LPWSTR,
                   szAppDir: LPWSTR, szCurDir: LPWSTR, lpuCurDirLen: PUINT,
                   szDestDir: LPWSTR, lpuDestDirLen: PUINT): DWORD{.stdcall,
    dynlib: "version", importc: "VerFindFileW".}
proc RegSetValueExW*(key: HKEY, lpValueName: LPCWSTR, Reserved: DWORD,
                     dwType: DWORD, lpData: LPBYTE, cbData: DWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegSetValueExW".}
proc RegUnLoadKeyW*(key: HKEY, lpSubKey: LPCWSTR): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegUnLoadKeyW".}
proc InitiateSystemShutdownW*(lpMachineName: LPWSTR, lpMessage: LPWSTR,
                              dwTimeout: DWORD, bForceAppsClosed: WINBOOL,
                              bRebootAfterShutdown: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "InitiateSystemShutdownW".}
proc AbortSystemShutdownW*(lpMachineName: LPWSTR): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "AbortSystemShutdownW".}
proc RegRestoreKeyW*(key: HKEY, lpFile: LPCWSTR, dwFlags: DWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegRestoreKeyW".}
proc RegSaveKeyW*(key: HKEY, lpFile: LPCWSTR,
                  lpSecurityAttributes: LPSECURITY_ATTRIBUTES): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegSaveKeyW".}
proc RegSetValueW*(key: HKEY, lpSubKey: LPCWSTR, dwType: DWORD,
                   lpData: LPCWSTR, cbData: DWORD): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegSetValueW".}
proc RegQueryValueW*(key: HKEY, lpSubKey: LPCWSTR, lpValue: LPWSTR,
                     lpcbValue: PLONG): LONG{.stdcall, dynlib: "advapi32",
    importc: "RegQueryValueW".}
proc RegQueryMultipleValuesW*(key: HKEY, val_list: PVALENT, num_vals: DWORD,
                              lpValueBuf: LPWSTR, ldwTotsize: LPDWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegQueryMultipleValuesW".}
proc RegQueryValueExW*(key: HKEY, lpValueName: LPCWSTR, lpReserved: LPDWORD,
                       lpType: LPDWORD, lpData: LPBYTE, lpcbData: LPDWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegQueryValueExW".}
proc RegReplaceKeyW*(key: HKEY, lpSubKey: LPCWSTR, lpNewFile: LPCWSTR,
                     lpOldFile: LPCWSTR): LONG{.stdcall, dynlib: "advapi32",
    importc: "RegReplaceKeyW".}
proc RegConnectRegistryW*(lpMachineName: LPWSTR, key: HKEY, phkResult: PHKEY): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegConnectRegistryW".}
proc RegCreateKeyW*(key: HKEY, lpSubKey: LPCWSTR, phkResult: PHKEY): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegCreateKeyW".}
proc RegCreateKeyExW*(key: HKEY, lpSubKey: LPCWSTR, Reserved: DWORD,
                      lpClass: LPWSTR, dwOptions: DWORD, samDesired: REGSAM,
                      lpSecurityAttributes: LPSECURITY_ATTRIBUTES,
                      phkResult: PHKEY, lpdwDisposition: LPDWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegCreateKeyExW".}
proc RegDeleteKeyW*(key: HKEY, lpSubKey: LPCWSTR): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegDeleteKeyW".}
proc RegDeleteValueW*(key: HKEY, lpValueName: LPCWSTR): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegDeleteValueW".}
proc RegEnumKeyW*(key: HKEY, dwIndex: DWORD, lpName: LPWSTR, cbName: DWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegEnumKeyW".}
proc RegEnumKeyExW*(key: HKEY, dwIndex: DWORD, lpName: LPWSTR,
                    lpcbName: LPDWORD, lpReserved: LPDWORD, lpClass: LPWSTR,
                    lpcbClass: LPDWORD, lpftLastWriteTime: PFILETIME): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegEnumKeyExW".}
proc RegEnumValueW*(key: HKEY, dwIndex: DWORD, lpValueName: LPWSTR,
                    lpcbValueName: LPDWORD, lpReserved: LPDWORD,
                    lpType: LPDWORD, lpData: LPBYTE, lpcbData: LPDWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegEnumValueW".}
proc RegLoadKeyW*(key: HKEY, lpSubKey: LPCWSTR, lpFile: LPCWSTR): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegLoadKeyW".}
proc RegOpenKeyW*(key: HKEY, lpSubKey: LPCWSTR, phkResult: PHKEY): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegOpenKeyW".}
proc RegOpenKeyExW*(key: HKEY, lpSubKey: LPCWSTR, ulOptions: DWORD,
                    samDesired: REGSAM, phkResult: PHKEY): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegOpenKeyExW".}
proc RegQueryInfoKeyW*(key: HKEY, lpClass: LPWSTR, lpcbClass: LPDWORD,
                       lpReserved: LPDWORD, lpcSubKeys: LPDWORD,
                       lpcbMaxSubKeyLen: LPDWORD, lpcbMaxClassLen: LPDWORD,
                       lpcValues: LPDWORD, lpcbMaxValueNameLen: LPDWORD,
                       lpcbMaxValueLen: LPDWORD,
                       lpcbSecurityDescriptor: LPDWORD,
                       lpftLastWriteTime: PFILETIME): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegQueryInfoKeyW".}
proc CompareStringW*(Locale: LCID, dwCmpFlags: DWORD, lpString1: LPCWSTR,
                     cchCount1: int32, lpString2: LPCWSTR, cchCount2: int32): int32{.
    stdcall, dynlib: "kernel32", importc: "CompareStringW".}
proc LCMapStringW*(Locale: LCID, dwMapFlags: DWORD, lpSrcStr: LPCWSTR,
                   cchSrc: int32, lpDestStr: LPWSTR, cchDest: int32): int32{.
    stdcall, dynlib: "kernel32", importc: "LCMapStringW".}
proc GetLocaleInfoW*(Locale: LCID, LCType: LCTYPE, lpLCData: LPWSTR,
                     cchData: int32): int32{.stdcall, dynlib: "kernel32",
    importc: "GetLocaleInfoW".}
proc SetLocaleInfoW*(Locale: LCID, LCType: LCTYPE, lpLCData: LPCWSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetLocaleInfoW".}
proc GetTimeFormatW*(Locale: LCID, dwFlags: DWORD, lpTime: LPSYSTEMTIME,
                     lpFormat: LPCWSTR, lpTimeStr: LPWSTR, cchTime: int32): int32{.
    stdcall, dynlib: "kernel32", importc: "GetTimeFormatW".}
proc GetDateFormatW*(Locale: LCID, dwFlags: DWORD, lpDate: LPSYSTEMTIME,
                     lpFormat: LPCWSTR, lpDateStr: LPWSTR, cchDate: int32): int32{.
    stdcall, dynlib: "kernel32", importc: "GetDateFormatW".}
proc GetNumberFormatW*(Locale: LCID, dwFlags: DWORD, lpValue: LPCWSTR,
                       lpFormat: PNUMBERFMT, lpNumberStr: LPWSTR,
                       cchNumber: int32): int32{.stdcall, dynlib: "kernel32",
    importc: "GetNumberFormatW".}
proc GetCurrencyFormatW*(Locale: LCID, dwFlags: DWORD, lpValue: LPCWSTR,
                         lpFormat: PCURRENCYFMT, lpCurrencyStr: LPWSTR,
                         cchCurrency: int32): int32{.stdcall,
    dynlib: "kernel32", importc: "GetCurrencyFormatW".}
proc EnumCalendarInfoW*(lpCalInfoEnumProc: CALINFO_ENUMPROC, Locale: LCID,
                        Calendar: CALID, CalType: CALTYPE): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "EnumCalendarInfoW".}
proc EnumTimeFormatsW*(lpTimeFmtEnumProc: TIMEFMT_ENUMPROC, Locale: LCID,
                       dwFlags: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "EnumTimeFormatsW".}
proc EnumDateFormatsW*(lpDateFmtEnumProc: DATEFMT_ENUMPROC, Locale: LCID,
                       dwFlags: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "EnumDateFormatsW".}
proc GetStringTypeExW*(Locale: LCID, dwInfoType: DWORD, lpSrcStr: LPCWSTR,
                       cchSrc: int32, lpCharType: LPWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetStringTypeExW".}
proc GetStringTypeW*(dwInfoType: DWORD, lpSrcStr: LPCWSTR, cchSrc: int32,
                     lpCharType: LPWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "GetStringTypeW".}
proc FoldStringW*(dwMapFlags: DWORD, lpSrcStr: LPCWSTR, cchSrc: int32,
                  lpDestStr: LPWSTR, cchDest: int32): int32{.stdcall,
    dynlib: "kernel32", importc: "FoldStringW".}
proc EnumSystemLocalesW*(lpLocaleEnumProc: LOCALE_ENUMPROC, dwFlags: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "EnumSystemLocalesW".}
proc EnumSystemCodePagesW*(lpCodePageEnumProc: CODEPAGE_ENUMPROC, dwFlags: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "EnumSystemCodePagesW".}
proc PeekConsoleInputW*(hConsoleInput: HANDLE, lpBuffer: PINPUTRECORD,
                        nLength: DWORD, lpNumberOfEventsRead: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "PeekConsoleInputW".}
proc ReadConsoleInputW*(hConsoleInput: HANDLE, lpBuffer: PINPUTRECORD,
                        nLength: DWORD, lpNumberOfEventsRead: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadConsoleInputW".}
proc WriteConsoleInputW*(hConsoleInput: HANDLE, lpBuffer: PINPUTRECORD,
                         nLength: DWORD, lpNumberOfEventsWritten: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleInputW".}
proc ReadConsoleOutputW*(hConsoleOutput: HANDLE, lpBuffer: PCHAR_INFO,
                         dwBufferSize: COORD, dwBufferCoord: COORD,
                         lpReadRegion: PSMALL_RECT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "ReadConsoleOutputW".}
proc WriteConsoleOutputW*(hConsoleOutput: HANDLE, lpBuffer: PCHAR_INFO,
                          dwBufferSize: COORD, dwBufferCoord: COORD,
                          lpWriteRegion: PSMALL_RECT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WriteConsoleOutputW".}
proc ReadConsoleOutputCharacterW*(hConsoleOutput: HANDLE, lpCharacter: LPWSTR,
                                  nLength: DWORD, dwReadCoord: COORD,
                                  lpNumberOfCharsRead: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadConsoleOutputCharacterW".}
proc WriteConsoleOutputCharacterW*(hConsoleOutput: HANDLE, lpCharacter: LPCWSTR,
                                   nLength: DWORD, dwWriteCoord: COORD,
                                   lpNumberOfCharsWritten: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleOutputCharacterW".}
proc FillConsoleOutputCharacterW*(hConsoleOutput: HANDLE, cCharacter: WCHAR,
                                  nLength: DWORD, dwWriteCoord: COORD,
                                  lpNumberOfCharsWritten: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FillConsoleOutputCharacterW".}
proc ScrollConsoleScreenBufferW*(hConsoleOutput: HANDLE,
                                 lpScrollRectangle: PSMALL_RECT,
                                 lpClipRectangle: PSMALL_RECT,
                                 dwDestinationOrigin: COORD, lpFill: PCHAR_INFO): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ScrollConsoleScreenBufferW".}
proc GetConsoleTitleW*(lpConsoleTitle: LPWSTR, nSize: DWORD): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetConsoleTitleW".}
proc SetConsoleTitleW*(lpConsoleTitle: LPCWSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetConsoleTitleW".}
proc ReadConsoleW*(hConsoleInput: HANDLE, lpBuffer: LPVOID,
                   nNumberOfCharsToRead: DWORD, lpNumberOfCharsRead: LPDWORD,
                   lpReserved: LPVOID): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "ReadConsoleW".}
proc WriteConsoleW*(hConsoleOutput: HANDLE, lpBuffer: pointer,
                    nNumberOfCharsToWrite: DWORD,
                    lpNumberOfCharsWritten: LPDWORD, lpReserved: LPVOID): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleW".}
proc WNetAddConnectionW*(lpRemoteName: LPCWSTR, lpPassword: LPCWSTR,
                         lpLocalName: LPCWSTR): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetAddConnectionW".}
proc WNetAddConnection2W*(lpNetResource: LPNETRESOURCE, lpPassword: LPCWSTR,
                          lpUserName: LPCWSTR, dwFlags: DWORD): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetAddConnection2W".}
proc WNetAddConnection3W*(hwndOwner: HWND, lpNetResource: LPNETRESOURCE,
                          lpPassword: LPCWSTR, lpUserName: LPCWSTR,
                          dwFlags: DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetAddConnection3W".}
proc WNetCancelConnectionW*(lpName: LPCWSTR, fForce: WINBOOL): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetCancelConnectionW".}
proc WNetCancelConnection2W*(lpName: LPCWSTR, dwFlags: DWORD, fForce: WINBOOL): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetCancelConnection2W".}
proc WNetGetConnectionW*(lpLocalName: LPCWSTR, lpRemoteName: LPWSTR,
                         lpnLength: LPDWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetGetConnectionW".}
proc WNetUseConnectionW*(hwndOwner: HWND, lpNetResource: LPNETRESOURCE,
                         lpUserID: LPCWSTR, lpPassword: LPCWSTR, dwFlags: DWORD,
                         lpAccessName: LPWSTR, lpBufferSize: LPDWORD,
                         lpResult: LPDWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetUseConnectionW".}
proc WNetSetConnectionW*(lpName: LPCWSTR, dwProperties: DWORD, pvValues: LPVOID): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetSetConnectionW".}
proc WNetConnectionDialog1W*(lpConnDlgStruct: LPCONNECTDLGSTRUCT): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetConnectionDialog1W".}
proc WNetDisconnectDialog1W*(lpConnDlgStruct: LPDISCDLGSTRUCT): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetDisconnectDialog1W".}
proc WNetOpenEnumW*(dwScope: DWORD, dwType: DWORD, dwUsage: DWORD,
                    lpNetResource: LPNETRESOURCE, lphEnum: LPHANDLE): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetOpenEnumW".}
proc WNetEnumResourceW*(hEnum: HANDLE, lpcCount: LPDWORD, lpBuffer: LPVOID,
                        lpBufferSize: LPDWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetEnumResourceW".}
proc WNetGetUniversalNameW*(lpLocalPath: LPCWSTR, dwInfoLevel: DWORD,
                            lpBuffer: LPVOID, lpBufferSize: LPDWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetUniversalNameW".}
proc WNetGetUserW*(lpName: LPCWSTR, lpUserName: LPWSTR, lpnLength: LPDWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetUserW".}
proc WNetGetProviderNameW*(dwNetType: DWORD, lpProviderName: LPWSTR,
                           lpBufferSize: LPDWORD): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetGetProviderNameW".}
proc WNetGetNetworkInformationW*(lpProvider: LPCWSTR,
                                 lpNetInfoStruct: LPNETINFOSTRUCT): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetNetworkInformationW".}
proc WNetGetLastErrorW*(lpError: LPDWORD, lpErrorBuf: LPWSTR,
                        nErrorBufSize: DWORD, lpNameBuf: LPWSTR,
                        nNameBufSize: DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetGetLastErrorW".}
proc MultinetGetConnectionPerformanceW*(lpNetResource: LPNETRESOURCE,
    lpNetConnectInfoStruct: LPNETCONNECTINFOSTRUCT): DWORD{.stdcall,
    dynlib: "mpr", importc: "MultinetGetConnectionPerformanceW".}
proc ChangeServiceConfigW*(hService: SC_HANDLE, dwServiceType: DWORD,
                           dwStartType: DWORD, dwErrorControl: DWORD,
                           lpBinaryPathName: LPCWSTR, lpLoadOrderGroup: LPCWSTR,
                           lpdwTagId: LPDWORD, lpDependencies: LPCWSTR,
                           lpServiceStartName: LPCWSTR, lpPassword: LPCWSTR,
                           lpDisplayName: LPCWSTR): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ChangeServiceConfigW".}
proc CreateServiceW*(hSCManager: SC_HANDLE, lpServiceName: LPCWSTR,
                     lpDisplayName: LPCWSTR, dwDesiredAccess: DWORD,
                     dwServiceType: DWORD, dwStartType: DWORD,
                     dwErrorControl: DWORD, lpBinaryPathName: LPCWSTR,
                     lpLoadOrderGroup: LPCWSTR, lpdwTagId: LPDWORD,
                     lpDependencies: LPCWSTR, lpServiceStartName: LPCWSTR,
                     lpPassword: LPCWSTR): SC_HANDLE{.stdcall,
    dynlib: "advapi32", importc: "CreateServiceW".}
proc EnumDependentServicesW*(hService: SC_HANDLE, dwServiceState: DWORD,
                             lpServices: LPENUM_SERVICE_STATUS,
                             cbBufSize: DWORD, pcbBytesNeeded: LPDWORD,
                             lpServicesReturned: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "EnumDependentServicesW".}
proc EnumServicesStatusW*(hSCManager: SC_HANDLE, dwServiceType: DWORD,
                          dwServiceState: DWORD,
                          lpServices: LPENUM_SERVICE_STATUS, cbBufSize: DWORD,
                          pcbBytesNeeded: LPDWORD, lpServicesReturned: LPDWORD,
                          lpResumeHandle: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "EnumServicesStatusW".}
proc GetServiceKeyNameW*(hSCManager: SC_HANDLE, lpDisplayName: LPCWSTR,
                         lpServiceName: LPWSTR, lpcchBuffer: LPDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetServiceKeyNameW".}
proc GetServiceDisplayNameW*(hSCManager: SC_HANDLE, lpServiceName: LPCWSTR,
                             lpDisplayName: LPWSTR, lpcchBuffer: LPDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetServiceDisplayNameW".}
proc OpenSCManagerW*(lpMachineName: LPCWSTR, lpDatabaseName: LPCWSTR,
                     dwDesiredAccess: DWORD): SC_HANDLE{.stdcall,
    dynlib: "advapi32", importc: "OpenSCManagerW".}
proc OpenServiceW*(hSCManager: SC_HANDLE, lpServiceName: LPCWSTR,
                   dwDesiredAccess: DWORD): SC_HANDLE{.stdcall,
    dynlib: "advapi32", importc: "OpenServiceW".}
proc QueryServiceConfigW*(hService: SC_HANDLE,
                          lpServiceConfig: LPQUERY_SERVICE_CONFIG,
                          cbBufSize: DWORD, pcbBytesNeeded: LPDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "QueryServiceConfigW".}
proc QueryServiceLockStatusW*(hSCManager: SC_HANDLE,
                              lpLockStatus: LPQUERY_SERVICE_LOCK_STATUS,
                              cbBufSize: DWORD, pcbBytesNeeded: LPDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "QueryServiceLockStatusW".}
proc RegisterServiceCtrlHandlerW*(lpServiceName: LPCWSTR,
                                  lpHandlerProc: LPHANDLER_FUNCTION): SERVICE_STATUS_HANDLE{.
    stdcall, dynlib: "advapi32", importc: "RegisterServiceCtrlHandlerW".}
proc StartServiceCtrlDispatcherW*(lpServiceStartTable: LPSERVICE_TABLE_ENTRY): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "StartServiceCtrlDispatcherW".}
proc StartServiceW*(hService: SC_HANDLE, dwNumServiceArgs: DWORD,
                    lpServiceArgVectors: LPCWSTR): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "StartServiceW".}
proc DragQueryFileW*(para1: HDROP, para2: int, para3: LPCWSTR, para4: int): int{.
    stdcall, dynlib: "shell32", importc: "DragQueryFileW".}
proc ExtractAssociatedIconW*(para1: HINST, para2: LPCWSTR, para3: LPWORD): HICON{.
    stdcall, dynlib: "shell32", importc: "ExtractAssociatedIconW".}
proc ExtractIconW*(para1: HINST, para2: LPCWSTR, para3: int): HICON{.stdcall,
    dynlib: "shell32", importc: "ExtractIconW".}
proc FindExecutableW*(para1: LPCWSTR, para2: LPCWSTR, para3: LPCWSTR): HINST{.
    stdcall, dynlib: "shell32", importc: "FindExecutableW".}
proc ShellAboutW*(para1: HWND, para2: LPCWSTR, para3: LPCWSTR, para4: HICON): int32{.
    stdcall, dynlib: "shell32", importc: "ShellAboutW".}
proc ShellExecuteW*(para1: HWND, para2: LPCWSTR, para3: LPCWSTR, para4: LPCWSTR,
                    para5: LPCWSTR, para6: int32): HINST{.stdcall,
    dynlib: "shell32", importc: "ShellExecuteW".}
proc Shell_NotifyIconW*(dwMessage: DWORD, lpData: PNotifyIconDataA): WINBOOL{.
    stdcall, dynlib: "shell32", importc: "Shell_NotifyIconW".}
proc DdeCreateStringHandleW*(para1: DWORD, para2: LPCWSTR, para3: int32): HSZ{.
    stdcall, dynlib: "user32", importc: "DdeCreateStringHandleW".}
proc DdeInitializeW*(para1: LPDWORD, para2: PFNCALLBACK, para3: DWORD,
                     para4: DWORD): UINT{.stdcall, dynlib: "user32",
    importc: "DdeInitializeW".}
proc DdeQueryStringW*(para1: DWORD, para2: HSZ, para3: LPCWSTR, para4: DWORD,
                      para5: int32): DWORD{.stdcall, dynlib: "user32",
    importc: "DdeQueryStringW".}
proc LogonUserW*(para1: LPWSTR, para2: LPWSTR, para3: LPWSTR, para4: DWORD,
                 para5: DWORD, para6: PHANDLE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LogonUserW".}
proc CreateProcessAsUserW*(para1: HANDLE, para2: LPCWSTR, para3: LPWSTR,
                           para4: LPSECURITY_ATTRIBUTES,
                           para5: LPSECURITY_ATTRIBUTES, para6: WINBOOL,
                           para7: DWORD, para8: LPVOID, para9: LPCWSTR,
                           para10: LPSTARTUPINFO, para11: LPPROCESS_INFORMATION): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "CreateProcessAsUserW".}
when defined(winUnicode):
  proc GetBinaryType*(lpApplicationName: LPCWSTR, lpBinaryType: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "GetBinaryTypeW".}
  proc GetShortPathName*(lpszLongPath: LPCWSTR, lpszShortPath: LPWSTR,
                         cchBuffer: DWORD): DWORD{.stdcall, dynlib: "kernel32",
      importc: "GetShortPathNameW".}
  proc GetEnvironmentStrings*(): LPWSTR{.stdcall, dynlib: "kernel32",
      importc: "GetEnvironmentStringsW".}
  proc FreeEnvironmentStrings*(para1: LPWSTR): WINBOOL{.stdcall,

      dynlib: "kernel32", importc: "FreeEnvironmentStringsW".}
  proc FormatMessage*(dwFlags: DWORD, lpSource: LPCVOID, dwMessageId: DWORD,
                      dwLanguageId: DWORD, lpBuffer: LPWSTR, nSize: DWORD,
                      Arguments: va_list): DWORD{.stdcall, dynlib: "kernel32",
      importc: "FormatMessageW".}
  proc CreateMailslot*(lpName: LPCWSTR, nMaxMessageSize: DWORD,
                       lReadTimeout: DWORD,
                       lpSecurityAttributes: LPSECURITY_ATTRIBUTES): HANDLE{.
      stdcall, dynlib: "kernel32", importc: "CreateMailslotW".}
  proc lstrcmp*(lpString1: LPCWSTR, lpString2: LPCWSTR): int32{.stdcall,
      dynlib: "kernel32", importc: "lstrcmpW".}
  proc lstrcmpi*(lpString1: LPCWSTR, lpString2: LPCWSTR): int32{.stdcall,
      dynlib: "kernel32", importc: "lstrcmpiW".}
  proc lstrcpyn*(lpString1: LPWSTR, lpString2: LPCWSTR, iMaxLength: int32): LPWSTR{.
      stdcall, dynlib: "kernel32", importc: "lstrcpynW".}
  proc lstrcpy*(lpString1: LPWSTR, lpString2: LPCWSTR): LPWSTR{.stdcall,
      dynlib: "kernel32", importc: "lstrcpyW".}
  proc lstrcat*(lpString1: LPWSTR, lpString2: LPCWSTR): LPWSTR{.stdcall,
      dynlib: "kernel32", importc: "lstrcatW".}
  proc lstrlen*(lpString: LPCWSTR): int32{.stdcall, dynlib: "kernel32",
      importc: "lstrlenW".}
  proc CreateMutex*(lpMutexAttributes: LPSECURITY_ATTRIBUTES,
                    bInitialOwner: WINBOOL, lpName: LPCWSTR): HANDLE{.stdcall,
      dynlib: "kernel32", importc: "CreateMutexW".}
  proc OpenMutex*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                  lpName: LPCWSTR): HANDLE{.stdcall, dynlib: "kernel32",
      importc: "OpenMutexW".}
  proc CreateEvent*(lpEventAttributes: LPSECURITY_ATTRIBUTES,
                    bManualReset: WINBOOL, bInitialState: WINBOOL,
                    lpName: LPCWSTR): HANDLE{.stdcall, dynlib: "kernel32",
      importc: "CreateEventW".}
  proc OpenEvent*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                  lpName: LPCWSTR): HANDLE{.stdcall, dynlib: "kernel32",
      importc: "OpenEventW".}
  proc CreateSemaphore*(lpSemaphoreAttributes: LPSECURITY_ATTRIBUTES,
                        lInitialCount: LONG, lMaximumCount: LONG,
                        lpName: LPCWSTR): HANDLE{.stdcall, dynlib: "kernel32",
      importc: "CreateSemaphoreW".}
  proc OpenSemaphore*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                      lpName: LPCWSTR): HANDLE{.stdcall, dynlib: "kernel32",
      importc: "OpenSemaphoreW".}
  proc CreateFileMapping*(hFile: HANDLE,
                          lpFileMappingAttributes: LPSECURITY_ATTRIBUTES,
                          flProtect: DWORD, dwMaximumSizeHigh: DWORD,
                          dwMaximumSizeLow: DWORD, lpName: LPCWSTR): HANDLE{.
      stdcall, dynlib: "kernel32", importc: "CreateFileMappingW".}
  proc OpenFileMapping*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                        lpName: LPCWSTR): HANDLE{.stdcall, dynlib: "kernel32",
      importc: "OpenFileMappingW".}
  proc GetLogicalDriveStrings*(nBufferLength: DWORD, lpBuffer: LPWSTR): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetLogicalDriveStringsW".}
  proc LoadLibrary*(lpLibFileName: LPCWSTR): HINST{.stdcall, dynlib: "kernel32",
      importc: "LoadLibraryW".}
  proc LoadLibraryEx*(lpLibFileName: LPCWSTR, hFile: HANDLE, dwFlags: DWORD): HINST{.
      stdcall, dynlib: "kernel32", importc: "LoadLibraryExW".}
  proc GetModuleFileName*(hModule: HINST, lpFilename: LPWSTR, nSize: DWORD): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetModuleFileNameW".}
  proc GetModuleHandle*(lpModuleName: LPCWSTR): HMODULE{.stdcall,
      dynlib: "kernel32", importc: "GetModuleHandleW".}
  proc FatalAppExit*(uAction: UINT, lpMessageText: LPCWSTR){.stdcall,
      dynlib: "kernel32", importc: "FatalAppExitW".}
  proc GetCommandLine*(): LPWSTR{.stdcall, dynlib: "kernel32",
                                  importc: "GetCommandLineW".}
  proc GetEnvironmentVariable*(lpName: LPCWSTR, lpBuffer: LPWSTR, nSize: DWORD): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetEnvironmentVariableW".}
  proc SetEnvironmentVariable*(lpName: LPCWSTR, lpValue: LPCWSTR): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "SetEnvironmentVariableW".}
  proc ExpandEnvironmentStrings*(lpSrc: LPCWSTR, lpDst: LPWSTR, nSize: DWORD): DWORD{.
      stdcall, dynlib: "kernel32", importc: "ExpandEnvironmentStringsW".}
  proc OutputDebugString*(lpOutputString: LPCWSTR){.stdcall, dynlib: "kernel32",
      importc: "OutputDebugStringW".}
  proc FindResource*(hModule: HINST, lpName: LPCWSTR, lpType: LPCWSTR): HRSRC{.
      stdcall, dynlib: "kernel32", importc: "FindResourceW".}
  proc FindResourceEx*(hModule: HINST, lpType: LPCWSTR, lpName: LPCWSTR,
                       wLanguage: int16): HRSRC{.stdcall, dynlib: "kernel32",
      importc: "FindResourceExW".}
  proc EnumResourceTypes*(hModule: HINST, lpEnumFunc: ENUMRESTYPEPROC,
                          lParam: LONG): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "EnumResourceTypesW".}
  proc EnumResourceNames*(hModule: HINST, lpType: LPCWSTR,
                          lpEnumFunc: ENUMRESNAMEPROC, lParam: LONG): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "EnumResourceNamesW".}
  proc EnumResourceLanguages*(hModule: HINST, lpType: LPCWSTR, lpName: LPCWSTR,
                              lpEnumFunc: ENUMRESLANGPROC, lParam: LONG): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "EnumResourceLanguagesW".}
  proc BeginUpdateResource*(pFileName: LPCWSTR,
                            bDeleteExistingResources: WINBOOL): HANDLE{.stdcall,
      dynlib: "kernel32", importc: "BeginUpdateResourceW".}
  proc UpdateResource*(hUpdate: HANDLE, lpType: LPCWSTR, lpName: LPCWSTR,
                       wLanguage: int16, lpData: LPVOID, cbData: DWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "UpdateResourceW".}
  proc EndUpdateResource*(hUpdate: HANDLE, fDiscard: WINBOOL): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "EndUpdateResourceW".}
  proc GlobalAddAtom*(lpString: LPCWSTR): ATOM{.stdcall, dynlib: "kernel32",
      importc: "GlobalAddAtomW".}
  proc GlobalFindAtom*(lpString: LPCWSTR): ATOM{.stdcall, dynlib: "kernel32",
      importc: "GlobalFindAtomW".}
  proc GlobalGetAtomName*(nAtom: ATOM, lpBuffer: LPWSTR, nSize: int32): UINT{.
      stdcall, dynlib: "kernel32", importc: "GlobalGetAtomNameW".}
  proc AddAtom*(lpString: LPCWSTR): ATOM{.stdcall, dynlib: "kernel32",
      importc: "AddAtomW".}
  proc FindAtom*(lpString: LPCWSTR): ATOM{.stdcall, dynlib: "kernel32",
      importc: "FindAtomW".}
  proc GetAtomName*(nAtom: ATOM, lpBuffer: LPWSTR, nSize: int32): UINT{.stdcall,
      dynlib: "kernel32", importc: "GetAtomNameW".}
  proc GetProfileInt*(lpAppName: LPCWSTR, lpKeyName: LPCWSTR, nDefault: WINT): UINT{.
      stdcall, dynlib: "kernel32", importc: "GetProfileIntW".}
  proc GetProfileString*(lpAppName: LPCWSTR, lpKeyName: LPCWSTR,
                         lpDefault: LPCWSTR, lpReturnedString: LPWSTR,
                         nSize: DWORD): DWORD{.stdcall, dynlib: "kernel32",
      importc: "GetProfileStringW".}
  proc WriteProfileString*(lpAppName: LPCWSTR, lpKeyName: LPCWSTR,
                           lpString: LPCWSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "WriteProfileStringW".}
  proc GetProfileSection*(lpAppName: LPCWSTR, lpReturnedString: LPWSTR,
                          nSize: DWORD): DWORD{.stdcall, dynlib: "kernel32",
      importc: "GetProfileSectionW".}
  proc WriteProfileSection*(lpAppName: LPCWSTR, lpString: LPCWSTR): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "WriteProfileSectionW".}
  proc GetPrivateProfileInt*(lpAppName: LPCWSTR, lpKeyName: LPCWSTR,
                             nDefault: WINT, lpFileName: LPCWSTR): UINT{.
      stdcall, dynlib: "kernel32", importc: "GetPrivateProfileIntW".}
  proc GetPrivateProfileString*(lpAppName: LPCWSTR, lpKeyName: LPCWSTR,
                                lpDefault: LPCWSTR, lpReturnedString: LPWSTR,
                                nSize: DWORD, lpFileName: LPCWSTR): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetPrivateProfileStringW".}
  proc WritePrivateProfileString*(lpAppName: LPCWSTR, lpKeyName: LPCWSTR,
                                  lpString: LPCWSTR, lpFileName: LPCWSTR): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "WritePrivateProfileStringW".}
  proc GetPrivateProfileSection*(lpAppName: LPCWSTR, lpReturnedString: LPWSTR,
                                 nSize: DWORD, lpFileName: LPCWSTR): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetPrivateProfileSectionW".}
  proc WritePrivateProfileSection*(lpAppName: LPCWSTR, lpString: LPCWSTR,
                                   lpFileName: LPCWSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "WritePrivateProfileSectionW".}
  proc GetDriveType*(lpRootPathName: LPCWSTR): UINT{.stdcall,
      dynlib: "kernel32", importc: "GetDriveTypeW".}
  proc GetSystemDirectory*(lpBuffer: LPWSTR, uSize: UINT): UINT{.stdcall,
      dynlib: "kernel32", importc: "GetSystemDirectoryW".}
  proc GetTempPath*(nBufferLength: DWORD, lpBuffer: LPWSTR): DWORD{.stdcall,
      dynlib: "kernel32", importc: "GetTempPathW".}
  proc GetTempFileName*(lpPathName: LPCWSTR, lpPrefixString: LPCWSTR,
                        uUnique: UINT, lpTempFileName: LPWSTR): UINT{.stdcall,
      dynlib: "kernel32", importc: "GetTempFileNameW".}
  proc GetWindowsDirectory*(lpBuffer: LPWSTR, uSize: UINT): UINT{.stdcall,
      dynlib: "kernel32", importc: "GetWindowsDirectoryW".}
  proc SetCurrentDirectory*(lpPathName: LPCWSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "SetCurrentDirectoryW".}
  proc GetCurrentDirectory*(nBufferLength: DWORD, lpBuffer: LPWSTR): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetCurrentDirectoryW".}
  proc GetDiskFreeSpace*(lpRootPathName: LPCWSTR, lpSectorsPerCluster: LPDWORD,
                         lpBytesPerSector: LPDWORD,
                         lpNumberOfFreeClusters: LPDWORD,
                         lpTotalNumberOfClusters: LPDWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetDiskFreeSpaceW".}
  proc CreateDirectory*(lpPathName: LPCWSTR,
                        lpSecurityAttributes: LPSECURITY_ATTRIBUTES): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "CreateDirectoryW".}
  proc CreateDirectoryEx*(lpTemplateDirectory: LPCWSTR, lpNewDirectory: LPCWSTR,
                          lpSecurityAttributes: LPSECURITY_ATTRIBUTES): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "CreateDirectoryExW".}
  proc RemoveDirectory*(lpPathName: LPCWSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "RemoveDirectoryW".}
  proc GetFullPathName*(lpFileName: LPCWSTR, nBufferLength: DWORD,
                        lpBuffer: LPWSTR, lpFilePart: var LPWSTR): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetFullPathNameW".}
  proc DefineDosDevice*(dwFlags: DWORD, lpDeviceName: LPCWSTR,
                        lpTargetPath: LPCWSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "DefineDosDeviceW".}
  proc QueryDosDevice*(lpDeviceName: LPCWSTR, lpTargetPath: LPWSTR,
                       ucchMax: DWORD): DWORD{.stdcall, dynlib: "kernel32",
      importc: "QueryDosDeviceW".}
  proc CreateFile*(lpFileName: LPCWSTR, dwDesiredAccess: DWORD,
                   dwShareMode: DWORD,
                   lpSecurityAttributes: LPSECURITY_ATTRIBUTES,
                   dwCreationDisposition: DWORD, dwFlagsAndAttributes: DWORD,
                   hTemplateFile: HANDLE): HANDLE{.stdcall, dynlib: "kernel32",
      importc: "CreateFileW".}
  proc SetFileAttributes*(lpFileName: LPCWSTR, dwFileAttributes: DWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "SetFileAttributesW".}
  proc GetFileAttributes*(lpFileName: LPCWSTR): DWORD{.stdcall,
      dynlib: "kernel32", importc: "GetFileAttributesW".}
  proc GetCompressedFileSize*(lpFileName: LPCWSTR, lpFileSizeHigh: LPDWORD): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetCompressedFileSizeW".}
  proc DeleteFile*(lpFileName: LPCWSTR): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "DeleteFileW".}
  proc SearchPath*(lpPath: LPCWSTR, lpFileName: LPCWSTR, lpExtension: LPCWSTR,
                   nBufferLength: DWORD, lpBuffer: LPWSTR, lpFilePart: LPWSTR): DWORD{.
      stdcall, dynlib: "kernel32", importc: "SearchPathW".}
  proc CopyFile*(lpExistingFileName: LPCWSTR, lpNewFileName: LPCWSTR,
                 bFailIfExists: WINBOOL): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "CopyFileW".}
  proc MoveFile*(lpExistingFileName: LPCWSTR, lpNewFileName: LPCWSTR): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "MoveFileW".}
  proc MoveFileEx*(lpExistingFileName: LPCWSTR, lpNewFileName: LPCWSTR,
                   dwFlags: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "MoveFileExW".}
  proc CreateNamedPipe*(lpName: LPCWSTR, dwOpenMode: DWORD, dwPipeMode: DWORD,
                        nMaxInstances: DWORD, nOutBufferSize: DWORD,
                        nInBufferSize: DWORD, nDefaultTimeOut: DWORD,
                        lpSecurityAttributes: LPSECURITY_ATTRIBUTES): HANDLE{.
      stdcall, dynlib: "kernel32", importc: "CreateNamedPipeW".}
  proc GetNamedPipeHandleState*(hNamedPipe: HANDLE, lpState: LPDWORD,
                                lpCurInstances: LPDWORD,
                                lpMaxCollectionCount: LPDWORD,
                                lpCollectDataTimeout: LPDWORD,
                                lpUserName: LPWSTR, nMaxUserNameSize: DWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "GetNamedPipeHandleStateW".}
  proc CallNamedPipe*(lpNamedPipeName: LPCWSTR, lpInBuffer: LPVOID,
                      nInBufferSize: DWORD, lpOutBuffer: LPVOID,
                      nOutBufferSize: DWORD, lpBytesRead: LPDWORD,
                      nTimeOut: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "CallNamedPipeW".}
  proc WaitNamedPipe*(lpNamedPipeName: LPCWSTR, nTimeOut: DWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "WaitNamedPipeW".}
  proc SetVolumeLabel*(lpRootPathName: LPCWSTR, lpVolumeName: LPCWSTR): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "SetVolumeLabelW".}
  proc GetVolumeInformation*(lpRootPathName: LPCWSTR,
                             lpVolumeNameBuffer: LPWSTR, nVolumeNameSize: DWORD,
                             lpVolumeSerialNumber: LPDWORD,
                             lpMaximumComponentLength: LPDWORD,
                             lpFileSystemFlags: LPDWORD,
                             lpFileSystemNameBuffer: LPWSTR,
                             nFileSystemNameSize: DWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetVolumeInformationW".}
  proc ClearEventLog*(hEventLog: HANDLE, lpBackupFileName: LPCWSTR): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "ClearEventLogW".}
  proc BackupEventLog*(hEventLog: HANDLE, lpBackupFileName: LPCWSTR): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "BackupEventLogW".}
  proc OpenEventLog*(lpUNCServerName: LPCWSTR, lpSourceName: LPCWSTR): HANDLE{.
      stdcall, dynlib: "advapi32", importc: "OpenEventLogW".}
  proc RegisterEventSource*(lpUNCServerName: LPCWSTR, lpSourceName: LPCWSTR): HANDLE{.
      stdcall, dynlib: "advapi32", importc: "RegisterEventSourceW".}
  proc OpenBackupEventLog*(lpUNCServerName: LPCWSTR, lpFileName: LPCWSTR): HANDLE{.
      stdcall, dynlib: "advapi32", importc: "OpenBackupEventLogW".}
  proc ReadEventLog*(hEventLog: HANDLE, dwReadFlags: DWORD,
                     dwRecordOffset: DWORD, lpBuffer: LPVOID,
                     nNumberOfBytesToRead: DWORD, pnBytesRead: LPDWORD,
                     pnMinNumberOfBytesNeeded: LPDWORD): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "ReadEventLogW".}
  proc ReportEvent*(hEventLog: HANDLE, wType: int16, wCategory: int16,
                    dwEventID: DWORD, lpUserSid: PSID, wNumStrings: int16,
                    dwDataSize: DWORD, lpStrings: LPPCWSTR, lpRawData: LPVOID): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "ReportEventW".}
  proc AccessCheckAndAuditAlarm*(SubsystemName: LPCWSTR, HandleId: LPVOID,
                                 ObjectTypeName: LPWSTR, ObjectName: LPWSTR,
                                 SecurityDescriptor: PSECURITY_DESCRIPTOR,
                                 DesiredAccess: DWORD,
                                 GenericMapping: PGENERIC_MAPPING,
                                 ObjectCreation: WINBOOL,
                                 GrantedAccess: LPDWORD, AccessStatus: LPBOOL,
                                 pfGenerateOnClose: LPBOOL): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "AccessCheckAndAuditAlarmW".}
  proc ObjectOpenAuditAlarm*(SubsystemName: LPCWSTR, HandleId: LPVOID,
                             ObjectTypeName: LPWSTR, ObjectName: LPWSTR,
                             pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                             ClientToken: HANDLE, DesiredAccess: DWORD,
                             GrantedAccess: DWORD, Privileges: PPRIVILEGE_SET,
                             ObjectCreation: WINBOOL, AccessGranted: WINBOOL,
                             GenerateOnClose: LPBOOL): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "ObjectOpenAuditAlarmW".}
  proc ObjectPrivilegeAuditAlarm*(SubsystemName: LPCWSTR, HandleId: LPVOID,
                                  ClientToken: HANDLE, DesiredAccess: DWORD,
                                  Privileges: PPRIVILEGE_SET,
                                  AccessGranted: WINBOOL): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "ObjectPrivilegeAuditAlarmW".}
  proc ObjectCloseAuditAlarm*(SubsystemName: LPCWSTR, HandleId: LPVOID,
                              GenerateOnClose: WINBOOL): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "ObjectCloseAuditAlarmW".}
  proc PrivilegedServiceAuditAlarm*(SubsystemName: LPCWSTR,
                                    ServiceName: LPCWSTR, ClientToken: HANDLE,
                                    Privileges: PPRIVILEGE_SET,
                                    AccessGranted: WINBOOL): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "PrivilegedServiceAuditAlarmW".}
  proc SetFileSecurity*(lpFileName: LPCWSTR,
                        SecurityInformation: SECURITY_INFORMATION,
                        pSecurityDescriptor: PSECURITY_DESCRIPTOR): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "SetFileSecurityW".}
  proc GetFileSecurity*(lpFileName: LPCWSTR,
                        RequestedInformation: SECURITY_INFORMATION,
                        pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                        nLength: DWORD, lpnLengthNeeded: LPDWORD): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "GetFileSecurityW".}
  proc FindFirstChangeNotification*(lpPathName: LPCWSTR, bWatchSubtree: WINBOOL,
                                    dwNotifyFilter: DWORD): HANDLE{.stdcall,
      dynlib: "kernel32", importc: "FindFirstChangeNotificationW".}
  proc IsBadStringPtr*(lpsz: LPCWSTR, ucchMax: UINT): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "IsBadStringPtrW".}
  proc LookupAccountSid*(lpSystemName: LPCWSTR, Sid: PSID, Name: LPWSTR,
                         cbName: LPDWORD, ReferencedDomainName: LPWSTR,
                         cbReferencedDomainName: LPDWORD, peUse: PSID_NAME_USE): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "LookupAccountSidW".}
  proc LookupAccountName*(lpSystemName: LPCWSTR, lpAccountName: LPCWSTR,
                          Sid: PSID, cbSid: LPDWORD,
                          ReferencedDomainName: LPWSTR,
                          cbReferencedDomainName: LPDWORD, peUse: PSID_NAME_USE): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "LookupAccountNameW".}
  proc LookupPrivilegeValue*(lpSystemName: LPCWSTR, lpName: LPCWSTR,
                             lpLuid: PLUID): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "LookupPrivilegeValueW".}
  proc LookupPrivilegeName*(lpSystemName: LPCWSTR, lpLuid: PLUID,
                            lpName: LPWSTR, cbName: LPDWORD): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "LookupPrivilegeNameW".}
  proc LookupPrivilegeDisplayName*(lpSystemName: LPCWSTR, lpName: LPCWSTR,
                                   lpDisplayName: LPWSTR,
                                   cbDisplayName: LPDWORD, lpLanguageId: LPDWORD): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "LookupPrivilegeDisplayNameW".}
  proc BuildCommDCB*(lpDef: LPCWSTR, lpDCB: LPDCB): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "BuildCommDCBW".}
  proc BuildCommDCBAndTimeouts*(lpDef: LPCWSTR, lpDCB: LPDCB,
                                lpCommTimeouts: LPCOMMTIMEOUTS): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "BuildCommDCBAndTimeoutsW".}
  proc CommConfigDialog*(lpszName: LPCWSTR, wnd: HWND, lpCC: LPCOMMCONFIG): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "CommConfigDialogW".}
  proc GetDefaultCommConfig*(lpszName: LPCWSTR, lpCC: LPCOMMCONFIG,
                             lpdwSize: LPDWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetDefaultCommConfigW".}
  proc SetDefaultCommConfig*(lpszName: LPCWSTR, lpCC: LPCOMMCONFIG,
                             dwSize: DWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "SetDefaultCommConfigW".}
  proc GetComputerName*(lpBuffer: LPWSTR, nSize: LPDWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetComputerNameW".}
  proc SetComputerName*(lpComputerName: LPCWSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "SetComputerNameW".}
  proc GetUserName*(lpBuffer: LPWSTR, nSize: LPDWORD): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "GetUserNameW".}
  proc LoadKeyboardLayout*(pwszKLID: LPCWSTR, Flags: UINT): HKL{.stdcall,
      dynlib: "user32", importc: "LoadKeyboardLayoutW".}
  proc GetKeyboardLayoutName*(pwszKLID: LPWSTR): WINBOOL{.stdcall,
      dynlib: "user32", importc: "GetKeyboardLayoutNameW".}
  proc CreateDesktop*(lpszDesktop: LPWSTR, lpszDevice: LPWSTR,
                      pDevmode: LPDEVMODE, dwFlags: DWORD,
                      dwDesiredAccess: DWORD, lpsa: LPSECURITY_ATTRIBUTES): HDESK{.
      stdcall, dynlib: "user32", importc: "CreateDesktopW".}
  proc OpenDesktop*(lpszDesktop: LPWSTR, dwFlags: DWORD, fInherit: WINBOOL,
                    dwDesiredAccess: DWORD): HDESK{.stdcall, dynlib: "user32",
      importc: "OpenDesktopW".}
  proc EnumDesktops*(hwinsta: HWINSTA, lpEnumFunc: DESKTOPENUMPROC,
                     lp: LPARAM): WINBOOL{.stdcall, dynlib: "user32",
      importc: "EnumDesktopsW".}
  proc CreateWindowStation*(lpwinsta: LPWSTR, dwReserved: DWORD,
                            dwDesiredAccess: DWORD, lpsa: LPSECURITY_ATTRIBUTES): HWINSTA{.
      stdcall, dynlib: "user32", importc: "CreateWindowStationW".}
  proc OpenWindowStation*(lpszWinSta: LPWSTR, fInherit: WINBOOL,
                          dwDesiredAccess: DWORD): HWINSTA{.stdcall,
      dynlib: "user32", importc: "OpenWindowStationW".}
  proc EnumWindowStations*(lpEnumFunc: ENUMWINDOWSTATIONPROC, lp: LPARAM): WINBOOL{.
      stdcall, dynlib: "user32", importc: "EnumWindowStationsW".}
  proc GetUserObjectInformation*(hObj: HANDLE, nIndex: int32, pvInfo: PVOID,
                                 nLength: DWORD, lpnLengthNeeded: LPDWORD): WINBOOL{.
      stdcall, dynlib: "user32", importc: "GetUserObjectInformationW".}
  proc SetUserObjectInformation*(hObj: HANDLE, nIndex: int32, pvInfo: PVOID,
                                 nLength: DWORD): WINBOOL{.stdcall,
      dynlib: "user32", importc: "SetUserObjectInformationW".}
  proc RegisterWindowMessage*(lpString: LPCWSTR): UINT{.stdcall,
      dynlib: "user32", importc: "RegisterWindowMessageW".}
  proc GetMessage*(lpMsg: LPMSG, wnd: HWND, wMsgFilterMin: UINT,
                   wMsgFilterMax: UINT): WINBOOL{.stdcall, dynlib: "user32",
      importc: "GetMessageW".}
  proc DispatchMessage*(lpMsg: LPMSG): LONG{.stdcall, dynlib: "user32",
      importc: "DispatchMessageW".}
  proc PeekMessage*(lpMsg: LPMSG, wnd: HWND, wMsgFilterMin: UINT,
                    wMsgFilterMax: UINT, wRemoveMsg: UINT): WINBOOL{.stdcall,
      dynlib: "user32", importc: "PeekMessageW".}
  proc SendMessage*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
      stdcall, dynlib: "user32", importc: "SendMessageW".}
  proc SendMessageTimeout*(wnd: HWND, Msg: UINT, wp: WPARAM,
                           lp: LPARAM, fuFlags: UINT, uTimeout: UINT,
                           lpdwResult: LPDWORD): LRESULT{.stdcall,
      dynlib: "user32", importc: "SendMessageTimeoutW".}
  proc SendNotifyMessage*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): WINBOOL{.
      stdcall, dynlib: "user32", importc: "SendNotifyMessageW".}
  proc SendMessageCallback*(wnd: HWND, Msg: UINT, wp: WPARAM,
                            lp: LPARAM, lpResultCallBack: SENDASYNCPROC,
                            dwData: DWORD): WINBOOL{.stdcall, dynlib: "user32",
      importc: "SendMessageCallbackW".}
  proc PostMessage*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): WINBOOL{.
      stdcall, dynlib: "user32", importc: "PostMessageW".}
  proc PostThreadMessage*(idThread: DWORD, Msg: UINT, wp: WPARAM,
                          lp: LPARAM): WINBOOL{.stdcall, dynlib: "user32",
      importc: "PostThreadMessageW".}
  proc DefWindowProc*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
      stdcall, dynlib: "user32", importc: "DefWindowProcW".}
  proc CallWindowProc*(lpPrevWndFunc: WNDPROC, wnd: HWND, Msg: UINT,
                       wp: WPARAM, lp: LPARAM): LRESULT{.stdcall,
      dynlib: "user32", importc: "CallWindowProcW".}
  proc RegisterClass*(lpWndClass: LPWNDCLASS): ATOM{.stdcall, dynlib: "user32",
      importc: "RegisterClassW".}
  proc UnregisterClass*(lpClassName: LPCWSTR, hInstance: HINST): WINBOOL{.
      stdcall, dynlib: "user32", importc: "UnregisterClassW".}
  proc GetClassInfo*(hInstance: HINST, lpClassName: LPCWSTR,
                     lpWndClass: LPWNDCLASS): WINBOOL{.stdcall,
      dynlib: "user32", importc: "GetClassInfoW".}
  proc RegisterClassEx*(para1: LPWNDCLASSEXW): ATOM{.stdcall, dynlib: "user32",
      importc: "RegisterClassExW".}
  proc GetClassInfoEx*(para1: HINST, para2: LPCWSTR, para3: LPWNDCLASSEX): WINBOOL{.
      stdcall, dynlib: "user32", importc: "GetClassInfoExW".}
  proc CreateWindowEx*(dwExStyle: DWORD, lpClassName: LPCWSTR,
                       lpWindowName: LPCWSTR, dwStyle: DWORD, X: int32,
                       Y: int32, nWidth: int32, nHeight: int32,
                       hWndParent: HWND, menu: HMENU, hInstance: HINST,
                       lpParam: LPVOID): HWND{.stdcall, dynlib: "user32",
      importc: "CreateWindowExW".}
  proc CreateDialogParam*(hInstance: HINST, lpTemplateName: LPCWSTR,
                          hWndParent: HWND, lpDialogFunc: DLGPROC,
                          dwInitParam: LPARAM): HWND{.stdcall, dynlib: "user32",
      importc: "CreateDialogParamW".}
  proc CreateDialogIndirectParam*(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                                  hWndParent: HWND, lpDialogFunc: DLGPROC,
                                  dwInitParam: LPARAM): HWND{.stdcall,
      dynlib: "user32", importc: "CreateDialogIndirectParamW".}
  proc DialogBoxParam*(hInstance: HINST, lpTemplateName: LPCWSTR,
                       hWndParent: HWND, lpDialogFunc: DLGPROC,
                       dwInitParam: LPARAM): int32{.stdcall, dynlib: "user32",
      importc: "DialogBoxParamW".}
  proc DialogBoxIndirectParam*(hInstance: HINST,
                               hDialogTemplate: LPCDLGTEMPLATE,
                               hWndParent: HWND, lpDialogFunc: DLGPROC,
                               dwInitParam: LPARAM): int32{.stdcall,
      dynlib: "user32", importc: "DialogBoxIndirectParamW".}
  proc SetDlgItemText*(hDlg: HWND, nIDDlgItem: int32, lpString: LPCWSTR): WINBOOL{.
      stdcall, dynlib: "user32", importc: "SetDlgItemTextW".}
  proc GetDlgItemText*(hDlg: HWND, nIDDlgItem: int32, lpString: LPWSTR,
                       nMaxCount: int32): UINT{.stdcall, dynlib: "user32",
      importc: "GetDlgItemTextW".}
  proc SendDlgItemMessage*(hDlg: HWND, nIDDlgItem: int32, Msg: UINT,
                           wp: WPARAM, lp: LPARAM): LONG{.stdcall,
      dynlib: "user32", importc: "SendDlgItemMessageW".}
  proc DefDlgProc*(hDlg: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
      stdcall, dynlib: "user32", importc: "DefDlgProcW".}
  proc CallMsgFilter*(lpMsg: LPMSG, nCode: int32): WINBOOL{.stdcall,
      dynlib: "user32", importc: "CallMsgFilterW".}
  proc RegisterClipboardFormat*(lpszFormat: LPCWSTR): UINT{.stdcall,
      dynlib: "user32", importc: "RegisterClipboardFormatW".}
  proc GetClipboardFormatName*(format: UINT, lpszFormatName: LPWSTR,
                               cchMaxCount: int32): int32{.stdcall,
      dynlib: "user32", importc: "GetClipboardFormatNameW".}
  proc CharToOem*(lpszSrc: LPCWSTR, lpszDst: LPSTR): WINBOOL{.stdcall,
      dynlib: "user32", importc: "CharToOemW".}
  proc OemToChar*(lpszSrc: LPCSTR, lpszDst: LPWSTR): WINBOOL{.stdcall,
      dynlib: "user32", importc: "OemToCharW".}
  proc CharToOemBuff*(lpszSrc: LPCWSTR, lpszDst: LPSTR, cchDstLength: DWORD): WINBOOL{.
      stdcall, dynlib: "user32", importc: "CharToOemBuffW".}
  proc OemToCharBuff*(lpszSrc: LPCSTR, lpszDst: LPWSTR, cchDstLength: DWORD): WINBOOL{.
      stdcall, dynlib: "user32", importc: "OemToCharBuffW".}
  proc CharUpper*(lpsz: LPWSTR): LPWSTR{.stdcall, dynlib: "user32",
      importc: "CharUpperW".}
  proc CharUpperBuff*(lpsz: LPWSTR, cchLength: DWORD): DWORD{.stdcall,
      dynlib: "user32", importc: "CharUpperBuffW".}
  proc CharLower*(lpsz: LPWSTR): LPWSTR{.stdcall, dynlib: "user32",
      importc: "CharLowerW".}
  proc CharLowerBuff*(lpsz: LPWSTR, cchLength: DWORD): DWORD{.stdcall,
      dynlib: "user32", importc: "CharLowerBuffW".}
  proc CharNext*(lpsz: LPCWSTR): LPWSTR{.stdcall, dynlib: "user32",
      importc: "CharNextW".}
  proc CharPrev*(lpszStart: LPCWSTR, lpszCurrent: LPCWSTR): LPWSTR{.stdcall,
      dynlib: "user32", importc: "CharPrevW".}
  proc IsCharAlpha*(ch: WCHAR): WINBOOL{.stdcall, dynlib: "user32",
      importc: "IsCharAlphaW".}
  proc IsCharAlphaNumeric*(ch: WCHAR): WINBOOL{.stdcall, dynlib: "user32",
      importc: "IsCharAlphaNumericW".}
  proc IsCharUpper*(ch: WCHAR): WINBOOL{.stdcall, dynlib: "user32",
      importc: "IsCharUpperW".}
  proc IsCharLower*(ch: WCHAR): WINBOOL{.stdcall, dynlib: "user32",
      importc: "IsCharLowerW".}
  proc GetKeyNameText*(lParam: LONG, lpString: LPWSTR, nSize: int32): int32{.
      stdcall, dynlib: "user32", importc: "GetKeyNameTextW".}
  proc VkKeyScan*(ch: WCHAR): SHORT{.stdcall, dynlib: "user32",
                                     importc: "VkKeyScanW".}
  proc VkKeyScanEx*(ch: WCHAR, dwhkl: HKL): SHORT{.stdcall, dynlib: "user32",
      importc: "VkKeyScanExW".}
  proc MapVirtualKey*(uCode: UINT, uMapType: UINT): UINT{.stdcall,
      dynlib: "user32", importc: "MapVirtualKeyW".}
  proc MapVirtualKeyEx*(uCode: UINT, uMapType: UINT, dwhkl: HKL): UINT{.stdcall,
      dynlib: "user32", importc: "MapVirtualKeyExW".}
  proc LoadAccelerators*(hInstance: HINST, lpTableName: LPCWSTR): HACCEL{.
      stdcall, dynlib: "user32", importc: "LoadAcceleratorsW".}
  proc CreateAcceleratorTable*(para1: LPACCEL, para2: int32): HACCEL{.stdcall,
      dynlib: "user32", importc: "CreateAcceleratorTableW".}
  proc CopyAcceleratorTable*(hAccelSrc: HACCEL, lpAccelDst: LPACCEL,
                             cAccelEntries: int32): int32{.stdcall,
      dynlib: "user32", importc: "CopyAcceleratorTableW".}
  proc TranslateAccelerator*(wnd: HWND, hAccTable: HACCEL, lpMsg: LPMSG): int32{.
      stdcall, dynlib: "user32", importc: "TranslateAcceleratorW".}
  proc LoadMenu*(hInstance: HINST, lpMenuName: LPCWSTR): HMENU{.stdcall,
      dynlib: "user32", importc: "LoadMenuW".}
  proc LoadMenuIndirect*(lpMenuTemplate: LPMENUTEMPLATE): HMENU{.stdcall,
      dynlib: "user32", importc: "LoadMenuIndirectW".}
  proc ChangeMenu*(menu: HMENU, cmd: UINT, lpszNewItem: LPCWSTR,
                   cmdInsert: UINT, flags: UINT): WINBOOL{.stdcall,
      dynlib: "user32", importc: "ChangeMenuW".}
  proc GetMenuString*(menu: HMENU, uIDItem: UINT, lpString: LPWSTR,
                      nMaxCount: int32, uFlag: UINT): int32{.stdcall,
      dynlib: "user32", importc: "GetMenuStringW".}
  proc InsertMenu*(menu: HMENU, uPosition: UINT, uFlags: UINT,
                   uIDNewItem: UINT, lpNewItem: LPCWSTR): WINBOOL{.stdcall,
      dynlib: "user32", importc: "InsertMenuW".}
  proc AppendMenu*(menu: HMENU, uFlags: UINT, uIDNewItem: UINT,
                   lpNewItem: LPCWSTR): WINBOOL{.stdcall, dynlib: "user32",
      importc: "AppendMenuW".}
  proc ModifyMenu*(hMnu: HMENU, uPosition: UINT, uFlags: UINT, uIDNewItem: UINT,
                   lpNewItem: LPCWSTR): WINBOOL{.stdcall, dynlib: "user32",
      importc: "ModifyMenuW".}
  proc InsertMenuItem*(para1: HMENU, para2: UINT, para3: WINBOOL,
                       para4: LPCMENUITEMINFO): WINBOOL{.stdcall,
      dynlib: "user32", importc: "InsertMenuItemW".}
  proc GetMenuItemInfo*(para1: HMENU, para2: UINT, para3: WINBOOL,
                        para4: LPMENUITEMINFO): WINBOOL{.stdcall,
      dynlib: "user32", importc: "GetMenuItemInfoW".}
  proc SetMenuItemInfo*(para1: HMENU, para2: UINT, para3: WINBOOL,
                        para4: LPCMENUITEMINFO): WINBOOL{.stdcall,
      dynlib: "user32", importc: "SetMenuItemInfoW".}
  proc DrawText*(hDC: HDC, lpString: LPCWSTR, nCount: int32, lpRect: LPRECT,
                 uFormat: UINT): int32{.stdcall, dynlib: "user32",
                                        importc: "DrawTextW".}
  proc DrawTextEx*(para1: HDC, para2: LPWSTR, para3: int32, para4: LPRECT,
                   para5: UINT, para6: LPDRAWTEXTPARAMS): int32{.stdcall,
      dynlib: "user32", importc: "DrawTextExW".}
  proc GrayString*(hDC: HDC, hBrush: HBRUSH, lpOutputFunc: GRAYSTRINGPROC,
                   lpData: LPARAM, nCount: int32, X: int32, Y: int32,
                   nWidth: int32, nHeight: int32): WINBOOL{.stdcall,
      dynlib: "user32", importc: "GrayStringW".}
  proc DrawState*(para1: HDC, para2: HBRUSH, para3: DRAWSTATEPROC,
                  para4: LPARAM, para5: WPARAM, para6: int32, para7: int32,
                  para8: int32, para9: int32, para10: UINT): WINBOOL{.stdcall,
      dynlib: "user32", importc: "DrawStateW".}
  proc TabbedTextOut*(hDC: HDC, X: int32, Y: int32, lpString: LPCWSTR,
                      nCount: int32, nTabPositions: int32,
                      lpnTabStopPositions: LPINT, nTabOrigin: int32): LONG{.
      stdcall, dynlib: "user32", importc: "TabbedTextOutW".}
  proc GetTabbedTextExtent*(hDC: HDC, lpString: LPCWSTR, nCount: int32,
                            nTabPositions: int32, lpnTabStopPositions: LPINT): DWORD{.
      stdcall, dynlib: "user32", importc: "GetTabbedTextExtentW".}
  proc SetProp*(wnd: HWND, lpString: LPCWSTR, hData: HANDLE): WINBOOL{.stdcall,
      dynlib: "user32", importc: "SetPropW".}
  proc GetProp*(wnd: HWND, lpString: LPCWSTR): HANDLE{.stdcall,
      dynlib: "user32", importc: "GetPropW".}
  proc RemoveProp*(wnd: HWND, lpString: LPCWSTR): HANDLE{.stdcall,
      dynlib: "user32", importc: "RemovePropW".}
  proc EnumPropsEx*(wnd: HWND, lpEnumFunc: PROPENUMPROCEX, lp: LPARAM): int32{.
      stdcall, dynlib: "user32", importc: "EnumPropsExW".}
  proc EnumProps*(wnd: HWND, lpEnumFunc: PROPENUMPROC): int32{.stdcall,
      dynlib: "user32", importc: "EnumPropsW".}
  proc SetWindowText*(wnd: HWND, lpString: LPCWSTR): WINBOOL{.stdcall,
      dynlib: "user32", importc: "SetWindowTextW".}
  proc GetWindowText*(wnd: HWND, lpString: LPWSTR, nMaxCount: int32): int32{.
      stdcall, dynlib: "user32", importc: "GetWindowTextW".}
  proc GetWindowTextLength*(wnd: HWND): int32{.stdcall, dynlib: "user32",
      importc: "GetWindowTextLengthW".}
  proc MessageBox*(wnd: HWND, lpText: LPCWSTR, lpCaption: LPCWSTR, uType: UINT): int32{.
      stdcall, dynlib: "user32", importc: "MessageBoxW".}
  proc MessageBoxEx*(wnd: HWND, lpText: LPCWSTR, lpCaption: LPCWSTR,
                     uType: UINT, wLanguageId: int16): int32{.stdcall,
      dynlib: "user32", importc: "MessageBoxExW".}
  proc MessageBoxIndirect*(para1: LPMSGBOXPARAMS): int32{.stdcall,
      dynlib: "user32", importc: "MessageBoxIndirectW".}
  proc GetWindowLong*(wnd: HWND, nIndex: int32): LONG{.stdcall,
      dynlib: "user32", importc: "GetWindowLongW".}
  proc SetWindowLong*(wnd: HWND, nIndex: int32, dwNewLong: LONG): LONG{.
      stdcall, dynlib: "user32", importc: "SetWindowLongW".}
  proc GetClassLong*(wnd: HWND, nIndex: int32): DWORD{.stdcall,
      dynlib: "user32", importc: "GetClassLongW".}
  proc SetClassLong*(wnd: HWND, nIndex: int32, dwNewLong: LONG): DWORD{.
      stdcall, dynlib: "user32", importc: "SetClassLongW".}
  when defined(cpu64):
    proc GetWindowLongPtr*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
        dynlib: "user32", importc: "GetWindowLongPtrW".}
    proc SetWindowLongPtr*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
        stdcall, dynlib: "user32", importc: "SetWindowLongPtrW".}
    proc GetClassLongPtr*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
        dynlib: "user32", importc: "GetClassLongPtrW".}
    proc SetClassLongPtr*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
        stdcall, dynlib: "user32", importc: "SetClassLongPtrW".}
  else:
    proc GetWindowLongPtr*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
        dynlib: "user32", importc: "GetWindowLongW".}
    proc SetWindowLongPtr*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
        stdcall, dynlib: "user32", importc: "SetWindowLongW".}
    proc GetClassLongPtr*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
        dynlib: "user32", importc: "GetClassLongW".}
    proc SetClassLongPtr*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
        stdcall, dynlib: "user32", importc: "SetClassLongW".}
  proc FindWindow*(lpClassName: LPCWSTR, lpWindowName: LPCWSTR): HWND{.stdcall,
      dynlib: "user32", importc: "FindWindowW".}
  proc FindWindowEx*(para1: HWND, para2: HWND, para3: LPCWSTR, para4: LPCWSTR): HWND{.
      stdcall, dynlib: "user32", importc: "FindWindowExW".}
  proc GetClassName*(wnd: HWND, lpClassName: LPWSTR, nMaxCount: int32): int32{.
      stdcall, dynlib: "user32", importc: "GetClassNameW".}
  proc SetWindowsHookEx*(idHook: int32, lpfn: HOOKPROC, hmod: HINST,
                         dwThreadId: DWORD): HHOOK{.stdcall, dynlib: "user32",
      importc: "SetWindowsHookExW".}
  proc LoadBitmap*(hInstance: HINST, lpBitmapName: LPCWSTR): HBITMAP{.stdcall,
      dynlib: "user32", importc: "LoadBitmapW".}
  proc LoadCursor*(hInstance: HINST, lpCursorName: LPCWSTR): HCURSOR{.stdcall,
      dynlib: "user32", importc: "LoadCursorW".}
  proc LoadCursorFromFile*(lpFileName: LPCWSTR): HCURSOR{.stdcall,
      dynlib: "user32", importc: "LoadCursorFromFileW".}
  proc LoadIcon*(hInstance: HINST, lpIconName: LPCWSTR): HICON{.stdcall,
      dynlib: "user32", importc: "LoadIconW".}
  proc LoadImage*(para1: HINST, para2: LPCWSTR, para3: UINT, para4: int32,
                  para5: int32, para6: UINT): HANDLE{.stdcall, dynlib: "user32",
      importc: "LoadImageW".}
  proc LoadString*(hInstance: HINST, uID: UINT, lpBuffer: LPWSTR,
                   nBufferMax: int32): int32{.stdcall, dynlib: "user32",
      importc: "LoadStringW".}
  proc IsDialogMessage*(hDlg: HWND, lpMsg: LPMSG): WINBOOL{.stdcall,
      dynlib: "user32", importc: "IsDialogMessageW".}
  proc DlgDirList*(hDlg: HWND, lpPathSpec: LPWSTR, nIDListBox: int32,
                   nIDStaticPath: int32, uFileType: UINT): int32{.stdcall,
      dynlib: "user32", importc: "DlgDirListW".}
  proc DlgDirSelectEx*(hDlg: HWND, lpString: LPWSTR, nCount: int32,
                       nIDListBox: int32): WINBOOL{.stdcall, dynlib: "user32",
      importc: "DlgDirSelectExW".}
  proc DlgDirListComboBox*(hDlg: HWND, lpPathSpec: LPWSTR, nIDComboBox: int32,
                           nIDStaticPath: int32, uFiletype: UINT): int32{.
      stdcall, dynlib: "user32", importc: "DlgDirListComboBoxW".}
  proc DlgDirSelectComboBoxEx*(hDlg: HWND, lpString: LPWSTR, nCount: int32,
                               nIDComboBox: int32): WINBOOL{.stdcall,
      dynlib: "user32", importc: "DlgDirSelectComboBoxExW".}
  proc DefFrameProc*(wnd: HWND, hWndMDIClient: HWND, uMsg: UINT,
                     wp: WPARAM, lp: LPARAM): LRESULT{.stdcall,
      dynlib: "user32", importc: "DefFrameProcW".}
  proc DefMDIChildProc*(wnd: HWND, uMsg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
      stdcall, dynlib: "user32", importc: "DefMDIChildProcW".}
  proc CreateMDIWindow*(lpClassName: LPWSTR, lpWindowName: LPWSTR,
                        dwStyle: DWORD, X: int32, Y: int32, nWidth: int32,
                        nHeight: int32, hWndParent: HWND, hInstance: HINST,
                        lp: LPARAM): HWND{.stdcall, dynlib: "user32",
      importc: "CreateMDIWindowW".}
  proc WinHelp*(hWndMain: HWND, lpszHelp: LPCWSTR, uCommand: UINT, dwData: DWORD): WINBOOL{.
      stdcall, dynlib: "user32", importc: "WinHelpW".}
  proc ChangeDisplaySettings*(lpDevMode: LPDEVMODE, dwFlags: DWORD): LONG{.
      stdcall, dynlib: "user32", importc: "ChangeDisplaySettingsW".}
  proc EnumDisplaySettings*(lpszDeviceName: LPCWSTR, iModeNum: DWORD,
                            lpDevMode: LPDEVMODEW): WINBOOL{.stdcall,
      dynlib: "user32", importc: "EnumDisplaySettingsW".}
  proc SystemParametersInfo*(uiAction: UINT, uiParam: UINT, pvParam: PVOID,
                             fWinIni: UINT): WINBOOL{.stdcall, dynlib: "user32",
      importc: "SystemParametersInfoW".}
  proc AddFontResource*(para1: LPCWSTR): int32{.stdcall, dynlib: "gdi32",
      importc: "AddFontResourceW".}
  proc CopyMetaFile*(para1: HMETAFILE, para2: LPCWSTR): HMETAFILE{.stdcall,
      dynlib: "gdi32", importc: "CopyMetaFileW".}
  proc CreateFontIndirect*(para1: PLOGFONT): HFONT{.stdcall, dynlib: "gdi32",
      importc: "CreateFontIndirectW".}
  proc CreateFontIndirect*(para1: var LOGFONT): HFONT{.stdcall, dynlib: "gdi32",
      importc: "CreateFontIndirectW".}
  proc CreateFont*(para1: int32, para2: int32, para3: int32, para4: int32,
                   para5: int32, para6: DWORD, para7: DWORD, para8: DWORD,
                   para9: DWORD, para10: DWORD, para11: DWORD, para12: DWORD,
                   para13: DWORD, para14: LPCWSTR): HFONT{.stdcall,
      dynlib: "gdi32", importc: "CreateFontW".}
  proc CreateIC*(para1: LPCWSTR, para2: LPCWSTR, para3: LPCWSTR,
                 para4: LPDEVMODE): HDC{.stdcall, dynlib: "gdi32",
      importc: "CreateICW".}
  proc CreateMetaFile*(para1: LPCWSTR): HDC{.stdcall, dynlib: "gdi32",
      importc: "CreateMetaFileW".}
  proc CreateScalableFontResource*(para1: DWORD, para2: LPCWSTR, para3: LPCWSTR,
                                   para4: LPCWSTR): WINBOOL{.stdcall,
      dynlib: "gdi32", importc: "CreateScalableFontResourceW".}
  proc EnumFontFamiliesEx*(para1: HDC, para2: LPLOGFONT, para3: FONTENUMEXPROC,
                           para4: LPARAM, para5: DWORD): int32{.stdcall,
      dynlib: "gdi32", importc: "EnumFontFamiliesExW".}
  proc EnumFontFamilies*(para1: HDC, para2: LPCWSTR, para3: FONTENUMPROC,
                         para4: LPARAM): int32{.stdcall, dynlib: "gdi32",
      importc: "EnumFontFamiliesW".}
  proc EnumFonts*(para1: HDC, para2: LPCWSTR, para3: ENUMFONTSPROC,
                  para4: LPARAM): int32{.stdcall, dynlib: "gdi32",
      importc: "EnumFontsW".}
  proc EnumFonts*(para1: HDC, para2: LPCWSTR, para3: ENUMFONTSPROC,
                  para4: pointer): int32{.stdcall, dynlib: "gdi32",
      importc: "EnumFontsW".}
  proc GetCharWidth*(para1: HDC, para2: UINT, para3: UINT, para4: LPINT): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "GetCharWidthW".}
  proc GetCharWidth32*(para1: HDC, para2: UINT, para3: UINT, para4: LPINT): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "GetCharWidth32W".}
  proc GetCharWidthFloat*(para1: HDC, para2: UINT, para3: UINT, para4: ptr float32): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "GetCharWidthFloatW".}
  proc GetCharABCWidths*(para1: HDC, para2: UINT, para3: UINT, para4: LPABC): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "GetCharABCWidthsW".}
  proc GetCharABCWidthsFloat*(para1: HDC, para2: UINT, para3: UINT,
                              para4: LPABCFLOAT): WINBOOL{.stdcall,
      dynlib: "gdi32", importc: "GetCharABCWidthsFloatW".}
  proc GetGlyphOutline*(para1: HDC, para2: UINT, para3: UINT,
                        para4: LPGLYPHMETRICS, para5: DWORD, para6: LPVOID,
                        para7: PMAT2): DWORD{.stdcall, dynlib: "gdi32",
      importc: "GetGlyphOutlineW".}
  proc GetMetaFile*(para1: LPCWSTR): HMETAFILE{.stdcall, dynlib: "gdi32",
      importc: "GetMetaFileW".}
  proc GetOutlineTextMetrics*(para1: HDC, para2: UINT,
                              para3: LPOUTLINETEXTMETRIC): UINT{.stdcall,
      dynlib: "gdi32", importc: "GetOutlineTextMetricsW".}
  proc GetTextExtentPoint*(para1: HDC, para2: LPCWSTR, para3: int32,
                           para4: LPSIZE): WINBOOL{.stdcall, dynlib: "gdi32",
      importc: "GetTextExtentPointW".}
  proc GetTextExtentPoint32*(para1: HDC, para2: LPCWSTR, para3: int32,
                             para4: LPSIZE): WINBOOL{.stdcall, dynlib: "gdi32",
      importc: "GetTextExtentPoint32W".}
  proc GetTextExtentExPoint*(para1: HDC, para2: LPCWSTR, para3: int32,
                             para4: int32, para5: LPINT, para6: LPINT,
                             para7: LPSIZE): WINBOOL{.stdcall, dynlib: "gdi32",
      importc: "GetTextExtentExPointW".}
  proc GetCharacterPlacement*(para1: HDC, para2: LPCWSTR, para3: int32,
                              para4: int32, para5: LPGCP_RESULTS, para6: DWORD): DWORD{.
      stdcall, dynlib: "gdi32", importc: "GetCharacterPlacementW".}
  proc ResetDC*(para1: HDC, para2: LPDEVMODE): HDC{.stdcall, dynlib: "gdi32",
      importc: "ResetDCW".}
  proc RemoveFontResource*(para1: LPCWSTR): WINBOOL{.stdcall, dynlib: "gdi32",
      importc: "RemoveFontResourceW".}
  proc CopyEnhMetaFile*(para1: HENHMETAFILE, para2: LPCWSTR): HENHMETAFILE{.
      stdcall, dynlib: "gdi32", importc: "CopyEnhMetaFileW".}
  proc CreateEnhMetaFile*(para1: HDC, para2: LPCWSTR, para3: LPRECT,
                          para4: LPCWSTR): HDC{.stdcall, dynlib: "gdi32",
      importc: "CreateEnhMetaFileW".}
  proc GetEnhMetaFile*(para1: LPCWSTR): HENHMETAFILE{.stdcall, dynlib: "gdi32",
      importc: "GetEnhMetaFileW".}
  proc GetEnhMetaFileDescription*(para1: HENHMETAFILE, para2: UINT,
                                  para3: LPWSTR): UINT{.stdcall,
      dynlib: "gdi32", importc: "GetEnhMetaFileDescriptionW".}
  proc GetTextMetrics*(para1: HDC, para2: LPTEXTMETRIC): WINBOOL{.stdcall,
      dynlib: "gdi32", importc: "GetTextMetricsW".}
  proc StartDoc*(para1: HDC, para2: PDOCINFO): int32{.stdcall, dynlib: "gdi32",
      importc: "StartDocW".}
  proc GetObject*(para1: HGDIOBJ, para2: int32, para3: LPVOID): int32{.stdcall,
      dynlib: "gdi32", importc: "GetObjectW".}
  proc TextOut*(para1: HDC, para2: int32, para3: int32, para4: LPCWSTR,
                para5: int32): WINBOOL{.stdcall, dynlib: "gdi32",
                                        importc: "TextOutW".}
  proc ExtTextOut*(para1: HDC, para2: int32, para3: int32, para4: UINT,
                   para5: LPRECT, para6: LPCWSTR, para7: UINT, para8: LPINT): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "ExtTextOutW".}
  proc PolyTextOut*(para1: HDC, para2: PPOLYTEXT, para3: int32): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "PolyTextOutW".}
  proc GetTextFace*(para1: HDC, para2: int32, para3: LPWSTR): int32{.stdcall,
      dynlib: "gdi32", importc: "GetTextFaceW".}
  proc GetKerningPairs*(para1: HDC, para2: DWORD, para3: LPKERNINGPAIR): DWORD{.
      stdcall, dynlib: "gdi32", importc: "GetKerningPairsW".}
  proc GetLogColorSpace*(para1: HCOLORSPACE, para2: LPLOGCOLORSPACE,
                         para3: DWORD): WINBOOL{.stdcall, dynlib: "gdi32",
      importc: "GetLogColorSpaceW".}
  proc CreateColorSpace*(para1: LPLOGCOLORSPACE): HCOLORSPACE{.stdcall,
      dynlib: "gdi32", importc: "CreateColorSpaceW".}
  proc GetICMProfile*(para1: HDC, para2: DWORD, para3: LPWSTR): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "GetICMProfileW".}
  proc SetICMProfile*(para1: HDC, para2: LPWSTR): WINBOOL{.stdcall,

      dynlib: "gdi32", importc: "SetICMProfileW".}
  proc UpdateICMRegKey*(para1: DWORD, para2: DWORD, para3: LPWSTR, para4: UINT): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "UpdateICMRegKeyW".}
  proc EnumICMProfiles*(para1: HDC, para2: ICMENUMPROC, para3: LPARAM): int32{.
      stdcall, dynlib: "gdi32", importc: "EnumICMProfilesW".}
  proc CreatePropertySheetPage*(lppsp: LPCPROPSHEETPAGE): HPROPSHEETPAGE{.
      stdcall, dynlib: "comctl32", importc: "CreatePropertySheetPageW".}
  proc PropertySheet*(lppsph: LPCPROPSHEETHEADER): int32{.stdcall,
      dynlib: "comctl32", importc: "PropertySheetW".}
  proc ImageList_LoadImage*(hi: HINST, lpbmp: LPCWSTR, cx: int32, cGrow: int32,
                            crMask: COLORREF, uType: UINT, uFlags: UINT): HIMAGELIST{.
      stdcall, dynlib: "comctl32", importc: "ImageList_LoadImageW".}
  proc CreateStatusWindow*(style: LONG, lpszText: LPCWSTR, hwndParent: HWND,
                           wID: UINT): HWND{.stdcall, dynlib: "comctl32",
      importc: "CreateStatusWindowW".}
  proc DrawStatusText*(hDC: HDC, lprc: LPRECT, pszText: LPCWSTR, uFlags: UINT){.
      stdcall, dynlib: "comctl32", importc: "DrawStatusTextW".}
  proc GetOpenFileName*(para1: LPOPENFILENAME): WINBOOL{.stdcall,
      dynlib: "comdlg32", importc: "GetOpenFileNameW".}
  proc GetSaveFileName*(para1: LPOPENFILENAME): WINBOOL{.stdcall,
      dynlib: "comdlg32", importc: "GetSaveFileNameW".}
  proc GetFileTitle*(para1: LPCWSTR, para2: LPWSTR, para3: int16): int{.stdcall,
      dynlib: "comdlg32", importc: "GetFileTitleW".}
  proc ChooseColor*(para1: LPCHOOSECOLOR): WINBOOL{.stdcall, dynlib: "comdlg32",
      importc: "ChooseColorW".}
  proc ReplaceText*(para1: LPFINDREPLACE): HWND{.stdcall, dynlib: "comdlg32",
      importc: "ReplaceTextW".}
  proc ChooseFont*(para1: LPCHOOSEFONT): WINBOOL{.stdcall, dynlib: "comdlg32",
      importc: "ChooseFontW".}
  proc FindText*(para1: LPFINDREPLACE): HWND{.stdcall, dynlib: "comdlg32",
      importc: "FindTextW".}
  proc PrintDlg*(para1: LPPRINTDLG): WINBOOL{.stdcall, dynlib: "comdlg32",
      importc: "PrintDlgW".}
  proc PageSetupDlg*(para1: LPPAGESETUPDLG): WINBOOL{.stdcall,
      dynlib: "comdlg32", importc: "PageSetupDlgW".}
  proc CreateProcess*(lpApplicationName: LPCWSTR, lpCommandLine: LPWSTR,
                      lpProcessAttributes: LPSECURITY_ATTRIBUTES,
                      lpThreadAttributes: LPSECURITY_ATTRIBUTES,
                      bInheritHandles: WINBOOL, dwCreationFlags: DWORD,
                      lpEnvironment: LPVOID, lpCurrentDirectory: LPCWSTR,
                      lpStartupInfo: LPSTARTUPINFO,
                      lpProcessInformation: LPPROCESS_INFORMATION): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "CreateProcessW".}
  proc GetStartupInfo*(lpStartupInfo: LPSTARTUPINFO){.stdcall,
      dynlib: "kernel32", importc: "GetStartupInfoW".}
  proc FindFirstFile*(lpFileName: LPCWSTR, lpFindFileData: LPWIN32_FIND_DATA): HANDLE{.
      stdcall, dynlib: "kernel32", importc: "FindFirstFileW".}
  proc FindNextFile*(hFindFile: HANDLE, lpFindFileData: LPWIN32_FIND_DATA): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "FindNextFileW".}
  proc GetVersionEx*(VersionInformation: LPOSVERSIONINFOW): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetVersionExW".}
  proc GetVersionExW*(VersionInformation: LPOSVERSIONINFOW): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetVersionExW".}
  proc CreateWindow*(lpClassName: LPCWSTR, lpWindowName: LPCWSTR,
                     dwStyle: DWORD, X: int32, Y: int32, nWidth: int32,
                     nHeight: int32, hWndParent: HWND, menu: HMENU,
                     hInstance: HINST, lpParam: LPVOID): HWND
  proc CreateDialog*(hInstance: HINST, lpName: LPCWSTR, hWndParent: HWND,
                     lpDialogFunc: DLGPROC): HWND
  proc CreateDialogIndirect*(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                             hWndParent: HWND, lpDialogFunc: DLGPROC): HWND
  proc DialogBox*(hInstance: HINST, lpTemplate: LPCWSTR, hWndParent: HWND,
                  lpDialogFunc: DLGPROC): int32
  proc DialogBoxIndirect*(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                          hWndParent: HWND, lpDialogFunc: DLGPROC): int32
  proc CreateDC*(para1: LPCWSTR, para2: LPCWSTR, para3: LPCWSTR, para4: pDEVMODE): HDC{.
      stdcall, dynlib: "gdi32", importc: "CreateDCW".}
  proc VerInstallFile*(uFlags: DWORD, szSrcFileName: LPWSTR,
                       szDestFileName: LPWSTR, szSrcDir: LPWSTR,
                       szDestDir: LPWSTR, szCurDir: LPWSTR, szTmpFile: LPWSTR,
                       lpuTmpFileLen: PUINT): DWORD{.stdcall, dynlib: "version",
      importc: "VerInstallFileW".}
  proc GetFileVersionInfoSize*(lptstrFilename: LPWSTR, lpdwHandle: LPDWORD): DWORD{.
      stdcall, dynlib: "version", importc: "GetFileVersionInfoSizeW".}
  proc GetFileVersionInfo*(lptstrFilename: LPWSTR, dwHandle: DWORD,
                           dwLen: DWORD, lpData: LPVOID): WINBOOL{.stdcall,
      dynlib: "version", importc: "GetFileVersionInfoW".}
  proc VerLanguageName*(wLang: DWORD, szLang: LPWSTR, nSize: DWORD): DWORD{.
      stdcall, dynlib: "kernel32", importc: "VerLanguageNameW".}
  proc VerQueryValue*(pBlock: LPVOID, lpSubBlock: LPWSTR, lplpBuffer: LPVOID,
                      puLen: PUINT): WINBOOL{.stdcall, dynlib: "version",
      importc: "VerQueryValueW".}
  proc VerFindFile*(uFlags: DWORD, szFileName: LPWSTR, szWinDir: LPWSTR,
                    szAppDir: LPWSTR, szCurDir: LPWSTR, lpuCurDirLen: PUINT,
                    szDestDir: LPWSTR, lpuDestDirLen: PUINT): DWORD{.stdcall,
      dynlib: "version", importc: "VerFindFileW".}
  proc RegSetValueEx*(key: HKEY, lpValueName: LPCWSTR, Reserved: DWORD,
                      dwType: DWORD, lpData: LPBYTE, cbData: DWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegSetValueExW".}
  proc RegUnLoadKey*(key: HKEY, lpSubKey: LPCWSTR): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegUnLoadKeyW".}
  proc InitiateSystemShutdown*(lpMachineName: LPWSTR, lpMessage: LPWSTR,
                               dwTimeout: DWORD, bForceAppsClosed: WINBOOL,
                               bRebootAfterShutdown: WINBOOL): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "InitiateSystemShutdownW".}
  proc AbortSystemShutdown*(lpMachineName: LPWSTR): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "AbortSystemShutdownW".}
  proc RegRestoreKey*(key: HKEY, lpFile: LPCWSTR, dwFlags: DWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegRestoreKeyW".}
  proc RegSaveKey*(key: HKEY, lpFile: LPCWSTR,
                   lpSecurityAttributes: LPSECURITY_ATTRIBUTES): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegSaveKeyW".}
  proc RegSetValue*(key: HKEY, lpSubKey: LPCWSTR, dwType: DWORD,
                    lpData: LPCWSTR, cbData: DWORD): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegSetValueW".}
  proc RegQueryValue*(key: HKEY, lpSubKey: LPCWSTR, lpValue: LPWSTR,
                      lpcbValue: PLONG): LONG{.stdcall, dynlib: "advapi32",
      importc: "RegQueryValueW".}
  proc RegQueryMultipleValues*(key: HKEY, val_list: PVALENT, num_vals: DWORD,
                               lpValueBuf: LPWSTR, ldwTotsize: LPDWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegQueryMultipleValuesW".}
  proc RegQueryValueEx*(key: HKEY, lpValueName: LPCWSTR, lpReserved: LPDWORD,
                        lpType: LPDWORD, lpData: LPBYTE, lpcbData: LPDWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegQueryValueExW".}
  proc RegReplaceKey*(key: HKEY, lpSubKey: LPCWSTR, lpNewFile: LPCWSTR,
                      lpOldFile: LPCWSTR): LONG{.stdcall, dynlib: "advapi32",
      importc: "RegReplaceKeyW".}
  proc RegConnectRegistry*(lpMachineName: LPWSTR, key: HKEY, phkResult: PHKEY): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegConnectRegistryW".}
  proc RegCreateKey*(key: HKEY, lpSubKey: LPCWSTR, phkResult: PHKEY): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegCreateKeyW".}
  proc RegCreateKeyEx*(key: HKEY, lpSubKey: LPCWSTR, Reserved: DWORD,
                       lpClass: LPWSTR, dwOptions: DWORD, samDesired: REGSAM,
                       lpSecurityAttributes: LPSECURITY_ATTRIBUTES,
                       phkResult: PHKEY, lpdwDisposition: LPDWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegCreateKeyExW".}
  proc RegDeleteKey*(key: HKEY, lpSubKey: LPCWSTR): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegDeleteKeyW".}
  proc RegDeleteValue*(key: HKEY, lpValueName: LPCWSTR): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegDeleteValueW".}
  proc RegEnumKey*(key: HKEY, dwIndex: DWORD, lpName: LPWSTR, cbName: DWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegEnumKeyW".}
  proc RegEnumKeyEx*(key: HKEY, dwIndex: DWORD, lpName: LPWSTR,
                     lpcbName: LPDWORD, lpReserved: LPDWORD, lpClass: LPWSTR,
                     lpcbClass: LPDWORD, lpftLastWriteTime: PFILETIME): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegEnumKeyExW".}
  proc RegEnumValue*(key: HKEY, dwIndex: DWORD, lpValueName: LPWSTR,
                     lpcbValueName: LPDWORD, lpReserved: LPDWORD,
                     lpType: LPDWORD, lpData: LPBYTE, lpcbData: LPDWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegEnumValueW".}
  proc RegLoadKey*(key: HKEY, lpSubKey: LPCWSTR, lpFile: LPCWSTR): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegLoadKeyW".}
  proc RegOpenKey*(key: HKEY, lpSubKey: LPCWSTR, phkResult: PHKEY): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegOpenKeyW".}
  proc RegOpenKeyEx*(key: HKEY, lpSubKey: LPCWSTR, ulOptions: DWORD,
                     samDesired: REGSAM, phkResult: PHKEY): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegOpenKeyExW".}
  proc RegQueryInfoKey*(key: HKEY, lpClass: LPWSTR, lpcbClass: LPDWORD,
                        lpReserved: LPDWORD, lpcSubKeys: LPDWORD,
                        lpcbMaxSubKeyLen: LPDWORD, lpcbMaxClassLen: LPDWORD,
                        lpcValues: LPDWORD, lpcbMaxValueNameLen: LPDWORD,
                        lpcbMaxValueLen: LPDWORD,
                        lpcbSecurityDescriptor: LPDWORD,
                        lpftLastWriteTime: PFILETIME): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegQueryInfoKeyW".}
  proc CompareString*(Locale: LCID, dwCmpFlags: DWORD, lpString1: LPCWSTR,
                      cchCount1: int32, lpString2: LPCWSTR, cchCount2: int32): int32{.
      stdcall, dynlib: "kernel32", importc: "CompareStringW".}
  proc LCMapString*(Locale: LCID, dwMapFlags: DWORD, lpSrcStr: LPCWSTR,
                    cchSrc: int32, lpDestStr: LPWSTR, cchDest: int32): int32{.
      stdcall, dynlib: "kernel32", importc: "LCMapStringW".}
  proc GetLocaleInfo*(Locale: LCID, LCType: LCTYPE, lpLCData: LPWSTR,
                      cchData: int32): int32{.stdcall, dynlib: "kernel32",
      importc: "GetLocaleInfoW".}
  proc SetLocaleInfo*(Locale: LCID, LCType: LCTYPE, lpLCData: LPCWSTR): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "SetLocaleInfoW".}
  proc GetTimeFormat*(Locale: LCID, dwFlags: DWORD, lpTime: LPSYSTEMTIME,
                      lpFormat: LPCWSTR, lpTimeStr: LPWSTR, cchTime: int32): int32{.
      stdcall, dynlib: "kernel32", importc: "GetTimeFormatW".}
  proc GetDateFormat*(Locale: LCID, dwFlags: DWORD, lpDate: LPSYSTEMTIME,
                      lpFormat: LPCWSTR, lpDateStr: LPWSTR, cchDate: int32): int32{.
      stdcall, dynlib: "kernel32", importc: "GetDateFormatW".}
  proc GetNumberFormat*(Locale: LCID, dwFlags: DWORD, lpValue: LPCWSTR,
                        lpFormat: PNUMBERFMT, lpNumberStr: LPWSTR,
                        cchNumber: int32): int32{.stdcall, dynlib: "kernel32",
      importc: "GetNumberFormatW".}
  proc GetCurrencyFormat*(Locale: LCID, dwFlags: DWORD, lpValue: LPCWSTR,
                          lpFormat: PCURRENCYFMT, lpCurrencyStr: LPWSTR,
                          cchCurrency: int32): int32{.stdcall,
      dynlib: "kernel32", importc: "GetCurrencyFormatW".}
  proc EnumCalendarInfo*(lpCalInfoEnumProc: CALINFO_ENUMPROC, Locale: LCID,
                         Calendar: CALID, CalType: CALTYPE): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "EnumCalendarInfoW".}
  proc EnumTimeFormats*(lpTimeFmtEnumProc: TIMEFMT_ENUMPROC, Locale: LCID,
                        dwFlags: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "EnumTimeFormatsW".}
  proc EnumDateFormats*(lpDateFmtEnumProc: DATEFMT_ENUMPROC, Locale: LCID,
                        dwFlags: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "EnumDateFormatsW".}
  proc GetStringTypeEx*(Locale: LCID, dwInfoType: DWORD, lpSrcStr: LPCWSTR,
                        cchSrc: int32, lpCharType: LPWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetStringTypeExW".}
  proc GetStringType*(dwInfoType: DWORD, lpSrcStr: LPCWSTR, cchSrc: int32,
                      lpCharType: LPWORD): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "GetStringTypeW".}
  proc FoldString*(dwMapFlags: DWORD, lpSrcStr: LPCWSTR, cchSrc: int32,
                   lpDestStr: LPWSTR, cchDest: int32): int32{.stdcall,
      dynlib: "kernel32", importc: "FoldStringW".}
  proc EnumSystemLocales*(lpLocaleEnumProc: LOCALE_ENUMPROC, dwFlags: DWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "EnumSystemLocalesW".}
  proc EnumSystemCodePages*(lpCodePageEnumProc: CODEPAGE_ENUMPROC,
                            dwFlags: DWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "EnumSystemCodePagesW".}
  proc PeekConsoleInput*(hConsoleInput: HANDLE, lpBuffer: PINPUTRECORD,
                         nLength: DWORD, lpNumberOfEventsRead: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "PeekConsoleInputW".}
  proc ReadConsoleInput*(hConsoleInput: HANDLE, lpBuffer: PINPUTRECORD,
                         nLength: DWORD, lpNumberOfEventsRead: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "ReadConsoleInputW".}
  proc WriteConsoleInput*(hConsoleInput: HANDLE, lpBuffer: PINPUTRECORD,
                          nLength: DWORD, lpNumberOfEventsWritten: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "WriteConsoleInputW".}
  proc ReadConsoleOutput*(hConsoleOutput: HANDLE, lpBuffer: PCHAR_INFO,
                          dwBufferSize: COORD, dwBufferCoord: COORD,
                          lpReadRegion: PSMALL_RECT): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "ReadConsoleOutputW".}
  proc WriteConsoleOutput*(hConsoleOutput: HANDLE, lpBuffer: PCHAR_INFO,
                           dwBufferSize: COORD, dwBufferCoord: COORD,
                           lpWriteRegion: PSMALL_RECT): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "WriteConsoleOutputW".}
  proc ReadConsoleOutputCharacter*(hConsoleOutput: HANDLE, lpCharacter: LPWSTR,
                                   nLength: DWORD, dwReadCoord: COORD,
                                   lpNumberOfCharsRead: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "ReadConsoleOutputCharacterW".}
  proc WriteConsoleOutputCharacter*(hConsoleOutput: HANDLE,
                                    lpCharacter: LPCWSTR, nLength: DWORD,
                                    dwWriteCoord: COORD,
                                    lpNumberOfCharsWritten: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "WriteConsoleOutputCharacterW".}
  proc FillConsoleOutputCharacter*(hConsoleOutput: HANDLE, cCharacter: WCHAR,
                                   nLength: DWORD, dwWriteCoord: COORD,
                                   lpNumberOfCharsWritten: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "FillConsoleOutputCharacterW".}
  proc ScrollConsoleScreenBuffer*(hConsoleOutput: HANDLE,
                                  lpScrollRectangle: PSMALL_RECT,
                                  lpClipRectangle: PSMALL_RECT,
                                  dwDestinationOrigin: COORD, lpFill: PCHAR_INFO): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "ScrollConsoleScreenBufferW".}
  proc GetConsoleTitle*(lpConsoleTitle: LPWSTR, nSize: DWORD): DWORD{.stdcall,
      dynlib: "kernel32", importc: "GetConsoleTitleW".}
  proc SetConsoleTitle*(lpConsoleTitle: LPCWSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "SetConsoleTitleW".}
  proc ReadConsole*(hConsoleInput: HANDLE, lpBuffer: LPVOID,
                    nNumberOfCharsToRead: DWORD, lpNumberOfCharsRead: LPDWORD,
                    lpReserved: LPVOID): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "ReadConsoleW".}
  proc WriteConsole*(hConsoleOutput: HANDLE, lpBuffer: pointer,
                     nNumberOfCharsToWrite: DWORD,
                     lpNumberOfCharsWritten: LPDWORD, lpReserved: LPVOID): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "WriteConsoleW".}
  proc WNetAddConnection*(lpRemoteName: LPCWSTR, lpPassword: LPCWSTR,
                          lpLocalName: LPCWSTR): DWORD{.stdcall, dynlib: "mpr",
      importc: "WNetAddConnectionW".}
  proc WNetAddConnection2*(lpNetResource: LPNETRESOURCE, lpPassword: LPCWSTR,
                           lpUserName: LPCWSTR, dwFlags: DWORD): DWORD{.stdcall,
      dynlib: "mpr", importc: "WNetAddConnection2W".}
  proc WNetAddConnection3*(hwndOwner: HWND, lpNetResource: LPNETRESOURCE,
                           lpPassword: LPCWSTR, lpUserName: LPCWSTR,
                           dwFlags: DWORD): DWORD{.stdcall, dynlib: "mpr",
      importc: "WNetAddConnection3W".}
  proc WNetCancelConnection*(lpName: LPCWSTR, fForce: WINBOOL): DWORD{.stdcall,
      dynlib: "mpr", importc: "WNetCancelConnectionW".}
  proc WNetCancelConnection2*(lpName: LPCWSTR, dwFlags: DWORD, fForce: WINBOOL): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetCancelConnection2W".}
  proc WNetGetConnection*(lpLocalName: LPCWSTR, lpRemoteName: LPWSTR,
                          lpnLength: LPDWORD): DWORD{.stdcall, dynlib: "mpr",
      importc: "WNetGetConnectionW".}
  proc WNetUseConnection*(hwndOwner: HWND, lpNetResource: LPNETRESOURCE,
                          lpUserID: LPCWSTR, lpPassword: LPCWSTR,
                          dwFlags: DWORD, lpAccessName: LPWSTR,
                          lpBufferSize: LPDWORD, lpResult: LPDWORD): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetUseConnectionW".}
  proc WNetSetConnection*(lpName: LPCWSTR, dwProperties: DWORD, pvValues: LPVOID): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetSetConnectionW".}
  proc WNetConnectionDialog1*(lpConnDlgStruct: LPCONNECTDLGSTRUCT): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetConnectionDialog1W".}
  proc WNetDisconnectDialog1*(lpConnDlgStruct: LPDISCDLGSTRUCT): DWORD{.stdcall,
      dynlib: "mpr", importc: "WNetDisconnectDialog1W".}
  proc WNetOpenEnum*(dwScope: DWORD, dwType: DWORD, dwUsage: DWORD,
                     lpNetResource: LPNETRESOURCE, lphEnum: LPHANDLE): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetOpenEnumW".}
  proc WNetEnumResource*(hEnum: HANDLE, lpcCount: LPDWORD, lpBuffer: LPVOID,
                         lpBufferSize: LPDWORD): DWORD{.stdcall, dynlib: "mpr",
      importc: "WNetEnumResourceW".}
  proc WNetGetUniversalName*(lpLocalPath: LPCWSTR, dwInfoLevel: DWORD,
                             lpBuffer: LPVOID, lpBufferSize: LPDWORD): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetGetUniversalNameW".}
  proc WNetGetUser*(lpName: LPCWSTR, lpUserName: LPWSTR, lpnLength: LPDWORD): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetGetUserW".}
  proc WNetGetProviderName*(dwNetType: DWORD, lpProviderName: LPWSTR,
                            lpBufferSize: LPDWORD): DWORD{.stdcall,
      dynlib: "mpr", importc: "WNetGetProviderNameW".}
  proc WNetGetNetworkInformation*(lpProvider: LPCWSTR,
                                  lpNetInfoStruct: LPNETINFOSTRUCT): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetGetNetworkInformationW".}
  proc WNetGetLastError*(lpError: LPDWORD, lpErrorBuf: LPWSTR,
                         nErrorBufSize: DWORD, lpNameBuf: LPWSTR,
                         nNameBufSize: DWORD): DWORD{.stdcall, dynlib: "mpr",
      importc: "WNetGetLastErrorW".}
  proc MultinetGetConnectionPerformance*(lpNetResource: LPNETRESOURCE,
      lpNetConnectInfoStruct: LPNETCONNECTINFOSTRUCT): DWORD{.stdcall,
      dynlib: "mpr", importc: "MultinetGetConnectionPerformanceW".}
  proc ChangeServiceConfig*(hService: SC_HANDLE, dwServiceType: DWORD,
                            dwStartType: DWORD, dwErrorControl: DWORD,
                            lpBinaryPathName: LPCWSTR,
                            lpLoadOrderGroup: LPCWSTR, lpdwTagId: LPDWORD,
                            lpDependencies: LPCWSTR,
                            lpServiceStartName: LPCWSTR, lpPassword: LPCWSTR,
                            lpDisplayName: LPCWSTR): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "ChangeServiceConfigW".}
  proc CreateService*(hSCManager: SC_HANDLE, lpServiceName: LPCWSTR,
                      lpDisplayName: LPCWSTR, dwDesiredAccess: DWORD,
                      dwServiceType: DWORD, dwStartType: DWORD,
                      dwErrorControl: DWORD, lpBinaryPathName: LPCWSTR,
                      lpLoadOrderGroup: LPCWSTR, lpdwTagId: LPDWORD,
                      lpDependencies: LPCWSTR, lpServiceStartName: LPCWSTR,
                      lpPassword: LPCWSTR): SC_HANDLE{.stdcall,
      dynlib: "advapi32", importc: "CreateServiceW".}
  proc EnumDependentServices*(hService: SC_HANDLE, dwServiceState: DWORD,
                              lpServices: LPENUM_SERVICE_STATUS,
                              cbBufSize: DWORD, pcbBytesNeeded: LPDWORD,
                              lpServicesReturned: LPDWORD): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "EnumDependentServicesW".}
  proc EnumServicesStatus*(hSCManager: SC_HANDLE, dwServiceType: DWORD,
                           dwServiceState: DWORD,
                           lpServices: LPENUM_SERVICE_STATUS, cbBufSize: DWORD,
                           pcbBytesNeeded: LPDWORD, lpServicesReturned: LPDWORD,
                           lpResumeHandle: LPDWORD): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "EnumServicesStatusW".}
  proc GetServiceKeyName*(hSCManager: SC_HANDLE, lpDisplayName: LPCWSTR,
                          lpServiceName: LPWSTR, lpcchBuffer: LPDWORD): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "GetServiceKeyNameW".}
  proc GetServiceDisplayName*(hSCManager: SC_HANDLE, lpServiceName: LPCWSTR,
                              lpDisplayName: LPWSTR, lpcchBuffer: LPDWORD): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "GetServiceDisplayNameW".}
  proc OpenSCManager*(lpMachineName: LPCWSTR, lpDatabaseName: LPCWSTR,
                      dwDesiredAccess: DWORD): SC_HANDLE{.stdcall,
      dynlib: "advapi32", importc: "OpenSCManagerW".}
  proc OpenService*(hSCManager: SC_HANDLE, lpServiceName: LPCWSTR,
                    dwDesiredAccess: DWORD): SC_HANDLE{.stdcall,
      dynlib: "advapi32", importc: "OpenServiceW".}
  proc QueryServiceConfig*(hService: SC_HANDLE,
                           lpServiceConfig: LPQUERY_SERVICE_CONFIG,
                           cbBufSize: DWORD, pcbBytesNeeded: LPDWORD): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "QueryServiceConfigW".}
  proc QueryServiceLockStatus*(hSCManager: SC_HANDLE,
                               lpLockStatus: LPQUERY_SERVICE_LOCK_STATUS,
                               cbBufSize: DWORD, pcbBytesNeeded: LPDWORD): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "QueryServiceLockStatusW".}
  proc RegisterServiceCtrlHandler*(lpServiceName: LPCWSTR,
                                   lpHandlerProc: LPHANDLER_FUNCTION): SERVICE_STATUS_HANDLE{.
      stdcall, dynlib: "advapi32", importc: "RegisterServiceCtrlHandlerW".}
  proc StartServiceCtrlDispatcher*(lpServiceStartTable: LPSERVICE_TABLE_ENTRY): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "StartServiceCtrlDispatcherW".}
  proc StartService*(hService: SC_HANDLE, dwNumServiceArgs: DWORD,
                     lpServiceArgVectors: LPCWSTR): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "StartServiceW".}
  proc DragQueryFile*(para1: HDROP, para2: int, para3: LPCWSTR, para4: int): int{.
      stdcall, dynlib: "shell32", importc: "DragQueryFileW".}
  proc ExtractAssociatedIcon*(para1: HINST, para2: LPCWSTR, para3: LPWORD): HICON{.
      stdcall, dynlib: "shell32", importc: "ExtractAssociatedIconW".}
  proc ExtractIcon*(para1: HINST, para2: LPCWSTR, para3: int): HICON{.stdcall,
      dynlib: "shell32", importc: "ExtractIconW".}
  proc FindExecutable*(para1: LPCWSTR, para2: LPCWSTR, para3: LPCWSTR): HINST{.
      stdcall, dynlib: "shell32", importc: "FindExecutableW".}
  proc ShellAbout*(para1: HWND, para2: LPCWSTR, para3: LPCWSTR, para4: HICON): int32{.
      stdcall, dynlib: "shell32", importc: "ShellAboutW".}
  proc ShellExecute*(para1: HWND, para2: LPCWSTR, para3: LPCWSTR,
                     para4: LPCWSTR, para5: LPCWSTR, para6: int32): HINST{.
      stdcall, dynlib: "shell32", importc: "ShellExecuteW".}
  proc Shell_NotifyIcon*(dwMessage: DWORD, lpData: PNotifyIconDataA): WINBOOL{.
      stdcall, dynlib: "shell32", importc: "Shell_NotifyIconW".}
  proc DdeCreateStringHandle*(para1: DWORD, para2: LPCWSTR, para3: int32): HSZ{.
      stdcall, dynlib: "user32", importc: "DdeCreateStringHandleW".}
  proc DdeInitialize*(para1: LPDWORD, para2: PFNCALLBACK, para3: DWORD,
                      para4: DWORD): UINT{.stdcall, dynlib: "user32",
      importc: "DdeInitializeW".}
  proc DdeQueryString*(para1: DWORD, para2: HSZ, para3: LPCWSTR, para4: DWORD,
                       para5: int32): DWORD{.stdcall, dynlib: "user32",
      importc: "DdeQueryStringW".}
  proc LogonUser*(para1: LPWSTR, para2: LPWSTR, para3: LPWSTR, para4: DWORD,
                  para5: DWORD, para6: PHANDLE): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "LogonUserW".}
  proc CreateProcessAsUser*(para1: HANDLE, para2: LPCWSTR, para3: LPWSTR,
                            para4: LPSECURITY_ATTRIBUTES,
                            para5: LPSECURITY_ATTRIBUTES, para6: WINBOOL,
                            para7: DWORD, para8: LPVOID, para9: LPCWSTR,
                            para10: LPSTARTUPINFO, para11: LPPROCESS_INFORMATION): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "CreateProcessAsUserW".}
else:
  proc GetBinaryType*(lpApplicationName: LPCSTR, lpBinaryType: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "GetBinaryTypeA".}
  proc GetShortPathName*(lpszLongPath: LPCSTR, lpszShortPath: LPSTR,
                         cchBuffer: DWORD): DWORD{.stdcall, dynlib: "kernel32",
      importc: "GetShortPathNameA".}
  proc GetEnvironmentStrings*(): LPSTR{.stdcall, dynlib: "kernel32",
                                        importc: "GetEnvironmentStringsA".}
  proc FreeEnvironmentStrings*(para1: LPSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "FreeEnvironmentStringsA".}
  proc FormatMessage*(dwFlags: DWORD, lpSource: LPCVOID, dwMessageId: DWORD,
                      dwLanguageId: DWORD, lpBuffer: LPSTR, nSize: DWORD,
                      Arguments: va_list): DWORD{.stdcall, dynlib: "kernel32",
      importc: "FormatMessageA".}
  proc CreateMailslot*(lpName: LPCSTR, nMaxMessageSize: DWORD,
                       lReadTimeout: DWORD,
                       lpSecurityAttributes: LPSECURITY_ATTRIBUTES): HANDLE{.
      stdcall, dynlib: "kernel32", importc: "CreateMailslotA".}
  proc lstrcmp*(lpString1: LPCSTR, lpString2: LPCSTR): int32{.stdcall,
      dynlib: "kernel32", importc: "lstrcmpA".}
  proc lstrcmpi*(lpString1: LPCSTR, lpString2: LPCSTR): int32{.stdcall,
      dynlib: "kernel32", importc: "lstrcmpiA".}
  proc lstrcpyn*(lpString1: LPSTR, lpString2: LPCSTR, iMaxLength: int32): LPSTR{.
      stdcall, dynlib: "kernel32", importc: "lstrcpynA".}
  proc lstrcpy*(lpString1: LPSTR, lpString2: LPCSTR): LPSTR{.stdcall,
      dynlib: "kernel32", importc: "lstrcpyA".}
  proc lstrcat*(lpString1: LPSTR, lpString2: LPCSTR): LPSTR{.stdcall,
      dynlib: "kernel32", importc: "lstrcatA".}
  proc lstrlen*(lpString: LPCSTR): int32{.stdcall, dynlib: "kernel32",
      importc: "lstrlenA".}
  proc CreateMutex*(lpMutexAttributes: LPSECURITY_ATTRIBUTES,
                    bInitialOwner: WINBOOL, lpName: LPCSTR): HANDLE{.stdcall,
      dynlib: "kernel32", importc: "CreateMutexA".}
  proc OpenMutex*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                  lpName: LPCSTR): HANDLE{.stdcall, dynlib: "kernel32",
      importc: "OpenMutexA".}
  proc CreateEvent*(lpEventAttributes: LPSECURITY_ATTRIBUTES,
                    bManualReset: WINBOOL, bInitialState: WINBOOL,
                    lpName: LPCSTR): HANDLE{.stdcall, dynlib: "kernel32",
      importc: "CreateEventA".}
  proc OpenEvent*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                  lpName: LPCSTR): HANDLE{.stdcall, dynlib: "kernel32",
      importc: "OpenEventA".}
  proc CreateSemaphore*(lpSemaphoreAttributes: LPSECURITY_ATTRIBUTES,
                        lInitialCount: LONG, lMaximumCount: LONG, lpName: LPCSTR): HANDLE{.
      stdcall, dynlib: "kernel32", importc: "CreateSemaphoreA".}
  proc OpenSemaphore*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                      lpName: LPCSTR): HANDLE{.stdcall, dynlib: "kernel32",
      importc: "OpenSemaphoreA".}
  proc CreateFileMapping*(hFile: HANDLE,
                          lpFileMappingAttributes: LPSECURITY_ATTRIBUTES,
                          flProtect: DWORD, dwMaximumSizeHigh: DWORD,
                          dwMaximumSizeLow: DWORD, lpName: LPCSTR): HANDLE{.
      stdcall, dynlib: "kernel32", importc: "CreateFileMappingA".}
  proc OpenFileMapping*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                        lpName: LPCSTR): HANDLE{.stdcall, dynlib: "kernel32",
      importc: "OpenFileMappingA".}
  proc GetLogicalDriveStrings*(nBufferLength: DWORD, lpBuffer: LPSTR): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetLogicalDriveStringsA".}
  proc LoadLibrary*(lpLibFileName: LPCSTR): HINST{.stdcall, dynlib: "kernel32",
      importc: "LoadLibraryA".}
  proc LoadLibraryEx*(lpLibFileName: LPCSTR, hFile: HANDLE, dwFlags: DWORD): HINST{.
      stdcall, dynlib: "kernel32", importc: "LoadLibraryExA".}
  proc GetModuleFileName*(hModule: HINST, lpFilename: LPSTR, nSize: DWORD): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetModuleFileNameA".}
  proc GetModuleHandle*(lpModuleName: LPCSTR): HMODULE{.stdcall,
      dynlib: "kernel32", importc: "GetModuleHandleA".}
  proc FatalAppExit*(uAction: UINT, lpMessageText: LPCSTR){.stdcall,
      dynlib: "kernel32", importc: "FatalAppExitA".}
  proc GetCommandLine*(): LPSTR{.stdcall, dynlib: "kernel32",
                                 importc: "GetCommandLineA".}
  proc GetEnvironmentVariable*(lpName: LPCSTR, lpBuffer: LPSTR, nSize: DWORD): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetEnvironmentVariableA".}
  proc SetEnvironmentVariable*(lpName: LPCSTR, lpValue: LPCSTR): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "SetEnvironmentVariableA".}
  proc ExpandEnvironmentStrings*(lpSrc: LPCSTR, lpDst: LPSTR, nSize: DWORD): DWORD{.
      stdcall, dynlib: "kernel32", importc: "ExpandEnvironmentStringsA".}
  proc OutputDebugString*(lpOutputString: LPCSTR){.stdcall, dynlib: "kernel32",
      importc: "OutputDebugStringA".}
  proc FindResource*(hModule: HINST, lpName: LPCSTR, lpType: LPCSTR): HRSRC{.
      stdcall, dynlib: "kernel32", importc: "FindResourceA".}
  proc FindResourceEx*(hModule: HINST, lpType: LPCSTR, lpName: LPCSTR,
                       wLanguage: int16): HRSRC{.stdcall, dynlib: "kernel32",
      importc: "FindResourceExA".}
  proc EnumResourceTypes*(hModule: HINST, lpEnumFunc: ENUMRESTYPEPROC,
                          lParam: LONG): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "EnumResourceTypesA".}
  proc EnumResourceNames*(hModule: HINST, lpType: LPCSTR,
                          lpEnumFunc: ENUMRESNAMEPROC, lParam: LONG): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "EnumResourceNamesA".}
  proc EnumResourceLanguages*(hModule: HINST, lpType: LPCSTR, lpName: LPCSTR,
                              lpEnumFunc: ENUMRESLANGPROC, lParam: LONG): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "EnumResourceLanguagesA".}
  proc BeginUpdateResource*(pFileName: LPCSTR, bDeleteExistingResources: WINBOOL): HANDLE{.
      stdcall, dynlib: "kernel32", importc: "BeginUpdateResourceA".}
  proc UpdateResource*(hUpdate: HANDLE, lpType: LPCSTR, lpName: LPCSTR,
                       wLanguage: int16, lpData: LPVOID, cbData: DWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "UpdateResourceA".}
  proc EndUpdateResource*(hUpdate: HANDLE, fDiscard: WINBOOL): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "EndUpdateResourceA".}
  proc GlobalAddAtom*(lpString: LPCSTR): ATOM{.stdcall, dynlib: "kernel32",
      importc: "GlobalAddAtomA".}
  proc GlobalFindAtom*(lpString: LPCSTR): ATOM{.stdcall, dynlib: "kernel32",
      importc: "GlobalFindAtomA".}
  proc GlobalGetAtomName*(nAtom: ATOM, lpBuffer: LPSTR, nSize: int32): UINT{.
      stdcall, dynlib: "kernel32", importc: "GlobalGetAtomNameA".}
  proc AddAtom*(lpString: LPCSTR): ATOM{.stdcall, dynlib: "kernel32",
      importc: "AddAtomA".}
  proc FindAtom*(lpString: LPCSTR): ATOM{.stdcall, dynlib: "kernel32",
      importc: "FindAtomA".}
  proc GetAtomName*(nAtom: ATOM, lpBuffer: LPSTR, nSize: int32): UINT{.stdcall,
      dynlib: "kernel32", importc: "GetAtomNameA".}
  proc GetProfileInt*(lpAppName: LPCSTR, lpKeyName: LPCSTR, nDefault: WINT): UINT{.
      stdcall, dynlib: "kernel32", importc: "GetProfileIntA".}
  proc GetProfileString*(lpAppName: LPCSTR, lpKeyName: LPCSTR,
                         lpDefault: LPCSTR, lpReturnedString: LPSTR,
                         nSize: DWORD): DWORD{.stdcall, dynlib: "kernel32",
      importc: "GetProfileStringA".}
  proc WriteProfileString*(lpAppName: LPCSTR, lpKeyName: LPCSTR,
                           lpString: LPCSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "WriteProfileStringA".}
  proc GetProfileSection*(lpAppName: LPCSTR, lpReturnedString: LPSTR,
                          nSize: DWORD): DWORD{.stdcall, dynlib: "kernel32",
      importc: "GetProfileSectionA".}
  proc WriteProfileSection*(lpAppName: LPCSTR, lpString: LPCSTR): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "WriteProfileSectionA".}
  proc GetPrivateProfileInt*(lpAppName: LPCSTR, lpKeyName: LPCSTR,
                             nDefault: WINT, lpFileName: LPCSTR): UINT{.stdcall,
      dynlib: "kernel32", importc: "GetPrivateProfileIntA".}
  proc GetPrivateProfileString*(lpAppName: LPCSTR, lpKeyName: LPCSTR,
                                lpDefault: LPCSTR, lpReturnedString: LPSTR,
                                nSize: DWORD, lpFileName: LPCSTR): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetPrivateProfileStringA".}
  proc WritePrivateProfileString*(lpAppName: LPCSTR, lpKeyName: LPCSTR,
                                  lpString: LPCSTR, lpFileName: LPCSTR): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "WritePrivateProfileStringA".}
  proc GetPrivateProfileSection*(lpAppName: LPCSTR, lpReturnedString: LPSTR,
                                 nSize: DWORD, lpFileName: LPCSTR): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetPrivateProfileSectionA".}
  proc WritePrivateProfileSection*(lpAppName: LPCSTR, lpString: LPCSTR,
                                   lpFileName: LPCSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "WritePrivateProfileSectionA".}
  proc GetDriveType*(lpRootPathName: LPCSTR): UINT{.stdcall, dynlib: "kernel32",
      importc: "GetDriveTypeA".}
  proc GetSystemDirectory*(lpBuffer: LPSTR, uSize: UINT): UINT{.stdcall,
      dynlib: "kernel32", importc: "GetSystemDirectoryA".}
  proc GetTempPath*(nBufferLength: DWORD, lpBuffer: LPSTR): DWORD{.stdcall,
      dynlib: "kernel32", importc: "GetTempPathA".}
  proc GetTempFileName*(lpPathName: LPCSTR, lpPrefixString: LPCSTR,
                        uUnique: UINT, lpTempFileName: LPSTR): UINT{.stdcall,
      dynlib: "kernel32", importc: "GetTempFileNameA".}
  proc GetWindowsDirectory*(lpBuffer: LPSTR, uSize: UINT): UINT{.stdcall,
      dynlib: "kernel32", importc: "GetWindowsDirectoryA".}
  proc SetCurrentDirectory*(lpPathName: LPCSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "SetCurrentDirectoryA".}
  proc GetCurrentDirectory*(nBufferLength: DWORD, lpBuffer: LPSTR): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetCurrentDirectoryA".}
  proc GetDiskFreeSpace*(lpRootPathName: LPCSTR, lpSectorsPerCluster: LPDWORD,
                         lpBytesPerSector: LPDWORD,
                         lpNumberOfFreeClusters: LPDWORD,
                         lpTotalNumberOfClusters: LPDWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetDiskFreeSpaceA".}
  proc CreateDirectory*(lpPathName: LPCSTR,
                        lpSecurityAttributes: LPSECURITY_ATTRIBUTES): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "CreateDirectoryA".}
  proc CreateDirectoryEx*(lpTemplateDirectory: LPCSTR, lpNewDirectory: LPCSTR,
                          lpSecurityAttributes: LPSECURITY_ATTRIBUTES): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "CreateDirectoryExA".}
  proc RemoveDirectory*(lpPathName: LPCSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "RemoveDirectoryA".}
  proc GetFullPathName*(lpFileName: LPCSTR, nBufferLength: DWORD,
                        lpBuffer: LPSTR, lpFilePart: var LPSTR): DWORD{.stdcall,
      dynlib: "kernel32", importc: "GetFullPathNameA".}
  proc DefineDosDevice*(dwFlags: DWORD, lpDeviceName: LPCSTR,
                        lpTargetPath: LPCSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "DefineDosDeviceA".}
  proc QueryDosDevice*(lpDeviceName: LPCSTR, lpTargetPath: LPSTR, ucchMax: DWORD): DWORD{.
      stdcall, dynlib: "kernel32", importc: "QueryDosDeviceA".}
  proc CreateFile*(lpFileName: LPCSTR, dwDesiredAccess: DWORD,
                   dwShareMode: DWORD,
                   lpSecurityAttributes: LPSECURITY_ATTRIBUTES,
                   dwCreationDisposition: DWORD, dwFlagsAndAttributes: DWORD,
                   hTemplateFile: HANDLE): HANDLE{.stdcall, dynlib: "kernel32",
      importc: "CreateFileA".}
  proc SetFileAttributes*(lpFileName: LPCSTR, dwFileAttributes: DWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "SetFileAttributesA".}
  proc GetFileAttributes*(lpFileName: LPCSTR): DWORD{.stdcall,
      dynlib: "kernel32", importc: "GetFileAttributesA".}
  proc GetCompressedFileSize*(lpFileName: LPCSTR, lpFileSizeHigh: LPDWORD): DWORD{.
      stdcall, dynlib: "kernel32", importc: "GetCompressedFileSizeA".}
  proc DeleteFile*(lpFileName: LPCSTR): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "DeleteFileA".}
  proc SearchPath*(lpPath: LPCSTR, lpFileName: LPCSTR, lpExtension: LPCSTR,
                   nBufferLength: DWORD, lpBuffer: LPSTR, lpFilePart: LPSTR): DWORD{.
      stdcall, dynlib: "kernel32", importc: "SearchPathA".}
  proc CopyFile*(lpExistingFileName: LPCSTR, lpNewFileName: LPCSTR,
                 bFailIfExists: WINBOOL): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "CopyFileA".}
  proc MoveFile*(lpExistingFileName: LPCSTR, lpNewFileName: LPCSTR): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "MoveFileA".}
  proc MoveFileEx*(lpExistingFileName: LPCSTR, lpNewFileName: LPCSTR,
                   dwFlags: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "MoveFileExA".}
  proc CreateNamedPipe*(lpName: LPCSTR, dwOpenMode: DWORD, dwPipeMode: DWORD,
                        nMaxInstances: DWORD, nOutBufferSize: DWORD,
                        nInBufferSize: DWORD, nDefaultTimeOut: DWORD,
                        lpSecurityAttributes: LPSECURITY_ATTRIBUTES): HANDLE{.
      stdcall, dynlib: "kernel32", importc: "CreateNamedPipeA".}
  proc GetNamedPipeHandleState*(hNamedPipe: HANDLE, lpState: LPDWORD,
                                lpCurInstances: LPDWORD,
                                lpMaxCollectionCount: LPDWORD,
                                lpCollectDataTimeout: LPDWORD,
                                lpUserName: LPSTR, nMaxUserNameSize: DWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "GetNamedPipeHandleStateA".}
  proc CallNamedPipe*(lpNamedPipeName: LPCSTR, lpInBuffer: LPVOID,
                      nInBufferSize: DWORD, lpOutBuffer: LPVOID,
                      nOutBufferSize: DWORD, lpBytesRead: LPDWORD,
                      nTimeOut: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "CallNamedPipeA".}
  proc WaitNamedPipe*(lpNamedPipeName: LPCSTR, nTimeOut: DWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "WaitNamedPipeA".}
  proc SetVolumeLabel*(lpRootPathName: LPCSTR, lpVolumeName: LPCSTR): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "SetVolumeLabelA".}
  proc GetVolumeInformation*(lpRootPathName: LPCSTR, lpVolumeNameBuffer: LPSTR,
                             nVolumeNameSize: DWORD,
                             lpVolumeSerialNumber: LPDWORD,
                             lpMaximumComponentLength: LPDWORD,
                             lpFileSystemFlags: LPDWORD,
                             lpFileSystemNameBuffer: LPSTR,
                             nFileSystemNameSize: DWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetVolumeInformationA".}
  proc ClearEventLog*(hEventLog: HANDLE, lpBackupFileName: LPCSTR): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "ClearEventLogA".}
  proc BackupEventLog*(hEventLog: HANDLE, lpBackupFileName: LPCSTR): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "BackupEventLogA".}
  proc OpenEventLog*(lpUNCServerName: LPCSTR, lpSourceName: LPCSTR): HANDLE{.
      stdcall, dynlib: "advapi32", importc: "OpenEventLogA".}
  proc RegisterEventSource*(lpUNCServerName: LPCSTR, lpSourceName: LPCSTR): HANDLE{.
      stdcall, dynlib: "advapi32", importc: "RegisterEventSourceA".}
  proc OpenBackupEventLog*(lpUNCServerName: LPCSTR, lpFileName: LPCSTR): HANDLE{.
      stdcall, dynlib: "advapi32", importc: "OpenBackupEventLogA".}
  proc ReadEventLog*(hEventLog: HANDLE, dwReadFlags: DWORD,
                     dwRecordOffset: DWORD, lpBuffer: LPVOID,
                     nNumberOfBytesToRead: DWORD, pnBytesRead: LPDWORD,
                     pnMinNumberOfBytesNeeded: LPDWORD): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "ReadEventLogA".}
  proc ReportEvent*(hEventLog: HANDLE, wType: int16, wCategory: int16,
                    dwEventID: DWORD, lpUserSid: PSID, wNumStrings: int16,
                    dwDataSize: DWORD, lpStrings: LPPCSTR, lpRawData: LPVOID): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "ReportEventA".}
  proc AccessCheckAndAuditAlarm*(SubsystemName: LPCSTR, HandleId: LPVOID,
                                 ObjectTypeName: LPSTR, ObjectName: LPSTR,
                                 SecurityDescriptor: PSECURITY_DESCRIPTOR,
                                 DesiredAccess: DWORD,
                                 GenericMapping: PGENERIC_MAPPING,
                                 ObjectCreation: WINBOOL,
                                 GrantedAccess: LPDWORD, AccessStatus: LPBOOL,
                                 pfGenerateOnClose: LPBOOL): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "AccessCheckAndAuditAlarmA".}
  proc ObjectOpenAuditAlarm*(SubsystemName: LPCSTR, HandleId: LPVOID,
                             ObjectTypeName: LPSTR, ObjectName: LPSTR,
                             pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                             ClientToken: HANDLE, DesiredAccess: DWORD,
                             GrantedAccess: DWORD, Privileges: PPRIVILEGE_SET,
                             ObjectCreation: WINBOOL, AccessGranted: WINBOOL,
                             GenerateOnClose: LPBOOL): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "ObjectOpenAuditAlarmA".}
  proc ObjectPrivilegeAuditAlarm*(SubsystemName: LPCSTR, HandleId: LPVOID,
                                  ClientToken: HANDLE, DesiredAccess: DWORD,
                                  Privileges: PPRIVILEGE_SET,
                                  AccessGranted: WINBOOL): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "ObjectPrivilegeAuditAlarmA".}
  proc ObjectCloseAuditAlarm*(SubsystemName: LPCSTR, HandleId: LPVOID,
                              GenerateOnClose: WINBOOL): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "ObjectCloseAuditAlarmA".}
  proc PrivilegedServiceAuditAlarm*(SubsystemName: LPCSTR, ServiceName: LPCSTR,
                                    ClientToken: HANDLE,
                                    Privileges: PPRIVILEGE_SET,
                                    AccessGranted: WINBOOL): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "PrivilegedServiceAuditAlarmA".}
  proc SetFileSecurity*(lpFileName: LPCSTR,
                        SecurityInformation: SECURITY_INFORMATION,
                        pSecurityDescriptor: PSECURITY_DESCRIPTOR): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "SetFileSecurityA".}
  proc GetFileSecurity*(lpFileName: LPCSTR,
                        RequestedInformation: SECURITY_INFORMATION,
                        pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                        nLength: DWORD, lpnLengthNeeded: LPDWORD): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "GetFileSecurityA".}
  proc FindFirstChangeNotification*(lpPathName: LPCSTR, bWatchSubtree: WINBOOL,
                                    dwNotifyFilter: DWORD): HANDLE{.stdcall,
      dynlib: "kernel32", importc: "FindFirstChangeNotificationA".}
  proc IsBadStringPtr*(lpsz: LPCSTR, ucchMax: UINT): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "IsBadStringPtrA".}
  proc LookupAccountSid*(lpSystemName: LPCSTR, Sid: PSID, Name: LPSTR,
                         cbName: LPDWORD, ReferencedDomainName: LPSTR,
                         cbReferencedDomainName: LPDWORD, peUse: PSID_NAME_USE): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "LookupAccountSidA".}
  proc LookupAccountName*(lpSystemName: LPCSTR, lpAccountName: LPCSTR,
                          Sid: PSID, cbSid: LPDWORD,
                          ReferencedDomainName: LPSTR,
                          cbReferencedDomainName: LPDWORD, peUse: PSID_NAME_USE): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "LookupAccountNameA".}
  proc LookupPrivilegeValue*(lpSystemName: LPCSTR, lpName: LPCSTR, lpLuid: PLUID): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "LookupPrivilegeValueA".}
  proc LookupPrivilegeName*(lpSystemName: LPCSTR, lpLuid: PLUID, lpName: LPSTR,
                            cbName: LPDWORD): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "LookupPrivilegeNameA".}
  proc LookupPrivilegeDisplayName*(lpSystemName: LPCSTR, lpName: LPCSTR,
                                   lpDisplayName: LPSTR, cbDisplayName: LPDWORD,
                                   lpLanguageId: LPDWORD): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "LookupPrivilegeDisplayNameA".}
  proc BuildCommDCB*(lpDef: LPCSTR, lpDCB: LPDCB): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "BuildCommDCBA".}
  proc BuildCommDCBAndTimeouts*(lpDef: LPCSTR, lpDCB: LPDCB,
                                lpCommTimeouts: LPCOMMTIMEOUTS): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "BuildCommDCBAndTimeoutsA".}
  proc CommConfigDialog*(lpszName: LPCSTR, wnd: HWND, lpCC: LPCOMMCONFIG): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "CommConfigDialogA".}
  proc GetDefaultCommConfig*(lpszName: LPCSTR, lpCC: LPCOMMCONFIG,
                             lpdwSize: LPDWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetDefaultCommConfigA".}
  proc SetDefaultCommConfig*(lpszName: LPCSTR, lpCC: LPCOMMCONFIG, dwSize: DWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "SetDefaultCommConfigA".}
  proc GetComputerName*(lpBuffer: LPSTR, nSize: LPDWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetComputerNameA".}
  proc SetComputerName*(lpComputerName: LPCSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "SetComputerNameA".}
  proc GetUserName*(lpBuffer: LPSTR, nSize: LPDWORD): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "GetUserNameA".}
  proc wvsprintf*(para1: LPSTR, para2: LPCSTR, arglist: va_list): int32{.
      stdcall, dynlib: "user32", importc: "wvsprintfA".}
  proc LoadKeyboardLayout*(pwszKLID: LPCSTR, Flags: UINT): HKL{.stdcall,
      dynlib: "user32", importc: "LoadKeyboardLayoutA".}
  proc GetKeyboardLayoutName*(pwszKLID: LPSTR): WINBOOL{.stdcall,
      dynlib: "user32", importc: "GetKeyboardLayoutNameA".}
  proc CreateDesktop*(lpszDesktop: LPSTR, lpszDevice: LPSTR,
                      pDevmode: LPDEVMODE, dwFlags: DWORD,
                      dwDesiredAccess: DWORD, lpsa: LPSECURITY_ATTRIBUTES): HDESK{.
      stdcall, dynlib: "user32", importc: "CreateDesktopA".}
  proc OpenDesktop*(lpszDesktop: LPSTR, dwFlags: DWORD, fInherit: WINBOOL,
                    dwDesiredAccess: DWORD): HDESK{.stdcall, dynlib: "user32",
      importc: "OpenDesktopA".}
  proc EnumDesktops*(hwinsta: HWINSTA, lpEnumFunc: DESKTOPENUMPROC,
                     lp: LPARAM): WINBOOL{.stdcall, dynlib: "user32",
      importc: "EnumDesktopsA".}
  proc CreateWindowStation*(lpwinsta: LPSTR, dwReserved: DWORD,
                            dwDesiredAccess: DWORD, lpsa: LPSECURITY_ATTRIBUTES): HWINSTA{.
      stdcall, dynlib: "user32", importc: "CreateWindowStationA".}
  proc OpenWindowStation*(lpszWinSta: LPSTR, fInherit: WINBOOL,
                          dwDesiredAccess: DWORD): HWINSTA{.stdcall,
      dynlib: "user32", importc: "OpenWindowStationA".}
  proc EnumWindowStations*(lpEnumFunc: ENUMWINDOWSTATIONPROC, lp: LPARAM): WINBOOL{.
      stdcall, dynlib: "user32", importc: "EnumWindowStationsA".}
  proc GetUserObjectInformation*(hObj: HANDLE, nIndex: int32, pvInfo: PVOID,
                                 nLength: DWORD, lpnLengthNeeded: LPDWORD): WINBOOL{.
      stdcall, dynlib: "user32", importc: "GetUserObjectInformationA".}
  proc SetUserObjectInformation*(hObj: HANDLE, nIndex: int32, pvInfo: PVOID,
                                 nLength: DWORD): WINBOOL{.stdcall,
      dynlib: "user32", importc: "SetUserObjectInformationA".}
  proc RegisterWindowMessage*(lpString: LPCSTR): UINT{.stdcall,
      dynlib: "user32", importc: "RegisterWindowMessageA".}
  proc GetMessage*(lpMsg: LPMSG, wnd: HWND, wMsgFilterMin: UINT,
                   wMsgFilterMax: UINT): WINBOOL{.stdcall, dynlib: "user32",
      importc: "GetMessageA".}
  proc DispatchMessage*(lpMsg: LPMSG): LONG{.stdcall, dynlib: "user32",
      importc: "DispatchMessageA".}
  proc PeekMessage*(lpMsg: LPMSG, wnd: HWND, wMsgFilterMin: UINT,
                    wMsgFilterMax: UINT, wRemoveMsg: UINT): WINBOOL{.stdcall,
      dynlib: "user32", importc: "PeekMessageA".}
  proc SendMessage*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
      stdcall, dynlib: "user32", importc: "SendMessageA".}
  proc SendMessageTimeout*(wnd: HWND, Msg: UINT, wp: WPARAM,
                           lp: LPARAM, fuFlags: UINT, uTimeout: UINT,
                           lpdwResult: LPDWORD): LRESULT{.stdcall,
      dynlib: "user32", importc: "SendMessageTimeoutA".}
  proc SendNotifyMessage*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): WINBOOL{.
      stdcall, dynlib: "user32", importc: "SendNotifyMessageA".}
  proc SendMessageCallback*(wnd: HWND, Msg: UINT, wp: WPARAM,
                            lp: LPARAM, lpResultCallBack: SENDASYNCPROC,
                            dwData: DWORD): WINBOOL{.stdcall, dynlib: "user32",
      importc: "SendMessageCallbackA".}
  proc PostMessage*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): WINBOOL{.
      stdcall, dynlib: "user32", importc: "PostMessageA".}
  proc PostThreadMessage*(idThread: DWORD, Msg: UINT, wp: WPARAM,
                          lp: LPARAM): WINBOOL{.stdcall, dynlib: "user32",
      importc: "PostThreadMessageA".}
  proc DefWindowProc*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
      stdcall, dynlib: "user32", importc: "DefWindowProcA".}
  proc CallWindowProc*(lpPrevWndFunc: WNDPROC, wnd: HWND, Msg: UINT,
                       wp: WPARAM, lp: LPARAM): LRESULT{.stdcall,
      dynlib: "user32", importc: "CallWindowProcA".}
  proc RegisterClass*(lpWndClass: LPWNDCLASS): ATOM{.stdcall, dynlib: "user32",
      importc: "RegisterClassA".}
  proc UnregisterClass*(lpClassName: LPCSTR, hInstance: HINST): WINBOOL{.
      stdcall, dynlib: "user32", importc: "UnregisterClassA".}
  proc GetClassInfo*(hInstance: HINST, lpClassName: LPCSTR,
                     lpWndClass: LPWNDCLASS): WINBOOL{.stdcall,
      dynlib: "user32", importc: "GetClassInfoA".}
  proc RegisterClassEx*(para1: LPWNDCLASSEX): ATOM{.stdcall, dynlib: "user32",
      importc: "RegisterClassExA".}
  proc GetClassInfoEx*(para1: HINST, para2: LPCSTR, para3: LPWNDCLASSEX): WINBOOL{.
      stdcall, dynlib: "user32", importc: "GetClassInfoExA".}
  proc CreateWindowEx*(dwExStyle: DWORD, lpClassName: LPCSTR,
                       lpWindowName: LPCSTR, dwStyle: DWORD, X: int32, Y: int32,
                       nWidth: int32, nHeight: int32, hWndParent: HWND,
                       menu: HMENU, hInstance: HINST, lpParam: LPVOID): HWND{.
      stdcall, dynlib: "user32", importc: "CreateWindowExA".}
  proc CreateDialogParam*(hInstance: HINST, lpTemplateName: LPCSTR,
                          hWndParent: HWND, lpDialogFunc: DLGPROC,
                          dwInitParam: LPARAM): HWND{.stdcall, dynlib: "user32",
      importc: "CreateDialogParamA".}
  proc CreateDialogIndirectParam*(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,

                                  hWndParent: HWND, lpDialogFunc: DLGPROC,
                                  dwInitParam: LPARAM): HWND{.stdcall,
      dynlib: "user32", importc: "CreateDialogIndirectParamA".}
  proc DialogBoxParam*(hInstance: HINST, lpTemplateName: LPCSTR,
                       hWndParent: HWND, lpDialogFunc: DLGPROC,
                       dwInitParam: LPARAM): int32{.stdcall, dynlib: "user32",
      importc: "DialogBoxParamA".}
  proc DialogBoxIndirectParam*(hInstance: HINST,
                               hDialogTemplate: LPCDLGTEMPLATE,
                               hWndParent: HWND, lpDialogFunc: DLGPROC,
                               dwInitParam: LPARAM): int32{.stdcall,
      dynlib: "user32", importc: "DialogBoxIndirectParamA".}
  proc SetDlgItemText*(hDlg: HWND, nIDDlgItem: int32, lpString: LPCSTR): WINBOOL{.
      stdcall, dynlib: "user32", importc: "SetDlgItemTextA".}
  proc GetDlgItemText*(hDlg: HWND, nIDDlgItem: int32, lpString: LPSTR,
                       nMaxCount: int32): UINT{.stdcall, dynlib: "user32",
      importc: "GetDlgItemTextA".}
  proc SendDlgItemMessage*(hDlg: HWND, nIDDlgItem: int32, Msg: UINT,
                           wp: WPARAM, lp: LPARAM): LONG{.stdcall,
      dynlib: "user32", importc: "SendDlgItemMessageA".}
  proc DefDlgProc*(hDlg: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
      stdcall, dynlib: "user32", importc: "DefDlgProcA".}
  proc CallMsgFilter*(lpMsg: LPMSG, nCode: int32): WINBOOL{.stdcall,
      dynlib: "user32", importc: "CallMsgFilterA".}
  proc RegisterClipboardFormat*(lpszFormat: LPCSTR): UINT{.stdcall,
      dynlib: "user32", importc: "RegisterClipboardFormatA".}
  proc GetClipboardFormatName*(format: UINT, lpszFormatName: LPSTR,
                               cchMaxCount: int32): int32{.stdcall,
      dynlib: "user32", importc: "GetClipboardFormatNameA".}
  proc CharToOem*(lpszSrc: LPCSTR, lpszDst: LPSTR): WINBOOL{.stdcall,
      dynlib: "user32", importc: "CharToOemA".}
  proc OemToChar*(lpszSrc: LPCSTR, lpszDst: LPSTR): WINBOOL{.stdcall,
      dynlib: "user32", importc: "OemToCharA".}
  proc CharToOemBuff*(lpszSrc: LPCSTR, lpszDst: LPSTR, cchDstLength: DWORD): WINBOOL{.
      stdcall, dynlib: "user32", importc: "CharToOemBuffA".}
  proc OemToCharBuff*(lpszSrc: LPCSTR, lpszDst: LPSTR, cchDstLength: DWORD): WINBOOL{.
      stdcall, dynlib: "user32", importc: "OemToCharBuffA".}
  proc CharUpper*(lpsz: LPSTR): LPSTR{.stdcall, dynlib: "user32",
                                       importc: "CharUpperA".}
  proc CharUpperBuff*(lpsz: LPSTR, cchLength: DWORD): DWORD{.stdcall,
      dynlib: "user32", importc: "CharUpperBuffA".}
  proc CharLower*(lpsz: LPSTR): LPSTR{.stdcall, dynlib: "user32",
                                       importc: "CharLowerA".}
  proc CharLowerBuff*(lpsz: LPSTR, cchLength: DWORD): DWORD{.stdcall,
      dynlib: "user32", importc: "CharLowerBuffA".}
  proc CharNext*(lpsz: LPCSTR): LPSTR{.stdcall, dynlib: "user32",
                                       importc: "CharNextA".}
  proc CharPrev*(lpszStart: LPCSTR, lpszCurrent: LPCSTR): LPSTR{.stdcall,
      dynlib: "user32", importc: "CharPrevA".}
  proc IsCharAlpha*(ch: CHAR): WINBOOL{.stdcall, dynlib: "user32",
                                        importc: "IsCharAlphaA".}
  proc IsCharAlphaNumeric*(ch: CHAR): WINBOOL{.stdcall, dynlib: "user32",
      importc: "IsCharAlphaNumericA".}
  proc IsCharUpper*(ch: CHAR): WINBOOL{.stdcall, dynlib: "user32",
                                        importc: "IsCharUpperA".}
  proc IsCharLower*(ch: CHAR): WINBOOL{.stdcall, dynlib: "user32",
                                        importc: "IsCharLowerA".}
  proc GetKeyNameText*(lParam: LONG, lpString: LPSTR, nSize: int32): int32{.
      stdcall, dynlib: "user32", importc: "GetKeyNameTextA".}
  proc VkKeyScan*(ch: CHAR): SHORT{.stdcall, dynlib: "user32",
                                    importc: "VkKeyScanA".}
  proc VkKeyScanEx*(ch: CHAR, dwhkl: HKL): SHORT{.stdcall, dynlib: "user32",
      importc: "VkKeyScanExA".}
  proc MapVirtualKey*(uCode: UINT, uMapType: UINT): UINT{.stdcall,
      dynlib: "user32", importc: "MapVirtualKeyA".}
  proc MapVirtualKeyEx*(uCode: UINT, uMapType: UINT, dwhkl: HKL): UINT{.stdcall,
      dynlib: "user32", importc: "MapVirtualKeyExA".}
  proc LoadAccelerators*(hInstance: HINST, lpTableName: LPCSTR): HACCEL{.
      stdcall, dynlib: "user32", importc: "LoadAcceleratorsA".}
  proc CreateAcceleratorTable*(para1: LPACCEL, para2: int32): HACCEL{.stdcall,
      dynlib: "user32", importc: "CreateAcceleratorTableA".}
  proc CopyAcceleratorTable*(hAccelSrc: HACCEL, lpAccelDst: LPACCEL,
                             cAccelEntries: int32): int32{.stdcall,
      dynlib: "user32", importc: "CopyAcceleratorTableA".}
  proc TranslateAccelerator*(wnd: HWND, hAccTable: HACCEL, lpMsg: LPMSG): int32{.
      stdcall, dynlib: "user32", importc: "TranslateAcceleratorA".}
  proc LoadMenu*(hInstance: HINST, lpMenuName: LPCSTR): HMENU{.stdcall,
      dynlib: "user32", importc: "LoadMenuA".}
  proc LoadMenuIndirect*(lpMenuTemplate: LPMENUTEMPLATE): HMENU{.stdcall,
      dynlib: "user32", importc: "LoadMenuIndirectA".}
  proc ChangeMenu*(menu: HMENU, cmd: UINT, lpszNewItem: LPCSTR,
                   cmdInsert: UINT, flags: UINT): WINBOOL{.stdcall,
      dynlib: "user32", importc: "ChangeMenuA".}
  proc GetMenuString*(menu: HMENU, uIDItem: UINT, lpString: LPSTR,
                      nMaxCount: int32, uFlag: UINT): int32{.stdcall,
      dynlib: "user32", importc: "GetMenuStringA".}
  proc InsertMenu*(menu: HMENU, uPosition: UINT, uFlags: UINT,
                   uIDNewItem: UINT, lpNewItem: LPCSTR): WINBOOL{.stdcall,
      dynlib: "user32", importc: "InsertMenuA".}
  proc AppendMenu*(menu: HMENU, uFlags: UINT, uIDNewItem: UINT,
                   lpNewItem: LPCSTR): WINBOOL{.stdcall, dynlib: "user32",
      importc: "AppendMenuA".}
  proc ModifyMenu*(hMnu: HMENU, uPosition: UINT, uFlags: UINT, uIDNewItem: UINT,
                   lpNewItem: LPCSTR): WINBOOL{.stdcall, dynlib: "user32",
      importc: "ModifyMenuA".}
  proc InsertMenuItem*(para1: HMENU, para2: UINT, para3: WINBOOL,
                       para4: LPCMENUITEMINFO): WINBOOL{.stdcall,
      dynlib: "user32", importc: "InsertMenuItemA".}
  proc GetMenuItemInfo*(para1: HMENU, para2: UINT, para3: WINBOOL,
                        para4: LPMENUITEMINFO): WINBOOL{.stdcall,
      dynlib: "user32", importc: "GetMenuItemInfoA".}
  proc SetMenuItemInfo*(para1: HMENU, para2: UINT, para3: WINBOOL,
                        para4: LPCMENUITEMINFO): WINBOOL{.stdcall,
      dynlib: "user32", importc: "SetMenuItemInfoA".}
  proc DrawText*(hDC: HDC, lpString: LPCSTR, nCount: int32, lpRect: LPRECT,
                 uFormat: UINT): int32{.stdcall, dynlib: "user32",
                                        importc: "DrawTextA".}
  proc DrawTextEx*(para1: HDC, para2: LPSTR, para3: int32, para4: LPRECT,
                   para5: UINT, para6: LPDRAWTEXTPARAMS): int32{.stdcall,
      dynlib: "user32", importc: "DrawTextExA".}
  proc GrayString*(hDC: HDC, hBrush: HBRUSH, lpOutputFunc: GRAYSTRINGPROC,
                   lpData: LPARAM, nCount: int32, X: int32, Y: int32,
                   nWidth: int32, nHeight: int32): WINBOOL{.stdcall,
      dynlib: "user32", importc: "GrayStringA".}
  proc DrawState*(para1: HDC, para2: HBRUSH, para3: DRAWSTATEPROC,
                  para4: LPARAM, para5: WPARAM, para6: int32, para7: int32,
                  para8: int32, para9: int32, para10: UINT): WINBOOL{.stdcall,
      dynlib: "user32", importc: "DrawStateA".}
  proc TabbedTextOut*(dc: HDC, X: int32, Y: int32, lpString: LPCSTR,
                      nCount: int32, nTabPositions: int32,
                      lpnTabStopPositions: LPINT, nTabOrigin: int32): LONG{.
      stdcall, dynlib: "user32", importc: "TabbedTextOutA".}
  proc GetTabbedTextExtent*(hDC: HDC, lpString: LPCSTR, nCount: int32,
                            nTabPositions: int32, lpnTabStopPositions: LPINT): DWORD{.
      stdcall, dynlib: "user32", importc: "GetTabbedTextExtentA".}
  proc SetProp*(wnd: HWND, lpString: LPCSTR, hData: HANDLE): WINBOOL{.stdcall,
      dynlib: "user32", importc: "SetPropA".}
  proc GetProp*(wnd: HWND, lpString: LPCSTR): HANDLE{.stdcall,
      dynlib: "user32", importc: "GetPropA".}
  proc RemoveProp*(wnd: HWND, lpString: LPCSTR): HANDLE{.stdcall,
      dynlib: "user32", importc: "RemovePropA".}
  proc EnumPropsEx*(wnd: HWND, lpEnumFunc: PROPENUMPROCEX, lp: LPARAM): int32{.
      stdcall, dynlib: "user32", importc: "EnumPropsExA".}
  proc EnumProps*(wnd: HWND, lpEnumFunc: PROPENUMPROC): int32{.stdcall,
      dynlib: "user32", importc: "EnumPropsA".}
  proc SetWindowText*(wnd: HWND, lpString: LPCSTR): WINBOOL{.stdcall,
      dynlib: "user32", importc: "SetWindowTextA".}
  proc GetWindowText*(wnd: HWND, lpString: LPSTR, nMaxCount: int32): int32{.
      stdcall, dynlib: "user32", importc: "GetWindowTextA".}
  proc GetWindowTextLength*(wnd: HWND): int32{.stdcall, dynlib: "user32",
      importc: "GetWindowTextLengthA".}
  proc MessageBox*(wnd: HWND, lpText: LPCSTR, lpCaption: LPCSTR, uType: UINT): int32{.
      stdcall, dynlib: "user32", importc: "MessageBoxA".}
  proc MessageBoxEx*(wnd: HWND, lpText: LPCSTR, lpCaption: LPCSTR, uType: UINT,
                     wLanguageId: int16): int32{.stdcall, dynlib: "user32",
      importc: "MessageBoxExA".}
  proc MessageBoxIndirect*(para1: LPMSGBOXPARAMS): int32{.stdcall,
      dynlib: "user32", importc: "MessageBoxIndirectA".}
  proc GetWindowLong*(wnd: HWND, nIndex: int32): LONG{.stdcall,
      dynlib: "user32", importc: "GetWindowLongA".}
  proc SetWindowLong*(wnd: HWND, nIndex: int32, dwNewLong: LONG): LONG{.
      stdcall, dynlib: "user32", importc: "SetWindowLongA".}
  proc GetClassLong*(wnd: HWND, nIndex: int32): DWORD{.stdcall,
      dynlib: "user32", importc: "GetClassLongA".}
  proc SetClassLong*(wnd: HWND, nIndex: int32, dwNewLong: LONG): DWORD{.
      stdcall, dynlib: "user32", importc: "SetClassLongA".}
  when defined(cpu64):
    proc GetWindowLongPtr*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
        dynlib: "user32", importc: "GetWindowLongPtrA".}
    proc SetWindowLongPtr*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
        stdcall, dynlib: "user32", importc: "SetWindowLongPtrA".}
    proc GetClassLongPtr*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
        dynlib: "user32", importc: "GetClassLongPtrA".}
    proc SetClassLongPtr*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
        stdcall, dynlib: "user32", importc: "SetClassLongPtrA".}
  else:
    proc GetWindowLongPtr*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
        dynlib: "user32", importc: "GetWindowLongA".}
    proc SetWindowLongPtr*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
        stdcall, dynlib: "user32", importc: "SetWindowLongA".}
    proc GetClassLongPtr*(wnd: HWND, nIndex: int32): LONG_PTR{.stdcall,
        dynlib: "user32", importc: "GetClassLongA".}
    proc SetClassLongPtr*(wnd: HWND, nIndex: int32, dwNewLong: LONG_PTR): LONG_PTR{.
        stdcall, dynlib: "user32", importc: "SetClassLongA".}
  proc FindWindow*(lpClassName: LPCSTR, lpWindowName: LPCSTR): HWND{.stdcall,
      dynlib: "user32", importc: "FindWindowA".}
  proc FindWindowEx*(para1: HWND, para2: HWND, para3: LPCSTR, para4: LPCSTR): HWND{.
      stdcall, dynlib: "user32", importc: "FindWindowExA".}
  proc GetClassName*(wnd: HWND, lpClassName: LPSTR, nMaxCount: int32): int32{.
      stdcall, dynlib: "user32", importc: "GetClassNameA".}
  proc SetWindowsHookEx*(idHook: int32, lpfn: HOOKPROC, hmod: HINST,
                         dwThreadId: DWORD): HHOOK{.stdcall, dynlib: "user32",
      importc: "SetWindowsHookExA".}
  proc LoadBitmap*(hInstance: HINST, lpBitmapName: LPCSTR): HBITMAP{.stdcall,
      dynlib: "user32", importc: "LoadBitmapA".}
  proc LoadCursor*(hInstance: HINST, lpCursorName: LPCSTR): HCURSOR{.stdcall,
      dynlib: "user32", importc: "LoadCursorA".}
  proc LoadCursorFromFile*(lpFileName: LPCSTR): HCURSOR{.stdcall,
      dynlib: "user32", importc: "LoadCursorFromFileA".}
  proc LoadIcon*(hInstance: HINST, lpIconName: LPCSTR): HICON{.stdcall,
      dynlib: "user32", importc: "LoadIconA".}
  proc LoadImage*(para1: HINST, para2: LPCSTR, para3: UINT, para4: int32,
                  para5: int32, para6: UINT): HANDLE{.stdcall, dynlib: "user32",
      importc: "LoadImageA".}
  proc LoadString*(hInstance: HINST, uID: UINT, lpBuffer: LPSTR,
                   nBufferMax: int32): int32{.stdcall, dynlib: "user32",
      importc: "LoadStringA".}
  proc IsDialogMessage*(hDlg: HWND, lpMsg: LPMSG): WINBOOL{.stdcall,
      dynlib: "user32", importc: "IsDialogMessageA".}
  proc DlgDirList*(hDlg: HWND, lpPathSpec: LPSTR, nIDListBox: int32,
                   nIDStaticPath: int32, uFileType: UINT): int32{.stdcall,
      dynlib: "user32", importc: "DlgDirListA".}
  proc DlgDirSelectEx*(hDlg: HWND, lpString: LPSTR, nCount: int32,
                       nIDListBox: int32): WINBOOL{.stdcall, dynlib: "user32",
      importc: "DlgDirSelectExA".}
  proc DlgDirListComboBox*(hDlg: HWND, lpPathSpec: LPSTR, nIDComboBox: int32,
                           nIDStaticPath: int32, uFiletype: UINT): int32{.
      stdcall, dynlib: "user32", importc: "DlgDirListComboBoxA".}
  proc DlgDirSelectComboBoxEx*(hDlg: HWND, lpString: LPSTR, nCount: int32,
                               nIDComboBox: int32): WINBOOL{.stdcall,
      dynlib: "user32", importc: "DlgDirSelectComboBoxExA".}
  proc DefFrameProc*(wnd: HWND, hWndMDIClient: HWND, uMsg: UINT,
                     wp: WPARAM, lp: LPARAM): LRESULT{.stdcall,
      dynlib: "user32", importc: "DefFrameProcA".}
  proc DefMDIChildProc*(wnd: HWND, uMsg: UINT, wp: WPARAM, lp: LPARAM): LRESULT{.
      stdcall, dynlib: "user32", importc: "DefMDIChildProcA".}
  proc CreateMDIWindow*(lpClassName: LPSTR, lpWindowName: LPSTR, dwStyle: DWORD,
                        X: int32, Y: int32, nWidth: int32, nHeight: int32,
                        hWndParent: HWND, hInstance: HINST, lp: LPARAM): HWND{.
      stdcall, dynlib: "user32", importc: "CreateMDIWindowA".}
  proc WinHelp*(hWndMain: HWND, lpszHelp: LPCSTR, uCommand: UINT, dwData: DWORD): WINBOOL{.
      stdcall, dynlib: "user32", importc: "WinHelpA".}
  proc ChangeDisplaySettings*(lpDevMode: LPDEVMODE, dwFlags: DWORD): LONG{.
      stdcall, dynlib: "user32", importc: "ChangeDisplaySettingsA".}
  proc EnumDisplaySettings*(lpszDeviceName: LPCSTR, iModeNum: DWORD,
                            lpDevMode: LPDEVMODE): WINBOOL{.stdcall,
      dynlib: "user32", importc: "EnumDisplaySettingsA".}
  proc SystemParametersInfo*(uiAction: UINT, uiParam: UINT, pvParam: PVOID,
                             fWinIni: UINT): WINBOOL{.stdcall, dynlib: "user32",
      importc: "SystemParametersInfoA".}
  proc AddFontResource*(para1: LPCSTR): int32{.stdcall, dynlib: "gdi32",
      importc: "AddFontResourceA".}
  proc CopyMetaFile*(para1: HMETAFILE, para2: LPCSTR): HMETAFILE{.stdcall,
      dynlib: "gdi32", importc: "CopyMetaFileA".}
  proc CreateFont*(para1: int32, para2: int32, para3: int32, para4: int32,
                   para5: int32, para6: DWORD, para7: DWORD, para8: DWORD,
                   para9: DWORD, para10: DWORD, para11: DWORD, para12: DWORD,
                   para13: DWORD, para14: LPCSTR): HFONT{.stdcall,
      dynlib: "gdi32", importc: "CreateFontA".}
  proc CreateFontIndirect*(para1: LPLOGFONT): HFONT{.stdcall, dynlib: "gdi32",
      importc: "CreateFontIndirectA".}
  proc CreateFontIndirect*(para1: var LOGFONT): HFONT{.stdcall, dynlib: "gdi32",
      importc: "CreateFontIndirectA".}
  proc CreateIC*(para1: LPCSTR, para2: LPCSTR, para3: LPCSTR, para4: LPDEVMODE): HDC{.
      stdcall, dynlib: "gdi32", importc: "CreateICA".}
  proc CreateMetaFile*(para1: LPCSTR): HDC{.stdcall, dynlib: "gdi32",
      importc: "CreateMetaFileA".}
  proc CreateScalableFontResource*(para1: DWORD, para2: LPCSTR, para3: LPCSTR,
                                   para4: LPCSTR): WINBOOL{.stdcall,
      dynlib: "gdi32", importc: "CreateScalableFontResourceA".}
  proc EnumFontFamiliesEx*(para1: HDC, para2: LPLOGFONT, para3: FONTENUMEXPROC,
                           para4: LPARAM, para5: DWORD): int32{.stdcall,
      dynlib: "gdi32", importc: "EnumFontFamiliesExA".}
  proc EnumFontFamilies*(para1: HDC, para2: LPCSTR, para3: FONTENUMPROC,
                         para4: LPARAM): int32{.stdcall, dynlib: "gdi32",
      importc: "EnumFontFamiliesA".}
  proc EnumFonts*(para1: HDC, para2: LPCSTR, para3: ENUMFONTSPROC, para4: LPARAM): int32{.
      stdcall, dynlib: "gdi32", importc: "EnumFontsA".}
  proc EnumFonts*(para1: HDC, para2: LPCSTR, para3: ENUMFONTSPROC,
                  para4: pointer): int32{.stdcall, dynlib: "gdi32",
      importc: "EnumFontsA".}
  proc GetCharWidth*(para1: HDC, para2: UINT, para3: UINT, para4: LPINT): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "GetCharWidthA".}
  proc GetCharWidth32*(para1: HDC, para2: UINT, para3: UINT, para4: LPINT): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "GetCharWidth32A".}
  proc GetCharWidthFloat*(para1: HDC, para2: UINT, para3: UINT, para4: ptr float32): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "GetCharWidthFloatA".}
  proc GetCharABCWidths*(para1: HDC, para2: UINT, para3: UINT, para4: LPABC): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "GetCharABCWidthsA".}
  proc GetCharABCWidthsFloat*(para1: HDC, para2: UINT, para3: UINT,
                              para4: LPABCFLOAT): WINBOOL{.stdcall,
      dynlib: "gdi32", importc: "GetCharABCWidthsFloatA".}
  proc GetGlyphOutline*(para1: HDC, para2: UINT, para3: UINT,
                        para4: LPGLYPHMETRICS, para5: DWORD, para6: LPVOID,
                        para7: PMAT2): DWORD{.stdcall, dynlib: "gdi32",
      importc: "GetGlyphOutlineA".}
  proc GetMetaFile*(para1: LPCSTR): HMETAFILE{.stdcall, dynlib: "gdi32",
      importc: "GetMetaFileA".}
  proc GetOutlineTextMetrics*(para1: HDC, para2: UINT,
                              para3: LPOUTLINETEXTMETRIC): UINT{.stdcall,
      dynlib: "gdi32", importc: "GetOutlineTextMetricsA".}
  proc GetTextExtentPoint*(para1: HDC, para2: LPCSTR, para3: int32,
                           para4: LPSIZE): WINBOOL{.stdcall, dynlib: "gdi32",
      importc: "GetTextExtentPointA".}
  proc GetTextExtentPoint32*(para1: HDC, para2: LPCSTR, para3: int32,
                             para4: LPSIZE): WINBOOL{.stdcall, dynlib: "gdi32",
      importc: "GetTextExtentPoint32A".}
  proc GetTextExtentExPoint*(para1: HDC, para2: LPCSTR, para3: int32,
                             para4: int32, para5: LPINT, para6: LPINT,
                             para7: LPSIZE): WINBOOL{.stdcall, dynlib: "gdi32",
      importc: "GetTextExtentExPointA".}
  proc GetCharacterPlacement*(para1: HDC, para2: LPCSTR, para3: int32,
                              para4: int32, para5: LPGCP_RESULTS, para6: DWORD): DWORD{.
      stdcall, dynlib: "gdi32", importc: "GetCharacterPlacementA".}
  proc ResetDC*(para1: HDC, para2: LPDEVMODE): HDC{.stdcall, dynlib: "gdi32",
      importc: "ResetDCA".}
  proc RemoveFontResource*(para1: LPCSTR): WINBOOL{.stdcall, dynlib: "gdi32",
      importc: "RemoveFontResourceA".}
  proc CopyEnhMetaFile*(para1: HENHMETAFILE, para2: LPCSTR): HENHMETAFILE{.
      stdcall, dynlib: "gdi32", importc: "CopyEnhMetaFileA".}
  proc CreateEnhMetaFile*(para1: HDC, para2: LPCSTR, para3: LPRECT,
                          para4: LPCSTR): HDC{.stdcall, dynlib: "gdi32",
      importc: "CreateEnhMetaFileA".}
  proc GetEnhMetaFile*(para1: LPCSTR): HENHMETAFILE{.stdcall, dynlib: "gdi32",
      importc: "GetEnhMetaFileA".}
  proc GetEnhMetaFileDescription*(para1: HENHMETAFILE, para2: UINT, para3: LPSTR): UINT{.
      stdcall, dynlib: "gdi32", importc: "GetEnhMetaFileDescriptionA".}
  proc GetTextMetrics*(para1: HDC, para2: LPTEXTMETRIC): WINBOOL{.stdcall,
      dynlib: "gdi32", importc: "GetTextMetricsA".}
  proc StartDoc*(para1: HDC, para2: PDOCINFO): int32{.stdcall, dynlib: "gdi32",
      importc: "StartDocA".}
  proc GetObject*(para1: HGDIOBJ, para2: int32, para3: LPVOID): int32{.stdcall,
      dynlib: "gdi32", importc: "GetObjectA".}
  proc TextOut*(para1: HDC, para2: int32, para3: int32, para4: LPCSTR,
                para5: int32): WINBOOL{.stdcall, dynlib: "gdi32",
                                        importc: "TextOutA".}
  proc ExtTextOut*(para1: HDC, para2: int32, para3: int32, para4: UINT,
                   para5: LPRECT, para6: LPCSTR, para7: UINT, para8: LPINT): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "ExtTextOutA".}
  proc PolyTextOut*(para1: HDC, para2: PPOLYTEXT, para3: int32): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "PolyTextOutA".}
  proc GetTextFace*(para1: HDC, para2: int32, para3: LPSTR): int32{.stdcall,
      dynlib: "gdi32", importc: "GetTextFaceA".}
  proc GetKerningPairs*(para1: HDC, para2: DWORD, para3: LPKERNINGPAIR): DWORD{.
      stdcall, dynlib: "gdi32", importc: "GetKerningPairsA".}
  proc CreateColorSpace*(para1: LPLOGCOLORSPACE): HCOLORSPACE{.stdcall,
      dynlib: "gdi32", importc: "CreateColorSpaceA".}
  proc GetLogColorSpace*(para1: HCOLORSPACE, para2: LPLOGCOLORSPACE,
                         para3: DWORD): WINBOOL{.stdcall, dynlib: "gdi32",
      importc: "GetLogColorSpaceA".}
  proc GetICMProfile*(para1: HDC, para2: DWORD, para3: LPSTR): WINBOOL{.stdcall,
      dynlib: "gdi32", importc: "GetICMProfileA".}
  proc SetICMProfile*(para1: HDC, para2: LPSTR): WINBOOL{.stdcall,
      dynlib: "gdi32", importc: "SetICMProfileA".}
  proc UpdateICMRegKey*(para1: DWORD, para2: DWORD, para3: LPSTR, para4: UINT): WINBOOL{.
      stdcall, dynlib: "gdi32", importc: "UpdateICMRegKeyA".}
  proc EnumICMProfiles*(para1: HDC, para2: ICMENUMPROC, para3: LPARAM): int32{.
      stdcall, dynlib: "gdi32", importc: "EnumICMProfilesA".}
  proc PropertySheet*(lppsph: LPCPROPSHEETHEADER): int32{.stdcall,
      dynlib: "comctl32", importc: "PropertySheetA".}
  proc ImageList_LoadImage*(hi: HINST, lpbmp: LPCSTR, cx: int32, cGrow: int32,
                            crMask: COLORREF, uType: UINT, uFlags: UINT): HIMAGELIST{.
      stdcall, dynlib: "comctl32", importc: "ImageList_LoadImageA".}
  proc CreateStatusWindow*(style: LONG, lpszText: LPCSTR, hwndParent: HWND,
                           wID: UINT): HWND{.stdcall, dynlib: "comctl32",
      importc: "CreateStatusWindowA".}
  proc DrawStatusText*(hDC: HDC, lprc: LPRECT, pszText: LPCSTR, uFlags: UINT){.
      stdcall, dynlib: "comctl32", importc: "DrawStatusTextA".}
  proc GetOpenFileName*(para1: LPOPENFILENAME): WINBOOL{.stdcall,
      dynlib: "comdlg32", importc: "GetOpenFileNameA".}
  proc GetSaveFileName*(para1: LPOPENFILENAME): WINBOOL{.stdcall,
      dynlib: "comdlg32", importc: "GetSaveFileNameA".}
  proc GetFileTitle*(para1: LPCSTR, para2: LPSTR, para3: int16): int{.stdcall,
      dynlib: "comdlg32", importc: "GetFileTitleA".}
  proc ChooseColor*(para1: LPCHOOSECOLOR): WINBOOL{.stdcall, dynlib: "comdlg32",
      importc: "ChooseColorA".}
  proc FindText*(para1: LPFINDREPLACE): HWND{.stdcall, dynlib: "comdlg32",
      importc: "FindTextA".}
  proc ReplaceText*(para1: LPFINDREPLACE): HWND{.stdcall, dynlib: "comdlg32",
      importc: "ReplaceTextA".}
  proc ChooseFont*(para1: LPCHOOSEFONT): WINBOOL{.stdcall, dynlib: "comdlg32",
      importc: "ChooseFontA".}
  proc PrintDlg*(para1: LPPRINTDLG): WINBOOL{.stdcall, dynlib: "comdlg32",
      importc: "PrintDlgA".}
  proc PageSetupDlg*(para1: LPPAGESETUPDLG): WINBOOL{.stdcall,
      dynlib: "comdlg32", importc: "PageSetupDlgA".}
  proc CreateProcess*(lpApplicationName: LPCSTR, lpCommandLine: LPSTR,
                      lpProcessAttributes: LPSECURITY_ATTRIBUTES,
                      lpThreadAttributes: LPSECURITY_ATTRIBUTES,
                      bInheritHandles: WINBOOL, dwCreationFlags: DWORD,
                      lpEnvironment: LPVOID, lpCurrentDirectory: LPCSTR,
                      lpStartupInfo: LPSTARTUPINFO,
                      lpProcessInformation: LPPROCESS_INFORMATION): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "CreateProcessA".}
  proc GetStartupInfo*(lpStartupInfo: LPSTARTUPINFO){.stdcall,
      dynlib: "kernel32", importc: "GetStartupInfoA".}
  proc FindFirstFile*(lpFileName: LPCSTR, lpFindFileData: LPWIN32_FIND_DATA): HANDLE{.
      stdcall, dynlib: "kernel32", importc: "FindFirstFileA".}
  proc FindNextFile*(hFindFile: HANDLE, lpFindFileData: LPWIN32_FIND_DATA): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "FindNextFileA".}
  proc GetVersionEx*(VersionInformation: LPOSVERSIONINFO): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetVersionExA".}
  proc CreateWindow*(lpClassName: LPCSTR, lpWindowName: LPCSTR, dwStyle: DWORD,
                     X: int32, Y: int32, nWidth: int32, nHeight: int32,
                     hWndParent: HWND, menu: HMENU, hInstance: HINST,
                     lpParam: LPVOID): HWND
  proc CreateDialog*(hInstance: HINST, lpTemplateName: LPCSTR, hWndParent: HWND,
                     lpDialogFunc: DLGPROC): HWND
  proc CreateDialogIndirect*(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                             hWndParent: HWND, lpDialogFunc: DLGPROC): HWND
  proc DialogBox*(hInstance: HINST, lpTemplateName: LPCSTR, hWndParent: HWND,
                  lpDialogFunc: DLGPROC): int32
  proc DialogBoxIndirect*(hInstance: HINST, hDialogTemplate: LPCDLGTEMPLATE,
                          hWndParent: HWND, lpDialogFunc: DLGPROC): int32
  proc CreateDC*(para1: LPCSTR, para2: LPCSTR, para3: LPCSTR, para4: pDEVMODE): HDC{.
      stdcall, dynlib: "gdi32", importc: "CreateDCA".}
  proc VerInstallFile*(uFlags: DWORD, szSrcFileName: LPSTR,
                       szDestFileName: LPSTR, szSrcDir: LPSTR, szDestDir: LPSTR,
                       szCurDir: LPSTR, szTmpFile: LPSTR, lpuTmpFileLen: PUINT): DWORD{.
      stdcall, dynlib: "version", importc: "VerInstallFileA".}
  proc GetFileVersionInfoSize*(lptstrFilename: LPSTR, lpdwHandle: LPDWORD): DWORD{.
      stdcall, dynlib: "version", importc: "GetFileVersionInfoSizeA".}
  proc GetFileVersionInfo*(lptstrFilename: LPSTR, dwHandle: DWORD, dwLen: DWORD,
                           lpData: LPVOID): WINBOOL{.stdcall, dynlib: "version",
      importc: "GetFileVersionInfoA".}
  proc VerLanguageName*(wLang: DWORD, szLang: LPSTR, nSize: DWORD): DWORD{.
      stdcall, dynlib: "kernel32", importc: "VerLanguageNameA".}
  proc VerQueryValue*(pBlock: LPVOID, lpSubBlock: LPSTR, lplpBuffer: LPVOID,
                      puLen: PUINT): WINBOOL{.stdcall, dynlib: "version",
      importc: "VerQueryValueA".}
  proc VerFindFile*(uFlags: DWORD, szFileName: LPSTR, szWinDir: LPSTR,
                    szAppDir: LPSTR, szCurDir: LPSTR, lpuCurDirLen: PUINT,
                    szDestDir: LPSTR, lpuDestDirLen: PUINT): DWORD{.stdcall,
      dynlib: "version", importc: "VerFindFileA".}
  proc RegConnectRegistry*(lpMachineName: LPSTR, key: HKEY, phkResult: PHKEY): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegConnectRegistryA".}
  proc RegCreateKey*(key: HKEY, lpSubKey: LPCSTR, phkResult: PHKEY): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegCreateKeyA".}
  proc RegCreateKeyEx*(key: HKEY, lpSubKey: LPCSTR, Reserved: DWORD,
                       lpClass: LPSTR, dwOptions: DWORD, samDesired: REGSAM,
                       lpSecurityAttributes: LPSECURITY_ATTRIBUTES,
                       phkResult: PHKEY, lpdwDisposition: LPDWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegCreateKeyExA".}
  proc RegDeleteKey*(key: HKEY, lpSubKey: LPCSTR): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegDeleteKeyA".}
  proc RegDeleteValue*(key: HKEY, lpValueName: LPCSTR): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegDeleteValueA".}
  proc RegEnumKey*(key: HKEY, dwIndex: DWORD, lpName: LPSTR, cbName: DWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegEnumKeyA".}
  proc RegEnumKeyEx*(key: HKEY, dwIndex: DWORD, lpName: LPSTR,
                     lpcbName: LPDWORD, lpReserved: LPDWORD, lpClass: LPSTR,
                     lpcbClass: LPDWORD, lpftLastWriteTime: PFILETIME): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegEnumKeyExA".}
  proc RegEnumValue*(key: HKEY, dwIndex: DWORD, lpValueName: LPSTR,
                     lpcbValueName: LPDWORD, lpReserved: LPDWORD,
                     lpType: LPDWORD, lpData: LPBYTE, lpcbData: LPDWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegEnumValueA".}
  proc RegLoadKey*(key: HKEY, lpSubKey: LPCSTR, lpFile: LPCSTR): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegLoadKeyA".}
  proc RegOpenKey*(key: HKEY, lpSubKey: LPCSTR, phkResult: PHKEY): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegOpenKeyA".}
  proc RegOpenKeyEx*(key: HKEY, lpSubKey: LPCSTR, ulOptions: DWORD,
                     samDesired: REGSAM, phkResult: PHKEY): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegOpenKeyExA".}
  proc RegQueryInfoKey*(key: HKEY, lpClass: LPSTR, lpcbClass: LPDWORD,
                        lpReserved: LPDWORD, lpcSubKeys: LPDWORD,
                        lpcbMaxSubKeyLen: LPDWORD, lpcbMaxClassLen: LPDWORD,
                        lpcValues: LPDWORD, lpcbMaxValueNameLen: LPDWORD,
                        lpcbMaxValueLen: LPDWORD,
                        lpcbSecurityDescriptor: LPDWORD,
                        lpftLastWriteTime: PFILETIME): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegQueryInfoKeyA".}
  proc RegQueryValue*(key: HKEY, lpSubKey: LPCSTR, lpValue: LPSTR,
                      lpcbValue: PLONG): LONG{.stdcall, dynlib: "advapi32",
      importc: "RegQueryValueA".}
  proc RegQueryMultipleValues*(key: HKEY, val_list: PVALENT, num_vals: DWORD,
                               lpValueBuf: LPSTR, ldwTotsize: LPDWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegQueryMultipleValuesA".}
  proc RegQueryValueEx*(key: HKEY, lpValueName: LPCSTR, lpReserved: LPDWORD,
                        lpType: LPDWORD, lpData: LPBYTE, lpcbData: LPDWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegQueryValueExA".}
  proc RegReplaceKey*(key: HKEY, lpSubKey: LPCSTR, lpNewFile: LPCSTR,
                      lpOldFile: LPCSTR): LONG{.stdcall, dynlib: "advapi32",
      importc: "RegReplaceKeyA".}
  proc RegRestoreKey*(key: HKEY, lpFile: LPCSTR, dwFlags: DWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegRestoreKeyA".}
  proc RegSaveKey*(key: HKEY, lpFile: LPCSTR,
                   lpSecurityAttributes: LPSECURITY_ATTRIBUTES): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegSaveKeyA".}
  proc RegSetValue*(key: HKEY, lpSubKey: LPCSTR, dwType: DWORD, lpData: LPCSTR,
                    cbData: DWORD): LONG{.stdcall, dynlib: "advapi32",
      importc: "RegSetValueA".}
  proc RegSetValueEx*(key: HKEY, lpValueName: LPCSTR, Reserved: DWORD,
                      dwType: DWORD, lpData: LPBYTE, cbData: DWORD): LONG{.
      stdcall, dynlib: "advapi32", importc: "RegSetValueExA".}
  proc RegUnLoadKey*(key: HKEY, lpSubKey: LPCSTR): LONG{.stdcall,
      dynlib: "advapi32", importc: "RegUnLoadKeyA".}
  proc InitiateSystemShutdown*(lpMachineName: LPSTR, lpMessage: LPSTR,
                               dwTimeout: DWORD, bForceAppsClosed: WINBOOL,
                               bRebootAfterShutdown: WINBOOL): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "InitiateSystemShutdownA".}
  proc AbortSystemShutdown*(lpMachineName: LPSTR): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "AbortSystemShutdownA".}
  proc CompareString*(Locale: LCID, dwCmpFlags: DWORD, lpString1: LPCSTR,
                      cchCount1: int32, lpString2: LPCSTR, cchCount2: int32): int32{.
      stdcall, dynlib: "kernel32", importc: "CompareStringA".}
  proc LCMapString*(Locale: LCID, dwMapFlags: DWORD, lpSrcStr: LPCSTR,
                    cchSrc: int32, lpDestStr: LPSTR, cchDest: int32): int32{.
      stdcall, dynlib: "kernel32", importc: "LCMapStringA".}
  proc GetLocaleInfo*(Locale: LCID, LCType: LCTYPE, lpLCData: LPSTR,
                      cchData: int32): int32{.stdcall, dynlib: "kernel32",
      importc: "GetLocaleInfoA".}
  proc SetLocaleInfo*(Locale: LCID, LCType: LCTYPE, lpLCData: LPCSTR): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "SetLocaleInfoA".}
  proc GetTimeFormat*(Locale: LCID, dwFlags: DWORD, lpTime: LPSYSTEMTIME,
                      lpFormat: LPCSTR, lpTimeStr: LPSTR, cchTime: int32): int32{.
      stdcall, dynlib: "kernel32", importc: "GetTimeFormatA".}
  proc GetDateFormat*(Locale: LCID, dwFlags: DWORD, lpDate: LPSYSTEMTIME,
                      lpFormat: LPCSTR, lpDateStr: LPSTR, cchDate: int32): int32{.
      stdcall, dynlib: "kernel32", importc: "GetDateFormatA".}
  proc GetNumberFormat*(Locale: LCID, dwFlags: DWORD, lpValue: LPCSTR,
                        lpFormat: PNUMBERFMT, lpNumberStr: LPSTR,
                        cchNumber: int32): int32{.stdcall, dynlib: "kernel32",
      importc: "GetNumberFormatA".}
  proc GetCurrencyFormat*(Locale: LCID, dwFlags: DWORD, lpValue: LPCSTR,
                          lpFormat: PCURRENCYFMT, lpCurrencyStr: LPSTR,
                          cchCurrency: int32): int32{.stdcall,
      dynlib: "kernel32", importc: "GetCurrencyFormatA".}
  proc EnumCalendarInfo*(lpCalInfoEnumProc: CALINFO_ENUMPROC, Locale: LCID,
                         Calendar: CALID, CalType: CALTYPE): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "EnumCalendarInfoA".}
  proc EnumTimeFormats*(lpTimeFmtEnumProc: TIMEFMT_ENUMPROC, Locale: LCID,
                        dwFlags: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "EnumTimeFormatsA".}
  proc EnumDateFormats*(lpDateFmtEnumProc: DATEFMT_ENUMPROC, Locale: LCID,
                        dwFlags: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "EnumDateFormatsA".}
  proc GetStringTypeEx*(Locale: LCID, dwInfoType: DWORD, lpSrcStr: LPCSTR,
                        cchSrc: int32, lpCharType: LPWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetStringTypeExA".}
  proc GetStringType*(Locale: LCID, dwInfoType: DWORD, lpSrcStr: LPCSTR,
                      cchSrc: int32, lpCharType: LPWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "GetStringTypeA".}
  proc FoldString*(dwMapFlags: DWORD, lpSrcStr: LPCSTR, cchSrc: int32,
                   lpDestStr: LPSTR, cchDest: int32): int32{.stdcall,
      dynlib: "kernel32", importc: "FoldStringA".}
  proc EnumSystemLocales*(lpLocaleEnumProc: LOCALE_ENUMPROC, dwFlags: DWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "EnumSystemLocalesA".}
  proc EnumSystemCodePages*(lpCodePageEnumProc: CODEPAGE_ENUMPROC,
                            dwFlags: DWORD): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "EnumSystemCodePagesA".}
  proc PeekConsoleInput*(hConsoleInput: HANDLE, lpBuffer: PINPUTRECORD,
                         nLength: DWORD, lpNumberOfEventsRead: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "PeekConsoleInputA".}
  proc ReadConsoleInput*(hConsoleInput: HANDLE, lpBuffer: PINPUTRECORD,
                         nLength: DWORD, lpNumberOfEventsRead: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "ReadConsoleInputA".}
  proc WriteConsoleInput*(hConsoleInput: HANDLE, lpBuffer: PINPUTRECORD,
                          nLength: DWORD, lpNumberOfEventsWritten: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "WriteConsoleInputA".}
  proc ReadConsoleOutput*(hConsoleOutput: HANDLE, lpBuffer: PCHAR_INFO,
                          dwBufferSize: COORD, dwBufferCoord: COORD,
                          lpReadRegion: PSMALL_RECT): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "ReadConsoleOutputA".}
  proc WriteConsoleOutput*(hConsoleOutput: HANDLE, lpBuffer: PCHAR_INFO,
                           dwBufferSize: COORD, dwBufferCoord: COORD,
                           lpWriteRegion: PSMALL_RECT): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "WriteConsoleOutputA".}
  proc ReadConsoleOutputCharacter*(hConsoleOutput: HANDLE, lpCharacter: LPSTR,
                                   nLength: DWORD, dwReadCoord: COORD,
                                   lpNumberOfCharsRead: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "ReadConsoleOutputCharacterA".}
  proc WriteConsoleOutputCharacter*(hConsoleOutput: HANDLE, lpCharacter: LPCSTR,
                                    nLength: DWORD, dwWriteCoord: COORD,
                                    lpNumberOfCharsWritten: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "WriteConsoleOutputCharacterA".}
  proc FillConsoleOutputCharacter*(hConsoleOutput: HANDLE, cCharacter: CHAR,
                                   nLength: DWORD, dwWriteCoord: COORD,
                                   lpNumberOfCharsWritten: LPDWORD): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "FillConsoleOutputCharacterA".}
  proc ScrollConsoleScreenBuffer*(hConsoleOutput: HANDLE,
                                  lpScrollRectangle: PSMALL_RECT,
                                  lpClipRectangle: PSMALL_RECT,
                                  dwDestinationOrigin: COORD, lpFill: PCHAR_INFO): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "ScrollConsoleScreenBufferA".}
  proc GetConsoleTitle*(lpConsoleTitle: LPSTR, nSize: DWORD): DWORD{.stdcall,
      dynlib: "kernel32", importc: "GetConsoleTitleA".}
  proc SetConsoleTitle*(lpConsoleTitle: LPCSTR): WINBOOL{.stdcall,
      dynlib: "kernel32", importc: "SetConsoleTitleA".}
  proc ReadConsole*(hConsoleInput: HANDLE, lpBuffer: LPVOID,
                    nNumberOfCharsToRead: DWORD, lpNumberOfCharsRead: LPDWORD,
                    lpReserved: LPVOID): WINBOOL{.stdcall, dynlib: "kernel32",
      importc: "ReadConsoleA".}
  proc WriteConsole*(hConsoleOutput: HANDLE, lpBuffer: pointer,
                     nNumberOfCharsToWrite: DWORD,
                     lpNumberOfCharsWritten: LPDWORD, lpReserved: LPVOID): WINBOOL{.
      stdcall, dynlib: "kernel32", importc: "WriteConsoleA".}
  proc WNetAddConnection*(lpRemoteName: LPCSTR, lpPassword: LPCSTR,
                          lpLocalName: LPCSTR): DWORD{.stdcall, dynlib: "mpr",
      importc: "WNetAddConnectionA".}
  proc WNetAddConnection2*(lpNetResource: LPNETRESOURCE, lpPassword: LPCSTR,
                           lpUserName: LPCSTR, dwFlags: DWORD): DWORD{.stdcall,
      dynlib: "mpr", importc: "WNetAddConnection2A".}
  proc WNetAddConnection3*(hwndOwner: HWND, lpNetResource: LPNETRESOURCE,
                           lpPassword: LPCSTR, lpUserName: LPCSTR,
                           dwFlags: DWORD): DWORD{.stdcall, dynlib: "mpr",
      importc: "WNetAddConnection3A".}
  proc WNetCancelConnection*(lpName: LPCSTR, fForce: WINBOOL): DWORD{.stdcall,
      dynlib: "mpr", importc: "WNetCancelConnectionA".}
  proc WNetCancelConnection2*(lpName: LPCSTR, dwFlags: DWORD, fForce: WINBOOL): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetCancelConnection2A".}
  proc WNetGetConnection*(lpLocalName: LPCSTR, lpRemoteName: LPSTR,
                          lpnLength: LPDWORD): DWORD{.stdcall, dynlib: "mpr",
      importc: "WNetGetConnectionA".}
  proc WNetUseConnection*(hwndOwner: HWND, lpNetResource: LPNETRESOURCE,
                          lpUserID: LPCSTR, lpPassword: LPCSTR, dwFlags: DWORD,
                          lpAccessName: LPSTR, lpBufferSize: LPDWORD,
                          lpResult: LPDWORD): DWORD{.stdcall, dynlib: "mpr",
      importc: "WNetUseConnectionA".}
  proc WNetSetConnection*(lpName: LPCSTR, dwProperties: DWORD, pvValues: LPVOID): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetSetConnectionA".}
  proc WNetConnectionDialog1*(lpConnDlgStruct: LPCONNECTDLGSTRUCT): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetConnectionDialog1A".}
  proc WNetDisconnectDialog1*(lpConnDlgStruct: LPDISCDLGSTRUCT): DWORD{.stdcall,
      dynlib: "mpr", importc: "WNetDisconnectDialog1A".}
  proc WNetOpenEnum*(dwScope: DWORD, dwType: DWORD, dwUsage: DWORD,
                     lpNetResource: LPNETRESOURCE, lphEnum: LPHANDLE): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetOpenEnumA".}
  proc WNetEnumResource*(hEnum: HANDLE, lpcCount: LPDWORD, lpBuffer: LPVOID,
                         lpBufferSize: LPDWORD): DWORD{.stdcall, dynlib: "mpr",
      importc: "WNetEnumResourceA".}
  proc WNetGetUniversalName*(lpLocalPath: LPCSTR, dwInfoLevel: DWORD,
                             lpBuffer: LPVOID, lpBufferSize: LPDWORD): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetGetUniversalNameA".}
  proc WNetGetUser*(lpName: LPCSTR, lpUserName: LPSTR, lpnLength: LPDWORD): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetGetUserA".}
  proc WNetGetProviderName*(dwNetType: DWORD, lpProviderName: LPSTR,
                            lpBufferSize: LPDWORD): DWORD{.stdcall,
      dynlib: "mpr", importc: "WNetGetProviderNameA".}
  proc WNetGetNetworkInformation*(lpProvider: LPCSTR,
                                  lpNetInfoStruct: LPNETINFOSTRUCT): DWORD{.
      stdcall, dynlib: "mpr", importc: "WNetGetNetworkInformationA".}
  proc WNetGetLastError*(lpError: LPDWORD, lpErrorBuf: LPSTR,
                         nErrorBufSize: DWORD, lpNameBuf: LPSTR,
                         nNameBufSize: DWORD): DWORD{.stdcall, dynlib: "mpr",
      importc: "WNetGetLastErrorA".}
  proc MultinetGetConnectionPerformance*(lpNetResource: LPNETRESOURCE,
      lpNetConnectInfoStruct: LPNETCONNECTINFOSTRUCT): DWORD{.stdcall,
      dynlib: "mpr", importc: "MultinetGetConnectionPerformanceA".}
  proc ChangeServiceConfig*(hService: SC_HANDLE, dwServiceType: DWORD,
                            dwStartType: DWORD, dwErrorControl: DWORD,
                            lpBinaryPathName: LPCSTR, lpLoadOrderGroup: LPCSTR,
                            lpdwTagId: LPDWORD, lpDependencies: LPCSTR,
                            lpServiceStartName: LPCSTR, lpPassword: LPCSTR,
                            lpDisplayName: LPCSTR): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "ChangeServiceConfigA".}
  proc CreateService*(hSCManager: SC_HANDLE, lpServiceName: LPCSTR,
                      lpDisplayName: LPCSTR, dwDesiredAccess: DWORD,
                      dwServiceType: DWORD, dwStartType: DWORD,
                      dwErrorControl: DWORD, lpBinaryPathName: LPCSTR,
                      lpLoadOrderGroup: LPCSTR, lpdwTagId: LPDWORD,
                      lpDependencies: LPCSTR, lpServiceStartName: LPCSTR,
                      lpPassword: LPCSTR): SC_HANDLE{.stdcall,
      dynlib: "advapi32", importc: "CreateServiceA".}
  proc EnumDependentServices*(hService: SC_HANDLE, dwServiceState: DWORD,
                              lpServices: LPENUM_SERVICE_STATUS,
                              cbBufSize: DWORD, pcbBytesNeeded: LPDWORD,
                              lpServicesReturned: LPDWORD): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "EnumDependentServicesA".}
  proc EnumServicesStatus*(hSCManager: SC_HANDLE, dwServiceType: DWORD,
                           dwServiceState: DWORD,
                           lpServices: LPENUM_SERVICE_STATUS, cbBufSize: DWORD,
                           pcbBytesNeeded: LPDWORD, lpServicesReturned: LPDWORD,
                           lpResumeHandle: LPDWORD): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "EnumServicesStatusA".}
  proc GetServiceKeyName*(hSCManager: SC_HANDLE, lpDisplayName: LPCSTR,
                          lpServiceName: LPSTR, lpcchBuffer: LPDWORD): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "GetServiceKeyNameA".}
  proc GetServiceDisplayName*(hSCManager: SC_HANDLE, lpServiceName: LPCSTR,
                              lpDisplayName: LPSTR, lpcchBuffer: LPDWORD): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "GetServiceDisplayNameA".}
  proc OpenSCManager*(lpMachineName: LPCSTR, lpDatabaseName: LPCSTR,
                      dwDesiredAccess: DWORD): SC_HANDLE{.stdcall,
      dynlib: "advapi32", importc: "OpenSCManagerA".}
  proc OpenService*(hSCManager: SC_HANDLE, lpServiceName: LPCSTR,
                    dwDesiredAccess: DWORD): SC_HANDLE{.stdcall,
      dynlib: "advapi32", importc: "OpenServiceA".}
  proc QueryServiceConfig*(hService: SC_HANDLE,
                           lpServiceConfig: LPQUERY_SERVICE_CONFIG,
                           cbBufSize: DWORD, pcbBytesNeeded: LPDWORD): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "QueryServiceConfigA".}
  proc QueryServiceLockStatus*(hSCManager: SC_HANDLE,
                               lpLockStatus: LPQUERY_SERVICE_LOCK_STATUS,
                               cbBufSize: DWORD, pcbBytesNeeded: LPDWORD): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "QueryServiceLockStatusA".}
  proc RegisterServiceCtrlHandler*(lpServiceName: LPCSTR,
                                   lpHandlerProc: LPHANDLER_FUNCTION): SERVICE_STATUS_HANDLE{.
      stdcall, dynlib: "advapi32", importc: "RegisterServiceCtrlHandlerA".}
  proc StartServiceCtrlDispatcher*(lpServiceStartTable: LPSERVICE_TABLE_ENTRY): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "StartServiceCtrlDispatcherA".}
  proc StartService*(hService: SC_HANDLE, dwNumServiceArgs: DWORD,
                     lpServiceArgVectors: LPCSTR): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "StartServiceA".}
  proc DragQueryFile*(para1: HDROP, para2: int, para3: cstring, para4: int): int{.
      stdcall, dynlib: "shell32", importc: "DragQueryFileA".}
  proc ExtractAssociatedIcon*(para1: HINST, para2: cstring, para3: LPWORD): HICON{.
      stdcall, dynlib: "shell32", importc: "ExtractAssociatedIconA".}
  proc ExtractIcon*(para1: HINST, para2: cstring, para3: int): HICON{.stdcall,
      dynlib: "shell32", importc: "ExtractIconA".}
  proc FindExecutable*(para1: cstring, para2: cstring, para3: cstring): HINST{.
      stdcall, dynlib: "shell32", importc: "FindExecutableA".}
  proc ShellAbout*(para1: HWND, para2: cstring, para3: cstring, para4: HICON): int32{.
      stdcall, dynlib: "shell32", importc: "ShellAboutA".}
  proc ShellExecute*(para1: HWND, para2: cstring, para3: cstring,
                     para4: cstring, para5: cstring, para6: int32): HINST{.
      stdcall, dynlib: "shell32", importc: "ShellExecuteA".}
  proc Shell_NotifyIcon*(dwMessage: DWORD, lpData: PNotifyIconDataA): WINBOOL{.
      stdcall, dynlib: "shell32", importc: "Shell_NotifyIconA".}
  proc DdeCreateStringHandle*(para1: DWORD, para2: cstring, para3: int32): HSZ{.
      stdcall, dynlib: "user32", importc: "DdeCreateStringHandleA".}
  proc DdeInitialize*(para1: LPDWORD, para2: PFNCALLBACK, para3: DWORD,
                      para4: DWORD): UINT{.stdcall, dynlib: "user32",
      importc: "DdeInitializeA".}
  proc DdeQueryString*(para1: DWORD, para2: HSZ, para3: cstring, para4: DWORD,
                       para5: int32): DWORD{.stdcall, dynlib: "user32",
      importc: "DdeQueryStringA".}
  proc LogonUser*(para1: LPSTR, para2: LPSTR, para3: LPSTR, para4: DWORD,
                  para5: DWORD, para6: PHANDLE): WINBOOL{.stdcall,
      dynlib: "advapi32", importc: "LogonUserA".}
  proc CreateProcessAsUser*(para1: HANDLE, para2: LPCTSTR, para3: LPTSTR,
                            para4: LPSECURITY_ATTRIBUTES,
                            para5: LPSECURITY_ATTRIBUTES, para6: WINBOOL,
                            para7: DWORD, para8: LPVOID, para9: LPCTSTR,
                            para10: LPSTARTUPINFO, para11: LPPROCESS_INFORMATION): WINBOOL{.
      stdcall, dynlib: "advapi32", importc: "CreateProcessAsUserA".}
proc GetRandomRgn*(aHDC: HDC, aHRGN: HRGN, iNum: WINT): WINT{.stdcall,
     importc, dynlib: "gdi32".}

proc AccessCheck*(pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                  ClientToken: HANDLE, DesiredAccess: DWORD,
                  GenericMapping: PGENERIC_MAPPING,
                  PrivilegeSet: PPRIVILEGE_SET, PrivilegeSetLength: LPDWORD,
                  GrantedAccess: LPDWORD, AccessStatus: LPBOOL): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "AccessCheck".}
proc FreeResource*(hResData: HGLOBAL): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "FreeResource".}
proc LockResource*(hResData: HGLOBAL): LPVOID{.stdcall, dynlib: "kernel32",
    importc: "LockResource".}
proc FreeLibrary*(hLibModule: HINST): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "FreeLibrary".}
proc FreeLibraryAndExitThread*(hLibModule: HMODULE, dwExitCode: DWORD){.stdcall,
    dynlib: "kernel32", importc: "FreeLibraryAndExitThread".}
proc DisableThreadLibraryCalls*(hLibModule: HMODULE): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "DisableThreadLibraryCalls".}
proc GetProcAddress*(hModule: HINST, lpProcName: LPCSTR): FARPROC{.stdcall,
    dynlib: "kernel32", importc: "GetProcAddress".}
proc GetVersion*(): DWORD{.stdcall, dynlib: "kernel32", importc: "GetVersion".}
proc GlobalAlloc*(uFlags: INT, dwBytes: DWORD): HGLOBAL{.stdcall,
    dynlib: "kernel32", importc: "GlobalAlloc".}
proc GlobalReAlloc*(hMem: HGLOBAL, dwBytes: DWORD, uFlags: INT): HGLOBAL{.
    stdcall, dynlib: "kernel32", importc: "GlobalReAlloc".}
proc GlobalSize*(hMem: HGLOBAL): DWORD{.stdcall, dynlib: "kernel32",
                                        importc: "GlobalSize".}
proc GlobalFlags*(hMem: HGLOBAL): UINT{.stdcall, dynlib: "kernel32",
                                        importc: "GlobalFlags".}
proc GlobalLock*(hMem: HGLOBAL): LPVOID{.stdcall, dynlib: "kernel32",
    importc: "GlobalLock".}
proc GlobalHandle*(pMem: LPCVOID): HGLOBAL{.stdcall, dynlib: "kernel32",
    importc: "GlobalHandle".}
proc GlobalUnlock*(hMem: HGLOBAL): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "GlobalUnlock".}
proc GlobalFree*(hMem: HGLOBAL): HGLOBAL{.stdcall, dynlib: "kernel32",
    importc: "GlobalFree".}
proc GlobalCompact*(dwMinFree: DWORD): UINT{.stdcall, dynlib: "kernel32",
    importc: "GlobalCompact".}
proc GlobalFix*(hMem: HGLOBAL){.stdcall, dynlib: "kernel32",
                                importc: "GlobalFix".}
proc GlobalUnfix*(hMem: HGLOBAL){.stdcall, dynlib: "kernel32",
                                  importc: "GlobalUnfix".}
proc GlobalWire*(hMem: HGLOBAL): LPVOID{.stdcall, dynlib: "kernel32",
    importc: "GlobalWire".}
proc GlobalUnWire*(hMem: HGLOBAL): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "GlobalUnWire".}
proc GlobalMemoryStatus*(lpBuffer: LPMEMORYSTATUS){.stdcall, dynlib: "kernel32",
    importc: "GlobalMemoryStatus".}
proc LocalAlloc*(uFlags: UINT, uBytes: UINT): HLOCAL{.stdcall,
    dynlib: "kernel32", importc: "LocalAlloc".}
proc LocalReAlloc*(hMem: HLOCAL, uBytes: UINT, uFlags: UINT): HLOCAL{.stdcall,
    dynlib: "kernel32", importc: "LocalReAlloc".}
proc LocalLock*(hMem: HLOCAL): LPVOID{.stdcall, dynlib: "kernel32",
                                       importc: "LocalLock".}
proc LocalHandle*(pMem: LPCVOID): HLOCAL{.stdcall, dynlib: "kernel32",
    importc: "LocalHandle".}
proc LocalUnlock*(hMem: HLOCAL): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "LocalUnlock".}
proc LocalSize*(hMem: HLOCAL): UINT{.stdcall, dynlib: "kernel32",
                                     importc: "LocalSize".}
proc LocalFlags*(hMem: HLOCAL): UINT{.stdcall, dynlib: "kernel32",
                                      importc: "LocalFlags".}
proc LocalFree*(hMem: HLOCAL): HLOCAL{.stdcall, dynlib: "kernel32",
                                       importc: "LocalFree".}
proc LocalShrink*(hMem: HLOCAL, cbNewSize: UINT): UINT{.stdcall,
    dynlib: "kernel32", importc: "LocalShrink".}
proc LocalCompact*(uMinFree: UINT): UINT{.stdcall, dynlib: "kernel32",
    importc: "LocalCompact".}
proc FlushInstructionCache*(hProcess: HANDLE, lpBaseAddress: LPCVOID,
                            dwSize: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "FlushInstructionCache".}
proc VirtualAlloc*(lpAddress: LPVOID, dwSize: DWORD, flAllocationType: DWORD,
                   flProtect: DWORD): LPVOID{.stdcall, dynlib: "kernel32",
    importc: "VirtualAlloc".}
proc VirtualFree*(lpAddress: LPVOID, dwSize: DWORD, dwFreeType: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "VirtualFree".}
proc VirtualProtect*(lpAddress: LPVOID, dwSize: DWORD, flNewProtect: DWORD,
                     lpflOldProtect: PDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "VirtualProtect".}
proc VirtualQuery*(lpAddress: LPCVOID, lpBuffer: PMEMORY_BASIC_INFORMATION,
                   dwLength: DWORD): DWORD{.stdcall, dynlib: "kernel32",
    importc: "VirtualQuery".}
proc VirtualProtectEx*(hProcess: HANDLE, lpAddress: LPVOID, dwSize: DWORD,
                       flNewProtect: DWORD, lpflOldProtect: PDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "VirtualProtectEx".}
proc VirtualQueryEx*(hProcess: HANDLE, lpAddress: LPCVOID,
                     lpBuffer: PMEMORY_BASIC_INFORMATION, dwLength: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc: "VirtualQueryEx".}
proc HeapCreate*(flOptions: DWORD, dwInitialSize: DWORD, dwMaximumSize: DWORD): HANDLE{.
    stdcall, dynlib: "kernel32", importc: "HeapCreate".}
proc HeapDestroy*(hHeap: HANDLE): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "HeapDestroy".}
proc HeapAlloc*(hHeap: HANDLE, dwFlags: DWORD, dwBytes: DWORD): LPVOID{.stdcall,
    dynlib: "kernel32", importc: "HeapAlloc".}
proc HeapReAlloc*(hHeap: HANDLE, dwFlags: DWORD, lpMem: LPVOID, dwBytes: DWORD): LPVOID{.
    stdcall, dynlib: "kernel32", importc: "HeapReAlloc".}
proc HeapFree*(hHeap: HANDLE, dwFlags: DWORD, lpMem: LPVOID): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "HeapFree".}
proc HeapSize*(hHeap: HANDLE, dwFlags: DWORD, lpMem: LPCVOID): DWORD{.stdcall,
    dynlib: "kernel32", importc: "HeapSize".}
proc HeapValidate*(hHeap: HANDLE, dwFlags: DWORD, lpMem: LPCVOID): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "HeapValidate".}
proc HeapCompact*(hHeap: HANDLE, dwFlags: DWORD): UINT{.stdcall,
    dynlib: "kernel32", importc: "HeapCompact".}
proc GetProcessHeap*(): HANDLE{.stdcall, dynlib: "kernel32",
                                importc: "GetProcessHeap".}
proc GetProcessHeaps*(NumberOfHeaps: DWORD, ProcessHeaps: PHANDLE): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetProcessHeaps".}
proc HeapLock*(hHeap: HANDLE): WINBOOL{.stdcall, dynlib: "kernel32",
                                        importc: "HeapLock".}
proc HeapUnlock*(hHeap: HANDLE): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "HeapUnlock".}
proc HeapWalk*(hHeap: HANDLE, lpEntry: LPPROCESS_HEAP_ENTRY): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "HeapWalk".}
proc GetProcessAffinityMask*(hProcess: HANDLE, lpProcessAffinityMask: LPDWORD,
                             lpSystemAffinityMask: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetProcessAffinityMask".}
proc GetProcessTimes*(hProcess: HANDLE, lpCreationTime: LPFILETIME,
                      lpExitTime: LPFILETIME, lpKernelTime: LPFILETIME,
                      lpUserTime: LPFILETIME): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetProcessTimes".}
proc GetProcessWorkingSetSize*(hProcess: HANDLE,
                               lpMinimumWorkingSetSize: LPDWORD,
                               lpMaximumWorkingSetSize: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetProcessWorkingSetSize".}
proc SetProcessWorkingSetSize*(hProcess: HANDLE, dwMinimumWorkingSetSize: DWORD,
                               dwMaximumWorkingSetSize: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetProcessWorkingSetSize".}
proc OpenProcess*(dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                  dwProcessId: DWORD): HANDLE{.stdcall, dynlib: "kernel32",
    importc: "OpenProcess".}
proc GetCurrentProcess*(): HANDLE{.stdcall, dynlib: "kernel32",
                                   importc: "GetCurrentProcess".}
proc GetCurrentProcessId*(): DWORD{.stdcall, dynlib: "kernel32",
                                    importc: "GetCurrentProcessId".}
proc ExitProcess*(uExitCode: UINT){.stdcall, dynlib: "kernel32",
                                    importc: "ExitProcess".}
proc TerminateProcess*(hProcess: HANDLE, uExitCode: UINT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "TerminateProcess".}
proc SetProcessAffinityMask*(hProcess: THandle, dwProcessAffinityMask: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetProcessAffinityMask".}
proc GetExitCodeProcess*(hProcess: HANDLE, lpExitCode: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetExitCodeProcess".}
proc FatalExit*(ExitCode: int32){.stdcall, dynlib: "kernel32",
                                  importc: "FatalExit".}
proc RaiseException*(dwExceptionCode: DWORD, dwExceptionFlags: DWORD,
                     nNumberOfArguments: DWORD, lpArguments: LPDWORD){.stdcall,
    dynlib: "kernel32", importc: "RaiseException".}
proc UnhandledExceptionFilter*(ExceptionInfo: lpemptyrecord): LONG{.stdcall,
    dynlib: "kernel32", importc: "UnhandledExceptionFilter".}
proc CreateRemoteThread*(hProcess: HANDLE,
                         lpThreadAttributes: LPSECURITY_ATTRIBUTES,
                         dwStackSize: DWORD,
                         lpStartAddress: LPTHREAD_START_ROUTINE,
                         lpParameter: LPVOID, dwCreationFlags: DWORD,
                         lpThreadId: LPDWORD): HANDLE{.stdcall,
    dynlib: "kernel32", importc: "CreateRemoteThread".}
proc GetCurrentThread*(): HANDLE{.stdcall, dynlib: "kernel32",
                                  importc: "GetCurrentThread".}
proc GetCurrentThreadId*(): DWORD{.stdcall, dynlib: "kernel32",
                                   importc: "GetCurrentThreadId".}
proc SetThreadAffinityMask*(hThread: HANDLE, dwThreadAffinityMask: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc: "SetThreadAffinityMask".}
proc SetThreadPriority*(hThread: HANDLE, nPriority: int32): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetThreadPriority".}
proc GetThreadPriority*(hThread: HANDLE): int32{.stdcall, dynlib: "kernel32",
    importc: "GetThreadPriority".}
proc GetThreadTimes*(hThread: HANDLE, lpCreationTime: LPFILETIME,
                     lpExitTime: LPFILETIME, lpKernelTime: LPFILETIME,
                     lpUserTime: LPFILETIME): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetThreadTimes".}
proc ExitThread*(dwExitCode: DWORD){.stdcall, dynlib: "kernel32",
                                     importc: "ExitThread".}
proc TerminateThread*(hThread: HANDLE, dwExitCode: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "TerminateThread".}
proc GetExitCodeThread*(hThread: HANDLE, lpExitCode: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetExitCodeThread".}
proc GetThreadSelectorEntry*(hThread: HANDLE, dwSelector: DWORD,
                             lpSelectorEntry: LPLDT_ENTRY): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetThreadSelectorEntry".}
proc GetLastError*(): DWORD{.stdcall, dynlib: "kernel32",
                             importc: "GetLastError".}
proc SetLastError*(dwErrCode: DWORD){.stdcall, dynlib: "kernel32",
                                      importc: "SetLastError".}
proc CreateIoCompletionPort*(FileHandle: HANDLE, ExistingCompletionPort: HANDLE,
                             CompletionKey: DWORD,
                             NumberOfConcurrentThreads: DWORD): HANDLE{.stdcall,
    dynlib: "kernel32", importc: "CreateIoCompletionPort".}
proc SetErrorMode*(uMode: UINT): UINT{.stdcall, dynlib: "kernel32",
                                       importc: "SetErrorMode".}
proc ReadProcessMemory*(hProcess: HANDLE, lpBaseAddress: LPCVOID,
                        lpBuffer: LPVOID, nSize: DWORD,
                        lpNumberOfBytesRead: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "ReadProcessMemory".}
proc WriteProcessMemory*(hProcess: HANDLE, lpBaseAddress: LPVOID,
                         lpBuffer: LPVOID, nSize: DWORD,
                         lpNumberOfBytesWritten: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WriteProcessMemory".}
proc GetThreadContext*(hThread: HANDLE, lpContext: LPCONTEXT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetThreadContext".}
proc SuspendThread*(hThread: HANDLE): DWORD{.stdcall, dynlib: "kernel32",
    importc: "SuspendThread".}
proc ResumeThread*(hThread: HANDLE): DWORD{.stdcall, dynlib: "kernel32",
    importc: "ResumeThread".}
proc DebugBreak*(){.stdcall, dynlib: "kernel32", importc: "DebugBreak".}
proc WaitForDebugEvent*(lpDebugEvent: LPDEBUG_EVENT, dwMilliseconds: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WaitForDebugEvent".}
proc ContinueDebugEvent*(dwProcessId: DWORD, dwThreadId: DWORD,
                         dwContinueStatus: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "ContinueDebugEvent".}
proc DebugActiveProcess*(dwProcessId: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "DebugActiveProcess".}
proc InitializeCriticalSection*(lpCriticalSection: LPCRITICAL_SECTION){.stdcall,
    dynlib: "kernel32", importc: "InitializeCriticalSection".}
proc EnterCriticalSection*(lpCriticalSection: LPCRITICAL_SECTION){.stdcall,
    dynlib: "kernel32", importc: "EnterCriticalSection".}
proc LeaveCriticalSection*(lpCriticalSection: LPCRITICAL_SECTION){.stdcall,
    dynlib: "kernel32", importc: "LeaveCriticalSection".}
proc DeleteCriticalSection*(lpCriticalSection: LPCRITICAL_SECTION){.stdcall,
    dynlib: "kernel32", importc: "DeleteCriticalSection".}
proc TryEnterCriticalSection*(lpCriticalSection: LPCRITICAL_SECTION): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "TryEnterCriticalSection".}
proc SetEvent*(hEvent: HANDLE): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "SetEvent".}
proc ResetEvent*(hEvent: HANDLE): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "ResetEvent".}
proc PulseEvent*(hEvent: HANDLE): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "PulseEvent".}
proc ReleaseSemaphore*(hSemaphore: HANDLE, lReleaseCount: LONG,
                       lpPreviousCount: LPLONG): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "ReleaseSemaphore".}
proc ReleaseMutex*(hMutex: HANDLE): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "ReleaseMutex".}
proc WaitForSingleObject*(hHandle: HANDLE, dwMilliseconds: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc: "WaitForSingleObject".}

proc Sleep*(dwMilliseconds: DWORD){.stdcall, dynlib: "kernel32",
                                    importc: "Sleep".}
proc LoadResource*(hModule: HINST, hResInfo: HRSRC): HGLOBAL{.stdcall,
    dynlib: "kernel32", importc: "LoadResource".}
proc SizeofResource*(hModule: HINST, hResInfo: HRSRC): DWORD{.stdcall,
    dynlib: "kernel32", importc: "SizeofResource".}
proc GlobalDeleteAtom*(nAtom: ATOM): ATOM{.stdcall, dynlib: "kernel32",
    importc: "GlobalDeleteAtom".}
proc InitAtomTable*(nSize: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "InitAtomTable".}
proc DeleteAtom*(nAtom: ATOM): ATOM{.stdcall, dynlib: "kernel32",
                                     importc: "DeleteAtom".}
proc SetHandleCount*(uNumber: UINT): UINT{.stdcall, dynlib: "kernel32",
    importc: "SetHandleCount".}
proc GetLogicalDrives*(): DWORD{.stdcall, dynlib: "kernel32",
                                 importc: "GetLogicalDrives".}
proc LockFile*(hFile: HANDLE, dwFileOffsetLow: DWORD, dwFileOffsetHigh: DWORD,
               nNumberOfBytesToLockLow: DWORD, nNumberOfBytesToLockHigh: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "LockFile".}
proc UnlockFile*(hFile: HANDLE, dwFileOffsetLow: DWORD, dwFileOffsetHigh: DWORD,
                 nNumberOfBytesToUnlockLow: DWORD,
                 nNumberOfBytesToUnlockHigh: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "UnlockFile".}
proc LockFileEx*(hFile: HANDLE, dwFlags: DWORD, dwReserved: DWORD,
                 nNumberOfBytesToLockLow: DWORD,
                 nNumberOfBytesToLockHigh: DWORD, lpOverlapped: LPOVERLAPPED): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "LockFileEx".}
proc UnlockFileEx*(hFile: HANDLE, dwReserved: DWORD,
                   nNumberOfBytesToUnlockLow: DWORD,
                   nNumberOfBytesToUnlockHigh: DWORD, lpOverlapped: LPOVERLAPPED): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "UnlockFileEx".}
proc GetFileInformationByHandle*(hFile: HANDLE, lpFileInformation: LPBY_HANDLE_FILE_INFORMATION): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetFileInformationByHandle".}
proc GetFileType*(hFile: HANDLE): DWORD{.stdcall, dynlib: "kernel32",
    importc: "GetFileType".}
proc GetFileSize*(hFile: HANDLE, lpFileSizeHigh: LPDWORD): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetFileSize".}
proc GetStdHandle*(nStdHandle: DWORD): HANDLE{.stdcall, dynlib: "kernel32",
    importc: "GetStdHandle".}
proc SetStdHandle*(nStdHandle: DWORD, hHandle: HANDLE): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetStdHandle".}
proc FlushFileBuffers*(hFile: HANDLE): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "FlushFileBuffers".}
proc DeviceIoControl*(hDevice: HANDLE, dwIoControlCode: DWORD,
                      lpInBuffer: LPVOID, nInBufferSize: DWORD,
                      lpOutBuffer: LPVOID, nOutBufferSize: DWORD,
                      lpBytesReturned: LPDWORD, lpOverlapped: LPOVERLAPPED): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "DeviceIoControl".}
proc SetEndOfFile*(hFile: HANDLE): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "SetEndOfFile".}
proc SetFilePointer*(hFile: HANDLE, lDistanceToMove: LONG,
                     lpDistanceToMoveHigh: PLONG, dwMoveMethod: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc: "SetFilePointer".}
proc FindClose*(hFindFile: HANDLE): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "FindClose".}
proc GetFileTime*(hFile: HANDLE, lpCreationTime: LPFILETIME,
                  lpLastAccessTime: LPFILETIME, lpLastWriteTime: LPFILETIME): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetFileTime".}
proc SetFileTime*(hFile: HANDLE, lpCreationTime: LPFILETIME,
                  lpLastAccessTime: LPFILETIME, lpLastWriteTime: LPFILETIME): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetFileTime".}
proc CloseHandle*(hObject: HANDLE): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "CloseHandle".}
proc DuplicateHandle*(hSourceProcessHandle: HANDLE, hSourceHandle: HANDLE,
                      hTargetProcessHandle: HANDLE, lpTargetHandle: LPHANDLE,
                      dwDesiredAccess: DWORD, bInheritHandle: WINBOOL,
                      dwOptions: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "DuplicateHandle".}
proc GetHandleInformation*(hObject: HANDLE, lpdwFlags: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetHandleInformation".}
proc SetHandleInformation*(hObject: HANDLE, dwMask: DWORD, dwFlags: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetHandleInformation".}
proc LoadModule*(lpModuleName: LPCSTR, lpParameterBlock: LPVOID): DWORD{.
    stdcall, dynlib: "kernel32", importc: "LoadModule".}
proc WinExec*(lpCmdLine: LPCSTR, uCmdShow: UINT): UINT{.stdcall,
    dynlib: "kernel32", importc: "WinExec".}
proc ClearCommBreak*(hFile: HANDLE): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "ClearCommBreak".}
proc ClearCommError*(hFile: HANDLE, lpErrors: LPDWORD, lpStat: LPCOMSTAT): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ClearCommError".}
proc SetupComm*(hFile: HANDLE, dwInQueue: DWORD, dwOutQueue: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetupComm".}
proc EscapeCommFunction*(hFile: HANDLE, dwFunc: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "EscapeCommFunction".}
proc GetCommConfig*(hCommDev: HANDLE, lpCC: LPCOMMCONFIG, lpdwSize: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetCommConfig".}
proc GetCommProperties*(hFile: HANDLE, lpCommProp: LPCOMMPROP): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetCommProperties".}
proc GetCommModemStatus*(hFile: HANDLE, lpModemStat: PDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetCommModemStatus".}
proc GetCommState*(hFile: HANDLE, lpDCB: PDCB): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetCommState".}
proc GetCommTimeouts*(hFile: HANDLE, lpCommTimeouts: PCOMMTIMEOUTS): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetCommTimeouts".}
proc PurgeComm*(hFile: HANDLE, dwFlags: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "PurgeComm".}
proc SetCommBreak*(hFile: HANDLE): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "SetCommBreak".}
proc SetCommConfig*(hCommDev: HANDLE, lpCC: LPCOMMCONFIG, dwSize: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetCommConfig".}
proc SetCommMask*(hFile: HANDLE, dwEvtMask: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetCommMask".}
proc SetCommState*(hFile: HANDLE, lpDCB: LPDCB): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetCommState".}
proc SetCommTimeouts*(hFile: HANDLE, lpCommTimeouts: LPCOMMTIMEOUTS): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetCommTimeouts".}
proc TransmitCommChar*(hFile: HANDLE, cChar: char): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "TransmitCommChar".}
proc WaitCommEvent*(hFile: HANDLE, lpEvtMask: LPDWORD,
                    lpOverlapped: LPOVERLAPPED): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WaitCommEvent".}
proc SetTapePosition*(hDevice: HANDLE, dwPositionMethod: DWORD,
                      dwPartition: DWORD, dwOffsetLow: DWORD,
                      dwOffsetHigh: DWORD, bImmediate: WINBOOL): DWORD{.stdcall,
    dynlib: "kernel32", importc: "SetTapePosition".}
proc GetTapePosition*(hDevice: HANDLE, dwPositionType: DWORD,
                      lpdwPartition: LPDWORD, lpdwOffsetLow: LPDWORD,
                      lpdwOffsetHigh: LPDWORD): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetTapePosition".}
proc PrepareTape*(hDevice: HANDLE, dwOperation: DWORD, bImmediate: WINBOOL): DWORD{.
    stdcall, dynlib: "kernel32", importc: "PrepareTape".}
proc EraseTape*(hDevice: HANDLE, dwEraseType: DWORD, bImmediate: WINBOOL): DWORD{.
    stdcall, dynlib: "kernel32", importc: "EraseTape".}
proc CreateTapePartition*(hDevice: HANDLE, dwPartitionMethod: DWORD,
                          dwCount: DWORD, dwSize: DWORD): DWORD{.stdcall,
    dynlib: "kernel32", importc: "CreateTapePartition".}
proc WriteTapemark*(hDevice: HANDLE, dwTapemarkType: DWORD,
                    dwTapemarkCount: DWORD, bImmediate: WINBOOL): DWORD{.
    stdcall, dynlib: "kernel32", importc: "WriteTapemark".}
proc GetTapeStatus*(hDevice: HANDLE): DWORD{.stdcall, dynlib: "kernel32",
    importc: "GetTapeStatus".}
proc GetTapeParameters*(hDevice: HANDLE, dwOperation: DWORD, lpdwSize: LPDWORD,
                        lpTapeInformation: LPVOID): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetTapeParameters".}
proc SetTapeParameters*(hDevice: HANDLE, dwOperation: DWORD,
                        lpTapeInformation: LPVOID): DWORD{.stdcall,
    dynlib: "kernel32", importc: "SetTapeParameters".}
proc Beep*(dwFreq: DWORD, dwDuration: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "Beep".}
proc MulDiv*(nNumber: int32, nNumerator: int32, nDenominator: int32): int32{.
    stdcall, dynlib: "kernel32", importc: "MulDiv".}
proc GetSystemTime*(lpSystemTime: LPSYSTEMTIME){.stdcall, dynlib: "kernel32",
    importc: "GetSystemTime".}
proc GetSystemTimeAsFileTime*(lpSystemTimeAsFileTime: LPFILETIME){.stdcall,
    dynlib: "kernel32", importc: "GetSystemTimeAsFileTime".}
proc SetSystemTime*(lpSystemTime: LPSYSTEMTIME): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetSystemTime".}
proc GetLocalTime*(lpSystemTime: LPSYSTEMTIME){.stdcall, dynlib: "kernel32",
    importc: "GetLocalTime".}
proc SetLocalTime*(lpSystemTime: LPSYSTEMTIME): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetLocalTime".}
proc GetSystemInfo*(lpSystemInfo: LPSYSTEM_INFO){.stdcall, dynlib: "kernel32",
    importc: "GetSystemInfo".}
proc SystemTimeToTzSpecificLocalTime*(lpTimeZoneInformation: LPTIME_ZONE_INFORMATION,
                                      lpUniversalTime: LPSYSTEMTIME,
                                      lpLocalTime: LPSYSTEMTIME): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SystemTimeToTzSpecificLocalTime".}
proc GetTimeZoneInformation*(lpTimeZoneInformation: LPTIME_ZONE_INFORMATION): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetTimeZoneInformation".}
proc SetTimeZoneInformation*(lpTimeZoneInformation: LPTIME_ZONE_INFORMATION): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetTimeZoneInformation".}
proc SystemTimeToFileTime*(lpSystemTime: LPSYSTEMTIME, lpFileTime: LPFILETIME): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SystemTimeToFileTime".}
proc FileTimeToLocalFileTime*(FileTime: LPFILETIME,
                              lpLocalFileTime: LPFILETIME): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "FileTimeToLocalFileTime".}
proc LocalFileTimeToFileTime*(lpLocalFileTime: LPFILETIME,
                              lpFileTime: LPFILETIME): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "LocalFileTimeToFileTime".}
proc FileTimeToSystemTime*(lpFileTime: LPFILETIME, lpSystemTime: LPSYSTEMTIME): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FileTimeToSystemTime".}
proc CompareFileTime*(lpFileTime1: LPFILETIME, lpFileTime2: LPFILETIME): LONG{.
    stdcall, dynlib: "kernel32", importc: "CompareFileTime".}
proc FileTimeToDosDateTime*(lpFileTime: LPFILETIME, lpFatDate: LPWORD,
                            lpFatTime: LPWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "FileTimeToDosDateTime".}
proc DosDateTimeToFileTime*(wFatDate: int16, wFatTime: int16,
                            lpFileTime: LPFILETIME): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "DosDateTimeToFileTime".}
proc GetTickCount*(): DWORD{.stdcall, dynlib: "kernel32",
                             importc: "GetTickCount".}
proc SetSystemTimeAdjustment*(dwTimeAdjustment: DWORD,
                              bTimeAdjustmentDisabled: WINBOOL): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetSystemTimeAdjustment".}
proc GetSystemTimeAdjustment*(lpTimeAdjustment: PDWORD, lpTimeIncrement: PDWORD,
                              lpTimeAdjustmentDisabled: PWINBOOL): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetSystemTimeAdjustment".}
proc CreatePipe*(hReadPipe: PHANDLE, hWritePipe: PHANDLE,
                 lpPipeAttributes: LPSECURITY_ATTRIBUTES, nSize: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CreatePipe".}
proc ConnectNamedPipe*(hNamedPipe: HANDLE, lpOverlapped: LPOVERLAPPED): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ConnectNamedPipe".}
proc DisconnectNamedPipe*(hNamedPipe: HANDLE): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "DisconnectNamedPipe".}
proc SetNamedPipeHandleState*(hNamedPipe: HANDLE, lpMode: LPDWORD,
                              lpMaxCollectionCount: LPDWORD,
                              lpCollectDataTimeout: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetNamedPipeHandleState".}
proc GetNamedPipeInfo*(hNamedPipe: HANDLE, lpFlags: LPDWORD,
                       lpOutBufferSize: LPDWORD, lpInBufferSize: LPDWORD,
                       lpMaxInstances: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetNamedPipeInfo".}
proc PeekNamedPipe*(hNamedPipe: HANDLE, lpBuffer: LPVOID, nBufferSize: DWORD,
                    lpBytesRead: LPDWORD, lpTotalBytesAvail: LPDWORD,
                    lpBytesLeftThisMessage: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "PeekNamedPipe".}
proc TransactNamedPipe*(hNamedPipe: HANDLE, lpInBuffer: LPVOID,
                        nInBufferSize: DWORD, lpOutBuffer: LPVOID,
                        nOutBufferSize: DWORD, lpBytesRead: LPDWORD,
                        lpOverlapped: LPOVERLAPPED): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "TransactNamedPipe".}
proc GetMailslotInfo*(hMailslot: HANDLE, lpMaxMessageSize: LPDWORD,
                      lpNextSize: LPDWORD, lpMessageCount: LPDWORD,
                      lpReadTimeout: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetMailslotInfo".}
proc SetMailslotInfo*(hMailslot: HANDLE, lReadTimeout: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetMailslotInfo".}
proc MapViewOfFile*(hFileMappingObject: HANDLE, dwDesiredAccess: DWORD,
                    dwFileOffsetHigh: DWORD, dwFileOffsetLow: DWORD,
                    dwNumberOfBytesToMap: DWORD): LPVOID{.stdcall,
    dynlib: "kernel32", importc: "MapViewOfFile".}
proc FlushViewOfFile*(lpBaseAddress: LPCVOID, dwNumberOfBytesToFlush: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FlushViewOfFile".}
proc UnmapViewOfFile*(lpBaseAddress: LPVOID): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "UnmapViewOfFile".}
proc OpenFile*(lpFileName: LPCSTR, lpReOpenBuff: LPOFSTRUCT, uStyle: UINT): HFILE{.
    stdcall, dynlib: "kernel32", importc: "OpenFile".}
proc lopen*(lpPathName: LPCSTR, iReadWrite: int32): HFILE{.stdcall,
    dynlib: "kernel32", importc: "_lopen".}
proc lcreat*(lpPathName: LPCSTR, iAttribute: int32): HFILE{.stdcall,
    dynlib: "kernel32", importc: "_lcreat".}
proc lread*(hFile: HFILE, lpBuffer: LPVOID, uBytes: UINT): UINT{.stdcall,
    dynlib: "kernel32", importc: "_lread".}
proc lwrite*(hFile: HFILE, lpBuffer: LPCSTR, uBytes: UINT): UINT{.stdcall,
    dynlib: "kernel32", importc: "_lwrite".}
proc hread*(hFile: HFILE, lpBuffer: LPVOID, lBytes: int32): int32{.stdcall,
    dynlib: "kernel32", importc: "_hread".}
proc hwrite*(hFile: HFILE, lpBuffer: LPCSTR, lBytes: int32): int32{.stdcall,
    dynlib: "kernel32", importc: "_hwrite".}
proc lclose*(file: HFILE): HFILE{.stdcall, dynlib: "kernel32",
                                   importc: "_lclose".}
proc llseek*(file: HFILE, lOffset: LONG, iOrigin: int32): LONG{.stdcall,
    dynlib: "kernel32", importc: "_llseek".}
proc IsTextUnicode*(lpBuffer: LPVOID, cb: int32, lpi: LPINT): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "IsTextUnicode".}
proc TlsAlloc*(): DWORD{.stdcall, dynlib: "kernel32", importc: "TlsAlloc".}
proc TlsGetValue*(dwTlsIndex: DWORD): LPVOID{.stdcall, dynlib: "kernel32",
    importc: "TlsGetValue".}
proc TlsSetValue*(dwTlsIndex: DWORD, lpTlsValue: LPVOID): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "TlsSetValue".}
proc TlsFree*(dwTlsIndex: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "TlsFree".}
proc SleepEx*(dwMilliseconds: DWORD, bAlertable: WINBOOL): DWORD{.stdcall,
    dynlib: "kernel32", importc: "SleepEx".}
proc WaitForSingleObjectEx*(hHandle: HANDLE, dwMilliseconds: DWORD,
                            bAlertable: WINBOOL): DWORD{.stdcall,
    dynlib: "kernel32", importc: "WaitForSingleObjectEx".}
proc WaitForMultipleObjectsEx*(nCount: DWORD, lpHandles: LPHANDLE,
                               bWaitAll: WINBOOL, dwMilliseconds: DWORD,
                               bAlertable: WINBOOL): DWORD{.stdcall,
    dynlib: "kernel32", importc: "WaitForMultipleObjectsEx".}
proc ReadFileEx*(hFile: HANDLE, lpBuffer: LPVOID, nNumberOfBytesToRead: DWORD,
                 lpOverlapped: LPOVERLAPPED,
                 lpCompletionRoutine: LPOVERLAPPED_COMPLETION_ROUTINE): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadFileEx".}
proc WriteFileEx*(hFile: HANDLE, lpBuffer: LPCVOID,
                  nNumberOfBytesToWrite: DWORD, lpOverlapped: LPOVERLAPPED,
                  lpCompletionRoutine: LPOVERLAPPED_COMPLETION_ROUTINE): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteFileEx".}
proc BackupRead*(hFile: HANDLE, lpBuffer: LPBYTE, nNumberOfBytesToRead: DWORD,
                 lpNumberOfBytesRead: LPDWORD, bAbort: WINBOOL,
                 bProcessSecurity: WINBOOL, lpContext: var LPVOID): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "BackupRead".}
proc BackupSeek*(hFile: HANDLE, dwLowBytesToSeek: DWORD,
                 dwHighBytesToSeek: DWORD, lpdwLowByteSeeked: LPDWORD,
                 lpdwHighByteSeeked: LPDWORD, lpContext: var LPVOID): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "BackupSeek".}
proc BackupWrite*(hFile: HANDLE, lpBuffer: LPBYTE, nNumberOfBytesToWrite: DWORD,
                  lpNumberOfBytesWritten: LPDWORD, bAbort: WINBOOL,
                  bProcessSecurity: WINBOOL, lpContext: var LPVOID): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "BackupWrite".}
proc SetProcessShutdownParameters*(dwLevel: DWORD, dwFlags: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetProcessShutdownParameters".}
proc GetProcessShutdownParameters*(lpdwLevel: LPDWORD, lpdwFlags: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetProcessShutdownParameters".}
proc SetFileApisToOEM*(){.stdcall, dynlib: "kernel32",
                          importc: "SetFileApisToOEM".}
proc SetFileApisToANSI*(){.stdcall, dynlib: "kernel32",
                           importc: "SetFileApisToANSI".}
proc AreFileApisANSI*(): WINBOOL{.stdcall, dynlib: "kernel32",
                                  importc: "AreFileApisANSI".}
proc CloseEventLog*(hEventLog: HANDLE): WINBOOL{.stdcall, dynlib: "advapi32",
    importc: "CloseEventLog".}
proc DeregisterEventSource*(hEventLog: HANDLE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "DeregisterEventSource".}
proc NotifyChangeEventLog*(hEventLog: HANDLE, hEvent: HANDLE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "NotifyChangeEventLog".}
proc GetNumberOfEventLogRecords*(hEventLog: HANDLE, NumberOfRecords: PDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetNumberOfEventLogRecords".}
proc GetOldestEventLogRecord*(hEventLog: HANDLE, OldestRecord: PDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetOldestEventLogRecord".}
proc DuplicateToken*(ExistingTokenHandle: HANDLE,
                     ImpersonationLevel: SECURITY_IMPERSONATION_LEVEL,
                     DuplicateTokenHandle: PHANDLE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "DuplicateToken".}
proc GetKernelObjectSecurity*(Handle: HANDLE,
                              RequestedInformation: SECURITY_INFORMATION,
                              pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                              nLength: DWORD, lpnLengthNeeded: LPDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetKernelObjectSecurity".}
proc ImpersonateNamedPipeClient*(hNamedPipe: HANDLE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ImpersonateNamedPipeClient".}
proc ImpersonateLoggedOnUser*(hToken: HANDLE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ImpersonateLoggedOnUser".}
proc ImpersonateSelf*(ImpersonationLevel: SECURITY_IMPERSONATION_LEVEL): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "ImpersonateSelf".}
proc RevertToSelf*(): WINBOOL{.stdcall, dynlib: "advapi32",
                               importc: "RevertToSelf".}
proc SetThreadToken*(Thread: PHANDLE, Token: HANDLE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "SetThreadToken".}
proc OpenProcessToken*(ProcessHandle: HANDLE, DesiredAccess: DWORD,
                       TokenHandle: PHANDLE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "OpenProcessToken".}
proc OpenThreadToken*(ThreadHandle: HANDLE, DesiredAccess: DWORD,
                      OpenAsSelf: WINBOOL, TokenHandle: PHANDLE): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "OpenThreadToken".}
proc GetTokenInformation*(TokenHandle: HANDLE,
                          TokenInformationClass: TOKEN_INFORMATION_CLASS,
                          TokenInformation: LPVOID,
                          TokenInformationLength: DWORD, ReturnLength: PDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetTokenInformation".}
proc SetTokenInformation*(TokenHandle: HANDLE,
                          TokenInformationClass: TOKEN_INFORMATION_CLASS,
                          TokenInformation: LPVOID,
                          TokenInformationLength: DWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "SetTokenInformation".}
proc AdjustTokenPrivileges*(TokenHandle: HANDLE, DisableAllPrivileges: WINBOOL,
                            NewState: PTOKEN_PRIVILEGES, BufferLength: DWORD,
                            PreviousState: PTOKEN_PRIVILEGES,
                            ReturnLength: PDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "AdjustTokenPrivileges".}
proc AdjustTokenGroups*(TokenHandle: HANDLE, ResetToDefault: WINBOOL,
                        NewState: PTOKEN_GROUPS, BufferLength: DWORD,
                        PreviousState: PTOKEN_GROUPS, ReturnLength: PDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "AdjustTokenGroups".}
proc PrivilegeCheck*(ClientToken: HANDLE, RequiredPrivileges: PPRIVILEGE_SET,
                     pfResult: LPBOOL): WINBOOL{.stdcall, dynlib: "advapi32",
    importc: "PrivilegeCheck".}
proc IsValidSid*(pSid: PSID): WINBOOL{.stdcall, dynlib: "advapi32",
                                       importc: "IsValidSid".}
proc EqualSid*(pSid1: PSID, pSid2: PSID): WINBOOL{.stdcall, dynlib: "advapi32",
    importc: "EqualSid".}
proc EqualPrefixSid*(pSid1: PSID, pSid2: PSID): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "EqualPrefixSid".}
proc GetSidLengthRequired*(nSubAuthorityCount: UCHAR): DWORD{.stdcall,
    dynlib: "advapi32", importc: "GetSidLengthRequired".}
proc AllocateAndInitializeSid*(pIdentifierAuthority: PSID_IDENTIFIER_AUTHORITY,
                               nSubAuthorityCount: int8, nSubAuthority0: DWORD,
                               nSubAuthority1: DWORD, nSubAuthority2: DWORD,
                               nSubAuthority3: DWORD, nSubAuthority4: DWORD,
                               nSubAuthority5: DWORD, nSubAuthority6: DWORD,
                               nSubAuthority7: DWORD, pSid: var PSID): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "AllocateAndInitializeSid".}
proc FreeSid*(pSid: PSID): PVOID{.stdcall, dynlib: "advapi32",
                                  importc: "FreeSid".}
proc InitializeSid*(Sid: PSID, pIdentifierAuthority: PSID_IDENTIFIER_AUTHORITY,
                    nSubAuthorityCount: int8): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "InitializeSid".}
proc GetSidIdentifierAuthority*(pSid: PSID): PSID_IDENTIFIER_AUTHORITY{.stdcall,
    dynlib: "advapi32", importc: "GetSidIdentifierAuthority".}
proc GetSidSubAuthority*(pSid: PSID, nSubAuthority: DWORD): PDWORD{.stdcall,
    dynlib: "advapi32", importc: "GetSidSubAuthority".}
proc GetSidSubAuthorityCount*(pSid: PSID): PUCHAR{.stdcall, dynlib: "advapi32",
    importc: "GetSidSubAuthorityCount".}
proc GetLengthSid*(pSid: PSID): DWORD{.stdcall, dynlib: "advapi32",
                                       importc: "GetLengthSid".}
proc CopySid*(nDestinationSidLength: DWORD, pDestinationSid: PSID,
              pSourceSid: PSID): WINBOOL{.stdcall, dynlib: "advapi32",
    importc: "CopySid".}
proc AreAllAccessesGranted*(GrantedAccess: DWORD, DesiredAccess: DWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "AreAllAccessesGranted".}
proc AreAnyAccessesGranted*(GrantedAccess: DWORD, DesiredAccess: DWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "AreAnyAccessesGranted".}
proc MapGenericMask*(AccessMask: PDWORD, GenericMapping: PGENERIC_MAPPING){.
    stdcall, dynlib: "advapi32", importc: "MapGenericMask".}
proc IsValidAcl*(pAcl: PACL): WINBOOL{.stdcall, dynlib: "advapi32",
                                       importc: "IsValidAcl".}
proc InitializeAcl*(pAcl: PACL, nAclLength: DWORD, dwAclRevision: DWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "InitializeAcl".}
proc GetAclInformation*(pAcl: PACL, pAclInformation: LPVOID,
                        nAclInformationLength: DWORD,
                        dwAclInformationClass: ACL_INFORMATION_CLASS): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetAclInformation".}
proc SetAclInformation*(pAcl: PACL, pAclInformation: LPVOID,
                        nAclInformationLength: DWORD,
                        dwAclInformationClass: ACL_INFORMATION_CLASS): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "SetAclInformation".}
proc AddAce*(pAcl: PACL, dwAceRevision: DWORD, dwStartingAceIndex: DWORD,
             pAceList: LPVOID, nAceListLength: DWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "AddAce".}
proc DeleteAce*(pAcl: PACL, dwAceIndex: DWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "DeleteAce".}
proc GetAce*(pAcl: PACL, dwAceIndex: DWORD, pAce: var LPVOID): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "GetAce".}
proc AddAccessAllowedAce*(pAcl: PACL, dwAceRevision: DWORD, AccessMask: DWORD,
                          pSid: PSID): WINBOOL{.stdcall, dynlib: "advapi32",
    importc: "AddAccessAllowedAce".}
proc AddAccessDeniedAce*(pAcl: PACL, dwAceRevision: DWORD, AccessMask: DWORD,
                         pSid: PSID): WINBOOL{.stdcall, dynlib: "advapi32",
    importc: "AddAccessDeniedAce".}
proc AddAuditAccessAce*(pAcl: PACL, dwAceRevision: DWORD, dwAccessMask: DWORD,
                        pSid: PSID, bAuditSuccess: WINBOOL,
                        bAuditFailure: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "AddAuditAccessAce".}
proc FindFirstFreeAce*(pAcl: PACL, pAce: var LPVOID): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "FindFirstFreeAce".}
proc InitializeSecurityDescriptor*(pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                                   dwRevision: DWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "InitializeSecurityDescriptor".}
proc IsValidSecurityDescriptor*(pSecurityDescriptor: PSECURITY_DESCRIPTOR): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "IsValidSecurityDescriptor".}
proc GetSecurityDescriptorLength*(pSecurityDescriptor: PSECURITY_DESCRIPTOR): DWORD{.
    stdcall, dynlib: "advapi32", importc: "GetSecurityDescriptorLength".}
proc GetSecurityDescriptorControl*(pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                                   pControl: PSECURITY_DESCRIPTOR_CONTROL,
                                   lpdwRevision: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "GetSecurityDescriptorControl".}
proc SetSecurityDescriptorDacl*(pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                                bDaclPresent: WINBOOL, pDacl: PACL,
                                bDaclDefaulted: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "SetSecurityDescriptorDacl".}
proc GetSecurityDescriptorDacl*(pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                                lpbDaclPresent: LPBOOL, pDacl: var PACL,
                                lpbDaclDefaulted: LPBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "GetSecurityDescriptorDacl".}
proc SetSecurityDescriptorSacl*(pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                                bSaclPresent: WINBOOL, pSacl: PACL,
                                bSaclDefaulted: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "SetSecurityDescriptorSacl".}
proc GetSecurityDescriptorSacl*(pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                                lpbSaclPresent: LPBOOL, pSacl: var PACL,
                                lpbSaclDefaulted: LPBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "GetSecurityDescriptorSacl".}
proc SetSecurityDescriptorOwner*(pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                                 pOwner: PSID, bOwnerDefaulted: WINBOOL): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "SetSecurityDescriptorOwner".}
proc GetSecurityDescriptorOwner*(pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                                 pOwner: var PSID, lpbOwnerDefaulted: LPBOOL): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetSecurityDescriptorOwner".}
proc SetSecurityDescriptorGroup*(pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                                 pGroup: PSID, bGroupDefaulted: WINBOOL): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "SetSecurityDescriptorGroup".}
proc GetSecurityDescriptorGroup*(pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                                 pGroup: var PSID, lpbGroupDefaulted: LPBOOL): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetSecurityDescriptorGroup".}
proc CreatePrivateObjectSecurity*(ParentDescriptor: PSECURITY_DESCRIPTOR,
                                  CreatorDescriptor: PSECURITY_DESCRIPTOR,
                                  NewDescriptor: var PSECURITY_DESCRIPTOR,
                                  IsDirectoryObject: WINBOOL, Token: HANDLE,
                                  GenericMapping: PGENERIC_MAPPING): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "CreatePrivateObjectSecurity".}
proc SetPrivateObjectSecurity*(SecurityInformation: SECURITY_INFORMATION,
                               ModificationDescriptor: PSECURITY_DESCRIPTOR,
    ObjectsSecurityDescriptor: var PSECURITY_DESCRIPTOR,
                               GenericMapping: PGENERIC_MAPPING, Token: HANDLE): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "SetPrivateObjectSecurity".}
proc GetPrivateObjectSecurity*(ObjectDescriptor: PSECURITY_DESCRIPTOR,
                               SecurityInformation: SECURITY_INFORMATION,
                               ResultantDescriptor: PSECURITY_DESCRIPTOR,
                               DescriptorLength: DWORD, ReturnLength: PDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "GetPrivateObjectSecurity".}
proc DestroyPrivateObjectSecurity*(ObjectDescriptor: PSECURITY_DESCRIPTOR): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "DestroyPrivateObjectSecurity".}
proc MakeSelfRelativeSD*(pAbsoluteSecurityDescriptor: PSECURITY_DESCRIPTOR,
                         pSelfRelativeSecurityDescriptor: PSECURITY_DESCRIPTOR,
                         lpdwBufferLength: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "MakeSelfRelativeSD".}
proc MakeAbsoluteSD*(pSelfRelativeSecurityDescriptor: PSECURITY_DESCRIPTOR,
                     pAbsoluteSecurityDescriptor: PSECURITY_DESCRIPTOR,
                     lpdwAbsoluteSecurityDescriptorSize: LPDWORD, pDacl: PACL,
                     lpdwDaclSize: LPDWORD, pSacl: PACL, lpdwSaclSize: LPDWORD,
                     pOwner: PSID, lpdwOwnerSize: LPDWORD, pPrimaryGroup: PSID,
                     lpdwPrimaryGroupSize: LPDWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "MakeAbsoluteSD".}
proc SetKernelObjectSecurity*(Handle: HANDLE,
                              SecurityInformation: SECURITY_INFORMATION,
                              SecurityDescriptor: PSECURITY_DESCRIPTOR): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "SetKernelObjectSecurity".}
proc FindNextChangeNotification*(hChangeHandle: HANDLE): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "FindNextChangeNotification".}
proc FindCloseChangeNotification*(hChangeHandle: HANDLE): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "FindCloseChangeNotification".}
proc VirtualLock*(lpAddress: LPVOID, dwSize: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "VirtualLock".}
proc VirtualUnlock*(lpAddress: LPVOID, dwSize: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "VirtualUnlock".}
proc MapViewOfFileEx*(hFileMappingObject: HANDLE, dwDesiredAccess: DWORD,
                      dwFileOffsetHigh: DWORD, dwFileOffsetLow: DWORD,
                      dwNumberOfBytesToMap: DWORD, lpBaseAddress: LPVOID): LPVOID{.
    stdcall, dynlib: "kernel32", importc: "MapViewOfFileEx".}
proc SetPriorityClass*(hProcess: HANDLE, dwPriorityClass: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetPriorityClass".}
proc GetPriorityClass*(hProcess: HANDLE): DWORD{.stdcall, dynlib: "kernel32",
    importc: "GetPriorityClass".}
proc IsBadReadPtr*(lp: pointer, ucb: UINT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "IsBadReadPtr".}
proc IsBadWritePtr*(lp: LPVOID, ucb: UINT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "IsBadWritePtr".}
proc IsBadHugeReadPtr*(lp: pointer, ucb: UINT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "IsBadHugeReadPtr".}
proc IsBadHugeWritePtr*(lp: LPVOID, ucb: UINT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "IsBadHugeWritePtr".}
proc IsBadCodePtr*(lpfn: FARPROC): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "IsBadCodePtr".}
proc AllocateLocallyUniqueId*(Luid: PLUID): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "AllocateLocallyUniqueId".}
proc QueryPerformanceCounter*(lpPerformanceCount: PLARGE_INTEGER): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "QueryPerformanceCounter".}
proc QueryPerformanceFrequency*(lpFrequency: PLARGE_INTEGER): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "QueryPerformanceFrequency".}
proc ActivateKeyboardLayout*(hkl: HKL, Flags: UINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "ActivateKeyboardLayout".}
proc UnloadKeyboardLayout*(hkl: HKL): WINBOOL{.stdcall, dynlib: "user32",
    importc: "UnloadKeyboardLayout".}
proc GetKeyboardLayoutList*(nBuff: int32, lpList: var HKL): int32{.stdcall,
    dynlib: "user32", importc: "GetKeyboardLayoutList".}
proc GetKeyboardLayout*(dwLayout: DWORD): HKL{.stdcall, dynlib: "user32",
    importc: "GetKeyboardLayout".}
proc OpenInputDesktop*(dwFlags: DWORD, fInherit: WINBOOL, dwDesiredAccess: DWORD): HDESK{.
    stdcall, dynlib: "user32", importc: "OpenInputDesktop".}
proc EnumDesktopWindows*(hDesktop: HDESK, lpfn: ENUMWINDOWSPROC, lp: LPARAM): WINBOOL{.
    stdcall, dynlib: "user32", importc: "EnumDesktopWindows".}
proc SwitchDesktop*(hDesktop: HDESK): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SwitchDesktop".}
proc SetThreadDesktop*(hDesktop: HDESK): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SetThreadDesktop".}
proc CloseDesktop*(hDesktop: HDESK): WINBOOL{.stdcall, dynlib: "user32",
    importc: "CloseDesktop".}
proc GetThreadDesktop*(dwThreadId: DWORD): HDESK{.stdcall, dynlib: "user32",
    importc: "GetThreadDesktop".}
proc CloseWindowStation*(hWinSta: HWINSTA): WINBOOL{.stdcall, dynlib: "user32",
    importc: "CloseWindowStation".}
proc SetProcessWindowStation*(hWinSta: HWINSTA): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetProcessWindowStation".}
proc GetProcessWindowStation*(): HWINSTA{.stdcall, dynlib: "user32",
    importc: "GetProcessWindowStation".}
proc SetUserObjectSecurity*(hObj: HANDLE, pSIRequested: PSECURITY_INFORMATION,
                            pSID: PSECURITY_DESCRIPTOR): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetUserObjectSecurity".}
proc GetUserObjectSecurity*(hObj: HANDLE, pSIRequested: PSECURITY_INFORMATION,
                            pSID: PSECURITY_DESCRIPTOR, nLength: DWORD,
                            lpnLengthNeeded: LPDWORD): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetUserObjectSecurity".}
proc TranslateMessage*(lpMsg: LPMSG): WINBOOL{.stdcall, dynlib: "user32",
    importc: "TranslateMessage".}
proc SetMessageQueue*(cMessagesMax: int32): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SetMessageQueue".}
proc RegisterHotKey*(wnd: HWND, anID: int32, fsModifiers: UINT, vk: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "RegisterHotKey".}
proc UnregisterHotKey*(wnd: HWND, anID: int32): WINBOOL{.stdcall,
    dynlib: "user32", importc: "UnregisterHotKey".}
proc ExitWindowsEx*(uFlags: UINT, dwReserved: DWORD): WINBOOL{.stdcall,
    dynlib: "user32", importc: "ExitWindowsEx".}
proc SwapMouseButton*(fSwap: WINBOOL): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SwapMouseButton".}
proc GetMessagePos*(): DWORD{.stdcall, dynlib: "user32",
                              importc: "GetMessagePos".}
proc GetMessageTime*(): LONG{.stdcall, dynlib: "user32",
                              importc: "GetMessageTime".}
proc GetMessageExtraInfo*(): LONG{.stdcall, dynlib: "user32",
                                   importc: "GetMessageExtraInfo".}
proc SetMessageExtraInfo*(lp: LPARAM): LPARAM{.stdcall, dynlib: "user32",
    importc: "SetMessageExtraInfo".}
proc BroadcastSystemMessage*(para1: DWORD, para2: LPDWORD, para3: UINT,
                             para4: WPARAM, para5: LPARAM): int32{.stdcall,
    dynlib: "user32", importc: "BroadcastSystemMessage".}
proc AttachThreadInput*(idAttach: DWORD, idAttachTo: DWORD, fAttach: WINBOOL): WINBOOL{.
    stdcall, dynlib: "user32", importc: "AttachThreadInput".}
proc ReplyMessage*(lResult: LRESULT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "ReplyMessage".}
proc WaitMessage*(): WINBOOL{.stdcall, dynlib: "user32", importc: "WaitMessage".}
proc WaitForInputIdle*(hProcess: HANDLE, dwMilliseconds: DWORD): DWORD{.stdcall,
    dynlib: "user32", importc: "WaitForInputIdle".}
proc PostQuitMessage*(nExitCode: int32){.stdcall, dynlib: "user32",
    importc: "PostQuitMessage".}
proc InSendMessage*(): WINBOOL{.stdcall, dynlib: "user32",
                                importc: "InSendMessage".}
proc GetDoubleClickTime*(): UINT{.stdcall, dynlib: "user32",
                                  importc: "GetDoubleClickTime".}
proc SetDoubleClickTime*(para1: UINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SetDoubleClickTime".}
proc IsWindow*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
                                     importc: "IsWindow".}
proc IsMenu*(menu: HMENU): WINBOOL{.stdcall, dynlib: "user32",
                                     importc: "IsMenu".}
proc IsChild*(hWndParent: HWND, wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
    importc: "IsChild".}
proc DestroyWindow*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DestroyWindow".}
proc ShowWindow*(wnd: HWND, nCmdShow: int32): WINBOOL{.stdcall,
    dynlib: "user32", importc: "ShowWindow".}
proc ShowWindowAsync*(wnd: HWND, nCmdShow: int32): WINBOOL{.stdcall,
    dynlib: "user32", importc: "ShowWindowAsync".}
proc FlashWindow*(wnd: HWND, bInvert: WINBOOL): WINBOOL{.stdcall,
    dynlib: "user32", importc: "FlashWindow".}
proc ShowOwnedPopups*(wnd: HWND, fShow: WINBOOL): WINBOOL{.stdcall,
    dynlib: "user32", importc: "ShowOwnedPopups".}
proc OpenIcon*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
                                     importc: "OpenIcon".}
proc CloseWindow*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
                                        importc: "CloseWindow".}
proc MoveWindow*(wnd: HWND, X: int32, Y: int32, nWidth: int32, nHeight: int32,
                 bRepaint: WINBOOL): WINBOOL{.stdcall, dynlib: "user32",
    importc: "MoveWindow".}
proc SetWindowPos*(wnd: HWND, hWndInsertAfter: HWND, X: int32, Y: int32,
                   cx: int32, cy: int32, uFlags: UINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetWindowPos".}
proc GetWindowPlacement*(wnd: HWND, lpwndpl: var WINDOWPLACEMENT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetWindowPlacement".}
proc SetWindowPlacement*(wnd: HWND, lpwndpl: var WINDOWPLACEMENT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SetWindowPlacement".}
proc GetWindowPlacement*(wnd: HWND, lpwndpl: PWINDOWPLACEMENT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetWindowPlacement".}
proc SetWindowPlacement*(wnd: HWND, lpwndpl: PWINDOWPLACEMENT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SetWindowPlacement".}
proc BeginDeferWindowPos*(nNumWindows: int32): HDWP{.stdcall, dynlib: "user32",
    importc: "BeginDeferWindowPos".}
proc DeferWindowPos*(hWinPosInfo: HDWP, wnd: HWND, hWndInsertAfter: HWND,
                     x: int32, y: int32, cx: int32, cy: int32, uFlags: UINT): HDWP{.
    stdcall, dynlib: "user32", importc: "DeferWindowPos".}
proc EndDeferWindowPos*(hWinPosInfo: HDWP): WINBOOL{.stdcall, dynlib: "user32",
    importc: "EndDeferWindowPos".}
proc IsWindowVisible*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
    importc: "IsWindowVisible".}
proc IsIconic*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
                                     importc: "IsIconic".}
proc AnyPopup*(): WINBOOL{.stdcall, dynlib: "user32", importc: "AnyPopup".}
proc BringWindowToTop*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
    importc: "BringWindowToTop".}
proc IsZoomed*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
                                     importc: "IsZoomed".}
proc EndDialog*(hDlg: HWND, nResult: int32): WINBOOL{.stdcall, dynlib: "user32",
    importc: "EndDialog".}
proc GetDlgItem*(hDlg: HWND, nIDDlgItem: int32): HWND{.stdcall,
    dynlib: "user32", importc: "GetDlgItem".}
proc SetDlgItemInt*(hDlg: HWND, nIDDlgItem: int32, uValue: UINT,
                    bSigned: WINBOOL): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SetDlgItemInt".}
proc GetDlgItemInt*(hDlg: HWND, nIDDlgItem: int32, lpTranslated: var WINBOOL,
                    bSigned: WINBOOL): UINT{.stdcall, dynlib: "user32",
    importc: "GetDlgItemInt".}
proc CheckDlgButton*(hDlg: HWND, nIDButton: int32, uCheck: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "CheckDlgButton".}
proc CheckRadioButton*(hDlg: HWND, nIDFirstButton: int32, nIDLastButton: int32,
                       nIDCheckButton: int32): WINBOOL{.stdcall,
    dynlib: "user32", importc: "CheckRadioButton".}
proc IsDlgButtonChecked*(hDlg: HWND, nIDButton: int32): UINT{.stdcall,
    dynlib: "user32", importc: "IsDlgButtonChecked".}
proc GetNextDlgGroupItem*(hDlg: HWND, hCtl: HWND, bPrevious: WINBOOL): HWND{.
    stdcall, dynlib: "user32", importc: "GetNextDlgGroupItem".}
proc GetNextDlgTabItem*(hDlg: HWND, hCtl: HWND, bPrevious: WINBOOL): HWND{.
    stdcall, dynlib: "user32", importc: "GetNextDlgTabItem".}
proc GetDlgCtrlID*(wnd: HWND): int32{.stdcall, dynlib: "user32",
                                       importc: "GetDlgCtrlID".}
proc GetDialogBaseUnits*(): int32{.stdcall, dynlib: "user32",
                                   importc: "GetDialogBaseUnits".}
proc OpenClipboard*(hWndNewOwner: HWND): WINBOOL{.stdcall, dynlib: "user32",
    importc: "OpenClipboard".}
proc CloseClipboard*(): WINBOOL{.stdcall, dynlib: "user32",
                                 importc: "CloseClipboard".}
proc GetClipboardOwner*(): HWND{.stdcall, dynlib: "user32",
                                 importc: "GetClipboardOwner".}
proc SetClipboardViewer*(hWndNewViewer: HWND): HWND{.stdcall, dynlib: "user32",
    importc: "SetClipboardViewer".}
proc GetClipboardViewer*(): HWND{.stdcall, dynlib: "user32",
                                  importc: "GetClipboardViewer".}
proc ChangeClipboardChain*(hWndRemove: HWND, hWndNewNext: HWND): WINBOOL{.
    stdcall, dynlib: "user32", importc: "ChangeClipboardChain".}
proc SetClipboardData*(uFormat: UINT, hMem: HANDLE): HANDLE{.stdcall,
    dynlib: "user32", importc: "SetClipboardData".}
proc GetClipboardData*(uFormat: UINT): HANDLE{.stdcall, dynlib: "user32",
    importc: "GetClipboardData".}
proc CountClipboardFormats*(): int32{.stdcall, dynlib: "user32",
                                      importc: "CountClipboardFormats".}
proc EnumClipboardFormats*(format: UINT): UINT{.stdcall, dynlib: "user32",
    importc: "EnumClipboardFormats".}
proc EmptyClipboard*(): WINBOOL{.stdcall, dynlib: "user32",
                                 importc: "EmptyClipboard".}
proc IsClipboardFormatAvailable*(format: UINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "IsClipboardFormatAvailable".}
proc GetPriorityClipboardFormat*(paFormatPriorityList: var UINT, cFormats: int32): int32{.
    stdcall, dynlib: "user32", importc: "GetPriorityClipboardFormat".}
proc GetOpenClipboardWindow*(): HWND{.stdcall, dynlib: "user32",
                                      importc: "GetOpenClipboardWindow".}
proc CharNextExA*(CodePage: int16, lpCurrentChar: LPCSTR, dwFlags: DWORD): LPSTR{.
    stdcall, dynlib: "user32", importc: "CharNextExA".}
proc CharPrevExA*(CodePage: int16, lpStart: LPCSTR, lpCurrentChar: LPCSTR,
                  dwFlags: DWORD): LPSTR{.stdcall, dynlib: "user32",
    importc: "CharPrevExA".}
proc SetFocus*(wnd: HWND): HWND{.stdcall, dynlib: "user32", importc: "SetFocus".}
proc GetActiveWindow*(): HWND{.stdcall, dynlib: "user32",
                               importc: "GetActiveWindow".}
proc GetFocus*(): HWND{.stdcall, dynlib: "user32", importc: "GetFocus".}
proc GetKBCodePage*(): UINT{.stdcall, dynlib: "user32", importc: "GetKBCodePage".}
proc GetKeyState*(nVirtKey: int32): SHORT{.stdcall, dynlib: "user32",
    importc: "GetKeyState".}
proc GetAsyncKeyState*(vKey: int32): SHORT{.stdcall, dynlib: "user32",
    importc: "GetAsyncKeyState".}
proc GetKeyboardState*(lpKeyState: PBYTE): WINBOOL{.stdcall, dynlib: "user32",
    importc: "GetKeyboardState".}
proc SetKeyboardState*(lpKeyState: LPBYTE): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SetKeyboardState".}
proc GetKeyboardType*(nTypeFlag: int32): int32{.stdcall, dynlib: "user32",
    importc: "GetKeyboardType".}
proc ToAscii*(uVirtKey: UINT, uScanCode: UINT, lpKeyState: PBYTE,
              lpChar: LPWORD, uFlags: UINT): int32{.stdcall, dynlib: "user32",
    importc: "ToAscii".}
proc ToAsciiEx*(uVirtKey: UINT, uScanCode: UINT, lpKeyState: PBYTE,
                lpChar: LPWORD, uFlags: UINT, dwhkl: HKL): int32{.stdcall,
    dynlib: "user32", importc: "ToAsciiEx".}
proc ToUnicode*(wVirtKey: UINT, wScanCode: UINT, lpKeyState: PBYTE,
                pwszBuff: LPWSTR, cchBuff: int32, wFlags: UINT): int32{.stdcall,
    dynlib: "user32", importc: "ToUnicode".}
proc OemKeyScan*(wOemChar: int16): DWORD{.stdcall, dynlib: "user32",
    importc: "OemKeyScan".}
proc keybd_event*(bVk: int8, bScan: int8, dwFlags: DWORD, dwExtraInfo: DWORD){.
    stdcall, dynlib: "user32", importc: "keybd_event".}
proc mouse_event*(dwFlags: DWORD, dx: DWORD, dy: DWORD, cButtons: DWORD,
                  dwExtraInfo: DWORD){.stdcall, dynlib: "user32",
                                       importc: "mouse_event".}
proc GetInputState*(): WINBOOL{.stdcall, dynlib: "user32",
                                importc: "GetInputState".}
proc GetQueueStatus*(flags: UINT): DWORD{.stdcall, dynlib: "user32",
    importc: "GetQueueStatus".}
proc GetCapture*(): HWND{.stdcall, dynlib: "user32", importc: "GetCapture".}
proc SetCapture*(wnd: HWND): HWND{.stdcall, dynlib: "user32",
                                    importc: "SetCapture".}
proc ReleaseCapture*(): WINBOOL{.stdcall, dynlib: "user32",
                                 importc: "ReleaseCapture".}
proc MsgWaitForMultipleObjects*(nCount: DWORD, pHandles: LPHANDLE,
                                fWaitAll: WINBOOL, dwMilliseconds: DWORD,
                                dwWakeMask: DWORD): DWORD{.stdcall,
    dynlib: "user32", importc: "MsgWaitForMultipleObjects".}
proc SetTimer*(wnd: HWND, nIDEvent: UINT, uElapse: UINT, lpTimerFunc: TIMERPROC): UINT{.
    stdcall, dynlib: "user32", importc: "SetTimer".}
proc KillTimer*(wnd: HWND, uIDEvent: UINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "KillTimer".}
proc IsWindowUnicode*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
    importc: "IsWindowUnicode".}
proc EnableWindow*(wnd: HWND, bEnable: WINBOOL): WINBOOL{.stdcall,
    dynlib: "user32", importc: "EnableWindow".}
proc IsWindowEnabled*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
    importc: "IsWindowEnabled".}
proc DestroyAcceleratorTable*(hAccel: HACCEL): WINBOOL{.stdcall,
    dynlib: "user32", importc: "DestroyAcceleratorTable".}
proc GetSystemMetrics*(nIndex: int32): int32{.stdcall, dynlib: "user32",
    importc: "GetSystemMetrics".}
proc GetMenu*(wnd: HWND): HMENU{.stdcall, dynlib: "user32", importc: "GetMenu".}
proc SetMenu*(wnd: HWND, menu: HMENU): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SetMenu".}
proc HiliteMenuItem*(wnd: HWND, menu: HMENU, uIDHiliteItem: UINT,
                     uHilite: UINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "HiliteMenuItem".}
proc GetMenuState*(menu: HMENU, uId: UINT, uFlags: UINT): UINT{.stdcall,
    dynlib: "user32", importc: "GetMenuState".}
proc DrawMenuBar*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
                                        importc: "DrawMenuBar".}
proc GetSystemMenu*(wnd: HWND, bRevert: WINBOOL): HMENU{.stdcall,
    dynlib: "user32", importc: "GetSystemMenu".}
proc CreateMenu*(): HMENU{.stdcall, dynlib: "user32", importc: "CreateMenu".}
proc CreatePopupMenu*(): HMENU{.stdcall, dynlib: "user32",
                                importc: "CreatePopupMenu".}
proc DestroyMenu*(menu: HMENU): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DestroyMenu".}
proc CheckMenuItem*(menu: HMENU, uIDCheckItem: UINT, uCheck: UINT): DWORD{.
    stdcall, dynlib: "user32", importc: "CheckMenuItem".}
proc EnableMenuItem*(menu: HMENU, uIDEnableItem: UINT, uEnable: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "EnableMenuItem".}
proc GetSubMenu*(menu: HMENU, nPos: int32): HMENU{.stdcall, dynlib: "user32",
    importc: "GetSubMenu".}
proc GetMenuItemID*(menu: HMENU, nPos: int32): UINT{.stdcall, dynlib: "user32",
    importc: "GetMenuItemID".}
proc GetMenuItemCount*(menu: HMENU): int32{.stdcall, dynlib: "user32",
    importc: "GetMenuItemCount".}
proc RemoveMenu*(menu: HMENU, uPosition: UINT, uFlags: UINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "RemoveMenu".}
proc DeleteMenu*(menu: HMENU, uPosition: UINT, uFlags: UINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "DeleteMenu".}
proc SetMenuItemBitmaps*(menu: HMENU, uPosition: UINT, uFlags: UINT,
                         hBitmapUnchecked: HBITMAP, hBitmapChecked: HBITMAP): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SetMenuItemBitmaps".}
proc GetMenuCheckMarkDimensions*(): LONG{.stdcall, dynlib: "user32",
    importc: "GetMenuCheckMarkDimensions".}
proc TrackPopupMenu*(menu: HMENU, uFlags: UINT, x: int32, y: int32,
                     nReserved: int32, wnd: HWND, prcRect: var RECT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "TrackPopupMenu".}
proc GetMenuDefaultItem*(menu: HMENU, fByPos: UINT, gmdiFlags: UINT): UINT{.
    stdcall, dynlib: "user32", importc: "GetMenuDefaultItem".}
proc SetMenuDefaultItem*(menu: HMENU, uItem: UINT, fByPos: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SetMenuDefaultItem".}
proc GetMenuItemRect*(wnd: HWND, menu: HMENU, uItem: UINT, lprcItem: LPRECT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetMenuItemRect".}
proc MenuItemFromPoint*(wnd: HWND, menu: HMENU, ptScreen: POINT): int32{.
    stdcall, dynlib: "user32", importc: "MenuItemFromPoint".}
proc DragObject*(para1: HWND, para2: HWND, para3: UINT, para4: DWORD,
                 para5: HCURSOR): DWORD{.stdcall, dynlib: "user32",
    importc: "DragObject".}
proc DragDetect*(wnd: HWND, pt: POINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DragDetect".}
proc DrawIcon*(hDC: HDC, X: int32, Y: int32, icon: HICON): WINBOOL{.stdcall,
    dynlib: "user32", importc: "DrawIcon".}
proc UpdateWindow*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
    importc: "UpdateWindow".}
proc SetActiveWindow*(wnd: HWND): HWND{.stdcall, dynlib: "user32",
    importc: "SetActiveWindow".}
proc GetForegroundWindow*(): HWND{.stdcall, dynlib: "user32",
                                   importc: "GetForegroundWindow".}
proc PaintDesktop*(hdc: HDC): WINBOOL{.stdcall, dynlib: "user32",
                                       importc: "PaintDesktop".}
proc SetForegroundWindow*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SetForegroundWindow".}
proc WindowFromDC*(hDC: HDC): HWND{.stdcall, dynlib: "user32",
                                    importc: "WindowFromDC".}
proc GetDC*(wnd: HWND): HDC{.stdcall, dynlib: "user32", importc: "GetDC".}
proc GetDCEx*(wnd: HWND, hrgnClip: HRGN, flags: DWORD): HDC{.stdcall,
    dynlib: "user32", importc: "GetDCEx".}
proc GetWindowDC*(wnd: HWND): HDC{.stdcall, dynlib: "user32",
                                    importc: "GetWindowDC".}
proc ReleaseDC*(wnd: HWND, hDC: HDC): int32{.stdcall, dynlib: "user32",
    importc: "ReleaseDC".}
proc BeginPaint*(wnd: HWND, lpPaint: LPPAINTSTRUCT): HDC{.stdcall,
    dynlib: "user32", importc: "BeginPaint".}
proc EndPaint*(wnd: HWND, lpPaint: LPPAINTSTRUCT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "EndPaint".}
proc GetUpdateRect*(wnd: HWND, lpRect: LPRECT, bErase: WINBOOL): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetUpdateRect".}
proc GetUpdateRgn*(wnd: HWND, hRgn: HRGN, bErase: WINBOOL): int32{.stdcall,
    dynlib: "user32", importc: "GetUpdateRgn".}
proc SetWindowRgn*(wnd: HWND, hRgn: HRGN, bRedraw: WINBOOL): int32{.stdcall,
    dynlib: "user32", importc: "SetWindowRgn".}
proc GetWindowRgn*(wnd: HWND, hRgn: HRGN): int32{.stdcall, dynlib: "user32",
    importc: "GetWindowRgn".}
proc ExcludeUpdateRgn*(hDC: HDC, wnd: HWND): int32{.stdcall, dynlib: "user32",
    importc: "ExcludeUpdateRgn".}
proc InvalidateRect*(wnd: HWND, lpRect: var RECT, bErase: WINBOOL): WINBOOL{.
    stdcall, dynlib: "user32", importc: "InvalidateRect".}
proc InvalidateRect*(wnd: HWND, lpRect: LPRECT, bErase: WINBOOL): WINBOOL{.
    stdcall, dynlib: "user32", importc: "InvalidateRect".}
proc ValidateRect*(wnd: HWND, lpRect: var RECT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "ValidateRect".}
proc ValidateRect*(wnd: HWND, lpRect: LPRECT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "ValidateRect".}
proc InvalidateRgn*(wnd: HWND, hRgn: HRGN, bErase: WINBOOL): WINBOOL{.stdcall,
    dynlib: "user32", importc: "InvalidateRgn".}
proc ValidateRgn*(wnd: HWND, hRgn: HRGN): WINBOOL{.stdcall, dynlib: "user32",
    importc: "ValidateRgn".}
proc RedrawWindow*(wnd: HWND, lprcUpdate: var RECT, hrgnUpdate: HRGN,
                   flags: UINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "RedrawWindow".}
proc RedrawWindow*(wnd: HWND, lprcUpdate: LPRECT, hrgnUpdate: HRGN, flags: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "RedrawWindow".}
proc LockWindowUpdate*(hWndLock: HWND): WINBOOL{.stdcall, dynlib: "user32",
    importc: "LockWindowUpdate".}
proc ScrollWindow*(wnd: HWND, XAmount: int32, YAmount: int32, lpRect: var RECT,
                   lpClipRect: var RECT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "ScrollWindow".}
proc ScrollDC*(hDC: HDC, dx: int32, dy: int32, lprcScroll: var RECT,
               lprcClip: var RECT, hrgnUpdate: HRGN, lprcUpdate: LPRECT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "ScrollDC".}
proc ScrollWindowEx*(wnd: HWND, dx: int32, dy: int32, prcScroll: var RECT,
                     prcClip: var RECT, hrgnUpdate: HRGN, prcUpdate: LPRECT,
                     flags: UINT): int32{.stdcall, dynlib: "user32",
    importc: "ScrollWindowEx".}
proc SetScrollPos*(wnd: HWND, nBar: int32, nPos: int32, bRedraw: WINBOOL): int32{.
    stdcall, dynlib: "user32", importc: "SetScrollPos".}
proc GetScrollPos*(wnd: HWND, nBar: int32): int32{.stdcall, dynlib: "user32",
    importc: "GetScrollPos".}
proc SetScrollRange*(wnd: HWND, nBar: int32, nMinPos: int32, nMaxPos: int32,
                     bRedraw: WINBOOL): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SetScrollRange".}
proc GetScrollRange*(wnd: HWND, nBar: int32, lpMinPos: LPINT, lpMaxPos: LPINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetScrollRange".}
proc ShowScrollBar*(wnd: HWND, wBar: int32, bShow: WINBOOL): WINBOOL{.stdcall,
    dynlib: "user32", importc: "ShowScrollBar".}
proc EnableScrollBar*(wnd: HWND, wSBflags: UINT, wArrows: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "EnableScrollBar".}
proc GetClientRect*(wnd: HWND, lpRect: LPRECT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetClientRect".}
proc GetWindowRect*(wnd: HWND, lpRect: LPRECT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetWindowRect".}
proc AdjustWindowRect*(lpRect: LPRECT, dwStyle: DWORD, bMenu: WINBOOL): WINBOOL{.
    stdcall, dynlib: "user32", importc: "AdjustWindowRect".}
proc AdjustWindowRectEx*(lpRect: LPRECT, dwStyle: DWORD, bMenu: WINBOOL,
                         dwExStyle: DWORD): WINBOOL{.stdcall, dynlib: "user32",
    importc: "AdjustWindowRectEx".}
proc SetWindowContextHelpId*(para1: HWND, para2: DWORD): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetWindowContextHelpId".}
proc GetWindowContextHelpId*(para1: HWND): DWORD{.stdcall, dynlib: "user32",
    importc: "GetWindowContextHelpId".}
proc SetMenuContextHelpId*(para1: HMENU, para2: DWORD): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetMenuContextHelpId".}
proc GetMenuContextHelpId*(para1: HMENU): DWORD{.stdcall, dynlib: "user32",
    importc: "GetMenuContextHelpId".}
proc MessageBeep*(uType: UINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "MessageBeep".}
proc ShowCursor*(bShow: WINBOOL): int32{.stdcall, dynlib: "user32",
    importc: "ShowCursor".}
proc SetCursorPos*(X: int32, Y: int32): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SetCursorPos".}
proc SetCursor*(cursor: HCURSOR): HCURSOR{.stdcall, dynlib: "user32",
    importc: "SetCursor".}
proc GetCursorPos*(lpPoint: LPPOINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "GetCursorPos".}
proc ClipCursor*(lpRect: LPRECT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "ClipCursor".}
proc GetClipCursor*(lpRect: LPRECT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "GetClipCursor".}
proc GetCursor*(): HCURSOR{.stdcall, dynlib: "user32", importc: "GetCursor".}
proc CreateCaret*(wnd: HWND, hBitmap: HBITMAP, nWidth: int32, nHeight: int32): WINBOOL{.
    stdcall, dynlib: "user32", importc: "CreateCaret".}
proc GetCaretBlinkTime*(): UINT{.stdcall, dynlib: "user32",
                                 importc: "GetCaretBlinkTime".}
proc SetCaretBlinkTime*(uMSeconds: UINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SetCaretBlinkTime".}
proc DestroyCaret*(): WINBOOL{.stdcall, dynlib: "user32",
                               importc: "DestroyCaret".}
proc HideCaret*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
                                      importc: "HideCaret".}
proc ShowCaret*(wnd: HWND): WINBOOL{.stdcall, dynlib: "user32",
                                      importc: "ShowCaret".}
proc SetCaretPos*(X: int32, Y: int32): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SetCaretPos".}
proc GetCaretPos*(lpPoint: LPPOINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "GetCaretPos".}
proc ClientToScreen*(wnd: HWND, lpPoint: LPPOINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "ClientToScreen".}
proc ScreenToClient*(wnd: HWND, lpPoint: LPPOINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "ScreenToClient".}
proc MapWindowPoints*(hWndFrom: HWND, hWndTo: HWND, lpPoints: LPPOINT,
                      cPoints: UINT): int32{.stdcall, dynlib: "user32",
    importc: "MapWindowPoints".}
proc WindowFromPoint*(Point: POINT): HWND{.stdcall, dynlib: "user32",
    importc: "WindowFromPoint".}
proc ChildWindowFromPoint*(hWndParent: HWND, Point: POINT): HWND{.stdcall,
    dynlib: "user32", importc: "ChildWindowFromPoint".}
proc GetSysColor*(nIndex: int32): DWORD{.stdcall, dynlib: "user32",
    importc: "GetSysColor".}
proc GetSysColorBrush*(nIndex: int32): HBRUSH{.stdcall, dynlib: "user32",
    importc: "GetSysColorBrush".}
proc SetSysColors*(cElements: int32, lpaElements: var wINT,
                   lpaRgbValues: var COLORREF): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetSysColors".}
proc DrawFocusRect*(hDC: HDC, lprc: var RECT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "DrawFocusRect".}
proc FillRect*(hDC: HDC, lprc: RECT, hbr: HBRUSH): int32{.stdcall,
    dynlib: "user32", importc: "FillRect".}
proc FrameRect*(hDC: HDC, lprc: var RECT, hbr: HBRUSH): int32{.stdcall,
    dynlib: "user32", importc: "FrameRect".}
proc InvertRect*(hDC: HDC, lprc: var RECT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "InvertRect".}
proc SetRect*(lprc: LPRECT, xLeft: int32, yTop: int32, xRight: int32,
              yBottom: int32): WINBOOL{.stdcall, dynlib: "user32",
                                        importc: "SetRect".}
proc SetRectEmpty*(lprc: LPRECT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SetRectEmpty".}
proc CopyRect*(lprcDst: LPRECT, lprcSrc: var RECT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "CopyRect".}
proc InflateRect*(lprc: LPRECT, dx: int32, dy: int32): WINBOOL{.stdcall,
    dynlib: "user32", importc: "InflateRect".}
proc IntersectRect*(lprcDst: LPRECT, lprcSrc1: var RECT, lprcSrc2: var RECT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "IntersectRect".}
proc UnionRect*(lprcDst: LPRECT, lprcSrc1: var RECT, lprcSrc2: var RECT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "UnionRect".}
proc SubtractRect*(lprcDst: LPRECT, lprcSrc1: var RECT, lprcSrc2: var RECT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SubtractRect".}
proc OffsetRect*(lprc: LPRECT, dx: int32, dy: int32): WINBOOL{.stdcall,
    dynlib: "user32", importc: "OffsetRect".}
proc IsRectEmpty*(lprc: var RECT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "IsRectEmpty".}
proc EqualRect*(lprc1: var RECT, lprc2: var RECT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "EqualRect".}
proc PtInRect*(lprc: var RECT, pt: POINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "PtInRect".}
proc PtInRect*(lprc: LPRECT, pt: POINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "PtInRect".}
proc GetWindowWord*(wnd: HWND, nIndex: int32): int16{.stdcall,
    dynlib: "user32", importc: "GetWindowWord".}
proc SetWindowWord*(wnd: HWND, nIndex: int32, wNewWord: int16): int16{.stdcall,
    dynlib: "user32", importc: "SetWindowWord".}
proc GetClassWord*(wnd: HWND, nIndex: int32): int16{.stdcall, dynlib: "user32",
    importc: "GetClassWord".}
proc SetClassWord*(wnd: HWND, nIndex: int32, wNewWord: int16): int16{.stdcall,
    dynlib: "user32", importc: "SetClassWord".}
proc GetDesktopWindow*(): HWND{.stdcall, dynlib: "user32",
                                importc: "GetDesktopWindow".}
proc GetParent*(wnd: HWND): HWND{.stdcall, dynlib: "user32",
                                   importc: "GetParent".}
proc SetParent*(hWndChild: HWND, hWndNewParent: HWND): HWND{.stdcall,
    dynlib: "user32", importc: "SetParent".}
proc EnumChildWindows*(hWndParent: HWND, lpEnumFunc: ENUMWINDOWSPROC,
                       lp: LPARAM): WINBOOL{.stdcall, dynlib: "user32",
    importc: "EnumChildWindows".}
proc EnumWindows*(lpEnumFunc: ENUMWINDOWSPROC, lp: LPARAM): WINBOOL{.
    stdcall, dynlib: "user32", importc: "EnumWindows".}
proc EnumThreadWindows*(dwThreadId: DWORD, lpfn: ENUMWINDOWSPROC, lp: LPARAM): WINBOOL{.
    stdcall, dynlib: "user32", importc: "EnumThreadWindows".}
proc EnumTaskWindows*(hTask: HWND, lpfn: FARPROC, lp: LPARAM): WINBOOL{.
    stdcall, dynlib: "user32", importc: "EnumThreadWindows".}
proc GetTopWindow*(wnd: HWND): HWND{.stdcall, dynlib: "user32",
                                      importc: "GetTopWindow".}
proc GetWindowThreadProcessId*(wnd: HWND, lpdwProcessId: LPDWORD): DWORD{.
    stdcall, dynlib: "user32", importc: "GetWindowThreadProcessId".}
proc GetLastActivePopup*(wnd: HWND): HWND{.stdcall, dynlib: "user32",
    importc: "GetLastActivePopup".}
proc GetWindow*(wnd: HWND, uCmd: UINT): HWND{.stdcall, dynlib: "user32",
    importc: "GetWindow".}
proc UnhookWindowsHook*(nCode: int32, pfnFilterProc: HOOKPROC): WINBOOL{.
    stdcall, dynlib: "user32", importc: "UnhookWindowsHook".}
proc UnhookWindowsHookEx*(hhk: HHOOK): WINBOOL{.stdcall, dynlib: "user32",
    importc: "UnhookWindowsHookEx".}
proc CallNextHookEx*(hhk: HHOOK, nCode: int32, wp: WPARAM, lp: LPARAM): LRESULT{.
    stdcall, dynlib: "user32", importc: "CallNextHookEx".}
proc CheckMenuRadioItem*(para1: HMENU, para2: UINT, para3: UINT, para4: UINT,
                         para5: UINT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "CheckMenuRadioItem".}
proc CreateCursor*(hInst: HINST, xHotSpot: int32, yHotSpot: int32,
                   nWidth: int32, nHeight: int32, pvANDPlane: pointer,
                   pvXORPlane: pointer): HCURSOR{.stdcall, dynlib: "user32",
    importc: "CreateCursor".}
proc DestroyCursor*(cursor: HCURSOR): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DestroyCursor".}
proc SetSystemCursor*(hcur: HCURSOR, anID: DWORD): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetSystemCursor".}
proc CreateIcon*(hInstance: HINST, nWidth: int32, nHeight: int32, cPlanes: int8,
                 cBitsPixel: int8, lpbANDbits: var int8, lpbXORbits: var int8): HICON{.
    stdcall, dynlib: "user32", importc: "CreateIcon".}
proc DestroyIcon*(icon: HICON): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DestroyIcon".}
proc LookupIconIdFromDirectory*(presbits: PBYTE, fIcon: WINBOOL): int32{.
    stdcall, dynlib: "user32", importc: "LookupIconIdFromDirectory".}
proc LookupIconIdFromDirectoryEx*(presbits: PBYTE, fIcon: WINBOOL,
                                  cxDesired: int32, cyDesired: int32,
                                  Flags: UINT): int32{.stdcall,
    dynlib: "user32", importc: "LookupIconIdFromDirectoryEx".}
proc CreateIconFromResource*(presbits: PBYTE, dwResSize: DWORD, fIcon: WINBOOL,
                             dwVer: DWORD): HICON{.stdcall, dynlib: "user32",
    importc: "CreateIconFromResource".}
proc CreateIconFromResourceEx*(presbits: PBYTE, dwResSize: DWORD,
                               fIcon: WINBOOL, dwVer: DWORD, cxDesired: int32,
                               cyDesired: int32, Flags: UINT): HICON{.stdcall,
    dynlib: "user32", importc: "CreateIconFromResourceEx".}
proc CopyImage*(para1: HANDLE, para2: UINT, para3: int32, para4: int32,
                para5: UINT): HICON{.stdcall, dynlib: "user32",
                                     importc: "CopyImage".}
proc CreateIconIndirect*(piconinfo: PICONINFO): HICON{.stdcall,
    dynlib: "user32", importc: "CreateIconIndirect".}
proc CopyIcon*(icon: HICON): HICON{.stdcall, dynlib: "user32",
                                     importc: "CopyIcon".}
proc GetIconInfo*(icon: HICON, piconinfo: PICONINFO): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetIconInfo".}
proc MapDialogRect*(hDlg: HWND, lpRect: LPRECT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "MapDialogRect".}
proc SetScrollInfo*(para1: HWND, para2: int32, para3: LPCSCROLLINFO,
                    para4: WINBOOL): int32{.stdcall, dynlib: "user32",
    importc: "SetScrollInfo".}
proc GetScrollInfo*(para1: HWND, para2: int32, para3: LPSCROLLINFO): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetScrollInfo".}
proc TranslateMDISysAccel*(hWndClient: HWND, lpMsg: LPMSG): WINBOOL{.stdcall,
    dynlib: "user32", importc: "TranslateMDISysAccel".}
proc ArrangeIconicWindows*(wnd: HWND): UINT{.stdcall, dynlib: "user32",
    importc: "ArrangeIconicWindows".}
proc TileWindows*(hwndParent: HWND, wHow: UINT, lpRect: var RECT, cKids: UINT,
                  lpKids: var HWND): int16{.stdcall, dynlib: "user32",
    importc: "TileWindows".}
proc CascadeWindows*(hwndParent: HWND, wHow: UINT, lpRect: var RECT,
                     cKids: UINT, lpKids: var HWND): int16{.stdcall,
    dynlib: "user32", importc: "CascadeWindows".}
proc SetLastErrorEx*(dwErrCode: DWORD, dwType: DWORD){.stdcall,
    dynlib: "user32", importc: "SetLastErrorEx".}
proc SetDebugErrorLevel*(dwLevel: DWORD){.stdcall, dynlib: "user32",
    importc: "SetDebugErrorLevel".}
proc DrawEdge*(hdc: HDC, qrc: LPRECT, edge: UINT, grfFlags: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "DrawEdge".}
proc DrawFrameControl*(para1: HDC, para2: LPRECT, para3: UINT, para4: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "DrawFrameControl".}
proc DrawCaption*(para1: HWND, para2: HDC, para3: var RECT, para4: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "DrawCaption".}
proc DrawAnimatedRects*(wnd: HWND, idAni: int32, lprcFrom: var RECT,
                        lprcTo: var RECT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DrawAnimatedRects".}
proc TrackPopupMenuEx*(para1: HMENU, para2: UINT, para3: int32, para4: int32,
                       para5: HWND, para6: LPTPMPARAMS): WINBOOL{.stdcall,
    dynlib: "user32", importc: "TrackPopupMenuEx".}
proc ChildWindowFromPointEx*(para1: HWND, para2: POINT, para3: UINT): HWND{.
    stdcall, dynlib: "user32", importc: "ChildWindowFromPointEx".}
proc DrawIconEx*(hdc: HDC, xLeft: int32, yTop: int32, icon: HICON,
                 cxWidth: int32, cyWidth: int32, istepIfAniCur: UINT,
                 hbrFlickerFreeDraw: HBRUSH, diFlags: UINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "DrawIconEx".}
proc AnimatePalette*(para1: HPALETTE, para2: UINT, para3: UINT,
                     para4: var PALETTEENTRY): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "AnimatePalette".}
proc Arc*(para1: HDC, para2: int32, para3: int32, para4: int32, para5: int32,
          para6: int32, para7: int32, para8: int32, para9: int32): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "Arc".}
proc BitBlt*(para1: HDC, para2: int32, para3: int32, para4: int32, para5: int32,
             para6: HDC, para7: int32, para8: int32, para9: DWORD): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "BitBlt".}
proc CancelDC*(para1: HDC): WINBOOL{.stdcall, dynlib: "gdi32",
                                     importc: "CancelDC".}
proc Chord*(para1: HDC, para2: int32, para3: int32, para4: int32, para5: int32,
            para6: int32, para7: int32, para8: int32, para9: int32): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "Chord".}
proc CloseMetaFile*(para1: HDC): HMETAFILE{.stdcall, dynlib: "gdi32",
    importc: "CloseMetaFile".}
proc CombineRgn*(para1: HRGN, para2: HRGN, para3: HRGN, para4: int32): int32{.
    stdcall, dynlib: "gdi32", importc: "CombineRgn".}
proc CreateBitmap*(para1: int32, para2: int32, para3: UINT, para4: UINT,
                   para5: pointer): HBITMAP{.stdcall, dynlib: "gdi32",
    importc: "CreateBitmap".}
proc CreateBitmapIndirect*(para1: var BITMAP): HBITMAP{.stdcall,
    dynlib: "gdi32", importc: "CreateBitmapIndirect".}
proc CreateBrushIndirect*(para1: var LOGBRUSH): HBRUSH{.stdcall,
    dynlib: "gdi32", importc: "CreateBrushIndirect".}
proc CreateCompatibleBitmap*(para1: HDC, para2: int32, para3: int32): HBITMAP{.
    stdcall, dynlib: "gdi32", importc: "CreateCompatibleBitmap".}
proc CreateDiscardableBitmap*(para1: HDC, para2: int32, para3: int32): HBITMAP{.
    stdcall, dynlib: "gdi32", importc: "CreateDiscardableBitmap".}
proc CreateCompatibleDC*(para1: HDC): HDC{.stdcall, dynlib: "gdi32",
    importc: "CreateCompatibleDC".}
proc CreateDIBitmap*(para1: HDC, para2: var BITMAPINFOHEADER, para3: DWORD,
                     para4: pointer, para5: var BITMAPINFO, para6: UINT): HBITMAP{.
    stdcall, dynlib: "gdi32", importc: "CreateDIBitmap".}
proc CreateDIBPatternBrush*(para1: HGLOBAL, para2: UINT): HBRUSH{.stdcall,
    dynlib: "gdi32", importc: "CreateDIBPatternBrush".}
proc CreateDIBPatternBrushPt*(para1: pointer, para2: UINT): HBRUSH{.stdcall,
    dynlib: "gdi32", importc: "CreateDIBPatternBrushPt".}
proc CreateEllipticRgn*(para1: int32, para2: int32, para3: int32, para4: int32): HRGN{.
    stdcall, dynlib: "gdi32", importc: "CreateEllipticRgn".}
proc CreateEllipticRgnIndirect*(para1: var RECT): HRGN{.stdcall,
    dynlib: "gdi32", importc: "CreateEllipticRgnIndirect".}
proc CreateHatchBrush*(para1: int32, para2: COLORREF): HBRUSH{.stdcall,
    dynlib: "gdi32", importc: "CreateHatchBrush".}
proc CreatePalette*(para1: var LOGPALETTE): HPALETTE{.stdcall, dynlib: "gdi32",
    importc: "CreatePalette".}
proc CreatePen*(para1: int32, para2: int32, para3: COLORREF): HPEN{.stdcall,
    dynlib: "gdi32", importc: "CreatePen".}
proc CreatePenIndirect*(para1: var LOGPEN): HPEN{.stdcall, dynlib: "gdi32",
    importc: "CreatePenIndirect".}
proc CreatePolyPolygonRgn*(para1: var POINT, para2: var wINT, para3: int32,
                           para4: int32): HRGN{.stdcall, dynlib: "gdi32",
    importc: "CreatePolyPolygonRgn".}
proc CreatePatternBrush*(para1: HBITMAP): HBRUSH{.stdcall, dynlib: "gdi32",
    importc: "CreatePatternBrush".}
proc CreateRectRgn*(para1: int32, para2: int32, para3: int32, para4: int32): HRGN{.
    stdcall, dynlib: "gdi32", importc: "CreateRectRgn".}
proc CreateRectRgnIndirect*(para1: var RECT): HRGN{.stdcall, dynlib: "gdi32",
    importc: "CreateRectRgnIndirect".}
proc CreateRoundRectRgn*(para1: int32, para2: int32, para3: int32, para4: int32,
                         para5: int32, para6: int32): HRGN{.stdcall,
    dynlib: "gdi32", importc: "CreateRoundRectRgn".}
proc CreateSolidBrush*(para1: COLORREF): HBRUSH{.stdcall, dynlib: "gdi32",
    importc: "CreateSolidBrush".}
proc DeleteDC*(para1: HDC): WINBOOL{.stdcall, dynlib: "gdi32",
                                     importc: "DeleteDC".}
proc DeleteMetaFile*(para1: HMETAFILE): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "DeleteMetaFile".}
proc DeleteObject*(para1: HGDIOBJ): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "DeleteObject".}
proc DrawEscape*(para1: HDC, para2: int32, para3: int32, para4: LPCSTR): int32{.
    stdcall, dynlib: "gdi32", importc: "DrawEscape".}
proc Ellipse*(para1: HDC, para2: int32, para3: int32, para4: int32, para5: int32): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "Ellipse".}
proc EnumObjects*(para1: HDC, para2: int32, para3: ENUMOBJECTSPROC,
                  para4: LPARAM): int32{.stdcall, dynlib: "gdi32",
    importc: "EnumObjects".}
proc EqualRgn*(para1: HRGN, para2: HRGN): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "EqualRgn".}
proc Escape*(para1: HDC, para2: int32, para3: int32, para4: LPCSTR,
             para5: LPVOID): int32{.stdcall, dynlib: "gdi32", importc: "Escape".}
proc ExtEscape*(para1: HDC, para2: int32, para3: int32, para4: LPCSTR,
                para5: int32, para6: LPSTR): int32{.stdcall, dynlib: "gdi32",
    importc: "ExtEscape".}
proc ExcludeClipRect*(para1: HDC, para2: int32, para3: int32, para4: int32,
                      para5: int32): int32{.stdcall, dynlib: "gdi32",
    importc: "ExcludeClipRect".}
proc ExtCreateRegion*(para1: var XFORM, para2: DWORD, para3: var RGNDATA): HRGN{.
    stdcall, dynlib: "gdi32", importc: "ExtCreateRegion".}
proc ExtFloodFill*(para1: HDC, para2: int32, para3: int32, para4: COLORREF,
                   para5: UINT): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "ExtFloodFill".}
proc FillRgn*(para1: HDC, para2: HRGN, para3: HBRUSH): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "FillRgn".}
proc FloodFill*(para1: HDC, para2: int32, para3: int32, para4: COLORREF): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "FloodFill".}
proc FrameRgn*(para1: HDC, para2: HRGN, para3: HBRUSH, para4: int32,
               para5: int32): WINBOOL{.stdcall, dynlib: "gdi32",
                                       importc: "FrameRgn".}
proc GetROP2*(para1: HDC): int32{.stdcall, dynlib: "gdi32", importc: "GetROP2".}
proc GetAspectRatioFilterEx*(para1: HDC, para2: LPSIZE): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetAspectRatioFilterEx".}
proc GetBkColor*(para1: HDC): COLORREF{.stdcall, dynlib: "gdi32",
                                        importc: "GetBkColor".}
proc GetBkMode*(para1: HDC): int32{.stdcall, dynlib: "gdi32",
                                    importc: "GetBkMode".}
proc GetBitmapBits*(para1: HBITMAP, para2: LONG, para3: LPVOID): LONG{.stdcall,
    dynlib: "gdi32", importc: "GetBitmapBits".}
proc GetBitmapDimensionEx*(para1: HBITMAP, para2: LPSIZE): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetBitmapDimensionEx".}
proc GetBoundsRect*(para1: HDC, para2: LPRECT, para3: UINT): UINT{.stdcall,
    dynlib: "gdi32", importc: "GetBoundsRect".}
proc GetBrushOrgEx*(para1: HDC, para2: LPPOINT): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetBrushOrgEx".}
proc GetClipBox*(para1: HDC, para2: LPRECT): int32{.stdcall, dynlib: "gdi32",
    importc: "GetClipBox".}
proc GetClipRgn*(para1: HDC, para2: HRGN): int32{.stdcall, dynlib: "gdi32",
    importc: "GetClipRgn".}
proc GetMetaRgn*(para1: HDC, para2: HRGN): int32{.stdcall, dynlib: "gdi32",
    importc: "GetMetaRgn".}
proc GetCurrentObject*(para1: HDC, para2: UINT): HGDIOBJ{.stdcall,
    dynlib: "gdi32", importc: "GetCurrentObject".}
proc GetCurrentPositionEx*(para1: HDC, para2: LPPOINT): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetCurrentPositionEx".}
proc GetDeviceCaps*(para1: HDC, para2: int32): int32{.stdcall, dynlib: "gdi32",
    importc: "GetDeviceCaps".}
proc GetDIBits*(para1: HDC, para2: HBITMAP, para3: UINT, para4: UINT,
                para5: LPVOID, para6: LPBITMAPINFO, para7: UINT): int32{.
    stdcall, dynlib: "gdi32", importc: "GetDIBits".}
proc GetFontData*(para1: HDC, para2: DWORD, para3: DWORD, para4: LPVOID,
                  para5: DWORD): DWORD{.stdcall, dynlib: "gdi32",
                                        importc: "GetFontData".}
proc GetGraphicsMode*(para1: HDC): int32{.stdcall, dynlib: "gdi32",
    importc: "GetGraphicsMode".}
proc GetMapMode*(para1: HDC): int32{.stdcall, dynlib: "gdi32",
                                     importc: "GetMapMode".}
proc GetMetaFileBitsEx*(para1: HMETAFILE, para2: UINT, para3: LPVOID): UINT{.
    stdcall, dynlib: "gdi32", importc: "GetMetaFileBitsEx".}
proc GetNearestColor*(para1: HDC, para2: COLORREF): COLORREF{.stdcall,
    dynlib: "gdi32", importc: "GetNearestColor".}
proc GetNearestPaletteIndex*(para1: HPALETTE, para2: COLORREF): UINT{.stdcall,
    dynlib: "gdi32", importc: "GetNearestPaletteIndex".}
proc GetObjectType*(h: HGDIOBJ): DWORD{.stdcall, dynlib: "gdi32",
                                        importc: "GetObjectType".}
proc GetPaletteEntries*(para1: HPALETTE, para2: UINT, para3: UINT,
                        para4: LPPALETTEENTRY): UINT{.stdcall, dynlib: "gdi32",
    importc: "GetPaletteEntries".}
proc GetPixel*(para1: HDC, para2: int32, para3: int32): COLORREF{.stdcall,
    dynlib: "gdi32", importc: "GetPixel".}
proc GetPixelFormat*(para1: HDC): int32{.stdcall, dynlib: "gdi32",
    importc: "GetPixelFormat".}
proc GetPolyFillMode*(para1: HDC): int32{.stdcall, dynlib: "gdi32",
    importc: "GetPolyFillMode".}
proc GetRasterizerCaps*(para1: LPRASTERIZER_STATUS, para2: UINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetRasterizerCaps".}
proc GetRegionData*(para1: HRGN, para2: DWORD, para3: LPRGNDATA): DWORD{.
    stdcall, dynlib: "gdi32", importc: "GetRegionData".}
proc GetRgnBox*(para1: HRGN, para2: LPRECT): int32{.stdcall, dynlib: "gdi32",
    importc: "GetRgnBox".}
proc GetStockObject*(para1: int32): HGDIOBJ{.stdcall, dynlib: "gdi32",
    importc: "GetStockObject".}
proc GetStretchBltMode*(para1: HDC): int32{.stdcall, dynlib: "gdi32",
    importc: "GetStretchBltMode".}
proc GetSystemPaletteEntries*(para1: HDC, para2: UINT, para3: UINT,
                              para4: LPPALETTEENTRY): UINT{.stdcall,
    dynlib: "gdi32", importc: "GetSystemPaletteEntries".}
proc GetSystemPaletteUse*(para1: HDC): UINT{.stdcall, dynlib: "gdi32",
    importc: "GetSystemPaletteUse".}
proc GetTextCharacterExtra*(para1: HDC): int32{.stdcall, dynlib: "gdi32",
    importc: "GetTextCharacterExtra".}
proc GetTextAlign*(para1: HDC): UINT{.stdcall, dynlib: "gdi32",
                                      importc: "GetTextAlign".}
proc GetTextColor*(para1: HDC): COLORREF{.stdcall, dynlib: "gdi32",
    importc: "GetTextColor".}
proc GetTextCharset*(hdc: HDC): int32{.stdcall, dynlib: "gdi32",
                                       importc: "GetTextCharset".}
proc GetTextCharsetInfo*(hdc: HDC, lpSig: LPFONTSIGNATURE, dwFlags: DWORD): int32{.
    stdcall, dynlib: "gdi32", importc: "GetTextCharsetInfo".}
proc TranslateCharsetInfo*(lpSrc: var DWORD, lpCs: LPCHARSETINFO, dwFlags: DWORD): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "TranslateCharsetInfo".}
proc GetFontLanguageInfo*(para1: HDC): DWORD{.stdcall, dynlib: "gdi32",
    importc: "GetFontLanguageInfo".}
proc GetViewportExtEx*(para1: HDC, para2: LPSIZE): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetViewportExtEx".}
proc GetViewportOrgEx*(para1: HDC, para2: LPPOINT): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetViewportOrgEx".}
proc GetWindowExtEx*(para1: HDC, para2: LPSIZE): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetWindowExtEx".}
proc GetWindowOrgEx*(para1: HDC, para2: LPPOINT): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetWindowOrgEx".}
proc IntersectClipRect*(para1: HDC, para2: int32, para3: int32, para4: int32,
                        para5: int32): int32{.stdcall, dynlib: "gdi32",
    importc: "IntersectClipRect".}
proc InvertRgn*(para1: HDC, para2: HRGN): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "InvertRgn".}
proc LineDDA*(para1: int32, para2: int32, para3: int32, para4: int32,
              para5: LINEDDAPROC, para6: LPARAM): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "LineDDA".}
proc LineTo*(para1: HDC, para2: int32, para3: int32): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "LineTo".}
proc MaskBlt*(para1: HDC, para2: int32, para3: int32, para4: int32,
              para5: int32, para6: HDC, para7: int32, para8: int32,
              para9: HBITMAP, para10: int32, para11: int32, para12: DWORD): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "MaskBlt".}
proc PlgBlt*(para1: HDC, para2: var POINT, para3: HDC, para4: int32,
             para5: int32, para6: int32, para7: int32, para8: HBITMAP,
             para9: int32, para10: int32): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "PlgBlt".}
proc OffsetClipRgn*(para1: HDC, para2: int32, para3: int32): int32{.stdcall,
    dynlib: "gdi32", importc: "OffsetClipRgn".}
proc OffsetRgn*(para1: HRGN, para2: int32, para3: int32): int32{.stdcall,
    dynlib: "gdi32", importc: "OffsetRgn".}
proc PatBlt*(para1: HDC, para2: int32, para3: int32, para4: int32, para5: int32,
             para6: DWORD): WINBOOL{.stdcall, dynlib: "gdi32", importc: "PatBlt".}
proc Pie*(para1: HDC, para2: int32, para3: int32, para4: int32, para5: int32,
          para6: int32, para7: int32, para8: int32, para9: int32): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "Pie".}
proc PlayMetaFile*(para1: HDC, para2: HMETAFILE): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "PlayMetaFile".}
proc PaintRgn*(para1: HDC, para2: HRGN): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "PaintRgn".}
proc PolyPolygon*(para1: HDC, para2: var POINT, para3: var wINT, para4: int32): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "PolyPolygon".}
proc PtInRegion*(para1: HRGN, para2: int32, para3: int32): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "PtInRegion".}
proc PtVisible*(para1: HDC, para2: int32, para3: int32): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "PtVisible".}
proc RectInRegion*(para1: HRGN, para2: var RECT): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "RectInRegion".}
proc RectVisible*(para1: HDC, para2: var RECT): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "RectVisible".}
proc Rectangle*(para1: HDC, para2: int32, para3: int32, para4: int32,
                para5: int32): WINBOOL{.stdcall, dynlib: "gdi32",
                                        importc: "Rectangle".}
proc RestoreDC*(para1: HDC, para2: int32): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "RestoreDC".}
proc RealizePalette*(para1: HDC): UINT{.stdcall, dynlib: "gdi32",
                                        importc: "RealizePalette".}
proc RoundRect*(para1: HDC, para2: int32, para3: int32, para4: int32,
                para5: int32, para6: int32, para7: int32): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "RoundRect".}
proc ResizePalette*(para1: HPALETTE, para2: UINT): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "ResizePalette".}
proc SaveDC*(para1: HDC): int32{.stdcall, dynlib: "gdi32", importc: "SaveDC".}
proc SelectClipRgn*(para1: HDC, para2: HRGN): int32{.stdcall, dynlib: "gdi32",
    importc: "SelectClipRgn".}
proc ExtSelectClipRgn*(para1: HDC, para2: HRGN, para3: int32): int32{.stdcall,
    dynlib: "gdi32", importc: "ExtSelectClipRgn".}
proc SetMetaRgn*(para1: HDC): int32{.stdcall, dynlib: "gdi32",
                                     importc: "SetMetaRgn".}
proc SelectObject*(para1: HDC, para2: HGDIOBJ): HGDIOBJ{.stdcall,
    dynlib: "gdi32", importc: "SelectObject".}
proc SelectPalette*(para1: HDC, para2: HPALETTE, para3: WINBOOL): HPALETTE{.
    stdcall, dynlib: "gdi32", importc: "SelectPalette".}
proc SetBkColor*(para1: HDC, para2: COLORREF): COLORREF{.stdcall,
    dynlib: "gdi32", importc: "SetBkColor".}
proc SetBkMode*(para1: HDC, para2: int32): int32{.stdcall, dynlib: "gdi32",
    importc: "SetBkMode".}
proc SetBitmapBits*(para1: HBITMAP, para2: DWORD, para3: pointer): LONG{.
    stdcall, dynlib: "gdi32", importc: "SetBitmapBits".}
proc SetBoundsRect*(para1: HDC, para2: var RECT, para3: UINT): UINT{.stdcall,
    dynlib: "gdi32", importc: "SetBoundsRect".}
proc SetDIBits*(para1: HDC, para2: HBITMAP, para3: UINT, para4: UINT,
                para5: pointer, para6: PBITMAPINFO, para7: UINT): int32{.
    stdcall, dynlib: "gdi32", importc: "SetDIBits".}
proc SetDIBitsToDevice*(para1: HDC, para2: int32, para3: int32, para4: DWORD,
                        para5: DWORD, para6: int32, para7: int32, para8: UINT,
                        para9: UINT, para10: pointer, para11: var BITMAPINFO,
                        para12: UINT): int32{.stdcall, dynlib: "gdi32",
    importc: "SetDIBitsToDevice".}
proc SetMapperFlags*(para1: HDC, para2: DWORD): DWORD{.stdcall, dynlib: "gdi32",
    importc: "SetMapperFlags".}
proc SetGraphicsMode*(hdc: HDC, iMode: int32): int32{.stdcall, dynlib: "gdi32",
    importc: "SetGraphicsMode".}
proc SetMapMode*(para1: HDC, para2: int32): int32{.stdcall, dynlib: "gdi32",
    importc: "SetMapMode".}
proc SetMetaFileBitsEx*(para1: UINT, para2: var int8): HMETAFILE{.stdcall,
    dynlib: "gdi32", importc: "SetMetaFileBitsEx".}
proc SetPaletteEntries*(para1: HPALETTE, para2: UINT, para3: UINT,
                        para4: var PALETTEENTRY): UINT{.stdcall,
    dynlib: "gdi32", importc: "SetPaletteEntries".}
proc SetPixel*(para1: HDC, para2: int32, para3: int32, para4: COLORREF): COLORREF{.
    stdcall, dynlib: "gdi32", importc: "SetPixel".}
proc SetPixelV*(para1: HDC, para2: int32, para3: int32, para4: COLORREF): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "SetPixelV".}
proc SetPolyFillMode*(para1: HDC, para2: int32): int32{.stdcall,
    dynlib: "gdi32", importc: "SetPolyFillMode".}
proc StretchBlt*(para1: HDC, para2: int32, para3: int32, para4: int32,
                 para5: int32, para6: HDC, para7: int32, para8: int32,
                 para9: int32, para10: int32, para11: DWORD): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "StretchBlt".}
proc SetRectRgn*(para1: HRGN, para2: int32, para3: int32, para4: int32,
                 para5: int32): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "SetRectRgn".}
proc StretchDIBits*(para1: HDC, para2: int32, para3: int32, para4: int32,
                    para5: int32, para6: int32, para7: int32, para8: int32,
                    para9: int32, para10: pointer, para11: var BITMAPINFO,
                    para12: UINT, para13: DWORD): int32{.stdcall,
    dynlib: "gdi32", importc: "StretchDIBits".}
proc SetROP2*(para1: HDC, para2: int32): int32{.stdcall, dynlib: "gdi32",
    importc: "SetROP2".}
proc SetStretchBltMode*(para1: HDC, para2: int32): int32{.stdcall,
    dynlib: "gdi32", importc: "SetStretchBltMode".}
proc SetSystemPaletteUse*(para1: HDC, para2: UINT): UINT{.stdcall,
    dynlib: "gdi32", importc: "SetSystemPaletteUse".}
proc SetTextCharacterExtra*(para1: HDC, para2: int32): int32{.stdcall,
    dynlib: "gdi32", importc: "SetTextCharacterExtra".}
proc SetTextColor*(para1: HDC, para2: COLORREF): COLORREF{.stdcall,
    dynlib: "gdi32", importc: "SetTextColor".}
proc SetTextAlign*(para1: HDC, para2: UINT): UINT{.stdcall, dynlib: "gdi32",
    importc: "SetTextAlign".}
proc SetTextJustification*(para1: HDC, para2: int32, para3: int32): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "SetTextJustification".}
proc UpdateColors*(para1: HDC): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "UpdateColors".}
proc PlayMetaFileRecord*(para1: HDC, para2: LPHANDLETABLE, para3: LPMETARECORD,
                         para4: UINT): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "PlayMetaFileRecord".}
proc EnumMetaFile*(para1: HDC, para2: HMETAFILE, para3: ENUMMETAFILEPROC,
                   para4: LPARAM): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "EnumMetaFile".}
proc CloseEnhMetaFile*(para1: HDC): HENHMETAFILE{.stdcall, dynlib: "gdi32",
    importc: "CloseEnhMetaFile".}
proc DeleteEnhMetaFile*(para1: HENHMETAFILE): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "DeleteEnhMetaFile".}
proc EnumEnhMetaFile*(para1: HDC, para2: HENHMETAFILE, para3: ENHMETAFILEPROC,
                      para4: LPVOID, para5: var RECT): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "EnumEnhMetaFile".}
proc GetEnhMetaFileHeader*(para1: HENHMETAFILE, para2: UINT,
                           para3: LPENHMETAHEADER): UINT{.stdcall,
    dynlib: "gdi32", importc: "GetEnhMetaFileHeader".}
proc GetEnhMetaFilePaletteEntries*(para1: HENHMETAFILE, para2: UINT,
                                   para3: LPPALETTEENTRY): UINT{.stdcall,
    dynlib: "gdi32", importc: "GetEnhMetaFilePaletteEntries".}
proc GetEnhMetaFileBits*(para1: HENHMETAFILE, para2: UINT, para3: LPBYTE): UINT{.
    stdcall, dynlib: "gdi32", importc: "GetEnhMetaFileBits".}
proc GetWinMetaFileBits*(para1: HENHMETAFILE, para2: UINT, para3: LPBYTE,
                         para4: wINT, para5: HDC): UINT{.stdcall,
    dynlib: "gdi32", importc: "GetWinMetaFileBits".}
proc PlayEnhMetaFile*(para1: HDC, para2: HENHMETAFILE, para3: RECT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "PlayEnhMetaFile".}
proc PlayEnhMetaFileRecord*(para1: HDC, para2: LPHANDLETABLE,
                            para3: var TENHMETARECORD, para4: UINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "PlayEnhMetaFileRecord".}
proc SetEnhMetaFileBits*(para1: UINT, para2: var int8): HENHMETAFILE{.stdcall,
    dynlib: "gdi32", importc: "SetEnhMetaFileBits".}
proc SetWinMetaFileBits*(para1: UINT, para2: var int8, para3: HDC,
                         para4: var METAFILEPICT): HENHMETAFILE{.stdcall,
    dynlib: "gdi32", importc: "SetWinMetaFileBits".}
proc GdiComment*(para1: HDC, para2: UINT, para3: var int8): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GdiComment".}
proc AngleArc*(para1: HDC, para2: int32, para3: int32, para4: DWORD,
               para5: float32, para6: float32): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "AngleArc".}
proc PolyPolyline*(para1: HDC, para2: var POINT, para3: var DWORD, para4: DWORD): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "PolyPolyline".}
proc GetWorldTransform*(para1: HDC, para2: LPXFORM): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetWorldTransform".}
proc SetWorldTransform*(para1: HDC, para2: var XFORM): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "SetWorldTransform".}
proc ModifyWorldTransform*(para1: HDC, para2: var XFORM, para3: DWORD): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "ModifyWorldTransform".}
proc CombineTransform*(para1: LPXFORM, para2: var XFORM, para3: var XFORM): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "CombineTransform".}
proc CreateDIBSection*(para1: HDC, para2: var BITMAPINFO, para3: UINT,
                       para4: var pointer, para5: HANDLE, para6: DWORD): HBITMAP{.
    stdcall, dynlib: "gdi32", importc: "CreateDIBSection".}
proc GetDIBColorTable*(para1: HDC, para2: UINT, para3: UINT, para4: var RGBQUAD): UINT{.
    stdcall, dynlib: "gdi32", importc: "GetDIBColorTable".}
proc SetDIBColorTable*(para1: HDC, para2: UINT, para3: UINT, para4: var RGBQUAD): UINT{.
    stdcall, dynlib: "gdi32", importc: "SetDIBColorTable".}
proc SetColorAdjustment*(para1: HDC, para2: var COLORADJUSTMENT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "SetColorAdjustment".}
proc GetColorAdjustment*(para1: HDC, para2: LPCOLORADJUSTMENT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetColorAdjustment".}
proc CreateHalftonePalette*(para1: HDC): HPALETTE{.stdcall, dynlib: "gdi32",
    importc: "CreateHalftonePalette".}
proc EndDoc*(para1: HDC): int32{.stdcall, dynlib: "gdi32", importc: "EndDoc".}
proc StartPage*(para1: HDC): int32{.stdcall, dynlib: "gdi32",
                                    importc: "StartPage".}
proc EndPage*(para1: HDC): int32{.stdcall, dynlib: "gdi32", importc: "EndPage".}
proc AbortDoc*(para1: HDC): int32{.stdcall, dynlib: "gdi32", importc: "AbortDoc".}
proc SetAbortProc*(para1: HDC, para2: TABORTPROC): int32{.stdcall,
    dynlib: "gdi32", importc: "SetAbortProc".}
proc ArcTo*(para1: HDC, para2: int32, para3: int32, para4: int32, para5: int32,
            para6: int32, para7: int32, para8: int32, para9: int32): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "ArcTo".}
proc BeginPath*(para1: HDC): WINBOOL{.stdcall, dynlib: "gdi32",
                                      importc: "BeginPath".}
proc CloseFigure*(para1: HDC): WINBOOL{.stdcall, dynlib: "gdi32",
                                        importc: "CloseFigure".}
proc EndPath*(para1: HDC): WINBOOL{.stdcall, dynlib: "gdi32", importc: "EndPath".}
proc FillPath*(para1: HDC): WINBOOL{.stdcall, dynlib: "gdi32",
                                     importc: "FillPath".}
proc FlattenPath*(para1: HDC): WINBOOL{.stdcall, dynlib: "gdi32",
                                        importc: "FlattenPath".}
proc GetPath*(para1: HDC, para2: LPPOINT, para3: LPBYTE, para4: int32): int32{.
    stdcall, dynlib: "gdi32", importc: "GetPath".}
proc PathToRegion*(para1: HDC): HRGN{.stdcall, dynlib: "gdi32",
                                      importc: "PathToRegion".}
proc PolyDraw*(para1: HDC, para2: var POINT, para3: var int8, para4: int32): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "PolyDraw".}
proc SelectClipPath*(para1: HDC, para2: int32): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "SelectClipPath".}
proc SetArcDirection*(para1: HDC, para2: int32): int32{.stdcall,
    dynlib: "gdi32", importc: "SetArcDirection".}
proc SetMiterLimit*(para1: HDC, para2: float32, para3: ptr float32): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "SetMiterLimit".}
proc StrokeAndFillPath*(para1: HDC): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "StrokeAndFillPath".}
proc StrokePath*(para1: HDC): WINBOOL{.stdcall, dynlib: "gdi32",
                                       importc: "StrokePath".}
proc WidenPath*(para1: HDC): WINBOOL{.stdcall, dynlib: "gdi32",
                                      importc: "WidenPath".}
proc ExtCreatePen*(para1: DWORD, para2: DWORD, para3: var LOGBRUSH,
                   para4: DWORD, para5: var DWORD): HPEN{.stdcall,
    dynlib: "gdi32", importc: "ExtCreatePen".}
proc GetMiterLimit*(para1: HDC, para2: ptr float32): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetMiterLimit".}
proc GetArcDirection*(para1: HDC): int32{.stdcall, dynlib: "gdi32",
    importc: "GetArcDirection".}
proc MoveToEx*(para1: HDC, para2: int32, para3: int32, para4: LPPOINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "MoveToEx".}
proc CreatePolygonRgn*(para1: var POINT, para2: int32, para3: int32): HRGN{.
    stdcall, dynlib: "gdi32", importc: "CreatePolygonRgn".}
proc DPtoLP*(para1: HDC, para2: LPPOINT, para3: int32): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "DPtoLP".}
proc LPtoDP*(para1: HDC, para2: LPPOINT, para3: int32): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "LPtoDP".}
proc Polygon*(para1: HDC, para2: LPPOINT, para3: int32): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "Polygon".}
proc Polyline*(para1: HDC, para2: LPPOINT, para3: int32): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "Polyline".}
proc PolyBezier*(para1: HDC, para2: LPPOINT, para3: DWORD): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "PolyBezier".}
proc PolyBezierTo*(para1: HDC, para2: POINT, para3: DWORD): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "PolyBezierTo".}
proc PolylineTo*(para1: HDC, para2: LPPOINT, para3: DWORD): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "PolylineTo".}
proc SetViewportExtEx*(para1: HDC, para2: int32, para3: int32, para4: LPSIZE): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "SetViewportExtEx".}
proc SetViewportOrgEx*(para1: HDC, para2: int32, para3: int32, para4: LPPOINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "SetViewportOrgEx".}
proc SetWindowExtEx*(para1: HDC, para2: int32, para3: int32, para4: LPSIZE): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "SetWindowExtEx".}
proc SetWindowOrgEx*(para1: HDC, para2: int32, para3: int32, para4: LPPOINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "SetWindowOrgEx".}
proc OffsetViewportOrgEx*(para1: HDC, para2: int32, para3: int32, para4: LPPOINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "OffsetViewportOrgEx".}
proc OffsetWindowOrgEx*(para1: HDC, para2: int32, para3: int32, para4: LPPOINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "OffsetWindowOrgEx".}
proc ScaleViewportExtEx*(para1: HDC, para2: int32, para3: int32, para4: int32,
                         para5: int32, para6: LPSIZE): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "ScaleViewportExtEx".}
proc ScaleWindowExtEx*(para1: HDC, para2: int32, para3: int32, para4: int32,
                       para5: int32, para6: LPSIZE): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "ScaleWindowExtEx".}
proc SetBitmapDimensionEx*(para1: HBITMAP, para2: int32, para3: int32,
                           para4: LPSIZE): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "SetBitmapDimensionEx".}
proc SetBrushOrgEx*(para1: HDC, para2: int32, para3: int32, para4: LPPOINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "SetBrushOrgEx".}
proc GetDCOrgEx*(para1: HDC, para2: LPPOINT): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "GetDCOrgEx".}
proc FixBrushOrgEx*(para1: HDC, para2: int32, para3: int32, para4: LPPOINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "FixBrushOrgEx".}
proc UnrealizeObject*(para1: HGDIOBJ): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "UnrealizeObject".}
proc GdiFlush*(): WINBOOL{.stdcall, dynlib: "gdi32", importc: "GdiFlush".}
proc GdiSetBatchLimit*(para1: DWORD): DWORD{.stdcall, dynlib: "gdi32",
    importc: "GdiSetBatchLimit".}
proc GdiGetBatchLimit*(): DWORD{.stdcall, dynlib: "gdi32",
                                 importc: "GdiGetBatchLimit".}
proc SetICMMode*(para1: HDC, para2: int32): int32{.stdcall, dynlib: "gdi32",
    importc: "SetICMMode".}
proc CheckColorsInGamut*(para1: HDC, para2: LPVOID, para3: LPVOID, para4: DWORD): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "CheckColorsInGamut".}
proc GetColorSpace*(para1: HDC): HANDLE{.stdcall, dynlib: "gdi32",
    importc: "GetColorSpace".}
proc SetColorSpace*(para1: HDC, para2: HCOLORSPACE): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "SetColorSpace".}
proc DeleteColorSpace*(para1: HCOLORSPACE): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "DeleteColorSpace".}
proc GetDeviceGammaRamp*(para1: HDC, para2: LPVOID): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetDeviceGammaRamp".}
proc SetDeviceGammaRamp*(para1: HDC, para2: LPVOID): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "SetDeviceGammaRamp".}
proc ColorMatchToTarget*(para1: HDC, para2: HDC, para3: DWORD): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "ColorMatchToTarget".}
proc CreatePropertySheetPageA*(lppsp: LPCPROPSHEETPAGE): HPROPSHEETPAGE{.
    stdcall, dynlib: "comctl32", importc: "CreatePropertySheetPageA".}
proc DestroyPropertySheetPage*(hPSPage: HPROPSHEETPAGE): WINBOOL{.stdcall,
    dynlib: "comctl32", importc: "DestroyPropertySheetPage".}
proc InitCommonControls*(){.stdcall, dynlib: "comctl32",
                            importc: "InitCommonControls".}
proc ImageList_AddIcon*(himl: HIMAGELIST, hicon: HICON): int32
proc ImageList_Create*(cx: int32, cy: int32, flags: UINT, cInitial: int32,
                       cGrow: int32): HIMAGELIST{.stdcall, dynlib: "comctl32",
    importc: "ImageList_Create".}
proc ImageList_Destroy*(himl: HIMAGELIST): WINBOOL{.stdcall, dynlib: "comctl32",
    importc: "ImageList_Destroy".}
proc ImageList_GetImageCount*(himl: HIMAGELIST): int32{.stdcall,
    dynlib: "comctl32", importc: "ImageList_GetImageCount".}
proc ImageList_Add*(himl: HIMAGELIST, hbmImage: HBITMAP, hbmMask: HBITMAP): int32{.
    stdcall, dynlib: "comctl32", importc: "ImageList_Add".}
proc ImageList_ReplaceIcon*(himl: HIMAGELIST, i: int32, hicon: HICON): int32{.
    stdcall, dynlib: "comctl32", importc: "ImageList_ReplaceIcon".}
proc ImageList_SetBkColor*(himl: HIMAGELIST, clrBk: COLORREF): COLORREF{.
    stdcall, dynlib: "comctl32", importc: "ImageList_SetBkColor".}
proc ImageList_GetBkColor*(himl: HIMAGELIST): COLORREF{.stdcall,
    dynlib: "comctl32", importc: "ImageList_GetBkColor".}
proc ImageList_SetOverlayImage*(himl: HIMAGELIST, iImage: int32, iOverlay: int32): WINBOOL{.
    stdcall, dynlib: "comctl32", importc: "ImageList_SetOverlayImage".}
proc ImageList_Draw*(himl: HIMAGELIST, i: int32, hdcDst: HDC, x: int32,
                     y: int32, fStyle: UINT): WINBOOL{.stdcall,
    dynlib: "comctl32", importc: "ImageList_Draw".}
proc ImageList_Replace*(himl: HIMAGELIST, i: int32, hbmImage: HBITMAP,
                        hbmMask: HBITMAP): WINBOOL{.stdcall, dynlib: "comctl32",
    importc: "ImageList_Replace".}
proc ImageList_AddMasked*(himl: HIMAGELIST, hbmImage: HBITMAP, crMask: COLORREF): int32{.
    stdcall, dynlib: "comctl32", importc: "ImageList_AddMasked".}
proc ImageList_DrawEx*(himl: HIMAGELIST, i: int32, hdcDst: HDC, x: int32,
                       y: int32, dx: int32, dy: int32, rgbBk: COLORREF,
                       rgbFg: COLORREF, fStyle: UINT): WINBOOL{.stdcall,
    dynlib: "comctl32", importc: "ImageList_DrawEx".}
proc ImageList_Remove*(himl: HIMAGELIST, i: int32): WINBOOL{.stdcall,
    dynlib: "comctl32", importc: "ImageList_Remove".}
proc ImageList_GetIcon*(himl: HIMAGELIST, i: int32, flags: UINT): HICON{.
    stdcall, dynlib: "comctl32", importc: "ImageList_GetIcon".}
proc ImageList_BeginDrag*(himlTrack: HIMAGELIST, iTrack: int32,
                          dxHotspot: int32, dyHotspot: int32): WINBOOL{.stdcall,
    dynlib: "comctl32", importc: "ImageList_BeginDrag".}
proc ImageList_EndDrag*(){.stdcall, dynlib: "comctl32",
                           importc: "ImageList_EndDrag".}
proc ImageList_DragEnter*(hwndLock: HWND, x: int32, y: int32): WINBOOL{.stdcall,
    dynlib: "comctl32", importc: "ImageList_DragEnter".}
proc ImageList_DragLeave*(hwndLock: HWND): WINBOOL{.stdcall, dynlib: "comctl32",
    importc: "ImageList_DragLeave".}
proc ImageList_DragMove*(x: int32, y: int32): WINBOOL{.stdcall,
    dynlib: "comctl32", importc: "ImageList_DragMove".}
proc ImageList_SetDragCursorImage*(himlDrag: HIMAGELIST, iDrag: int32,
                                   dxHotspot: int32, dyHotspot: int32): WINBOOL{.
    stdcall, dynlib: "comctl32", importc: "ImageList_SetDragCursorImage".}
proc ImageList_DragShowNolock*(fShow: WINBOOL): WINBOOL{.stdcall,
    dynlib: "comctl32", importc: "ImageList_DragShowNolock".}
proc ImageList_GetDragImage*(ppt: LPPOINT, pptHotspot: LPPOINT): HIMAGELIST{.
    stdcall, dynlib: "comctl32", importc: "ImageList_GetDragImage".}
proc ImageList_GetIconSize*(himl: HIMAGELIST, cx: var int32, cy: var int32): WINBOOL{.
    stdcall, dynlib: "comctl32", importc: "ImageList_GetIconSize".}
proc ImageList_SetIconSize*(himl: HIMAGELIST, cx: int32, cy: int32): WINBOOL{.
    stdcall, dynlib: "comctl32", importc: "ImageList_SetIconSize".}
proc ImageList_GetImageInfo*(himl: HIMAGELIST, i: int32,
                             pImageInfo: var IMAGEINFO): WINBOOL{.stdcall,
    dynlib: "comctl32", importc: "ImageList_GetImageInfo".}
proc ImageList_Merge*(himl1: HIMAGELIST, i1: int32, himl2: HIMAGELIST,
                      i2: int32, dx: int32, dy: int32): HIMAGELIST{.stdcall,
    dynlib: "comctl32", importc: "ImageList_Merge".}
proc ImageList_SetImageCount*(himl: HIMAGELIST, uNewCount: UINT): int{.stdcall,
    dynlib: "comctl32.dll", importc: "ImageList_SetImageCount".}
proc CreateToolbarEx*(wnd: HWND, ws: DWORD, wID: UINT, nBitmaps: int32,
                      hBMInst: HINST, wBMID: UINT, lpButtons: LPCTBBUTTON,
                      iNumButtons: int32, dxButton: int32, dyButton: int32,
                      dxBitmap: int32, dyBitmap: int32, uStructSize: UINT): HWND{.
    stdcall, dynlib: "comctl32", importc: "CreateToolbarEx".}
proc CreateMappedBitmap*(hInstance: HINST, idBitmap: int32, wFlags: UINT,
                         lpColorMap: LPCOLORMAP, iNumMaps: int32): HBITMAP{.
    stdcall, dynlib: "comctl32", importc: "CreateMappedBitmap".}
proc MenuHelp*(uMsg: UINT, wp: WPARAM, lp: LPARAM, hMainMenu: HMENU,
               hInst: HINST, hwndStatus: HWND, lpwIDs: var UINT){.stdcall,
    dynlib: "comctl32", importc: "MenuHelp".}
proc ShowHideMenuCtl*(wnd: HWND, uFlags: UINT, lpInfo: LPINT): WINBOOL{.
    stdcall, dynlib: "comctl32", importc: "ShowHideMenuCtl".}
proc GetEffectiveClientRect*(wnd: HWND, lprc: LPRECT, lpInfo: LPINT){.stdcall,
    dynlib: "comctl32", importc: "GetEffectiveClientRect".}
proc MakeDragList*(hLB: HWND): WINBOOL{.stdcall, dynlib: "comctl32",
                                        importc: "MakeDragList".}
proc DrawInsert*(handParent: HWND, hLB: HWND, nItem: int32){.stdcall,
    dynlib: "comctl32", importc: "DrawInsert".}
proc LBItemFromPt*(hLB: HWND, pt: POINT, bAutoScroll: WINBOOL): int32{.stdcall,
    dynlib: "comctl32", importc: "LBItemFromPt".}
proc CreateUpDownControl*(dwStyle: DWORD, x: int32, y: int32, cx: int32,
                          cy: int32, hParent: HWND, nID: int32, hInst: HINST,
                          hBuddy: HWND, nUpper: int32, nLower: int32,
                          nPos: int32): HWND{.stdcall, dynlib: "comctl32",
    importc: "CreateUpDownControl".}
proc RegCloseKey*(key: HKEY): LONG{.stdcall, dynlib: "advapi32",
                                     importc: "RegCloseKey".}
proc RegSetKeySecurity*(key: HKEY, SecurityInformation: SECURITY_INFORMATION,
                        pSecurityDescriptor: PSECURITY_DESCRIPTOR): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegSetKeySecurity".}
proc RegFlushKey*(key: HKEY): LONG{.stdcall, dynlib: "advapi32",
                                     importc: "RegFlushKey".}
proc RegGetKeySecurity*(key: HKEY, SecurityInformation: SECURITY_INFORMATION,
                        pSecurityDescriptor: PSECURITY_DESCRIPTOR,
                        lpcbSecurityDescriptor: LPDWORD): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegGetKeySecurity".}
proc RegNotifyChangeKeyValue*(key: HKEY, bWatchSubtree: WINBOOL,
                              dwNotifyFilter: DWORD, hEvent: HANDLE,
                              fAsynchronus: WINBOOL): LONG{.stdcall,
    dynlib: "advapi32", importc: "RegNotifyChangeKeyValue".}
proc IsValidCodePage*(CodePage: UINT): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "IsValidCodePage".}
proc GetACP*(): UINT{.stdcall, dynlib: "kernel32", importc: "GetACP".}
proc GetOEMCP*(): UINT{.stdcall, dynlib: "kernel32", importc: "GetOEMCP".}
proc GetCPInfo*(para1: UINT, para2: LPCPINFO): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetCPInfo".}
proc IsDBCSLeadByte*(TestChar: int8): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "IsDBCSLeadByte".}
proc IsDBCSLeadByteEx*(CodePage: UINT, TestChar: int8): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "IsDBCSLeadByteEx".}
proc MultiByteToWideChar*(CodePage: UINT, dwFlags: DWORD,
                          lpMultiByteStr: LPCSTR, cchMultiByte: int32,
                          lpWideCharStr: LPWSTR, cchWideChar: int32): int32{.
    stdcall, dynlib: "kernel32", importc: "MultiByteToWideChar".}
proc WideCharToMultiByte*(CodePage: UINT, dwFlags: DWORD,
                          lpWideCharStr: LPCWSTR, cchWideChar: int32,
                          lpMultiByteStr: LPSTR, cchMultiByte: int32,
                          lpDefaultChar: LPCSTR, lpUsedDefaultChar: LPBOOL): int32{.
    stdcall, dynlib: "kernel32", importc: "WideCharToMultiByte".}
proc IsValidLocale*(Locale: LCID, dwFlags: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "IsValidLocale".}
proc ConvertDefaultLocale*(Locale: LCID): LCID{.stdcall, dynlib: "kernel32",
    importc: "ConvertDefaultLocale".}
proc GetThreadLocale*(): LCID{.stdcall, dynlib: "kernel32",
                               importc: "GetThreadLocale".}
proc SetThreadLocale*(Locale: LCID): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "SetThreadLocale".}
proc GetSystemDefaultLangID*(): LANGID{.stdcall, dynlib: "kernel32",
                                        importc: "GetSystemDefaultLangID".}
proc GetUserDefaultLangID*(): LANGID{.stdcall, dynlib: "kernel32",
                                      importc: "GetUserDefaultLangID".}
proc GetSystemDefaultLCID*(): LCID{.stdcall, dynlib: "kernel32",
                                    importc: "GetSystemDefaultLCID".}
proc GetUserDefaultLCID*(): LCID{.stdcall, dynlib: "kernel32",
                                  importc: "GetUserDefaultLCID".}
proc ReadConsoleOutputAttribute*(hConsoleOutput: HANDLE, lpAttribute: LPWORD,
                                 nLength: DWORD, dwReadCoord: COORD,
                                 lpNumberOfAttrsRead: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadConsoleOutputAttribute".}
proc WriteConsoleOutputAttribute*(hConsoleOutput: HANDLE,
                                  lpAttribute: var int16, nLength: DWORD,
                                  dwWriteCoord: COORD,
                                  lpNumberOfAttrsWritten: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleOutputAttribute".}
proc FillConsoleOutputAttribute*(hConsoleOutput: HANDLE, wAttribute: int16,
                                 nLength: DWORD, dwWriteCoord: COORD,
                                 lpNumberOfAttrsWritten: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FillConsoleOutputAttribute".}
proc GetConsoleMode*(hConsoleHandle: HANDLE, lpMode: LPDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetConsoleMode".}
proc GetNumberOfConsoleInputEvents*(hConsoleInput: HANDLE,
                                    lpNumberOfEvents: PDWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetNumberOfConsoleInputEvents".}
proc GetConsoleScreenBufferInfo*(hConsoleOutput: HANDLE,
    lpConsoleScreenBufferInfo: PCONSOLE_SCREEN_BUFFER_INFO): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetConsoleScreenBufferInfo".}
proc GetLargestConsoleWindowSize*(hConsoleOutput: HANDLE): COORD
proc GetConsoleCursorInfo*(hConsoleOutput: HANDLE,
                           lpConsoleCursorInfo: PCONSOLE_CURSOR_INFO): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetConsoleCursorInfo".}
proc GetNumberOfConsoleMouseButtons*(lpNumberOfMouseButtons: LPDWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetNumberOfConsoleMouseButtons".}
proc SetConsoleMode*(hConsoleHandle: HANDLE, dwMode: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetConsoleMode".}
proc SetConsoleActiveScreenBuffer*(hConsoleOutput: HANDLE): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetConsoleActiveScreenBuffer".}
proc FlushConsoleInputBuffer*(hConsoleInput: HANDLE): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "FlushConsoleInputBuffer".}
proc SetConsoleScreenBufferSize*(hConsoleOutput: HANDLE, dwSize: COORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetConsoleScreenBufferSize".}
proc SetConsoleCursorPosition*(hConsoleOutput: HANDLE, dwCursorPosition: COORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetConsoleCursorPosition".}
proc SetConsoleCursorInfo*(hConsoleOutput: HANDLE,
                           lpConsoleCursorInfo: PCONSOLE_CURSOR_INFO): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetConsoleCursorInfo".}
proc SetConsoleWindowInfo*(hConsoleOutput: HANDLE, bAbsolute: WINBOOL,
                           lpConsoleWindow: var SMALL_RECT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetConsoleWindowInfo".}
proc SetConsoleTextAttribute*(hConsoleOutput: HANDLE, wAttributes: int16): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetConsoleTextAttribute".}
proc SetConsoleCtrlHandler*(HandlerRoutine: PHANDLER_ROUTINE, Add: WINBOOL): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetConsoleCtrlHandler".}
proc GenerateConsoleCtrlEvent*(dwCtrlEvent: DWORD, dwProcessGroupId: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GenerateConsoleCtrlEvent".}
proc AllocConsole*(): WINBOOL{.stdcall, dynlib: "kernel32",
                               importc: "AllocConsole".}
proc FreeConsole*(): WINBOOL{.stdcall, dynlib: "kernel32",
                              importc: "FreeConsole".}
proc CreateConsoleScreenBuffer*(dwDesiredAccess: DWORD, dwShareMode: DWORD,
                                lpSecurityAttributes: var SECURITY_ATTRIBUTES,
                                dwFlags: DWORD, lpScreenBufferData: LPVOID): HANDLE{.
    stdcall, dynlib: "kernel32", importc: "CreateConsoleScreenBuffer".}
proc GetConsoleCP*(): UINT{.stdcall, dynlib: "kernel32", importc: "GetConsoleCP".}
proc SetConsoleCP*(wCodePageID: UINT): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "SetConsoleCP".}
proc GetConsoleOutputCP*(): UINT{.stdcall, dynlib: "kernel32",
                                  importc: "GetConsoleOutputCP".}
proc SetConsoleOutputCP*(wCodePageID: UINT): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetConsoleOutputCP".}
proc WNetConnectionDialog*(wnd: HWND, dwType: DWORD): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetConnectionDialog".}
proc WNetDisconnectDialog*(wnd: HWND, dwType: DWORD): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetDisconnectDialog".}
proc WNetCloseEnum*(hEnum: HANDLE): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetCloseEnum".}
proc CloseServiceHandle*(hSCObject: SC_HANDLE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "CloseServiceHandle".}
proc ControlService*(hService: SC_HANDLE, dwControl: DWORD,
                     lpServiceStatus: LPSERVICE_STATUS): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ControlService".}
proc DeleteService*(hService: SC_HANDLE): WINBOOL{.stdcall, dynlib: "advapi32",
    importc: "DeleteService".}
proc LockServiceDatabase*(hSCManager: SC_HANDLE): SC_LOCK{.stdcall,
    dynlib: "advapi32", importc: "LockServiceDatabase".}
proc NotifyBootConfigStatus*(BootAcceptable: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "NotifyBootConfigStatus".}
proc QueryServiceObjectSecurity*(hService: SC_HANDLE,
                                 dwSecurityInformation: SECURITY_INFORMATION,
                                 lpSecurityDescriptor: PSECURITY_DESCRIPTOR,
                                 cbBufSize: DWORD, pcbBytesNeeded: LPDWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "QueryServiceObjectSecurity".}
proc QueryServiceStatus*(hService: SC_HANDLE, lpServiceStatus: LPSERVICE_STATUS): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "QueryServiceStatus".}
proc SetServiceObjectSecurity*(hService: SC_HANDLE,
                               dwSecurityInformation: SECURITY_INFORMATION,
                               lpSecurityDescriptor: PSECURITY_DESCRIPTOR): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "SetServiceObjectSecurity".}
proc SetServiceStatus*(hServiceStatus: SERVICE_STATUS_HANDLE,
                       lpServiceStatus: LPSERVICE_STATUS): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "SetServiceStatus".}
proc UnlockServiceDatabase*(ScLock: SC_LOCK): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "UnlockServiceDatabase".}
proc ChoosePixelFormat*(para1: HDC, para2: PPIXELFORMATDESCRIPTOR): int32{.
    stdcall, dynlib: "gdi32", importc: "ChoosePixelFormat".}
proc DescribePixelFormat*(para1: HDC, para2: int32, para3: UINT,
                          para4: LPPIXELFORMATDESCRIPTOR): int32{.stdcall,
    dynlib: "gdi32", importc: "DescribePixelFormat".}
proc SetPixelFormat*(para1: HDC, para2: int32, para3: PPIXELFORMATDESCRIPTOR): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "SetPixelFormat".}
proc SwapBuffers*(para1: HDC): WINBOOL{.stdcall, dynlib: "gdi32",
                                        importc: "SwapBuffers".}
proc DragQueryPoint*(para1: HDROP, para2: LPPOINT): WINBOOL{.stdcall,
    dynlib: "shell32", importc: "DragQueryPoint".}
proc DragFinish*(para1: HDROP){.stdcall, dynlib: "shell32",
                                importc: "DragFinish".}
proc DragAcceptFiles*(para1: HWND, para2: WINBOOL){.stdcall, dynlib: "shell32",
    importc: "DragAcceptFiles".}
proc DuplicateIcon*(para1: HINST, para2: HICON): HICON{.stdcall,
    dynlib: "shell32", importc: "DuplicateIcon".}
proc DdeAbandonTransaction*(para1: DWORD, para2: HCONV, para3: DWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "DdeAbandonTransaction".}
proc DdeAccessData*(para1: HDDEDATA, para2: PDWORD): PBYTE{.stdcall,
    dynlib: "user32", importc: "DdeAccessData".}
proc DdeAddData*(para1: HDDEDATA, para2: PBYTE, para3: DWORD, para4: DWORD): HDDEDATA{.
    stdcall, dynlib: "user32", importc: "DdeAddData".}
proc DdeClientTransaction*(para1: PBYTE, para2: DWORD, para3: HCONV, para4: HSZ,
                           para5: UINT, para6: UINT, para7: DWORD, para8: PDWORD): HDDEDATA{.
    stdcall, dynlib: "user32", importc: "DdeClientTransaction".}
proc DdeCmpStringHandles*(para1: HSZ, para2: HSZ): int32{.stdcall,
    dynlib: "user32", importc: "DdeCmpStringHandles".}
proc DdeConnect*(para1: DWORD, para2: HSZ, para3: HSZ, para4: var CONVCONTEXT): HCONV{.
    stdcall, dynlib: "user32", importc: "DdeConnect".}
proc DdeConnectList*(para1: DWORD, para2: HSZ, para3: HSZ, para4: HCONVLIST,
                     para5: PCONVCONTEXT): HCONVLIST{.stdcall, dynlib: "user32",
    importc: "DdeConnectList".}
proc DdeCreateDataHandle*(para1: DWORD, para2: LPBYTE, para3: DWORD,
                          para4: DWORD, para5: HSZ, para6: UINT, para7: UINT): HDDEDATA{.
    stdcall, dynlib: "user32", importc: "DdeCreateDataHandle".}
proc DdeDisconnect*(para1: HCONV): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DdeDisconnect".}
proc DdeDisconnectList*(para1: HCONVLIST): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DdeDisconnectList".}
proc DdeEnableCallback*(para1: DWORD, para2: HCONV, para3: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "DdeEnableCallback".}
proc DdeFreeDataHandle*(para1: HDDEDATA): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DdeFreeDataHandle".}
proc DdeFreeStringHandle*(para1: DWORD, para2: HSZ): WINBOOL{.stdcall,
    dynlib: "user32", importc: "DdeFreeStringHandle".}
proc DdeGetData*(para1: HDDEDATA, para2: LPBYTE, para3: DWORD, para4: DWORD): DWORD{.
    stdcall, dynlib: "user32", importc: "DdeGetData".}
proc DdeGetLastError*(para1: DWORD): UINT{.stdcall, dynlib: "user32",
    importc: "DdeGetLastError".}
proc DdeImpersonateClient*(para1: HCONV): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DdeImpersonateClient".}
proc DdeKeepStringHandle*(para1: DWORD, para2: HSZ): WINBOOL{.stdcall,
    dynlib: "user32", importc: "DdeKeepStringHandle".}
proc DdeNameService*(para1: DWORD, para2: HSZ, para3: HSZ, para4: UINT): HDDEDATA{.
    stdcall, dynlib: "user32", importc: "DdeNameService".}
proc DdePostAdvise*(para1: DWORD, para2: HSZ, para3: HSZ): WINBOOL{.stdcall,
    dynlib: "user32", importc: "DdePostAdvise".}
proc DdeQueryConvInfo*(para1: HCONV, para2: DWORD, para3: PCONVINFO): UINT{.
    stdcall, dynlib: "user32", importc: "DdeQueryConvInfo".}
proc DdeQueryNextServer*(para1: HCONVLIST, para2: HCONV): HCONV{.stdcall,
    dynlib: "user32", importc: "DdeQueryNextServer".}
proc DdeReconnect*(para1: HCONV): HCONV{.stdcall, dynlib: "user32",
    importc: "DdeReconnect".}
proc DdeSetUserHandle*(para1: HCONV, para2: DWORD, para3: DWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "DdeSetUserHandle".}
proc DdeUnaccessData*(para1: HDDEDATA): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DdeUnaccessData".}
proc DdeUninitialize*(para1: DWORD): WINBOOL{.stdcall, dynlib: "user32",
    importc: "DdeUninitialize".}
proc SHAddToRecentDocs*(para1: UINT, para2: LPCVOID){.stdcall,
    dynlib: "shell32", importc: "SHAddToRecentDocs".}
proc SHBrowseForFolder*(para1: LPBROWSEINFO): LPITEMIDLIST{.stdcall,
    dynlib: "shell32", importc: "SHBrowseForFolder".}
proc SHChangeNotify*(para1: LONG, para2: UINT, para3: LPCVOID, para4: LPCVOID){.
    stdcall, dynlib: "shell32", importc: "SHChangeNotify".}
proc SHFileOperation*(para1: LPSHFILEOPSTRUCT): int32{.stdcall,
    dynlib: "shell32", importc: "SHFileOperation".}
proc SHFreeNameMappings*(para1: HANDLE){.stdcall, dynlib: "shell32",
    importc: "SHFreeNameMappings".}
proc SHGetFileInfo*(para1: LPCTSTR, para2: DWORD, para3: var SHFILEINFO,
                    para4: UINT, para5: UINT): DWORD{.stdcall,
    dynlib: "shell32", importc: "SHGetFileInfo".}
proc SHGetPathFromIDList*(para1: LPCITEMIDLIST, para2: LPTSTR): WINBOOL{.
    stdcall, dynlib: "shell32", importc: "SHGetPathFromIDList".}
proc SHGetSpecialFolderLocation*(para1: HWND, para2: int32,
                                 para3: var LPITEMIDLIST): HRESULT{.stdcall,
    dynlib: "shell32", importc: "SHGetSpecialFolderLocation".}
proc CommDlgExtendedError*(): DWORD{.stdcall, dynlib: "comdlg32",
                                     importc: "CommDlgExtendedError".}
  # wgl Windows OpenGL helper functions
proc wglUseFontBitmaps*(para1: HDC, para2: DWORD, para3: DWORD, para4: DWORD): WINBOOL{.
    stdcall, dynlib: "opengl32", importc: "wglUseFontBitmapsA".}
proc wglCreateContext*(para1: HDC): HGLRC{.stdcall, dynlib: "opengl32",
    importc: "wglCreateContext".}
proc wglCreateLayerContext*(para1: HDC, para2: int32): HGLRC{.stdcall,
    dynlib: "opengl32", importc: "wglCreateLayerContext".}
proc wglCopyContext*(para1: HGLRC, para2: HGLRC, para3: UINT): WINBOOL{.stdcall,
    dynlib: "opengl32", importc: "wglCopyContext".}
proc wglDeleteContext*(para1: HGLRC): WINBOOL{.stdcall, dynlib: "opengl32",
    importc: "wglDeleteContext".}
proc wglGetCurrentContext*(): HGLRC{.stdcall, dynlib: "opengl32",
                                     importc: "wglGetCurrentContext".}
proc wglGetCurrentDC*(): HDC{.stdcall, dynlib: "opengl32",
                              importc: "wglGetCurrentDC".}
proc wglMakeCurrent*(para1: HDC, para2: HGLRC): WINBOOL{.stdcall,
    dynlib: "opengl32", importc: "wglMakeCurrent".}
proc wglShareLists*(para1: HGLRC, para2: HGLRC): WINBOOL{.stdcall,
    dynlib: "opengl32", importc: "wglShareLists".}
proc wglUseFontBitmapsW*(para1: HDC, para2: DWORD, para3: DWORD, para4: DWORD): WINBOOL{.
    stdcall, dynlib: "opengl32", importc: "wglUseFontBitmapsW".}
proc wglUseFontOutlines*(para1: HDC, para2: DWORD, para3: DWORD, para4: DWORD,
                         para5: float32, para6: float32, para7: int32,
                         para8: LPGLYPHMETRICSFLOAT): WINBOOL{.stdcall,
    dynlib: "opengl32", importc: "wglUseFontOutlinesA".}
proc wglUseFontBitmapsA*(para1: HDC, para2: DWORD, para3: DWORD, para4: DWORD): WINBOOL{.
    stdcall, dynlib: "opengl32", importc: "wglUseFontBitmapsA".}
proc wglUseFontOutlinesA*(para1: HDC, para2: DWORD, para3: DWORD, para4: DWORD,
                          para5: float32, para6: float32, para7: int32,
                          para8: LPGLYPHMETRICSFLOAT): WINBOOL{.stdcall,
    dynlib: "opengl32", importc: "wglUseFontOutlinesA".}
proc wglDescribeLayerPlane*(para1: HDC, para2: int32, para3: int32, para4: UINT,
                            para5: LPLAYERPLANEDESCRIPTOR): WINBOOL{.stdcall,
    dynlib: "opengl32", importc: "wglDescribeLayerPlane".}
proc wglGetLayerPaletteEntries*(para1: HDC, para2: int32, para3: int32,
                                para4: int32, para5: var COLORREF): int32{.
    stdcall, dynlib: "opengl32", importc: "wglGetLayerPaletteEntries".}
proc wglGetProcAddress*(para1: LPCSTR): TProc{.stdcall, dynlib: "opengl32",
    importc: "wglGetProcAddress".}
proc wglRealizeLayerPalette*(para1: HDC, para2: int32, para3: WINBOOL): WINBOOL{.
    stdcall, dynlib: "opengl32", importc: "wglRealizeLayerPalette".}
proc wglSetLayerPaletteEntries*(para1: HDC, para2: int32, para3: int32,
                                para4: int32, para5: var COLORREF): int32{.
    stdcall, dynlib: "opengl32", importc: "wglSetLayerPaletteEntries".}
proc wglSwapLayerBuffers*(para1: HDC, para2: UINT): WINBOOL{.stdcall,
    dynlib: "opengl32", importc: "wglSwapLayerBuffers".}
proc wglUseFontOutlinesW*(para1: HDC, para2: DWORD, para3: DWORD, para4: DWORD,
                          para5: float32, para6: float32, para7: int32,
                          para8: LPGLYPHMETRICSFLOAT): WINBOOL{.stdcall,
    dynlib: "opengl32", importc: "wglUseFontOutlinesW".}
  # translated macros
proc Animate_Create*(hWndP: HWND, id: HMENU, dwStyle: DWORD, hInstance: HINST): HWND
proc Animate_Open*(wnd: HWND, szName: LPTSTR): LRESULT
proc Animate_Play*(wnd: HWND, `from`, `to`: int32, rep: UINT): LRESULT

proc Animate_Stop*(wnd: HWND): LRESULT
proc Animate_Close*(wnd: HWND): LRESULT
proc Animate_Seek*(wnd: HWND, frame: int32): LRESULT
proc PropSheet_AddPage*(hPropSheetDlg: HWND, hpage: HPROPSHEETPAGE): LRESULT
proc PropSheet_Apply*(hPropSheetDlg: HWND): LRESULT
proc PropSheet_CancelToClose*(hPropSheetDlg: HWND): LRESULT
proc PropSheet_Changed*(hPropSheetDlg, hwndPage: HWND): LRESULT
proc PropSheet_GetCurrentPageHwnd*(hDlg: HWND): LRESULT
proc PropSheet_GetTabControl*(hPropSheetDlg: HWND): LRESULT
proc PropSheet_IsDialogMessage*(hDlg: HWND, pMsg: int32): LRESULT
proc PropSheet_PressButton*(hPropSheetDlg: HWND, iButton: int32): LRESULT
proc PropSheet_QuerySiblings*(hPropSheetDlg: HWND, param1, param2: int32): LRESULT
proc PropSheet_RebootSystem*(hPropSheetDlg: HWND): LRESULT
proc PropSheet_RemovePage*(hPropSheetDlg: HWND, hpage: HPROPSHEETPAGE,
                           index: int32): LRESULT
proc PropSheet_RestartWindows*(hPropSheetDlg: HWND): LRESULT
proc PropSheet_SetCurSel*(hPropSheetDlg: HWND, hpage: HPROPSHEETPAGE,
                          index: int32): LRESULT
proc PropSheet_SetCurSelByID*(hPropSheetDlg: HWND, id: int32): LRESULT
proc PropSheet_SetFinishText*(hPropSheetDlg: HWND, lpszText: LPTSTR): LRESULT
proc PropSheet_SetTitle*(hPropSheetDlg: HWND, dwStyle: DWORD, lpszText: LPCTSTR): LRESULT
proc PropSheet_SetWizButtons*(hPropSheetDlg: HWND, dwFlags: DWORD): LRESULT
proc PropSheet_UnChanged*(hPropSheetDlg: HWND, hwndPage: HWND): LRESULT
proc Header_DeleteItem*(hwndHD: HWND, index: int32): WINBOOL
proc Header_GetItem*(hwndHD: HWND, index: int32, hdi: var HD_ITEM): WINBOOL
proc Header_GetItemCount*(hwndHD: HWND): int32
proc Header_InsertItem*(hwndHD: HWND, index: int32, hdi: var HD_ITEM): int32
proc Header_Layout*(hwndHD: HWND, layout: var HD_LAYOUT): WINBOOL
proc Header_SetItem*(hwndHD: HWND, index: int32, hdi: var HD_ITEM): WINBOOL
proc ListView_Arrange*(hwndLV: HWND, code: UINT): LRESULT
proc ListView_CreateDragImage*(wnd: HWND, i: int32, lpptUpLeft: LPPOINT): LRESULT
proc ListView_DeleteAllItems*(wnd: HWND): LRESULT
proc ListView_DeleteColumn*(wnd: HWND, iCol: int32): LRESULT
proc ListView_DeleteItem*(wnd: HWND, iItem: int32): LRESULT
proc ListView_EditLabel*(hwndLV: HWND, i: int32): LRESULT
proc ListView_EnsureVisible*(hwndLV: HWND, i, fPartialOK: int32): LRESULT
proc ListView_FindItem*(wnd: HWND, iStart: int32, lvfi: var LV_FINDINFO): int32
proc ListView_GetBkColor*(wnd: HWND): LRESULT
proc ListView_GetCallbackMask*(wnd: HWND): LRESULT
proc ListView_GetColumn*(wnd: HWND, iCol: int32, col: var LV_COLUMN): LRESULT
proc ListView_GetColumnWidth*(wnd: HWND, iCol: int32): LRESULT
proc ListView_GetCountPerPage*(hwndLV: HWND): LRESULT
proc ListView_GetEditControl*(hwndLV: HWND): LRESULT
proc ListView_GetImageList*(wnd: HWND, iImageList: wINT): LRESULT
proc ListView_GetISearchString*(hwndLV: HWND, lpsz: LPTSTR): LRESULT
proc ListView_GetItem*(wnd: HWND, item: var LV_ITEM): LRESULT
proc ListView_GetItemCount*(wnd: HWND): LRESULT
proc ListView_GetItemPosition*(hwndLV: HWND, i: int32, pt: var POINT): int32
proc ListView_GetItemSpacing*(hwndLV: HWND, fSmall: int32): LRESULT
proc ListView_GetItemState*(hwndLV: HWND, i, mask: int32): LRESULT
proc ListView_GetNextItem*(wnd: HWND, iStart, flags: int32): LRESULT
proc ListView_GetOrigin*(hwndLV: HWND, pt: var POINT): LRESULT
proc ListView_GetSelectedCount*(hwndLV: HWND): LRESULT
proc ListView_GetStringWidth*(hwndLV: HWND, psz: LPCTSTR): LRESULT
proc ListView_GetTextBkColor*(wnd: HWND): LRESULT
proc ListView_GetTextColor*(wnd: HWND): LRESULT
proc ListView_GetTopIndex*(hwndLV: HWND): LRESULT
proc ListView_GetViewRect*(wnd: HWND, rc: var RECT): LRESULT
proc ListView_HitTest*(hwndLV: HWND, info: var LV_HITTESTINFO): LRESULT
proc ListView_InsertColumn*(wnd: HWND, iCol: int32, col: var LV_COLUMN): LRESULT
proc ListView_InsertItem*(wnd: HWND, item: var LV_ITEM): LRESULT
proc ListView_RedrawItems*(hwndLV: HWND, iFirst, iLast: int32): LRESULT
proc ListView_Scroll*(hwndLV: HWND, dx, dy: int32): LRESULT
proc ListView_SetBkColor*(wnd: HWND, clrBk: COLORREF): LRESULT
proc ListView_SetCallbackMask*(wnd: HWND, mask: UINT): LRESULT
proc ListView_SetColumn*(wnd: HWND, iCol: int32, col: var LV_COLUMN): LRESULT
proc ListView_SetColumnWidth*(wnd: HWND, iCol, cx: int32): LRESULT
proc ListView_SetImageList*(wnd: HWND, himl: int32, iImageList: HIMAGELIST): LRESULT
proc ListView_SetItem*(wnd: HWND, item: var LV_ITEM): LRESULT
proc ListView_SetItemCount*(hwndLV: HWND, cItems: int32): LRESULT
proc ListView_SetItemPosition*(hwndLV: HWND, i, x, y: int32): LRESULT
proc ListView_SetItemPosition32*(hwndLV: HWND, i, x, y: int32): LRESULT
proc ListView_SetItemState*(hwndLV: HWND, i, data, mask: int32): LRESULT
proc ListView_SetItemText*(hwndLV: HWND, i, iSubItem: int32, pszText: LPTSTR): LRESULT
proc ListView_SetTextBkColor*(wnd: HWND, clrTextBk: COLORREF): LRESULT
proc ListView_SetTextColor*(wnd: HWND, clrText: COLORREF): LRESULT
proc ListView_SortItems*(hwndLV: HWND, pfnCompare: PFNLVCOMPARE, lPrm: LPARAM): LRESULT
proc ListView_Update*(hwndLV: HWND, i: int32): LRESULT
proc TreeView_InsertItem*(wnd: HWND, lpis: LPTV_INSERTSTRUCT): LRESULT
proc TreeView_DeleteItem*(wnd: HWND, hitem: HTREEITEM): LRESULT
proc TreeView_DeleteAllItems*(wnd: HWND): LRESULT
proc TreeView_Expand*(wnd: HWND, hitem: HTREEITEM, code: int32): LRESULT
proc TreeView_GetCount*(wnd: HWND): LRESULT
proc TreeView_GetIndent*(wnd: HWND): LRESULT
proc TreeView_SetIndent*(wnd: HWND, indent: int32): LRESULT
proc TreeView_GetImageList*(wnd: HWND, iImage: WPARAM): LRESULT
proc TreeView_SetImageList*(wnd: HWND, himl: HIMAGELIST, iImage: WPARAM): LRESULT
proc TreeView_GetNextItem*(wnd: HWND, hitem: HTREEITEM, code: int32): LRESULT
proc TreeView_GetChild*(wnd: HWND, hitem: HTREEITEM): LRESULT
proc TreeView_GetNextSibling*(wnd: HWND, hitem: HTREEITEM): LRESULT
proc TreeView_GetPrevSibling*(wnd: HWND, hitem: HTREEITEM): LRESULT
proc TreeView_GetParent*(wnd: HWND, hitem: HTREEITEM): LRESULT
proc TreeView_GetFirstVisible*(wnd: HWND): LRESULT
proc TreeView_GetNextVisible*(wnd: HWND, hitem: HTREEITEM): LRESULT
proc TreeView_GetPrevVisible*(wnd: HWND, hitem: HTREEITEM): LRESULT
proc TreeView_GetSelection*(wnd: HWND): LRESULT
proc TreeView_GetDropHilight*(wnd: HWND): LRESULT
proc TreeView_GetRoot*(wnd: HWND): LRESULT
proc TreeView_Select*(wnd: HWND, hitem: HTREEITEM, code: int32): LRESULT
proc TreeView_SelectItem*(wnd: HWND, hitem: HTREEITEM): LRESULT
proc TreeView_SelectDropTarget*(wnd: HWND, hitem: HTREEITEM): LRESULT
proc TreeView_SelectSetFirstVisible*(wnd: HWND, hitem: HTREEITEM): LRESULT
proc TreeView_GetItem*(wnd: HWND, item: var TV_ITEM): LRESULT
proc TreeView_SetItem*(wnd: HWND, item: var TV_ITEM): LRESULT
proc TreeView_EditLabel*(wnd: HWND, hitem: HTREEITEM): LRESULT
proc TreeView_GetEditControl*(wnd: HWND): LRESULT
proc TreeView_GetVisibleCount*(wnd: HWND): LRESULT
proc TreeView_HitTest*(wnd: HWND, lpht: LPTV_HITTESTINFO): LRESULT
proc TreeView_CreateDragImage*(wnd: HWND, hitem: HTREEITEM): LRESULT
proc TreeView_SortChildren*(wnd: HWND, hitem: HTREEITEM, recurse: int32): LRESULT
proc TreeView_EnsureVisible*(wnd: HWND, hitem: HTREEITEM): LRESULT
proc TreeView_SortChildrenCB*(wnd: HWND, psort: LPTV_SORTCB, recurse: int32): LRESULT
proc TreeView_EndEditLabelNow*(wnd: HWND, fCancel: int32): LRESULT
proc TreeView_GetISearchString*(hwndTV: HWND, lpsz: LPTSTR): LRESULT
proc TabCtrl_GetImageList*(wnd: HWND): LRESULT
proc TabCtrl_SetImageList*(wnd: HWND, himl: HIMAGELIST): LRESULT
proc TabCtrl_GetItemCount*(wnd: HWND): LRESULT
proc TabCtrl_GetItem*(wnd: HWND, iItem: int32, item: var TC_ITEM): LRESULT
proc TabCtrl_SetItem*(wnd: HWND, iItem: int32, item: var TC_ITEM): LRESULT

proc TabCtrl_InsertItem*(wnd: HWND, iItem: int32, item: var TC_ITEM): LRESULT
proc TabCtrl_DeleteItem*(wnd: HWND, i: int32): LRESULT
proc TabCtrl_DeleteAllItems*(wnd: HWND): LRESULT
proc TabCtrl_GetItemRect*(wnd: HWND, i: int32, rc: var RECT): LRESULT
proc TabCtrl_GetCurSel*(wnd: HWND): LRESULT
proc TabCtrl_SetCurSel*(wnd: HWND, i: int32): LRESULT
proc TabCtrl_HitTest*(hwndTC: HWND, info: var TC_HITTESTINFO): LRESULT
proc TabCtrl_SetItemExtra*(hwndTC: HWND, cb: int32): LRESULT
proc TabCtrl_AdjustRect*(wnd: HWND, bLarger: WINBOOL, rc: var RECT): LRESULT
proc TabCtrl_SetItemSize*(wnd: HWND, x, y: int32): LRESULT
proc TabCtrl_RemoveImage*(wnd: HWND, i: WPARAM): LRESULT
proc TabCtrl_SetPadding*(wnd: HWND, cx, cy: int32): LRESULT
proc TabCtrl_GetRowCount*(wnd: HWND): LRESULT
proc TabCtrl_GetToolTips*(wnd: HWND): LRESULT
proc TabCtrl_SetToolTips*(wnd: HWND, hwndTT: int32): LRESULT
proc TabCtrl_GetCurFocus*(wnd: HWND): LRESULT
proc TabCtrl_SetCurFocus*(wnd: HWND, i: int32): LRESULT
proc SNDMSG*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM): LRESULT
proc CommDlg_OpenSave_GetSpecA*(hdlg: HWND, psz: LPSTR, cbmax: int32): LRESULT
proc CommDlg_OpenSave_GetSpecW*(hdlg: HWND, psz: LPWSTR, cbmax: int32): LRESULT
when defined(winUnicode):
  proc CommDlg_OpenSave_GetSpec*(hdlg: HWND, psz: LPWSTR, cbmax: int32): LRESULT
else:
  proc CommDlg_OpenSave_GetSpec*(hdlg: HWND, psz: LPSTR, cbmax: int32): LRESULT
proc CommDlg_OpenSave_GetFilePathA*(hdlg: HWND, psz: LPSTR, cbmax: int32): LRESULT
proc CommDlg_OpenSave_GetFilePathW*(hdlg: HWND, psz: LPWSTR, cbmax: int32): LRESULT
when defined(winUnicode):
  proc CommDlg_OpenSave_GetFilePath*(hdlg: HWND, psz: LPWSTR, cbmax: int32): LRESULT
else:
  proc CommDlg_OpenSave_GetFilePath*(hdlg: HWND, psz: LPSTR, cbmax: int32): LRESULT
proc CommDlg_OpenSave_GetFolderPathA*(hdlg: HWND, psz: LPSTR, cbmax: int32): LRESULT
proc CommDlg_OpenSave_GetFolderPathW*(hdlg: HWND, psz: LPWSTR, cbmax: int32): LRESULT
when defined(winUnicode):
  proc CommDlg_OpenSave_GetFolderPath*(hdlg: HWND, psz: LPWSTR, cbmax: int32): LRESULT
else:
  proc CommDlg_OpenSave_GetFolderPath*(hdlg: HWND, psz: LPSTR, cbmax: int32): LRESULT
proc CommDlg_OpenSave_GetFolderIDList*(hdlg: HWND, pidl: LPVOID, cbmax: int32): LRESULT
proc CommDlg_OpenSave_SetControlText*(hdlg: HWND, id: int32, text: LPSTR): LRESULT
proc CommDlg_OpenSave_HideControl*(hdlg: HWND, id: int32): LRESULT
proc CommDlg_OpenSave_SetDefExt*(hdlg: HWND, pszext: LPSTR): LRESULT
proc GetNextWindow*(wnd: HWND, uCmd: UINT): HWND{.stdcall, dynlib: "user32",
    importc: "GetWindow".}
proc GlobalAllocPtr*(flags, cb: DWord): Pointer
proc GlobalFreePtr*(lp: Pointer): Pointer
proc GlobalUnlockPtr*(lp: pointer): Pointer
proc GlobalLockPtr*(lp: pointer): Pointer
proc GlobalReAllocPtr*(lp: Pointer, cbNew, flags: DWord): Pointer
proc GlobalPtrHandle*(lp: pointer): Pointer
proc SetLayeredWindowAttributes*(HWND: hwnd, crKey: COLORREF, bAlpha: int8,
                                 dwFlags: DWORD): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetLayeredWindowAttributes".}
type
  PIID* = PGUID
  TIID* = TGUID
  TFNDlgProc* = FARPROC
  TFNThreadStartRoutine* = FARPROC
  TFNTimerAPCRoutine* = FARPROC
  TFNFiberStartRoutine* = FARPROC
  TFNHookProc* = HOOKPROC
  PObjectTypeList* = ptr TObjectTypeList
  OBJECT_TYPE_LIST* {.final, pure.} = object
    Level*: int16
    Sbz*: int16
    ObjectType*: PGUID

  TObjectTypeList* = OBJECT_TYPE_LIST
  AUDIT_EVENT_TYPE* = DWORD
  PBlendFunction* = ptr TBlendFunction
  BLENDFUNCTION* {.final, pure.} = object
    BlendOp*: int8
    BlendFlags*: int8
    SourceConstantAlpha*: int8
    AlphaFormat*: int8

  TBlendFunction* = BLENDFUNCTION
  WIN_CERTIFICATE* {.final, pure.} = object
    dwLength*: DWord
    wRevision*: int16
    wCertificateType*: int16
    bCertificate*: array[0..0, int8]

  TWinCertificate* = WIN_CERTIFICATE
  PWinCertificate* = ptr TWinCertificate
  TMaxLogPalette* {.final, pure.} = object
    palVersion*: int16
    palNumEntries*: int16
    palPalEntry*: array[int8, TPaletteEntry]

  PMaxLogPalette* = ptr TMaxLogPalette
  POSVersionInfoA* = POSVERSIONINFO
  TBitmapFileHeader* = BITMAPFILEHEADER
  PBitmapFileHeader* = ptr TBitmapFileHeader

const
  # dll names
  advapi32* = "advapi32.dll"
  kernel32* = "kernel32.dll"
  mpr* = "mpr.dll"
  version* = "version.dll"
  comctl32* = "comctl32.dll"
  gdi32* = "gdi32.dll"
  opengl32* = "opengl32.dll"
  user32* = "user32.dll"
  wintrust* = "wintrust.dll"
  # Openfile Share modes normally declared in sysutils
  fmShareCompat* = 0x00000000
  fmShareExclusive* = 0x00000010
  fmShareDenyWrite* = 0x00000020
  fmShareDenyRead* = 0x00000030
  fmShareDenyNone* = 0x00000040
  # HRESULT codes, delphilike
  SIF_TRACKPOS* = 0x00000010
  HTBORDER* = 18
  CP_UTF7* = 65000
  CP_UTF8* = 65001
  CREATE_NO_WINDOW* = 0x08000000
  VK_ATTN* = 246
  VK_CRSEL* = 247
  VK_EXSEL* = 248
  VK_EREOF* = 249
  VK_PLAY* = 250
  VK_ZOOM* = 251
  VK_NONAME* = 252
  VK_PA1* = 253
  VK_OEM_CLEAR* = 254

const                         # Severity values
  FACILITY_NT_BIT* = 0x10000000

                            #  A language ID is a 16 bit value which is the combination of a
                            #  primary language ID and a secondary language ID.  The bits are
                            #  allocated as follows:
                            #
                            #       +-----------------------+-------------------------+
                            #       |     Sublanguage ID    |   Primary Language ID   |
                            #       +-----------------------+-------------------------+
                            #        15                   10 9                       0   bit
                            #
                            #
                            #  Language ID creation/extraction macros:
                            #
                            #    MAKELANGID    - construct language id from a primary language id and
                            #                    a sublanguage id.
                            #    PRIMARYLANGID - extract primary language id from a language id.
                            #    SUBLANGID     - extract sublanguage id from a language id.
                            #
proc MAKELANGID*(PrimaryLang, SubLang: USHORT): int16
proc PRIMARYLANGID*(LangId: int16): int16
proc SUBLANGID*(LangId: int16): int16

  #
  #  A locale ID is a 32 bit value which is the combination of a
  #  language ID, a sort ID, and a reserved area.  The bits are
  #  allocated as follows:
  #
  #       +-------------+---------+-------------------------+
  #       |   Reserved  | Sort ID |      Language ID        |
  #       +-------------+---------+-------------------------+
  #        31         20 19     16 15                      0   bit
  #
  #
  #  Locale ID creation/extraction macros:
  #
  #    MAKELCID            - construct the locale id from a language id and a sort id.
  #    MAKESORTLCID        - construct the locale id from a language id, sort id, and sort version.
  #    LANGIDFROMLCID      - extract the language id from a locale id.
  #    SORTIDFROMLCID      - extract the sort id from a locale id.
  #    SORTVERSIONFROMLCID - extract the sort version from a locale id.
  #
const
  NLS_VALID_LOCALE_MASK* = 0x000FFFFF

proc MAKELCID*(LangId, SortId: int16): DWORD
proc MAKESORTLCID*(LangId, SortId, SortVersion: int16): DWORD
proc LANGIDFROMLCID*(LocaleId: LCID): int16
proc SORTIDFROMLCID*(LocaleId: LCID): int16
proc SORTVERSIONFROMLCID*(LocaleId: LCID): int16

  #
  #  Default System and User IDs for language and locale.
  #
proc LANG_SYSTEM_DEFAULT*(): int16
proc LANG_USER_DEFAULT*(): int16
proc LOCALE_NEUTRAL*(): DWORD
proc LOCALE_INVARIANT*(): DWORD
proc Succeeded*(Status: HRESULT): WINBOOL
proc Failed*(Status: HRESULT): WINBOOL
proc IsError*(Status: HRESULT): WINBOOL
proc HResultCode*(hr: HRESULT): int32
proc HResultFacility*(hr: HRESULT): int32
proc HResultSeverity*(hr: HRESULT): int32
proc MakeResult*(p1, p2, mask: int32): HRESULT
proc HResultFromWin32*(x: int32): HRESULT
proc HResultFromNT*(x: int32): HRESULT
proc InitializeCriticalSection*(CriticalSection: var TRTLCriticalSection){.
    stdcall, dynlib: "kernel32", importc: "InitializeCriticalSection".}
proc EnterCriticalSection*(CriticalSection: var TRTLCriticalSection){.stdcall,
    dynlib: "kernel32", importc: "EnterCriticalSection".}
proc LeaveCriticalSection*(CriticalSection: var TRTLCriticalSection){.stdcall,
    dynlib: "kernel32", importc: "LeaveCriticalSection".}
proc DeleteCriticalSection*(CriticalSection: var TRTLCriticalSection){.stdcall,
    dynlib: "kernel32", importc: "DeleteCriticalSection".}
proc InitializeCriticalSectionAndSpinCount*(
    CriticalSection: var TRTLCriticalSection, dwSpinCount: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32",
    importc: "InitializeCriticalSectionAndSpinCount".}
proc SetCriticalSectionSpinCount*(CriticalSection: var TRTLCriticalSection,
                                  dwSpinCount: DWORD): DWORD{.stdcall,
    dynlib: "kernel32", importc: "SetCriticalSectionSpinCount".}
proc TryEnterCriticalSection*(CriticalSection: var TRTLCriticalSection): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "TryEnterCriticalSection".}
proc ControlService*(hService: SC_HANDLE, dwControl: DWORD,
                     ServiceStatus: var TSERVICESTATUS): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ControlService".}
proc QueryServiceStatus*(hService: SC_HANDLE,
                         lpServiceStatus: var TSERVICESTATUS): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "QueryServiceStatus".}
proc SetServiceStatus*(hServiceStatus: SERVICE_STATUS_HANDLE,
                       ServiceStatus: TSERVICESTATUS): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "SetServiceStatus".}
proc AdjustTokenPrivileges*(TokenHandle: THandle, DisableAllPrivileges: WINBOOL,
                            NewState: TTokenPrivileges, BufferLength: DWORD,
                            PreviousState: var TTokenPrivileges,
                            ReturnLength: var DWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "AdjustTokenPrivileges".}
proc AdjustWindowRect*(lpRect: var TRect, dwStyle: DWORD, bMenu: WINBOOL): WINBOOL{.
    stdcall, dynlib: "user32", importc: "AdjustWindowRect".}
proc AdjustWindowRectEx*(lpRect: var TRect, dwStyle: DWORD, bMenu: WINBOOL,
                         dwExStyle: DWORD): WINBOOL{.stdcall, dynlib: "user32",
    importc: "AdjustWindowRectEx".}
proc AllocateAndInitializeSid*(pIdentifierAuthority: TSIDIdentifierAuthority,
                               nSubAuthorityCount: int8,
                               nSubAuthority0, nSubAuthority1: DWORD,
    nSubAuthority2, nSubAuthority3, nSubAuthority4: DWORD, nSubAuthority5,
    nSubAuthority6, nSubAuthority7: DWORD, pSid: var Pointer): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "AllocateAndInitializeSid".}
proc AllocateLocallyUniqueId*(Luid: var TLargeInteger): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "AllocateLocallyUniqueId".}
proc BackupRead*(hFile: THandle, lpBuffer: PByte, nNumberOfBytesToRead: DWORD,
                 lpNumberOfBytesRead: var DWORD, bAbort: WINBOOL,
                 bProcessSecurity: WINBOOL, lpContext: var Pointer): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "BackupRead".}
proc BackupSeek*(hFile: THandle, dwLowBytesToSeek, dwHighBytesToSeek: DWORD,
                 lpdwLowByteSeeked, lpdwHighByteSeeked: var DWORD,
                 lpContext: Pointer): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "BackupSeek".}
proc BackupWrite*(hFile: THandle, lpBuffer: PByte, nNumberOfBytesToWrite: DWORD,
                  lpNumberOfBytesWritten: var DWORD,
                  bAbort, bProcessSecurity: WINBOOL, lpContext: var Pointer): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "BackupWrite".}
proc BeginPaint*(wnd: HWND, lpPaint: var TPaintStruct): HDC{.stdcall,
    dynlib: "user32", importc: "BeginPaint".}
proc BuildCommDCB*(lpDef: cstring, lpDCB: var TDCB): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "BuildCommDCBA".}
proc BuildCommDCBA*(lpDef: LPCSTR, lpDCB: var TDCB): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "BuildCommDCBA".}
proc BuildCommDCBAndTimeouts*(lpDef: cstring, lpDCB: var TDCB,
                              lpCommTimeouts: var TCommTimeouts): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "BuildCommDCBAndTimeoutsA".}
proc BuildCommDCBAndTimeoutsA*(lpDef: LPCSTR, lpDCB: var TDCB,
                               lpCommTimeouts: var TCommTimeouts): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "BuildCommDCBAndTimeoutsA".}
proc BuildCommDCBAndTimeoutsW*(lpDef: LPWSTR, lpDCB: var TDCB,
                               lpCommTimeouts: var TCommTimeouts): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "BuildCommDCBAndTimeoutsW".}
proc BuildCommDCBW*(lpDef: LPWSTR, lpDCB: var TDCB): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "BuildCommDCBW".}
proc CallMsgFilter*(lpMsg: var TMsg, nCode: int): WINBOOL{.stdcall,
    dynlib: "user32", importc: "CallMsgFilterA".}
proc CallMsgFilterA*(lpMsg: var TMsg, nCode: int): WINBOOL{.stdcall,
    dynlib: "user32", importc: "CallMsgFilterA".}
proc CallMsgFilterW*(lpMsg: var TMsg, nCode: int): WINBOOL{.stdcall,
    dynlib: "user32", importc: "CallMsgFilterW".}
proc CallNamedPipe*(lpNamedPipeName: cstring, lpInBuffer: Pointer,
                    nInBufferSize: DWORD, lpOutBuffer: Pointer,
                    nOutBufferSize: DWORD, lpBytesRead: var DWORD,
                    nTimeOut: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "CallNamedPipeA".}
proc CallNamedPipeA*(lpNamedPipeName: LPCSTR, lpInBuffer: Pointer,
                     nInBufferSize: DWORD, lpOutBuffer: Pointer,
                     nOutBufferSize: DWORD, lpBytesRead: var DWORD,
                     nTimeOut: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "CallNamedPipeA".}
proc CallNamedPipeW*(lpNamedPipeName: LPWSTR, lpInBuffer: Pointer,
                     nInBufferSize: DWORD, lpOutBuffer: Pointer,
                     nOutBufferSize: DWORD, lpBytesRead: var DWORD,
                     nTimeOut: DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "CallNamedPipeW".}
proc CoRegisterClassObject*(para1: TCLSID, para2: pointer, para3: DWORD,
                            para4: DWORD, out_para5: DWORD): HRESULT{.stdcall,
    dynlib: "ole32.dll", importc: "CoRegisterClassObject".}
proc ChangeDisplaySettings*(lpDevMode: var TDeviceMode, dwFlags: DWORD): int32{.
    stdcall, dynlib: "user32", importc: "ChangeDisplaySettingsA".}
proc ChangeDisplaySettingsA*(lpDevMode: var TDeviceModeA, dwFlags: DWORD): int32{.
    stdcall, dynlib: "user32", importc: "ChangeDisplaySettingsA".}
proc ChangeDisplaySettingsEx*(lpszDeviceName: cstring,
                              lpDevMode: var TDeviceMode, wnd: HWND,
                              dwFlags: DWORD, lParam: Pointer): int32{.stdcall,
    dynlib: "user32", importc: "ChangeDisplaySettingsExA".}
proc ChangeDisplaySettingsExA*(lpszDeviceName: LPCSTR,
                               lpDevMode: var TDeviceModeA, wnd: HWND,
                               dwFlags: DWORD, lParam: Pointer): int32{.stdcall,
    dynlib: "user32", importc: "ChangeDisplaySettingsExA".}
proc ChangeDisplaySettingsExW*(lpszDeviceName: LPWSTR,
                               lpDevMode: var TDeviceModeW, wnd: HWND,
                               dwFlags: DWORD, lParam: Pointer): int32{.stdcall,
    dynlib: "user32", importc: "ChangeDisplaySettingsExW".}
proc ChangeDisplaySettingsW*(lpDevMode: var TDeviceModeW, dwFlags: DWORD): int32{.
    stdcall, dynlib: "user32", importc: "ChangeDisplaySettingsW".}
  #function CheckColorsInGamut(DC: HDC; var RGBQuads, Results; Count: DWORD): WINBOOL; stdcall; external 'gdi32' name 'CheckColorsInGamut';
proc ChoosePixelFormat*(para1: HDC, para2: var PIXELFORMATDESCRIPTOR): int32{.
    stdcall, dynlib: "gdi32", importc: "ChoosePixelFormat".}
proc ClearCommError*(hFile: THandle, lpErrors: var DWORD, lpStat: PComStat): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ClearCommError".}
proc ClientToScreen*(wnd: HWND, lpPoint: var TPoint): WINBOOL{.stdcall,
    dynlib: "user32", importc: "ClientToScreen".}
proc ClipCursor*(lpRect: var RECT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "ClipCursor".}
  #function CombineTransform(var p1: TXForm; const p2, p3: TXForm): WINBOOL; stdcall; external 'gdi32' name 'CombineTransform';
proc CommConfigDialog*(lpszName: cstring, wnd: HWND, lpCC: var TCommConfig): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CommConfigDialogA".}
proc CommConfigDialogA*(lpszName: LPCSTR, wnd: HWND, lpCC: var TCommConfig): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CommConfigDialogA".}
proc CommConfigDialogW*(lpszName: LPWSTR, wnd: HWND, lpCC: var TCommConfig): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CommConfigDialogW".}
  #function CompareFileTime(const lpFileTime1, lpFileTime2: TFileTime): Longint; stdcall; external 'kernel32' name 'CompareFileTime';
  #function ConvertToAutoInheritPrivateObjectSecurity(ParentDescriptor, CurrentSecurityDescriptor: PSecurityDescriptor; var NewDescriptor: PSecurityDescriptor; ObjectType: PGUID; IsDirectoryObject: WINBOOL; const GenericMapping: TGenericMapping): WINBOOL;
  #  stdcall; external 'advapi32' name 'ConvertToAutoInheritPrivateObjectSecurity';
proc CopyAcceleratorTable*(hAccelSrc: HACCEL, lpAccelDst: pointer,
                           cAccelEntries: int): int{.stdcall, dynlib: "user32",
    importc: "CopyAcceleratorTableA".}
proc CopyAcceleratorTableA*(hAccelSrc: HACCEL, lpAccelDst: pointer,
                            cAccelEntries: int): int{.stdcall, dynlib: "user32",
    importc: "CopyAcceleratorTableA".}
proc CopyAcceleratorTableW*(hAccelSrc: HACCEL, lpAccelDst: pointer,
                            cAccelEntries: int): int{.stdcall, dynlib: "user32",
    importc: "CopyAcceleratorTableW".}
proc CopyRect*(lprcDst: var TRect, lprcSrc: TRect): WINBOOL{.stdcall,
    dynlib: "user32", importc: "CopyRect".}
proc CreateAcceleratorTable*(Accel: pointer, Count: int): HACCEL{.stdcall,
    dynlib: "user32", importc: "CreateAcceleratorTableA".}
proc CreateAcceleratorTableA*(Accel: pointer, Count: int): HACCEL{.stdcall,
    dynlib: "user32", importc: "CreateAcceleratorTableA".}
proc CreateAcceleratorTableW*(Accel: pointer, Count: int): HACCEL{.stdcall,
    dynlib: "user32", importc: "CreateAcceleratorTableW".}
  #function CreateBitmapIndirect(const p1: TBitmap): HBITMAP; stdcall; external 'gdi32' name 'CreateBitmapIndirect';
  #function CreateBrushIndirect(const p1: TLogBrush): HBRUSH; stdcall; external 'gdi32' name 'CreateBrushIndirect';
proc CreateColorSpace*(ColorSpace: var TLogColorSpace): HCOLORSPACE{.stdcall,
    dynlib: "gdi32", importc: "CreateColorSpaceA".}
proc CreateColorSpaceA*(ColorSpace: var TLogColorSpaceA): HCOLORSPACE{.stdcall,
    dynlib: "gdi32", importc: "CreateColorSpaceA".}
  #function CreateColorSpaceW(var ColorSpace: TLogColorSpaceW): HCOLORSPACE; stdcall; external 'gdi32' name 'CreateColorSpaceW';
proc CreateDialogIndirectParam*(hInstance: HINST, lpTemplate: TDlgTemplate,
                                hWndParent: HWND, lpDialogFunc: TFNDlgProc,
                                dwInitParam: LPARAM): HWND{.stdcall,
    dynlib: "user32", importc: "CreateDialogIndirectParamA".}
  #function CreateDialogIndirectParamA(hInstance: HINST; const lpTemplate: TDlgTemplate; hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND; stdcall; external 'user32' name 'CreateDialogIndirectParamA';
  #function CreateDialogIndirectParamW(hInstance: HINST; const lpTemplate: TDlgTemplate; hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND; stdcall; external 'user32' name 'CreateDialogIndirectParamW';
  #function CreateDIBitmap(DC: HDC; var InfoHeader: TBitmapInfoHeader; dwUsage: DWORD; InitBits: PChar; var InitInfo: TBitmapInfo; wUsage: UINT): HBITMAP; stdcall; external 'gdi32' name 'CreateDIBitmap';
  #function CreateDIBPatternBrushPt(const p1: Pointer; p2: UINT): HBRUSH; stdcall; external 'gdi32' name 'CreateDIBPatternBrushPt';
  #function CreateDIBSection(DC: HDC; const p2: TBitmapInfo; p3: UINT; var p4: Pointer; p5: THandle; p6: DWORD): HBITMAP; stdcall; external 'gdi32' name 'CreateDIBSection';
  #function CreateEllipticRgnIndirect(const p1: TRect): HRGN; stdcall; external 'gdi32' name 'CreateEllipticRgnIndirect';
  #function CreateFontIndirect(const p1: TLogFont): HFONT;stdcall; external 'gdi32' name 'CreateFontIndirectA';
  #function CreateFontIndirectA(const p1: TLogFontA): HFONT; stdcall; external 'gdi32' name 'CreateFontIndirectA';
  #function CreateFontIndirectEx(const p1: PEnumLogFontExDV): HFONT;stdcall; external 'gdi32' name 'CreateFontIndirectExA';
  #function CreateFontIndirectExA(const p1: PEnumLogFontExDVA): HFONT;stdcall; external 'gdi32' name 'CreateFontIndirectExA';
  #function CreateFontIndirectExW(const p1: PEnumLogFontExDVW): HFONT;stdcall; external 'gdi32' name 'CreateFontIndirectExW';
  #function CreateFontIndirectW(const p1: TLogFontW): HFONT; stdcall; external 'gdi32' name 'CreateFontIndirectW';
proc CreateIconIndirect*(piconinfo: var TIconInfo): HICON{.stdcall,
    dynlib: "user32", importc: "CreateIconIndirect".}
  #function CreatePalette(const LogPalette: TLogPalette): HPalette; stdcall; external 'gdi32' name 'CreatePalette';
  #function CreatePenIndirect(const LogPen: TLogPen): HPEN; stdcall; external 'gdi32' name 'CreatePenIndirect';
proc CreatePipe*(hReadPipe, hWritePipe: var THandle,
                 lpPipeAttributes: PSecurityAttributes, nSize: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CreatePipe".}
proc CreatePolygonRgn*(Points: pointer, Count, FillMode: int): HRGN{.stdcall,
    dynlib: "gdi32", importc: "CreatePolygonRgn".}
proc CreatePolyPolygonRgn*(pPtStructs: pointer, pIntArray: pointer, p3, p4: int): HRGN{.
    stdcall, dynlib: "gdi32", importc: "CreatePolyPolygonRgn".}
  #function CreatePrivateObjectSecurity(ParentDescriptor, CreatorDescriptor: PSecurityDescriptor; var NewDescriptor: PSecurityDescriptor; IsDirectoryObject: WINBOOL; Token: THandle; const GenericMapping: TGenericMapping): WINBOOL;
  #  stdcall; external 'advapi32' name 'CreatePrivateObjectSecurity';
  #function CreatePrivateObjectSecurityEx(ParentDescriptor, CreatorDescriptor: PSecurityDescriptor; var NewDescriptor: PSecurityDescriptor; ObjectType: PGUID; IsContainerObject: WINBOOL; AutoInheritFlags: ULONG; Token: THandle;
  #  const GenericMapping: TGenericMapping): WINBOOL;stdcall; external 'advapi32' name 'CreatePrivateObjectSecurityEx';
proc CreateProcess*(lpApplicationName: cstring, lpCommandLine: cstring,
    lpProcessAttributes, lpThreadAttributes: PSecurityAttributes,
                    bInheritHandles: WINBOOL, dwCreationFlags: DWORD,
                    lpEnvironment: Pointer, lpCurrentDirectory: cstring,
                    lpStartupInfo: TStartupInfo,
                    lpProcessInformation: var TProcessInformation): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CreateProcessA".}
proc CreateProcessA*(lpApplicationName: LPCSTR, lpCommandLine: LPCSTR,
    lpProcessAttributes, lpThreadAttributes: PSecurityAttributes,
                     bInheritHandles: WINBOOL, dwCreationFlags: DWORD,
                     lpEnvironment: Pointer, lpCurrentDirectory: LPCSTR,
                     lpStartupInfo: TStartupInfo,
                     lpProcessInformation: var TProcessInformation): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CreateProcessA".}
  #function CreateProcessAsUser(hToken: THandle; lpApplicationName: PChar; lpCommandLine: PChar; lpProcessAttributes: PSecurityAttributes; lpThreadAttributes: PSecurityAttributes; bInheritHandles: WINBOOL; dwCreationFlags: DWORD;
  # lpEnvironment: Pointer; lpCurrentDirectory: PChar; const lpStartupInfo: TStartupInfo; var lpProcessInformation: TProcessInformation): WINBOOL;stdcall; external 'advapi32' name 'CreateProcessAsUserA';
  #function CreateProcessAsUserA(hToken: THandle; lpApplicationName: LPCSTR; lpCommandLine: LPCSTR; lpProcessAttributes: PSecurityAttributes; lpThreadAttributes: PSecurityAttributes; bInheritHandles: WINBOOL; dwCreationFlags: DWORD;
  #  lpEnvironment: Pointer; lpCurrentDirectory: LPCSTR; const lpStartupInfo: TStartupInfo; var lpProcessInformation: TProcessInformation): WINBOOL; stdcall; external 'advapi32' name 'CreateProcessAsUserA';
  #function CreateProcessAsUserW(hToken: THandle; lpApplicationName: LPWSTR; lpCommandLine: LPWSTR; lpProcessAttributes: PSecurityAttributes; lpThreadAttributes: PSecurityAttributes; bInheritHandles: WINBOOL; dwCreationFlags: DWORD;
  #  lpEnvironment: Pointer; lpCurrentDirectory: LPWSTR; const lpStartupInfo: TStartupInfo; var lpProcessInformation: TProcessInformation): WINBOOL; stdcall; external 'advapi32' name 'CreateProcessAsUserW';
proc CreateProcessW*(lpApplicationName: LPWSTR, lpCommandLine: LPWSTR,
    lpProcessAttributes, lpThreadAttributes: PSecurityAttributes,
                     bInheritHandles: WINBOOL, dwCreationFlags: DWORD,
                     lpEnvironment: Pointer, lpCurrentDirectory: LPWSTR,
                     lpStartupInfo: TStartupInfo,
                     lpProcessInformation: var TProcessInformation): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "CreateProcessW".}
  #function CreateRectRgnIndirect(const p1: TRect): HRGN; stdcall; external 'gdi32' name 'CreateRectRgnIndirect';
proc CreateRemoteThread*(hProcess: THandle, lpThreadAttributes: Pointer,
                         dwStackSize: DWORD,
                         lpStartAddress: TFNThreadStartRoutine,
                         lpParameter: Pointer, dwCreationFlags: DWORD,
                         lpThreadId: var DWORD): THandle{.stdcall,
    dynlib: "kernel32", importc: "CreateRemoteThread".}
proc CreateThread*(lpThreadAttributes: Pointer, dwStackSize: DWORD,
                   lpStartAddress: TFNThreadStartRoutine, lpParameter: Pointer,
                   dwCreationFlags: DWORD, lpThreadId: var DWORD): THandle{.
    stdcall, dynlib: "kernel32", importc: "CreateThread".}
proc DdeSetQualityOfService*(hWndClient: HWnd,
                             pqosNew: TSecurityQualityOfService,
                             pqosPrev: PSecurityQualityOfService): WINBOOL{.
    stdcall, dynlib: "user32", importc: "DdeSetQualityOfService".}
  #function DeleteAce(var pAcl: TACL; dwAceIndex: DWORD): WINBOOL; stdcall; external 'advapi32' name 'DeleteAce';
proc DescribePixelFormat*(DC: HDC, p2: int, p3: UINT,
                          p4: var TPixelFormatDescriptor): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "DescribePixelFormat".}
  #function DestroyPrivateObjectSecurity(var ObjectDescriptor: PSecurityDescriptor): WINBOOL; stdcall; external 'advapi32' name 'DestroyPrivateObjectSecurity';
proc DeviceIoControl*(hDevice: THandle, dwIoControlCode: DWORD,
                      lpInBuffer: Pointer, nInBufferSize: DWORD,
                      lpOutBuffer: Pointer, nOutBufferSize: DWORD,
                      lpBytesReturned: var DWORD, lpOverlapped: POverlapped): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "DeviceIoControl".}
proc DialogBoxIndirectParam*(hInstance: HINST, lpDialogTemplate: TDlgTemplate,
                             hWndParent: HWND, lpDialogFunc: TFNDlgProc,
                             dwInitParam: LPARAM): int{.stdcall,
    dynlib: "user32", importc: "DialogBoxIndirectParamA".}
proc DialogBoxIndirectParamA*(hInstance: HINST, lpDialogTemplate: TDlgTemplate,
                              hWndParent: HWND, lpDialogFunc: TFNDlgProc,
                              dwInitParam: LPARAM): int{.stdcall,
    dynlib: "user32", importc: "DialogBoxIndirectParamA".}
proc DialogBoxIndirectParamW*(hInstance: HINST, lpDialogTemplate: TDlgTemplate,
                              hWndParent: HWND, lpDialogFunc: TFNDlgProc,
                              dwInitParam: LPARAM): int{.stdcall,
    dynlib: "user32", importc: "DialogBoxIndirectParamW".}
proc DispatchMessage*(lpMsg: TMsg): int32{.stdcall, dynlib: "user32",
    importc: "DispatchMessageA".}
proc DispatchMessageA*(lpMsg: TMsg): int32{.stdcall, dynlib: "user32",
    importc: "DispatchMessageA".}
proc DispatchMessageW*(lpMsg: TMsg): int32{.stdcall, dynlib: "user32",
    importc: "DispatchMessageW".}
proc DosDateTimeToFileTime*(wFatDate, wFatTime: int16, lpFileTime: var TFileTime): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "DosDateTimeToFileTime".}
proc DPtoLP*(DC: HDC, Points: pointer, Count: int): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "DPtoLP".}
  # function DrawAnimatedRects(wnd: HWND; idAni: Integer; const lprcFrom, lprcTo: TRect): WINBOOL; stdcall; external 'user32' name 'DrawAnimatedRects';
  #function DrawCaption(p1: HWND; p2: HDC; const p3: TRect; p4: UINT): WINBOOL; stdcall; external 'user32' name 'DrawCaption';
proc DrawEdge*(hdc: HDC, qrc: var TRect, edge: UINT, grfFlags: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "DrawEdge".}
  #function DrawFocusRect(hDC: HDC; const lprc: TRect): WINBOOL; stdcall; external 'user32' name 'DrawFocusRect';
proc DrawFrameControl*(DC: HDC, Rect: TRect, uType, uState: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "DrawFrameControl".}
proc DrawText*(hDC: HDC, lpString: cstring, nCount: int, lpRect: var TRect,
               uFormat: UINT): int{.stdcall, dynlib: "user32",
                                    importc: "DrawTextA".}
proc DrawTextA*(hDC: HDC, lpString: LPCSTR, nCount: int, lpRect: var TRect,
                uFormat: UINT): int{.stdcall, dynlib: "user32",
                                     importc: "DrawTextA".}
proc DrawTextEx*(DC: HDC, lpchText: cstring, cchText: int, p4: var TRect,
                 dwDTFormat: UINT, DTParams: PDrawTextParams): int{.stdcall,
    dynlib: "user32", importc: "DrawTextExA".}
proc DrawTextExA*(DC: HDC, lpchText: LPCSTR, cchText: int, p4: var TRect,
                  dwDTFormat: UINT, DTParams: PDrawTextParams): int{.stdcall,
    dynlib: "user32", importc: "DrawTextExA".}
proc DrawTextExW*(DC: HDC, lpchText: LPWSTR, cchText: int, p4: var TRect,
                  dwDTFormat: UINT, DTParams: PDrawTextParams): int{.stdcall,
    dynlib: "user32", importc: "DrawTextExW".}
proc DrawTextW*(hDC: HDC, lpString: LPWSTR, nCount: int, lpRect: var TRect,
                uFormat: UINT): int{.stdcall, dynlib: "user32",
                                     importc: "DrawTextW".}
  #function DuplicateTokenEx(hExistingToken: THandle; dwDesiredAccess: DWORD; lpTokenAttributes: PSecurityAttributes; ImpersonationLevel: TSecurityImpersonationLevel; TokenType: TTokenType; var phNewToken: THandle): WINBOOL;
  #  stdcall; external 'advapi32' name 'DuplicateTokenEx';
proc EndPaint*(wnd: HWND, lpPaint: TPaintStruct): WINBOOL{.stdcall,
    dynlib: "user32", importc: "EndPaint".}
  #function EnumDisplayDevices(Unused: Pointer; iDevNum: DWORD; var lpDisplayDevice: TDisplayDevice; dwFlags: DWORD): WINBOOL;stdcall; external 'user32' name 'EnumDisplayDevicesA';
  #function EnumDisplayDevicesA(Unused: Pointer; iDevNum: DWORD; var lpDisplayDevice: TDisplayDeviceA; dwFlags: DWORD): WINBOOL;stdcall; external 'user32' name 'EnumDisplayDevicesA';
  #function EnumDisplayDevicesW(Unused: Pointer; iDevNum: DWORD; var lpDisplayDevice: TDisplayDeviceW; dwFlags: DWORD): WINBOOL;stdcall; external 'user32' name 'EnumDisplayDevicesW';
proc EnumDisplaySettings*(lpszDeviceName: cstring, iModeNum: DWORD,
                          lpDevMode: var TDeviceMode): WINBOOL{.stdcall,
    dynlib: "user32", importc: "EnumDisplaySettingsA".}
proc EnumDisplaySettingsA*(lpszDeviceName: LPCSTR, iModeNum: DWORD,
                           lpDevMode: var TDeviceModeA): WINBOOL{.stdcall,
    dynlib: "user32", importc: "EnumDisplaySettingsA".}
proc EnumDisplaySettingsW*(lpszDeviceName: LPWSTR, iModeNum: DWORD,
                           lpDevMode: var TDeviceModeW): WINBOOL{.stdcall,
    dynlib: "user32", importc: "EnumDisplaySettingsW".}
  #function EnumEnhMetaFile(DC: HDC; p2: HENHMETAFILE; p3: TFNEnhMFEnumProc; p4: Pointer; const p5: TRect): WINBOOL; stdcall; external 'gdi32' name 'EnumEnhMetaFile';
  #function EnumFontFamiliesEx(DC: HDC; var p2: TLogFont; p3: TFNFontEnumProc; p4: LPARAM; p5: DWORD): WINBOOL;stdcall; external 'gdi32' name 'EnumFontFamiliesExA';
  #function EnumFontFamiliesExA(DC: HDC; var p2: TLogFontA; p3: TFNFontEnumProcA; p4: LPARAM; p5: DWORD): WINBOOL; stdcall; external 'gdi32' name 'EnumFontFamiliesExA';
  #function EnumFontFamiliesExW(DC: HDC; var p2: TLogFontW; p3: TFNFontEnumProcW; p4: LPARAM; p5: DWORD): WINBOOL; stdcall; external 'gdi32' name 'EnumFontFamiliesExW';
  #function EqualRect(const lprc1, lprc2: TRect): WINBOOL; stdcall; external 'user32' name 'EqualRect';
proc ExtCreatePen*(PenStyle, Width: DWORD, Brush: TLogBrush, StyleCount: DWORD,
                   Style: Pointer): HPEN{.stdcall, dynlib: "gdi32",
    importc: "ExtCreatePen".}
proc ExtCreateRegion*(p1: PXForm, p2: DWORD, p3: TRgnData): HRGN{.stdcall,
    dynlib: "gdi32", importc: "ExtCreateRegion".}
  # function ExtEscape(DC: HDC; p2, p3: Integer; const p4: LPCSTR; p5: Integer; p6: LPSTR): Integer; stdcall; external 'gdi32' name 'ExtEscape';
proc FileTimeToDosDateTime*(lpFileTime: TFileTime,
                            lpFatDate, lpFatTime: var int16): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "FileTimeToDosDateTime".}
proc FileTimeToLocalFileTime*(lpFileTime: TFileTime,
                              lpLocalFileTime: var TFileTime): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "FileTimeToLocalFileTime".}
proc FileTimeToSystemTime*(lpFileTime: TFileTime, lpSystemTime: var TSystemTime): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FileTimeToSystemTime".}
proc FillConsoleOutputAttribute*(hConsoleOutput: THandle, wAttribute: int16,
                                 nLength: DWORD, dwWriteCoord: TCoord,
                                 lpNumberOfAttrsWritten: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FillConsoleOutputAttribute".}
proc FillConsoleOutputCharacter*(hConsoleOutput: THandle, cCharacter: Char,
                                 nLength: DWORD, dwWriteCoord: TCoord,
                                 lpNumberOfCharsWritten: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FillConsoleOutputCharacterA".}
proc FillConsoleOutputCharacterA*(hConsoleOutput: THandle, cCharacter: char,
                                  nLength: DWORD, dwWriteCoord: TCoord,
                                  lpNumberOfCharsWritten: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FillConsoleOutputCharacterA".}
proc FillConsoleOutputCharacterW*(hConsoleOutput: THandle, cCharacter: WideChar,
                                  nLength: DWORD, dwWriteCoord: TCoord,
                                  lpNumberOfCharsWritten: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FillConsoleOutputCharacterW".}
  #function FillRect(hDC: HDC; const lprc: TRect; hbr: HBRUSH): Integer; stdcall; external 'user32' name 'FillRect';
proc FindFirstFile*(lpFileName: cstring, lpFindFileData: var TWIN32FindData): THandle{.
    stdcall, dynlib: "kernel32", importc: "FindFirstFileA".}
proc FindFirstFileA*(lpFileName: LPCSTR, lpFindFileData: var TWIN32FindDataA): THandle{.
    stdcall, dynlib: "kernel32", importc: "FindFirstFileA".}
proc FindFirstFileW*(lpFileName: LPWSTR, lpFindFileData: var TWIN32FindDataW): THandle{.
    stdcall, dynlib: "kernel32", importc: "FindFirstFileW".}
  #function FindFirstFreeAce(var pAcl: TACL; var pAce: Pointer): WINBOOL; stdcall; external 'advapi32' name 'FindFirstFreeAce';
proc FindNextFile*(hFindFile: THandle, lpFindFileData: var TWIN32FindData): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FindNextFileA".}
proc FindNextFileA*(hFindFile: THandle, lpFindFileData: var TWIN32FindDataA): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FindNextFileA".}
proc FindNextFileW*(hFindFile: THandle, lpFindFileData: var TWIN32FindDataW): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "FindNextFileW".}
  #function FlushInstructionCache(hProcess: THandle; const lpBaseAddress: Pointer; dwSize: DWORD): WINBOOL; stdcall; external 'kernel32' name 'FlushInstructionCache';
  #function FlushViewOfFile(const lpBaseAddress: Pointer; dwNumberOfBytesToFlush: DWORD): WINBOOL; stdcall; external 'kernel32' name 'FlushViewOfFile';
  #function FrameRect(hDC: HDC; const lprc: TRect; hbr: HBRUSH): Integer; stdcall; external 'user32' name 'FrameRect';
  #function GetAce(const pAcl: TACL; dwAceIndex: DWORD; var pAce: Pointer): WINBOOL; stdcall; external 'advapi32' name 'GetAce';
  #function GetAclInformation(const pAcl: TACL; pAclInformation: Pointer; nAclInformationLength: DWORD; dwAclInformationClass: TAclInformationClass): WINBOOL; stdcall; external 'advapi32' name 'GetAclInformation';
  #function GetAltTabInfo(wnd: HWND; iItem: Integer; var pati: TAltTabInfo; pszItemText: PChar; cchItemText: UINT): WINBOOL;stdcall; external 'user32' name 'GetAltTabInfoA';
  #function GetAltTabInfoA(wnd: HWND; iItem: Integer; var pati: TAltTabInfo; pszItemText: LPCSTR; cchItemText: UINT): WINBOOL;stdcall; external 'user32' name 'GetAltTabInfoA';
  #function GetAltTabInfoW(wnd: HWND; iItem: Integer; var pati: TAltTabInfo; pszItemText: LPWSTR; cchItemText: UINT): WINBOOL;stdcall; external 'user32' name 'GetAltTabInfoW';
proc GetAspectRatioFilterEx*(DC: HDC, p2: var TSize): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetAspectRatioFilterEx".}
proc GetBinaryType*(lpApplicationName: cstring, lpBinaryType: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetBinaryTypeA".}
proc GetBinaryTypeA*(lpApplicationName: LPCSTR, lpBinaryType: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetBinaryTypeA".}
proc GetBinaryTypeW*(lpApplicationName: LPWSTR, lpBinaryType: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetBinaryTypeW".}
proc GetBitmapDimensionEx*(p1: HBITMAP, p2: var TSize): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetBitmapDimensionEx".}
proc GetBoundsRect*(DC: HDC, p2: var TRect, p3: UINT): UINT{.stdcall,
    dynlib: "gdi32", importc: "GetBoundsRect".}
proc GetBrushOrgEx*(DC: HDC, p2: var TPoint): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "GetBrushOrgEx".}
proc GetCaretPos*(lpPoint: var TPoint): WINBOOL{.stdcall, dynlib: "user32",
    importc: "GetCaretPos".}
proc GetCharABCWidths*(DC: HDC, p2, p3: UINT, ABCStructs: pointer): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharABCWidthsA".}
proc GetCharABCWidthsA*(DC: HDC, p2, p3: UINT, ABCStructs: pointer): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharABCWidthsA".}
proc GetCharABCWidthsFloat*(DC: HDC, p2, p3: UINT, ABCFloatSturcts: pointer): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharABCWidthsFloatA".}
proc GetCharABCWidthsFloatA*(DC: HDC, p2, p3: UINT, ABCFloatSturcts: pointer): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharABCWidthsFloatA".}
proc GetCharABCWidthsFloatW*(DC: HDC, p2, p3: UINT, ABCFloatSturcts: pointer): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharABCWidthsFloatW".}
  #function GetCharABCWidthsI(DC: HDC; p2, p3: UINT; p4: PWORD; const Widths): WINBOOL;stdcall; external 'gdi32' name 'GetCharABCWidthsI';
proc GetCharABCWidthsW*(DC: HDC, p2, p3: UINT, ABCStructs: pointer): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharABCWidthsW".}
proc GetCharacterPlacement*(DC: HDC, p2: cstring, p3, p4: WINBOOL,
                            p5: var TGCPResults, p6: DWORD): DWORD{.stdcall,
    dynlib: "gdi32", importc: "GetCharacterPlacementA".}
proc GetCharacterPlacementA*(DC: HDC, p2: LPCSTR, p3, p4: WINBOOL,
                             p5: var TGCPResults, p6: DWORD): DWORD{.stdcall,
    dynlib: "gdi32", importc: "GetCharacterPlacementA".}
proc GetCharacterPlacementW*(DC: HDC, p2: LPWSTR, p3, p4: WINBOOL,
                             p5: var TGCPResults, p6: DWORD): DWORD{.stdcall,
    dynlib: "gdi32", importc: "GetCharacterPlacementW".}
proc GetCharWidth*(DC: HDC, p2, p3: UINT, Widths: pointer): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetCharWidthA".}
proc GetCharWidth32*(DC: HDC, p2, p3: UINT, Widths: pointer): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetCharWidth32A".}
proc GetCharWidth32A*(DC: HDC, p2, p3: UINT, Widths: pointer): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetCharWidth32A".}
proc GetCharWidth32W*(DC: HDC, p2, p3: UINT, Widths: pointer): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetCharWidth32W".}
proc GetCharWidthA*(DC: HDC, p2, p3: UINT, Widths: pointer): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetCharWidthA".}
proc GetCharWidthFloat*(DC: HDC, p2, p3: UINT, Widths: pointer): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharWidthFloatA".}
proc GetCharWidthFloatA*(DC: HDC, p2, p3: UINT, Widths: pointer): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharWidthFloatA".}
proc GetCharWidthFloatW*(DC: HDC, p2, p3: UINT, Widths: pointer): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetCharWidthFloatW".}
  #function GetCharWidthI(DC: HDC; p2, p3: UINT; p4: PWORD; const Widths:pointer): WINBOOL;stdcall; external 'gdi32' name 'GetCharWidthI';
proc GetCharWidthW*(DC: HDC, p2, p3: UINT, Widths: pointer): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetCharWidthW".}
proc GetClassInfo*(hInstance: HINST, lpClassName: cstring,
                   lpWndClass: var TWndClass): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetClassInfoA".}
proc GetClassInfoA*(hInstance: HINST, lpClassName: LPCSTR,
                    lpWndClass: var TWndClassA): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetClassInfoA".}
proc GetClassInfoEx*(Instance: HINST, Classname: cstring,
                     WndClass: var TWndClassEx): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetClassInfoExA".}
  #function GetClassInfoExA(Instance: HINST; Classname: LPCSTR; var WndClass: TWndClassExA): WINBOOL; stdcall; external 'user32' name 'GetClassInfoExA';
  #function GetClassInfoExW(Instance: HINST; Classname: LPWSTR; var WndClass: TWndClassExW): WINBOOL; stdcall; external 'user32' name 'GetClassInfoExW';
  #function GetClassInfoW(hInstance: HINST; lpClassName: LPWSTR; var lpWndClass: TWndClassW): WINBOOL; stdcall; external 'user32' name 'GetClassInfoW';
proc GetClientRect*(wnd: HWND, lpRect: var TRect): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetClientRect".}
proc GetClipBox*(DC: HDC, Rect: var TRect): int{.stdcall, dynlib: "gdi32",
    importc: "GetClipBox".}
proc GetClipCursor*(lpRect: var TRect): WINBOOL{.stdcall, dynlib: "user32",
    importc: "GetClipCursor".}
proc GetColorAdjustment*(DC: HDC, p2: var TColorAdjustment): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetColorAdjustment".}
proc GetCommConfig*(hCommDev: THandle, lpCC: var TCommConfig,
                    lpdwSize: var DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "GetCommConfig".}
proc GetCommMask*(hFile: THandle, lpEvtMask: var DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetCommMask".}
proc GetCommModemStatus*(hFile: THandle, lpModemStat: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetCommModemStatus".}
proc GetCommProperties*(hFile: THandle, lpCommProp: var TCommProp): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetCommProperties".}
proc GetCommState*(hFile: THandle, lpDCB: var TDCB): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetCommState".}
proc GetCommTimeouts*(hFile: THandle, lpCommTimeouts: var TCommTimeouts): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetCommTimeouts".}
proc GetComputerName*(lpBuffer: cstring, nSize: var DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetComputerNameA".}
proc GetComputerNameA*(lpBuffer: LPCSTR, nSize: var DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetComputerNameA".}
proc GetComputerNameW*(lpBuffer: LPWSTR, nSize: var DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetComputerNameW".}
proc GetConsoleCursorInfo*(hConsoleOutput: THandle,
                           lpConsoleCursorInfo: var TConsoleCursorInfo): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetConsoleCursorInfo".}
proc GetConsoleMode*(hConsoleHandle: THandle, lpMode: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetConsoleMode".}
proc GetConsoleScreenBufferInfo*(hConsoleOutput: THandle,
    lpConsoleScreenBufferInfo: var TConsoleScreenBufferInfo): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetConsoleScreenBufferInfo".}
proc GetCPInfo*(CodePage: UINT, lpCPInfo: var TCPInfo): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetCPInfo".}
  #function GetCurrentHwProfile(var lpHwProfileInfo: THWProfileInfo): WINBOOL;stdcall; external 'advapi32' name 'GetCurrentHwProfileA';
  #function GetCurrentHwProfileA(var lpHwProfileInfo: THWProfileInfoA): WINBOOL;stdcall; external 'advapi32' name 'GetCurrentHwProfileA';
  #function GetCurrentHwProfileW(var lpHwProfileInfo: THWProfileInfoW): WINBOOL;stdcall; external 'advapi32' name 'GetCurrentHwProfileW';
proc GetCursorInfo*(pci: var TCursorInfo): WINBOOL{.stdcall, dynlib: "user32",
    importc: "GetCursorInfo".}
proc GetCursorPos*(lpPoint: var TPoint): WINBOOL{.stdcall, dynlib: "user32",
    importc: "GetCursorPos".}
proc GetDCOrgEx*(DC: HDC, Origin: var TPoint): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetDCOrgEx".}
proc GetDefaultCommConfig*(lpszName: cstring, lpCC: var TCommConfig,
                           lpdwSize: var DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetDefaultCommConfigA".}
proc GetDefaultCommConfigA*(lpszName: LPCSTR, lpCC: var TCommConfig,
                            lpdwSize: var DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetDefaultCommConfigA".}
proc GetDefaultCommConfigW*(lpszName: LPWSTR, lpCC: var TCommConfig,
                            lpdwSize: var DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetDefaultCommConfigW".}
proc GetDIBColorTable*(DC: HDC, p2, p3: UINT, RGBQuadStructs: pointer): UINT{.
    stdcall, dynlib: "gdi32", importc: "GetDIBColorTable".}
proc GetDIBits*(DC: HDC, Bitmap: HBitmap, StartScan, NumScans: UINT,
                Bits: Pointer, BitInfo: var TBitmapInfo, Usage: UINT): int{.
    stdcall, dynlib: "gdi32", importc: "GetDIBits".}
proc GetDiskFreeSpace*(lpRootPathName: cstring, lpSectorsPerCluster,
    lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetDiskFreeSpaceA".}
proc GetDiskFreeSpaceA*(lpRootPathName: LPCSTR, lpSectorsPerCluster,
    lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetDiskFreeSpaceA".}
proc GetDiskFreeSpaceEx*(lpDirectoryName: cstring, lpFreeBytesAvailableToCaller,
    lpTotalNumberOfBytes: var TLargeInteger,
                         lpTotalNumberOfFreeBytes: PLargeInteger): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetDiskFreeSpaceExA".}
proc GetDiskFreeSpaceExA*(lpDirectoryName: LPCSTR, lpFreeBytesAvailableToCaller,
    lpTotalNumberOfBytes: var TLargeInteger,
                          lpTotalNumberOfFreeBytes: PLargeInteger): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetDiskFreeSpaceExA".}
proc GetDiskFreeSpaceExW*(lpDirectoryName: LPWSTR, lpFreeBytesAvailableToCaller,
    lpTotalNumberOfBytes: var TLargeInteger,
                          lpTotalNumberOfFreeBytes: PLargeInteger): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetDiskFreeSpaceExW".}
proc GetDiskFreeSpaceW*(lpRootPathName: LPWSTR, lpSectorsPerCluster,
    lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetDiskFreeSpaceW".}
proc GetDiskFreeSpaceEx*(lpDirectoryName: cstring, lpFreeBytesAvailableToCaller,
    lpTotalNumberOfBytes: pLargeInteger, lpTotalNumberOfFreeBytes: PLargeInteger): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetDiskFreeSpaceExA".}
proc GetDiskFreeSpaceExA*(lpDirectoryName: LPCSTR, lpFreeBytesAvailableToCaller,
    lpTotalNumberOfBytes: pLargeInteger, lpTotalNumberOfFreeBytes: PLargeInteger): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetDiskFreeSpaceExA".}
proc GetDiskFreeSpaceExW*(lpDirectoryName: LPWSTR, lpFreeBytesAvailableToCaller,
    lpTotalNumberOfBytes: pLargeInteger, lpTotalNumberOfFreeBytes: PLargeInteger): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetDiskFreeSpaceExW".}
  #function GetEnhMetaFilePixelFormat(p1: HENHMETAFILE; p2: Cardinal; var p3: TPixelFormatDescriptor): UINT;stdcall; external 'gdi32' name 'GetEnhMetaFilePixelFormat';
proc GetExitCodeProcess*(hProcess: THandle, lpExitCode: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetExitCodeProcess".}
proc GetExitCodeThread*(hThread: THandle, lpExitCode: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetExitCodeThread".}
proc GetFileInformationByHandle*(hFile: THandle, lpFileInformation: var TByHandleFileInformation): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetFileInformationByHandle".}
  #function GetFileSecurity(lpFileName: PChar; RequestedInformation: SECURITY_INFORMATION; pSecurityDescriptor: PSecurityDescriptor; nLength: DWORD; var lpnLengthNeeded: DWORD): WINBOOL;stdcall; external 'advapi32' name 'GetFileSecurityA';
  #function GetFileSecurityA(lpFileName: LPCSTR; RequestedInformation: SECURITY_INFORMATION; pSecurityDescriptor: PSecurityDescriptor; nLength: DWORD; var lpnLengthNeeded: DWORD): WINBOOL; stdcall; external 'advapi32' name 'GetFileSecurityA';
  #function GetFileSecurityW(lpFileName: LPWSTR; RequestedInformation: SECURITY_INFORMATION; pSecurityDescriptor: PSecurityDescriptor; nLength: DWORD; var lpnLengthNeeded: DWORD): WINBOOL; stdcall; external 'advapi32' name 'GetFileSecurityW';
proc GetFileVersionInfoSize*(lptstrFilename: cstring, lpdwHandle: var DWORD): DWORD{.
    stdcall, dynlib: "version", importc: "GetFileVersionInfoSizeA".}
proc GetFileVersionInfoSizeA*(lptstrFilename: LPCSTR, lpdwHandle: var DWORD): DWORD{.
    stdcall, dynlib: "version", importc: "GetFileVersionInfoSizeA".}
proc GetFileVersionInfoSizeW*(lptstrFilename: LPWSTR, lpdwHandle: var DWORD): DWORD{.
    stdcall, dynlib: "version", importc: "GetFileVersionInfoSizeW".}
  # removed because old definition was wrong !
  # function GetFullPathName(lpFileName: PChar; nBufferLength: DWORD; lpBuffer: PChar; var lpFilePart: PChar): DWORD;stdcall; external 'kernel32' name 'GetFullPathNameA';
  # function GetFullPathNameA(lpFileName: LPCSTR; nBufferLength: DWORD; lpBuffer: LPCSTR; var lpFilePart: LPCSTR): DWORD; stdcall; external 'kernel32' name 'GetFullPathNameA';
  # function GetFullPathNameW(lpFileName: LPWSTR; nBufferLength: DWORD; lpBuffer: LPWSTR; var lpFilePart: LPWSTR): DWORD; stdcall; external 'kernel32' name 'GetFullPathNameW';
proc GetGlyphOutline*(DC: HDC, p2, p3: UINT, p4: TGlyphMetrics, p5: DWORD,
                      p6: Pointer, p7: TMat2): DWORD{.stdcall, dynlib: "gdi32",
    importc: "GetGlyphOutlineA".}
proc GetGlyphOutlineA*(DC: HDC, p2, p3: UINT, p4: TGlyphMetrics, p5: DWORD,
                       p6: Pointer, p7: TMat2): DWORD{.stdcall, dynlib: "gdi32",
    importc: "GetGlyphOutlineA".}
proc GetGlyphOutlineW*(DC: HDC, p2, p3: UINT, p4: TGlyphMetrics, p5: DWORD,
                       p6: Pointer, p7: TMat2): DWORD{.stdcall, dynlib: "gdi32",
    importc: "GetGlyphOutlineW".}
  #function GetGUIThreadInfo(idThread: DWORD; var pgui: TGUIThreadinfo): WINBOOL;stdcall; external 'user32' name 'GetGUIThreadInfo';
proc GetHandleInformation*(hObject: THandle, lpdwFlags: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetHandleInformation".}
  #function GetICMProfile(DC: HDC; var Size: DWORD; Name: PChar): WINBOOL;stdcall; external 'gdi32' name 'GetICMProfileA';
  #function GetICMProfileA(DC: HDC; var Size: DWORD; Name: LPCSTR): WINBOOL; stdcall; external 'gdi32' name 'GetICMProfileA';
  #function GetICMProfileW(DC: HDC; var Size: DWORD; Name: LPWSTR): WINBOOL; stdcall; external 'gdi32' name 'GetICMProfileW';
proc GetIconInfo*(icon: HICON, piconinfo: var TIconInfo): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetIconInfo".}
  #function GetKernelObjectSecurity(Handle: THandle; RequestedInformation: SECURITY_INFORMATION; pSecurityDescriptor: PSecurityDescriptor; nLength: DWORD; var lpnLengthNeeded: DWORD): WINBOOL; stdcall; external 'advapi32' name 'GetKernelObjectSecurity';
proc GetKerningPairs*(DC: HDC, Count: DWORD, KerningPairs: pointer): DWORD{.
    stdcall, dynlib: "gdi32", importc: "GetKerningPairs".}
proc GetKeyboardLayoutList*(nBuff: int, List: pointer): UINT{.stdcall,
    dynlib: "user32", importc: "GetKeyboardLayoutList".}
  #function GetKeyboardState(var KeyState: TKeyboardState): WINBOOL; stdcall; external 'user32' name 'GetKeyboardState';
  #function GetLastInputInfo(var plii: TLastInputInfo): WINBOOL;stdcall; external 'user32' name 'GetLastInputInfo';
proc GetSystemTime*(lpSystemTime: var SYSTEMTIME){.stdcall, dynlib: "kernel32",
    importc: "GetSystemTime".}
proc GetLocalTime*(SystemTime: var SYSTEMTIME){.stdcall, dynlib: "kernel32",
    importc: "GetLocalTime".}
proc GetSystemInfo*(SystemInfo: var SYSTEM_INFO){.stdcall, dynlib: "kernel32",
    importc: "GetSystemInfo".}
proc SetSystemTime*(lpSystemTime: var SYSTEMTIME): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetSystemTime".}
proc SetLocalTime*(lpSystemTime: var SYSTEMTIME): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetLocalTime".}
proc GetLogColorSpace*(p1: HCOLORSPACE, ColorSpace: var TLogColorSpace,
                       Size: DWORD): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "GetLogColorSpaceA".}
proc GetLogColorSpaceA*(p1: HCOLORSPACE, ColorSpace: var TLogColorSpaceA,
                        Size: DWORD): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "GetLogColorSpaceA".}
  #function GetLogColorSpaceW(p1: HCOLORSPACE; var ColorSpace: TLogColorSpaceW; Size: DWORD): WINBOOL; stdcall; external 'gdi32' name 'GetLogColorSpaceW';
proc GetMailslotInfo*(hMailslot: THandle, lpMaxMessageSize: Pointer,
                      lpNextSize: var DWORD,
                      lpMessageCount, lpReadTimeout: Pointer): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetMailslotInfo".}
  #function GetMenuBarInfo(hend: HWND; idObject, idItem: Longint; var pmbi: TMenuBarInfo): WINBOOL;stdcall; external 'user32' name 'GetMenuBarInfo';
  #function GetMenuInfo(menu: HMENU; var lpmi: TMenuInfo): WINBOOL;stdcall; external 'user32' name 'GetMenuInfo';
proc GetMenuItemInfo*(p1: HMENU, p2: UINT, p3: WINBOOL, p4: var TMenuItemInfo): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetMenuItemInfoA".}
proc GetMenuItemInfoA*(p1: HMENU, p2: UINT, p3: WINBOOL, p4: var TMenuItemInfoA): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetMenuItemInfoA".}
  #function GetMenuItemInfoW(p1: HMENU; p2: UINT; p3: WINBOOL; var p4: TMenuItemInfoW): WINBOOL; stdcall; external 'user32' name 'GetMenuItemInfoW';
proc GetMenuItemRect*(wnd: HWND, menu: HMENU, uItem: UINT, lprcItem: var TRect): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetMenuItemRect".}
proc GetMessage*(lpMsg: var TMsg, wnd: HWND, wMsgFilterMin, wMsgFilterMax: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetMessageA".}
proc GetMessageA*(lpMsg: var TMsg, wnd: HWND,
                  wMsgFilterMin, wMsgFilterMax: UINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetMessageA".}
proc GetMessageW*(lpMsg: var TMsg, wnd: HWND,
                  wMsgFilterMin, wMsgFilterMax: UINT): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetMessageW".}
proc GetMiterLimit*(DC: HDC, Limit: var float32): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetMiterLimit".}
  #function GetMouseMovePoints(cbSize: UINT; var lppt, lpptBuf: TMouseMovePoint; nBufPoints: Integer; resolution: DWORD): Integer;stdcall; external 'user32' name 'GetMouseMovePoints';
proc GetNamedPipeInfo*(hNamedPipe: THandle, lpFlags: var DWORD,
                       lpOutBufferSize, lpInBufferSize, lpMaxInstances: Pointer): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetNamedPipeInfo".}
proc GetNumberOfConsoleInputEvents*(hConsoleInput: THandle,
                                    lpNumberOfEvents: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetNumberOfConsoleInputEvents".}
proc GetNumberOfConsoleMouseButtons*(lpNumberOfMouseButtons: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetNumberOfConsoleMouseButtons".}
  #function GetNumberOfEventLogRecords(hEventLog: THandle; var NumberOfRecords: DWORD): WINBOOL; stdcall; external 'advapi32' name 'GetNumberOfEventLogRecords';
  #function GetOldestEventLogRecord(hEventLog: THandle; var OldestRecord: DWORD): WINBOOL; stdcall; external 'advapi32' name 'GetOldestEventLogRecord';
proc GetOverlappedResult*(hFile: THandle, lpOverlapped: TOverlapped,
                          lpNumberOfBytesTransferred: var DWORD, bWait: WINBOOL): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetOverlappedResult".}
proc GetPaletteEntries*(Palette: HPALETTE, StartIndex, NumEntries: UINT,
                        PaletteEntries: pointer): UINT{.stdcall,
    dynlib: "gdi32", importc: "GetPaletteEntries".}
proc GetPath*(DC: HDC, Points, Types: pointer, nSize: int): int{.stdcall,
    dynlib: "gdi32", importc: "GetPath".}
proc GetPriorityClipboardFormat*(paFormatPriorityList: pointer, cFormats: int): int{.
    stdcall, dynlib: "user32", importc: "GetPriorityClipboardFormat".}
  #function GetPrivateObjectSecurity(ObjectDescriptor: PSecurityDescriptor; SecurityInformation: SECURITY_INFORMATION; ResultantDescriptor: PSecurityDescriptor; DescriptorLength: DWORD; var ReturnLength: DWORD): WINBOOL;
  #  stdcall; external 'advapi32' name 'GetPrivateObjectSecurity';
proc GetPrivateProfileSectionNamesA*(lpszReturnBuffer: LPSTR, nSize: DWORD,
                                     lpFileName: LPCSTR): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetPrivateProfileSectionNamesA".}
proc GetPrivateProfileSectionNamesW*(lpszReturnBuffer: LPWSTR, nSize: DWORD,
                                     lpFileName: LPCWSTR): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetPrivateProfileSectionNamesW".}
proc GetPrivateProfileSectionNames*(lpszReturnBuffer: LPTSTR, nSize: DWORD,
                                    lpFileName: LPCTSTR): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetPrivateProfileSectionNamesA".}
proc GetPrivateProfileStructA*(lpszSection, lpszKey: LPCSTR, lpStruct: LPVOID,
                               uSizeStruct: UINT, szFile: LPCSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetPrivateProfileStructA".}
proc GetPrivateProfileStructW*(lpszSection, lpszKey: LPCWSTR, lpStruct: LPVOID,
                               uSizeStruct: UINT, szFile: LPCWSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetPrivateProfileStructW".}
proc GetPrivateProfileStruct*(lpszSection, lpszKey: LPCTSTR, lpStruct: LPVOID,
                              uSizeStruct: UINT, szFile: LPCTSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetPrivateProfileStructA".}
proc GetProcessAffinityMask*(hProcess: THandle, lpProcessAffinityMask,
    lpSystemAffinityMask: var DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "GetProcessAffinityMask".}
proc GetProcessHeaps*(NumberOfHeaps: DWORD, ProcessHeaps: var THandle): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetProcessHeaps".}
proc GetProcessPriorityBoost*(hThread: THandle,
                              DisablePriorityBoost: var WINBOOL): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetProcessPriorityBoost".}
proc GetProcessShutdownParameters*(lpdwLevel, lpdwFlags: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetProcessShutdownParameters".}
proc GetProcessTimes*(hProcess: THandle, lpCreationTime, lpExitTime,
    lpKernelTime, lpUserTime: var TFileTime): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetProcessTimes".}
proc GetProcessWorkingSetSize*(hProcess: THandle, lpMinimumWorkingSetSize,
    lpMaximumWorkingSetSize: var DWORD): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "GetProcessWorkingSetSize".}
proc GetQueuedCompletionStatus*(CompletionPort: THandle,
    lpNumberOfBytesTransferred, lpCompletionKey: var DWORD,
                                lpOverlapped: var POverlapped,
                                dwMilliseconds: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetQueuedCompletionStatus".}
proc GetRasterizerCaps*(p1: var TRasterizerStatus, p2: UINT): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetRasterizerCaps".}
proc GetRgnBox*(RGN: HRGN, p2: var TRect): int{.stdcall, dynlib: "gdi32",
    importc: "GetRgnBox".}
proc GetScrollInfo*(wnd: HWND, BarFlag: int, ScrollInfo: var TScrollInfo): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetScrollInfo".}
proc GetScrollRange*(wnd: HWND, nBar: int, lpMinPos, lpMaxPos: var int): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetScrollRange".}
  #function GetSecurityDescriptorControl(pSecurityDescriptor: PSecurityDescriptor; var pControl: SECURITY_DESCRIPTOR_CONTROL; var lpdwRevision: DWORD): WINBOOL; stdcall; external 'advapi32' name 'GetSecurityDescriptorControl';
  #function GetSecurityDescriptorDacl(pSecurityDescriptor: PSecurityDescriptor; var lpbDaclPresent: WINBOOL; var pDacl: PACL; var lpbDaclDefaulted: WINBOOL): WINBOOL; stdcall; external 'advapi32' name 'GetSecurityDescriptorDacl';
  #function GetSecurityDescriptorGroup(pSecurityDescriptor: PSecurityDescriptor; var pGroup: PSID; var lpbGroupDefaulted: WINBOOL): WINBOOL; stdcall; external 'advapi32' name 'GetSecurityDescriptorGroup';
  #function GetSecurityDescriptorOwner(pSecurityDescriptor: PSecurityDescriptor; var pOwner: PSID; var lpbOwnerDefaulted: WINBOOL): WINBOOL; stdcall; external 'advapi32' name 'GetSecurityDescriptorOwner';
  #function GetSecurityDescriptorSacl(pSecurityDescriptor: PSecurityDescriptor; var lpbSaclPresent: WINBOOL; var pSacl: PACL; var lpbSaclDefaulted: WINBOOL): WINBOOL; stdcall; external 'advapi32' name 'GetSecurityDescriptorSacl';
proc GetStartupInfo*(lpStartupInfo: var TSTARTUPINFO){.stdcall,
    dynlib: "kernel32", importc: "GetStartupInfoA".}
proc GetStringTypeA*(Locale: LCID, dwInfoType: DWORD, lpSrcStr: LPCSTR,
                     cchSrc: WINBOOL, lpCharType: var int16): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetStringTypeA".}
proc GetStringTypeEx*(Locale: LCID, dwInfoType: DWORD, lpSrcStr: cstring,
                      cchSrc: int, lpCharType: var int16): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetStringTypeExA".}
proc GetStringTypeExA*(Locale: LCID, dwInfoType: DWORD, lpSrcStr: LPCSTR,
                       cchSrc: int, lpCharType: var int16): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetStringTypeExA".}
proc GetStringTypeExW*(Locale: LCID, dwInfoType: DWORD, lpSrcStr: LPWSTR,
                       cchSrc: int, lpCharType: var int16): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetStringTypeExW".}
proc GetStringTypeW*(dwInfoType: DWORD, lpSrcStr: WCHAR, cchSrc: WINBOOL,
                     lpCharType: var int16): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetStringTypeW".}
proc GetSystemPaletteEntries*(DC: HDC, StartIndex, NumEntries: UINT,
                              PaletteEntries: pointer): UINT{.stdcall,
    dynlib: "gdi32", importc: "GetSystemPaletteEntries".}
proc GetSystemPowerStatus*(lpSystemPowerStatus: var TSystemPowerStatus): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetSystemPowerStatus".}
proc GetSystemTimeAdjustment*(lpTimeAdjustment, lpTimeIncrement: var DWORD,
                              lpTimeAdjustmentDisabled: var WINBOOL): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetSystemTimeAdjustment".}
proc GetSystemTimeAsFileTime*(lpSystemTimeAsFileTime: var TFILETIME){.stdcall,
    dynlib: "kernel32", importc: "GetSystemTimeAsFileTime".}
proc GetTabbedTextExtent*(hDC: HDC, lpString: cstring,
                          nCount, nTabPositions: int,
                          lpnTabStopPositions: pointer): DWORD{.stdcall,
    dynlib: "user32", importc: "GetTabbedTextExtentA".}
proc GetTabbedTextExtentA*(hDC: HDC, lpString: LPCSTR,
                           nCount, nTabPositions: int,
                           lpnTabStopPositions: pointer): DWORD{.stdcall,
    dynlib: "user32", importc: "GetTabbedTextExtentA".}
proc GetTabbedTextExtentW*(hDC: HDC, lpString: LPWSTR,
                           nCount, nTabPositions: int,
                           lpnTabStopPositions: pointer): DWORD{.stdcall,
    dynlib: "user32", importc: "GetTabbedTextExtentW".}
proc GetTapeParameters*(hDevice: THandle, dwOperation: DWORD,
                        lpdwSize: var DWORD, lpTapeInformation: Pointer): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetTapeParameters".}
proc GetTapePosition*(hDevice: THandle, dwPositionType: DWORD,
                      lpdwPartition, lpdwOffsetLow: var DWORD,
                      lpdwOffsetHigh: Pointer): DWORD{.stdcall,
    dynlib: "kernel32", importc: "GetTapePosition".}
proc GetTextExtentExPoint*(DC: HDC, p2: cstring, p3, p4: int, p5, p6: PInteger,
                           p7: var TSize): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "GetTextExtentExPointA".}
proc GetTextExtentExPointA*(DC: HDC, p2: LPCSTR, p3, p4: int, p5, p6: PInteger,
                            p7: var TSize): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "GetTextExtentExPointA".}
  #function GetTextExtentExPointI(DC: HDC; p2: PWORD; p3, p4: Integer; p5, p6: PINT; var p7: TSize): WINBOOL;stdcall; external 'gdi32' name 'GetTextExtentExPointI';
proc GetTextExtentExPointW*(DC: HDC, p2: LPWSTR, p3, p4: int, p5, p6: PInteger,
                            p7: var TSize): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "GetTextExtentExPointW".}
proc GetTextExtentPoint*(DC: HDC, Str: cstring, Count: int, Size: var TSize): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetTextExtentPointA".}
proc GetTextExtentPoint32*(DC: HDC, Str: cstring, Count: int, Size: var TSize): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetTextExtentPoint32A".}
proc GetTextExtentPoint32A*(DC: HDC, Str: LPCSTR, Count: int, Size: var TSize): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetTextExtentPoint32A".}
proc GetTextExtentPoint32W*(DC: HDC, Str: LPWSTR, Count: int, Size: var TSize): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetTextExtentPoint32W".}
proc GetTextExtentPointA*(DC: HDC, Str: LPCSTR, Count: int, Size: var TSize): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetTextExtentPointA".}
  #function GetTextExtentPointI(DC: HDC; p2: PWORD; p3: Integer; var p4: TSize): WINBOOL;stdcall; external 'gdi32' name 'GetTextExtentPointI';
proc GetTextExtentPointW*(DC: HDC, Str: LPWSTR, Count: int, Size: var TSize): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "GetTextExtentPointW".}
proc GetTextMetrics*(DC: HDC, TM: var TTextMetric): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetTextMetricsA".}
  #function GetTextMetricsA(DC: HDC; var TM: TTextMetricA): WINBOOL; stdcall; external 'gdi32' name 'GetTextMetricsA';
  #function GetTextMetricsW(DC: HDC; var TM: TTextMetricW): WINBOOL; stdcall; external 'gdi32' name 'GetTextMetricsW';
proc GetThreadContext*(hThread: THandle, lpContext: var TContext): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetThreadContext".}
proc GetThreadPriorityBoost*(hThread: THandle, DisablePriorityBoost: var WINBOOL): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetThreadPriorityBoost".}
proc GetThreadSelectorEntry*(hThread: THandle, dwSelector: DWORD,
                             lpSelectorEntry: var TLDTEntry): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetThreadSelectorEntry".}
proc GetThreadTimes*(hThread: THandle, lpCreationTime, lpExitTime, lpKernelTime,
                                       lpUserTime: var TFileTime): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetThreadTimes".}
proc GetTimeZoneInformation*(lpTimeZoneInformation: var TTimeZoneInformation): DWORD{.
    stdcall, dynlib: "kernel32", importc: "GetTimeZoneInformation".}
  #function GetTitleBarInfo(wnd: HWND; var pti: TTitleBarInfo): WINBOOL;stdcall; external 'user32' name 'GetTitleBarInfo';
  #function GetTokenInformation(TokenHandle: THandle; TokenInformationClass: TTokenInformationClass; TokenInformation: Pointer; TokenInformationLength: DWORD; var ReturnLength: DWORD): WINBOOL; stdcall; external 'advapi32' name 'GetTokenInformation';
proc GetUpdateRect*(wnd: HWND, lpRect: var TRect, bErase: WINBOOL): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetUpdateRect".}
proc GetUserName*(lpBuffer: cstring, nSize: var DWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "GetUserNameA".}
proc GetUserNameA*(lpBuffer: LPCSTR, nSize: var DWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "GetUserNameA".}
proc GetUserNameW*(lpBuffer: LPWSTR, nSize: var DWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "GetUserNameW".}
proc GetUserObjectInformation*(hObj: THandle, nIndex: int, pvInfo: Pointer,
                               nLength: DWORD, lpnLengthNeeded: var DWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetUserObjectInformationA".}
proc GetUserObjectInformationA*(hObj: THandle, nIndex: int, pvInfo: Pointer,
                                nLength: DWORD, lpnLengthNeeded: var DWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetUserObjectInformationA".}
proc GetUserObjectInformationW*(hObj: THandle, nIndex: int, pvInfo: Pointer,
                                nLength: DWORD, lpnLengthNeeded: var DWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "GetUserObjectInformationW".}
proc GetUserObjectSecurity*(hObj: THandle, pSIRequested: var DWORD,
                            pSID: PSecurityDescriptor, nLength: DWORD,
                            lpnLengthNeeded: var DWORD): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetUserObjectSecurity".}
proc GetVersionEx*(lpVersionInformation: var TOSVersionInfo): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetVersionExA".}
proc GetVersionExA*(lpVersionInformation: var TOSVersionInfo): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetVersionExA".}
proc GetVersionExW*(lpVersionInformation: var TOSVersionInfoW): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "GetVersionExW".}
proc GetViewportExtEx*(DC: HDC, Size: var TSize): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetViewportExtEx".}
proc GetViewportOrgEx*(DC: HDC, Point: var TPoint): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetViewportOrgEx".}
proc GetVolumeInformation*(lpRootPathName: cstring, lpVolumeNameBuffer: cstring,
                           nVolumeNameSize: DWORD, lpVolumeSerialNumber: PDWORD,
    lpMaximumComponentLength, lpFileSystemFlags: var DWORD,
                           lpFileSystemNameBuffer: cstring,
                           nFileSystemNameSize: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetVolumeInformationA".}
proc GetVolumeInformationA*(lpRootPathName: LPCSTR, lpVolumeNameBuffer: LPCSTR,
                            nVolumeNameSize: DWORD,
                            lpVolumeSerialNumber: PDWORD,
    lpMaximumComponentLength, lpFileSystemFlags: var DWORD,
                            lpFileSystemNameBuffer: LPCSTR,
                            nFileSystemNameSize: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetVolumeInformationA".}
proc GetVolumeInformationW*(lpRootPathName: LPWSTR, lpVolumeNameBuffer: LPWSTR,
                            nVolumeNameSize: DWORD,
                            lpVolumeSerialNumber: PDWORD,
    lpMaximumComponentLength, lpFileSystemFlags: var DWORD,
                            lpFileSystemNameBuffer: LPWSTR,
                            nFileSystemNameSize: DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "GetVolumeInformationW".}
proc GetWindowExtEx*(DC: HDC, Size: var TSize): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetWindowExtEx".}
  #function GetWindowInfo(wnd: HWND; var pwi: TWindowInfo): WINBOOL;stdcall; external 'user32' name 'GetWindowInfo';
proc GetWindowOrgEx*(DC: HDC, Point: var TPoint): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetWindowOrgEx".}
proc GetWindowRect*(wnd: HWND, lpRect: var TRect): WINBOOL{.stdcall,
    dynlib: "user32", importc: "GetWindowRect".}
proc GetWorldTransform*(DC: HDC, p2: var TXForm): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "GetWorldTransform".}
  #function GradientFill(DC: HDC; var p2: TTriVertex; p3: ULONG; p4: Pointer; p5, p6: ULONG): WINBOOL;stdcall; external 'gdi32' name 'GradientFill';
proc GlobalMemoryStatus*(Buffer: var MEMORYSTATUS){.stdcall, dynlib: "kernel32",
    importc: "GlobalMemoryStatus".}
proc HeapWalk*(hHeap: THandle, lpEntry: var TProcessHeapEntry): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "HeapWalk".}
proc ImageList_GetDragImage*(ppt: var POINT, pptHotspot: var POINT): HIMAGELIST{.
    stdcall, dynlib: "comctl32", importc: "ImageList_GetDragImage".}
proc InflateRect*(lprc: var TRect, dx, dy: int): WINBOOL{.stdcall,
    dynlib: "user32", importc: "InflateRect".}
proc InitializeAcl*(pAcl: var TACL, nAclLength, dwAclRevision: DWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "InitializeAcl".}
proc InitializeCriticalSectionAndSpinCount*(
    lpCriticalSection: var TRTLCriticalSection, dwSpinCount: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32",
    importc: "InitializeCriticalSectionAndSpinCount".}
proc InitializeSid*(Sid: Pointer, pIdentifierAuthority: TSIDIdentifierAuthority,
                    nSubAuthorityCount: int8): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "InitializeSid".}
proc InsertMenuItem*(p1: HMENU, p2: UINT, p3: WINBOOL, p4: TMenuItemInfo): WINBOOL{.
    stdcall, dynlib: "user32", importc: "InsertMenuItemA".}
proc InsertMenuItemA*(p1: HMENU, p2: UINT, p3: WINBOOL, p4: TMenuItemInfoA): WINBOOL{.
    stdcall, dynlib: "user32", importc: "InsertMenuItemA".}
  #function InsertMenuItemW(p1: HMENU; p2: UINT; p3: WINBOOL; const p4: TMenuItemInfoW): WINBOOL; stdcall; external 'user32' name 'InsertMenuItemW';
proc IntersectRect*(lprcDst: var TRect, lprcSrc1, lprcSrc2: TRect): WINBOOL{.
    stdcall, dynlib: "user32", importc: "IntersectRect".}
  #function InvertRect(hDC: HDC; const lprc: TRect): WINBOOL; stdcall; external 'user32' name 'InvertRect';
proc IsDialogMessage*(hDlg: HWND, lpMsg: var TMsg): WINBOOL{.stdcall,
    dynlib: "user32", importc: "IsDialogMessageA".}
proc IsDialogMessageA*(hDlg: HWND, lpMsg: var TMsg): WINBOOL{.stdcall,
    dynlib: "user32", importc: "IsDialogMessageA".}
proc IsDialogMessageW*(hDlg: HWND, lpMsg: var TMsg): WINBOOL{.stdcall,
    dynlib: "user32", importc: "IsDialogMessageW".}
  #function IsRectEmpty(const lprc: TRect): WINBOOL; stdcall; external 'user32' name 'IsRectEmpty';
proc IsValidAcl*(pAcl: TACL): WINBOOL{.stdcall, dynlib: "advapi32",
                                       importc: "IsValidAcl".}
proc LocalFileTimeToFileTime*(lpLocalFileTime: TFileTime,
                              lpFileTime: var TFileTime): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "LocalFileTimeToFileTime".}
proc LockFileEx*(hFile: THandle, dwFlags, dwReserved: DWORD,
                 nNumberOfBytesToLockLow, nNumberOfBytesToLockHigh: DWORD,
                 lpOverlapped: TOverlapped): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "LockFileEx".}
proc LogonUser*(lpszUsername, lpszDomain, lpszPassword: cstring,
                dwLogonType, dwLogonProvider: DWORD, phToken: var THandle): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "LogonUserA".}
proc LogonUserA*(lpszUsername, lpszDomain, lpszPassword: LPCSTR,
                 dwLogonType, dwLogonProvider: DWORD, phToken: var THandle): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "LogonUserA".}
proc LogonUserW*(lpszUsername, lpszDomain, lpszPassword: LPWSTR,
                 dwLogonType, dwLogonProvider: DWORD, phToken: var THandle): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "LogonUserW".}
proc LookupAccountName*(lpSystemName, lpAccountName: cstring, Sid: PSID,
                        cbSid: var DWORD, ReferencedDomainName: cstring,
                        cbReferencedDomainName: var DWORD,
                        peUse: var SID_NAME_USE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupAccountNameA".}
proc LookupAccountNameA*(lpSystemName, lpAccountName: LPCSTR, Sid: PSID,
                         cbSid: var DWORD, ReferencedDomainName: LPCSTR,
                         cbReferencedDomainName: var DWORD,
                         peUse: var SID_NAME_USE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupAccountNameA".}
proc LookupAccountNameW*(lpSystemName, lpAccountName: LPWSTR, Sid: PSID,
                         cbSid: var DWORD, ReferencedDomainName: LPWSTR,
                         cbReferencedDomainName: var DWORD,
                         peUse: var SID_NAME_USE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupAccountNameW".}
proc LookupAccountSid*(lpSystemName: cstring, Sid: PSID, Name: cstring,
                       cbName: var DWORD, ReferencedDomainName: cstring,
                       cbReferencedDomainName: var DWORD,
                       peUse: var SID_NAME_USE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupAccountSidA".}
proc LookupAccountSidA*(lpSystemName: LPCSTR, Sid: PSID, Name: LPCSTR,
                        cbName: var DWORD, ReferencedDomainName: LPCSTR,
                        cbReferencedDomainName: var DWORD,
                        peUse: var SID_NAME_USE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupAccountSidA".}
proc LookupAccountSidW*(lpSystemName: LPWSTR, Sid: PSID, Name: LPWSTR,
                        cbName: var DWORD, ReferencedDomainName: LPWSTR,
                        cbReferencedDomainName: var DWORD,
                        peUse: var SID_NAME_USE): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupAccountSidW".}
proc LookupPrivilegeDisplayName*(lpSystemName, lpName: LPCSTR,
                                 lpDisplayName: cstring,
                                 cbDisplayName, lpLanguageId: var DWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "LookupPrivilegeDisplayNameA".}
proc LookupPrivilegeDisplayNameA*(lpSystemName, lpName: LPCSTR,
                                  lpDisplayName: LPCSTR,
                                  cbDisplayName, lpLanguageId: var DWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "LookupPrivilegeDisplayNameA".}
proc LookupPrivilegeDisplayNameW*(lpSystemName, lpName: LPCSTR,
                                  lpDisplayName: LPWSTR,
                                  cbDisplayName, lpLanguageId: var DWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "LookupPrivilegeDisplayNameW".}
proc LookupPrivilegeName*(lpSystemName: cstring, lpLuid: var TLargeInteger,
                          lpName: cstring, cbName: var DWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupPrivilegeNameA".}
proc LookupPrivilegeNameA*(lpSystemName: LPCSTR, lpLuid: var TLargeInteger,
                           lpName: LPCSTR, cbName: var DWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupPrivilegeNameA".}
proc LookupPrivilegeNameW*(lpSystemName: LPWSTR, lpLuid: var TLargeInteger,
                           lpName: LPWSTR, cbName: var DWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupPrivilegeNameW".}
proc LookupPrivilegeValue*(lpSystemName, lpName: cstring,
                           lpLuid: var TLargeInteger): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupPrivilegeValueA".}
proc LookupPrivilegeValueA*(lpSystemName, lpName: LPCSTR,
                            lpLuid: var TLargeInteger): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupPrivilegeValueA".}
proc LookupPrivilegeValueW*(lpSystemName, lpName: LPWSTR,
                            lpLuid: var TLargeInteger): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "LookupPrivilegeValueW".}
proc LPtoDP*(DC: HDC, Points: pointer, Count: int): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "LPtoDP".}
proc MakeAbsoluteSD*(pSelfRelativeSecurityDescriptor: PSecurityDescriptor,
                     pAbsoluteSecurityDescriptor: PSecurityDescriptor,
                     lpdwAbsoluteSecurityDescriptorSi: var DWORD,
                     pDacl: var TACL, lpdwDaclSize: var DWORD, pSacl: var TACL,

                     lpdwSaclSize: var DWORD, pOwner: PSID,
                     lpdwOwnerSize: var DWORD, pPrimaryGroup: Pointer,
                     lpdwPrimaryGroupSize: var DWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "MakeAbsoluteSD".}
proc MakeSelfRelativeSD*(pAbsoluteSecurityDescriptor: PSecurityDescriptor,
                         pSelfRelativeSecurityDescriptor: PSecurityDescriptor,
                         lpdwBufferLength: var DWORD): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "MakeSelfRelativeSD".}
proc MapDialogRect*(hDlg: HWND, lpRect: var TRect): WINBOOL{.stdcall,
    dynlib: "user32", importc: "MapDialogRect".}
proc MapWindowPoints*(hWndFrom, hWndTo: HWND, lpPoints: pointer, cPoints: UINT): int{.
    stdcall, dynlib: "user32", importc: "MapWindowPoints".}
proc MessageBoxIndirect*(MsgBoxParams: TMsgBoxParams): WINBOOL{.stdcall,
    dynlib: "user32", importc: "MessageBoxIndirectA".}
proc MessageBoxIndirectA*(MsgBoxParams: TMsgBoxParamsA): WINBOOL{.stdcall,
    dynlib: "user32", importc: "MessageBoxIndirectA".}
  #function MessageBoxIndirectW(const MsgBoxParams: TMsgBoxParamsW): WINBOOL; stdcall; external 'user32' name 'MessageBoxIndirectW';
  #function ModifyWorldTransform(DC: HDC; const p2: TXForm; p3: DWORD): WINBOOL; stdcall; external 'gdi32' name 'ModifyWorldTransform';
proc MsgWaitForMultipleObjects*(nCount: DWORD, pHandles: pointer,
                                fWaitAll: WINBOOL,
                                dwMilliseconds, dwWakeMask: DWORD): DWORD{.
    stdcall, dynlib: "user32", importc: "MsgWaitForMultipleObjects".}
proc MsgWaitForMultipleObjectsEx*(nCount: DWORD, pHandles: pointer,
                                  dwMilliseconds, dwWakeMask, dwFlags: DWORD): DWORD{.
    stdcall, dynlib: "user32", importc: "MsgWaitForMultipleObjectsEx".}
  # function MultiByteToWideChar(CodePage: UINT; dwFlags: DWORD; const lpMultiByteStr: LPCSTR; cchMultiByte: Integer; lLPWSTRStr: LPWSTR; cchWideChar: Integer): Integer; stdcall; external 'kernel32' name 'MultiByteToWideChar';
proc ObjectOpenAuditAlarm*(SubsystemName: cstring, HandleId: Pointer,
                           ObjectTypeName: cstring, ObjectName: cstring,
                           pSecurityDescriptor: PSecurityDescriptor,
                           ClientToken: THandle,
                           DesiredAccess, GrantedAccess: DWORD,
                           Privileges: var TPrivilegeSet,
                           ObjectCreation, AccessGranted: WINBOOL,
                           GenerateOnClose: var WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ObjectOpenAuditAlarmA".}
proc ObjectOpenAuditAlarmA*(SubsystemName: LPCSTR, HandleId: Pointer,
                            ObjectTypeName: LPCSTR, ObjectName: LPCSTR,
                            pSecurityDescriptor: PSecurityDescriptor,
                            ClientToken: THandle,
                            DesiredAccess, GrantedAccess: DWORD,
                            Privileges: var TPrivilegeSet,
                            ObjectCreation, AccessGranted: WINBOOL,
                            GenerateOnClose: var WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ObjectOpenAuditAlarmA".}
proc ObjectOpenAuditAlarmW*(SubsystemName: LPWSTR, HandleId: Pointer,
                            ObjectTypeName: LPWSTR, ObjectName: LPWSTR,
                            pSecurityDescriptor: PSecurityDescriptor,
                            ClientToken: THandle,
                            DesiredAccess, GrantedAccess: DWORD,
                            Privileges: var TPrivilegeSet,
                            ObjectCreation, AccessGranted: WINBOOL,
                            GenerateOnClose: var WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ObjectOpenAuditAlarmW".}
proc ObjectPrivilegeAuditAlarm*(SubsystemName: cstring, HandleId: Pointer,
                                ClientToken: THandle, DesiredAccess: DWORD,
                                Privileges: var TPrivilegeSet,
                                AccessGranted: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ObjectPrivilegeAuditAlarmA".}
proc ObjectPrivilegeAuditAlarmA*(SubsystemName: LPCSTR, HandleId: Pointer,
                                 ClientToken: THandle, DesiredAccess: DWORD,
                                 Privileges: var TPrivilegeSet,
                                 AccessGranted: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ObjectPrivilegeAuditAlarmA".}
proc ObjectPrivilegeAuditAlarmW*(SubsystemName: LPWSTR, HandleId: Pointer,
                                 ClientToken: THandle, DesiredAccess: DWORD,
                                 Privileges: var TPrivilegeSet,
                                 AccessGranted: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "ObjectPrivilegeAuditAlarmW".}
proc OffsetRect*(lprc: var TRect, dx, dy: int): WINBOOL{.stdcall,
    dynlib: "user32", importc: "OffsetRect".}
proc OffsetViewportOrgEx*(DC: HDC, X, Y: int, Points: pointer): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "OffsetViewportOrgEx".}
proc OffsetWindowOrgEx*(DC: HDC, X, Y: int, Points: pointer): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "OffsetWindowOrgEx".}
proc OpenFile*(lpFileName: LPCSTR, lpReOpenBuff: var TOFStruct, uStyle: UINT): HFILE{.
    stdcall, dynlib: "kernel32", importc: "OpenFile".}
proc OpenProcessToken*(ProcessHandle: THandle, DesiredAccess: DWORD,
                       TokenHandle: var THandle): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "OpenProcessToken".}
proc OpenThreadToken*(ThreadHandle: THandle, DesiredAccess: DWORD,
                      OpenAsSelf: WINBOOL, TokenHandle: var THandle): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "OpenThreadToken".}
proc PeekConsoleInput*(hConsoleInput: THandle, lpBuffer: var TInputRecord,
                       nLength: DWORD, lpNumberOfEventsRead: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "PeekConsoleInputA".}
proc PeekConsoleInputA*(hConsoleInput: THandle, lpBuffer: var TInputRecord,
                        nLength: DWORD, lpNumberOfEventsRead: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "PeekConsoleInputA".}
proc PeekConsoleInputW*(hConsoleInput: THandle, lpBuffer: var TInputRecord,
                        nLength: DWORD, lpNumberOfEventsRead: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "PeekConsoleInputW".}
proc PeekMessage*(lpMsg: var TMsg, wnd: HWND,
                  wMsgFilterMin, wMsgFilterMax, wRemoveMsg: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "PeekMessageA".}
proc PeekMessageA*(lpMsg: var TMsg, wnd: HWND,
                   wMsgFilterMin, wMsgFilterMax, wRemoveMsg: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "PeekMessageA".}
proc PeekMessageW*(lpMsg: var TMsg, wnd: HWND,
                   wMsgFilterMin, wMsgFilterMax, wRemoveMsg: UINT): WINBOOL{.
    stdcall, dynlib: "user32", importc: "PeekMessageW".}
  #function PlayEnhMetaFile(DC: HDC; p2: HENHMETAFILE; const p3: TRect): WINBOOL; stdcall; external 'gdi32' name 'PlayEnhMetaFile';
proc PlayEnhMetaFileRecord*(DC: HDC, p2: var THandleTable, p3: TEnhMetaRecord,
                            p4: UINT): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "PlayEnhMetaFileRecord".}
proc PlayMetaFileRecord*(DC: HDC, p2: THandleTable, p3: TMetaRecord, p4: UINT): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "PlayMetaFileRecord".}
proc PlgBlt*(DC: HDC, PointsArray: pointer, p3: HDC, p4, p5, p6, p7: int,
             p8: HBITMAP, p9, p10: int): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "PlgBlt".}
proc PolyBezier*(DC: HDC, Points: pointer, Count: DWORD): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "PolyBezier".}
proc PolyBezierTo*(DC: HDC, Points: pointer, Count: DWORD): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "PolyBezierTo".}
proc PolyDraw*(DC: HDC, Points, Types: pointer, cCount: int): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "PolyDraw".}
proc Polygon*(DC: HDC, Points: pointer, Count: int): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "Polygon".}
proc Polyline*(DC: HDC, Points: pointer, Count: int): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "Polyline".}
proc PolyLineTo*(DC: HDC, Points: pointer, Count: DWORD): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "PolylineTo".}
proc PolyPolygon*(DC: HDC, Points: pointer, nPoints: pointer, p4: int): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "PolyPolygon".}
proc PolyPolyline*(DC: HDC, PointStructs: pointer, Points: pointer, p4: DWORD): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "PolyPolyline".}
proc PolyTextOut*(DC: HDC, PolyTextArray: pointer, Strings: int): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "PolyTextOutA".}
proc PolyTextOutA*(DC: HDC, PolyTextArray: pointer, Strings: int): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "PolyTextOutA".}
proc PolyTextOutW*(DC: HDC, PolyTextArray: pointer, Strings: int): WINBOOL{.
    stdcall, dynlib: "gdi32", importc: "PolyTextOutW".}
proc PrivilegeCheck*(ClientToken: THandle, RequiredPrivileges: TPrivilegeSet,
                     pfResult: var WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "PrivilegeCheck".}
proc PrivilegedServiceAuditAlarm*(SubsystemName, ServiceName: cstring,
                                  ClientToken: THandle,
                                  Privileges: var TPrivilegeSet,
                                  AccessGranted: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "PrivilegedServiceAuditAlarmA".}
proc PrivilegedServiceAuditAlarmA*(SubsystemName, ServiceName: LPCSTR,
                                   ClientToken: THandle,
                                   Privileges: var TPrivilegeSet,
                                   AccessGranted: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "PrivilegedServiceAuditAlarmA".}
proc PrivilegedServiceAuditAlarmW*(SubsystemName, ServiceName: LPWSTR,
                                   ClientToken: THandle,
                                   Privileges: var TPrivilegeSet,
                                   AccessGranted: WINBOOL): WINBOOL{.stdcall,
    dynlib: "advapi32", importc: "PrivilegedServiceAuditAlarmW".}
  #function PtInRect(const lprc: TRect; pt: TPoint): WINBOOL; stdcall; external 'user32' name 'PtInRect';
proc QueryPerformanceCounter*(lpPerformanceCount: var TLargeInteger): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "QueryPerformanceCounter".}
proc QueryPerformanceFrequency*(lpFrequency: var TLargeInteger): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "QueryPerformanceFrequency".}
  #function QueryRecoveryAgents(p1: PChar; var p2: Pointer; var p3: TRecoveryAgentInformation): DWORD;stdcall; external 'kernel32' name 'QueryRecoveryAgentsA';
  #function QueryRecoveryAgentsA(p1: LPCSTR; var p2: Pointer; var p3: TRecoveryAgentInformationA): DWORD;stdcall; external 'kernel32' name 'QueryRecoveryAgentsA';
  #function QueryRecoveryAgentsW(p1: LPWSTR; var p2: Pointer; var p3: TRecoveryAgentInformationW): DWORD;stdcall; external 'kernel32' name 'QueryRecoveryAgentsW';
proc RaiseException*(dwExceptionCode: DWORD, dwExceptionFlags: DWORD,
                     nNumberOfArguments: DWORD, lpArguments: var DWORD){.
    stdcall, dynlib: "kernel32", importc: "RaiseException".}
proc UnhandledExceptionFilter*(ExceptionInfo: var emptyrecord): LONG{.stdcall,
    dynlib: "kernel32", importc: "UnhandledExceptionFilter".}
proc ReadConsole*(hConsoleInput: THandle, lpBuffer: Pointer,
                  nNumberOfCharsToRead: DWORD, lpNumberOfCharsRead: var DWORD,
                  lpReserved: Pointer): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "ReadConsoleA".}
proc ReadConsoleA*(hConsoleInput: THandle, lpBuffer: Pointer,
                   nNumberOfCharsToRead: DWORD, lpNumberOfCharsRead: var DWORD,
                   lpReserved: Pointer): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "ReadConsoleA".}
proc ReadConsoleInput*(hConsoleInput: THandle, lpBuffer: var TInputRecord,
                       nLength: DWORD, lpNumberOfEventsRead: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadConsoleInputA".}
proc ReadConsoleInputA*(hConsoleInput: THandle, lpBuffer: var TInputRecord,
                        nLength: DWORD, lpNumberOfEventsRead: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadConsoleInputA".}
proc ReadConsoleInputW*(hConsoleInput: THandle, lpBuffer: var TInputRecord,
                        nLength: DWORD, lpNumberOfEventsRead: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadConsoleInputW".}
proc ReadConsoleOutput*(hConsoleOutput: THandle, lpBuffer: Pointer,
                        dwBufferSize, dwBufferCoord: TCoord,
                        lpReadRegion: var TSmallRect): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "ReadConsoleOutputA".}
proc ReadConsoleOutputA*(hConsoleOutput: THandle, lpBuffer: Pointer,
                         dwBufferSize, dwBufferCoord: TCoord,
                         lpReadRegion: var TSmallRect): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "ReadConsoleOutputA".}
proc ReadConsoleOutputAttribute*(hConsoleOutput: THandle, lpAttribute: Pointer,
                                 nLength: DWORD, dwReadCoord: TCoord,
                                 lpNumberOfAttrsRead: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadConsoleOutputAttribute".}
proc ReadConsoleOutputCharacter*(hConsoleOutput: THandle, lpCharacter: LPCSTR,
                                 nLength: DWORD, dwReadCoord: TCoord,
                                 lpNumberOfCharsRead: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadConsoleOutputCharacterA".}
proc ReadConsoleOutputCharacterA*(hConsoleOutput: THandle, lpCharacter: LPCSTR,
                                  nLength: DWORD, dwReadCoord: TCoord,
                                  lpNumberOfCharsRead: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadConsoleOutputCharacterA".}
proc ReadConsoleOutputCharacterW*(hConsoleOutput: THandle, lpCharacter: LPCSTR,
                                  nLength: DWORD, dwReadCoord: TCoord,
                                  lpNumberOfCharsRead: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadConsoleOutputCharacterW".}
proc ReadConsoleOutputW*(hConsoleOutput: THandle, lpBuffer: Pointer,
                         dwBufferSize, dwBufferCoord: TCoord,
                         lpReadRegion: var TSmallRect): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "ReadConsoleOutputW".}
proc ReadConsoleW*(hConsoleInput: THandle, lpBuffer: Pointer,
                   nNumberOfCharsToRead: DWORD, lpNumberOfCharsRead: var DWORD,
                   lpReserved: Pointer): WINBOOL{.stdcall, dynlib: "kernel32",
    importc: "ReadConsoleW".}
proc ReadEventLog*(hEventLog: THandle, dwReadFlags, dwRecordOffset: DWORD,
                   lpBuffer: Pointer, nNumberOfBytesToRead: DWORD,
                   pnBytesRead, pnMinNumberOfBytesNeeded: var DWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "ReadEventLogA".}
proc ReadEventLogA*(hEventLog: THandle, dwReadFlags, dwRecordOffset: DWORD,
                    lpBuffer: Pointer, nNumberOfBytesToRead: DWORD,
                    pnBytesRead, pnMinNumberOfBytesNeeded: var DWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "ReadEventLogA".}
proc ReadEventLogW*(hEventLog: THandle, dwReadFlags, dwRecordOffset: DWORD,
                    lpBuffer: Pointer, nNumberOfBytesToRead: DWORD,
                    pnBytesRead, pnMinNumberOfBytesNeeded: var DWORD): WINBOOL{.
    stdcall, dynlib: "advapi32", importc: "ReadEventLogW".}
proc ReadFile*(hFile: THandle, Buffer: pointer, nNumberOfBytesToRead: DWORD,
               lpNumberOfBytesRead: var DWORD, lpOverlapped: POverlapped): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "ReadFile".}
proc ReadProcessMemory*(hProcess: THandle, lpBaseAddress: Pointer,
                        lpBuffer: Pointer, nSize: DWORD,
                        lpNumberOfBytesRead: var DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "ReadProcessMemory".}
  #function RectInRegion(RGN: HRGN; const p2: TRect): WINBOOL; stdcall; external 'gdi32' name 'RectInRegion';
  #function RectVisible(DC: HDC; const Rect: TRect): WINBOOL; stdcall; external 'gdi32' name 'RectVisible';
proc RegConnectRegistry*(lpMachineName: cstring, key: HKEY, phkResult: var HKEY): int32{.
    stdcall, dynlib: "advapi32", importc: "RegConnectRegistryA".}
proc RegConnectRegistryA*(lpMachineName: LPCSTR, key: HKEY, phkResult: var HKEY): int32{.
    stdcall, dynlib: "advapi32", importc: "RegConnectRegistryA".}
proc RegConnectRegistryW*(lpMachineName: LPWSTR, key: HKEY, phkResult: var HKEY): int32{.
    stdcall, dynlib: "advapi32", importc: "RegConnectRegistryW".}
proc RegCreateKey*(key: HKEY, lpSubKey: cstring, phkResult: var HKEY): int32{.
    stdcall, dynlib: "advapi32", importc: "RegCreateKeyA".}
proc RegCreateKeyA*(key: HKEY, lpSubKey: LPCSTR, phkResult: var HKEY): int32{.
    stdcall, dynlib: "advapi32", importc: "RegCreateKeyA".}
proc RegCreateKeyEx*(key: HKEY, lpSubKey: cstring, Reserved: DWORD,
                     lpClass: cstring, dwOptions: DWORD, samDesired: REGSAM,
                     lpSecurityAttributes: PSecurityAttributes,
                     phkResult: var HKEY, lpdwDisposition: PDWORD): int32{.
    stdcall, dynlib: "advapi32", importc: "RegCreateKeyExA".}
proc RegCreateKeyExA*(key: HKEY, lpSubKey: LPCSTR, Reserved: DWORD,
                      lpClass: LPCSTR, dwOptions: DWORD, samDesired: REGSAM,
                      lpSecurityAttributes: PSecurityAttributes,
                      phkResult: var HKEY, lpdwDisposition: PDWORD): int32{.
    stdcall, dynlib: "advapi32", importc: "RegCreateKeyExA".}
proc RegCreateKeyExW*(key: HKEY, lpSubKey: LPWSTR, Reserved: DWORD,
                      lpClass: LPWSTR, dwOptions: DWORD, samDesired: REGSAM,
                      lpSecurityAttributes: PSecurityAttributes,
                      phkResult: var HKEY, lpdwDisposition: PDWORD): int32{.
    stdcall, dynlib: "advapi32", importc: "RegCreateKeyExW".}
proc RegCreateKeyW*(key: HKEY, lpSubKey: LPWSTR, phkResult: var HKEY): int32{.
    stdcall, dynlib: "advapi32", importc: "RegCreateKeyW".}
proc RegEnumKeyEx*(key: HKEY, dwIndex: DWORD, lpName: cstring,
                   lpcbName: var DWORD, lpReserved: Pointer, lpClass: cstring,
                   lpcbClass: PDWORD, lpftLastWriteTime: PFileTime): int32{.
    stdcall, dynlib: "advapi32", importc: "RegEnumKeyExA".}
proc RegEnumKeyExA*(key: HKEY, dwIndex: DWORD, lpName: LPCSTR,
                    lpcbName: var DWORD, lpReserved: Pointer, lpClass: LPCSTR,
                    lpcbClass: PDWORD, lpftLastWriteTime: PFileTime): int32{.
    stdcall, dynlib: "advapi32", importc: "RegEnumKeyExA".}
proc RegEnumKeyExW*(key: HKEY, dwIndex: DWORD, lpName: LPWSTR,
                    lpcbName: var DWORD, lpReserved: Pointer, lpClass: LPWSTR,
                    lpcbClass: PDWORD, lpftLastWriteTime: PFileTime): int32{.
    stdcall, dynlib: "advapi32", importc: "RegEnumKeyExW".}
proc RegEnumValue*(key: HKEY, dwIndex: DWORD, lpValueName: cstring,
                   lpcbValueName: var DWORD, lpReserved: Pointer,
                   lpType: PDWORD, lpData: PByte, lpcbData: PDWORD): int32{.
    stdcall, dynlib: "advapi32", importc: "RegEnumValueA".}
proc RegEnumValueA*(key: HKEY, dwIndex: DWORD, lpValueName: cstring,
                    lpcbValueName: var DWORD, lpReserved: Pointer,
                    lpType: PDWORD, lpData: PByte, lpcbData: PDWORD): int32{.
    stdcall, dynlib: "advapi32", importc: "RegEnumValueA".}
proc RegEnumValueW*(key: HKEY, dwIndex: DWORD, lpValueName: cstring,
                    lpcbValueName: var DWORD, lpReserved: Pointer,
                    lpType: PDWORD, lpData: PByte, lpcbData: PDWORD): int32{.
    stdcall, dynlib: "advapi32", importc: "RegEnumValueW".}
proc RegGetKeySecurity*(key: HKEY, SecurityInformation: SECURITY_INFORMATION,
                        pSecurityDescriptor: PSecurityDescriptor,
                        lpcbSecurityDescriptor: var DWORD): int32{.stdcall,
    dynlib: "advapi32", importc: "RegGetKeySecurity".}
proc RegSetValueEx*(key: HKEY, lpValueName: LPCSTR, Reserved: DWORD,
                    dwType: DWORD, lpData: pointer, cbData: DWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegSetValueExA".}
proc RegSetValueExA*(key: HKEY, lpValueName: LPCSTR, Reserved: DWORD,
                     dwType: DWORD, lpData: pointer, cbData: DWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegSetValueExA".}
proc RegSetValueExW*(key: HKEY, lpValueName: LPCWSTR, Reserved: DWORD,
                     dwType: DWORD, lpData: pointer, cbData: DWORD): LONG{.
    stdcall, dynlib: "advapi32", importc: "RegSetValueExW".}
proc RegisterClass*(lpWndClass: TWndClass): ATOM{.stdcall, dynlib: "user32",
    importc: "RegisterClassA".}
proc RegisterClassA*(lpWndClass: TWndClassA): ATOM{.stdcall, dynlib: "user32",
    importc: "RegisterClassA".}
proc RegisterClassEx*(WndClass: TWndClassEx): ATOM{.stdcall, dynlib: "user32",
    importc: "RegisterClassExA".}
proc RegisterClassExA*(WndClass: TWndClassExA): ATOM{.stdcall, dynlib: "user32",
    importc: "RegisterClassExA".}
proc RegisterClassExW*(WndClass: TWndClassExW): ATOM{.stdcall, dynlib: "user32",
    importc: "RegisterClassExW".}
proc RegisterClassW*(lpWndClass: TWndClassW): ATOM{.stdcall, dynlib: "user32",
    importc: "RegisterClassW".}
proc RegOpenKey*(key: HKEY, lpSubKey: cstring, phkResult: var HKEY): int32{.
    stdcall, dynlib: "advapi32", importc: "RegOpenKeyA".}
proc RegOpenKeyA*(key: HKEY, lpSubKey: LPCSTR, phkResult: var HKEY): int32{.
    stdcall, dynlib: "advapi32", importc: "RegOpenKeyA".}
proc RegOpenKeyEx*(key: HKEY, lpSubKey: cstring, ulOptions: DWORD,
                   samDesired: REGSAM, phkResult: var HKEY): int32{.stdcall,
    dynlib: "advapi32", importc: "RegOpenKeyExA".}
proc RegOpenKeyExA*(key: HKEY, lpSubKey: LPCSTR, ulOptions: DWORD,
                    samDesired: REGSAM, phkResult: var HKEY): int32{.stdcall,
    dynlib: "advapi32", importc: "RegOpenKeyExA".}
proc RegOpenKeyExW*(key: HKEY, lpSubKey: LPWSTR, ulOptions: DWORD,
                    samDesired: REGSAM, phkResult: var HKEY): int32{.stdcall,
    dynlib: "advapi32", importc: "RegOpenKeyExW".}
proc RegOpenKeyW*(key: HKEY, lpSubKey: LPWSTR, phkResult: var HKEY): int32{.
    stdcall, dynlib: "advapi32", importc: "RegOpenKeyW".}
proc RegQueryMultipleValues*(key: HKEY, ValList: pointer, NumVals: DWORD,
                             lpValueBuf: cstring, ldwTotsize: var DWORD): int32{.
    stdcall, dynlib: "advapi32", importc: "RegQueryMultipleValuesA".}
proc RegQueryMultipleValuesA*(key: HKEY, ValList: pointer, NumVals: DWORD,
                              lpValueBuf: LPCSTR, ldwTotsize: var DWORD): int32{.
    stdcall, dynlib: "advapi32", importc: "RegQueryMultipleValuesA".}
proc RegQueryMultipleValuesW*(key: HKEY, ValList: pointer, NumVals: DWORD,
                              lpValueBuf: LPWSTR, ldwTotsize: var DWORD): int32{.
    stdcall, dynlib: "advapi32", importc: "RegQueryMultipleValuesW".}
proc RegQueryValue*(key: HKEY, lpSubKey: cstring, lpValue: cstring,
                    lpcbValue: var int32): int32{.stdcall, dynlib: "advapi32",
    importc: "RegQueryValueA".}
proc RegQueryValueA*(key: HKEY, lpSubKey: LPCSTR, lpValue: LPCSTR,
                     lpcbValue: var int32): int32{.stdcall, dynlib: "advapi32",
    importc: "RegQueryValueA".}
proc RegQueryValueW*(key: HKEY, lpSubKey: LPWSTR, lpValue: LPWSTR,
                     lpcbValue: var int32): int32{.stdcall, dynlib: "advapi32",
    importc: "RegQueryValueW".}
proc ResetDC*(DC: HDC, p2: TDeviceMode): HDC{.stdcall, dynlib: "gdi32",
    importc: "ResetDCA".}
proc ResetDCA*(DC: HDC, p2: TDeviceModeA): HDC{.stdcall, dynlib: "gdi32",
    importc: "ResetDCA".}
  #function ResetDCW(DC: HDC; const p2: TDeviceModeW): HDC; stdcall; external 'gdi32' name 'ResetDCW';
proc ScreenToClient*(wnd: HWND, lpPoint: var TPoint): WINBOOL{.stdcall,
    dynlib: "user32", importc: "ScreenToClient".}
proc ScrollConsoleScreenBuffer*(hConsoleOutput: THandle,
                                lpScrollRectangle: TSmallRect,
                                lpClipRectangle: TSmallRect,
                                dwDestinationOrigin: TCoord,
                                lpFill: var TCharInfo): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "ScrollConsoleScreenBufferA".}
proc ScrollConsoleScreenBufferA*(hConsoleOutput: THandle,
                                 lpScrollRectangle: TSmallRect,
                                 lpClipRectangle: TSmallRect,
                                 dwDestinationOrigin: TCoord,
                                 lpFill: var TCharInfo): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "ScrollConsoleScreenBufferA".}
proc ScrollConsoleScreenBufferW*(hConsoleOutput: THandle,
                                 lpScrollRectangle: TSmallRect,
                                 lpClipRectangle: TSmallRect,
                                 dwDestinationOrigin: TCoord,
                                 lpFill: var TCharInfo): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "ScrollConsoleScreenBufferW".}
proc ScrollWindow*(wnd: HWND, XAmount: int32, YAmount: int32, rect: LPRECT,
                   lpClipRect: lpRECT): WINBOOL{.stdcall, dynlib: "user32",
    importc: "ScrollWindow".}
proc ScrollWindowEx*(wnd: HWND, dx: int32, dy: int32, prcScroll: lpRECT,
                     prcClip: lpRECT, hrgnUpdate: HRGN, prcUpdate: LPRECT,
                     flags: UINT): int32{.stdcall, dynlib: "user32",
    importc: "ScrollWindowEx".}
  #function ScrollDC(DC: HDC; DX, DY: Integer; var Scroll, Clip: TRect; Rgn: HRGN; Update: PRect): WINBOOL; stdcall; external 'user32' name 'ScrollDC';
  #function SearchPath(lpPath, lpFileName, lpExtension: PChar; nBufferLength: DWORD; lpBuffer: PChar; var lpFilePart: PChar): DWORD;stdcall; external 'kernel32' name 'SearchPathA';
  #function SearchPathA(lpPath, lpFileName, lpExtension: LPCSTR; nBufferLength: DWORD; lpBuffer: LPCSTR; var lpFilePart: LPCSTR): DWORD; stdcall; external 'kernel32' name 'SearchPathA';
  #function SearchPathW(lpPath, lpFileName, lpExtension: LPWSTR; nBufferLength: DWORD; lpBuffer: LPWSTR; var lpFilePart: LPWSTR): DWORD; stdcall; external 'kernel32' name 'SearchPathW';
  #function SendInput(cInputs: UINT; var pInputs: TInput; cbSize: Integer): UINT;stdcall; external 'user32' name 'SendInput';
proc SendMessageTimeout*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM,
                         fuFlags, uTimeout: UINT, lpdwResult: var DWORD): LRESULT{.
    stdcall, dynlib: "user32", importc: "SendMessageTimeoutA".}
proc SendMessageTimeoutA*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM,
                          fuFlags, uTimeout: UINT, lpdwResult: var DWORD): LRESULT{.
    stdcall, dynlib: "user32", importc: "SendMessageTimeoutA".}
proc SendMessageTimeoutW*(wnd: HWND, Msg: UINT, wp: WPARAM, lp: LPARAM,
                          fuFlags, uTimeout: UINT, lpdwResult: var DWORD): LRESULT{.
    stdcall, dynlib: "user32", importc: "SendMessageTimeoutW".}
  #function SetAclInformation(var pAcl: TACL; pAclInformation: Pointer; nAclInformationLength: DWORD; dwAclInformationClass: TAclInformationClass): WINBOOL; stdcall; external 'advapi32' name 'SetAclInformation';
  #function SetColorAdjustment(DC: HDC; const p2: TColorAdjustment): WINBOOL; stdcall; external 'gdi32' name 'SetColorAdjustment';
proc SetCommConfig*(hCommDev: THandle, lpCC: TCommConfig, dwSize: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetCommConfig".}
proc SetCommState*(hFile: THandle, lpDCB: TDCB): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetCommState".}
proc SetCommTimeouts*(hFile: THandle, lpCommTimeouts: TCommTimeouts): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetCommTimeouts".}
proc SetConsoleCursorInfo*(hConsoleOutput: THandle,
                           lpConsoleCursorInfo: TConsoleCursorInfo): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetConsoleCursorInfo".}
  #function SetConsoleWindowInfo(hConsoleOutput: THandle; bAbsolute: WINBOOL; const lpConsoleWindow: TSmallRect): WINBOOL; stdcall; external 'kernel32' name 'SetConsoleWindowInfo';
proc SetCriticalSectionSpinCount*(lpCriticalSection: var TRTLCriticalSection,
                                  dwSpinCount: DWORD): DWORD{.stdcall,
    dynlib: "kernel32", importc: "SetCriticalSectionSpinCount".}
proc SetDeviceGammaRamp*(DC: HDC, Ramp: pointer): WINBOOL{.stdcall,
    dynlib: "gdi32", importc: "SetDeviceGammaRamp".}
proc SetDIBColorTable*(DC: HDC, p2, p3: UINT, RGBQuadSTructs: pointer): UINT{.
    stdcall, dynlib: "gdi32", importc: "SetDIBColorTable".}
proc SetDIBits*(DC: HDC, Bitmap: HBITMAP, StartScan, NumScans: UINT,
                Bits: Pointer, BitsInfo: var TBitmapInfo, Usage: UINT): int{.
    stdcall, dynlib: "gdi32", importc: "SetDIBits".}
  #function SetDIBitsToDevice(DC: HDC; DestX, DestY: Integer; Width, Height: DWORD; SrcX, SrcY: Integer; nStartScan, NumScans: UINT; Bits: Pointer; var BitsInfo: TBitmapInfo; Usage: UINT): Integer; stdcall; external 'gdi32' name 'SetDIBitsToDevice';
proc SetEnhMetaFileBits*(para1: UINT, para2: pointer): HENHMETAFILE{.stdcall,
    dynlib: "gdi32", importc: "SetEnhMetaFileBits".}
proc SetFileTime*(hFile: HANDLE, lpCreationTime: var FILETIME,
                  lpLastAccessTime: var FILETIME, lpLastWriteTime: var FILETIME): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetFileTime".}
  #function SetKeyboardState(var KeyState: TKeyboardState): WINBOOL; stdcall; external 'user32' name 'SetKeyboardState';
  #function SetLocalTime(const lpSystemTime: TSystemTime): WINBOOL; stdcall; external 'kernel32' name 'SetLocalTime';
  #function SetMenuInfo(menu: HMENU; const lpcmi: TMenuInfo): WINBOOL;stdcall; external 'user32' name 'SetMenuInfo';
proc SetMenuItemInfo*(p1: HMENU, p2: UINT, p3: WINBOOL, p4: TMenuItemInfo): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SetMenuItemInfoA".}
proc SetMenuItemInfoA*(p1: HMENU, p2: UINT, p3: WINBOOL, p4: TMenuItemInfoA): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SetMenuItemInfoA".}
  #function SetMenuItemInfoW(p1: HMENU; p2: UINT; p3: WINBOOL; const p4: TMenuItemInfoW): WINBOOL; stdcall; external 'user32' name 'SetMenuItemInfoW';
proc SetMetaFileBitsEx*(p1: UINT, p2: cstring): HMETAFILE{.stdcall,
    dynlib: "gdi32", importc: "SetMetaFileBitsEx".}
proc SetNamedPipeHandleState*(hNamedPipe: THandle, lpMode: var DWORD,
    lpMaxCollectionCount, lpCollectDataTimeout: Pointer): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetNamedPipeHandleState".}
proc SetPaletteEntries*(Palette: HPALETTE, StartIndex, NumEntries: UINT,
                        PaletteEntries: pointer): UINT{.stdcall,
    dynlib: "gdi32", importc: "SetPaletteEntries".}
  #function SetPrivateObjectSecurity(SecurityInformation: SECURITY_INFORMATION; ModificationDescriptor: PSecurityDescriptor; var ObjectsSecurityDescriptor: PSecurityDescriptor; const GenericMapping: TGenericMapping; Token: THandle): WINBOOL;
  #  stdcall; external 'advapi32' name 'SetPrivateObjectSecurity';
  #function SetPrivateObjectSecurityEx(SecurityInformation: SECURITY_INFORMATION; ModificationDescriptor: PSecurityDescriptor; var ObjectsSecurityDescriptor: PSecurityDescriptor; AutoInheritFlags: ULONG;
  #  const GenericMapping: TGenericMapping; Token: THandle): WINBOOL;stdcall; external 'advapi32' name 'SetPrivateObjectSecurityEx';
proc SetRect*(lprc: var TRect, xLeft, yTop, xRight, yBottom: int): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SetRect".}
proc SetRectEmpty*(lprc: var TRect): WINBOOL{.stdcall, dynlib: "user32",
    importc: "SetRectEmpty".}
proc SetScrollInfo*(wnd: HWND, BarFlag: int, ScrollInfo: TScrollInfo,
                    Redraw: WINBOOL): int{.stdcall, dynlib: "user32",
    importc: "SetScrollInfo".}
proc SetSysColors*(cElements: int, lpaElements: pointer, lpaRgbValues: pointer): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SetSysColors".}
  #function SetSystemTime(const lpSystemTime: TSystemTime): WINBOOL; stdcall; external 'kernel32' name 'SetSystemTime';
proc SetThreadContext*(hThread: THandle, lpContext: TContext): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SetThreadContext".}
  #function SetTimeZoneInformation(const lpTimeZoneInformation: TTimeZoneInformation): WINBOOL; stdcall; external 'kernel32' name 'SetTimeZoneInformation';
proc SetUserObjectSecurity*(hObj: THandle, pSIRequested: var DWORD,
                            pSID: PSecurityDescriptor): WINBOOL{.stdcall,
    dynlib: "user32", importc: "SetUserObjectSecurity".}
proc SetWaitableTimer*(hTimer: THandle, lpDueTime: var TLargeInteger,
                       lPeriod: int32, pfnCompletionRoutine: TFNTimerAPCRoutine,
                       lpArgToCompletionRoutine: Pointer, fResume: WINBOOL): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SetWaitableTimer".}
proc SetWinMetaFileBits*(p1: UINT, p2: cstring, p3: HDC, p4: TMetaFilePict): HENHMETAFILE{.
    stdcall, dynlib: "gdi32", importc: "SetWinMetaFileBits".}
  #function SetWorldTransform(DC: HDC; const p2: TXForm): WINBOOL; stdcall; external 'gdi32' name 'SetWorldTransform';
proc StartDoc*(DC: HDC, p2: TDocInfo): int{.stdcall, dynlib: "gdi32",
    importc: "StartDocA".}
proc StartDocA*(DC: HDC, p2: TDocInfoA): int{.stdcall, dynlib: "gdi32",
    importc: "StartDocA".}
  #function StartDocW(DC: HDC; const p2: TDocInfoW): Integer; stdcall; external 'gdi32' name 'StartDocW';
  #function StretchDIBits(DC: HDC; DestX, DestY, DestWidth, DestHegiht, SrcX, SrcY, SrcWidth, SrcHeight: Integer; Bits: Pointer; var BitsInfo: TBitmapInfo; Usage: UINT; Rop: DWORD): Integer; stdcall; external 'gdi32' name 'StretchDIBits';
proc SubtractRect*(lprcDst: var TRect, lprcSrc1, lprcSrc2: TRect): WINBOOL{.
    stdcall, dynlib: "user32", importc: "SubtractRect".}
proc SystemTimeToFileTime*(lpSystemTime: TSystemTime, lpFileTime: var TFileTime): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "SystemTimeToFileTime".}
proc SystemTimeToTzSpecificLocalTime*(lpTimeZoneInformation: PTimeZoneInformation,
    lpUniversalTime, lpLocalTime: var TSystemTime): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "SystemTimeToTzSpecificLocalTime".}
proc TabbedTextOut*(hDC: HDC, X, Y: int, lpString: cstring,
                    nCount, nTabPositions: int, lpnTabStopPositions: pointer,
                    nTabOrigin: int): int32{.stdcall, dynlib: "user32",
    importc: "TabbedTextOutA".}
proc TabbedTextOutA*(hDC: HDC, X, Y: int, lpString: LPCSTR,
                     nCount, nTabPositions: int, lpnTabStopPositions: pointer,
                     nTabOrigin: int): int32{.stdcall, dynlib: "user32",
    importc: "TabbedTextOutA".}
proc TabbedTextOutW*(hDC: HDC, X, Y: int, lpString: LPWSTR,
                     nCount, nTabPositions: int, lpnTabStopPositions: pointer,
                     nTabOrigin: int): int32{.stdcall, dynlib: "user32",
    importc: "TabbedTextOutW".}
  #function ToAscii(uVirtKey, uScanCode: UINT; const KeyState: TKeyboardState; lpChar: PChar; uFlags: UINT): Integer; stdcall; external 'user32' name 'ToAscii';
  #function ToAsciiEx(uVirtKey: UINT; uScanCode: UINT; const KeyState: TKeyboardState; lpChar: PChar; uFlags: UINT; dwhkl: HKL): Integer; stdcall; external 'user32' name 'ToAsciiEx';
  #function ToUnicode(wVirtKey, wScanCode: UINT; const KeyState: TKeyboardState; var pwszBuff; cchBuff: Integer; wFlags: UINT): Integer; stdcall; external 'user32' name 'ToUnicode';
  # Careful, NT and higher only.
proc TrackMouseEvent*(EventTrack: var TTrackMouseEvent): WINBOOL{.stdcall,
    dynlib: "user32", importc: "TrackMouseEvent".}
proc TrackMouseEvent*(lpEventTrack: PTrackMouseEvent): WINBOOL{.stdcall,
    dynlib: "user32", importc: "TrackMouseEvent".}
proc TrackPopupMenu*(menu: HMENU, uFlags: UINT, x: int32, y: int32,
                     nReserved: int32, wnd: HWND, prcRect: PRect): WINBOOL{.
    stdcall, dynlib: "user32", importc: "TrackPopupMenu".}
proc TransactNamedPipe*(hNamedPipe: THandle, lpInBuffer: Pointer,
                        nInBufferSize: DWORD, lpOutBuffer: Pointer,
                        nOutBufferSize: DWORD, lpBytesRead: var DWORD,
                        lpOverlapped: POverlapped): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "TransactNamedPipe".}
proc TranslateAccelerator*(wnd: HWND, hAccTable: HACCEL, lpMsg: var TMsg): int{.
    stdcall, dynlib: "user32", importc: "TranslateAcceleratorA".}
proc TranslateAcceleratorA*(wnd: HWND, hAccTable: HACCEL, lpMsg: var TMsg): int{.
    stdcall, dynlib: "user32", importc: "TranslateAcceleratorA".}
proc TranslateAcceleratorW*(wnd: HWND, hAccTable: HACCEL, lpMsg: var TMsg): int{.
    stdcall, dynlib: "user32", importc: "TranslateAcceleratorW".}
proc TranslateCharsetInfo*(lpSrc: var DWORD, lpCs: var TCharsetInfo,
                           dwFlags: DWORD): WINBOOL{.stdcall, dynlib: "gdi32",
    importc: "TranslateCharsetInfo".}
proc TranslateMDISysAccel*(hWndClient: HWND, lpMsg: TMsg): WINBOOL{.stdcall,
    dynlib: "user32", importc: "TranslateMDISysAccel".}
proc TranslateMessage*(lpMsg: TMsg): WINBOOL{.stdcall, dynlib: "user32",
    importc: "TranslateMessage".}
  #function TransparentDIBits(DC: HDC; p2, p3, p4, p5: Integer; const p6: Pointer; const p7: PBitmapInfo; p8: UINT; p9, p10, p11, p12: Integer; p13: UINT): WINBOOL;stdcall; external 'gdi32' name 'TransparentDIBits';
proc TryEnterCriticalSection*(lpCriticalSection: var TRTLCriticalSection): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "TryEnterCriticalSection".}
proc UnhandledExceptionFilter*(ExceptionInfo: TExceptionPointers): int32{.
    stdcall, dynlib: "kernel32", importc: "UnhandledExceptionFilter".}
proc UnionRect*(lprcDst: var TRect, lprcSrc1, lprcSrc2: TRect): WINBOOL{.
    stdcall, dynlib: "user32", importc: "UnionRect".}
proc UnlockFileEx*(hFile: THandle, dwReserved, nNumberOfBytesToUnlockLow: DWORD,
                   nNumberOfBytesToUnlockHigh: DWORD, lpOverlapped: TOverlapped): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "UnlockFileEx".}
proc VerFindFile*(uFlags: DWORD,
                  szFileName, szWinDir, szAppDir, szCurDir: cstring,
                  lpuCurDirLen: var UINT, szDestDir: cstring,
                  lpuDestDirLen: var UINT): DWORD{.stdcall, dynlib: "version",
    importc: "VerFindFileA".}
proc VerFindFileA*(uFlags: DWORD,
                   szFileName, szWinDir, szAppDir, szCurDir: LPCSTR,
                   lpuCurDirLen: var UINT, szDestDir: LPCSTR,
                   lpuDestDirLen: var UINT): DWORD{.stdcall, dynlib: "version",
    importc: "VerFindFileA".}
proc VerFindFileW*(uFlags: DWORD,
                   szFileName, szWinDir, szAppDir, szCurDir: LPWSTR,
                   lpuCurDirLen: var UINT, szDestDir: LPWSTR,
                   lpuDestDirLen: var UINT): DWORD{.stdcall, dynlib: "version",
    importc: "VerFindFileW".}
proc VerInstallFile*(uFlags: DWORD, szSrcFileName, szDestFileName, szSrcDir,
                                    szDestDir, szCurDir, szTmpFile: cstring,
                     lpuTmpFileLen: var UINT): DWORD{.stdcall,
    dynlib: "version", importc: "VerInstallFileA".}
proc VerInstallFileA*(uFlags: DWORD, szSrcFileName, szDestFileName, szSrcDir,
                                     szDestDir, szCurDir, szTmpFile: LPCSTR,
                      lpuTmpFileLen: var UINT): DWORD{.stdcall,
    dynlib: "version", importc: "VerInstallFileA".}
proc VerInstallFileW*(uFlags: DWORD, szSrcFileName, szDestFileName, szSrcDir,
                                     szDestDir, szCurDir, szTmpFile: LPWSTR,
                      lpuTmpFileLen: var UINT): DWORD{.stdcall,
    dynlib: "version", importc: "VerInstallFileW".}
proc VerQueryValue*(pBlock: Pointer, lpSubBlock: cstring,
                    lplpBuffer: var Pointer, puLen: var UINT): WINBOOL{.stdcall,
    dynlib: "version", importc: "VerQueryValueA".}
proc VerQueryValueA*(pBlock: Pointer, lpSubBlock: LPCSTR,
                     lplpBuffer: var Pointer, puLen: var UINT): WINBOOL{.
    stdcall, dynlib: "version", importc: "VerQueryValueA".}
proc VerQueryValueW*(pBlock: Pointer, lpSubBlock: LPWSTR,
                     lplpBuffer: var Pointer, puLen: var UINT): WINBOOL{.
    stdcall, dynlib: "version", importc: "VerQueryValueW".}
proc VirtualQuery*(lpAddress: Pointer, lpBuffer: var TMemoryBasicInformation,
                   dwLength: DWORD): DWORD{.stdcall, dynlib: "kernel32",
    importc: "VirtualQuery".}
proc VirtualQueryEx*(hProcess: THandle, lpAddress: Pointer,
                     lpBuffer: var TMemoryBasicInformation, dwLength: DWORD): DWORD{.
    stdcall, dynlib: "kernel32", importc: "VirtualQueryEx".}
proc WaitCommEvent*(hFile: THandle, lpEvtMask: var DWORD,
                    lpOverlapped: POverlapped): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WaitCommEvent".}
proc WaitForDebugEvent*(lpDebugEvent: var TDebugEvent, dwMilliseconds: DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WaitForDebugEvent".}
proc wglDescribeLayerPlane*(p1: HDC, p2, p3: int, p4: int,
                            p5: var TLayerPlaneDescriptor): WINBOOL{.stdcall,
    dynlib: "opengl32", importc: "wglDescribeLayerPlane".}
proc wglGetLayerPaletteEntries*(p1: HDC, p2, p3, p4: int, pcr: pointer): int{.
    stdcall, dynlib: "opengl32", importc: "wglGetLayerPaletteEntries".}
proc wglSetLayerPaletteEntries*(p1: HDC, p2, p3, p4: int, pcr: pointer): int{.
    stdcall, dynlib: "opengl32", importc: "wglSetLayerPaletteEntries".}
  #function wglSwapMultipleBuffers(p1: UINT; const p2: PWGLSwap): DWORD;stdcall; external 'opengl32' name 'wglSwapMultipleBuffers';
  #function WinSubmitCertificate(var lpCertificate: TWinCertificate): WINBOOL;stdcall; external 'imaghlp' name 'WinSubmitCertificate';
  #function WinVerifyTrust(wnd: HWND; const ActionID: TGUID; ActionData: Pointer): Longint;stdcall; external 'imaghlp' name 'WinVerifyTrust';
proc WNetAddConnection2*(lpNetResource: var TNetResource,
                         lpPassword, lpUserName: cstring, dwFlags: DWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetAddConnection2A".}
proc WNetAddConnection2A*(lpNetResource: var TNetResourceA,
                          lpPassword, lpUserName: LPCSTR, dwFlags: DWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetAddConnection2A".}
  #function WNetAddConnection2W(var lpNetResource: TNetResourceW; lpPassword, lpUserName: LPWSTR; dwFlags: DWORD): DWORD; stdcall; external 'mpr' name 'WNetAddConnection2W';
proc WNetAddConnection3*(hwndOwner: HWND, lpNetResource: var TNetResource,
                         lpPassword, lpUserName: cstring, dwFlags: DWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetAddConnection3A".}
proc WNetAddConnection3A*(hwndOwner: HWND, lpNetResource: var TNetResourceA,
                          lpPassword, lpUserName: LPCSTR, dwFlags: DWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetAddConnection3A".}
  #function WNetAddConnection3W(hwndOwner: HWND; var lpNetResource: TNetResourceW; lpPassword, lpUserName: LPWSTR; dwFlags: DWORD): DWORD; stdcall; external 'mpr' name 'WNetAddConnection3W';
proc WNetConnectionDialog1*(lpConnDlgStruct: var TConnectDlgStruct): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetConnectionDialog1A".}
proc WNetConnectionDialog1A*(lpConnDlgStruct: var TConnectDlgStruct): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetConnectionDialog1A".}
  #function WNetConnectionDialog1W(var lpConnDlgStruct: TConnectDlgStruct): DWORD; stdcall; external 'mpr' name 'WNetConnectionDialog1W';
proc WNetDisconnectDialog1*(lpConnDlgStruct: var TDiscDlgStruct): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetDisconnectDialog1A".}
proc WNetDisconnectDialog1A*(lpConnDlgStruct: var TDiscDlgStructA): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetDisconnectDialog1A".}
  #function WNetDisconnectDialog1W(var lpConnDlgStruct: TDiscDlgStructW): DWORD; stdcall; external 'mpr' name 'WNetDisconnectDialog1W';
proc WNetEnumResource*(hEnum: THandle, lpcCount: var DWORD, lpBuffer: Pointer,
                       lpBufferSize: var DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetEnumResourceA".}
proc WNetEnumResourceA*(hEnum: THandle, lpcCount: var DWORD, lpBuffer: Pointer,
                        lpBufferSize: var DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetEnumResourceA".}
proc WNetEnumResourceW*(hEnum: THandle, lpcCount: var DWORD, lpBuffer: Pointer,
                        lpBufferSize: var DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetEnumResourceW".}
proc WNetGetConnection*(lpLocalName: cstring, lpRemoteName: cstring,
                        lpnLength: var DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetGetConnectionA".}
proc WNetGetConnectionA*(lpLocalName: LPCSTR, lpRemoteName: LPCSTR,
                         lpnLength: var DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetGetConnectionA".}
proc WNetGetConnectionW*(lpLocalName: LPWSTR, lpRemoteName: LPWSTR,
                         lpnLength: var DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetGetConnectionW".}
proc WNetGetLastError*(lpError: var DWORD, lpErrorBuf: cstring,
                       nErrorBufSize: DWORD, lpNameBuf: cstring,
                       nNameBufSize: DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetGetLastErrorA".}
proc WNetGetLastErrorA*(lpError: var DWORD, lpErrorBuf: LPCSTR,
                        nErrorBufSize: DWORD, lpNameBuf: LPCSTR,
                        nNameBufSize: DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetGetLastErrorA".}
proc WNetGetLastErrorW*(lpError: var DWORD, lpErrorBuf: LPWSTR,
                        nErrorBufSize: DWORD, lpNameBuf: LPWSTR,
                        nNameBufSize: DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetGetLastErrorW".}
proc WNetGetNetworkInformation*(lpProvider: cstring,
                                lpNetInfoStruct: var TNetInfoStruct): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetNetworkInformationA".}
proc WNetGetNetworkInformationA*(lpProvider: LPCSTR,
                                 lpNetInfoStruct: var TNetInfoStruct): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetNetworkInformationA".}
proc WNetGetNetworkInformationW*(lpProvider: LPWSTR,
                                 lpNetInfoStruct: var TNetInfoStruct): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetNetworkInformationW".}
proc WNetGetProviderName*(dwNetType: DWORD, lpProviderName: cstring,
                          lpBufferSize: var DWORD): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetGetProviderNameA".}
proc WNetGetProviderNameA*(dwNetType: DWORD, lpProviderName: LPCSTR,
                           lpBufferSize: var DWORD): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetGetProviderNameA".}
proc WNetGetProviderNameW*(dwNetType: DWORD, lpProviderName: LPWSTR,
                           lpBufferSize: var DWORD): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetGetProviderNameW".}
proc WNetGetResourceParent*(lpNetResource: PNetResource, lpBuffer: Pointer,
                            cbBuffer: var DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetGetResourceParentA".}
proc WNetGetResourceParentA*(lpNetResource: PNetResourceA, lpBuffer: Pointer,
                             cbBuffer: var DWORD): DWORD{.stdcall,
    dynlib: "mpr", importc: "WNetGetResourceParentA".}
  #function WNetGetResourceParentW(lpNetResource: PNetResourceW; lpBuffer: Pointer; var cbBuffer: DWORD): DWORD;stdcall; external 'mpr' name 'WNetGetResourceParentW';
proc WNetGetUniversalName*(lpLocalPath: cstring, dwInfoLevel: DWORD,
                           lpBuffer: Pointer, lpBufferSize: var DWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetUniversalNameA".}
proc WNetGetUniversalNameA*(lpLocalPath: LPCSTR, dwInfoLevel: DWORD,
                            lpBuffer: Pointer, lpBufferSize: var DWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetUniversalNameA".}
proc WNetGetUniversalNameW*(lpLocalPath: LPWSTR, dwInfoLevel: DWORD,
                            lpBuffer: Pointer, lpBufferSize: var DWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetUniversalNameW".}
proc WNetGetUser*(lpName: cstring, lpUserName: cstring, lpnLength: var DWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetUserA".}
proc WNetGetUserA*(lpName: LPCSTR, lpUserName: LPCSTR, lpnLength: var DWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetUserA".}
proc WNetGetUserW*(lpName: LPWSTR, lpUserName: LPWSTR, lpnLength: var DWORD): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetGetUserW".}
proc WNetOpenEnum*(dwScope, dwType, dwUsage: DWORD, lpNetResource: PNetResource,
                   lphEnum: var THandle): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetOpenEnumA".}
proc WNetOpenEnumA*(dwScope, dwType, dwUsage: DWORD,
                    lpNetResource: PNetResourceA, lphEnum: var THandle): DWORD{.
    stdcall, dynlib: "mpr", importc: "WNetOpenEnumA".}
  #function WNetOpenEnumW(dwScope, dwType, dwUsage: DWORD; lpNetResource: PNetResourceW; var lphEnum: THandle): DWORD; stdcall; external 'mpr' name 'WNetOpenEnumW';
proc WNetUseConnection*(hwndOwner: HWND, lpNetResource: var TNetResource,
                        lpUserID: cstring, lpPassword: cstring, dwFlags: DWORD,
                        lpAccessName: cstring, lpBufferSize: var DWORD,
                        lpResult: var DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetUseConnectionA".}
proc WNetUseConnectionA*(hwndOwner: HWND, lpNetResource: var TNetResourceA,
                         lpUserID: LPCSTR, lpPassword: LPCSTR, dwFlags: DWORD,
                         lpAccessName: LPCSTR, lpBufferSize: var DWORD,
                         lpResult: var DWORD): DWORD{.stdcall, dynlib: "mpr",
    importc: "WNetUseConnectionA".}
  #function WNetUseConnectionW(hwndOwner: HWND; var lpNetResource: TNetResourceW; lpUserID: LPWSTR; lpPassword: LPWSTR; dwFlags: DWORD; lpAccessName: LPWSTR; var lpBufferSize: DWORD; var lpResult: DWORD): DWORD; stdcall; external 'mpr' name 'WNetUseConnectionW';
proc WriteConsole*(hConsoleOutput: THandle, lpBuffer: Pointer,
                   nNumberOfCharsToWrite: DWORD,
                   lpNumberOfCharsWritten: var DWORD, lpReserved: Pointer): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleA".}
proc WriteConsoleA*(hConsoleOutput: THandle, lpBuffer: Pointer,
                    nNumberOfCharsToWrite: DWORD,
                    lpNumberOfCharsWritten: var DWORD, lpReserved: Pointer): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleA".}
proc WriteConsoleInput*(hConsoleInput: THandle, lpBuffer: TInputRecord,
                        nLength: DWORD, lpNumberOfEventsWritten: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleInputA".}
proc WriteConsoleInputA*(hConsoleInput: THandle, lpBuffer: TInputRecord,
                         nLength: DWORD, lpNumberOfEventsWritten: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleInputA".}
proc WriteConsoleInputW*(hConsoleInput: THandle, lpBuffer: TInputRecord,
                         nLength: DWORD, lpNumberOfEventsWritten: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleInputW".}
proc WriteConsoleOutput*(hConsoleOutput: THandle, lpBuffer: Pointer,
                         dwBufferSize, dwBufferCoord: TCoord,
                         lpWriteRegion: var TSmallRect): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WriteConsoleOutputA".}
proc WriteConsoleOutputA*(hConsoleOutput: THandle, lpBuffer: Pointer,
                          dwBufferSize, dwBufferCoord: TCoord,
                          lpWriteRegion: var TSmallRect): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WriteConsoleOutputA".}
proc WriteConsoleOutputAttribute*(hConsoleOutput: THandle, lpAttribute: Pointer,
                                  nLength: DWORD, dwWriteCoord: TCoord,
                                  lpNumberOfAttrsWritten: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleOutputAttribute".}
proc WriteConsoleOutputCharacter*(hConsoleOutput: THandle, lpCharacter: cstring,
                                  nLength: DWORD, dwWriteCoord: TCoord,
                                  lpNumberOfCharsWritten: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleOutputCharacterA".}
proc WriteConsoleOutputCharacterA*(hConsoleOutput: THandle, lpCharacter: LPCSTR,
                                   nLength: DWORD, dwWriteCoord: TCoord,
                                   lpNumberOfCharsWritten: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleOutputCharacterA".}
proc WriteConsoleOutputCharacterW*(hConsoleOutput: THandle, lpCharacter: LPWSTR,
                                   nLength: DWORD, dwWriteCoord: TCoord,
                                   lpNumberOfCharsWritten: var DWORD): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleOutputCharacterW".}
proc WriteConsoleOutputW*(hConsoleOutput: THandle, lpBuffer: Pointer,
                          dwBufferSize, dwBufferCoord: TCoord,
                          lpWriteRegion: var TSmallRect): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WriteConsoleOutputW".}
proc WriteConsoleW*(hConsoleOutput: THandle, lpBuffer: Pointer,
                    nNumberOfCharsToWrite: DWORD,
                    lpNumberOfCharsWritten: var DWORD, lpReserved: Pointer): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteConsoleW".}
proc WriteFile*(hFile: THandle, Buffer: pointer, nNumberOfBytesToWrite: DWORD,
                lpNumberOfBytesWritten: var DWORD, lpOverlapped: POverlapped): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WriteFile".}
proc WriteFileEx*(hFile: THandle, lpBuffer: Pointer,
                  nNumberOfBytesToWrite: DWORD, lpOverlapped: TOverlapped,
                  lpCompletionRoutine: FARPROC): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WriteFileEx".}
proc WritePrivateProfileStructA*(lpszSection, lpszKey: LPCSTR, lpStruct: LPVOID,
                                 uSizeStruct: UINT, szFile: LPCSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WritePrivateProfileStructA".}
proc WritePrivateProfileStructW*(lpszSection, lpszKey: LPCWSTR,
                                 lpStruct: LPVOID, uSizeStruct: UINT,
                                 szFile: LPCWSTR): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WritePrivateProfileStructW".}
proc WritePrivateProfileStruct*(lpszSection, lpszKey: LPCTSTR, lpStruct: LPVOID,
                                uSizeStruct: UINT, szFile: LPCTSTR): WINBOOL{.
    stdcall, dynlib: "kernel32", importc: "WritePrivateProfileStructA".}
proc WriteProcessMemory*(hProcess: THandle, lpBaseAddress: Pointer,
                         lpBuffer: Pointer, nSize: DWORD,
                         lpNumberOfBytesWritten: var DWORD): WINBOOL{.stdcall,
    dynlib: "kernel32", importc: "WriteProcessMemory".}
proc SHFileOperation*(para1: var SHFILEOPSTRUCT): int32{.stdcall,
    dynlib: "shell32", importc: "SHFileOperation".}

  # these are old Win16 funcs that under win32 are aliases for several char* funcs.
# exist under Win32 (even in SDK's from 2002), but are officially "deprecated"
proc AnsiNext*(lpsz: LPCSTR): LPSTR{.stdcall, dynlib: "user32",
                                     importc: "CharNextA".}
proc AnsiPrev*(lpszStart: LPCSTR, lpszCurrent: LPCSTR): LPSTR{.stdcall,
    dynlib: "user32", importc: "CharPrevA".}
proc AnsiToOem*(lpszSrc: LPCSTR, lpszDst: LPSTR): WINBOOL{.stdcall,
    dynlib: "user32", importc: "CharToOemA".}
proc OemToAnsi*(lpszSrc: LPCSTR, lpszDst: LPSTR): WINBOOL{.stdcall,
    dynlib: "user32", importc: "OemToCharA".}
proc AnsiToOemBuff*(lpszSrc: LPCSTR, lpszDst: LPSTR, cchDstLength: DWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "CharToOemBuffA".}
proc OemToAnsiBuff*(lpszSrc: LPCSTR, lpszDst: LPSTR, cchDstLength: DWORD): WINBOOL{.
    stdcall, dynlib: "user32", importc: "OemToCharBuffA".}
proc AnsiUpper*(lpsz: LPSTR): LPSTR{.stdcall, dynlib: "user32",
                                     importc: "CharUpperA".}
proc AnsiUpperBuff*(lpsz: LPSTR, cchLength: DWORD): DWORD{.stdcall,
    dynlib: "user32", importc: "CharUpperBuffA".}
proc AnsiLower*(lpsz: LPSTR): LPSTR{.stdcall, dynlib: "user32",
                                     importc: "CharLowerA".}
proc AnsiLowerBuff*(lpsz: LPSTR, cchLength: DWORD): DWORD{.stdcall,
    dynlib: "user32", importc: "CharLowerBuffA".}

#== Implementation of macros

# WinBase.h

proc FreeModule*(h: HINST): WINBOOL =
  result = FreeLibrary(h)

proc MakeProcInstance*(p, i: pointer): pointer =
  result = p

proc FreeProcInstance*(p: pointer): pointer =
  result = p

proc GlobalDiscard*(hglbMem: HGLOBAL): HGLOBAL =
  result = GlobalReAlloc(hglbMem, 0, GMEM_MOVEABLE)

proc LocalDiscard*(hlocMem: HLOCAL): HLOCAL =
  result = LocalReAlloc(hlocMem, 0, LMEM_MOVEABLE)

# WinGDI.h

proc GetGValue*(rgb: int32): int8 =
  result = toU8(rgb shr 8'i32)
proc RGB*(r, g, b: int): COLORREF =
  result = toU32(r) or (toU32(g) shl 8) or (toU32(b) shl 16)
proc RGB*(r, g, b: range[0 .. 255]): COLORREF =
  result = r or g shl 8 or b shl 16

proc PALETTERGB*(r, g, b: range[0..255]): COLORREF =
  result = 0x02000000 or RGB(r, g, b)

proc PALETTEINDEX*(i: DWORD): COLORREF =
  result = COLORREF(0x01000000'i32 or i and 0xffff'i32)


proc GetRValue*(rgb: COLORREF): int8 =
  result = toU8(rgb)

proc GetGValue*(rgb: COLORREF): int8 =
  result = toU8(rgb shr 8)

proc GetBValue*(rgb: COLORREF): int8 =
  result = toU8(rgb shr 16)

#

proc HIBYTE*(w: int32): int8 =
  result = toU8(w shr 8'i32 and 0x000000FF'i32)

proc HIWORD*(L: int32): int16 =
  result = toU16(L shr 16'i32 and 0x0000FFFF'i32)

proc LOBYTE*(w: int32): int8 =
  result = toU8(w)

proc LOWORD*(L: int32): int16 =
  result = toU16(L)

proc MAKELONG*(a, b: int32): LONG =
  result = a and 0x0000ffff'i32 or b shl 16'i32

proc MAKEWORD*(a, b: int32): int16 =
  result = toU16(a and 0xff'i32) or toU16(b shl 8'i32)

proc SEXT_HIWORD*(L: int32): int32 =
  # return type might be wrong
  result = HIWORD(L)

proc ZEXT_HIWORD*(L: int32): int32 =
  # return type might be wrong
  result = HIWORD(L) and 0xffff'i32

proc SEXT_LOWORD*(L: int32): int32 =
  result = LOWORD(L)

proc INDEXTOOVERLAYMASK*(i: int32): int32 =
  # return type might be wrong
  result = i shl 8'i32

proc INDEXTOSTATEIMAGEMASK*(i: int32): int32 =
  # return type might be wrong
  result = i shl 12'i32

proc MAKEINTATOM*(i: int32): LPTSTR =
  result = cast[LPTSTR](cast[ULONG_PTR](ToU16(i)))

proc MAKELANGID*(p, s: int32): int32 =
  # return type might be wrong
  result = toU16(s) shl 10'i16 or toU16(p)

proc PRIMARYLANGID*(lgid: int32): int16 =
  result = toU16(lgid) and 0x000003FF'i16

proc SUBLANGID*(lgid: int32): int32 =
  # return type might be wrong
  result = toU16(lgid) shr 10'i16

proc LANGIDFROMLCID*(lcid: int32): int16 =
  result = toU16(lcid)

proc SORTIDFROMLCID*(lcid: int32): int16 =
  result = toU16((lcid and 0x000FFFFF'i32) shr 16'i32)

proc MAKELCID*(lgid, srtid: int32): DWORD =
  result = toU32(srtid shl 16'i32 or lgid and 0xffff'i32)

proc MAKELPARAM*(L, h: int32): LPARAM =
  result = LPARAM(MAKELONG(L, h))

proc MAKELRESULT*(L, h: int32): LRESULT =
  result = LRESULT(MAKELONG(L, h))

proc MAKEROP4*(fore, back: int32): DWORD =
  result = back shl 8'i32 and 0xFF000000'i32 or fore

proc MAKEWPARAM*(L, h: int32): WPARAM =
  result = WPARAM(MAKELONG(L, h))

proc GET_X_LPARAM*(lp: Windows.LParam): int32 =
  result = LOWORD(lp.int32)

proc GET_Y_LPARAM*(lp: Windows.LParam): int32 =
  result = HIWORD(lp.int32)

proc UNICODE_NULL*(): WCHAR =
  result = 0'u16



proc GetFirstChild*(h: HWND): HWND =
  result = GetTopWindow(h)

proc GetNextSibling*(h: HWND): HWND =
  result = GetWindow(h, GW_HWNDNEXT)

proc GetWindowID*(h: HWND): int32 =
  result = GetDlgCtrlID(h)

proc SubclassWindow*(h: HWND, p: LONG): LONG =
  result = SetWindowLong(h, GWL_WNDPROC, p)

proc GET_WM_COMMAND_CMD*(w, L: int32): int32 =
  # return type might be wrong
  result = HIWORD(w)

proc GET_WM_COMMAND_ID(w, L: int32): int32 =
  # return type might be wrong
  result = LOWORD(w)

proc GET_WM_CTLCOLOR_HDC(w, L, msg: int32): HDC =
  result = HDC(w)

proc GET_WM_CTLCOLOR_HWND(w, L, msg: int32): HWND =
  result = HWND(L)

proc GET_WM_HSCROLL_CODE(w, L: int32): int32 =
  # return type might be wrong
  result = LOWORD(w)

proc GET_WM_HSCROLL_HWND(w, L: int32): HWND =
  result = HWND(L)

proc GET_WM_HSCROLL_POS(w, L: int32): int32 =
  # return type might be wrong
  result = HIWORD(w)

proc GET_WM_MDIACTIVATE_FACTIVATE(h, a, b: int32): int32 =
  # return type might be wrong
  result = ord(b == h)

proc GET_WM_MDIACTIVATE_HWNDACTIVATE(a, b: int32): HWND =
  result = HWND(b)

proc GET_WM_MDIACTIVATE_HWNDDEACT(a, b: int32): HWND =
  result = HWND(a)

proc GET_WM_VSCROLL_CODE(w, L: int32): int32 =
  # return type might be wrong
  result = LOWORD(w)

proc GET_WM_VSCROLL_HWND(w, L: int32): HWND =
  result = HWND(L)

proc GET_WM_VSCROLL_POS(w, L: int32): int32 =
  # return type might be wrong
  result = HIWORD(w)

proc fBinary(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fBinary) shr bp_DCB_fBinary

proc set_fBinary(a: var DCB, fBinary: DWORD) =
  a.flags = a.flags or ((fBinary shl bp_DCB_fBinary) and bm_DCB_fBinary)

proc fParity(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fParity) shr bp_DCB_fParity

proc set_fParity(a: var DCB, fParity: DWORD) =
  a.flags = a.flags or ((fParity shl bp_DCB_fParity) and bm_DCB_fParity)

proc fOutxCtsFlow(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fOutxCtsFlow) shr bp_DCB_fOutxCtsFlow

proc set_fOutxCtsFlow(a: var DCB, fOutxCtsFlow: DWORD) =
  a.flags = a.flags or
      ((fOutxCtsFlow shl bp_DCB_fOutxCtsFlow) and bm_DCB_fOutxCtsFlow)

proc fOutxDsrFlow(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fOutxDsrFlow) shr bp_DCB_fOutxDsrFlow

proc set_fOutxDsrFlow(a: var DCB, fOutxDsrFlow: DWORD) =
  a.flags = a.flags or
      ((fOutxDsrFlow shl bp_DCB_fOutxDsrFlow) and bm_DCB_fOutxDsrFlow)

proc fDtrControl(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fDtrControl) shr bp_DCB_fDtrControl

proc set_fDtrControl(a: var DCB, fDtrControl: DWORD) =
  a.flags = a.flags or
      ((fDtrControl shl bp_DCB_fDtrControl) and bm_DCB_fDtrControl)

proc fDsrSensitivity(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fDsrSensitivity) shr bp_DCB_fDsrSensitivity

proc set_fDsrSensitivity(a: var DCB, fDsrSensitivity: DWORD) =
  a.flags = a.flags or
      ((fDsrSensitivity shl bp_DCB_fDsrSensitivity) and
      bm_DCB_fDsrSensitivity)

proc fTXContinueOnXoff(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fTXContinueOnXoff) shr
      bp_DCB_fTXContinueOnXoff

proc set_fTXContinueOnXoff(a: var DCB, fTXContinueOnXoff: DWORD) =
  a.flags = a.flags or
      ((fTXContinueOnXoff shl bp_DCB_fTXContinueOnXoff) and
      bm_DCB_fTXContinueOnXoff)

proc fOutX(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fOutX) shr bp_DCB_fOutX

proc set_fOutX(a: var DCB, fOutX: DWORD) =
  a.flags = a.flags or ((fOutX shl bp_DCB_fOutX) and bm_DCB_fOutX)

proc fInX(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fInX) shr bp_DCB_fInX

proc set_fInX(a: var DCB, fInX: DWORD) =
  a.flags = a.flags or ((fInX shl bp_DCB_fInX) and bm_DCB_fInX)

proc fErrorChar(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fErrorChar) shr bp_DCB_fErrorChar

proc set_fErrorChar(a: var DCB, fErrorChar: DWORD) =
  a.flags = a.flags or
      ((fErrorChar shl bp_DCB_fErrorChar) and bm_DCB_fErrorChar)

proc fNull(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fNull) shr bp_DCB_fNull

proc set_fNull(a: var DCB, fNull: DWORD) =
  a.flags = a.flags or ((fNull shl bp_DCB_fNull) and bm_DCB_fNull)

proc fRtsControl(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fRtsControl) shr bp_DCB_fRtsControl

proc set_fRtsControl(a: var DCB, fRtsControl: DWORD) =
  a.flags = a.flags or
      ((fRtsControl shl bp_DCB_fRtsControl) and bm_DCB_fRtsControl)

proc fAbortOnError(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fAbortOnError) shr bp_DCB_fAbortOnError

proc set_fAbortOnError(a: var DCB, fAbortOnError: DWORD) =
  a.flags = a.flags or
      ((fAbortOnError shl bp_DCB_fAbortOnError) and bm_DCB_fAbortOnError)

proc fDummy2(a: var DCB): DWORD =
  result = (a.flags and bm_DCB_fDummy2) shr bp_DCB_fDummy2

proc set_fDummy2(a: var DCB, fDummy2: DWORD) =
  a.flags = a.flags or ((fDummy2 shl bp_DCB_fDummy2) and bm_DCB_fDummy2)

proc fCtsHold(a: var COMSTAT): DWORD =
  result = (a.flag0 and bm_COMSTAT_fCtsHold) shr bp_COMSTAT_fCtsHold

proc set_fCtsHold(a: var COMSTAT, fCtsHold: DWORD) =
  a.flag0 = a.flag0 or
      ((fCtsHold shl bp_COMSTAT_fCtsHold) and bm_COMSTAT_fCtsHold)

proc fDsrHold(a: var COMSTAT): DWORD =
  result = (a.flag0 and bm_COMSTAT_fDsrHold) shr bp_COMSTAT_fDsrHold

proc set_fDsrHold(a: var COMSTAT, fDsrHold: DWORD) =
  a.flag0 = a.flag0 or
      ((fDsrHold shl bp_COMSTAT_fDsrHold) and bm_COMSTAT_fDsrHold)

proc fRlsdHold(a: var COMSTAT): DWORD =
  result = (a.flag0 and bm_COMSTAT_fRlsdHold) shr bp_COMSTAT_fRlsdHold

proc set_fRlsdHold(a: var COMSTAT, fRlsdHold: DWORD) =
  a.flag0 = a.flag0 or
      ((fRlsdHold shl bp_COMSTAT_fRlsdHold) and bm_COMSTAT_fRlsdHold)

proc fXoffHold(a: var COMSTAT): DWORD =
  result = (a.flag0 and bm_COMSTAT_fXoffHold) shr bp_COMSTAT_fXoffHold

proc set_fXoffHold(a: var COMSTAT, fXoffHold: DWORD) =
  a.flag0 = a.flag0 or
      ((fXoffHold shl bp_COMSTAT_fXoffHold) and bm_COMSTAT_fXoffHold)

proc fXoffSent(a: var COMSTAT): DWORD =
  result = (a.flag0 and bm_COMSTAT_fXoffSent) shr bp_COMSTAT_fXoffSent

proc set_fXoffSent(a: var COMSTAT, fXoffSent: DWORD) =
  a.flag0 = a.flag0 or
      ((fXoffSent shl bp_COMSTAT_fXoffSent) and bm_COMSTAT_fXoffSent)

proc fEof(a: var COMSTAT): DWORD =
  result = (a.flag0 and bm_COMSTAT_fEof) shr bp_COMSTAT_fEof

proc set_fEof(a: var COMSTAT, fEof: DWORD) =
  a.flag0 = a.flag0 or ((fEof shl bp_COMSTAT_fEof) and bm_COMSTAT_fEof)

proc fTxim(a: var COMSTAT): DWORD =
  result = (a.flag0 and bm_COMSTAT_fTxim) shr bp_COMSTAT_fTxim

proc set_fTxim(a: var COMSTAT, fTxim: DWORD) =
  a.flag0 = a.flag0 or ((fTxim shl bp_COMSTAT_fTxim) and bm_COMSTAT_fTxim)

proc fReserved(a: var COMSTAT): DWORD =
  result = (a.flag0 and bm_COMSTAT_fReserved) shr bp_COMSTAT_fReserved

proc set_fReserved(a: var COMSTAT, fReserved: DWORD) =
  a.flag0 = a.flag0 or
      ((fReserved shl bp_COMSTAT_fReserved) and bm_COMSTAT_fReserved)

proc bAppReturnCode(a: var DDEACK): int16 =
  result = (a.flag0 and bm_DDEACK_bAppReturnCode) shr
      bp_DDEACK_bAppReturnCode

proc set_bAppReturnCode(a: var DDEACK, bAppReturnCode: int16) =
  a.flag0 = a.flag0 or
      ((bAppReturnCode shl bp_DDEACK_bAppReturnCode) and
      bm_DDEACK_bAppReturnCode)

proc reserved(a: var DDEACK): int16 =
  result = (a.flag0 and bm_DDEACK_reserved) shr bp_DDEACK_reserved

proc set_reserved(a: var DDEACK, reserved: int16) =
  a.flag0 = a.flag0 or
      ((reserved shl bp_DDEACK_reserved) and bm_DDEACK_reserved)

proc fBusy(a: var DDEACK): int16 =
  result = (a.flag0 and bm_DDEACK_fBusy) shr bp_DDEACK_fBusy

proc set_fBusy(a: var DDEACK, fBusy: int16) =
  a.flag0 = a.flag0 or ((fBusy shl bp_DDEACK_fBusy) and bm_DDEACK_fBusy)

proc fAck(a: var DDEACK): int16 =
  result = (a.flag0 and bm_DDEACK_fAck) shr bp_DDEACK_fAck

proc set_fAck(a: var DDEACK, fAck: int16) =
  a.flag0 = a.flag0 or ((fAck shl bp_DDEACK_fAck) and bm_DDEACK_fAck)

proc reserved(a: var DDEADVISE): int16 =
  result = (a.flag0 and bm_DDEADVISE_reserved) shr bp_DDEADVISE_reserved

proc set_reserved(a: var DDEADVISE, reserved: int16) =
  a.flag0 = a.flag0 or
      ((reserved shl bp_DDEADVISE_reserved) and bm_DDEADVISE_reserved)

proc fDeferUpd(a: var DDEADVISE): int16 =
  result = (a.flag0 and bm_DDEADVISE_fDeferUpd) shr bp_DDEADVISE_fDeferUpd

proc set_fDeferUpd(a: var DDEADVISE, fDeferUpd: int16) =
  a.flag0 = a.flag0 or
      ((fDeferUpd shl bp_DDEADVISE_fDeferUpd) and bm_DDEADVISE_fDeferUpd)

proc fAckReq(a: var DDEADVISE): int16 =
  result = (a.flag0 and bm_DDEADVISE_fAckReq) shr bp_DDEADVISE_fAckReq

proc set_fAckReq(a: var DDEADVISE, fAckReq: int16) =
  a.flag0 = a.flag0 or
      ((fAckReq shl bp_DDEADVISE_fAckReq) and bm_DDEADVISE_fAckReq)

proc unused(a: var DDEDATA): int16 =
  result = (a.flag0 and bm_DDEDATA_unused) shr bp_DDEDATA_unused

proc set_unused(a: var DDEDATA, unused: int16) =
  a.flag0 = a.flag0 or ((unused shl bp_DDEDATA_unused) and bm_DDEDATA_unused)

proc fResponse(a: var DDEDATA): int16 =
  result = (a.flag0 and bm_DDEDATA_fResponse) shr bp_DDEDATA_fResponse

proc set_fResponse(a: var DDEDATA, fResponse: int16) =
  a.flag0 = a.flag0 or
      ((fResponse shl bp_DDEDATA_fResponse) and bm_DDEDATA_fResponse)

proc fRelease(a: var DDEDATA): int16 =
  result = (a.flag0 and bm_DDEDATA_fRelease) shr bp_DDEDATA_fRelease

proc set_fRelease(a: var DDEDATA, fRelease: int16) =
  a.flag0 = a.flag0 or
      ((fRelease shl bp_DDEDATA_fRelease) and bm_DDEDATA_fRelease)

proc reserved(a: var DDEDATA): int16 =
  result = (a.flag0 and bm_DDEDATA_reserved) shr bp_DDEDATA_reserved

proc set_reserved(a: var DDEDATA, reserved: int16) =
  a.flag0 = a.flag0 or
      ((reserved shl bp_DDEDATA_reserved) and bm_DDEDATA_reserved)

proc fAckReq(a: var DDEDATA): int16 =
  result = (a.flag0 and bm_DDEDATA_fAckReq) shr bp_DDEDATA_fAckReq

proc set_fAckReq(a: var DDEDATA, fAckReq: int16) =
  a.flag0 = a.flag0 or
      ((fAckReq shl bp_DDEDATA_fAckReq) and bm_DDEDATA_fAckReq)

proc unused(a: var DDELN): int16 =
  result = (a.flag0 and bm_DDELN_unused) shr bp_DDELN_unused

proc set_unused(a: var DDELN, unused: int16) =
  a.flag0 = a.flag0 or ((unused shl bp_DDELN_unused) and bm_DDELN_unused)

proc fRelease(a: var DDELN): int16 =
  result = (a.flag0 and bm_DDELN_fRelease) shr bp_DDELN_fRelease

proc set_fRelease(a: var DDELN, fRelease: int16) =
  a.flag0 = a.flag0 or
      ((fRelease shl bp_DDELN_fRelease) and bm_DDELN_fRelease)

proc fDeferUpd(a: var DDELN): int16 =
  result = (a.flag0 and bm_DDELN_fDeferUpd) shr bp_DDELN_fDeferUpd

proc set_fDeferUpd(a: var DDELN, fDeferUpd: int16) =
  a.flag0 = a.flag0 or
      ((fDeferUpd shl bp_DDELN_fDeferUpd) and bm_DDELN_fDeferUpd)

proc fAckReq(a: var DDELN): int16 =
  result = (a.flag0 and bm_DDELN_fAckReq) shr bp_DDELN_fAckReq

proc set_fAckReq(a: var DDELN, fAckReq: int16) =
  a.flag0 = a.flag0 or ((fAckReq shl bp_DDELN_fAckReq) and bm_DDELN_fAckReq)

proc unused(a: var DDEPOKE): int16 =
  result = (a.flag0 and bm_DDEPOKE_unused) shr bp_DDEPOKE_unused

proc set_unused(a: var DDEPOKE, unused: int16) =
  a.flag0 = a.flag0 or ((unused shl bp_DDEPOKE_unused) and bm_DDEPOKE_unused)

proc fRelease(a: var DDEPOKE): int16 =
  result = (a.flag0 and bm_DDEPOKE_fRelease) shr bp_DDEPOKE_fRelease

proc set_fRelease(a: var DDEPOKE, fRelease: int16) =
  a.flag0 = a.flag0 or
      ((fRelease shl bp_DDEPOKE_fRelease) and bm_DDEPOKE_fRelease)

proc fReserved(a: var DDEPOKE): int16 =
  result = (a.flag0 and bm_DDEPOKE_fReserved) shr bp_DDEPOKE_fReserved

proc set_fReserved(a: var DDEPOKE, fReserved: int16) =
  a.flag0 = a.flag0 or
      ((fReserved shl bp_DDEPOKE_fReserved) and bm_DDEPOKE_fReserved)

proc unused(a: var DDEUP): int16 =
  result = (a.flag0 and bm_DDEUP_unused) shr bp_DDEUP_unused

proc set_unused(a: var DDEUP, unused: int16) =
  a.flag0 = a.flag0 or ((unused shl bp_DDEUP_unused) and bm_DDEUP_unused)

proc fAck(a: var DDEUP): int16 =
  result = (a.flag0 and bm_DDEUP_fAck) shr bp_DDEUP_fAck

proc set_fAck(a: var DDEUP, fAck: int16) =
  a.flag0 = a.flag0 or ((fAck shl bp_DDEUP_fAck) and bm_DDEUP_fAck)

proc fRelease(a: var DDEUP): int16 =
  result = (a.flag0 and bm_DDEUP_fRelease) shr bp_DDEUP_fRelease

proc set_fRelease(a: var DDEUP, fRelease: int16) =
  a.flag0 = a.flag0 or
      ((fRelease shl bp_DDEUP_fRelease) and bm_DDEUP_fRelease)

proc fReserved(a: var DDEUP): int16 =
  result = (a.flag0 and bm_DDEUP_fReserved) shr bp_DDEUP_fReserved

proc set_fReserved(a: var DDEUP, fReserved: int16) =
  a.flag0 = a.flag0 or
      ((fReserved shl bp_DDEUP_fReserved) and bm_DDEUP_fReserved)

proc fAckReq(a: var DDEUP): int16 =
  result = (a.flag0 and bm_DDEUP_fAckReq) shr bp_DDEUP_fAckReq

proc set_fAckReq(a: var DDEUP, fAckReq: int16) =
  a.flag0 = a.flag0 or ((fAckReq shl bp_DDEUP_fAckReq) and bm_DDEUP_fAckReq)

proc CreateWindowA(lpClassName: LPCSTR, lpWindowName: LPCSTR, dwStyle: DWORD,
                   X: int32, Y: int32, nWidth: int32, nHeight: int32,
                   hWndParent: HWND, menu: HMENU, hInstance: HINST,
                   lpParam: LPVOID): HWND =
  result = CreateWindowExA(0, lpClassName, lpWindowName, dwStyle, x, y, nWidth,
                           nHeight, hWndParent, menu, hInstance, lpParam)

proc CreateDialogA(hInstance: HINST, lpTemplateName: LPCSTR, hWndParent: HWND,
                   lpDialogFunc: DLGPROC): HWND =
  result = CreateDialogParamA(hInstance, lpTemplateName, hWndParent,
                              lpDialogFunc, 0)

proc CreateDialogIndirectA(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                           hWndParent: HWND, lpDialogFunc: DLGPROC): HWND =
  result = CreateDialogIndirectParamA(hInstance, lpTemplate, hWndParent,
                                      lpDialogFunc, 0)

proc DialogBoxA(hInstance: HINST, lpTemplateName: LPCSTR, hWndParent: HWND,
                lpDialogFunc: DLGPROC): int32 =
  result = DialogBoxParamA(hInstance, lpTemplateName, hWndParent, lpDialogFunc,
                           0)

proc DialogBoxIndirectA(hInstance: HINST, hDialogTemplate: LPCDLGTEMPLATE,
                        hWndParent: HWND, lpDialogFunc: DLGPROC): int32 =
  result = DialogBoxIndirectParamA(hInstance, hDialogTemplate, hWndParent,
                                   lpDialogFunc, 0)

proc CreateWindowW(lpClassName: LPCWSTR, lpWindowName: LPCWSTR, dwStyle: DWORD,
                   X: int32, Y: int32, nWidth: int32, nHeight: int32,
                   hWndParent: HWND, menu: HMENU, hInstance: HINST,
                   lpParam: LPVOID): HWND =
  result = CreateWindowExW(0, lpClassName, lpWindowName, dwStyle, x, y, nWidth,
                           nHeight, hWndParent, menu, hInstance, lpParam)

proc CreateDialogW(hInstance: HINST, lpName: LPCWSTR, hWndParent: HWND,
                   lpDialogFunc: DLGPROC): HWND =
  result = CreateDialogParamW(hInstance, lpName, hWndParent, lpDialogFunc, 0)

proc CreateDialogIndirectW(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                           hWndParent: HWND, lpDialogFunc: DLGPROC): HWND =
  result = CreateDialogIndirectParamW(hInstance, lpTemplate, hWndParent,
                                      lpDialogFunc, 0)

proc DialogBoxW(hInstance: HINST, lpTemplate: LPCWSTR, hWndParent: HWND,
                lpDialogFunc: DLGPROC): int32 =
  result = DialogBoxParamW(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0)

proc DialogBoxIndirectW(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                        hWndParent: HWND, lpDialogFunc: DLGPROC): int32 =
  result = DialogBoxIndirectParamW(hInstance, lpTemplate, hWndParent,
                                   lpDialogFunc, 0)

when defined(winUnicode):
  proc CreateWindow(lpClassName: LPCWSTR, lpWindowName: LPCWSTR, dwStyle: DWORD,
                    X: int32, Y: int32, nWidth: int32, nHeight: int32,
                    hWndParent: HWND, menu: HMENU, hInstance: HINST,
                    lpParam: LPVOID): HWND =
    result = CreateWindowEx(0, lpClassName, lpWindowName, dwStyle, x, y, nWidth,
                            nHeight, hWndParent, hMenu, hInstance, lpParam)

  proc CreateDialog(hInstance: HINST, lpName: LPCWSTR, hWndParent: HWND,
                    lpDialogFunc: DLGPROC): HWND =
    result = CreateDialogParam(hInstance, lpName, hWndParent, lpDialogFunc, 0)

  proc CreateDialogIndirect(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                            hWndParent: HWND, lpDialogFunc: DLGPROC): HWND =
    result = CreateDialogIndirectParam(hInstance, lpTemplate, hWndParent,
                                       lpDialogFunc, 0)

  proc DialogBox(hInstance: HINST, lpTemplate: LPCWSTR, hWndParent: HWND,
                 lpDialogFunc: DLGPROC): int32 =
    result = DialogBoxParam(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0)

  proc DialogBoxIndirect(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                         hWndParent: HWND, lpDialogFunc: DLGPROC): int32 =
    result = DialogBoxIndirectParam(hInstance, lpTemplate, hWndParent,
                                    lpDialogFunc, 0)

else:
  proc CreateWindow(lpClassName: LPCSTR, lpWindowName: LPCSTR, dwStyle: DWORD,
                    X: int32, Y: int32, nWidth: int32, nHeight: int32,
                    hWndParent: HWND, menu: HMENU, hInstance: HINST,
                    lpParam: LPVOID): HWND =
    result = CreateWindowEx(0, lpClassName, lpWindowName, dwStyle, x, y, nWidth,
                            nHeight, hWndParent, menu, hInstance, lpParam)

  proc CreateDialog(hInstance: HINST, lpTemplateName: LPCSTR, hWndParent: HWND,
                    lpDialogFunc: DLGPROC): HWND =
    result = CreateDialogParam(hInstance, lpTemplateName, hWndParent,
                               lpDialogFunc, 0)

  proc CreateDialogIndirect(hInstance: HINST, lpTemplate: LPCDLGTEMPLATE,
                            hWndParent: HWND, lpDialogFunc: DLGPROC): HWND =
    result = CreateDialogIndirectParam(hInstance, lpTemplate, hWndParent,
                                       lpDialogFunc, 0)

  proc DialogBox(hInstance: HINST, lpTemplateName: LPCSTR, hWndParent: HWND,
                 lpDialogFunc: DLGPROC): int32 =
    result = DialogBoxParam(hInstance, lpTemplateName, hWndParent, lpDialogFunc,
                            0)

  proc DialogBoxIndirect(hInstance: HINST, hDialogTemplate: LPCDLGTEMPLATE,
                         hWndParent: HWND, lpDialogFunc: DLGPROC): int32 =
    result = DialogBoxIndirectParam(hInstance, hDialogTemplate, hWndParent,
                                    lpDialogFunc, 0)

proc GlobalAllocPtr(flags, cb: DWord): Pointer =
  result = GlobalLock(GlobalAlloc(flags, cb))

proc GlobalFreePtr(lp: Pointer): Pointer =
  result = cast[Pointer](GlobalFree(cast[HWND](GlobalUnlockPtr(lp))))

proc GlobalUnlockPtr(lp: pointer): Pointer =
  discard GlobalUnlock(GlobalHandle(lp))
  result = lp

proc GlobalLockPtr(lp: pointer): Pointer =
  result = GlobalLock(GlobalHandle(lp))

proc GlobalReAllocPtr(lp: Pointer, cbNew, flags: DWord): Pointer =
  result = GlobalLock(GlobalReAlloc(cast[HWND](GlobalUnlockPtr(lp)), cbNew, flags))

proc GlobalPtrHandle(lp: pointer): Pointer =
  result = cast[Pointer](GlobalHandle(lp))

proc ImageList_AddIcon(himl: HIMAGELIST, hicon: HICON): int32 =
  result = ImageList_ReplaceIcon(himl, -1, hicon)

proc Animate_Create(hWndP: HWND, id: HMENU, dwStyle: DWORD, hInstance: HINST): HWND =
  result = CreateWindow(cast[LPCSTR](ANIMATE_CLASS), nil, dwStyle, 0, 0, 0, 0, hwndP,
                        id, hInstance, nil)

proc Animate_Open(wnd: HWND, szName: LPTSTR): LRESULT =
  result = SendMessage(wnd, ACM_OPEN, 0, cast[LPARAM](szName))

proc Animate_Play(wnd: HWND, `from`, `to`: int32, rep: UINT): LRESULT =
  result = SendMessage(wnd, ACM_PLAY, WPARAM(rep),
                       LPARAM(MAKELONG(`from`, `to`)))

proc Animate_Stop(wnd: HWND): LRESULT =
  result = SendMessage(wnd, ACM_STOP, 0, 0)

proc Animate_Close(wnd: HWND): LRESULT =
  result = Animate_Open(wnd, nil)

proc Animate_Seek(wnd: HWND, frame: int32): LRESULT =
  result = Animate_Play(wnd, frame, frame, 1)

proc PropSheet_AddPage(hPropSheetDlg: HWND, hpage: HPROPSHEETPAGE): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_ADDPAGE, 0, cast[LPARAM](hpage))

proc PropSheet_Apply(hPropSheetDlg: HWND): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_APPLY, 0, 0)

proc PropSheet_CancelToClose(hPropSheetDlg: HWND): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_CANCELTOCLOSE, 0, 0)

proc PropSheet_Changed(hPropSheetDlg, hwndPage: HWND): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_CHANGED, WPARAM(hwndPage), 0)

proc PropSheet_GetCurrentPageHwnd(hDlg: HWND): LRESULT =
  result = SendMessage(hDlg, PSM_GETCURRENTPAGEHWND, 0, 0)

proc PropSheet_GetTabControl(hPropSheetDlg: HWND): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_GETTABCONTROL, 0, 0)

proc PropSheet_IsDialogMessage(hDlg: HWND, pMsg: int32): LRESULT =
  result = SendMessage(hDlg, PSM_ISDIALOGMESSAGE, 0, LPARAM(pMsg))

proc PropSheet_PressButton(hPropSheetDlg: HWND, iButton: int32): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_PRESSBUTTON, WPARAM(int32(iButton)), 0)

proc PropSheet_QuerySiblings(hPropSheetDlg: HWND, param1, param2: int32): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_QUERYSIBLINGS, WPARAM(param1),
                       LPARAM(param2))

proc PropSheet_RebootSystem(hPropSheetDlg: HWND): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_REBOOTSYSTEM, 0, 0)

proc PropSheet_RemovePage(hPropSheetDlg: HWND, hpage: HPROPSHEETPAGE,
                          index: int32): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_REMOVEPAGE, WPARAM(index),
                       cast[LPARAM](hpage))

proc PropSheet_RestartWindows(hPropSheetDlg: HWND): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_RESTARTWINDOWS, 0, 0)

proc PropSheet_SetCurSel(hPropSheetDlg: HWND, hpage: HPROPSHEETPAGE,
                         index: int32): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_SETCURSEL, WPARAM(index),
                       cast[LPARAM](hpage))

proc PropSheet_SetCurSelByID(hPropSheetDlg: HWND, id: int32): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_SETCURSELID, 0, LPARAM(id))

proc PropSheet_SetFinishText(hPropSheetDlg: HWND, lpszText: LPTSTR): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_SETFINISHTEXT, 0, cast[LPARAM](lpszText))

proc PropSheet_SetTitle(hPropSheetDlg: HWND, dwStyle: DWORD, lpszText: LPCTSTR): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_SETTITLE, WPARAM(dwStyle),
                       cast[LPARAM](lpszText))

proc PropSheet_SetWizButtons(hPropSheetDlg: HWND, dwFlags: DWORD): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_SETWIZBUTTONS, 0, LPARAM(dwFlags))

proc PropSheet_UnChanged(hPropSheetDlg: HWND, hwndPage: HWND): LRESULT =
  result = SendMessage(hPropSheetDlg, PSM_UNCHANGED, WPARAM(hwndPage), 0)

proc Header_DeleteItem(hwndHD: HWND, index: int32): WINBOOL =
  result = WINBOOL(SendMessage(hwndHD, HDM_DELETEITEM, WPARAM(index), 0))

proc Header_GetItem(hwndHD: HWND, index: int32, hdi: var HD_ITEM): WINBOOL =
  result = WINBOOL(SendMessage(hwndHD, HDM_GETITEM, WPARAM(index),
                               cast[LPARAM](addr(hdi))))

proc Header_GetItemCount(hwndHD: HWND): int32 =
  result = int32(SendMessage(hwndHD, HDM_GETITEMCOUNT, 0, 0))

proc Header_InsertItem(hwndHD: HWND, index: int32, hdi: var HD_ITEM): int32 =
  result = int32(SendMessage(hwndHD, HDM_INSERTITEM, WPARAM(index),
                             cast[LPARAM](addr(hdi))))

proc Header_Layout(hwndHD: HWND, layout: var HD_LAYOUT): WINBOOL =
  result = WINBOOL(SendMessage(hwndHD, HDM_LAYOUT, 0,
                   cast[LPARAM](addr(layout))))

proc Header_SetItem(hwndHD: HWND, index: int32, hdi: var HD_ITEM): WINBOOL =
  result = WINBOOL(SendMessage(hwndHD, HDM_SETITEM, WPARAM(index),
                               cast[LPARAM](addr(hdi))))

proc ListView_Arrange(hwndLV: HWND, code: UINT): LRESULT =
  result = SendMessage(hwndLV, LVM_ARRANGE, WPARAM(code), 0)

proc ListView_CreateDragImage(wnd: HWND, i: int32, lpptUpLeft: LPPOINT): LRESULT =
  result = SendMessage(wnd, LVM_CREATEDRAGIMAGE, WPARAM(i), cast[LPARAM](lpptUpLeft))

proc ListView_DeleteAllItems(wnd: HWND): LRESULT =
  result = SendMessage(wnd, LVM_DELETEALLITEMS, 0, 0)

proc ListView_DeleteColumn(wnd: HWND, iCol: int32): LRESULT =
  result = SendMessage(wnd, LVM_DELETECOLUMN, WPARAM(iCol), 0)

proc ListView_DeleteItem(wnd: HWND, iItem: int32): LRESULT =
  result = SendMessage(wnd, LVM_DELETEITEM, WPARAM(iItem), 0)

proc ListView_EditLabel(hwndLV: HWND, i: int32): LRESULT =
  result = SendMessage(hwndLV, LVM_EDITLABEL, WPARAM(int32(i)), 0)

proc ListView_EnsureVisible(hwndLV: HWND, i, fPartialOK: int32): LRESULT =
  result = SendMessage(hwndLV, LVM_ENSUREVISIBLE, WPARAM(i),
                       MAKELPARAM(fPartialOK, 0))

proc ListView_FindItem(wnd: HWND, iStart: int32, lvfi: var LV_FINDINFO): int32 =
  result = SendMessage(wnd, LVM_FINDITEM, WPARAM(iStart), 
                       cast[LPARAM](addr(lvfi))).int32

proc ListView_GetBkColor(wnd: HWND): LRESULT =
  result = SendMessage(wnd, LVM_GETBKCOLOR, 0, 0)

proc ListView_GetCallbackMask(wnd: HWND): LRESULT =
  result = SendMessage(wnd, LVM_GETCALLBACKMASK, 0, 0)

proc ListView_GetColumn(wnd: HWND, iCol: int32, col: var LV_COLUMN): LRESULT =
  result = SendMessage(wnd, LVM_GETCOLUMN, WPARAM(iCol), cast[LPARAM](addr(col)))

proc ListView_GetColumnWidth(wnd: HWND, iCol: int32): LRESULT =
  result = SendMessage(wnd, LVM_GETCOLUMNWIDTH, WPARAM(iCol), 0)

proc ListView_GetCountPerPage(hwndLV: HWND): LRESULT =
  result = SendMessage(hwndLV, LVM_GETCOUNTPERPAGE, 0, 0)

proc ListView_GetEditControl(hwndLV: HWND): LRESULT =
  result = SendMessage(hwndLV, LVM_GETEDITCONTROL, 0, 0)

proc ListView_GetImageList(wnd: HWND, iImageList: wINT): LRESULT =
  result = SendMessage(wnd, LVM_GETIMAGELIST, WPARAM(iImageList), 0)

proc ListView_GetISearchString(hwndLV: HWND, lpsz: LPTSTR): LRESULT =
  result = SendMessage(hwndLV, LVM_GETISEARCHSTRING, 0, cast[LPARAM](lpsz))

proc ListView_GetItem(wnd: HWND, item: var LV_ITEM): LRESULT =
  result = SendMessage(wnd, LVM_GETITEM, 0, cast[LPARAM](addr(item)))

proc ListView_GetItemCount(wnd: HWND): LRESULT =
  result = SendMessage(wnd, LVM_GETITEMCOUNT, 0, 0)

proc ListView_GetItemPosition(hwndLV: HWND, i: int32, pt: var POINT): int32 =
  result = SendMessage(hwndLV, LVM_GETITEMPOSITION, WPARAM(int32(i)),
                       cast[LPARAM](addr(pt))).int32

proc ListView_GetItemSpacing(hwndLV: HWND, fSmall: int32): LRESULT =
  result = SendMessage(hwndLV, LVM_GETITEMSPACING, fSmall, 0)

proc ListView_GetItemState(hwndLV: HWND, i, mask: int32): LRESULT =
  result = SendMessage(hwndLV, LVM_GETITEMSTATE, WPARAM(i), LPARAM(mask))

proc ListView_GetNextItem(wnd: HWND, iStart, flags: int32): LRESULT =
  result = SendMessage(wnd, LVM_GETNEXTITEM, WPARAM(iStart), LPARAM(flags))

proc ListView_GetOrigin(hwndLV: HWND, pt: var POINT): LRESULT =
  result = SendMessage(hwndLV, LVM_GETORIGIN, WPARAM(0), cast[LPARAM](addr(pt)))

proc ListView_GetSelectedCount(hwndLV: HWND): LRESULT =
  result = SendMessage(hwndLV, LVM_GETSELECTEDCOUNT, 0, 0)

proc ListView_GetStringWidth(hwndLV: HWND, psz: LPCTSTR): LRESULT =
  result = SendMessage(hwndLV, LVM_GETSTRINGWIDTH, 0, cast[LPARAM](psz))

proc ListView_GetTextBkColor(wnd: HWND): LRESULT =
  result = SendMessage(wnd, LVM_GETTEXTBKCOLOR, 0, 0)

proc ListView_GetTextColor(wnd: HWND): LRESULT =
  result = SendMessage(wnd, LVM_GETTEXTCOLOR, 0, 0)

proc ListView_GetTopIndex(hwndLV: HWND): LRESULT =
  result = SendMessage(hwndLV, LVM_GETTOPINDEX, 0, 0)

proc ListView_GetViewRect(wnd: HWND, rc: var RECT): LRESULT =
  result = SendMessage(wnd, LVM_GETVIEWRECT, 0, cast[LPARAM](addr(rc)))

proc ListView_HitTest(hwndLV: HWND, info: var LV_HITTESTINFO): LRESULT =
  result = SendMessage(hwndLV, LVM_HITTEST, 0, cast[LPARAM](addr(info)))

proc ListView_InsertColumn(wnd: HWND, iCol: int32, col: var LV_COLUMN): LRESULT =
  result = SendMessage(wnd, LVM_INSERTCOLUMN, WPARAM(iCol), cast[LPARAM](addr(col)))

proc ListView_InsertItem(wnd: HWND, item: var LV_ITEM): LRESULT =
  result = Send