/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

void put_window (TM *tm) {
  // main window
  if (tm->gtk->window != NULL) {
    gtk_widget_destroy(tm->gtk->window);
  }
  tm->gtk->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(tm->gtk->window), tm->cfg->window_title);
  if (strcmp(tm->cfg->remember_window_size, "yes") == 0) {
    gtk_window_set_default_size(GTK_WINDOW(tm->gtk->window), tm->cfg->window_width, tm->cfg->window_height);
  } else {
    gtk_window_set_default_size(GTK_WINDOW(tm->gtk->window), 840, 480);
  }
  gtk_window_set_position(GTK_WINDOW(tm->gtk->window), get_win_pos(tm->cfg->gtk_win_pos));
  gtk_widget_set_size_request(tm->gtk->window, tm->cfg->window_min_width, tm->cfg->window_min_height);
  g_signal_connect_swapped(tm->gtk->window, "delete-event", G_CALLBACK(gtk_neon_quit), tm);
  if (strcmp(tm->cfg->start_maximized, "yes") == 0) {
    gtk_window_maximize(GTK_WINDOW(tm->gtk->window));
  }
  // grid containers for packing everything up
  if (tm->gtk->grid1 != NULL) {
    gtk_widget_destroy(tm->gtk->grid1);
  }
  tm->gtk->grid1 = gtk_grid_new();
  gtk_container_add(GTK_CONTAINER(tm->gtk->window), tm->gtk->grid1);
  tm->gtk->grid11 = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->gtk->grid1), tm->gtk->grid11, 0, 0, 1, 1);
  tm->gtk->grid12 = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->gtk->grid1), tm->gtk->grid12, 0, 1, 1, 1);
  tm->gtk->grid13 = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->gtk->grid1), tm->gtk->grid13, 0, 2, 1, 1);
  tm->gtk->grid13a = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->gtk->grid13), tm->gtk->grid13a, 0, 0, 1, 1);
  tm->gtk->grid13b = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->gtk->grid13), tm->gtk->grid13b, 1, 0, 1, 1);
  tm->gtk->grid13c = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->gtk->grid13), tm->gtk->grid13c, 2, 0, 1, 1);
  tm->gtk->grid14 = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->gtk->grid1), tm->gtk->grid14, 0, 3, 1, 1);

  gtk_widget_show_all(tm->gtk->window);
}
