/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

void put_window (TM *tm) {
  tm->tgtk->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(tm->tgtk->window), tm->tcfg->window_title);
  if (strcmp(tm->tcfg->remember_window_size, "yes") == 0) {
    gtk_window_set_default_size(GTK_WINDOW(tm->tgtk->window), tm->tcfg->window_width, tm->tcfg->window_height);
  } else {
    gtk_window_set_default_size(GTK_WINDOW(tm->tgtk->window), 640, 400);
  }
  gtk_window_set_position(GTK_WINDOW(tm->tgtk->window), get_win_pos(tm->tcfg->gtk_win_pos));
  gtk_widget_set_size_request(tm->tgtk->window, 520, 320);
  g_signal_connect_swapped(tm->tgtk->window, "delete-event", G_CALLBACK(gtk_neon_quit), tm);

  if (strcmp(tm->tcfg->start_maximized, "yes") == 0) {
    gtk_window_maximize(GTK_WINDOW(tm->tgtk->window));
  }

  tm->tgtk->grid1 = gtk_grid_new();
  gtk_container_add(GTK_CONTAINER(tm->tgtk->window), tm->tgtk->grid1);
  tm->tgtk->grid11 = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->tgtk->grid1), tm->tgtk->grid11, 0, 0, 1, 1);
  tm->tgtk->grid12 = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->tgtk->grid1), tm->tgtk->grid12, 0, 1, 1, 1);
  tm->tgtk->grid13 = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->tgtk->grid1), tm->tgtk->grid13, 0, 2, 1, 1);
  tm->tgtk->grid13a = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->tgtk->grid13), tm->tgtk->grid13a, 0, 0, 1, 1);
  tm->tgtk->grid13b = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->tgtk->grid13), tm->tgtk->grid13b, 1, 0, 1, 1);
  tm->tgtk->grid13c = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->tgtk->grid13), tm->tgtk->grid13c, 2, 0, 1, 1);
  tm->tgtk->grid14 = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(tm->tgtk->grid1), tm->tgtk->grid14, 0, 3, 1, 1);
  gtk_widget_show_all(tm->tgtk->grid1);

  put_toolbar(tm);
  //  put_left_sidebar(tm);
  put_right_sidebar(tm);
  //  put_status(tm);
  //  put_menubar(tm); // now menu has toolbar and status stuff defined
  put_scrolled(tm);

  // grab focus so it is removed from the first button on toolbar
  gtk_widget_grab_focus(tm->tgtk->scrolled);

  //  gtk_widget_show(tm->tgtk->window);

  fprintf(stdout, "[NeonView] NeonView started...\n");
}

void put_menubar (TM *tm) {
  GtkWidget *menufile, *file, *open, *sep1, *quit;
  GtkWidget *menuimage, *image, *sep3, *normal, *fit, *orig, *sep4, *zoom_in, *zoom_out,
    *sep5, *rotate_left, *rotate_right, *flip;
  GtkWidget *menutools, *tools, *show_toolbar, *show_status, *show_left_sidebar, *show_right_sidebar, *sep6, *settings;
  GtkWidget *menuhelp, *help, *manual, *faq, *sep6a, *homepage, *sep7, *about;
  //  GtkWidget *save, *save_as;

  GtkAccelGroup *accel_group;

  accel_group = gtk_accel_group_new();
  gtk_window_add_accel_group(GTK_WINDOW(tm->tgtk->window), accel_group);

  tm->tgtk->menubar = gtk_menu_bar_new();

  /********************************* FILE MENU ***********************************/
  menufile = gtk_menu_new();
  file = gtk_menu_item_new_with_mnemonic("_File");
  open = gtk_menu_item_new_with_mnemonic("_Open...");
  sep1 = gtk_separator_menu_item_new();
  quit = gtk_menu_item_new_with_mnemonic("_Quit");
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(file), menufile);
  gtk_menu_shell_append(GTK_MENU_SHELL(menufile), open);
  gtk_menu_shell_append(GTK_MENU_SHELL(menufile), sep1);
  gtk_menu_shell_append(GTK_MENU_SHELL(menufile), quit);
  gtk_menu_shell_append(GTK_MENU_SHELL(tm->tgtk->menubar), file);
  g_signal_connect_swapped(open, "activate", G_CALLBACK(put_open), tm);
  g_signal_connect_swapped(quit, "activate", G_CALLBACK(gtk_neon_quit), tm);
  gtk_widget_add_accelerator(open, "activate", accel_group, GDK_KEY_o, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  //  gtk_widget_add_accelerator(save, "activate", accel_group, GDK_KEY_s, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  //  gtk_widget_add_accelerator(save_as, "activate", accel_group, GDK_KEY_a, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(quit, "activate", accel_group, GDK_KEY_q, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  /********************************* IMAGE MENU **********************************/
  menuimage = gtk_menu_new();
  image = gtk_menu_item_new_with_mnemonic("_Image");
  tm->tgtk->menu_prev = gtk_menu_item_new_with_mnemonic("_Previous");
  tm->tgtk->menu_next = gtk_menu_item_new_with_mnemonic("_Next");
  sep3 = gtk_separator_menu_item_new();
  normal = gtk_menu_item_new_with_mnemonic("Normal _Size");
  fit = gtk_menu_item_new_with_mnemonic("Fit to _Window");
  orig = gtk_menu_item_new_with_mnemonic("Original Image");
  sep4 = gtk_separator_menu_item_new();
  zoom_in = gtk_menu_item_new_with_mnemonic("Zoom _In");
  zoom_out = gtk_menu_item_new_with_mnemonic("Zoom _Out");
  sep5 = gtk_separator_menu_item_new();
  rotate_left = gtk_menu_item_new_with_mnemonic("Rotate _Left");
  rotate_right = gtk_menu_item_new_with_mnemonic("Rotate _Right");
  flip = gtk_menu_item_new_with_mnemonic("_Flip");
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(image), menuimage);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), tm->tgtk->menu_prev);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), tm->tgtk->menu_next);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), sep3);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), normal);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), fit);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), orig);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), sep4);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), zoom_in);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), zoom_out);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), sep5);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), rotate_left);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), rotate_right);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), flip);
  gtk_menu_shell_append(GTK_MENU_SHELL(tm->tgtk->menubar), image);
  g_signal_connect_swapped(tm->tgtk->menu_prev, "activate", G_CALLBACK(show_prev), tm);
  g_signal_connect_swapped(tm->tgtk->menu_next, "activate", G_CALLBACK(show_next), tm);
  g_signal_connect_swapped(normal, "activate", G_CALLBACK(load_orig_image), tm);
  g_signal_connect_swapped(fit, "activate", G_CALLBACK(fit_to_window), tm);
  g_signal_connect_swapped(orig, "activate", G_CALLBACK(load_orig_image), tm);
  g_signal_connect_swapped(zoom_in, "activate", G_CALLBACK(zoom_in_image), tm);
  g_signal_connect_swapped(zoom_out, "activate", G_CALLBACK(zoom_out_image), tm);
  g_signal_connect_swapped(rotate_left, "activate", G_CALLBACK(rotate_left_image), tm);
  g_signal_connect_swapped(rotate_right, "activate", G_CALLBACK(rotate_right_image), tm);
  g_signal_connect_swapped(flip, "activate", G_CALLBACK(flip_image), tm);
  gtk_widget_add_accelerator(tm->tgtk->menu_next, "activate", accel_group, GDK_KEY_n, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(tm->tgtk->menu_next, "activate", accel_group, GDK_KEY_space, 0, GTK_ACCEL_VISIBLE);

  gtk_widget_add_accelerator(tm->tgtk->menu_prev, "activate", accel_group, GDK_KEY_p, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(tm->tgtk->menu_prev, "activate", accel_group, GDK_KEY_BackSpace, 0, GTK_ACCEL_VISIBLE);

  gtk_widget_add_accelerator(normal, "activate", accel_group, GDK_KEY_z, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(fit, "activate", accel_group, GDK_KEY_x, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(orig, "activate", accel_group, GDK_KEY_m, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(zoom_in, "activate", accel_group, GDK_KEY_i, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(zoom_out, "activate", accel_group, GDK_KEY_o, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(rotate_left, "activate", accel_group, GDK_KEY_l, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(rotate_left, "activate", accel_group, GDK_KEY_Left, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(rotate_right, "activate", accel_group, GDK_KEY_r, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(rotate_right, "activate", accel_group, GDK_KEY_Right, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(flip, "activate", accel_group, GDK_KEY_f, 0, GTK_ACCEL_VISIBLE);

  /********************************* TOOLS MENU **********************************/
  menutools = gtk_menu_new();
  tools = gtk_menu_item_new_with_mnemonic("_Tools");
  show_toolbar = gtk_check_menu_item_new_with_mnemonic("T_oolbar");
  show_status = gtk_check_menu_item_new_with_mnemonic("Statu_s Bar");
  show_left_sidebar = gtk_check_menu_item_new_with_mnemonic("_Left Panel");
  show_right_sidebar = gtk_check_menu_item_new_with_mnemonic("_Right Panel");
  sep6 = gtk_separator_menu_item_new();
  settings = gtk_menu_item_new_with_mnemonic("Se_ttings");
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(tools), menutools);
  gtk_menu_shell_append(GTK_MENU_SHELL(menutools), show_toolbar);
  gtk_menu_shell_append(GTK_MENU_SHELL(menutools), show_status);
  gtk_menu_shell_append(GTK_MENU_SHELL(menutools), show_left_sidebar);
  gtk_menu_shell_append(GTK_MENU_SHELL(menutools), show_right_sidebar);
  gtk_menu_shell_append(GTK_MENU_SHELL(menutools), sep6);
  gtk_menu_shell_append(GTK_MENU_SHELL(menutools), settings);
  gtk_menu_shell_append(GTK_MENU_SHELL(tm->tgtk->menubar), tools);
  g_signal_connect(show_toolbar, "toggled", G_CALLBACK(toggle_toolbar), tm);
  g_signal_connect(show_status, "toggled", G_CALLBACK(toggle_status), tm);
  g_signal_connect(show_left_sidebar, "toggled", G_CALLBACK(toggle_left_sidebar), tm);
  g_signal_connect(show_right_sidebar, "toggled", G_CALLBACK(toggle_right_sidebar), tm);
  g_signal_connect_swapped(settings, "activate", G_CALLBACK(put_settings), tm);
  gtk_widget_add_accelerator(settings, "activate", accel_group, GDK_KEY_t, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  /********************************* HELP MENU ***********************************/
  menuhelp = gtk_menu_new();
  help = gtk_menu_item_new_with_mnemonic("_Help");
  manual = gtk_menu_item_new_with_mnemonic("_Manual");
  faq = gtk_menu_item_new_with_mnemonic("_FAQ");
  sep6a = gtk_separator_menu_item_new();
  homepage = gtk_menu_item_new_with_mnemonic("_Homepage");
  sep7 = gtk_separator_menu_item_new();
  about = gtk_menu_item_new_with_mnemonic("_About");
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(help), menuhelp);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuhelp), manual);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuhelp), faq);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuhelp), sep6a);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuhelp), homepage);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuhelp), sep7);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuhelp), about);
  gtk_menu_shell_append(GTK_MENU_SHELL(tm->tgtk->menubar), help);
  gtk_widget_add_accelerator(manual, "activate", accel_group, GDK_KEY_F1, 0, GTK_ACCEL_VISIBLE);
  g_signal_connect(manual, "activate", G_CALLBACK(put_manual), NULL);
  g_signal_connect(faq, "activate", G_CALLBACK(put_faq), NULL);
  g_signal_connect(homepage, "activate", G_CALLBACK(put_homepage), NULL);
  g_signal_connect(about, "activate", G_CALLBACK(put_about), NULL);

  /*******************************************************************************/
  if (strcmp(tm->tcfg->show_toolbar, "yes") == 0) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(show_toolbar), TRUE);
    gtk_widget_show_all(tm->tgtk->toolbar);
  }
  if (strcmp(tm->tcfg->show_status, "yes") == 0) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(show_status), TRUE);
    gtk_widget_show_all(tm->tgtk->grid14);
  }
  if (strcmp(tm->tcfg->show_left_sidebar, "yes") == 0) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(show_left_sidebar), TRUE);
  }
  if (strcmp(tm->tcfg->show_right_sidebar, "yes") == 0) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(show_right_sidebar), TRUE);
  }

  /*******************************************************************************/
  gtk_widget_set_hexpand(tm->tgtk->menubar, TRUE);
  gtk_grid_attach(GTK_GRID(tm->tgtk->grid11), tm->tgtk->menubar, 0, 0, 1, 1);
  gtk_widget_show_all(tm->tgtk->menubar);
}

void put_toolbar (TM *tm) {
  GtkToolItem *open, *sep1, *sep3, *normal, *fit, *sep3a,
    *zoom_in, *zoom_out, *sep4, *settings, *sep5, *about;
  //  GtkToolItem *save, *save_as;

  tm->tgtk->toolbar = gtk_toolbar_new();
  gtk_toolbar_set_style(GTK_TOOLBAR(tm->tgtk->toolbar), GTK_TOOLBAR_ICONS);

  open = gtk_tool_button_new_from_stock(GTK_STOCK_OPEN);
  gtk_tool_item_set_tooltip_text(open, "Open Image");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), open, -1);
  g_signal_connect_swapped(open, "clicked", G_CALLBACK(put_open), tm);

  sep1 = gtk_separator_tool_item_new();
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), sep1, -1);
  /*
  save = gtk_tool_button_new_from_stock(GTK_STOCK_SAVE);
  gtk_tool_item_set_tooltip_text(save, "Save");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), save, -1);

  save_as = gtk_tool_button_new_from_stock(GTK_STOCK_SAVE_AS);
  gtk_tool_item_set_tooltip_text(save_as, "Save As...");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), save_as, -1);

  sep2 = gtk_separator_tool_item_new();
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), sep2, -1);
  */
  tm->tgtk->prev = gtk_tool_button_new_from_stock(GTK_STOCK_GO_BACK);
  gtk_tool_item_set_tooltip_text(tm->tgtk->prev, "Previous Image");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), tm->tgtk->prev, -1);
  g_signal_connect_swapped(tm->tgtk->prev, "clicked", G_CALLBACK(show_prev), tm);

  tm->tgtk->next = gtk_tool_button_new_from_stock(GTK_STOCK_GO_FORWARD);
  gtk_tool_item_set_tooltip_text(tm->tgtk->next, "Next Image");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), tm->tgtk->next, -1);
  g_signal_connect_swapped(tm->tgtk->next, "clicked", G_CALLBACK(show_next), tm);

  sep3 = gtk_separator_tool_item_new();
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), sep3, -1);

  normal = gtk_tool_button_new_from_stock(GTK_STOCK_ZOOM_100);
  gtk_tool_item_set_tooltip_text(normal, "Normal Size");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), normal, -1);
  g_signal_connect_swapped(normal, "clicked", G_CALLBACK(load_orig_image), tm);

  fit = gtk_tool_button_new_from_stock(GTK_STOCK_ZOOM_FIT);
  gtk_tool_item_set_tooltip_text(fit, "Fit to Window");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), fit, -1);
  g_signal_connect_swapped(fit, "clicked", G_CALLBACK(fit_to_window), tm);

  sep3a = gtk_separator_tool_item_new();
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), sep3a, -1);

  zoom_in = gtk_tool_button_new_from_stock(GTK_STOCK_ZOOM_IN);
  gtk_tool_item_set_tooltip_text(zoom_in, "Zoom In");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), zoom_in, -1);
  g_signal_connect_swapped(zoom_in, "clicked", G_CALLBACK(zoom_in_image), tm);

  zoom_out = gtk_tool_button_new_from_stock(GTK_STOCK_ZOOM_OUT);
  gtk_tool_item_set_tooltip_text(zoom_out, "Zoom Out");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), zoom_out, -1);
  g_signal_connect_swapped(zoom_out, "clicked", G_CALLBACK(zoom_out_image), tm);

  sep4 = gtk_separator_tool_item_new();
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), sep4, -1);

  settings = gtk_tool_button_new_from_stock(GTK_STOCK_PREFERENCES);
  gtk_tool_item_set_tooltip_text(settings, "Settings");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), settings, -1);
  g_signal_connect_swapped(settings, "clicked", G_CALLBACK(put_settings), tm);

  sep5 = gtk_separator_tool_item_new();
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), sep5, -1);

  about = gtk_tool_button_new_from_stock(GTK_STOCK_ABOUT);
  gtk_tool_item_set_tooltip_text(about, "About NeonView");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->tgtk->toolbar), about, -1);
  g_signal_connect_swapped(about, "clicked", G_CALLBACK(put_about), tm);

  gtk_widget_set_hexpand(tm->tgtk->toolbar, TRUE);
  gtk_grid_attach(GTK_GRID(tm->tgtk->grid12), tm->tgtk->toolbar, 0, 0, 1, 1);
  //  gtk_widget_show_all(tm->tgtk->toolbar);
}

void put_scrolled (TM *tm) {
  tm->tgtk->scrolled = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_hexpand(tm->tgtk->scrolled, TRUE);
  gtk_widget_set_vexpand(tm->tgtk->scrolled, TRUE);

  gtk_grid_attach(GTK_GRID(tm->tgtk->grid13b), tm->tgtk->scrolled, 0, 0, 1, 1);
  gtk_widget_show(tm->tgtk->scrolled);
}

void put_left_sidebar (TM *tm) {
  GtkWidget *grid1;
  GtkWidget *label1;

  if (tm->tgtk->notebook1 != NULL) {
    gtk_widget_destroy(tm->tgtk->notebook1);
  }

  tm->tgtk->notebook1 = gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(tm->tgtk->notebook1), GTK_POS_TOP);
  gtk_widget_set_vexpand(tm->tgtk->notebook1, TRUE);
  gtk_widget_set_size_request(tm->tgtk->notebook1, 142, 0);

  grid1 = gtk_grid_new();
  label1 = gtk_label_new("Thumbs");
  gtk_notebook_append_page(GTK_NOTEBOOK(tm->tgtk->notebook1), grid1, label1);
  /**********/
  GdkPixbuf **pixbuf;
  GtkWidget **image, *scrolled, *grid;

  scrolled = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_vexpand(scrolled, TRUE);
  gtk_widget_set_size_request(scrolled, 142, 0);
  grid = gtk_grid_new();

  pixbuf = malloc(tm->tnfo->total * sizeof(GdkPixbuf *));
  image = malloc(tm->tnfo->total * sizeof(GtkImage *));
  tm->tgtk->button = malloc(tm->tnfo->total * sizeof(GtkWidget *));

  for (tm->tnfo->it = 0; tm->tnfo->it < tm->tnfo->total; tm->tnfo->it++) {
    pixbuf[tm->tnfo->it] = gdk_pixbuf_new_from_file_at_size(tm->tnfo->image_list[tm->tnfo->it], 100, 100, NULL);
    image[tm->tnfo->it] = gtk_image_new_from_pixbuf(pixbuf[tm->tnfo->it]);
    tm->tgtk->button[tm->tnfo->it] = gtk_button_new();
    gtk_container_add(GTK_CONTAINER(tm->tgtk->button[tm->tnfo->it]), image[tm->tnfo->it]);
    gtk_grid_attach(GTK_GRID(grid), tm->tgtk->button[tm->tnfo->it], 0, tm->tnfo->it, 1, 1);
    g_signal_connect_swapped(tm->tgtk->button[tm->tnfo->it], "clicked", G_CALLBACK(thumb_show), tm);
  }
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled), grid);
  gtk_grid_attach(GTK_GRID(grid1), scrolled, 0, 0, 1, 1);

  gtk_grid_attach(GTK_GRID(tm->tgtk->grid13a), tm->tgtk->notebook1, 0, 0, 1, 1);
}

void put_right_sidebar (TM *tm) {
  GtkWidget *grid1;
  GtkWidget *label1;

  tm->tgtk->notebook2 = gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(tm->tgtk->notebook2), GTK_POS_TOP);
  gtk_widget_set_vexpand(tm->tgtk->notebook2, TRUE);
  gtk_widget_set_size_request(tm->tgtk->notebook2, 142, 0);

  grid1 = gtk_grid_new();
  label1 = gtk_label_new("Info");
  gtk_notebook_append_page(GTK_NOTEBOOK(tm->tgtk->notebook2), grid1, label1);

  GtkWidget *subtitle1, *subtitle2, *subtitle3, *subtitle4;

  subtitle1 = gtk_label_new("Filename");
  subtitle2 = gtk_label_new("Resolution");
  subtitle3 = gtk_label_new("Size");
  subtitle4 = gtk_label_new("Path");

  char *markup;

  markup = g_markup_printf_escaped("<b>%s</b>", "Filename");
  gtk_label_set_markup(GTK_LABEL(subtitle1), markup);
  gtk_misc_set_alignment(GTK_MISC(subtitle1), 0, 0);

  markup = g_markup_printf_escaped("<b>%s</b>", "Image Size");
  gtk_label_set_markup(GTK_LABEL(subtitle2), markup);
  gtk_misc_set_alignment(GTK_MISC(subtitle2), 0, 0);

  markup = g_markup_printf_escaped("<b>%s</b>", "File Size");
  gtk_label_set_markup(GTK_LABEL(subtitle3), markup);
  gtk_misc_set_alignment(GTK_MISC(subtitle3), 0, 0);

  markup = g_markup_printf_escaped("<b>%s</b>", "Path");
  gtk_label_set_markup(GTK_LABEL(subtitle4), markup);
  gtk_misc_set_alignment(GTK_MISC(subtitle4), 0, 0);

  tm->tgtk->entry21 = gtk_entry_new();
  tm->tgtk->entry22 = gtk_entry_new();
  tm->tgtk->entry23 = gtk_entry_new();
  tm->tgtk->entry24 = gtk_entry_new();

  gtk_entry_set_width_chars(GTK_ENTRY(tm->tgtk->entry21), 15);
  gtk_editable_set_editable(GTK_EDITABLE(tm->tgtk->entry21), FALSE);
  gtk_entry_set_width_chars(GTK_ENTRY(tm->tgtk->entry22), 15);
  gtk_editable_set_editable(GTK_EDITABLE(tm->tgtk->entry22), FALSE);
  gtk_entry_set_width_chars(GTK_ENTRY(tm->tgtk->entry23), 15);
  gtk_editable_set_editable(GTK_EDITABLE(tm->tgtk->entry23), FALSE);
  gtk_entry_set_width_chars(GTK_ENTRY(tm->tgtk->entry24), 15);
  gtk_editable_set_editable(GTK_EDITABLE(tm->tgtk->entry24), FALSE);

  gtk_widget_set_margin_top(subtitle1, 10);
  gtk_widget_set_margin_top(subtitle2, 10);
  gtk_widget_set_margin_top(subtitle3, 10);
  gtk_widget_set_margin_top(subtitle4, 10);

  gtk_grid_attach(GTK_GRID(grid1), subtitle1, 0, 0, 1, 1);
  gtk_grid_attach(GTK_GRID(grid1), tm->tgtk->entry21, 0, 1, 1, 1);
  gtk_grid_attach(GTK_GRID(grid1), subtitle2, 0, 2, 1, 1);
  gtk_grid_attach(GTK_GRID(grid1), tm->tgtk->entry22, 0, 3, 1, 1);
  gtk_grid_attach(GTK_GRID(grid1), subtitle3, 0, 4, 1, 1);
  gtk_grid_attach(GTK_GRID(grid1), tm->tgtk->entry23, 0, 5, 1, 1);
  gtk_grid_attach(GTK_GRID(grid1), subtitle4, 0, 6, 1, 1);
  gtk_grid_attach(GTK_GRID(grid1), tm->tgtk->entry24, 0, 7, 1, 1);

  if (tm->tgtk->pixbuf != NULL) {
    fill_right_sidebar(tm);
  }

  gtk_grid_attach(GTK_GRID(tm->tgtk->grid13c), tm->tgtk->notebook2, 0, 0, 1, 1);
}

void destroy_status (TM *tm) {
  if (tm->tgtk->status1 != NULL) {
    gtk_widget_destroy(tm->tgtk->status1);
  }
  if (tm->tgtk->status2 != NULL) {
    gtk_widget_destroy(tm->tgtk->status2);
  }
  if (tm->tgtk->status3 != NULL) {
    gtk_widget_destroy(tm->tgtk->status3);
  }
  if (tm->tgtk->status4 != NULL) {
    gtk_widget_destroy(tm->tgtk->status4);
  }
}

void put_status (TM *tm) {
  destroy_status(tm);
  if (tm->tgtk->pixbuf == NULL && tm->tgtk->animation == NULL) {
    tm->tgtk->status1 = gtk_label_new("No image loaded");
    tm->tgtk->status2 = gtk_label_new(NULL);
    tm->tgtk->status3 = gtk_label_new(NULL);
    tm->tgtk->status4 = gtk_label_new(NULL);

    gtk_grid_attach(GTK_GRID(tm->tgtk->grid14), tm->tgtk->status1, 0, 0, 1, 1);
    gtk_grid_attach(GTK_GRID(tm->tgtk->grid14), tm->tgtk->status2, 1, 0, 1, 1);
    gtk_grid_attach(GTK_GRID(tm->tgtk->grid14), tm->tgtk->status3, 2, 0, 1, 1);
    gtk_grid_attach(GTK_GRID(tm->tgtk->grid14), tm->tgtk->status4, 3, 0, 1, 1);

    if (strcmp(tm->tcfg->show_status, "yes") == 0) {
      gtk_widget_show_all(tm->tgtk->grid14);
    }
    return;
  }

  //title
  int i;
  char tmp[31];

  if (strlen(tm->tnfo->image_list_basename[tm->tnfo->pos]) > 30) {
    for (i = 0; i < 30; i++) {
      tmp[i] = tm->tnfo->image_list_basename[tm->tnfo->pos][i];
    }
    tmp[i] = '\0';
    tm->tgtk->status1 = gtk_label_new(tmp);
  } else {
    tm->tgtk->status1 = gtk_label_new(tm->tnfo->image_list_basename[tm->tnfo->pos]);
  }
  gtk_widget_set_size_request(tm->tgtk->status1, 220, 0);
  gtk_misc_set_alignment(GTK_MISC(tm->tgtk->status1), 0, 0);
  // resolution
  char width[digits(tm->tnfo->image_width) + 1];
  char height[digits(tm->tnfo->image_height) + 1];
  char str[sizeof(width) + sizeof(height)]; // should be -1, but 'x' gets a char too
  if (GDK_IS_PIXBUF(tm->tgtk->pixbuf)) {
    sprintf(width, "%d", tm->tnfo->image_width);
    sprintf(height, "%d", tm->tnfo->image_height);
    strcpy(str, width);
    strcat(str, "x");
    strcat(str, height);
  } else {
    strcpy(str, "0x0");
  }
  tm->tgtk->status2 = gtk_label_new(str);
  gtk_widget_set_size_request(tm->tgtk->status2, 100, 0);
  gtk_misc_set_alignment(GTK_MISC(tm->tgtk->status2), 0, 0);
  // size
  long size, mb = 0, kb = 0, bytes = 0;
  float newsize;
  size = filesize(tm->tnfo->image_list[tm->tnfo->pos]);
  if (size > 1024 * 1024) { // > 1MB
    newsize = size / (1024.0 * 1024.0);
    mb = 1;
  } else {
    if (size > 1024) { // > 1KB
      newsize = size / 1024.0;
      kb = 1;
    } else {
      newsize = size;
      bytes = 1;
    }
  }
  sprintf(str, "%.2f", newsize);
  if (mb == 1) { strcat(str, " MB"); }
  if (kb == 1) { strcat(str, " KB"); }
  if (bytes == 1) { strcat(str, " bytes"); }
  if (newsize == 0) { strcpy(str, "0 bytes"); }
  tm->tgtk->status3 = gtk_label_new(str);
  gtk_widget_set_size_request(tm->tgtk->status3, 100, 0);
  gtk_misc_set_alignment(GTK_MISC(tm->tgtk->status3), 0, 0);
  // path
  if (strlen(tm->tnfo->image_dirname) > 24) {
    for (i = 0; i < 24; i++) {
      tmp[i] = tm->tnfo->image_dirname[i];
    }
    tmp[i] = '\0';
    tm->tgtk->status4 = gtk_label_new(tmp);
  } else {
    tm->tgtk->status4 = gtk_label_new(tm->tnfo->image_dirname);
  }
  gtk_widget_set_size_request(tm->tgtk->status4, 100, 0);
  gtk_misc_set_alignment(GTK_MISC(tm->tgtk->status4), 0, 0);

  gtk_grid_attach(GTK_GRID(tm->tgtk->grid14), tm->tgtk->status1, 0, 0, 1, 1);
  gtk_grid_attach(GTK_GRID(tm->tgtk->grid14), tm->tgtk->status2, 1, 0, 1, 1);
  gtk_grid_attach(GTK_GRID(tm->tgtk->grid14), tm->tgtk->status3, 2, 0, 1, 1);
  gtk_grid_attach(GTK_GRID(tm->tgtk->grid14), tm->tgtk->status4, 3, 0, 1, 1);

  if (strcmp(tm->tcfg->show_status, "yes") == 0) {
    gtk_widget_show_all(tm->tgtk->grid14);
  }
}

void toggle_toolbar (GtkWidget *widget, TM *tm) {
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(widget)) == TRUE) {
    gtk_widget_show_all(tm->tgtk->toolbar);
    strcpy(tm->tcfg->show_toolbar, "yes");
  } else {
    gtk_widget_hide(tm->tgtk->toolbar);
    strcpy(tm->tcfg->show_toolbar, "no");
  }
}

void toggle_status (GtkWidget *widget, TM *tm) {
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(widget)) == TRUE) {
    gtk_widget_show_all(tm->tgtk->grid14);
    strcpy(tm->tcfg->show_status, "yes");
  } else {
    gtk_widget_hide(tm->tgtk->grid14);
    strcpy(tm->tcfg->show_status, "no");
  }
}

void toggle_left_sidebar (GtkWidget *widget, TM *tm) {
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(widget)) == TRUE) {
    gtk_widget_show_all(tm->tgtk->grid13a);
    strcpy(tm->tcfg->show_left_sidebar, "yes");
  } else {
    gtk_widget_hide(tm->tgtk->grid13a);
    strcpy(tm->tcfg->show_left_sidebar, "no");
  }
}

void toggle_right_sidebar (GtkWidget *widget, TM *tm) {
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(widget)) == TRUE) {
    gtk_widget_show_all(tm->tgtk->grid13c);
    strcpy(tm->tcfg->show_right_sidebar, "yes");
  } else {
    gtk_widget_hide(tm->tgtk->grid13c);
    strcpy(tm->tcfg->show_right_sidebar, "no");
  }
}
