/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

void get_dirname (TM *tm, char *str) {
  if (str == NULL) {
    tm->img->image_dirname = malloc(strlen(tm->env->cwd) + 2);
    if (!tm->img->image_dirname) {
      criterr(0);
    }
    strcpy(tm->img->image_dirname, tm->env->cwd);
    strcat(tm->img->image_dirname, "/");
    return;
  }

  if (strlen(str) > 4096) {
    return;
  }

  int i, count, stop;
  char dirname[strlen(str) + 1];
  char basename[strlen(str) + 1];
  char tmp[strlen(str) + 1];

  i = strlen(str) - 1;
  stop = 0;
  count = 0;
  while (i >= 0 && stop == 0) {
    if (str[i] != '/') {
      tmp[count] = str[i];
      count++;
    } else {
      stop = 1;
    }
    i--;
  }
  tmp[count] = '\0';
  rts(tmp);
  strcpy(basename, tmp);

  i = 0;
  while (i < strlen(str) - count) {
    dirname[i] = str[i];
    i++;
  }
  dirname[i] = '\0';

  if (strcmp(basename, "..") == 0) {
    strcat(dirname, basename);
    strcat(dirname, "/");
    memset(basename, '\0', sizeof(basename));
  }

  int rv;
  struct stat st;

  rv = stat(tm->argv[1], &st);
  if (rv) {
    fprintf(stdout, "[NeonView] %s is not a valid file or directory.\n", tm->argv[1]);
  }
  if (S_ISDIR(st.st_mode)) {
    strcat(dirname, basename);
    strcat(dirname, "/");
    memset(basename, '\0', sizeof(basename));
  }

  printf("dirname = %s basename = %s\n", dirname, basename);

  if (dirname[0] != '/') {
    tm->img->image_dirname = malloc(strlen(tm->env->cwd) + strlen(dirname) + 2);
    if (!tm->img->image_dirname) {
      criterr(0);
    }
    strcpy(tm->img->image_dirname, tm->env->cwd);
    strcat(tm->img->image_dirname, "/");
    strcat(tm->img->image_dirname, dirname);
  } else {
    tm->img->image_dirname = malloc(strlen(dirname) + 1);
    if (!tm->img->image_dirname) {
      criterr(0);
    }
    strcpy(tm->img->image_dirname, dirname);
  }
  tm->img->image_basename = malloc(strlen(basename) + 1);
  if (!tm->img->image_basename) {
    criterr(0);
  }
  strcpy(tm->img->image_basename, basename);

  tm->img->image_full_path = malloc(strlen(tm->img->image_dirname) + strlen(tm->img->image_basename) + 1);
  if (!tm->img->image_full_path) {
    criterr(0);
  }
  strcpy(tm->img->image_full_path, tm->img->image_dirname);
  strcat(tm->img->image_full_path, tm->img->image_basename);
}

void fill_image_list (TM *tm) {
  DIR *dir;
  struct dirent *ent;

  if (tm->img->image_dirname == NULL) {
    return;
  }

  dir = opendir(tm->img->image_dirname);
  if (!dir) {
    criterr(2);
    return;
  }

  tm->img->total = 0;
  while ((ent = readdir(dir)) != NULL) {
    if (check_extension(tm, ent->d_name) > 0) {
      tm->img->total++;
    }
  }

  closedir(dir);

  tm->img->ls = malloc(tm->img->total * sizeof(LS));
  if (!tm->img->ls) {
    criterr(0);
  }

  int i;

  for (i = 0; i < tm->img->total; i++) {
    tm->img->ls[i] = malloc(sizeof(LS));
    if (!tm->img->ls[i]) {
      criterr(0);
    }
  }

  dir = opendir(tm->img->image_dirname);
  if (!dir) {
    criterr(2);
    return;
  }

  i = 0;
  while ((ent = readdir(dir)) != NULL) {
    if (check_extension(tm, ent->d_name) > 0) {
      // full_path
      tm->img->ls[i]->full_path = malloc(strlen(tm->img->image_dirname) + strlen(ent->d_name) + 1);
      if (!tm->img->ls[i]->full_path) {
	criterr(0);
      }
      strcpy(tm->img->ls[i]->full_path, tm->img->image_dirname);
      strcat(tm->img->ls[i]->full_path, ent->d_name);
      // basename
      if (strcmp(ent->d_name, ".") == 0 || strcmp(ent->d_name, "..") == 0) {
	tm->img->ls[i]->basename = malloc(1);
	if (!tm->img->ls[i]->basename) {
	  criterr(0);
	}
	tm->img->ls[i]->basename[0] = '\0';
      } else {
	tm->img->ls[i]->basename = malloc(strlen(ent->d_name) + 1);
	if (!tm->img->ls[i]->basename) {
	  criterr(0);
	}
	strcpy(tm->img->ls[i]->basename, ent->d_name);
      }
      // type
      memset(tm->img->ls[i]->type, '\0', sizeof(tm->img->ls[i]->type));
      strcpy(tm->img->ls[i]->type, tm->img->type);
      i++;
    }
  }
  closedir(dir);
}

void print_image_list (TM *tm) {
  int i;

  for (i = 0; i < tm->img->total; i++) {
    fprintf(stdout, "tm->img->ls[%2d]->full_path = %s  ", i, tm->img->ls[i]->full_path);
    fprintf(stdout, "tm->img->ls[%2d]->basename = %s  ", i, tm->img->ls[i]->basename);
    fprintf(stdout, "tm->img->ls[%2d]->type = %s\n", i, tm->img->ls[i]->type);
  }
}

void print_all (TM *tm) {
  print_image_list(tm);
  fprintf(stdout, "tm->gtk->pixbuf = %p\n", (void*)tm->gtk->pixbuf);
  fprintf(stdout, "tm->img->image_dirname = %s\n", tm->img->image_dirname);
  fprintf(stdout, "tm->img->image_basename = %s\n", tm->img->image_basename);
  fprintf(stdout, "tm->img->image_full_path = %s\n", tm->img->image_full_path);
  fprintf(stdout, "tm->img->total = %d\n", tm->img->total);
  fprintf(stdout, "tm->img->pos = %d\n", tm->img->pos);
}

void sort_list_by_name (TM *tm) {
  int i, j, remaining = 0;
  char *tmp1, *tmp2, tmp3[6];
  char *case1, *case2;

  for (i = remaining; i < tm->img->total - 1; i++) {
    for (j = remaining + 1; j < tm->img->total; j++) {
      case1 = malloc(strlen(tm->img->ls[i]->basename) + 1);
      case2 = malloc(strlen(tm->img->ls[j]->basename) + 1);
      if (!case1 || !case2) {
	criterr(0);
      }
      strcpy(case1, tm->img->ls[i]->basename);
      strcpy(case2, tm->img->ls[j]->basename);
      lc(case1);
      lc(case2);
      //      if (strcasecmp(tm->img->ls[i]->basename, tm->img->ls[j]->basename) > 0) {
      if (strcmp(case1, case2) > 0) {
	tmp1 = malloc(strlen(tm->img->ls[i]->basename) + 1);
	tmp2 = malloc(strlen(tm->img->ls[i]->full_path) + 1);
	if (!tm->img->ls[i]->basename || !tm->img->ls[i]->full_path) {
	  criterr(0);
	}
	strcpy(tmp1, tm->img->ls[i]->basename);
	strcpy(tmp2, tm->img->ls[i]->full_path);
	strcpy(tmp3, tm->img->ls[i]->type);
	tm->img->ls[i]->basename = malloc(strlen(tm->img->ls[j]->basename) + 1);
	tm->img->ls[i]->full_path = malloc(strlen(tm->img->ls[j]->full_path) + 1);
	if (!tm->img->ls[i]->basename || !tm->img->ls[i]->full_path) {
	  criterr(0);
	}
	strcpy(tm->img->ls[i]->basename, tm->img->ls[j]->basename);
	strcpy(tm->img->ls[i]->full_path, tm->img->ls[j]->full_path);
	strcpy(tm->img->ls[i]->type, tm->img->ls[j]->type);
	tm->img->ls[j]->basename = malloc(strlen(tmp1) + 1);
	tm->img->ls[j]->full_path = malloc(strlen(tmp2) + 1);
	if (!tm->img->ls[j]->basename || !tm->img->ls[j]->full_path) {
	  criterr(0);
	}
	strcpy(tm->img->ls[j]->basename, tmp1);
	strcpy(tm->img->ls[j]->full_path, tmp2);
	strcpy(tm->img->ls[j]->type, tmp3);
      }
    }
    remaining++;
  }
}

void get_position (TM *tm, char *str) {
  int i, stop = 0, rv;
  struct stat st;

  tm->img->pos = 0;

  rv = stat(str, &st);
  if (rv) {
    return;
  }
  if (S_ISREG(st.st_mode)) {
    for (i = 0; i < tm->img->total && stop == 0; i++) {
      if (strstr(tm->img->ls[i]->full_path, str)) {
	tm->img->pos = i;
	stop = 1;
      }
    }
  }
  if (S_ISDIR(st.st_mode)) {
    fprintf(stdout, "[NeonView] %s is a directory, not a file.\n", str);
  }
}
