/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

void put_toolbar (TM *tm) {
  GtkToolItem *open, *sep1, *sep2, *sep3, *sep4, *settings, *sep5, *about;

  if (tm->gtk->toolbar != NULL) {
    gtk_widget_destroy(tm->gtk->toolbar);
  }

  tm->gtk->toolbar = gtk_toolbar_new();
  gtk_toolbar_set_style(GTK_TOOLBAR(tm->gtk->toolbar), GTK_TOOLBAR_ICONS);

  open = gtk_tool_button_new_from_stock(GTK_STOCK_OPEN);
  gtk_tool_item_set_tooltip_text(GTK_TOOL_ITEM(open), "Open Image");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), open, -1);
  g_signal_connect_swapped(open, "clicked", G_CALLBACK(put_open), tm);
  sep1 = gtk_separator_tool_item_new();
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), sep1, -1);
  tm->gtk->tool_prev = gtk_tool_button_new_from_stock(GTK_STOCK_GO_BACK);
  gtk_tool_item_set_tooltip_text(GTK_TOOL_ITEM(tm->gtk->tool_prev), "Previous Image");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), tm->gtk->tool_prev, -1);
  tm->gtk->tool_next = gtk_tool_button_new_from_stock(GTK_STOCK_GO_FORWARD);
  gtk_tool_item_set_tooltip_text(GTK_TOOL_ITEM(tm->gtk->tool_next), "Next Image");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), tm->gtk->tool_next, -1);
  sep2 = gtk_separator_tool_item_new();
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), sep2, -1);
  tm->gtk->tool_orig = gtk_tool_button_new_from_stock(GTK_STOCK_ZOOM_100);
  gtk_tool_item_set_tooltip_text(GTK_TOOL_ITEM(tm->gtk->tool_orig), "Original Image");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), tm->gtk->tool_orig, -1);
  tm->gtk->tool_fit = gtk_tool_button_new_from_stock(GTK_STOCK_ZOOM_FIT);
  gtk_tool_item_set_tooltip_text(GTK_TOOL_ITEM(tm->gtk->tool_fit), "Fit to Window");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), tm->gtk->tool_fit, -1);
  sep3 = gtk_separator_tool_item_new();
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), sep3, -1);
  tm->gtk->tool_zoom_out = gtk_tool_button_new_from_stock(GTK_STOCK_ZOOM_OUT);
  gtk_tool_item_set_tooltip_text(GTK_TOOL_ITEM(tm->gtk->tool_zoom_out), "Zoom Out");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), tm->gtk->tool_zoom_out, -1);
  tm->gtk->tool_zoom_in = gtk_tool_button_new_from_stock(GTK_STOCK_ZOOM_IN);
  gtk_tool_item_set_tooltip_text(GTK_TOOL_ITEM(tm->gtk->tool_zoom_in), "Zoom In");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), tm->gtk->tool_zoom_in, -1);
  sep4 = gtk_separator_tool_item_new();
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), sep4, -1);
  settings = gtk_tool_button_new_from_stock(GTK_STOCK_PREFERENCES);
  gtk_tool_item_set_tooltip_text(GTK_TOOL_ITEM(settings), "Settings");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), settings, -1);
  sep5 = gtk_separator_tool_item_new();
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), sep5, -1);
  about = gtk_tool_button_new_from_stock(GTK_STOCK_ABOUT);
  gtk_tool_item_set_tooltip_text(GTK_TOOL_ITEM(about), "About NeonView");
  gtk_toolbar_insert(GTK_TOOLBAR(tm->gtk->toolbar), about, -1);

  g_signal_connect_swapped(tm->gtk->tool_prev, "clicked", G_CALLBACK(show_prev), tm);
  g_signal_connect_swapped(tm->gtk->tool_next, "clicked", G_CALLBACK(show_next), tm);
  g_signal_connect_swapped(tm->gtk->tool_fit, "clicked", G_CALLBACK(fit_to_window), tm);
  g_signal_connect_swapped(tm->gtk->tool_orig, "clicked", G_CALLBACK(orig), tm);
  g_signal_connect_swapped(tm->gtk->tool_zoom_in, "clicked", G_CALLBACK(zoom_in), tm);
  g_signal_connect_swapped(tm->gtk->tool_zoom_out, "clicked", G_CALLBACK(zoom_out), tm);
  g_signal_connect_swapped(settings, "clicked", G_CALLBACK(put_settings), tm);
  g_signal_connect(about, "clicked", G_CALLBACK(put_about), NULL);

  gtk_widget_set_hexpand(tm->gtk->toolbar, TRUE);
  gtk_grid_attach(GTK_GRID(tm->gtk->grid12), tm->gtk->toolbar, 0, 0, 1, 1);

  if (strcmp(tm->cfg->show_toolbar, "yes") == 0) {
    gtk_widget_show_all(tm->gtk->toolbar);
  } else {
    gtk_widget_hide(tm->gtk->toolbar);
  }
}
