/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

// convert a string to lowercase, modifies argument
char *lc (char *str) {
  int i;

  for (i = 0; i < strlen(str); i++) {
    if (str[i] >= 65 && str[i] <= 92) {
      str[i] = str[i] + 32;
    }
  }
  return str;
}

// convert a string to uppercase, modifies argument
char *uc (char *str) {
  int i;
  for (i = 0; i < strlen(str); i++) {
    if (str[i] >= 97 && str[i] <= 124) {
      str[i] = str[i] - 32;
    }
  }
  return str;
}

// reverse string, modifies argument
char *rts (char *str) {
  int len, i;
  char tmp;

  len = strlen(str) - 1;
  for (i = 0; i < strlen(str) / 2; i++) {
    tmp = str[len];
    str[len] = str[i];
    str[i] = tmp;
    len--;
  }

  return str;
}

// remove spaces, tabs and double-quotes in a string, modifies argument
char *strip (char *str) {
  char tmp[strlen(str) + 1];
  int i, j;

  j = 0;
  for (i = 0; i < strlen(str); i++) {
    if (str[i] != ' ' && str[i] != '\t' && str[i] != '"') {
      tmp[j] = str[i];
      j++;
    }
  }
  tmp[j] = '\0';
  strcpy(str, tmp);

  return str;
}

// return 0 if a string contains only digits, 1 otherwise
int all_digits (char *str) {
  int i;

  for (i = 0; i < strlen(str); i++) {
    if (str[i] < 48 || str[i] > 57) {
      return 1;
    }
  }

  return 0;
}

// count digits in an integer
int digits (int n) {
  int digits;

  if (n == 0) {
    return 1;
  }

  digits = 0;
  while (n > 0) {
    n = n / 10;
    digits++;
  }

  return digits;
}

// return size of a file in bytes
long filesize (char *str) {
  FILE *file;
  long filesize;

  file = fopen(str, "rb");
  if (!file) {
    return -1;
  }
  fseek(file, 0, SEEK_END);
  filesize = ftell(file);
  fclose(file);

  return filesize;
}

// check if a file exists and can be opened for reading
int rfile (char *str) {
  if (access(str, R_OK) == 0) {
    return 1; // all OK
  } else {
    return 0;
  }

  return -1;
}

int xfile (char *str) {
  if (access(str, X_OK) == 0) {
    return 1;
  } else {
    return 0;
  }

  return -1;
}
