/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

void put_status (TM *tm) {
  destroy_status(tm);
  /*
  if (!tm->gtk->pixbuf && !tm->gtk->animation) {
    tm->gtk->status1 = gtk_label_new("No image loaded");
    gtk_grid_attach(GTK_GRID(tm->gtk->grid14), tm->gtk->status1, 0, 0, 1, 1);
    if (strcmp(tm->cfg->show_status, "yes") == 0) {
      gtk_widget_show_all(tm->gtk->grid14);
    }
    return;
  }
  */
  if (tm->img->total == 0) {
    tm->gtk->status1 = gtk_label_new("No image loaded");
    gtk_grid_attach(GTK_GRID(tm->gtk->grid14), tm->gtk->status1, 0, 0, 1, 1);
    if (strcmp(tm->cfg->show_status, "yes") == 0) {
      gtk_widget_show_all(tm->gtk->grid14);
    }
    return;
  }
  // title
  int i;
  char tmp[31];

  if (strlen(tm->img->ls[tm->img->pos]->basename) > 30) {
    for (i = 0; i < 30; i++) {
      tmp[i] = tm->img->ls[tm->img->pos]->basename[i];
    }
    tmp[i] = '\0';
    tm->gtk->status1 = gtk_label_new(tmp);
    gtk_entry_set_text(GTK_ENTRY(tm->gtk->entry21), tmp);
  } else {
    tm->gtk->status1 = gtk_label_new(tm->img->ls[tm->img->pos]->basename);
    gtk_entry_set_text(GTK_ENTRY(tm->gtk->entry21), tm->img->ls[tm->img->pos]->basename);
  }
  gtk_grid_attach(GTK_GRID(tm->gtk->grid14), tm->gtk->status1, 0, 0, 1, 1);
  gtk_widget_set_size_request(tm->gtk->status1, 220, 0);
  gtk_misc_set_alignment(GTK_MISC(tm->gtk->status1), 0, 0);
  // resolution
  char width[digits(gdk_pixbuf_get_width(tm->gtk->pixbuf_orig) + 1)];
  char height[digits(gdk_pixbuf_get_height(tm->gtk->pixbuf_orig) + 1)];
  char str[sizeof(width) + sizeof(height)]; // should be -1, but 'x' gets a char too
  if (GDK_IS_PIXBUF(tm->gtk->pixbuf_orig) && GTK_IS_WIDGET(tm->gtk->image)) {
    sprintf(width, "%d", gdk_pixbuf_get_width(tm->gtk->pixbuf_orig));
    sprintf(height, "%d", gdk_pixbuf_get_height(tm->gtk->pixbuf_orig));
    strcpy(str, width);
    strcat(str, "x");
    strcat(str, height);
  } else {
    strcpy(str, "0x0");
  }
  tm->gtk->status2 = gtk_label_new(str);
  gtk_entry_set_text(GTK_ENTRY(tm->gtk->entry22), str);
  gtk_widget_set_size_request(tm->gtk->status2, 100, 0);
  gtk_misc_set_alignment(GTK_MISC(tm->gtk->status2), 0, 0);
  gtk_grid_attach(GTK_GRID(tm->gtk->grid14), tm->gtk->status2, 1, 0, 1, 1);
  // size
  long size, mb = 0, kb = 0, bytes = 0;
  float newsize;
  size = filesize(tm->img->ls[tm->img->pos]->full_path);
  if (size > 1024 * 1024) { // > 1MB
    newsize = size / (1024.0 * 1024.0);
    mb = 1;
  } else {
    if (size > 1024) { // > 1KB
      newsize = size / 1024.0;
      kb = 1;
    } else {
      newsize = size;
      bytes = 1;
    }
  }
  sprintf(str, "%.2f", newsize);
  if (mb == 1) { strcat(str, " MB"); }
  if (kb == 1) { strcat(str, " KB"); }
  if (bytes == 1) { strcat(str, " bytes"); }
  if (newsize == 0) { strcpy(str, "0 bytes"); }
  tm->gtk->status3 = gtk_label_new(str);
  gtk_entry_set_text(GTK_ENTRY(tm->gtk->entry23), str);
  gtk_widget_set_size_request(tm->gtk->status3, 100, 0);
  gtk_misc_set_alignment(GTK_MISC(tm->gtk->status3), 0, 0);
  gtk_grid_attach(GTK_GRID(tm->gtk->grid14), tm->gtk->status3, 2, 0, 1, 1);
  // path
  if (strlen(tm->img->ls[tm->img->pos]->full_path) > 24) {
    int i;
    for (i = 0; i < 24; i++) {
      tmp[i] = tm->img->ls[tm->img->pos]->full_path[i];
    }
    tmp[i] = '\0';
    //    tm->gtk->status4 = gtk_label_new(tmp);
    gtk_entry_set_text(GTK_ENTRY(tm->gtk->entry24), tmp);
  } else {
    //    tm->gtk->status4 = gtk_label_new(tm->img->ls[tm->img->pos]->full_path);
    gtk_entry_set_text(GTK_ENTRY(tm->gtk->entry24), tm->img->ls[tm->img->pos]->full_path);
  }
  /*
  gtk_widget_set_size_request(tm->gtk->status4, 100, 0);
  gtk_misc_set_alignment(GTK_MISC(tm->gtk->status4), 0, 0);
  gtk_grid_attach(GTK_GRID(tm->gtk->grid14), tm->gtk->status4, 3, 0, 1, 1);
  */

  if (strcmp(tm->cfg->show_status, "yes") == 0) {
    gtk_widget_show_all(tm->gtk->grid14);
  } else {
    gtk_widget_hide(tm->gtk->grid14);
  }
}

void destroy_status (TM *tm) {
  if (tm->gtk->status1 != NULL) {
    gtk_widget_destroy(tm->gtk->status1);
  }
  if (tm->gtk->status2 != NULL) {
    gtk_widget_destroy(tm->gtk->status2);
  }
  if (tm->gtk->status3 != NULL) {
    gtk_widget_destroy(tm->gtk->status3);
  }
  if (tm->gtk->status4 != NULL) {
    gtk_widget_destroy(tm->gtk->status4);
  }
}
