/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

void put_settings (TM *tm) {
  if (tm->cfg->settings != 0) {
    fprintf(stdout, "[NeonView] The Settings window is already open.\n");
    return;
  }
  tm->cfg->settings = 1;

  GtkWidget *grid1, *grid11, *grid12, *grid13, *label, *button1, *button2;

  tm->gtk->window_settings = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_position(GTK_WINDOW(tm->gtk->window_settings), GTK_WIN_POS_CENTER);
  //  gtk_widget_set_size_request(tm->gtk->window_settings, 400, 320);
  gtk_window_set_resizable(GTK_WINDOW(tm->gtk->window_settings), FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(tm->gtk->window_settings), 10);
  gtk_window_set_title(GTK_WINDOW(tm->gtk->window_settings), "NeonView Settings");

  grid1 = gtk_grid_new();
  gtk_container_add(GTK_CONTAINER(tm->gtk->window_settings), grid1);
  grid11 = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(grid1), grid11, 0, 0, 1, 1);
  grid12 = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(grid1), grid12, 0, 1, 1, 1);
  grid13 = gtk_grid_new();
  gtk_grid_attach(GTK_GRID(grid1), grid13, 0, 2, 1, 1);

  GtkWidget *notebook, *title1, *title2, *ngrid1, *ngrid2;

  notebook = gtk_notebook_new();
  title1 = gtk_label_new("Application");
  ngrid1 = gtk_grid_new();
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), ngrid1, title1);
  title2 = gtk_label_new("Images");
  ngrid2 = gtk_grid_new();
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), ngrid2, title2);
  gtk_widget_set_hexpand(notebook, TRUE);
  gtk_grid_attach(GTK_GRID(grid11), notebook, 0, 0, 1, 1);

  label = gtk_label_new("This is the NeonView configuration window. It allows you to change several aspects of NeonView. Mouse-over each option to get a brief description about it in this area.");
  gtk_widget_set_size_request(label, 320, 140);
  gtk_widget_set_vexpand(label, TRUE);
  gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
  gtk_label_set_line_wrap_mode(GTK_LABEL(label), PANGO_WRAP_WORD_CHAR);
  gtk_label_set_max_width_chars(GTK_LABEL(label), 44);
  gtk_widget_set_margin_top(label, 10);
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0);
  gtk_grid_attach(GTK_GRID(grid12), label, 0, 0, 1, 1);

  gtk_widget_set_margin_top(grid13, 10);
  gtk_widget_set_hexpand(grid13, TRUE);
  gtk_grid_set_column_homogeneous(GTK_GRID(grid13), TRUE);

  button1 = gtk_button_new_with_mnemonic("_Cancel");
  gtk_widget_set_size_request(button1, 40, 32);
  gtk_grid_attach(GTK_GRID(grid13), button1, 0, 0, 1, 1);
  button2 = gtk_button_new_with_mnemonic("_OK");
  gtk_widget_set_size_request(button2, 40, 32);
  gtk_grid_attach(GTK_GRID(grid13), button2, 1, 0, 1, 1);
  // notebook page 1
  GtkWidget *ebox11, *ebox12, *subtitle11, *check11, *check12;

  subtitle11 = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(subtitle11), "<b>General</b>");
  gtk_misc_set_alignment(GTK_MISC(subtitle11), 0, 0);
  gtk_widget_set_margin_top(subtitle11, 10);
  gtk_widget_set_margin_left(subtitle11, 10);
  gtk_grid_attach(GTK_GRID(ngrid1), subtitle11, 0, 0, 1, 1);

  check11 = gtk_check_button_new_with_label("Start maximized");
  gtk_widget_set_margin_top(check11, 10);
  gtk_widget_set_margin_left(check11, 20);
  ebox11 = gtk_event_box_new();
  gtk_container_add(GTK_CONTAINER(ebox11), check11);
  gtk_grid_attach(GTK_GRID(ngrid1), ebox11, 0, 1, 1, 1);
  g_signal_connect_swapped(ebox11, "enter-notify-event", G_CALLBACK(show_hint11), label);
  g_signal_connect_swapped(ebox11, "leave-notify-event", G_CALLBACK(show_hint00), label);

  check12 = gtk_check_button_new_with_label("Remember window size");
  gtk_widget_set_margin_top(check12, 10);
  gtk_widget_set_margin_left(check12, 20);
  ebox12 = gtk_event_box_new();
  gtk_container_add(GTK_CONTAINER(ebox12), check12);
  gtk_grid_attach(GTK_GRID(ngrid1), ebox12, 0, 2, 1, 1);
  g_signal_connect_swapped(ebox11, "enter-notify-event", G_CALLBACK(show_hint12), label);
  g_signal_connect_swapped(ebox11, "leave-notify-event", G_CALLBACK(show_hint00), label);
  // notebook page 2
  GtkWidget *subtitle21, *ebox21, *ebox22, *check21, *check22;

  subtitle21 = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(subtitle21), "<b>Image</b>");
  gtk_misc_set_alignment(GTK_MISC(subtitle21), 0, 0);
  gtk_widget_set_margin_top(subtitle21, 10);
  gtk_widget_set_margin_left(subtitle21, 10);
  gtk_grid_attach(GTK_GRID(ngrid2), subtitle21, 0, 0, 1, 1);

  check21 = gtk_check_button_new_with_label("Remember fit to window");
  gtk_widget_set_margin_top(check21, 10);
  gtk_widget_set_margin_left(check21, 20);
  ebox21 = gtk_event_box_new();
  gtk_container_add(GTK_CONTAINER(ebox21), check21);
  gtk_grid_attach(GTK_GRID(ngrid2), ebox21, 0, 1, 1, 1);
  g_signal_connect_swapped(ebox21, "enter-notify-event", G_CALLBACK(show_hint21), label);
  g_signal_connect_swapped(ebox21, "leave-notify-event", G_CALLBACK(show_hint00), label);

  check22 = gtk_check_button_new_with_label("Lock fit to window");
  gtk_widget_set_margin_top(check22, 10);
  gtk_widget_set_margin_left(check22, 20);
  ebox22 = gtk_event_box_new();
  gtk_container_add(GTK_CONTAINER(ebox22), check22);
  gtk_grid_attach(GTK_GRID(ngrid2), ebox22, 0, 2, 1, 1);
  g_signal_connect_swapped(ebox22, "enter-notify-event", G_CALLBACK(show_hint22), label);
  g_signal_connect_swapped(ebox22, "leave-notify-event", G_CALLBACK(show_hint00), label);

  // fill in check boxes
  if (strcmp(tm->cfg->start_maximized, "yes") == 0) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check11), TRUE);
  }
  if (strcmp(tm->cfg->remember_window_size, "yes") == 0) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check12), TRUE);
  }
  if (strcmp(tm->cfg->remember_fit, "yes") == 0) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check21), TRUE);
  }
  if (strcmp(tm->cfg->lock_fit, "yes") == 0) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check22), TRUE);
  }

  strcpy(tm->cfg->tmp_start_maximized, tm->cfg->start_maximized);
  strcpy(tm->cfg->tmp_remember_window_size, tm->cfg->remember_window_size);
  strcpy(tm->cfg->tmp_remember_fit, tm->cfg->remember_fit);
  strcpy(tm->cfg->tmp_lock_fit, tm->cfg->lock_fit);

  g_signal_connect_swapped(check11, "toggled", G_CALLBACK(toggle_start_maximized), tm);
  g_signal_connect_swapped(check12, "toggled", G_CALLBACK(toggle_remember_window_size), tm);
  g_signal_connect_swapped(check21, "toggled", G_CALLBACK(toggle_remember_fit), tm);
  g_signal_connect_swapped(check22, "toggled", G_CALLBACK(toggle_lock_fit), tm);

  g_signal_connect_swapped(button1, "clicked", G_CALLBACK(settings_cancel), tm);
  g_signal_connect_swapped(button2, "clicked", G_CALLBACK(settings_ok), tm);

  GtkAccelGroup *accel_group;
  accel_group = gtk_accel_group_new();
  gtk_window_add_accel_group(GTK_WINDOW(tm->gtk->window_settings), accel_group);
  gtk_widget_add_accelerator(button1, "activate", accel_group, GDK_KEY_Escape, 0, GTK_ACCEL_VISIBLE);

  gtk_widget_show_all(grid1);
  gtk_widget_show(tm->gtk->window_settings);
}

void settings_cancel (TM *tm) {
  tm->cfg->settings = 0;
  gtk_widget_destroy(tm->gtk->window_settings);
}

void settings_ok (TM *tm) {
  strcpy(tm->cfg->start_maximized, tm->cfg->tmp_start_maximized);
  strcpy(tm->cfg->remember_window_size, tm->cfg->tmp_remember_window_size);
  strcpy(tm->cfg->remember_fit, tm->cfg->tmp_remember_fit);
  strcpy(tm->cfg->lock_fit, tm->cfg->tmp_lock_fit);

  tm->cfg->settings = 0;
  gtk_widget_destroy(tm->gtk->window_settings);
}

void toggle_start_maximized (TM *tm, GtkWidget *widget) {
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == TRUE) {
    strcpy(tm->cfg->tmp_start_maximized, "yes");
  } else {
    strcpy(tm->cfg->tmp_start_maximized, "no");
  }
}

void toggle_remember_window_size (TM *tm, GtkWidget *widget) {
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == TRUE) {
    strcpy(tm->cfg->tmp_remember_window_size, "yes");
  } else {
    strcpy(tm->cfg->tmp_remember_window_size, "no");
  }
}

void toggle_remember_fit (TM *tm, GtkWidget *widget) {
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == TRUE) {
    strcpy(tm->cfg->tmp_remember_fit, "yes");
  } else {
    strcpy(tm->cfg->tmp_remember_fit, "no");
  }
}

void toggle_lock_fit (TM *tm, GtkWidget *widget) {
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == TRUE) {
    strcpy(tm->cfg->tmp_lock_fit, "yes");
  } else {
    strcpy(tm->cfg->tmp_lock_fit, "no");
  }
}

void show_hint00 (GtkWidget *widget) {
  gtk_label_set_text(GTK_LABEL(widget), "This is the NeonView configuration window. It allows you to change several aspects of NeonView. Mouse-over each option to get a brief description about it in this area.");
}

void show_hint11 (GtkWidget *widget) {
  gtk_label_set_text(GTK_LABEL(widget), "When checked, NeonView will start maximized even if Remember window size is checked. NeonView will still remember the window size between sessions, but it will ignore it and automatically start maximized.");
}

void show_hint12 (GtkWidget *widget) {
  gtk_label_set_text(GTK_LABEL(widget), "When checked, NeonView will remember the window size and restore it between sessions. Notice that if Start maximized is checked, NeonView will ignore this. When unchecked, NeonView will start with a default size if Start maximized is unchecked.");
}

void show_hint21 (GtkWidget *widget) {
  gtk_label_set_text(GTK_LABEL(widget), "When checked, NeonView will remember the fit to window option between sessions. This means that if the Fit to window menu entry was checked last session, NeonView will automatically display images to fit the window size.");
}

void show_hint22 (GtkWidget *widget) {
  gtk_label_set_text(GTK_LABEL(widget), "When checked, NeonView will display all images in a directory available via Previous and Next menu entries at a size that fits the window size. When unchecked, NeonView will reset the size for Next and Previous images, displaying them at normal size.");
}
