/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

void put_scrolled (TM *tm) {
  if (tm->gtk->scrolled != NULL) {
    gtk_widget_destroy(tm->gtk->scrolled);
  }
  tm->gtk->scrolled = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_hexpand(tm->gtk->scrolled, TRUE);
  gtk_widget_set_vexpand(tm->gtk->scrolled, TRUE);
  gtk_grid_attach(GTK_GRID(tm->gtk->grid13b), tm->gtk->scrolled, 0, 0, 1, 1);

  gtk_widget_show_all(tm->gtk->scrolled);
}

void put_left_panel (TM *tm) {
  if (tm->gtk->notebook1 != NULL) {
    gtk_widget_destroy(tm->gtk->notebook1);
  }

  GtkWidget *grid1, *label1, *scrolled1, *sgrid1;

  tm->gtk->notebook1 = gtk_notebook_new();
  gtk_widget_set_vexpand(tm->gtk->notebook1, TRUE);
  grid1 = gtk_grid_new();
  label1 = gtk_label_new("Thumbnails");
  gtk_notebook_append_page(GTK_NOTEBOOK(tm->gtk->notebook1), grid1, label1);
  scrolled1 = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_vexpand(scrolled1, TRUE);
  gtk_widget_set_size_request(scrolled1, 162, 0);
  sgrid1 = gtk_grid_new();

  GdkPixbuf **pixbuf;
  GtkWidget **image;

  tm->gtk->button = malloc(tm->img->total * sizeof(GtkWidget *));
  pixbuf = malloc(tm->img->total * sizeof(GdkPixbuf *));
  image = malloc(tm->img->total * sizeof(GtkWidget *));
  if (!tm->gtk->button || !pixbuf || !image) {
    criterr(0);
  }

  for (tm->img->it = 0; tm->img->it < tm->img->total; tm->img->it++) {
    pixbuf[tm->img->it] = gdk_pixbuf_new_from_file_at_size(tm->img->ls[tm->img->it]->full_path, 120, 120, NULL);
    image[tm->img->it] = gtk_image_new_from_pixbuf(pixbuf[tm->img->it]);
    tm->gtk->button[tm->img->it] = gtk_button_new();
    g_signal_connect_swapped(tm->gtk->button[tm->img->it], "clicked", G_CALLBACK(show_thumbnail), tm);
    gtk_container_add(GTK_CONTAINER(tm->gtk->button[tm->img->it]), image[tm->img->it]);
    gtk_grid_attach(GTK_GRID(sgrid1), tm->gtk->button[tm->img->it], 0, tm->img->it, 1, 1);
  }

  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled1), sgrid1);
  gtk_grid_attach(GTK_GRID(grid1), scrolled1, 0, 0, 1, 1);
  gtk_grid_attach(GTK_GRID(tm->gtk->grid13a), tm->gtk->notebook1, 0, 0, 1, 1);

  if (strcmp(tm->cfg->show_left_panel, "yes") == 0) {
    gtk_widget_show_all(tm->gtk->notebook1);
  } else {
    gtk_widget_hide(tm->gtk->notebook1);
  }
}

void put_right_panel (TM *tm) {
  if (tm->gtk->notebook2 != NULL) {
    gtk_widget_destroy(tm->gtk->notebook2);
  }

  GtkWidget *label1, *grid1, *scrolled1, *sgrid1;

  tm->gtk->notebook2 = gtk_notebook_new();
  //  gtk_widget_set_size_request(tm->gtk->notebook2, 148, 0);
  gtk_widget_set_vexpand(tm->gtk->notebook2, TRUE);
  label1 = gtk_label_new("Info");
  grid1 = gtk_grid_new();
  gtk_notebook_append_page(GTK_NOTEBOOK(tm->gtk->notebook2), grid1, label1);
  scrolled1 = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_size_request(scrolled1, 140, 0);
  gtk_container_add(GTK_CONTAINER(grid1), scrolled1);
  sgrid1 = gtk_grid_new();
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled1), sgrid1);
  gtk_grid_attach(GTK_GRID(tm->gtk->grid13c), tm->gtk->notebook2, 0, 0, 1, 1);

  GtkWidget *subtitle1, *subtitle2, *subtitle3, *subtitle4;

  subtitle1 = gtk_label_new("Filename");
  subtitle2 = gtk_label_new("Resolution");
  subtitle3 = gtk_label_new("Size");
  subtitle4 = gtk_label_new("Path");

  char *markup;

  markup = g_markup_printf_escaped("<b>%s</b>", "Filename");
  gtk_label_set_markup(GTK_LABEL(subtitle1), markup);
  gtk_misc_set_alignment(GTK_MISC(subtitle1), 0, 0);

  markup = g_markup_printf_escaped("<b>%s</b>", "Image Size");
  gtk_label_set_markup(GTK_LABEL(subtitle2), markup);
  gtk_misc_set_alignment(GTK_MISC(subtitle2), 0, 0);

  markup = g_markup_printf_escaped("<b>%s</b>", "File Size");
  gtk_label_set_markup(GTK_LABEL(subtitle3), markup);
  gtk_misc_set_alignment(GTK_MISC(subtitle3), 0, 0);

  markup = g_markup_printf_escaped("<b>%s</b>", "Path");
  gtk_label_set_markup(GTK_LABEL(subtitle4), markup);
  gtk_misc_set_alignment(GTK_MISC(subtitle4), 0, 0);

  tm->gtk->entry21 = gtk_entry_new();
  tm->gtk->entry22 = gtk_entry_new();
  tm->gtk->entry23 = gtk_entry_new();
  tm->gtk->entry24 = gtk_entry_new();

  gtk_entry_set_width_chars(GTK_ENTRY(tm->gtk->entry21), 15);
  gtk_editable_set_editable(GTK_EDITABLE(tm->gtk->entry21), FALSE);
  gtk_entry_set_width_chars(GTK_ENTRY(tm->gtk->entry22), 15);
  gtk_editable_set_editable(GTK_EDITABLE(tm->gtk->entry22), FALSE);
  gtk_entry_set_width_chars(GTK_ENTRY(tm->gtk->entry23), 15);
  gtk_editable_set_editable(GTK_EDITABLE(tm->gtk->entry23), FALSE);
  gtk_entry_set_width_chars(GTK_ENTRY(tm->gtk->entry24), 15);
  gtk_editable_set_editable(GTK_EDITABLE(tm->gtk->entry24), FALSE);

  gtk_widget_set_margin_top(subtitle1, 10);
  gtk_widget_set_margin_top(subtitle2, 10);
  gtk_widget_set_margin_top(subtitle3, 10);
  gtk_widget_set_margin_top(subtitle4, 10);

  gtk_grid_attach(GTK_GRID(sgrid1), subtitle1, 0, 0, 1, 1);
  gtk_grid_attach(GTK_GRID(sgrid1), tm->gtk->entry21, 0, 1, 1, 1);
  gtk_grid_attach(GTK_GRID(sgrid1), subtitle2, 0, 2, 1, 1);
  gtk_grid_attach(GTK_GRID(sgrid1), tm->gtk->entry22, 0, 3, 1, 1);
  gtk_grid_attach(GTK_GRID(sgrid1), subtitle3, 0, 4, 1, 1);
  gtk_grid_attach(GTK_GRID(sgrid1), tm->gtk->entry23, 0, 5, 1, 1);
  gtk_grid_attach(GTK_GRID(sgrid1), subtitle4, 0, 6, 1, 1);
  gtk_grid_attach(GTK_GRID(sgrid1), tm->gtk->entry24, 0, 7, 1, 1);

  gtk_widget_set_vexpand(sgrid1, TRUE);

  if (strcmp(tm->cfg->show_right_panel, "yes") == 0) {
    gtk_widget_show_all(tm->gtk->notebook2);
  } else {
    gtk_widget_hide(tm->gtk->notebook2);
  }
}
