/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

void put_open (TM *tm) {
  GtkWidget *dialog;
  char *filename;
  int emit;

  dialog = gtk_file_chooser_dialog_new("Open Image", NULL, GTK_FILE_CHOOSER_ACTION_OPEN,
				       GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				       GTK_STOCK_OPEN, GTK_RESPONSE_OK, NULL);
  emit = gtk_dialog_run(GTK_DIALOG(dialog));
  if (emit == GTK_RESPONSE_OK) {
    filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));
    gtk_widget_destroy(dialog);
    get_dirname(tm, filename);
    fill_image_list(tm);
    sort_list_by_name(tm);
    get_position(tm, filename);
    show_image(tm);
    put_left_panel(tm);
    init_widgets(tm);
    //    printf("total = %d\n", tm->img->total);
    //    print_all(tm);
  } else {
    gtk_widget_destroy(dialog);
  }
}
