/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

void put_menubar (TM *tm) {
  GtkWidget *menufile, *file, *open, *sep1, *quit;
  GtkWidget *menuimage, *image, *sep2, *sep3, *sep4;
  GtkWidget *menutools, *tools, *sep5, *settings;
  GtkWidget *menuhelp, *help, *manual, *faq, *sep6, *homepage, *sep7, *about;
  GtkAccelGroup *accel_group;

  if (tm->gtk->menubar != NULL) {
    gtk_widget_destroy(tm->gtk->menubar);
  }

  accel_group = gtk_accel_group_new();
  gtk_window_add_accel_group(GTK_WINDOW(tm->gtk->window), accel_group);

  tm->gtk->menubar = gtk_menu_bar_new();
  /*****************************************************************************************/
  /************************************** FILE MNEU ****************************************/
  menufile = gtk_menu_new();
  file = gtk_menu_item_new_with_mnemonic("_File");
  open = gtk_menu_item_new_with_mnemonic("_Open...");
  sep1 = gtk_separator_menu_item_new();
  quit = gtk_menu_item_new_with_mnemonic("_Quit");
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(file), menufile);
  gtk_menu_shell_append(GTK_MENU_SHELL(menufile), open);
  gtk_menu_shell_append(GTK_MENU_SHELL(menufile), sep1);
  gtk_menu_shell_append(GTK_MENU_SHELL(menufile), quit);
  gtk_menu_shell_append(GTK_MENU_SHELL(tm->gtk->menubar), file);
  g_signal_connect_swapped(open, "activate", G_CALLBACK(put_open), tm);
  g_signal_connect_swapped(quit, "activate", G_CALLBACK(gtk_neon_quit), tm);
  gtk_widget_add_accelerator(open, "activate", accel_group, GDK_KEY_o, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(quit, "activate", accel_group, GDK_KEY_q, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  /*****************************************************************************************/
  /************************************** IMAGE MENU ***************************************/
  menuimage = gtk_menu_new();
  image = gtk_menu_item_new_with_mnemonic("_Image");
  tm->gtk->menu_prev = gtk_menu_item_new_with_mnemonic("_Previous");
  tm->gtk->menu_next = gtk_menu_item_new_with_mnemonic("_Next");
  sep2 = gtk_separator_menu_item_new();
  tm->gtk->menu_fit = gtk_check_menu_item_new_with_mnemonic("Fit to _Window");
  tm->gtk->menu_orig = gtk_menu_item_new_with_mnemonic("Original I_mage");
  sep3 = gtk_separator_menu_item_new();
  tm->gtk->zoom_out = gtk_menu_item_new_with_mnemonic("Zoom _Out");
  tm->gtk->zoom_in = gtk_menu_item_new_with_mnemonic("Zoom _In");
  sep4 = gtk_separator_menu_item_new();
  tm->gtk->menu_left = gtk_menu_item_new_with_mnemonic("Rotate _Left");
  tm->gtk->menu_right = gtk_menu_item_new_with_mnemonic("Rotate _Right");
  tm->gtk->menu_flip = gtk_menu_item_new_with_mnemonic("_Flip");
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(image), menuimage);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), tm->gtk->menu_prev);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), tm->gtk->menu_next);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), sep2);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), tm->gtk->menu_fit);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), tm->gtk->menu_orig);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), sep3);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), tm->gtk->zoom_out);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), tm->gtk->zoom_in);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), sep4);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), tm->gtk->menu_left);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), tm->gtk->menu_right);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuimage), tm->gtk->menu_flip);
  gtk_menu_shell_append(GTK_MENU_SHELL(tm->gtk->menubar), image);
  gtk_widget_add_accelerator(tm->gtk->menu_next, "activate", accel_group, GDK_KEY_n, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(tm->gtk->menu_next, "activate", accel_group, GDK_KEY_space, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(tm->gtk->menu_prev, "activate", accel_group, GDK_KEY_p, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(tm->gtk->menu_prev, "activate", accel_group, GDK_KEY_BackSpace, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(tm->gtk->menu_fit, "activate", accel_group, GDK_KEY_x, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(tm->gtk->menu_orig, "activate", accel_group, GDK_KEY_m, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(tm->gtk->zoom_in, "activate", accel_group, GDK_KEY_i, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(tm->gtk->zoom_out, "activate", accel_group, GDK_KEY_o, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(tm->gtk->menu_left, "activate", accel_group, GDK_KEY_l, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(tm->gtk->menu_right, "activate", accel_group, GDK_KEY_r, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(tm->gtk->menu_flip, "activate", accel_group, GDK_KEY_f, 0, GTK_ACCEL_VISIBLE);
  g_signal_connect_swapped(tm->gtk->menu_prev, "activate", G_CALLBACK(show_prev), tm);
  g_signal_connect_swapped(tm->gtk->menu_next, "activate", G_CALLBACK(show_next), tm);
  g_signal_connect_swapped(tm->gtk->menu_fit, "activate", G_CALLBACK(fit_to_window), tm);
  g_signal_connect_swapped(tm->gtk->menu_orig, "activate", G_CALLBACK(orig), tm);
  g_signal_connect_swapped(tm->gtk->zoom_in, "activate", G_CALLBACK(zoom_in), tm);
  g_signal_connect_swapped(tm->gtk->zoom_out, "activate", G_CALLBACK(zoom_out), tm);
  g_signal_connect_swapped(tm->gtk->menu_left, "activate", G_CALLBACK(rotate_left), tm);
  g_signal_connect_swapped(tm->gtk->menu_right, "activate", G_CALLBACK(rotate_right), tm);
  g_signal_connect_swapped(tm->gtk->menu_flip, "activate", G_CALLBACK(flip), tm);
  /*****************************************************************************************/
  /************************************** TOOLS MENU ***************************************/
  menutools = gtk_menu_new();
  tools = gtk_menu_item_new_with_mnemonic("_Tools");
  tm->gtk->show_toolbar = gtk_check_menu_item_new_with_mnemonic("T_oolbar");
  tm->gtk->show_status = gtk_check_menu_item_new_with_mnemonic("_Status Bar");
  tm->gtk->show_left_panel = gtk_check_menu_item_new_with_mnemonic("_Left Panel");
  tm->gtk->show_right_panel = gtk_check_menu_item_new_with_mnemonic("_Right Panel");
  sep5 = gtk_separator_menu_item_new();
  settings = gtk_menu_item_new_with_mnemonic("Se_ttings");
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(tools), menutools);
  gtk_menu_shell_append(GTK_MENU_SHELL(menutools), tm->gtk->show_toolbar);
  gtk_menu_shell_append(GTK_MENU_SHELL(menutools), tm->gtk->show_status);
  gtk_menu_shell_append(GTK_MENU_SHELL(menutools), tm->gtk->show_left_panel);
  gtk_menu_shell_append(GTK_MENU_SHELL(menutools), tm->gtk->show_right_panel);
  gtk_menu_shell_append(GTK_MENU_SHELL(menutools), sep5);
  gtk_menu_shell_append(GTK_MENU_SHELL(menutools), settings);
  gtk_menu_shell_append(GTK_MENU_SHELL(tm->gtk->menubar), tools);
  gtk_widget_add_accelerator(settings, "activate", accel_group, GDK_KEY_t, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  g_signal_connect_swapped(tm->gtk->show_toolbar, "activate", G_CALLBACK(toggle_toolbar), tm);
  g_signal_connect_swapped(tm->gtk->show_status, "activate", G_CALLBACK(toggle_status), tm);
  g_signal_connect_swapped(tm->gtk->show_left_panel, "activate", G_CALLBACK(toggle_left_panel), tm);
  g_signal_connect_swapped(tm->gtk->show_right_panel, "activate", G_CALLBACK(toggle_right_panel), tm);
  g_signal_connect_swapped(settings, "activate", G_CALLBACK(put_settings), tm);
  /*****************************************************************************************/
  /************************************** HELP MENU ****************************************/
  menuhelp = gtk_menu_new();
  help = gtk_menu_item_new_with_mnemonic("_Help");
  manual = gtk_menu_item_new_with_mnemonic("_Manual");
  faq = gtk_menu_item_new_with_mnemonic("_FAQ");
  sep6 = gtk_separator_menu_item_new();
  homepage = gtk_menu_item_new_with_mnemonic("_Homepage");
  sep7 = gtk_separator_menu_item_new();
  about = gtk_menu_item_new_with_mnemonic("_About");
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(help), menuhelp);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuhelp), manual);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuhelp), faq);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuhelp), sep6);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuhelp), homepage);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuhelp), sep7);
  gtk_menu_shell_append(GTK_MENU_SHELL(menuhelp), about);
  gtk_menu_shell_append(GTK_MENU_SHELL(tm->gtk->menubar), help);
  gtk_widget_add_accelerator(manual, "activate", accel_group, GDK_KEY_F1, 0, GTK_ACCEL_VISIBLE);
  g_signal_connect(manual, "activate", G_CALLBACK(put_manual), NULL);
  g_signal_connect(faq, "activate", G_CALLBACK(put_faq), NULL);
  g_signal_connect(homepage, "activate", G_CALLBACK(put_homepage), NULL);
  g_signal_connect(about, "activate", G_CALLBACK(put_about), NULL);
  /******************************************************************************/
  /******************************************************************************/
  gtk_widget_set_hexpand(tm->gtk->menubar, TRUE);
  gtk_grid_attach(GTK_GRID(tm->gtk->grid11), tm->gtk->menubar, 0, 0, 1, 1);
  /******************************************************************************/
  /******************************************************************************/
  if (strcmp(tm->cfg->remember_fit, "yes") == 0 && strcmp(tm->cfg->lock_fit, "yes") == 0) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(tm->gtk->menu_fit), TRUE);
  }
  if (strcmp(tm->cfg->show_toolbar, "yes") == 0) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(tm->gtk->show_toolbar), TRUE);
    // gtk_widget_show_all(tm->gtk->toolbar);
  }
  if (strcmp(tm->cfg->show_status, "yes") == 0) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(tm->gtk->show_status), TRUE);
    // gtk_widget_show_all(tm->gtk->status);
  }
  if (strcmp(tm->cfg->show_left_panel, "yes") == 0) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(tm->gtk->show_left_panel), TRUE);
    // gtk_widget_show_all(tm->gtk->left_panel);
  }
  if (strcmp(tm->cfg->show_right_panel, "yes") == 0) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(tm->gtk->show_right_panel), TRUE);
    // gtk_widget_show_all(tm->gtk->right_panel);
  }

  gtk_widget_show_all(tm->gtk->menubar);
}

void toggle_toolbar (TM *tm) {
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(tm->gtk->show_toolbar)) == TRUE) {
    strcpy(tm->cfg->show_toolbar, "yes");
    gtk_widget_show_all(tm->gtk->toolbar);
  } else {
    strcpy(tm->cfg->show_toolbar, "no");
    gtk_widget_hide(tm->gtk->toolbar);
  }
}

void toggle_status (TM *tm) {
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(tm->gtk->show_status)) == TRUE) {
    strcpy(tm->cfg->show_status, "yes");
    gtk_widget_show_all(tm->gtk->grid14);
  } else {
    strcpy(tm->cfg->show_status, "no");
    gtk_widget_hide(tm->gtk->grid14);
  }
}

void toggle_left_panel (TM *tm) {
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(tm->gtk->show_left_panel)) == TRUE) {
    strcpy(tm->cfg->show_left_panel, "yes");
    gtk_widget_show_all(tm->gtk->notebook1);
  } else {
    strcpy(tm->cfg->show_left_panel, "no");
    gtk_widget_hide(tm->gtk->notebook1);
  }
}

void toggle_right_panel (TM *tm) {
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(tm->gtk->show_right_panel)) == TRUE) {
    strcpy(tm->cfg->show_right_panel, "yes");
    gtk_widget_show_all(tm->gtk->notebook2);
  } else {
    strcpy(tm->cfg->show_right_panel, "no");
    gtk_widget_hide(tm->gtk->notebook2);
  }
}
