/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

void init_args (TM *tm) {
  int go = 0; // tells program which way to continue

  if (tm->argc == 1) {
    go = 1; // no arguments
  }
  if (tm->argc == 2) {
    if (strcmp(tm->argv[1], "-v") == 0 || strcmp(tm->argv[1], "--version") == 0) {
      fprintf(stdout, "%s %s - %s\n", NAME, VERSION, HTTP);
      exit(0);
    }
    if (strcmp(tm->argv[1], "-h") == 0 || strcmp(tm->argv[1], "--help") == 0) {
      fprintf(stdout, "Usage:\n");
      fprintf(stdout, "  neonview [OPTION|FILE]\n");
      fprintf(stdout, "\n");
      fprintf(stdout, "NeonView is a fast, lightweight image viewer.\n");
      fprintf(stdout, "\n");
      fprintf(stdout, "Options:\n");
      fprintf(stdout, "  -v, --version\t\t\tShow version\n");
      fprintf(stdout, "  -h, --help\t\t\tShow help\n");
      fprintf(stdout, "\n");
      fprintf(stdout, "Examples:\n");
      fprintf(stdout, "  neonview guitar.jpg\t\tOpen image guitar.jpg\n");
      fprintf(stdout, "  neonview -h\t\t\tShow this help\n");
      exit(0);
    }
    if (strcmp(tm->argv[1], "-v") != 0 && strcmp(tm->argv[1], "--version") != 0 &&
	strcmp(tm->argv[1], "-h") != 0 && strcmp(tm->argv[1], "--help") != 0) {
      go = 2; // only one argument, NOT a valid option => try to display as image
    }
  }
  if (tm->argc > 2) {
    fprintf(stdout, "Usage: neonview [OPTION|FILE]\n");
    exit(0);
  }

  init_struct(tm);
  get_cwd(tm);
  get_home(tm);
  get_config_dir(tm);
  get_config_file(tm);
  init_keys(tm);
  read_config(tm);
  print_config(tm);

  get_dirname(tm, tm->argv[1]);
  fill_image_list(tm);
  sort_list_by_name(tm);
  get_position(tm, tm->argv[1]);

  if (go == 0) {
    criterr(-1);
  }
  if (go == 1) {
    // no arguments
  }
  if (go == 2) {
    // one argument
  }

  put_window(tm);
  put_scrolled(tm);
  put_toolbar(tm);
  put_left_panel(tm);
  put_right_panel(tm);
  put_menubar(tm);
  show_image(tm);
  put_status(tm);
  gtk_widget_grab_focus(tm->gtk->scrolled); // prevent first toolbar button from getting the focus

  //  print_all(tm);
}

void init_struct (TM *tm) {
  memset(tm->env->cwd, '\0', sizeof(tm->env->cwd));
  tm->env->home = NULL;
  tm->env->config_dir = NULL;
  tm->env->config_file = NULL;

  tm->cfg->settings = 0;

  tm->img->argv1 = NULL;
  tm->img->image_full_path = NULL;
  tm->img->image_dirname = NULL;
  tm->img->image_basename = NULL;
  tm->img->total = 0;
  tm->img->pos = 0;
  tm->img->scaled = 0;
  tm->img->it = 0;

  tm->img->ls = NULL;

  tm->gtk->window = NULL;
  tm->gtk->grid1 = NULL;
  tm->gtk->menubar = NULL;
  tm->gtk->toolbar = NULL;
  tm->gtk->scrolled = NULL;
  tm->gtk->notebook1 = NULL;
  tm->gtk->notebook2 = NULL;

  tm->gtk->pixbuf = NULL;
  tm->gtk->pixbuf_orig = NULL;
  tm->gtk->animation = NULL;
  tm->gtk->animation_orig = NULL;
  tm->gtk->image = NULL;
}
