/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

void show_image (TM *tm) {
  if (tm->gtk->image != NULL && GTK_IS_WIDGET(tm->gtk->image)) {
    gtk_widget_destroy(tm->gtk->image);
  }
	if (tm->img->total > 0) {
  if (strcmp(tm->img->ls[tm->img->pos]->type, "GIF") == 0) {
    tm->gtk->animation = gdk_pixbuf_animation_new_from_file(tm->img->ls[tm->img->pos]->full_path, NULL);
    if (GDK_IS_PIXBUF_ANIMATION(tm->gtk->animation)) {
      tm->gtk->animation_orig = tm->gtk->animation;
      tm->gtk->image = gtk_image_new_from_animation(tm->gtk->animation);
      gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(tm->gtk->scrolled), tm->gtk->image);
      gtk_widget_show(tm->gtk->image);
    } else {
      fprintf(stdout, "[NeonView] WARNING: Not a valid GIF file.\n");
    }
  } else {
    if (tm->img->scaled == 0) {
      tm->gtk->pixbuf = gdk_pixbuf_new_from_file(tm->img->ls[tm->img->pos]->full_path, NULL);
      tm->gtk->pixbuf_orig = tm->gtk->pixbuf;
      tm->gtk->image = gtk_image_new_from_pixbuf(tm->gtk->pixbuf);
      gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(tm->gtk->scrolled), tm->gtk->image);
      gtk_widget_show(tm->gtk->image);
    } else {
      // show image at scale
      int width, height;
      gtk_window_get_size(GTK_WINDOW(tm->gtk->window), &width, &height);
      tm->gtk->pixbuf = gdk_pixbuf_new_from_file_at_scale(tm->img->ls[tm->img->pos]->full_path, width - 340, height - 70, TRUE, NULL);
      //      tm->gtk->pixbuf_orig = tm->gtk->pixbuf;
      tm->gtk->image = gtk_image_new_from_pixbuf(tm->gtk->pixbuf);
      gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(tm->gtk->scrolled), tm->gtk->image);
      gtk_widget_show(tm->gtk->image);
      tm->gtk->pixbuf_orig = gdk_pixbuf_new_from_file(tm->img->ls[tm->img->pos]->full_path, NULL);
    }
    put_status(tm);
  }
	}
  init_widgets(tm);
}

void show_image_fit (TM *tm) {
}

void show_thumbnail (TM *tm, GtkWidget *widget) {
  int i;
  for (i = 0; i < tm->img->total; i++) {
    if (tm->gtk->button[i] == widget) {
      if (tm->gtk->image != NULL && GTK_IS_WIDGET(tm->gtk->image)) {
	gtk_widget_destroy(tm->gtk->image);
      }
      init_scaled(tm);
      tm->img->pos = i;
      if (strcmp(tm->img->ls[i]->type, "GIF") == 0) {
	tm->gtk->animation = gdk_pixbuf_animation_new_from_file(tm->img->ls[i]->full_path, NULL);
	if (GDK_IS_PIXBUF_ANIMATION(tm->gtk->animation)) {
	  tm->gtk->animation_orig = tm->gtk->animation;
	  tm->gtk->image = gtk_image_new_from_animation(tm->gtk->animation);
	  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(tm->gtk->scrolled), tm->gtk->image);
	  gtk_widget_show(tm->gtk->image);
	} else {
	  fprintf(stdout, "[NeonView] WARNING: Not a valid GIF file.\n");
	}
      } else {
	if (tm->img->scaled == 0) {
	  tm->gtk->pixbuf = gdk_pixbuf_new_from_file(tm->img->ls[i]->full_path, NULL);
	  tm->gtk->pixbuf_orig = tm->gtk->pixbuf;
	  tm->gtk->image = gtk_image_new_from_pixbuf(tm->gtk->pixbuf);
	  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(tm->gtk->scrolled), tm->gtk->image);
	  gtk_widget_show(tm->gtk->image);
	} else {
	  // show image at scale
	  int width, height;
	  gtk_window_get_size(GTK_WINDOW(tm->gtk->window), &width, &height);
	  tm->gtk->pixbuf = gdk_pixbuf_new_from_file_at_scale(tm->img->ls[i]->full_path, width - 340, height - 70, TRUE, NULL);
	  //	  tm->gtk->pixbuf_orig = tm->gtk->pixbuf;
	  tm->gtk->image = gtk_image_new_from_pixbuf(tm->gtk->pixbuf);
	  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(tm->gtk->scrolled), tm->gtk->image);
	  gtk_widget_show(tm->gtk->image);
	  tm->gtk->pixbuf_orig = gdk_pixbuf_new_from_file(tm->img->ls[i]->full_path, NULL);
	}
	put_status(tm);
      }
      init_widgets(tm);
    }
  }
}

void init_widgets (TM *tm) {
  if (tm->img->total == 0) {
    gtk_widget_set_sensitive(tm->gtk->menu_prev, FALSE);
    gtk_widget_set_sensitive(tm->gtk->menu_next, FALSE);
    gtk_widget_set_sensitive(tm->gtk->menu_fit, FALSE);
    gtk_widget_set_sensitive(tm->gtk->menu_orig, FALSE);
    gtk_widget_set_sensitive(tm->gtk->zoom_in, FALSE);
    gtk_widget_set_sensitive(tm->gtk->zoom_out, FALSE);
    gtk_widget_set_sensitive(tm->gtk->menu_left, FALSE);
    gtk_widget_set_sensitive(tm->gtk->menu_right, FALSE);
    gtk_widget_set_sensitive(tm->gtk->menu_flip, FALSE);
    if (GTK_IS_WIDGET(tm->gtk->tool_prev) && GTK_IS_WIDGET(tm->gtk->tool_next) && GTK_IS_WIDGET(tm->gtk->tool_orig) &&
	GTK_IS_WIDGET(tm->gtk->tool_fit) && GTK_IS_WIDGET(tm->gtk->tool_zoom_in) && GTK_IS_WIDGET(tm->gtk->tool_zoom_out)) {
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_prev), FALSE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_next), FALSE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_orig), FALSE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_fit), FALSE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_zoom_in), FALSE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_zoom_out), FALSE);
    }
  }
  if (tm->img->total == 1) {
    gtk_widget_set_sensitive(tm->gtk->menu_prev, TRUE);
    gtk_widget_set_sensitive(tm->gtk->menu_next, TRUE);
    gtk_widget_set_sensitive(tm->gtk->menu_fit, TRUE);
    gtk_widget_set_sensitive(tm->gtk->menu_orig, TRUE);
    gtk_widget_set_sensitive(tm->gtk->zoom_in, TRUE);
    gtk_widget_set_sensitive(tm->gtk->zoom_out, TRUE);
    gtk_widget_set_sensitive(tm->gtk->menu_left, TRUE);
    gtk_widget_set_sensitive(tm->gtk->menu_right, TRUE);
    gtk_widget_set_sensitive(tm->gtk->menu_flip, TRUE);
    if (GTK_IS_WIDGET(tm->gtk->tool_prev) && GTK_IS_WIDGET(tm->gtk->tool_next) && GTK_IS_WIDGET(tm->gtk->tool_orig) &&
	GTK_IS_WIDGET(tm->gtk->tool_fit) && GTK_IS_WIDGET(tm->gtk->tool_zoom_in) && GTK_IS_WIDGET(tm->gtk->tool_zoom_out)) {
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_prev), TRUE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_next), TRUE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_orig), TRUE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_fit), TRUE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_zoom_in), TRUE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_zoom_out), TRUE);
    }
    gtk_widget_set_sensitive(tm->gtk->menu_prev, FALSE);
    gtk_widget_set_sensitive(tm->gtk->menu_next, FALSE);
    if (GTK_IS_WIDGET(tm->gtk->tool_prev) && GTK_IS_WIDGET(tm->gtk->tool_next)) {
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_prev), FALSE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_next), FALSE);
    }
  }
  if (tm->img->total > 1) {
    gtk_widget_set_sensitive(tm->gtk->menu_prev, TRUE);
    gtk_widget_set_sensitive(tm->gtk->menu_next, TRUE);
    gtk_widget_set_sensitive(tm->gtk->menu_fit, TRUE);
    gtk_widget_set_sensitive(tm->gtk->menu_orig, TRUE);
    gtk_widget_set_sensitive(tm->gtk->zoom_in, TRUE);
    gtk_widget_set_sensitive(tm->gtk->zoom_out, TRUE);
    gtk_widget_set_sensitive(tm->gtk->menu_left, TRUE);
    gtk_widget_set_sensitive(tm->gtk->menu_right, TRUE);
    gtk_widget_set_sensitive(tm->gtk->menu_flip, TRUE);
    if (GTK_IS_WIDGET(tm->gtk->tool_prev) && GTK_IS_WIDGET(tm->gtk->tool_next) && GTK_IS_WIDGET(tm->gtk->tool_orig) &&
	GTK_IS_WIDGET(tm->gtk->tool_fit) && GTK_IS_WIDGET(tm->gtk->tool_zoom_in) && GTK_IS_WIDGET(tm->gtk->tool_zoom_out)) {
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_prev), TRUE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_next), TRUE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_orig), TRUE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_fit), TRUE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_zoom_in), TRUE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_zoom_out), TRUE);
    }
    if (tm->img->pos == 0) {
      gtk_widget_set_sensitive(tm->gtk->menu_prev, FALSE);
      if (GTK_IS_WIDGET(tm->gtk->tool_prev)) {
	gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_prev), FALSE);
      }
      gtk_widget_set_sensitive(tm->gtk->menu_next, TRUE);
      if (GTK_IS_WIDGET(tm->gtk->tool_next)) {
	gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_next), TRUE);
      }
    }
    if (tm->img->pos == tm->img->total - 1) {
      gtk_widget_set_sensitive(tm->gtk->menu_prev, TRUE);
      gtk_widget_set_sensitive(tm->gtk->menu_next, FALSE);
      if (GTK_IS_WIDGET(tm->gtk->tool_prev) && GTK_IS_WIDGET(tm->gtk->tool_next)) {
	gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_prev), TRUE);
	gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_next), FALSE);
      }
    }
    if (tm->img->pos != 0 && tm->img->pos != tm->img->total - 1) {
      gtk_widget_set_sensitive(tm->gtk->menu_prev, TRUE);
      gtk_widget_set_sensitive(tm->gtk->menu_next, TRUE);
      if (GTK_IS_WIDGET(tm->gtk->tool_prev) && GTK_IS_WIDGET(tm->gtk->tool_next)) {
	gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_prev), TRUE);
	gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_next), TRUE);
      }
    }
  }
}

void init_scaled (TM *tm) {
  if (strcmp(tm->cfg->lock_fit, "no") == 0 ) {
    tm->img->scaled = 0;
  }
}

void show_prev (TM *tm) {
  if (tm->img->pos > 0) {
    tm->img->pos = tm->img->pos - 1;
    init_scaled(tm);
    show_image(tm);
    init_widgets(tm);
  }
}

void show_next (TM *tm) {
  if (tm->img->pos < tm->img->total - 1) {
    tm->img->pos = tm->img->pos + 1;
    init_scaled(tm);
    show_image(tm);
    init_widgets(tm);
  }
}

void fit_to_window (TM *tm) {
  if (tm->img->scaled == 1) {
    tm->img->scaled = 0;
  } else {
    tm->img->scaled = 1;
  }
  show_image(tm);
}

void rotate_left (TM *tm) {
  if (GDK_IS_PIXBUF(tm->gtk->pixbuf)) {
    if (tm->gtk->image != NULL) {
      gtk_widget_destroy(tm->gtk->image);
    }
    tm->gtk->pixbuf = gdk_pixbuf_rotate_simple(tm->gtk->pixbuf, 90);
    tm->gtk->image = gtk_image_new_from_pixbuf(tm->gtk->pixbuf);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(tm->gtk->scrolled), tm->gtk->image);
    gtk_widget_show(tm->gtk->image);
  }
}

void rotate_right (TM *tm) {
  if (GDK_IS_PIXBUF(tm->gtk->pixbuf)) {
    if (tm->gtk->image != NULL) {
      gtk_widget_destroy(tm->gtk->image);
    }
    tm->gtk->pixbuf = gdk_pixbuf_rotate_simple(tm->gtk->pixbuf, 270);
    tm->gtk->image = gtk_image_new_from_pixbuf(tm->gtk->pixbuf);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(tm->gtk->scrolled), tm->gtk->image);
    gtk_widget_show(tm->gtk->image);
  }
}

void flip (TM *tm) {
  if (GDK_IS_PIXBUF(tm->gtk->pixbuf)) {
    if (tm->gtk->image != NULL) {
      gtk_widget_destroy(tm->gtk->image);
    }
    tm->gtk->pixbuf = gdk_pixbuf_flip(tm->gtk->pixbuf, FALSE);
    tm->gtk->image = gtk_image_new_from_pixbuf(tm->gtk->pixbuf);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(tm->gtk->scrolled), tm->gtk->image);
    gtk_widget_show(tm->gtk->image);
  }
}

void zoom_in (TM *tm) {
  if (GDK_IS_PIXBUF(tm->gtk->pixbuf_orig)) {
    float width, height;
    GdkPixbuf *pixbuf;
    width = gdk_pixbuf_get_width(tm->gtk->pixbuf);
    height = gdk_pixbuf_get_height(tm->gtk->pixbuf);
    if (width <= 4000 && height <= 4000) {
      pixbuf = gdk_pixbuf_scale_simple(tm->gtk->pixbuf, width + width * (20 / 100.0), height + height * (20 / 100.0), GDK_INTERP_BILINEAR);
      tm->gtk->pixbuf = pixbuf;
      if (tm->gtk->image != NULL) {
	gtk_widget_destroy(tm->gtk->image);
      }
      tm->gtk->image = gtk_image_new_from_pixbuf(pixbuf);
      gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(tm->gtk->scrolled), tm->gtk->image);
      gtk_widget_show(tm->gtk->image);
      gtk_widget_set_sensitive(tm->gtk->zoom_out, TRUE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_zoom_out), TRUE);
    } else {
      // disable zoom_in
      gtk_widget_set_sensitive(tm->gtk->zoom_in, FALSE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_zoom_in), FALSE);
    }
  }
}

void zoom_out (TM *tm) {
  if (GDK_IS_PIXBUF(tm->gtk->pixbuf_orig)) {
    float width, height;
    GdkPixbuf *pixbuf;
    width = gdk_pixbuf_get_width(tm->gtk->pixbuf);
    height = gdk_pixbuf_get_height(tm->gtk->pixbuf);
    if (width > 10 && height > 10) {
      pixbuf = gdk_pixbuf_scale_simple(tm->gtk->pixbuf, width - width * (20 / 100.0), height - height * (20 / 100.0), GDK_INTERP_BILINEAR);
      tm->gtk->pixbuf = pixbuf;
      if (tm->gtk->image != NULL) {
	gtk_widget_destroy(tm->gtk->image);
      }
      tm->gtk->image = gtk_image_new_from_pixbuf(pixbuf);
      gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(tm->gtk->scrolled), tm->gtk->image);
      gtk_widget_show(tm->gtk->image);
      gtk_widget_set_sensitive(tm->gtk->zoom_in, TRUE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_zoom_in), TRUE);
    } else {
      // disable zoom_out
      gtk_widget_set_sensitive(tm->gtk->zoom_out, FALSE);
      gtk_widget_set_sensitive(GTK_WIDGET(tm->gtk->tool_zoom_out), FALSE);
    }
  }
}

void orig (TM *tm) {
  if (GDK_IS_PIXBUF(tm->gtk->pixbuf_orig)) {
    if (tm->gtk->image != NULL) {
      gtk_widget_destroy(tm->gtk->image);
    }
    tm->gtk->image = gtk_image_new_from_pixbuf(tm->gtk->pixbuf_orig);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(tm->gtk->scrolled), tm->gtk->image);
    gtk_widget_show(tm->gtk->image);
    put_status(tm);
  }
}
