/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

void put_manual () {
  GtkWidget *window, *grid, *scrolled, *sgrid, *button;
  GtkWidget **label;
  int i;

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "NeonView Manual");
  gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  gtk_widget_set_size_request(window, 520, 480);
  gtk_window_set_resizable(GTK_WINDOW(window), FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(window), 10);

  grid = gtk_grid_new();
  gtk_widget_set_vexpand(grid, TRUE);
  gtk_container_add(GTK_CONTAINER(window), grid);
  scrolled = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_add(GTK_CONTAINER(grid), scrolled);
  sgrid = gtk_grid_new();
  gtk_widget_set_vexpand(sgrid, TRUE);
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled), sgrid);

  label = malloc(10 * sizeof(GtkWidget *));
  if (!label) {
    criterr(0);
  }

  char *str[] = {"<b>NeonView Manual v0.8.1</b>\n\n",
		 "<b>Introduction</b>\nNeonView is a fast, lightweight image viewer for Linux written in C and using the GTK+ 3 toolkit. It has support for over 30 image formats, including the most popular ones like JPG, PNG, SVG, TGA, TIFF, GIF and ANI. NeonView thrives for simplicity, while the same time providing some basic features like thumbnail previews, image manipulation functions like rotating, zooming, as well as configuration options to customize the interface and the way the program behaves. NeonView will remember configuration changes between sessions, it will save the window size and it will remember whether images should be displayed at full size rather than resized to fit the window.\n\n",
		 "<b>Features</b>\nSee the features.html file which came in the NeonView package.\n\n",
		 "<b>Supported formats</b>\nNeonView doesn't do any image parsing or format recognition by itself, instead all that is done by GdkPixbuf. Any format supported by GdkPixbuf is supported by NeonView. The following formats are currently supported:\n\nPNG\tICO\tCUR\tANI\tRAS\nPCX\tXBM\tTGA\tSVG\tJPG\nTIFF\tXPM\tBMP\tPNM\tPBM\nPGM\tPPM\tQIF\tJPC\tJPX\nJ2K\tJPF\tJPX\tGIF\tICNS\n\n",
		 "<b>Configuration</b>\n Most of the configuration options can be changed from within NeonView itself via the <i>Tools->Settings</i> window, however there are several options which can only be changed in the configuration file, which is located at <i>~/.neonview/neonview.cfg</i>, where <i>~</i> is your home directory (e.g. <i>/home/user/.neonview/neonview.cfg</i>). This file is a text file and can be edited with any text editor. NeonView saves its settings into this file when it exits and loads all the options from it when it starts up. If the file is corrupted, NeonView will proceed with default settings. You are encouraged to edit this file since any bad editing will not break NeonView. NeonView will echo to the standard output (run it in the console to see the output) any error it may find in this file. Everything after the <i>#</i> character is a comment and will be ignored by NeonView. Every line should have the form <i>KEY=\"VALUE\"</i>, however double-quotes are not mandatory, and spaces can be used too since NeonView will strip those when interpreting the file.\n\n",
		 "<b>Feature requests, bugs and suggestions</b>\nFor feature requests, bug reports or suggestions you have several options:\n\nSubmit them on the website via post comments at:\n\n\t<a href=\"http://www.tuxarena.com/neonview/\">http://www.tuxarena.com/neonview/</a>\n\nUse the forum at:\n\n\t<a href=\"http://www.tuxarena.com/forum/\">http://www.tuxarena.com/forum/</a>\n\nContact me at:\n\n\t<a href=\"mailto:craciun.dan@tuxarena.com\">craciun.dan@tuxarena.com</a>\n\n"};

  for (i = 0; i < 6; i++) {
    label[i] = gtk_label_new(NULL);
    gtk_label_set_markup(GTK_LABEL(label[i]), str[i]);
  }

  for (i = 0; i < 6; i++) {
    gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0);
    gtk_grid_attach(GTK_GRID(sgrid), label[i], 0, i, 1, 1);
    gtk_label_set_max_width_chars(GTK_LABEL(label[i]), 54);
    gtk_label_set_line_wrap(GTK_LABEL(label[i]), TRUE);
    gtk_label_set_line_wrap_mode(GTK_LABEL(label[i]), PANGO_WRAP_WORD_CHAR);
  }

  button = gtk_button_new_with_label("OK");
  gtk_widget_set_margin_top(button, 10);
  gtk_widget_set_hexpand(button, TRUE);
  gtk_grid_attach(GTK_GRID(grid), button, 0, 1, 1, 1);
  g_signal_connect_swapped(button, "clicked", G_CALLBACK(gtk_widget_destroy), window);

  GtkAccelGroup *accel_group;
  accel_group = gtk_accel_group_new();
  gtk_window_add_accel_group(GTK_WINDOW(window), accel_group);
  gtk_widget_add_accelerator(button, "clicked", accel_group, GDK_KEY_Escape, 0, GTK_ACCEL_VISIBLE);

  gtk_widget_show_all(window);
}

void put_faq () {
  GtkWidget *window, *grid, *scrolled, *sgrid, *button;
  GtkWidget **label;

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "NeonView FAQ");
  gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  gtk_widget_set_size_request(window, 480, 520);
  //  gtk_window_set_resizable(GTK_WINDOW(window), FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(window), 10);

  grid = gtk_grid_new();
  gtk_widget_set_vexpand(grid, TRUE);
  gtk_container_add(GTK_CONTAINER(window), grid);
  scrolled = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_add(GTK_CONTAINER(grid), scrolled);
  sgrid = gtk_grid_new();
  gtk_widget_set_vexpand(sgrid, TRUE);
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled), sgrid);

  label = malloc(10 * sizeof(GtkWidget *));
  if (!label) {
    criterr(0);
  }

  char *str1 = "<b>NeonView FAQ v0.8.0</b>\n\n";
  label[0] = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(label[0]), str1);

  char *str2 = "<b>What is it with these codenames? What do they stand for?</b>\nThe codenames are inspired by the genus or species name of various fish.\n\n";
  label[1] = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(label[1]), str2);

  char *str3 = "<b>Why does NeonView start maximized when the <i>Start maximized</i> option is disabled?</b>\nNeonView always remembers the size of the main window. So if you close NeonView and it is maximized, the next time it starts the window will remember the last sizes for width and height, even though the <i>Start maximized</i> option is disabled. To prevent it from doing so and always start with the default, hard-coded size, uncheck the <i>Remember window size</i> option too in <i>Tools->Settings</i>.\n\n";
  label[2] = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(label[2]), str3);

  char *str4 = "<b>How does NeonView handle images?</b>\nNeonView supports all formats handled by GdkPixbuf, so it doesn't interpret images by itself. No code regarding format recognition is involved, everything is being taken care of by GdkPixbuf. Since 0.8.0, NeonView correctly displays animated GIF files too.\n\nSupported formats include JPG, PNG, SVG, GMP, TGA, TIFF, GIF, ICO and ANI.\n\n";
  label[3] = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(label[3]), str4);

  char *str5 = "<b>Is there any configuration file available?</b>\nYes. The file is called <i>~/.neonview/neonview.cfg</i>, where <i>~</i> is your home directory (e.g. <i>/home/user</i>). In this file you can tweak several options that cannot be changed from within NeonView.\n\n";
  label[4] = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(label[4]), str5);

  char *str6 = "<b>Can I disable the left and right panels?</b>\nYes. You can do so by unchecking the respective options in the <i>Tools</i> menu, or by settings <i>show_left_panel</i> and <i>show_right_panel</i> options to <i>\"no\"</i> in the configuration file. The same applies for the toolbar and the status bar.\n\n";
  label[5] = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(label[5]), str6);

  char *str7 = "<b>Is there a Windows port?</b>\nNot yet, but chances are a port will be made, probably when NeonView hits version 1.0. No ports for Mac OS are planned yet. No ports for mobile platforms are planned yet either, but this may change though.\n\n";
  label[6] = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(label[6]), str7);

  char *str8 = "<b>On what platforms can I run NeonView?</b>\nNeonView is written in C and GTK+ 3 and it has only been tested in Linux (Debian 7.0 Wheezy, Ubuntu 12.04, Linux Mint 14). It works fine on these operating systems.\n\n";
  label[7] = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(label[7]), str8);

  char *str9 = "<b>What license does NeonView use?</b>\nGPLv2. This means you are free to modify and redistribute NeonView as long as you keep the same license terms for your derivative work. Please give me credit for my work.\n\n";
  label[8] = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(label[8]), str9);

  char *str10 = "<b>Does it work on older Linux distributions?</b>It should, depending on whether GTK+ 3 is installed.\n\n";
  label[9] = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(label[9]), str10);

  int i;
  for (i = 0; i < 9; i++) {
    gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0);
    gtk_grid_attach(GTK_GRID(sgrid), label[i], 0, i, 1, 1);
    gtk_label_set_max_width_chars(GTK_LABEL(label[i]), 54);
    gtk_label_set_line_wrap(GTK_LABEL(label[i]), TRUE);
    gtk_label_set_line_wrap_mode(GTK_LABEL(label[i]), PANGO_WRAP_WORD_CHAR);
  }

  button = gtk_button_new_with_label("OK");
  gtk_widget_set_margin_top(button, 10);
  gtk_widget_set_hexpand(button, TRUE);
  gtk_grid_attach(GTK_GRID(grid), button, 0, 1, 1, 1);
  g_signal_connect_swapped(button, "clicked", G_CALLBACK(gtk_widget_destroy), window);

  GtkAccelGroup *accel_group;
  accel_group = gtk_accel_group_new();
  gtk_window_add_accel_group(GTK_WINDOW(window), accel_group);
  gtk_widget_add_accelerator(button, "clicked", accel_group, GDK_KEY_Escape, 0, GTK_ACCEL_VISIBLE);

  gtk_widget_show_all(window);
}

void put_homepage () {
  if (xfile("/usr/bin/firefox")) {
    system("firefox http://www.tuxarena.com/neonview/ &");
    return;
  }
  if (xfile("/usr/bin/google-chrome")) {
    system("google-chrome http://www.tuxarena.com/neonview/ &");
    return;
  }
  if (xfile("/usr/bin/opera")) {
    system("opera http://www.tuxarena.com/neonview/ &");
    return;
  }
  if (xfile("/usr/bin/konqi")) {
    system("konqi http://www.tuxarena.com/neonview/ &");
    return;
  }
  if (xfile("/usr/bin/epiphany-browser")) {
    system("epiphany-browser http://www.tuxarena.com/neonview/ &");
    return;
  }
  if (xfile("/usr/bin/konqueror")) {
    system("konqueror http://www.tuxarena.com/neonview/ &");
    return;
  }
  if (xfile("/usr/bin/dillo")) {
    system("dillo http://www.tuxarena.com/neonview/ &");
    return;
  }
  if (xfile("/usr/bin/xterm")) {
    if (xfile("/usr/bin/w3m")) {
      system("xterm -e w3m http://www.tuxarena.com/neonview/ &");
      return;
    }
    if (xfile("/usr/bin/lynx")) {
      system("xterm -e lynx http://www.tuxarena.com/neonview/ &");
      return;
    }
  }
}

void put_about () {
  GtkWidget *window, *grid;
  GtkWidget *name, *desc, *author, *site;
  GtkWidget *button;

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "About NeonView");
  gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  gtk_widget_set_size_request(window, 340, 180);
  gtk_window_set_resizable(GTK_WINDOW(window), FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(window), 10);

  grid = gtk_grid_new();
  gtk_container_add(GTK_CONTAINER(window), grid);

  char *markup;

  name = gtk_label_new(NULL);
  markup = g_markup_printf_escaped("<b>%s %s '%s'</b>", NAME, VERSION, CODENAME);
  gtk_label_set_markup(GTK_LABEL(name), markup);
  gtk_widget_set_margin_top(name, 10);
  gtk_grid_attach(GTK_GRID(grid), name, 0, 0, 1, 1);

  desc = gtk_label_new(NULL);
  markup = g_markup_printf_escaped("A lightweight image viewer");
  gtk_label_set_markup(GTK_LABEL(desc), markup);
  gtk_widget_set_margin_top(desc, 10);
  gtk_grid_attach(GTK_GRID(grid), desc, 0, 1, 1, 1);

  author = gtk_label_new(NULL);
  markup = g_markup_printf_escaped("Copyright (C) 2011-2013 Craciun Dan");
  gtk_label_set_markup(GTK_LABEL(author), markup);
  gtk_widget_set_margin_top(author, 10);
  gtk_grid_attach(GTK_GRID(grid), author, 0, 2, 1, 1);

  site = gtk_label_new(NULL);
  markup = g_markup_printf_escaped("<a href=\"http://www.tuxarena.com/neonview/\">http://www.tuxarena.com/neonview/</a>");
  gtk_label_set_markup(GTK_LABEL(site), markup);
  gtk_widget_set_margin_top(site, 10);
  gtk_grid_attach(GTK_GRID(grid), site, 0, 3, 1, 1);

  button = gtk_button_new_with_label("OK");
  gtk_widget_set_hexpand(button, TRUE);
  gtk_widget_set_margin_top(button, 10);
  gtk_grid_attach(GTK_GRID(grid), button, 0, 4, 1, 1);
  g_signal_connect_swapped(button, "clicked", G_CALLBACK(gtk_widget_destroy), window);

  gtk_widget_modify_font(GTK_WIDGET(name), pango_font_description_from_string("DejaVu Sans 13"));
  gtk_widget_modify_font(GTK_WIDGET(desc), pango_font_description_from_string("DejaVu Sans 12"));
  gtk_widget_modify_font(GTK_WIDGET(author), pango_font_description_from_string("DejaVu Sans 10"));
  gtk_widget_modify_font(GTK_WIDGET(site), pango_font_description_from_string("DejaVu Sans 12"));

  GtkAccelGroup *accel_group;
  accel_group = gtk_accel_group_new();
  gtk_window_add_accel_group(GTK_WINDOW(window), accel_group);
  gtk_widget_add_accelerator(button, "clicked", accel_group, GDK_KEY_Escape, 0, GTK_ACCEL_VISIBLE);

  gtk_widget_show_all(grid);
  gtk_widget_show(window);
}
