/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <strings.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#ifdef __gnu_linux__
  #include <sys/types.h>
  #include <pwd.h>
#elif _WIN32
  #include <windows.h>
#endif

#include <gtk/gtk.h>

/* program info */
#define NAME "NeonView"
#define VERSION "0.8.2"
#define HTTP "http://www.tuxarena.com/neonview/"
#define CODENAME "Ancistrus"
#define DATE "Feb 27, 2013"
#define LICENSE "GPLv2"
#define AUTHOR "Craciun Dan"
#define MAIL "craciun.dan@tuxarena.com"

#define PATH_LENGTH 4096

typedef struct env {
  char cwd[PATH_LENGTH + 1]; // current working directory - full path from which the program was launched
  char *home; // home dir - full path as returned by getpwuid()
  char *config_dir; // config dir - full path e.g. /home/user/.neonview
  char *config_file; // config file - full path e.g. /home/user/.neonview/neonview.cfg
} ENV;

typedef struct list {
  char *full_path;
  char *basename;
  char type[6];
  int width;
  int height;
  long size; // bytes
} LS;

typedef struct img {
  char *argv1; // tm->argv[1]
  char *image_full_path;
  char *image_dirname;
  char *image_basename;
  char type[6];

  int total; // total number of images in the current directory
  int pos; // position of currently displayed image
  int scaled;
  int it; // iterator for thumbnails panel

  LS **ls;
} IMG;

typedef struct gtk {
  GtkWidget *window;
  GtkWidget *grid1, *grid11, *grid12, *grid13, *grid13a, *grid13b, *grid13c, *grid14;
  GtkWidget *menubar, *menu_prev, *menu_next, *menu_fit, *menu_orig, *zoom_in, *zoom_out, *menu_left, *menu_right, *menu_flip;
  GtkWidget *show_toolbar, *show_status, *show_left_panel, *show_right_panel;
  GtkWidget *toolbar;
  GtkToolItem *tool_prev, *tool_next, *tool_orig, *tool_fit, *tool_zoom_in, *tool_zoom_out;
  GtkWidget *scrolled;
  GtkWidget *notebook1, *notebook2; // notebooks for the panels
  GtkWidget **button;

  GdkPixbuf *pixbuf;
  GdkPixbuf *pixbuf_orig;
  GdkPixbufAnimation *animation;
  GdkPixbufAnimation *animation_orig;
  GtkWidget *image;

  GtkWidget *window_settings;

  GtkWidget *entry21, *entry22, *entry23, *entry24;
  GtkWidget *status1, *status2, *status3, *status4;
} GTK;

typedef struct cfg {
  char last_dir[PATH_LENGTH + 1];
  char start_dir[PATH_LENGTH + 1];
  int window_width;
  int window_height;
  int window_min_width;
  int window_min_height;
  char start_maximized[4];
  char show_toolbar[4];
  char show_status[4];
  char show_left_panel[4];
  char show_right_panel[4];
  char remember_fit[4];
  char lock_fit[4];
  char remember_zoom[4];
  char remember_window_size[4];
  char window_title[81];
  char gtk_win_pos[29];

  char tmp_start_maximized[4];
  char tmp_remember_window_size[4];
  char tmp_remember_fit[4];
  char tmp_lock_fit[4];
  int settings;
} CFG;

typedef struct master {
  char **argv;
  int argc;

  ENV *env;
  CFG *cfg;
  IMG *img;
  GTK *gtk;
} TM;

/* err.c */
void criterr (unsigned short);

/* init.c */
void init_args (TM *);
void init_struct (TM *);

/* env.c */
void get_cwd (TM *);
void get_home (TM *);
void get_config_dir (TM *);
void get_config_file (TM *);

/* config.c */
void init_keys (TM *);
void read_config (TM *);
int mk_config_dir (TM *);
int mk_config_file (TM *);
void print_config (TM *);
void assign_keys (TM *, char *, char *);
void write_config (TM *);

/* stdc.c */
char *lc (char *);
char *uc (char *);
char *rts (char *);
char *strip (char *);
int all_digits (char *);
long filesize (char *);
int rfile (char *);
int xfile (char *);
int digits (int);

/* utils.c */
void get_dirname (TM *, char *);
void fill_image_list (TM *);
void print_image_list (TM *);
void print_all (TM *);
void sort_list_by_name (TM *);
void get_position (TM *, char *);
int check_extension (TM *, char *);

/* gtkutils.c */
int get_win_pos (char *);
void gtk_neon_quit (TM *);

/* window.c */
void put_window (TM *);

/* menubar.c */
void put_menubar (TM *);
void toggle_toolbar (TM *);
void toggle_status (TM *);
void toggle_left_panel (TM *);
void toggle_right_panel (TM *);

/* toolbar.c */
void put_toolbar (TM *);

/* status.c */
void put_status (TM *);
void destroy_status (TM *);

/* panels.c */
void put_scrolled (TM *);
void put_left_panel (TM *);
void put_right_panel (TM *);

/* settings.c */
void put_settings (TM *);
void settings_cancel (TM *);
void settings_ok (TM *);
void toggle_start_maximized (TM *, GtkWidget *);
void toggle_remember_window_size (TM *, GtkWidget *);
void toggle_remember_fit (TM *, GtkWidget *);
void toggle_lock_fit (TM *, GtkWidget *);

/* image.c */
void show_image (TM *);
void show_thumbnail (TM *, GtkWidget *);
void show_prev (TM *);
void show_next (TM *);
void init_widgets (TM *);
void fit_to_window (TM *);
void show_image_fit (TM *);
void init_scaled (TM *);
void show_hint00 (GtkWidget *);
void show_hint11 (GtkWidget *);
void show_hint12 (GtkWidget *);
void show_hint21 (GtkWidget *);
void show_hint22 (GtkWidget *);
void rotate_left (TM *);
void rotate_right (TM *);
void flip (TM *);
void zoom_in (TM *);
void zoom_out (TM *);
void orig (TM *);

/* open.c */
void put_open (TM *);

/* help.c */
void put_manual ();
void put_faq ();
void put_homepage ();
void put_about ();
