/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

int check_extension (TM *tm, char *str) {
  int i, j, stop;
  char ext[256];

  i = strlen(str) - 1;
  j = 0;

  stop = 0;
  while (i >= 0 && stop == 0) {
    if (str[i] != '.') {
      ext[j] = str[i];
      ext[j+1] = '\0';
      j++;
    } else {
      ext[j] = '\0';
      stop = 1;
    }
    i--;
  }

  ext[j] = '\0';

  if (i == 0) {
    return 0; // file has no extension
  }

  rts(ext);
  lc(ext);

  char * const list[] = { "png", "ico", "cur", "ani", "ras", "pcx", "xbm", "tga", "svg", "svgz",
		   "jpeg", "jpe", "jpg", "tiff", "tif", "xpm", "bmp", "pnm", "pbm", "pgm",
		   "ppm", "qtif", "qif", "j2k", "jpf", "wbmp", "gif", "icns" };
  for (i = 0; i < 28; i++) {
    if (strcmp(ext, list[i]) == 0) {
      if (strcmp(ext, "gif") == 0) {
	uc(ext);
	strcpy(tm->img->type, ext);
	return 2;
      } else {
	uc(ext);
	strcpy(tm->img->type, ext);
	return 1;
      }
    }
  }

  return 0;
}
