/*
Copyright (C) 2011, 2012, 2013 Craciun Dan <craciun.dan@tuxarena.com>

This file is part of NeonView.

NeonView is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

NeonView is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NeonView.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "header.h"

void get_cwd (TM *tm) {
  char *rv;

  rv = getcwd(tm->env->cwd, sizeof(tm->env->cwd));
  if (!rv) {
    criterr(1);
  }
}

void get_home (TM *tm) {
  struct passwd *pw;

  pw = getpwuid(getuid());
  tm->env->home = malloc(strlen(pw->pw_dir) + 1);
  if (!tm->env->home) {
    criterr(0);
  }
  strcpy(tm->env->home, pw->pw_dir);
}

void get_config_dir (TM *tm) {
  tm->env->config_dir = malloc(strlen(tm->env->home) + strlen("/.neonview") + 1);
  if (!tm->env->config_dir) {
    criterr(0);
  }
  strcpy(tm->env->config_dir, tm->env->home);
  strcat(tm->env->config_dir, "/.neonview");
}

void get_config_file (TM *tm) {
  tm->env->config_file = malloc(strlen(tm->env->config_dir) + strlen("/.neonview.cfg") + 1);
  if (!tm->env->config_file) {
    criterr(0);
  }
  strcpy(tm->env->config_file, tm->env->config_dir);
  strcat(tm->env->config_file, "/neonview.cfg");
}
