/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


select_move(int x, int y)
{
	int rel_x = x - user_x;
	int rel_y = y - user_y;
	*dom_obj_x(0) += rel_x;
	*dom_obj_y(0) += rel_y;
	user_x += rel_x;
	user_y += rel_y;

	object_merge_area_step(
		-offset_x(0) + *dom_obj_x(0) - 50,
		-offset_y(0) + *dom_obj_y(0) - 50,
		*dom_obj_w(0) + 50,
		*dom_obj_h(0) + 50
	);

	statusbar_msg = 2;
	fixed_obj_move();

	if(gdk_events_pending()) return;
	int area[4];
	offset_area(area);
	object_merge_area(area[0], area[1], area[2], area[3]);
}
