/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


uchar brush_softer(double brush_radio, double dist1, double dist2)
{
	double dist;
	if(dist2 != -1)
	{
		if(dist1>dist2) dist = dist1;
		else dist = dist2;
	}
	else dist = dist1;

	double brush_fade_double = (double)brush_fade;
	double brush_opacity_char = 255 * (double)brush_opacity / 100;
	double soft_pos = brush_radio / 100 * (100-brush_fade_double);
	if(dist<=soft_pos) return (uchar)brush_opacity_char;
	if(dist>brush_radio) return 0;
	double soft_area = brush_radio - soft_pos;
	double dist_area = dist - soft_pos;
	double sin_area = dist_area * 3.2 / soft_area;
	sin_area = (sin(sin_area + 1.6) + 1) * 127.5;
	sin_area = sin_area * brush_opacity / 100;
	return (uchar)sin_area;
}


void brush_new()
{
	free(brush_raw);
	brush_raw = (uchar*)malloc(brush_size * brush_size * 4 *sizeof(uchar));
	int x, y;
	double brush_size_double = (double)brush_size;
	double brush_radio = brush_size_double/2;

	for(y=0; y<brush_size; y++)
	{
		for(x=0; x<brush_size; x++)
		{
			int brush_pos = pixel_pos(x, y, brush_size);
			brush_raw[ brush_pos+0 ] = color1[0];
			brush_raw[ brush_pos+1 ] = color1[1];
			brush_raw[ brush_pos+2 ] = color1[2];
			double dist_x = (double)x - brush_radio + 0.5;
			double dist_y = (double)y - brush_radio + 0.5;

			if(brush_mode==0)
			{
				brush_raw[ brush_pos+3 ] = brush_softer(brush_radio, abs(dist_x), abs(dist_y));
			}

			if(brush_mode==1)
			{
				double dist = sqrt( (dist_x*dist_x) + (dist_y*dist_y) );
				brush_raw[ brush_pos+3 ] = brush_softer(brush_radio, dist, -1);
			}
		}
	}
	fixed_brush_update();
}

void brush_stroke(int x, int y)
{
	over_object(
		dom_obj_raw(0),
		brush_raw,
		*dom_obj_w(0),
		*dom_obj_h(0),
		offset_x(x) - (brush_size/2) - *dom_obj_x(0),
		offset_y(y) - (brush_size/2) - *dom_obj_y(0),
		brush_size,
		brush_size,
		offset_x(x) - (brush_size/2) - *dom_obj_x(0),
		offset_y(y) - (brush_size/2) - *dom_obj_y(0),
		brush_size,
		brush_size,
		OVER_ADD
	);
	object_merge_area(x-(brush_size/2), y-(brush_size/2), brush_size, brush_size);
}


void brush_spacer(int x, int y, int traceStart)
{
	int brush_last_x = 0;
	int brush_last_y = 0;
	int brushSpace = ceil((double)brush_size / 10);
	if(traceStart)
	{
		brush_stroke(x,y);
		user_x = 0;
		user_y = 0;
	}
	if(user_x==0 && user_y==0)
	{
		user_x = x;
		user_y = y;
	}
	int ox = x - user_x;
	int oy = y - user_y;
	int dist = round( sqrt( (ox*ox) + (oy*oy) ) );

	if(brush_space==2) brush_stroke(x,y);

	else if(dist>brushSpace || brush_space==0)
	{
		double traceNeed = (double)dist / brushSpace;
		double traceStepX = (double)ox/traceNeed;
		double traceStepY = (double)oy/traceNeed;
		int i;
		for(i=1; i<traceNeed; i++)
		{
			double traceX = round( (traceStepX * i) + user_x );
			double traceY = round( (traceStepY * i) + user_y );
			brush_stroke(traceX, traceY);
			brush_last_x = traceX;
			brush_last_y = traceY;
		}
	}
	else brush_stroke(x,y);

	if(brush_last_x) user_x = brush_last_x;
	if(brush_last_y) user_y = brush_last_y;
}


brush_size_motion(int x, int y)
{
	int x_rel = user_x - x;
	int y_rel = user_y - y;
	brush_size -= x_rel;
	brush_size += y_rel;
	if(brush_size > brush_size_max) brush_size = brush_size_max;
	if(brush_size < 1) brush_size = 1;
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_brush_size), brush_size);
	user_x -= x_rel;
	user_y -= y_rel;
	statusbar_msg = 1;
}
