/*
 *  Nathive, The Usable Image Editor
 *  Copyright (C) 2008-2009 Marcos Díaz Mencía <http://www.nathive.org/>
 *
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


#define VERSION "0.813 Alpha"
#define SUBVERSION "portable"
#define PATH "./"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "lib/n-tree.c"


//constants
#define TOOLS 4
#define DIALOG_BTN_WIDTH 100


//macros
#define DOM_PATH 0
#define DOM_W 1
#define DOM_H 2
#define DOM_SCROLL 3
#define DOM_PIX 4
#define DOM_IMG 5
#define DOM_RAW 6
#define DOM_OBJ 7
#define DOM_PRE 8
#define DOM_OBJGUI 9
#define DOM_ALIGN 10
#define DOM_FIXED 11
#define DOM_VISUAL 12

#define OBJ_RAW 0
#define OBJ_W 1
#define OBJ_H 2
#define OBJ_X 3
#define OBJ_Y 4

#define PRE_MOSAIC 0

#define OVER_REPLACE 0
#define OVER_ADD 1

#define TOOL_SELECT 0
#define TOOL_MASK 1
#define TOOL_PICKER 2
#define TOOL_BRUSH 3


//types
typedef unsigned char uchar;
typedef unsigned int uint;
typedef long int lint;


//globals
#include "gb/global.c"
#include "gb/dialog-new.c"
#include "gb/brush.c"


//commons
#include "lib/common.c"
#include "lib/itoa.c"
#include "lib/n-xml.c"
#include "lib/dom.c"
#include "lib/cfg.c"
#include "lib/rgbhsv.c"
#include "lib/rgbhex.c"
#include "lib/unit.c"
#include "lib/pixel.c"
#include "lib/over.c"


//tools
#include "tool/select.c"
#include "tool/picker.c"
#include "tool/brush.c"


//user interface
#include "lib/language.c"
#include "lib/gui/misc.c"
#include "lib/gui/event.c"
#include "lib/gui/object.c"
#include "lib/gui/tab.c"
#include "lib/gui/fixed.c"
#include "lib/gui/dialog.c"
#include "lib/gui/call.c"
#include "lib/gui/entry.c"
#include "lib/gui/menu.c"
#include "lib/gui/scroll.c"
#include "lib/gui/offset.c"
#include "lib/gui/cursor.c"
#include "lib/gui/color.c"
#include "lib/gui/clear.c"
#include "lib/gui/statusbar.c"
#include "lib/gui/other.c"
#include "gui/gui-main.c"


//main
int main(int argc, char *argv[])
{
	dom = n_tree_new();

	printf("\nNathive Project %s (%s)\n", VERSION, SUBVERSION);
	printf("> loading from %s\n", PATH);
	printf("> libraries loaded\n");

	cfg_load();
	language_load();
	brush_new();

	gui_main(argc, argv);
	return 0;
}
