/* 
 *  This file is part of Nathive.
 * 
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */
 

double px_to_cm(int px, int dpi)
{
	return (double)px / (double)dpi * 2.54;
}

int cm_to_px(double cm, int dpi)
{
	return (double)cm * (double)dpi / 2.54;
}

double px_to_in(int px, int dpi)
{
	return (double)px / (double)dpi;
}

int in_to_px(double in, int dpi)
{
	return (double)in * (double)dpi;
}

double cm_to_in(double cm)
{
	return cm / 2.54;
}

double in_to_cm(double in)
{
	return in * 2.54;
}
