/* 
 *  This file is part of Nathive.
 * 
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */
 

int *rgb_to_hsv(uchar r, uchar g, uchar b)
{
	uchar max = r;
	if(g>max) max = g;
	if(b>max) max = b;
	
	uchar min = r;
	if(g<min) min = g;
	if(b<min) min = b;
	
	int h,s,v;
	
	double gbmm = ((double)g-b) / (max-min);
	double brmm = ((double)b-r) / (max-min);
	double rgmm = ((double)r-g) / (max-min);
	if(max==min) h = 0;
	if(max==r)
	{
		if(g>=b) h = round( ( 60.0 * gbmm ) + 0.0 );
		if(g<b) h = round( ( 60.0 * gbmm ) + 360.0 );
	}
	if(max==g) h = round( ( 60.0 * brmm ) + 120.0 );
	if(max==b) h = round( ( 60.0 * rgmm ) + 240.0 );

	s = round((1.0 - ((double)min/max)) * 100.0);
	v = round(100.0 * max / 255.0);

	int *hsv = (int*)malloc(3*sizeof(int));
	hsv[0] = h;
	hsv[1] = s;
	hsv[2] = v;
	return hsv;
}


uchar *hsv_to_rgb(double h, double s, double v)
{
	s /= 100.0;
	v /= 100.0;
	double hi = 6.0;
	modf( floor(h/60.0), &hi);
	double f = (h/60.0) - hi;
	double p = v*(1-s);
	double q = v*(1-(f*s));
	double t = v*(1-((1-f)*s));
	
	double r, g, b;
	if(hi==0){	r = v;	g = t; 	b = p; }
	if(hi==1){	r = q;	g = v; 	b = p; }
	if(hi==2){	r = p;	g = v; 	b = t; }
	if(hi==3){	r = p;	g = q; 	b = v; }
	if(hi==4){	r = t;	g = p; 	b = v; }
	if(hi==5){	r = v;	g = p; 	b = q; }
	
	uchar *rgb = (uchar*)malloc(3*sizeof(uchar));
	rgb[0] = round( 255.0 * r );
	rgb[1] = round( 255.0 * g );
	rgb[2] = round( 255.0 * b );
	return rgb;
}
