/* 
 *  This file is part of Nathive.
 * 
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */
 

int hex_to_int(char hex)
{
	if(hex>=48 && hex<=57) return (hex-48); // 0 to 9
	if(hex>=65 && hex<=70) return (hex-55); // a to f
	if(hex>=97 && hex<=102) return (hex-87); // A to F
}


uchar *hex_to_rgb(char *hex)
{	
	int r = (hex_to_int(hex[0])*16) + hex_to_int(hex[1]);
	int g = (hex_to_int(hex[2])*16) + hex_to_int(hex[3]);
	int b = (hex_to_int(hex[4])*16) + hex_to_int(hex[5]);
	
	uchar *rgb = (uchar*)malloc(3*sizeof(uchar));
	rgb[0] = r;
	rgb[1] = g;
	rgb[2] = b;
	return rgb;
}


char int_to_hex(int in) // input from 0 to 15
{
	if(in>=0 && in<=9) return 48+in;
	if(in>=10 && in<=15) return 87+in;
	return 48;
}


char *uchar_to_hex(uchar u, char hex[]) //input from 0 to 255
{
	char a = int_to_hex( u/16 );
	char b = int_to_hex( u%16 );
	sprintf(hex, "%c%c", a, b);
	return hex;
}


char *rgb_to_hex(uchar r, uchar g, uchar b) // return must be freed
{
	char *hex = (char*)malloc(6*sizeof(char));
	char *rhex = (char*)malloc(2*sizeof(char));
	char *ghex = (char*)malloc(2*sizeof(char));
	char *bhex = (char*)malloc(2*sizeof(char));
	uchar_to_hex(r, rhex);
	uchar_to_hex(g, ghex);
	uchar_to_hex(b, bhex);
	sprintf(hex, "%s%s%s", rhex, ghex, bhex);
	free(rhex);
	free(ghex);
	free(bhex);
	return hex;
}
