/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


uchar over_color(uchar base, uchar over, uchar base_opa, uchar over_opa)
{
	//base += ((int)255-base_opa) * (over-base) / 255;
	//return ( (base*((int)255-over_opa)) + (over*over_opa) ) / 255;
	return
	(
		(
			(base + ( (int)255-base_opa)*(over-base)/255 )
			*
			((int)255-over_opa)
		)
		+
		(over*over_opa)
	)
	/
	255;
}


uchar over_opacity(uchar base_opa, uchar over_opa)
{
	int ret = base_opa + ((255-base_opa)*over_opa/255);
	if(ret > 255) ret = 255;
	return ret;
}


void over_object(uchar *base, uchar *over, int base_w, int base_h, int over_x, int over_y,
                 int over_w, int over_h, int area_x, int area_y, int area_w, int area_h, int mode)
{
	int over_rel = pixel_pos(over_x, over_y, base_w);
	int area_rel = pixel_pos(area_x-over_x, area_y-over_y, over_w);

	int same_line = FALSE;
	int base_pos, over_pos;

	int xx, yy;
	for(yy=0; yy<area_h; yy++)
	{
		same_line = FALSE;
		for(xx=0; xx<area_w; xx++)
		{
			if(yy + area_y - over_y < 0) continue;
			if(xx + area_x - over_x < 0) continue;
			if(yy + area_y - over_y >= base_h) continue;
			if(xx + area_x - over_x >= base_w) continue;

			if(yy+area_y < 0) continue;
			if(xx+area_x < 0) continue;
			if(yy+area_y >= base_h) continue;
			if(xx+area_x >= base_w) continue;

			if(same_line)
			{
				base_pos += 4;
				over_pos += 4;
			}
			else
			{
				base_pos = pixel_pos(xx,yy,base_w) + over_rel + area_rel;
				over_pos = pixel_pos(xx,yy,over_w) + area_rel;
				same_line = TRUE;
			}

			if(mode==OVER_REPLACE)
			{
				base[base_pos+0] = over[over_pos+0];
				base[base_pos+1] = over[over_pos+1];
				base[base_pos+2] = over[over_pos+2];
				base[base_pos+3] = over[over_pos+3];
				continue;
			}

			if(mode==OVER_ADD)
			{
				if(over[over_pos+3] == 0) continue;

				if(over[over_pos+3] == 255)
				{
					base[base_pos+0] = over[over_pos+0];
					base[base_pos+1] = over[over_pos+1];
					base[base_pos+2] = over[over_pos+2];
					base[base_pos+3] = over[over_pos+3];
				}
				else
				{
					base[base_pos+0] = over_color(base[base_pos+0], over[over_pos+0], base[base_pos+3], over[over_pos+3]);
					base[base_pos+1] = over_color(base[base_pos+1], over[over_pos+1], base[base_pos+3], over[over_pos+3]);
					base[base_pos+2] = over_color(base[base_pos+2], over[over_pos+2], base[base_pos+3], over[over_pos+3]);
					base[base_pos+3] = over_opacity(base[base_pos+3], over[over_pos+3]);
				}
				continue;
			}
		}
	}
}
