/* 
 *  This file is part of Nathive.
 * 
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */
 

char *n_xml_get(char *xml, int n, ...) // must be rewritten with libxml2
{
	va_list va;
	va_start(va, n);	
	int i;
	for(i=0; i<n; i++) 
	{
		char *tag = va_arg(va, char*);
		
		char open[strlen(tag)+3];
		char close[strlen(tag)+4];
		snprintf(open, strlen(tag)+3, "<%s>", tag);
		snprintf(close, strlen(tag)+4, "</%s>", tag);
	
		xml = parse(xml, open, close);
	}
	return xml;
}
