/* 
 *  This file is part of Nathive.
 * 
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */
 

struct _NTree
{
	void *data;
	int is_stalk;
	struct _NTree *next;
};
typedef struct _NTree NTree;


NTree *n_tree_new()
{
	NTree *new = (NTree*)malloc(sizeof(NTree));
	new->data = NULL;
	new->is_stalk = TRUE;
	new->next = NULL;
	return new;
}


void *n_tree_stalk_get( NTree *tree, int stalk)
{
	if(stalk<0) stalk = 0;
	int i;
	for(i=0; i<stalk+1; i++) tree = tree->next;
	if(tree->data==NULL) printf("ERROR: n_tree_stalk_get: data is null\n");
	if(tree->is_stalk==0) printf("ERROR: n_tree_stalk_get: data is not stalk\n");
	return tree->data;
}


void n_tree_add( NTree *tree, int stalk[], void *data, int is_stalk)
{
	int i;
	for(i=0; stalk[i]!=-1; i++) tree = n_tree_stalk_get(tree, stalk[i]);
	while(tree->next != NULL) tree = tree->next;
	NTree *leaf = n_tree_new();
	tree->next = leaf;
	leaf->data = data;
	leaf->is_stalk = is_stalk;
	leaf->next = NULL;
	free(stalk);
}


void n_tree_stalk_add( NTree *tree, int stalk[])
{
	int i;
	for(i=0; stalk[i]!=-1; i++) tree = n_tree_stalk_get(tree, stalk[i]);
	NTree *new = n_tree_new();
	int j[1] = {-1}; 
	n_tree_add(tree, j, new, TRUE);
	free(stalk);
}


void *n_tree_get( NTree *tree, int stalk[])
{
	int i = 0;
	int j;
	while(stalk[i+1] != -1)
	{
		tree = n_tree_stalk_get(tree, stalk[i]);
		i++;
	}
	for(j=0; j<stalk[i]+1; j++) tree = tree->next;
	free(stalk);
	return tree->data;
}


void *n_tree_del( NTree *tree, int stalk[])
{	
	int i = 0;	
	while(stalk[i+1] != -1)
	{
		tree = n_tree_stalk_get(tree, stalk[i]);		
		i++;
	}
	NTree *seed = tree;
	int j;
	for(j=0; j<stalk[i]+2; j++) tree = tree->next;
	NTree *jump = tree;
	tree = seed;
	for(j=0; j<stalk[i]; j++) tree = tree->next;
	free(stalk);
	tree->next = jump;
}


int n_tree_count( NTree *tree, int stalk[])
{
	int i;
	for(i=0; stalk[i]!=-1; i++) tree = n_tree_stalk_get(tree, stalk[i]);
	int count = 0;
	while(tree->next!=NULL)
	{
		tree = tree->next;
		count++;
	}
	free(stalk);
	return count;
}


int *n_tree_stalk(int n, ...)
{
	if(!n)
	{
		int *stalk = (int*)malloc(sizeof(int));
		stalk[0] = -1;
		return stalk;
	}
	int *stalk = (int*)malloc((n+1)*sizeof(int));
	va_list va;
	va_start(va, n);	
	int i;
	for(i=0; i<n; i++) stalk[i] = va_arg(va, int);
	stalk[n] = -1;
	return stalk;
}


/*void *n_tree_free_last(NTree *tree)
{
	printf("get last for %p\n", tree);
	NTree *prev;
	while(tree->next!=NULL)	
	{
		printf(" moving to next %p\n", tree->next);
		prev = tree;
		tree = tree->next;
	}
	printf("is_stalk=%i\n", tree->is_stalk);
	if(tree->is_stalk==TRUE) tree = n_tree_free_last(tree->data);
	else 
	{
		printf("  freeing %p\n", tree->data);
		free(tree->data);
		prev->next = NULL;
	}	
}


void n_tree_free(NTree *tree)
{
	while(tree->next!=NULL) n_tree_free_last(tree);
}*/
