/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


language_load()
{
	if(!strcmp(language_,"auto"))
	{
		if(strstr(getenv("LANG"), "_ES")) language_ = "spanish";
		if(strstr(getenv("LANG"), "_PL")) language_ = "polish";
		if(strstr(getenv("LANG"), "_DE")) language_ = "german";
		if(strstr(getenv("LANG"), "_HU")) language_ = "hungarian";
		if(strstr(getenv("LANG"), "_CN")) language_ = "chinese";
		if(strstr(getenv("LANG"), "_FR")) language_ = "french";
		if(strstr(getenv("LANG"), "_SE")) language_ = "swedish";

		if(!strcmp(language_,"auto")) language_ = "english";
	}

	printf("> loading %s language\n", language_);

	char language_path[100];
	sprintf(language_path, "%slang/%s.xml", PATH, language_);
	char *file = file_to_str(language_path);

	char tag[10];
	int i;
	for(i=0; i<sizeof(language)/sizeof(char*); i++)
	{
		sprintf(tag, "word%i", i);
		language[i] = n_xml_get(file, 2, "language", tag);
	}
}
