/*
 *  Code owned by Kernighan & Ritchie, the following code are NOT under Nathive
 *  main license.
 *
 *  The function itoa appeared in the first edition of Kernighan and Ritchie's
 *  The C Programming Language, on page 60. The second edition of The C
 *  Programming Language ("K&R2") contains the following implementation of itoa,
 *  on page 64. Source: <http://en.wikipedia.org/>
 */


void reverse(char s[])
{
    int c, i, j;

    for (i = 0, j = strlen(s)-1; i<j; i++, j--) {
        c = s[i];
        s[i] = s[j];
        s[j] = c;
    }
}


void itoa(int n, char s[])
{
    int i, sign;

    if ((sign = n) < 0)
        n = -n;
    i = 0;
    do {
        s[i++] = n % 10 + '0';
    } while ((n /= 10) > 0);
    if (sign < 0)
        s[i++] = '-';
    s[i] = '\0';
    reverse(s);
}
