/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


tab_change(GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, void *data)
{
	if(page_num==1 && dom_file_count()==1 ) page_num = 0;
	gtk_tree_view_set_model(GTK_TREE_VIEW(object_tree_view), dom_objgui_model(page_num));
	object_gui_select_dtg(page_num);
}


tab_close(GtkWidget *idle, char *path)
{
	printf(">> closing '%s'\n", path);
	int tab = 0;
	while( strcmp( path,(char*)n_tree_get(dom, n_tree_stalk(2,tab,0)) ) ) tab++;

	g_object_unref( n_tree_get(dom, n_tree_stalk(2, tab, DOM_PIX)) );
	gtk_widget_destroy( n_tree_get(dom, n_tree_stalk(2, tab, DOM_IMG)) );
	free( n_tree_get(dom, n_tree_stalk(3, tab, DOM_PRE, PRE_MOSAIC)) );

	int obj;
	for(obj=0; obj<dom_obj_count(tab); obj++)
	{
		free( n_tree_get(dom, n_tree_stalk(4, tab, DOM_OBJ, obj+1, 0)) );
	}

	n_tree_del(dom, n_tree_stalk(1,tab) );
	gtk_notebook_remove_page(GTK_NOTEBOOK(tabs), tab);

	if(n_tree_count(dom, n_tree_stalk(0)) == 0)
	{
		gtk_tree_view_set_model(GTK_TREE_VIEW(object_tree_view), NULL);
	}
}


GdkPixbuf *pixbuf_new(char *path, int w, int h)
{
	if(path!=NULL) return gdk_pixbuf_new_from_file(path, NULL);
	return gdk_pixbuf_new(GDK_COLORSPACE_RGB, TRUE, 8, w, h);
}


tab_open(char *path, int new_w, int new_h, int no_bg)
{
	char *path_short;
	if(path!=NULL)
	{
		path_short = strrchr(path, 47);
		path_short++;
	}
	else
	{
		char *path_short_new = (char*)malloc(100*sizeof(char));
		char unsaved_count_char[10];
		itoa(unsaved_count, unsaved_count_char);
		unsaved_count++;
		sprintf(path_short_new, "%s %s", language[38], unsaved_count_char);
		path_short = path_short_new;
	}

	if(path!=NULL) printf(">> opening '%s'\n", path);
	else printf(">> creating document '%s'\n", path_short);


	//canvas
	GtkWidget *scroll = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), 1, 1);

		GtkWidget *ebox = gtk_event_box_new();
		g_signal_connect(G_OBJECT(ebox),"button-press-event",G_CALLBACK(event_press),NULL);
		g_signal_connect(G_OBJECT(ebox),"button-release-event",G_CALLBACK(event_release),NULL);
		g_signal_connect(G_OBJECT(ebox),"motion-notify-event",G_CALLBACK(event_motion),NULL);
		gtk_widget_set_events(ebox, GDK_POINTER_MOTION_MASK);

			GtkWidget *align = gtk_alignment_new(0.5, 0.5, 0, 0);
			gtk_container_add(GTK_CONTAINER(ebox), align);

				GtkWidget *fixed = gtk_fixed_new();
				gtk_container_add(GTK_CONTAINER(align), fixed);

		gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll), ebox);


	//tree store
	GdkPixbuf *pix = pixbuf_new(path, new_w, new_h);
	if(!gdk_pixbuf_get_has_alpha(pix)) pix = gdk_pixbuf_add_alpha(pix,FALSE,0,0,0);
	int *w = (int*)malloc(sizeof(int));
	int *h = (int*)malloc(sizeof(int));
	*w = gdk_pixbuf_get_width(pix);
	*h = gdk_pixbuf_get_height(pix);
	guchar *raw = gdk_pixbuf_get_pixels(pix);
	GtkWidget *img = gtk_image_new_from_pixbuf(pix);
	gtk_fixed_put(GTK_FIXED(fixed), img, 0, 0);
	gtk_widget_set_size_request(fixed, *w, *h);

	NTree *tab = n_tree_new();
	n_tree_add(dom, n_tree_stalk(0), tab, TRUE);

		if(path!=NULL) n_tree_add(tab, n_tree_stalk(0), path, FALSE);
		else n_tree_add(tab, n_tree_stalk(0), path_short, FALSE);
		n_tree_add(tab, n_tree_stalk(0), w, FALSE);
		n_tree_add(tab, n_tree_stalk(0), h, FALSE);
		n_tree_add(tab, n_tree_stalk(0), scroll, FALSE);
		n_tree_add(tab, n_tree_stalk(0), pix, FALSE);
		n_tree_add(tab, n_tree_stalk(0), img, FALSE);
		n_tree_add(tab, n_tree_stalk(0), raw, FALSE);

		NTree *obj = n_tree_new();
		n_tree_add(tab, n_tree_stalk(0), obj, TRUE);

			int *obj_sel = (int*)malloc(sizeof(int));
			*obj_sel = 1;
			n_tree_add(obj, n_tree_stalk(0), obj_sel, FALSE);

			NTree *obj1 = n_tree_new();
			n_tree_add(obj, n_tree_stalk(0), obj1, TRUE);

				GdkPixbuf *obj1pix = pixbuf_new(path, new_w, new_h);
				if(path==NULL && no_bg==0) gdk_pixbuf_fill(obj1pix, 0xffffffff);
				if(!gdk_pixbuf_get_has_alpha(obj1pix)) obj1pix = gdk_pixbuf_add_alpha(pix,FALSE,0,0,0);
				guchar *obj1raw = gdk_pixbuf_get_pixels(obj1pix);
				int *obj1w = (int*)malloc(sizeof(int));
				int *obj1h = (int*)malloc(sizeof(int));
				int *obj1x = (int*)malloc(sizeof(int));
				int *obj1y = (int*)malloc(sizeof(int));
				*obj1w = gdk_pixbuf_get_width(obj1pix);
				*obj1h = gdk_pixbuf_get_height(obj1pix);
				*obj1x = 0;
				*obj1y = 0;

				n_tree_add(obj1, n_tree_stalk(0), obj1raw, FALSE);
				n_tree_add(obj1, n_tree_stalk(0), obj1w, FALSE);
				n_tree_add(obj1, n_tree_stalk(0), obj1h, FALSE);
				n_tree_add(obj1, n_tree_stalk(0), obj1x, FALSE);
				n_tree_add(obj1, n_tree_stalk(0), obj1y, FALSE);

		NTree *pre = n_tree_new();
		n_tree_add(tab, n_tree_stalk(0), pre, TRUE);

			uchar *mosaic = object_mosaic_new(*w, *h, 16);
			n_tree_add(pre, n_tree_stalk(0), mosaic, FALSE);

		NTree *objgui = n_tree_new();
		n_tree_add(tab, n_tree_stalk(0), objgui, TRUE);

			GtkListStore *objgui_store = gtk_list_store_new(1, G_TYPE_STRING);
			GtkTreeModel *objgui_model = GTK_TREE_MODEL(objgui_store);
			gtk_tree_view_set_model(GTK_TREE_VIEW(object_tree_view), objgui_model);

			n_tree_add(objgui, n_tree_stalk(0), objgui_model, FALSE);
			n_tree_add(objgui, n_tree_stalk(0), objgui_store, FALSE);
			object_gui_new("Original", objgui_store);

		n_tree_add(tab, n_tree_stalk(0), align, FALSE);
		n_tree_add(tab, n_tree_stalk(0), fixed, FALSE);

		NTree *visual = n_tree_new();
		n_tree_add(tab, n_tree_stalk(0), visual, TRUE);

			GtkWidget *visuals[8];
			int i;
			for(i=0; i<8; i++)
			{
				visuals[i] = gtk_image_new_from_file(strcatnew(PATH,"img/visual_scale.png"));
				gtk_fixed_put(GTK_FIXED(fixed), visuals[i], 0, 0);
				n_tree_add(visual, n_tree_stalk(0), visuals[i], FALSE);
			}

			GtkWidget *visual_brush = gtk_image_new();
			gtk_fixed_put(GTK_FIXED(fixed), visual_brush, 0, 0);
			n_tree_add(visual, n_tree_stalk(0), visual_brush, FALSE);


	//tab label
	GtkWidget *label = gtk_hbox_new(FALSE,3);

		GtkWidget *label_text = gtk_label_new(path_short);
		GtkWidget *label_btn = gtk_button_new();
		gtk_button_set_relief(GTK_BUTTON(label_btn), GTK_RELIEF_NONE);
		gtk_button_set_focus_on_click(GTK_BUTTON(label_btn), 0);

		GtkRcStyle *rcstyle;
		rcstyle = gtk_rc_style_new();
		rcstyle->xthickness = rcstyle->ythickness = 0;
		gtk_widget_modify_style(label_btn, rcstyle);
		gint iconH, iconW;
		gtk_icon_size_lookup_for_settings(gtk_widget_get_settings(label), 1, &iconW, &iconH);
		gtk_widget_set_size_request (label_btn, iconW + 4, iconH + 4);
		gtk_button_set_image(GTK_BUTTON(label_btn), gtk_image_new_from_stock("gtk-close", 1));

		if(path!=NULL) g_signal_connect(G_OBJECT(label_btn),"clicked",G_CALLBACK(tab_close), path);
		else g_signal_connect(G_OBJECT(label_btn),"clicked",G_CALLBACK(tab_close), path_short);

		entry_space(label, "h", 0);
		gtk_box_pack_start(GTK_BOX(label),label_text,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(label),label_btn,FALSE,FALSE,0);
		gtk_widget_show_all(label);

		gtk_notebook_append_page(GTK_NOTEBOOK(tabs), scroll, label);


	//other
	gtk_widget_show_all(tabs);
	gtk_notebook_set_current_page(GTK_NOTEBOOK(tabs), -1);
	object_merge();
	statusbar_refresh();
	fixed_obj_move();
	fixed_show();
	fixed_brush_update();
}
