/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


statusbar_refresh()
{
	statusbar_w = *dom_w();
	statusbar_h = *dom_h();

	char statusbar_text[100];
	sprintf(
		statusbar_text,
		" %i x %i %s  ·  %i%c  ·  x%i  y%i",
		statusbar_w, statusbar_h, language[40],
		statusbar_z*100, 37,
		statusbar_x, statusbar_y
	);

	/* brush size from mouse */
	if(statusbar_msg==1)
	{
		sprintf(
			statusbar_text,
			"%s  ·  %s: %i",
			statusbar_text,
			language[52], brush_size
		);
	}

	/* select move */
	if(statusbar_msg==2)
	{
		sprintf(
			statusbar_text,
			"%s  ·  %s:  x%i  y%i",
			statusbar_text,
			language[57],
			statusbar_x-user_x_press, statusbar_y-user_y_press
		);
	}

	statusbar_msg = 0;
	gtk_statusbar_push(GTK_STATUSBAR(statusbar), 0, statusbar_text);
}
