/* 
 *  This file is part of Nathive.
 * 
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */
 

scroll(int x, int y)
{
	int x_rel = user_x_root - x;
	int y_rel = user_y_root - y;	
	GtkScrolledWindow *scroll = GTK_SCROLLED_WINDOW(dom_scroll());
	
	int h = gtk_adjustment_get_value(gtk_scrolled_window_get_hadjustment(scroll)) + x_rel;
	int v = gtk_adjustment_get_value(gtk_scrolled_window_get_vadjustment(scroll)) + y_rel;
	int alloc_x = gtk_scrolled_window_get_hscrollbar(scroll)->allocation.width;
	int alloc_y = gtk_scrolled_window_get_vscrollbar(scroll)->allocation.height;
	h = max(h, 0);
	v = max(v, 0);
	h = min(h, *dom_w() - alloc_x + 4);
	v = min(v, *dom_h() - alloc_y + 4);
	
	if(GTK_WIDGET(scroll)->allocation.width - alloc_x < 100)
	{
		gtk_adjustment_set_value(gtk_scrolled_window_get_hadjustment(scroll), h);
	}

	if(GTK_WIDGET(scroll)->allocation.height - alloc_y < 100)
	{
		gtk_adjustment_set_value(gtk_scrolled_window_get_vadjustment(scroll), v);
	}		
	
	user_x_root -= x_rel;
	user_y_root -= y_rel;
}
