/* 
 *  This file is part of Nathive.
 * 
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */
 

toolbar_item(GtkWidget *toolbar, int n, char *ops[])
{
	int nz;		
	GtkWidget *but[n];
	GtkWidget *butPre = NULL;
	for(nz=0; nz<n; nz++)
	{		
		if(!butPre) but[nz] = gtk_radio_button_new(NULL);
		else but[nz] = gtk_radio_button_new_from_widget(GTK_RADIO_BUTTON(butPre));
		butPre = but[nz];
	}
	
	int *ids = (int*)malloc(n*sizeof(int));;
	for(nz=0; nz<n; nz++)
	{
		ids[nz] = nz;
	}
	
	for(nz=0; nz<n; nz++)
	{
		gtk_button_set_relief(GTK_BUTTON(but[nz]), GTK_RELIEF_NONE);
		gtk_button_set_image(GTK_BUTTON(but[nz]), gtk_image_new_from_file(ops[nz]));
		gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(but[nz]), 0);
		if(tool==nz) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(but[nz]), 1);
		
		int **data = (int**)malloc(2*sizeof(int*));
		data[0] = &tool;
		data[1] = &ids[nz];
		
		g_signal_connect(G_OBJECT(but[nz]),"pressed",G_CALLBACK(call_radio), data);
		g_signal_connect(G_OBJECT(but[nz]),"pressed",G_CALLBACK(sidebar_tool_change), NULL);
		
		gtk_box_pack_start(GTK_BOX(toolbar),but[nz],FALSE,FALSE,0);
	}	
}


save()
{
	if(gtk_notebook_get_n_pages(GTK_NOTEBOOK(tabs)))
	{		
		int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
		char *path = n_tree_get(dom, n_tree_stalk(2,tab,0));
		printf(">> saving %s\n",path);
		
		GdkPixbuf *pix = n_tree_get(dom, n_tree_stalk(2,tab,4));
		gdk_pixbuf_save (pix, strcatnew(PATH,"output.png"), "png", NULL, NULL);
	}
}
