/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


object_gui_new(char *label, GtkListStore *store)
{
	if(store==NULL) store = dom_objgui_store(dom_tab());
	GtkTreeIter iter;
	gtk_list_store_append(store, &iter);
	gtk_list_store_set(store, &iter, 0, label, -1);
	gtk_list_store_move_after(store, &iter, NULL);

	GtkTreeSelection *select = gtk_tree_view_get_selection(GTK_TREE_VIEW(object_tree_view));
	int dom_obj_sel_temp = *dom_obj_sel(-1);
	gtk_tree_selection_select_iter(select, &iter);
	*dom_obj_sel(-1) = dom_obj_sel_temp;
}


object_gui_select_gtd(GtkTreeSelection *selection, void *data)
{
	GList *list = gtk_tree_selection_get_selected_rows(selection, NULL);
	GtkTreePath *path = g_list_nth_data(list, 0);
	if(path==NULL) return;
	int *index = gtk_tree_path_get_indices(path);
	*dom_obj_sel(-1) = dom_obj_count(-1) - index[0];

	if(dom_obj_count(-1) > 0) fixed_obj_move();
}


object_gui_select_dtg(int tab)
{
	GtkTreeSelection *select = gtk_tree_view_get_selection(GTK_TREE_VIEW(object_tree_view));
	GtkTreeIter iter;
	GtkTreeModel *model = dom_objgui_model(tab);
	gtk_tree_model_get_iter_first(model, &iter);
	int objs = dom_obj_count(tab);
	int sel = *dom_obj_sel(tab);
	int i;
	for(i=0; i<objs-sel; i++) gtk_tree_model_iter_next(model, &iter);
	int dom_obj_sel_temp = *dom_obj_sel(-1);
	gtk_tree_selection_select_iter(select, &iter);
	*dom_obj_sel(-1) = dom_obj_sel_temp;
}


object_new()
{
	if(dom_file_count() == 0) return;

	printf(">> creating object in '%s'\n", (char*)dom_file_path());
	if(dom_tab()==-1) return;
	lint obj_size = (*dom_w()) * (*dom_h()) * 4;
	uchar *obj_raw = (uchar*)malloc(obj_size*sizeof(uchar));

	lint i;
	for(i=0; i<obj_size; i++) obj_raw[i] = 0;

	NTree *obj = n_tree_new();
	n_tree_add(dom, n_tree_stalk(2,dom_tab(),DOM_OBJ), obj, TRUE);

		int *w = (int*)malloc(sizeof(int));
		int *h = (int*)malloc(sizeof(int));
		*w = *dom_w();
		*h = *dom_h();
		int *x = (int*)malloc(sizeof(int));
		int *y = (int*)malloc(sizeof(int));
		*x = 0;
		*y = 0;

		n_tree_add(obj, n_tree_stalk(0), obj_raw, FALSE);
		n_tree_add(obj, n_tree_stalk(0), w, FALSE);
		n_tree_add(obj, n_tree_stalk(0), h, FALSE);
		n_tree_add(obj, n_tree_stalk(0), x, FALSE);
		n_tree_add(obj, n_tree_stalk(0), y, FALSE);

	object_gui_new(language[2], NULL);
	*dom_obj_sel(-1) = dom_obj_count(-1);
}


object_merge_area(int x, int y, int w, int h)
{
	/*if(gdk_events_pending())
	{
		return;
	}*/

	int xo = offset_x(x);
	int yo = offset_y(y);

	over_object(
		dom_raw(),
		dom_mosaic(),
		*dom_w(),
		*dom_h(),
		0,
		0,
		*dom_w(),
		*dom_h(),
		xo,
		yo,
		w,
		h,
		OVER_REPLACE
	);

	int objs = dom_obj_count(-1);
	int i;
	for(i=1; i<objs+1; i++)
	{
		over_object(
			dom_raw(),
			dom_obj_raw(i),
			*dom_w(),
			*dom_h(),
			*dom_obj_x(i),
			*dom_obj_y(i),
			*dom_obj_w(i),
			*dom_obj_h(i),
			xo,
			yo,
			w,
			h,
			OVER_ADD
		);
	}

	gtk_widget_queue_draw_area(dom_img(), x, y, w, h);
}


object_merge_area_step(int x, int y, int w, int h)
{
	int step_x = 250;
	int step_y = 162;

	int user_area[4];
	offset_area(user_area);

	int xx, yy;
	for(yy=y; yy<y+h; yy+=step_y)
	{
		for(xx=x; xx<x+w; xx+=step_x)
		{
			if(xx < user_area[0] - step_x || xx > user_area[0] + user_area[2]) continue;
			if(yy < user_area[1] - step_y || yy > user_area[1] + user_area[3]) continue;

			if(gdk_events_pending()) return;
			object_merge_area(xx, yy, step_x, step_y);
			gtk_main_iteration_do(0);
		}
	}
}


object_merge()
{
	object_merge_area(-offset_x(0), -offset_y(0), *dom_w(), *dom_h());
}

object_merge_step()
{
	object_merge_area_step(-offset_x(0), -offset_y(0), *dom_w(), *dom_h());
}


uchar *object_mosaic_new(int w, int h, int size)
{
	uchar grayA = 203;
	uchar grayB = 127;

	uchar *mosaic = (uchar*)malloc(w*h*4*sizeof(uchar));
	int x,y,xx,yy;
	xx = yy = 0;
	for(y=0; y<h; y++)
	{
		xx = 0;
		for(x=0; x<w; x++)
		{
			int pos = pixel_pos(x,y,w);
			if( (xx<size/2 && yy<size/2) || (xx>=size/2 && yy>=size/2))
			{
				mosaic[pos+0] = grayA;
				mosaic[pos+1] = grayA;
				mosaic[pos+2] = grayA;
			}
			else
			{
				mosaic[pos+0] = grayB;
				mosaic[pos+1] = grayB;
				mosaic[pos+2] = grayB;
			}
			mosaic[pos+3] = 255;

			xx++;
			if(xx>=size) xx = 0;
		}
		yy++;
		if(yy>=size) yy = 0;
	}
	return mosaic;
}
