/* 
 *  This file is part of Nathive.
 * 
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */
 

menubar_item_new(GtkWidget *parent, char *label, char *stock, char *call)
{
	GtkWidget *item = gtk_image_menu_item_new_with_label(label);
	gtk_menu_shell_append(GTK_MENU_SHELL(parent), item);
	if(call) g_signal_connect(G_OBJECT(item), "activate", G_CALLBACK(call_function), call);
	if(stock)
	{
		GtkWidget *image = gtk_image_new_from_stock(stock, 1);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(item), image);
	}
}
