/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


fixed_obj_move()
{
	int o = 5; //offset
	int x = *dom_obj_x(0);
	int y = *dom_obj_y(0);
	int w = *dom_obj_w(0);
	int h = *dom_obj_h(0);
	int ww = w/2;
	int hh = h/2;

	gtk_fixed_move(GTK_FIXED(dom_fixed()), dom_visual(-1, 0), x-o,    y-o);
	gtk_fixed_move(GTK_FIXED(dom_fixed()), dom_visual(-1, 1), x-o+ww, y-o);
	gtk_fixed_move(GTK_FIXED(dom_fixed()), dom_visual(-1, 2), x-o+w,  y-o);

	gtk_fixed_move(GTK_FIXED(dom_fixed()), dom_visual(-1, 3), x-o,   y-o+hh);
	gtk_fixed_move(GTK_FIXED(dom_fixed()), dom_visual(-1, 4), x-o+w, y-o+hh);

	gtk_fixed_move(GTK_FIXED(dom_fixed()), dom_visual(-1, 5), x-o,    y-o+h);
	gtk_fixed_move(GTK_FIXED(dom_fixed()), dom_visual(-1, 6), x-o+ww, y-o+h);
	gtk_fixed_move(GTK_FIXED(dom_fixed()), dom_visual(-1, 7), x-o+w,  y-o+h);
}


fixed_brush(int x, int y)
{
	if(gdk_events_pending()) return;
	gtk_fixed_move(
		GTK_FIXED(dom_fixed()),
		dom_visual(-1, 8),
		offset_x( x-(brush_size/2) ),
		offset_y( y-(brush_size/2) )
	);
}


fixed_brush_update()
{
	if(!dom_file_count()) return;
	GdkPixbuf *visual = pixbuf_new(NULL, brush_size, brush_size);
	uchar *visual_raw = gdk_pixbuf_get_pixels(visual);

	int x,y;
	for(y=0; y<brush_size; y++)
	{
		for(x=0; x<brush_size; x++)
		{
			lint pos = pixel_pos(x, y, brush_size);
			visual_raw[pos+0] = visual_raw[pos+1] = visual_raw[pos+2] = 127;

			if(brush_raw[pos+3]>0)
			{
				if(x==0 || y==0 || x==brush_size-1 || y==brush_size-1)
				{
					visual_raw[pos+3] = 255;
					continue;
				}

				if
				(
					brush_raw[pos+3-4] != 0 &&
					brush_raw[pos+3+4] != 0 &&
					brush_raw[pos+3-(brush_size*4)] != 0 &&
					brush_raw[pos+3+(brush_size*4)] != 0
				)
				visual_raw[pos+3] = 0;

				else visual_raw[pos+3] = 255;
			}
			else visual_raw[pos+3] = 0;
		}
	}

	int i;
	for(i=0; i<dom_file_count(); i++)
	{
		gtk_image_set_from_pixbuf( GTK_IMAGE(dom_visual(i, 8)), visual);
	}
}


fixed_show()
{
	/* select */
	int i,j;
	for(i=0; i<dom_file_count(); i++)
	{
		for(j=0; j<8; j++)
		{
			if(tool==TOOL_SELECT) gtk_widget_show(dom_visual(i,j));
			else gtk_widget_hide(dom_visual(i,j));
		}
	}

	/* brush */
	for(i=0; i<dom_file_count(); i++)
	{
		if(tool==TOOL_BRUSH) gtk_widget_show(dom_visual(i,8));
		else gtk_widget_hide(dom_visual(i,8));
	}
}
