/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


event_press(GtkWidget *wid, GdkEventButton *event)
{
	int x = (int)event->x;
	int y = (int)event->y;
	user_button = event->button;
	user_x = x;
	user_y = y;
	user_x_root = (int)event->x_root;
	user_y_root = (int)event->y_root;
	user_x_press = offset_x(x);
	user_y_press = offset_y(y);
	if(user_button==2) cursor_stock(GDK_FLEUR);
	if(tool==2) if(user_button==1) picker_get(x,y);
	if(tool==3) if(user_button==1) brush_spacer(x,y,1);
}

event_release(GtkWidget *wid)
{
	if(tool==0) if(user_button==1) object_merge();
	cursor_default();
	user_button = 0;
}

event_motion(GtkWidget *wid, GdkEventMotion *event)
{
	int x = (int)event->x;
	int y = (int)event->y;
	int x_root = (int)event->x_root;
	int y_root = (int)event->y_root;

	if(user_button==2) scroll(x_root, y_root);

	if(tool==0) if(user_button==1) select_move(x,y);
	if(tool==2) if(user_button==1) picker_get(x,y);
	if(tool==3)
	{
		if(user_button==1) brush_spacer(x,y,0);
		if(user_button==3) brush_size_motion(x,y);
	}
	statusbar_x = offset_x(x);
	statusbar_y = offset_y(y);
	statusbar_refresh();
	fixed_brush(x,y);
}
