/* 
 *  This file is part of Nathive.
 * 
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */
 

entry_spin(GtkWidget *parent, char *label, void *value, int min, int max, char *type, 
           GtkObject *adj, int show_scale)
{
	double value_format;
	if(type=="uchar") value_format = *(uchar*)value;
	if(type=="int") value_format = *(int*)value;
	if(type=="double") value_format = *(double*)value;	

	if(adj==NULL) adj = gtk_adjustment_new(0,0,0,1,1,0);
	if(type=="uchar") g_signal_connect(G_OBJECT(adj),"value-changed",G_CALLBACK(call_adj_uchar),value);
	if(type=="int") g_signal_connect(G_OBJECT(adj),"value-changed",G_CALLBACK(call_adj_int),value);
	if(type=="double") g_signal_connect(G_OBJECT(adj),"value-changed",G_CALLBACK(call_adj_double),value);

	int separation = 0;
	if(!show_scale) separation = 10;
	GtkWidget *box = gtk_hbox_new(FALSE, separation);	
	
		GtkWidget *label_ = gtk_label_new(label);
		gtk_misc_set_alignment(GTK_MISC(label_), 0, 0.5);	
		gtk_box_pack_start(GTK_BOX(box),label_,TRUE,TRUE,0);
	
		if(show_scale)
		{
			GtkWidget *scale = gtk_scale_button_new(1,1,1,4,NULL);
			gtk_scale_button_set_adjustment(GTK_SCALE_BUTTON(scale), GTK_ADJUSTMENT(adj));
			const gchar *scaleIcons[] = {"gtk-index", NULL};
			gtk_scale_button_set_icons(GTK_SCALE_BUTTON(scale), scaleIcons);
			gtk_box_pack_start(GTK_BOX(box),scale,FALSE,FALSE,0);				
		}
	
		GtkWidget *spin = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1, 0);
		gtk_spin_button_set_range(GTK_SPIN_BUTTON(spin), min, max);
		if(type=="double") 
		{
			gtk_spin_button_set_digits(GTK_SPIN_BUTTON(spin), 2);
			gtk_spin_button_set_increments(GTK_SPIN_BUTTON(spin), 0.01, 0.01);
			gtk_spin_button_set_range(GTK_SPIN_BUTTON(spin), 0.01, max);
		}
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), value_format);
		gtk_box_pack_start(GTK_BOX(box),spin,FALSE,FALSE,0);			
		
	gtk_box_pack_start(GTK_BOX(parent), box, FALSE,FALSE,0);
}


entry_spinmenu(GtkWidget *parent, char *label, void *value, int min, int max, char *type, 
			   GtkObject *adj, int menun, int *menuvalue, char *ops[], GtkWidget *menu)
{
	double value_format;
	if(type=="int") value_format = *(int*)value;
	if(type=="double") value_format = *(double*)value;	

	if(adj==NULL) adj = gtk_adjustment_new(0,0,0,1,1,0);
	if(type=="int") g_signal_connect(G_OBJECT(adj),"value-changed",G_CALLBACK(call_adj_int),value);
	if(type=="double") g_signal_connect(G_OBJECT(adj),"value-changed",G_CALLBACK(call_adj_double),value);

	GtkWidget *box = gtk_hbox_new(FALSE, 0);	
	
		GtkWidget *label_ = gtk_label_new(label);
		gtk_misc_set_alignment(GTK_MISC(label_), 0, 0.5);		
	
	
		GtkWidget *spin = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1, 0);
		gtk_spin_button_set_range(GTK_SPIN_BUTTON(spin), min, max);
		if(type=="double") 
		{
			gtk_spin_button_set_digits(GTK_SPIN_BUTTON(spin), 2);
			gtk_spin_button_set_increments(GTK_SPIN_BUTTON(spin), 0.01, 0.01);
			gtk_spin_button_set_range(GTK_SPIN_BUTTON(spin), 0.01, max);
		}
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), value_format);
		
	
		GtkWidget *btn = gtk_button_new();
		gtk_button_set_image(GTK_BUTTON(btn), gtk_image_new_from_stock("gtk-sort-descending", 1));
		gtk_button_set_relief(GTK_BUTTON(btn), GTK_RELIEF_NONE);
		
		int i;
		int *ids = (int*)malloc(menun*sizeof(int));
		for(i=0; i<menun; i++) ids[i] = i;
		
		if(menu==NULL) menu = gtk_menu_new();
		if(ops)
		{
			GtkWidget *item[menun];
			for(i=0; i<menun; i++)
			{
				int **data = (int**)malloc(2*sizeof(int*));
				data[0] = menuvalue;
				data[1] = &ids[i];
		
				item[i] = gtk_menu_item_new_with_label(ops[i]);
				gtk_menu_shell_append(GTK_MENU_SHELL(menu), item[i]);
				g_signal_connect_swapped(G_OBJECT(item[i]),"activate",G_CALLBACK(call_spinmenu), data);	
			}			
		}
		gtk_widget_show_all(menu);
		g_signal_connect(G_OBJECT(btn),"clicked",G_CALLBACK(call_menu), menu);	
			
		
		gtk_box_pack_start(GTK_BOX(box),label_,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(box),btn,FALSE,FALSE,0);	
		gtk_box_pack_start(GTK_BOX(box),spin,FALSE,FALSE,0);
		
	gtk_box_pack_start(GTK_BOX(parent), box, FALSE,FALSE,0);
}


entry_combo(GtkWidget *parent, char *label, int n, int *value, char *ops[], GtkWidget *combo)
{
	GtkWidget *box = gtk_hbox_new(FALSE,5);	
	
		GtkWidget *label_ = gtk_label_new(label);
		gtk_misc_set_alignment(GTK_MISC(label_), 0, 0.5);
		
		if(combo==NULL) combo = gtk_combo_box_new_text();
		
		int i;
		for(i=0; i<n; i++) gtk_combo_box_append_text(GTK_COMBO_BOX(combo), ops[i]);

		gtk_combo_box_set_active(GTK_COMBO_BOX(combo), *value);
		g_signal_connect(G_OBJECT(combo),"changed",G_CALLBACK(call_combo),value);
	
		if(label!="") gtk_box_pack_start(GTK_BOX(box), label_, TRUE, TRUE, 0);
		
		if(label!="") gtk_box_pack_start(GTK_BOX(box), combo, FALSE, FALSE, 0);
		else gtk_box_pack_end(GTK_BOX(box), combo, FALSE, FALSE, 0);		
		
	gtk_box_pack_start(GTK_BOX(parent), box, FALSE,FALSE,0);
}


entry_toggle(GtkWidget *parent, char *label, int n, int *value, char *ops[], 
             GtkWidget *but[], char *call)
{
	GtkWidget *box = gtk_hbox_new(FALSE,0);	
	
		GtkWidget *label_ = gtk_label_new(label);
		gtk_misc_set_alignment(GTK_MISC(label_), 0, 0.5);	
		gtk_box_pack_start(GTK_BOX(box),label_,TRUE,TRUE,0);
		
		int i;		
		GtkWidget *btn_pre = NULL;
		for(i=0; i<n; i++)
		{		
			if(!btn_pre) but[i] = gtk_radio_button_new(NULL);
			else but[i] = gtk_radio_button_new_from_widget(GTK_RADIO_BUTTON(btn_pre));
			btn_pre = but[i];
		}
		
		int *ids = (int*)malloc(n*sizeof(int));;
		for(i=0; i<n; i++)
		{
			ids[i] = i;
		}
		
		for(i=0; i<n; i++)
		{
			gtk_button_set_relief(GTK_BUTTON(but[i]), GTK_RELIEF_NONE);
			gtk_button_set_image(GTK_BUTTON(but[i]), gtk_image_new_from_file(ops[i]));
			gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(but[i]), 0);
			if(*value==i) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(but[i]), 1);
			
			int **data = (int**)malloc(2*sizeof(int*));
			data[0] = value;
			data[1] = &ids[i];
			
			g_signal_connect(G_OBJECT(but[i]),"pressed",G_CALLBACK(call_radio), data);
			g_signal_connect(G_OBJECT(but[i]),"pressed",G_CALLBACK(call_function), call);
			
			gtk_box_pack_start(GTK_BOX(box),but[i],FALSE,FALSE,0);
		}	
		
	gtk_box_pack_start(GTK_BOX(parent), box, FALSE,FALSE,0);
}


entry_check(GtkWidget *parent, char *label, int *value, GtkWidget *check, char *call)
{
	GtkWidget *box = gtk_hbox_new(FALSE,0);	
	
		GtkWidget *label_ = gtk_label_new(label);
		gtk_misc_set_alignment(GTK_MISC(label_), 0, 0.5);	
		
		if(check==NULL) check = gtk_check_button_new();
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), *value);
	
		gtk_box_pack_start(GTK_BOX(box),label_,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(box),check,FALSE,FALSE,0);	
		
		g_signal_connect(G_OBJECT(check),"toggled",G_CALLBACK(call_check), value);		
		
	gtk_box_pack_start(GTK_BOX(parent), box, FALSE,FALSE,0);
}


entry_entry(GtkWidget *parent, char *label, char *value, int len, char *call, GtkWidget *entry)
{
	GtkWidget *box = gtk_hbox_new(FALSE,0);	
	
		GtkWidget *label_ = gtk_label_new(label);
		gtk_misc_set_alignment(GTK_MISC(label_), 0, 0.5);	
				
		if(entry==NULL) entry = gtk_entry_new();
		gtk_entry_set_max_length(GTK_ENTRY(entry), len);
		gtk_entry_set_width_chars(GTK_ENTRY(entry), len+1);
		gtk_entry_set_text(GTK_ENTRY(entry), value);
	
		gtk_box_pack_start(GTK_BOX(box),label_,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(box),entry,FALSE,FALSE,0);	
		
		g_signal_connect(G_OBJECT(entry),"changed",G_CALLBACK(call_function), call);		
		
	gtk_box_pack_start(GTK_BOX(parent), box, FALSE,FALSE,0);
}


entry_color(GtkWidget *parent, char *label)
{
	GtkWidget *box = gtk_hbox_new(FALSE,0);	
	
		GtkWidget *label_ = gtk_label_new(label);
		gtk_misc_set_alignment(GTK_MISC(label_), 0, 0.5);	
				
		GtkWidget *color = gtk_color_button_new();
	
		gtk_box_pack_start(GTK_BOX(box),label_,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(box),color,FALSE,FALSE,0);	
		
	gtk_box_pack_start(GTK_BOX(parent), box, FALSE,FALSE,0);
}


entry_clear(GtkWidget *parent, char *call, int size)
{
	GtkWidget *button = gtk_button_new();
	gtk_button_set_image(GTK_BUTTON(button), gtk_image_new_from_stock("gtk-clear", size));
	gtk_widget_set_tooltip_text(button, language[23]);
	g_signal_connect(G_OBJECT(button),"clicked",G_CALLBACK(call_function), call);
	gtk_box_pack_end(GTK_BOX(parent),button,FALSE,FALSE,0);			
}


entry_separator(GtkWidget *parent)
{
	GtkWidget *separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent), separator, FALSE, FALSE, 4);
}


entry_space(GtkWidget *parent, char *mode, int space)
{
	GtkWidget *box = gtk_hbox_new(FALSE, 0);
	if(mode=="v") gtk_widget_set_size_request(box, -1, space);
	if(mode=="h") gtk_widget_set_size_request(box, space, -1);
	gtk_box_pack_start(GTK_BOX(parent), box, FALSE, FALSE, 0);
}


entry_expand(GtkWidget *parent)
{
	GtkWidget *box = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(parent), box, TRUE,TRUE,0);
}
