/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


dialog_new_template_load()
{
	feedback_lock = 1;
	if(dialog_new_template == 1) // A3
	{
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[3]), 29.7);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[4]), 42.0);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[2]), 150);
		feedback_lock = 0;
		dialog_new_update("cm-refresh");
	}
	if(dialog_new_template == 2) // a4
	{
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[3]), 21.0);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[4]), 29.7);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[2]), 150);
		feedback_lock = 0;
		dialog_new_update("cm-refresh");
	}
	if(dialog_new_template == 3) // a5
	{
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[3]), 14.8);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[4]), 21.0);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[2]), 150);
		feedback_lock = 0;
		dialog_new_update("cm-refresh");
	}
	if(dialog_new_template == 4) // cd cover
	{
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[3]), 12.1);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[4]), 12.0);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[2]), 150);
		feedback_lock = 0;
		dialog_new_update("cm-refresh");
	}
	if(dialog_new_template == 5) // dvd cover
	{
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[3]), 27.2);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[4]), 18.4);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[2]), 150);
		feedback_lock = 0;
		dialog_new_update("cm-refresh");
	}
	if(dialog_new_template == 6) // dvd cover slim
	{
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[3]), 26.7);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[4]), 18.4);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[2]), 150);
		feedback_lock = 0;
		dialog_new_update("cm-refresh");
	}
}


dialog_new_rotate()
{
	if(dialog_new_pxw_ops != -1 || dialog_new_pxh_ops != -1)
	{
		int temp = dialog_new_pxw;
		dialog_new_pxw = dialog_new_pxh;
		dialog_new_pxh = temp;
		dialog_new_pxw_ops = dialog_new_pxh_ops = -1;
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[0]), dialog_new_pxw);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[1]), dialog_new_pxh);
		dialog_new_update("px");
	}
	if(dialog_new_cmw_ops != -1 || dialog_new_cmh_ops != -1)
	{
		double temp = dialog_new_cmw;
		dialog_new_cmw = dialog_new_cmh;
		dialog_new_cmh = temp;
		dialog_new_cmw_ops = dialog_new_cmh_ops = -1;
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[3]), dialog_new_cmw);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[4]), dialog_new_cmh);
		dialog_new_update("cm");
	}
	if(dialog_new_inw_ops != -1 || dialog_new_inh_ops != -1)
	{
		double temp = dialog_new_inw;
		dialog_new_inw = dialog_new_inh;
		dialog_new_inh = temp;
		dialog_new_inw_ops = dialog_new_inh_ops = -1;
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[5]), dialog_new_inw);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[6]), dialog_new_inh);
		dialog_new_update("in");
	}
}


dialog_new_porcent(double mod)
{
	if(dialog_new_pxw_ops != -1 || dialog_new_pxh_ops != -1)
	{
		if(dialog_new_pxw_ops != -1) dialog_new_pxw *= mod;
		if(dialog_new_pxh_ops != -1) dialog_new_pxh *= mod;
		dialog_new_pxw_ops = dialog_new_pxh_ops = -1;
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[0]), dialog_new_pxw);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[1]), dialog_new_pxh);
		dialog_new_update("px");
	}
	if(dialog_new_cmw_ops != -1 || dialog_new_cmh_ops != -1)
	{
		if(dialog_new_cmw_ops != -1) dialog_new_cmw *= mod;
		if(dialog_new_cmh_ops != -1) dialog_new_cmh *= mod;
		dialog_new_cmw_ops = dialog_new_cmh_ops = -1;
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[3]), dialog_new_cmw);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[4]), dialog_new_cmh);
		dialog_new_update("cm");
	}
	if(dialog_new_inw_ops != -1 || dialog_new_inh_ops != -1)
	{
		if(dialog_new_inw_ops != -1) dialog_new_inw *= mod;
		if(dialog_new_inh_ops != -1) dialog_new_inh *= mod;
		dialog_new_inw_ops = dialog_new_inh_ops = -1;
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[5]), dialog_new_inw);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[6]), dialog_new_inh);
		dialog_new_update("in");
	}
}


dialog_new_dpi_load()
{
	if(dialog_new_dpi_ops==0) dialog_new_dpi = 600;
	if(dialog_new_dpi_ops==1) dialog_new_dpi = 300;
	if(dialog_new_dpi_ops==2) dialog_new_dpi = 150;
	if(dialog_new_dpi_ops==3) dialog_new_dpi = 92;
	if(dialog_new_dpi_ops==4) dialog_new_dpi = 72;
	gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[2]), dialog_new_dpi);
	dialog_new_dpi_ops = -1;
}


dialog_new_smartshow()
{
	gtk_widget_hide(dialog_new_box_px);
	gtk_widget_hide(dialog_new_box_cm);
	gtk_widget_hide(dialog_new_box_in);
	if(dialog_new_unit == 0) gtk_widget_show(dialog_new_box_px);
	if(dialog_new_unit == 1) gtk_widget_show(dialog_new_box_cm);
	if(dialog_new_unit == 2) gtk_widget_show(dialog_new_box_in);

	/*if(dialog_new_unit == 0) gtk_widget_set_sensitive(dialog_new_box_re, 0);
	else gtk_widget_set_sensitive(dialog_new_box_re, 1);*/
}


dialog_new_update(char *seed)
{
	if(!feedback_lock)
	{
		feedback_lock = 1;

		if(seed!="unit" && !strstr(seed,"refresh"))
		{
			gtk_combo_box_set_active(GTK_COMBO_BOX(dialog_new_template_combo), 0);
		}
		if(seed=="px-refresh") seed="px";
		if(seed=="cm-refresh") seed="cm";
		if(seed=="in-refresh") seed="in";

		if(seed=="px")
		{
			dialog_new_cmw = px_to_cm(dialog_new_pxw, dialog_new_dpi);
			dialog_new_cmh = px_to_cm(dialog_new_pxh, dialog_new_dpi);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[3]), dialog_new_cmw);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[4]), dialog_new_cmh);
			dialog_new_inw = px_to_in(dialog_new_pxw, dialog_new_dpi);
			dialog_new_inh = px_to_in(dialog_new_pxh, dialog_new_dpi);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[5]), dialog_new_inw);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[6]), dialog_new_inh);
		}
		if(seed=="cm")
		{
			dialog_new_pxw = cm_to_px(dialog_new_cmw, dialog_new_dpi);
			dialog_new_pxh = cm_to_px(dialog_new_cmh, dialog_new_dpi);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[0]), dialog_new_pxw);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[1]), dialog_new_pxh);
			dialog_new_inw = cm_to_in(dialog_new_cmw);
			dialog_new_inh = cm_to_in(dialog_new_cmh);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[5]), dialog_new_inw);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[6]), dialog_new_inh);
		}
		if(seed=="in")
		{
			dialog_new_pxw = in_to_px(dialog_new_inw, dialog_new_dpi);
			dialog_new_pxh = in_to_px(dialog_new_inh, dialog_new_dpi);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[0]), dialog_new_pxw);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[1]), dialog_new_pxh);
			dialog_new_cmw = in_to_cm(dialog_new_inw);
			dialog_new_cmh = in_to_cm(dialog_new_inh);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[3]), dialog_new_cmw);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[4]), dialog_new_cmh);
		}
		if(seed=="dpi")
		{
			if(dialog_new_unit == 0)
			{
				dialog_new_cmw = px_to_cm(dialog_new_pxw, dialog_new_dpi);
				dialog_new_cmh = px_to_cm(dialog_new_pxh, dialog_new_dpi);
				gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[3]), dialog_new_cmw);
				gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[4]), dialog_new_cmh);
				dialog_new_inw = px_to_in(dialog_new_pxw, dialog_new_dpi);
				dialog_new_inh = px_to_in(dialog_new_pxh, dialog_new_dpi);
				gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[5]), dialog_new_inw);
				gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[6]), dialog_new_inh);
			}
			if(dialog_new_unit == 1)
			{
				dialog_new_pxw = cm_to_px(dialog_new_cmw, dialog_new_dpi);
				dialog_new_pxh = cm_to_px(dialog_new_cmh, dialog_new_dpi);
			}
			if(dialog_new_unit == 2)
			{
				dialog_new_pxw = in_to_px(dialog_new_inw, dialog_new_dpi);
				dialog_new_pxh = in_to_px(dialog_new_inh, dialog_new_dpi);
			}
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[0]), dialog_new_pxw);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(dialog_new_adj[1]), dialog_new_pxh);
		}
		feedback_lock = 0;
	}
}


dialog_new_call(GtkWidget *btn, GtkWidget *dialog)
{
	destroy(NULL, dialog);
	tab_open(NULL, dialog_new_pxw, dialog_new_pxh,  dialog_new_nobg);
}


dialog_new()
{
	GtkWidget *dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER_ALWAYS);
	gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
	gtk_window_set_title(GTK_WINDOW(dialog), language[2]);
	gtk_container_set_border_width(GTK_CONTAINER(dialog), 10);
	GtkWidget *vbox = gtk_vbox_new(FALSE,5);

		dialog_new_template_combo = gtk_combo_box_new_text();
		char *dialog_new_template_ops[] = {
			"",
			"DIN A3",
			"DIN A4",
			"DIN A5",
			language[45],
			language[46],
			strcatnew(language[46]," (slim)")
		};
		entry_combo(
			vbox,
			strcatnew(language[44],":"),
			7,
			&dialog_new_template,
			dialog_new_template_ops,
			dialog_new_template_combo
		);

		entry_separator(vbox);

		dialog_new_unit_combo = gtk_combo_box_new_text();
		char *dialog_new_unit_ops[] = { language[40], language[41], language[42] };
		entry_combo(vbox, strcatnew(language[39],":"), 3, &dialog_new_unit, dialog_new_unit_ops, dialog_new_unit_combo);


		int i;
		for(i=0; i<7; i++) dialog_new_adj[i] = gtk_adjustment_new(0,0,0,1,1,0);

		char *px_ops[] = {language[53], language[54], language[55]};
		GtkWidget *pxw_menu = gtk_menu_new();
		GtkWidget *pxh_menu = gtk_menu_new();
		GtkWidget *cmw_menu = gtk_menu_new();
		GtkWidget *cmh_menu = gtk_menu_new();
		GtkWidget *inw_menu = gtk_menu_new();
		GtkWidget *inh_menu = gtk_menu_new();

		dialog_new_box_px = gtk_vbox_new(FALSE,5);
			entry_spinmenu(dialog_new_box_px, strcatnew(language[30]," (px):"), &dialog_new_pxw, 1, 10000, "int", dialog_new_adj[0], 3, &dialog_new_pxw_ops, px_ops, pxw_menu);
			entry_spinmenu(dialog_new_box_px, strcatnew(language[31]," (px):"), &dialog_new_pxh, 1, 10000, "int", dialog_new_adj[1], 3, &dialog_new_pxh_ops, px_ops, pxh_menu);
		gtk_box_pack_start(GTK_BOX(vbox), dialog_new_box_px, FALSE, FALSE, 0);

		feedback_lock = 1;
		dialog_new_box_cm = gtk_vbox_new(FALSE,5);
			entry_spinmenu(dialog_new_box_cm, strcatnew(language[30]," (cm):"), &dialog_new_cmw, 1, 1000, "double", dialog_new_adj[3], 3, &dialog_new_cmw_ops, px_ops, cmw_menu);
			entry_spinmenu(dialog_new_box_cm, strcatnew(language[31]," (cm):"), &dialog_new_cmh, 1, 1000, "double", dialog_new_adj[4], 3, &dialog_new_cmh_ops, px_ops, cmh_menu);
		gtk_box_pack_start(GTK_BOX(vbox), dialog_new_box_cm, FALSE, FALSE, 0);

		dialog_new_box_in = gtk_vbox_new(FALSE,5);
			entry_spinmenu(dialog_new_box_in, strcatnew(language[30]," (in):"), &dialog_new_inw, 1, 1000, "double", dialog_new_adj[5], 3, &dialog_new_inw_ops, px_ops, inw_menu);
			entry_spinmenu(dialog_new_box_in, strcatnew(language[31]," (in):"), &dialog_new_inh, 1, 1000, "double", dialog_new_adj[6], 3, &dialog_new_inh_ops, px_ops, inh_menu);
		gtk_box_pack_start(GTK_BOX(vbox), dialog_new_box_in, FALSE, FALSE, 0);

		dialog_new_box_re = gtk_vbox_new(FALSE,5);
			char *re_ops[] = {
				strcatnew(language[47], " (600)"),
				strcatnew(language[48], " (300)"),
				strcatnew(language[49], " (150)"),
				strcatnew(language[50], " (92)"),
				strcatnew(language[51], " (72)"),
			};
			GtkWidget *re_menu = gtk_menu_new();
			entry_spinmenu(dialog_new_box_re, strcatnew(language[43]," (dpi):"), &dialog_new_dpi, 1, 10000, "int", dialog_new_adj[2], 5, &dialog_new_dpi_ops, re_ops, re_menu);
		gtk_box_pack_start(GTK_BOX(vbox), dialog_new_box_re, FALSE, FALSE, 0);
		feedback_lock = 0;


		entry_separator(vbox);

		dialog_new_nobg_check = gtk_check_button_new();
		entry_check(vbox, strcatnew(language[33],":"), &dialog_new_nobg, dialog_new_nobg_check, NULL);

		entry_space(vbox);

		GtkWidget *buttons = gtk_hbox_new(FALSE,5);

			GtkWidget *ok = gtk_button_new_from_stock("gtk-ok");
			g_signal_connect(G_OBJECT(ok), "clicked", G_CALLBACK(dialog_new_call), dialog);

			GtkWidget *cancel = gtk_button_new_from_stock("gtk-cancel");
			g_signal_connect(G_OBJECT(cancel), "clicked", G_CALLBACK(destroy), dialog);

			gtk_box_pack_end(GTK_BOX(buttons),ok,TRUE,TRUE,0);
			gtk_box_pack_end(GTK_BOX(buttons),cancel,TRUE,TRUE,0);
			entry_clear(buttons, "clear_new", 2);

		gtk_box_pack_start(GTK_BOX(vbox),buttons,FALSE,FALSE,0);

	gtk_container_add(GTK_CONTAINER(dialog), vbox);
	gtk_widget_show_all(dialog);
	dialog_new_smartshow();
}


dialog_open_path(GtkWidget *widget, GtkWidget *dialog)
{
	gchar *path = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));
	folder_last = gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER(dialog));
	tab_open(path, 0, 0, 0);
	destroy(NULL, dialog);
}


dialog_open_preview(GtkWidget *dialog, GtkWidget *preview_data[])
{
	GtkWidget *img = preview_data[0];
	GtkWidget *label = preview_data[1];
	//free(preview_data);

	GtkWidget *parent = gtk_widget_get_parent(img);
	parent = gtk_widget_get_parent(parent);
	gtk_frame_set_label(GTK_FRAME(parent), language[56]);

	char *path = gtk_file_chooser_get_preview_filename(GTK_FILE_CHOOSER(dialog));
	if(path==NULL) return;

	GdkPixbuf *pix = gdk_pixbuf_new_from_file_at_size(path, 128, 128, NULL);
	gtk_widget_set_size_request(img, 128, -1);

	if(pix!=NULL && gdk_pixbuf_get_has_alpha(pix))
	{
		int w = gdk_pixbuf_get_width(pix);
		int h = gdk_pixbuf_get_height(pix);
		uchar *raw = gdk_pixbuf_get_pixels(pix);
		uchar *mosaic = object_mosaic_new(w, h, 8);
		over_object(mosaic, raw, w, h, 0, 0, w, h, 0, 0, w, h, OVER_ADD);
		over_object(raw, mosaic, w, h, 0, 0, w, h, 0, 0, w, h, OVER_REPLACE);
	}
	gtk_image_set_from_pixbuf(GTK_IMAGE(img), pix);
	if(pix!=NULL) g_object_unref(G_OBJECT(pix));
	//else gtk_image_set_from_stock(GTK_IMAGE(img), "gtk-find", 6);

	if(pix!=NULL)
	{
		int width;
		int height;
		gdk_pixbuf_get_file_info(path, &width, &height);
		char size[15];
		sprintf(size, "%i x %i", width, height);
		gtk_label_set_text(GTK_LABEL(label), size);
	}
	else gtk_label_set_text(GTK_LABEL(label), "");
}


dialog_open()
{
	GtkWidget *dialog = gtk_file_chooser_dialog_new(NULL,NULL,GTK_FILE_CHOOSER_ACTION_OPEN,NULL,NULL);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);

	if(!strcmp(folder_last,"~/")) folder_last = getenv("HOME");
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(dialog), folder_last);

	GtkWidget *preview = gtk_frame_new("");
		GtkWidget *preview_box = gtk_vbox_new(FALSE, 5);
		gtk_container_set_border_width(GTK_CONTAINER(preview_box), 15);
			GtkWidget *preview_img = gtk_image_new();
			GtkWidget *preview_label = gtk_label_new("");
			gtk_box_pack_start(GTK_BOX(preview_box),preview_img,FALSE,FALSE,0);
			gtk_box_pack_start(GTK_BOX(preview_box),preview_label,FALSE,FALSE,0);

			GtkWidget **preview_data = (GtkWidget**)malloc(2*sizeof(GtkWidget*));
			preview_data[0] = preview_img;
			preview_data[1] = preview_label;

		gtk_container_add(GTK_CONTAINER(preview), preview_box);
		gtk_widget_show_all(preview);
		gtk_widget_hide(preview);

		gtk_file_chooser_set_preview_widget(GTK_FILE_CHOOSER(dialog), preview);
		gtk_file_chooser_set_use_preview_label(GTK_FILE_CHOOSER(dialog), FALSE);
		g_signal_connect(G_OBJECT(dialog), "update-preview", G_CALLBACK(dialog_open_preview), preview_data);

	GtkWidget *extra = gtk_hbox_new(FALSE, 5);
		GtkWidget *open = gtk_button_new_from_stock("gtk-open");
		gtk_widget_set_size_request(open, DIALOG_BTN_WIDTH, -1);
		g_signal_connect(G_OBJECT(open), "clicked", G_CALLBACK(dialog_open_path), dialog);
		g_signal_connect(G_OBJECT(dialog), "file-activated", G_CALLBACK(dialog_open_path), dialog);

		GtkWidget *cancel = gtk_button_new_from_stock("gtk-cancel");
		gtk_widget_set_size_request(cancel, DIALOG_BTN_WIDTH, -1);
		g_signal_connect(G_OBJECT(cancel), "clicked", G_CALLBACK(destroy), dialog);

		gtk_box_pack_end(GTK_BOX(extra),open,FALSE,FALSE,0);
		gtk_box_pack_end(GTK_BOX(extra),cancel,FALSE,FALSE,0);

	gtk_file_chooser_set_extra_widget(GTK_FILE_CHOOSER(dialog), extra);
	gtk_widget_show_all(dialog);
}


dialog_about()
{
	GtkWidget *dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
	gtk_window_set_title(GTK_WINDOW(dialog), language[28]);
	gtk_container_set_border_width(GTK_CONTAINER(dialog), 10);

	GtkWidget *box = gtk_vbox_new(FALSE,5);

		GtkWidget *notebook = gtk_notebook_new();

			GtkWidget *splash_box = gtk_vbox_new(FALSE,5);

				GtkWidget *splash = gtk_image_new_from_file( strcatnew(PATH,"img/about.png") );
				GtkWidget *copyleft = gtk_label_new("Copyright © 2008-2009 Marcos Diaz Mencia");
				char version[100];
				sprintf(version, "%s (%s)", VERSION, SUBVERSION);
				GtkWidget *version_ = gtk_label_new(version);

				gtk_box_pack_start(GTK_BOX(splash_box),splash,FALSE,FALSE,0);
				gtk_box_pack_start(GTK_BOX(splash_box),copyleft,FALSE,FALSE,0);
				gtk_box_pack_start(GTK_BOX(splash_box),version_,FALSE,FALSE,0);
				entry_space(splash_box);

			GtkWidget *credits = gtk_scrolled_window_new(NULL, NULL);
				gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(credits), 1, 1);
					GtkWidget *credits_text = gtk_text_view_new();
					gtk_text_view_set_left_margin(GTK_TEXT_VIEW(credits_text), 8);
					gtk_text_view_set_editable(GTK_TEXT_VIEW(credits_text), 0);
					gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(credits_text), 2);
					GtkTextBuffer *credits_buffer = gtk_text_buffer_new(NULL);
					char *credits_file = file_to_str( strcatnew(PATH,"text/credits") );
					//mark(hash_basic(credits_file));
					//if(hash_basic(credits_file) != 1493126064) credits_file = "ERROR";
					gtk_text_buffer_set_text(credits_buffer, credits_file, -1);
					gtk_text_view_set_buffer(GTK_TEXT_VIEW(credits_text), credits_buffer);
				gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(credits), credits_text);

			GtkWidget *license = gtk_scrolled_window_new(NULL, NULL);
				gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(license), 1, 1);
					GtkWidget *license_text = gtk_text_view_new();
					gtk_text_view_set_left_margin(GTK_TEXT_VIEW(license_text), 8);
					gtk_text_view_set_editable(GTK_TEXT_VIEW(license_text), 0);
					gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(license_text), 2);
					GtkTextBuffer *license_buffer = gtk_text_buffer_new(NULL);
					char *license_file = file_to_str( strcatnew(PATH,"text/license") );
					if(hash_basic(license_file) != 1035571580) license_file = "ERROR";
					gtk_text_buffer_set_text(license_buffer, license_file, -1);
					gtk_text_view_set_buffer(GTK_TEXT_VIEW(license_text), license_buffer);
				gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(license), license_text);

			GtkWidget *buttons = gtk_hbox_new(FALSE,5);
				GtkWidget *close = gtk_button_new_from_stock("gtk-close");
				gtk_widget_set_size_request(close, DIALOG_BTN_WIDTH, -1);
				g_signal_connect(G_OBJECT(close), "clicked", G_CALLBACK(destroy), dialog);
				gtk_box_pack_end(GTK_BOX(buttons),close,FALSE,FALSE,0);

			gtk_box_pack_start(GTK_BOX(box),notebook,FALSE,FALSE,0);
			gtk_box_pack_start(GTK_BOX(box),buttons,FALSE,FALSE,0);

		gtk_notebook_append_page(GTK_NOTEBOOK(notebook), splash_box, gtk_label_new(language[28]));
		gtk_notebook_append_page(GTK_NOTEBOOK(notebook), credits, gtk_label_new(language[35]));
		gtk_notebook_append_page(GTK_NOTEBOOK(notebook), license, gtk_label_new(language[36]));

	gtk_container_add(GTK_CONTAINER(dialog), box);
	gtk_widget_show_all(dialog);
}
