/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


cursor_stock(GdkCursorType stock)
{
	GdkCursor *cursor = gdk_cursor_new(stock);
	gdk_window_set_cursor(win->window, cursor);
}


cursor_pixbuf(char *path)
{
	GdkDisplay *display = gdk_display_get_default();
	GdkPixbuf *pix = gdk_pixbuf_new_from_file(path, NULL);
	GdkCursor *cursor = gdk_cursor_new_from_pixbuf(display, pix, 0, 0);
	gdk_window_set_cursor(win->window, cursor);
}


cursor_none()
{
	GdkDisplay *display = gdk_display_get_default();
	GdkPixbuf *pix = pixbuf_new(NULL, 1, 1);
	GdkCursor *cursor = gdk_cursor_new_from_pixbuf(display, pix, 0, 0);
	gdk_window_set_cursor(win->window, cursor);
}


cursor_default()
{
	gdk_window_set_cursor(win->window, NULL);
}
