/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


color_update(char *seed)
{
	if(seed=="rgb" && !feedback_lock)
	{
		feedback_lock = 1;
		int *return_hsv = rgb_to_hsv(color1[0], color1[1], color1[2]);
		color1hsv[0] = return_hsv[0];
		color1hsv[1] = return_hsv[1];
		color1hsv[2] = return_hsv[2];
		free(return_hsv);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[3]), color1hsv[0]);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[4]), color1hsv[1]);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[5]), color1hsv[2]);
		if(GTK_IS_ENTRY(adj_color1hex))
		{
			color1hex = rgb_to_hex(color1[0], color1[1], color1[2]);
			gtk_entry_set_text(GTK_ENTRY(adj_color1hex), color1hex);
			free(color1hex);
		}
		feedback_lock = 0;
	}
	if(seed=="hsv" && !feedback_lock)
	{
		feedback_lock = 1;
		uchar *return_rgb = hsv_to_rgb(color1hsv[0], color1hsv[1], color1hsv[2]);
		color1[0] = return_rgb[0];
		color1[1] = return_rgb[1];
		color1[2] = return_rgb[2];
		free(return_rgb);
		if(main_load)
		{
			gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[0]), color1[0]);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[1]), color1[1]);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[2]), color1[2]);
		}
		if(GTK_IS_ENTRY(adj_color1hex))
		{
			color1hex = rgb_to_hex(color1[0], color1[1], color1[2]);
			gtk_entry_set_text(GTK_ENTRY(adj_color1hex), color1hex);
			free(color1hex);
		}
		feedback_lock = 0;
	}
	if(seed=="hex" && !feedback_lock)
	{
		feedback_lock = 1;
		color1hex = (char*)gtk_entry_get_text(GTK_ENTRY(adj_color1hex));
		uchar *rgb = hex_to_rgb(color1hex);
		color1[0] = rgb[0];
		color1[1] = rgb[1];
		color1[2] = rgb[2];

		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[0]), color1[0]);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[1]), color1[1]);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[2]), color1[2]);

		int *return_hsv = rgb_to_hsv(color1[0], color1[1], color1[2]);
		color1hsv[0] = return_hsv[0];
		color1hsv[1] = return_hsv[1];
		color1hsv[2] = return_hsv[2];
		free(return_hsv);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[3]), color1hsv[0]);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[4]), color1hsv[1]);
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[5]), color1hsv[2]);
		brush_new();
		feedback_lock = 0;
	}

	uchar *raw = toolbar_color1[0];
	GtkWidget *img = toolbar_color1[1];
	int w = *(int*)toolbar_color1[2];
	int h = *(int*)toolbar_color1[3];
	int x, y;
	for(y=0; y<h; y++)
	{
		for(x=0; x<w; x++)
		{
			int pos = pixel_pos(x, y, w);
			if(x!=0 && y!=0 && x!=w-1 && y!=h-1)
			{
				*(raw+pos+0) = color1[0];
				*(raw+pos+1) = color1[1];
				*(raw+pos+2) = color1[2];
				*(raw+pos+3) = 255;
			}
			else
			{
				*(raw+pos+0) = 0;
				*(raw+pos+1) = 0;
				*(raw+pos+2) = 0;
				*(raw+pos+3) = 255;
			}
		}
	}
	gtk_widget_queue_draw(img);
}


colorbar_select(GtkWidget *wid, GdkEventButton *event, uchar data[3])
{
	color1[0] = data[0];
	color1[1] = data[1];
	color1[2] = data[2];
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[0]), color1[0]);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[1]), color1[1]);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adj_color1_rgbhsv[2]), color1[2]);
}


colorbar_item(GtkWidget *colorbar, uchar r, uchar g, uchar b)
{
	GtkWidget *ebox = gtk_event_box_new();
	gtk_widget_set_size_request(ebox,20,-1);

	GdkColor *color = (GdkColor*)malloc(sizeof(GdkColor));
	color->red = (guint16)r * 256;
	color->green = (guint16)g * 256;
	color->blue = (guint16)b * 256;

	gtk_widget_modify_bg(ebox, GTK_STATE_NORMAL, color);

	uchar *data = (uchar*)malloc(3*sizeof(uchar));
	data[0] = r;
	data[1] = g;
	data[2] = b;
	g_signal_connect(G_OBJECT(ebox), "button-press-event", G_CALLBACK(colorbar_select), data);
	gtk_box_pack_start(GTK_BOX(colorbar),ebox,TRUE,TRUE,0);
}


void load_palette_from_xml(GtkWidget *palette_, char *path)
{
	char *xml = file_to_str(path);

	int colors = atoi( n_xml_get(xml, 2, "palette", "colors") );

	char colornn[7];
	int i;
	for(i=1; i<=colors; i++)
	{
		sprintf(colornn, "color%i", i);
		char *hex = n_xml_get(xml, 2, "palette", colornn);
		uchar *rgb = hex_to_rgb(hex);
		colorbar_item(palette_, rgb[0], rgb[1], rgb[2]);
		free(rgb);
	}
}
