/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


call_adj_uchar(GtkAdjustment *adj, uchar *value)
{
	*value = (uchar)gtk_adjustment_get_value(adj);
	if(value==&color1[0] || value==&color1[1] || value==&color1[2])	color_update("rgb");
	if(!feedback_lock) brush_new();
}

call_adj_int(GtkAdjustment *adj, int *value)
{
	*value = (int)gtk_adjustment_get_value(adj);
	if(value==&color1hsv[0] || value==&color1hsv[1] || value==&color1hsv[2]) color_update("hsv");
	if(!feedback_lock) brush_new();
	if(value==&dialog_new_pxw || value==&dialog_new_pxh) dialog_new_update("px");
	if(value==&dialog_new_dpi) dialog_new_update("dpi");
}


call_adj_double(GtkAdjustment *adj, double *value)
{
	*value = (double)gtk_adjustment_get_value(adj);
	if(value==&dialog_new_cmw || value==&dialog_new_cmh) dialog_new_update("cm");
	if(value==&dialog_new_inw || value==&dialog_new_inh) dialog_new_update("in");
}


call_combo(GtkComboBox *combo, int *value)
{
	*value = gtk_combo_box_get_active(combo);
	if(value==&dialog_new_template)	dialog_new_template_load();
	if(value==&dialog_new_unit)	dialog_new_smartshow();
}


call_check(GtkToggleButton *check, int *value)
{
	*value =  gtk_toggle_button_get_active(check);
}


call_radio(GtkComboBox *combo, int *data[])
{
	*data[0] = *data[1];
	if(data[0] == &tool) fixed_show();
}


call_menu(GtkWidget *widget, GtkMenu *menu, GdkEvent *event)
{
	GdkEventButton *event_button = (GdkEventButton*) event;
	gtk_menu_popup(menu, NULL, NULL, NULL, NULL, event_button->button, event_button->time);
}


call_spinmenu(int *data[])
{
	*data[0] = *data[1];

	if(
		data[0]==&dialog_new_pxw_ops || data[0]==&dialog_new_pxh_ops ||
		data[0]==&dialog_new_cmw_ops || data[0]==&dialog_new_cmh_ops ||
		data[0]==&dialog_new_inw_ops || data[0]==&dialog_new_inh_ops
	)
	{
		if(*data[1]==0) dialog_new_rotate();
		if(*data[1]==1) dialog_new_porcent(0.50);
		if(*data[1]==2) dialog_new_porcent(2.00);
	}

	if(data[0] == &dialog_new_dpi_ops) dialog_new_dpi_load();
}


call_function(GtkWidget *wid, char *call)
{
	if(call=="brushNew") brush_new();
	else if(call=="dialog_new") dialog_new();
	else if(call=="dialog_open") dialog_open();
	else if(call=="dialog_about") dialog_about();
	else if(call=="clear_color") clear_color();
	else if(call=="clear_brush") clear_brush();
	else if(call=="clear_new") clear_new();
	else if(call=="window_fullscreen") window_fullscreen();
	else if(call=="sidebar_hide") sidebar_hide();
	else if(call=="hex_entry") color_update("hex");
	else if(call=="url_website") system("x-www-browser http://www.nathive.org");

	else printf("ERROR: call_function: Not match found\n");
}
